
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPainter.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPainter_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPainter

//  Constructor QPainter::QPainter()


static void _init_ctor_QPainter_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPainter *> ();
}

static void _call_ctor_QPainter_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainter *> (new QPainter ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPainter_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPainter::QPainter()\nThis method creates an object of class QPainter.", &_init_ctor_QPainter_0, &_call_ctor_QPainter_0);
}

//  Constructor QPainter::QPainter(QPaintDevice *)


static void _init_ctor_QPainter_1803 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return_new<QPainter *> ();
}

static void _call_ctor_QPainter_1803 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintDevice *arg1 = args.read<QPaintDevice * > ();
  ret.write<QPainter *> (new QPainter (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPainter_1803 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPainter::QPainter(QPaintDevice *)\nThis method creates an object of class QPainter.", &_init_ctor_QPainter_1803, &_call_ctor_QPainter_1803);
}

// const QBrush &QPainter::background()


static void _init_f_background_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_background_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPainter *)cls)->background ());
}

static qt_gsi::GenericMethod *_create_f_background_c0 ()
{
  return new qt_gsi::GenericMethod (":background", "@brief Method const QBrush &QPainter::background()\n", true, &_init_f_background_c0, &_call_f_background_c0);
}

// Qt::BGMode QPainter::backgroundMode()


static void _init_f_backgroundMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::BGMode>::target_type > ();
}

static void _call_f_backgroundMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::BGMode>::target_type > ((qt_gsi::Converter<Qt::BGMode>::target_type)qt_gsi::CppToQtAdaptor<Qt::BGMode>(((QPainter *)cls)->backgroundMode ()));
}

static qt_gsi::GenericMethod *_create_f_backgroundMode_c0 ()
{
  return new qt_gsi::GenericMethod (":backgroundMode", "@brief Method Qt::BGMode QPainter::backgroundMode()\n", true, &_init_f_backgroundMode_c0, &_call_f_backgroundMode_c0);
}

// bool QPainter::begin(QPaintDevice *)


static void _init_f_begin_1803 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_begin_1803 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintDevice *arg1 = args.read<QPaintDevice * > ();
  ret.write<bool > ((bool)((QPainter *)cls)->begin (arg1));
}

static qt_gsi::GenericMethod *_create_f_begin_1803 ()
{
  return new qt_gsi::GenericMethod ("begin", "@brief Method bool QPainter::begin(QPaintDevice *)\n", false, &_init_f_begin_1803, &_call_f_begin_1803);
}

// void QPainter::beginNativePainting()


static void _init_f_beginNativePainting_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_beginNativePainting_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPainter *)cls)->beginNativePainting ();
}

static qt_gsi::GenericMethod *_create_f_beginNativePainting_0 ()
{
  return new qt_gsi::GenericMethod ("beginNativePainting", "@brief Method void QPainter::beginNativePainting()\n", false, &_init_f_beginNativePainting_0, &_call_f_beginNativePainting_0);
}

// QRectF QPainter::boundingRect(const QRectF &rect, int flags, const QString &text)


static void _init_f_boundingRect_4438 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_4438 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  int arg2 = args.read<int > ();
  const QString &arg3 = args.read<const QString & > ();
  ret.write<QRectF > ((QRectF)((QPainter *)cls)->boundingRect (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_boundingRect_4438 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QPainter::boundingRect(const QRectF &rect, int flags, const QString &text)\n", false, &_init_f_boundingRect_4438, &_call_f_boundingRect_4438);
}

// QRect QPainter::boundingRect(const QRect &rect, int flags, const QString &text)


static void _init_f_boundingRect_4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_boundingRect_4368 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  int arg2 = args.read<int > ();
  const QString &arg3 = args.read<const QString & > ();
  ret.write<QRect > ((QRect)((QPainter *)cls)->boundingRect (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_boundingRect_4368 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRect QPainter::boundingRect(const QRect &rect, int flags, const QString &text)\n", false, &_init_f_boundingRect_4368, &_call_f_boundingRect_4368);
}

// QRect QPainter::boundingRect(int x, int y, int w, int h, int flags, const QString &text)


static void _init_f_boundingRect_5320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  decl->set_return<QRect > ();
}

static void _call_f_boundingRect_5320 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  int arg5 = args.read<int > ();
  const QString &arg6 = args.read<const QString & > ();
  ret.write<QRect > ((QRect)((QPainter *)cls)->boundingRect (arg1, arg2, arg3, arg4, arg5, arg6));
}

static qt_gsi::GenericMethod *_create_f_boundingRect_5320 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRect QPainter::boundingRect(int x, int y, int w, int h, int flags, const QString &text)\n", false, &_init_f_boundingRect_5320, &_call_f_boundingRect_5320);
}

// QRectF QPainter::boundingRect(const QRectF &rect, const QString &text, const QTextOption &o)


static void _init_f_boundingRect_6119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("o", true, "QTextOption()");
  decl->add_arg<const QTextOption & > (argspec_2);
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_6119 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QString &arg2 = args.read<const QString & > ();
  const QTextOption &arg3 = args ? args.read<const QTextOption & > () : (const QTextOption &)(QTextOption());
  ret.write<QRectF > ((QRectF)((QPainter *)cls)->boundingRect (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_boundingRect_6119 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QPainter::boundingRect(const QRectF &rect, const QString &text, const QTextOption &o)\n", false, &_init_f_boundingRect_6119, &_call_f_boundingRect_6119);
}

// const QBrush &QPainter::brush()


static void _init_f_brush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_brush_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPainter *)cls)->brush ());
}

static qt_gsi::GenericMethod *_create_f_brush_c0 ()
{
  return new qt_gsi::GenericMethod (":brush", "@brief Method const QBrush &QPainter::brush()\n", true, &_init_f_brush_c0, &_call_f_brush_c0);
}

// QPoint QPainter::brushOrigin()


static void _init_f_brushOrigin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_brushOrigin_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QPainter *)cls)->brushOrigin ());
}

static qt_gsi::GenericMethod *_create_f_brushOrigin_c0 ()
{
  return new qt_gsi::GenericMethod (":brushOrigin", "@brief Method QPoint QPainter::brushOrigin()\n", true, &_init_f_brushOrigin_c0, &_call_f_brushOrigin_c0);
}

// QPainterPath QPainter::clipPath()


static void _init_f_clipPath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_clipPath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QPainter *)cls)->clipPath ());
}

static qt_gsi::GenericMethod *_create_f_clipPath_c0 ()
{
  return new qt_gsi::GenericMethod (":clipPath", "@brief Method QPainterPath QPainter::clipPath()\n", true, &_init_f_clipPath_c0, &_call_f_clipPath_c0);
}

// QRegion QPainter::clipRegion()


static void _init_f_clipRegion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_clipRegion_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRegion > ((QRegion)((QPainter *)cls)->clipRegion ());
}

static qt_gsi::GenericMethod *_create_f_clipRegion_c0 ()
{
  return new qt_gsi::GenericMethod (":clipRegion", "@brief Method QRegion QPainter::clipRegion()\n", true, &_init_f_clipRegion_c0, &_call_f_clipRegion_c0);
}

// QMatrix QPainter::combinedMatrix()


static void _init_f_combinedMatrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMatrix > ();
}

static void _call_f_combinedMatrix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMatrix > ((QMatrix)((QPainter *)cls)->combinedMatrix ());
}

static qt_gsi::GenericMethod *_create_f_combinedMatrix_c0 ()
{
  return new qt_gsi::GenericMethod ("combinedMatrix", "@brief Method QMatrix QPainter::combinedMatrix()\n", true, &_init_f_combinedMatrix_c0, &_call_f_combinedMatrix_c0);
}

// QTransform QPainter::combinedTransform()


static void _init_f_combinedTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_combinedTransform_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTransform > ((QTransform)((QPainter *)cls)->combinedTransform ());
}

static qt_gsi::GenericMethod *_create_f_combinedTransform_c0 ()
{
  return new qt_gsi::GenericMethod ("combinedTransform", "@brief Method QTransform QPainter::combinedTransform()\n", true, &_init_f_combinedTransform_c0, &_call_f_combinedTransform_c0);
}

// QPainter::CompositionMode QPainter::compositionMode()


static void _init_f_compositionMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPainter::CompositionMode>::target_type > ();
}

static void _call_f_compositionMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPainter::CompositionMode>::target_type > ((qt_gsi::Converter<QPainter::CompositionMode>::target_type)qt_gsi::CppToQtAdaptor<QPainter::CompositionMode>(((QPainter *)cls)->compositionMode ()));
}

static qt_gsi::GenericMethod *_create_f_compositionMode_c0 ()
{
  return new qt_gsi::GenericMethod (":compositionMode", "@brief Method QPainter::CompositionMode QPainter::compositionMode()\n", true, &_init_f_compositionMode_c0, &_call_f_compositionMode_c0);
}

// QPaintDevice *QPainter::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintDevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintDevice * > ((QPaintDevice *)((QPainter *)cls)->device ());
}

static qt_gsi::GenericMethod *_create_f_device_c0 ()
{
  return new qt_gsi::GenericMethod ("device", "@brief Method QPaintDevice *QPainter::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
}

// const QMatrix &QPainter::deviceMatrix()


static void _init_f_deviceMatrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMatrix & > ();
}

static void _call_f_deviceMatrix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMatrix & > ((const QMatrix &)((QPainter *)cls)->deviceMatrix ());
}

static qt_gsi::GenericMethod *_create_f_deviceMatrix_c0 ()
{
  return new qt_gsi::GenericMethod ("deviceMatrix", "@brief Method const QMatrix &QPainter::deviceMatrix()\n", true, &_init_f_deviceMatrix_c0, &_call_f_deviceMatrix_c0);
}

// const QTransform &QPainter::deviceTransform()


static void _init_f_deviceTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QTransform & > ();
}

static void _call_f_deviceTransform_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QTransform & > ((const QTransform &)((QPainter *)cls)->deviceTransform ());
}

static qt_gsi::GenericMethod *_create_f_deviceTransform_c0 ()
{
  return new qt_gsi::GenericMethod ("deviceTransform", "@brief Method const QTransform &QPainter::deviceTransform()\n", true, &_init_f_deviceTransform_c0, &_call_f_deviceTransform_c0);
}

// void QPainter::drawArc(const QRectF &rect, int a, int alen)


static void _init_f_drawArc_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawArc_3180 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPainter *)cls)->drawArc (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawArc_3180 ()
{
  return new qt_gsi::GenericMethod ("drawArc", "@brief Method void QPainter::drawArc(const QRectF &rect, int a, int alen)\n", false, &_init_f_drawArc_3180, &_call_f_drawArc_3180);
}

// void QPainter::drawArc(const QRect &, int a, int alen)


static void _init_f_drawArc_3110 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawArc_3110 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPainter *)cls)->drawArc (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawArc_3110 ()
{
  return new qt_gsi::GenericMethod ("drawArc", "@brief Method void QPainter::drawArc(const QRect &, int a, int alen)\n", false, &_init_f_drawArc_3110, &_call_f_drawArc_3110);
}

// void QPainter::drawArc(int x, int y, int w, int h, int a, int alen)


static void _init_f_drawArc_4062 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("alen");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_drawArc_4062 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  int arg5 = args.read<int > ();
  int arg6 = args.read<int > ();
  ((QPainter *)cls)->drawArc (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_drawArc_4062 ()
{
  return new qt_gsi::GenericMethod ("drawArc", "@brief Method void QPainter::drawArc(int x, int y, int w, int h, int a, int alen)\n", false, &_init_f_drawArc_4062, &_call_f_drawArc_4062);
}

// void QPainter::drawChord(const QRectF &rect, int a, int alen)


static void _init_f_drawChord_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawChord_3180 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPainter *)cls)->drawChord (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawChord_3180 ()
{
  return new qt_gsi::GenericMethod ("drawChord", "@brief Method void QPainter::drawChord(const QRectF &rect, int a, int alen)\n", false, &_init_f_drawChord_3180, &_call_f_drawChord_3180);
}

// void QPainter::drawChord(int x, int y, int w, int h, int a, int alen)


static void _init_f_drawChord_4062 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("alen");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_drawChord_4062 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  int arg5 = args.read<int > ();
  int arg6 = args.read<int > ();
  ((QPainter *)cls)->drawChord (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_drawChord_4062 ()
{
  return new qt_gsi::GenericMethod ("drawChord", "@brief Method void QPainter::drawChord(int x, int y, int w, int h, int a, int alen)\n", false, &_init_f_drawChord_4062, &_call_f_drawChord_4062);
}

// void QPainter::drawChord(const QRect &, int a, int alen)


static void _init_f_drawChord_3110 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawChord_3110 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPainter *)cls)->drawChord (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawChord_3110 ()
{
  return new qt_gsi::GenericMethod ("drawChord", "@brief Method void QPainter::drawChord(const QRect &, int a, int alen)\n", false, &_init_f_drawChord_3110, &_call_f_drawChord_3110);
}

// void QPainter::drawConvexPolygon(const QPolygonF &polygon)


static void _init_f_drawConvexPolygon_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawConvexPolygon_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  ((QPainter *)cls)->drawConvexPolygon (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawConvexPolygon_2208 ()
{
  return new qt_gsi::GenericMethod ("drawConvexPolygon", "@brief Method void QPainter::drawConvexPolygon(const QPolygonF &polygon)\n", false, &_init_f_drawConvexPolygon_2208, &_call_f_drawConvexPolygon_2208);
}

// void QPainter::drawConvexPolygon(const QPolygon &polygon)


static void _init_f_drawConvexPolygon_2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawConvexPolygon_2138 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  ((QPainter *)cls)->drawConvexPolygon (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawConvexPolygon_2138 ()
{
  return new qt_gsi::GenericMethod ("drawConvexPolygon", "@brief Method void QPainter::drawConvexPolygon(const QPolygon &polygon)\n", false, &_init_f_drawConvexPolygon_2138, &_call_f_drawConvexPolygon_2138);
}

// void QPainter::drawEllipse(const QRectF &r)


static void _init_f_drawEllipse_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QPainter *)cls)->drawEllipse (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawEllipse_1862 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPainter::drawEllipse(const QRectF &r)\n", false, &_init_f_drawEllipse_1862, &_call_f_drawEllipse_1862);
}

// void QPainter::drawEllipse(const QRect &r)


static void _init_f_drawEllipse_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QPainter *)cls)->drawEllipse (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawEllipse_1792 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPainter::drawEllipse(const QRect &r)\n", false, &_init_f_drawEllipse_1792, &_call_f_drawEllipse_1792);
}

// void QPainter::drawEllipse(int x, int y, int w, int h)


static void _init_f_drawEllipse_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QPainter *)cls)->drawEllipse (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawEllipse_2744 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPainter::drawEllipse(int x, int y, int w, int h)\n", false, &_init_f_drawEllipse_2744, &_call_f_drawEllipse_2744);
}

// void QPainter::drawEllipse(const QPointF &center, double rx, double ry)


static void _init_f_drawEllipse_3912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("center");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rx");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ry");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_3912 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ((QPainter *)cls)->drawEllipse (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawEllipse_3912 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPainter::drawEllipse(const QPointF &center, double rx, double ry)\n", false, &_init_f_drawEllipse_3912, &_call_f_drawEllipse_3912);
}

// void QPainter::drawEllipse(const QPoint &center, int rx, int ry)


static void _init_f_drawEllipse_3234 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("center");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rx");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ry");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_3234 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPainter *)cls)->drawEllipse (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawEllipse_3234 ()
{
  return new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPainter::drawEllipse(const QPoint &center, int rx, int ry)\n", false, &_init_f_drawEllipse_3234, &_call_f_drawEllipse_3234);
}

// void QPainter::drawImage(const QRectF &targetRect, const QImage &image, const QRectF &sourceRect, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_8645 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("targetRect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawImage_8645 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QImage &arg2 = args.read<const QImage & > ();
  const QRectF &arg3 = args.read<const QRectF & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ((QPainter *)cls)->drawImage (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_drawImage_8645 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QRectF &targetRect, const QImage &image, const QRectF &sourceRect, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_8645, &_call_f_drawImage_8645);
}

// void QPainter::drawImage(const QRect &targetRect, const QImage &image, const QRect &sourceRect, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_8505 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("targetRect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRect");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawImage_8505 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const QImage &arg2 = args.read<const QImage & > ();
  const QRect &arg3 = args.read<const QRect & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ((QPainter *)cls)->drawImage (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_drawImage_8505 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QRect &targetRect, const QImage &image, const QRect &sourceRect, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_8505, &_call_f_drawImage_8505);
}

// void QPainter::drawImage(const QPointF &p, const QImage &image, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_8769 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawImage_8769 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QImage &arg2 = args.read<const QImage & > ();
  const QRectF &arg3 = args.read<const QRectF & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ((QPainter *)cls)->drawImage (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_drawImage_8769 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QPointF &p, const QImage &image, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_8769, &_call_f_drawImage_8769);
}

// void QPainter::drawImage(const QPoint &p, const QImage &image, const QRect &sr, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_8629 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawImage_8629 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const QImage &arg2 = args.read<const QImage & > ();
  const QRect &arg3 = args.read<const QRect & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ((QPainter *)cls)->drawImage (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_drawImage_8629 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QPoint &p, const QImage &image, const QRect &sr, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_8629, &_call_f_drawImage_8629);
}

// void QPainter::drawImage(const QRectF &r, const QImage &image)


static void _init_f_drawImage_3631 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawImage_3631 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QImage &arg2 = args.read<const QImage & > ();
  ((QPainter *)cls)->drawImage (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawImage_3631 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QRectF &r, const QImage &image)\n", false, &_init_f_drawImage_3631, &_call_f_drawImage_3631);
}

// void QPainter::drawImage(const QRect &r, const QImage &image)


static void _init_f_drawImage_3561 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawImage_3561 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const QImage &arg2 = args.read<const QImage & > ();
  ((QPainter *)cls)->drawImage (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawImage_3561 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QRect &r, const QImage &image)\n", false, &_init_f_drawImage_3561, &_call_f_drawImage_3561);
}

// void QPainter::drawImage(const QPointF &p, const QImage &image)


static void _init_f_drawImage_3755 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawImage_3755 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QImage &arg2 = args.read<const QImage & > ();
  ((QPainter *)cls)->drawImage (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawImage_3755 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QPointF &p, const QImage &image)\n", false, &_init_f_drawImage_3755, &_call_f_drawImage_3755);
}

// void QPainter::drawImage(const QPoint &p, const QImage &image)


static void _init_f_drawImage_3685 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawImage_3685 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const QImage &arg2 = args.read<const QImage & > ();
  ((QPainter *)cls)->drawImage (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawImage_3685 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(const QPoint &p, const QImage &image)\n", false, &_init_f_drawImage_3685, &_call_f_drawImage_3685);
}

// void QPainter::drawImage(int x, int y, const QImage &image, int sx, int sy, int sw, int sh, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_9091 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("image");
  decl->add_arg<const QImage & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("sx", true, "0");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("sy", true, "0");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("sw", true, "-1");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("sh", true, "-1");
  decl->add_arg<int > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_7);
  decl->set_return<void > ();
}

static void _call_f_drawImage_9091 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QImage &arg3 = args.read<const QImage & > ();
  int arg4 = args ? args.read<int > () : (int)(0);
  int arg5 = args ? args.read<int > () : (int)(0);
  int arg6 = args ? args.read<int > () : (int)(-1);
  int arg7 = args ? args.read<int > () : (int)(-1);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg8 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ((QPainter *)cls)->drawImage (arg1, arg2, arg3, arg4, arg5, arg6, arg7, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg8).cref());
}

static qt_gsi::GenericMethod *_create_f_drawImage_9091 ()
{
  return new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPainter::drawImage(int x, int y, const QImage &image, int sx, int sy, int sw, int sh, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_9091, &_call_f_drawImage_9091);
}

// void QPainter::drawLine(const QLineF &line)


static void _init_f_drawLine_1856 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("line");
  decl->add_arg<const QLineF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLine_1856 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLineF &arg1 = args.read<const QLineF & > ();
  ((QPainter *)cls)->drawLine (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawLine_1856 ()
{
  return new qt_gsi::GenericMethod ("drawLine", "@brief Method void QPainter::drawLine(const QLineF &line)\n", false, &_init_f_drawLine_1856, &_call_f_drawLine_1856);
}

// void QPainter::drawLine(const QLine &line)


static void _init_f_drawLine_1786 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("line");
  decl->add_arg<const QLine & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLine_1786 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLine &arg1 = args.read<const QLine & > ();
  ((QPainter *)cls)->drawLine (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawLine_1786 ()
{
  return new qt_gsi::GenericMethod ("drawLine", "@brief Method void QPainter::drawLine(const QLine &line)\n", false, &_init_f_drawLine_1786, &_call_f_drawLine_1786);
}

// void QPainter::drawLine(int x1, int y1, int x2, int y2)


static void _init_f_drawLine_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawLine_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QPainter *)cls)->drawLine (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawLine_2744 ()
{
  return new qt_gsi::GenericMethod ("drawLine", "@brief Method void QPainter::drawLine(int x1, int y1, int x2, int y2)\n", false, &_init_f_drawLine_2744, &_call_f_drawLine_2744);
}

// void QPainter::drawLine(const QPoint &p1, const QPoint &p2)


static void _init_f_drawLine_3724 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p1");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("p2");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawLine_3724 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const QPoint &arg2 = args.read<const QPoint & > ();
  ((QPainter *)cls)->drawLine (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawLine_3724 ()
{
  return new qt_gsi::GenericMethod ("drawLine", "@brief Method void QPainter::drawLine(const QPoint &p1, const QPoint &p2)\n", false, &_init_f_drawLine_3724, &_call_f_drawLine_3724);
}

// void QPainter::drawLine(const QPointF &p1, const QPointF &p2)


static void _init_f_drawLine_3864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p1");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("p2");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawLine_3864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  ((QPainter *)cls)->drawLine (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawLine_3864 ()
{
  return new qt_gsi::GenericMethod ("drawLine", "@brief Method void QPainter::drawLine(const QPointF &p1, const QPointF &p2)\n", false, &_init_f_drawLine_3864, &_call_f_drawLine_3864);
}

// void QPainter::drawLines(const QVector<QLineF> &lines)


static void _init_f_drawLines_2686 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lines");
  decl->add_arg<const qt_gsi::Converter<QVector<QLineF> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLines_2686 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVector<QLineF> >::target_type & arg1 = args.read<const qt_gsi::Converter<QVector<QLineF> >::target_type & > ();
  ((QPainter *)cls)->drawLines (qt_gsi::QtToCppAdaptor<QVector<QLineF> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_drawLines_2686 ()
{
  return new qt_gsi::GenericMethod ("drawLines_f", "@brief Method void QPainter::drawLines(const QVector<QLineF> &lines)\n", false, &_init_f_drawLines_2686, &_call_f_drawLines_2686);
}

// void QPainter::drawLines(const QVector<QPointF> &pointPairs)


static void _init_f_drawLines_2816 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pointPairs");
  decl->add_arg<const qt_gsi::Converter<QVector<QPointF> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLines_2816 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVector<QPointF> >::target_type & arg1 = args.read<const qt_gsi::Converter<QVector<QPointF> >::target_type & > ();
  ((QPainter *)cls)->drawLines (qt_gsi::QtToCppAdaptor<QVector<QPointF> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_drawLines_2816 ()
{
  return new qt_gsi::GenericMethod ("drawLines_fp", "@brief Method void QPainter::drawLines(const QVector<QPointF> &pointPairs)\n", false, &_init_f_drawLines_2816, &_call_f_drawLines_2816);
}

// void QPainter::drawLines(const QVector<QLine> &lines)


static void _init_f_drawLines_2616 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lines");
  decl->add_arg<const qt_gsi::Converter<QVector<QLine> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLines_2616 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVector<QLine> >::target_type & arg1 = args.read<const qt_gsi::Converter<QVector<QLine> >::target_type & > ();
  ((QPainter *)cls)->drawLines (qt_gsi::QtToCppAdaptor<QVector<QLine> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_drawLines_2616 ()
{
  return new qt_gsi::GenericMethod ("drawLines_i", "@brief Method void QPainter::drawLines(const QVector<QLine> &lines)\n", false, &_init_f_drawLines_2616, &_call_f_drawLines_2616);
}

// void QPainter::drawLines(const QVector<QPoint> &pointPairs)


static void _init_f_drawLines_2746 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pointPairs");
  decl->add_arg<const qt_gsi::Converter<QVector<QPoint> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawLines_2746 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVector<QPoint> >::target_type & arg1 = args.read<const qt_gsi::Converter<QVector<QPoint> >::target_type & > ();
  ((QPainter *)cls)->drawLines (qt_gsi::QtToCppAdaptor<QVector<QPoint> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_drawLines_2746 ()
{
  return new qt_gsi::GenericMethod ("drawLines_ip", "@brief Method void QPainter::drawLines(const QVector<QPoint> &pointPairs)\n", false, &_init_f_drawLines_2746, &_call_f_drawLines_2746);
}

// void QPainter::drawPath(const QPainterPath &path)


static void _init_f_drawPath_2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPath_2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ((QPainter *)cls)->drawPath (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawPath_2514 ()
{
  return new qt_gsi::GenericMethod ("drawPath", "@brief Method void QPainter::drawPath(const QPainterPath &path)\n", false, &_init_f_drawPath_2514, &_call_f_drawPath_2514);
}

// void QPainter::drawPicture(const QPointF &p, const QPicture &picture)


static void _init_f_drawPicture_4004 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("picture");
  decl->add_arg<const QPicture & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPicture_4004 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QPicture &arg2 = args.read<const QPicture & > ();
  ((QPainter *)cls)->drawPicture (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawPicture_4004 ()
{
  return new qt_gsi::GenericMethod ("drawPicture", "@brief Method void QPainter::drawPicture(const QPointF &p, const QPicture &picture)\n", false, &_init_f_drawPicture_4004, &_call_f_drawPicture_4004);
}

// void QPainter::drawPicture(int x, int y, const QPicture &picture)


static void _init_f_drawPicture_3444 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("picture");
  decl->add_arg<const QPicture & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPicture_3444 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QPicture &arg3 = args.read<const QPicture & > ();
  ((QPainter *)cls)->drawPicture (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawPicture_3444 ()
{
  return new qt_gsi::GenericMethod ("drawPicture", "@brief Method void QPainter::drawPicture(int x, int y, const QPicture &picture)\n", false, &_init_f_drawPicture_3444, &_call_f_drawPicture_3444);
}

// void QPainter::drawPicture(const QPoint &p, const QPicture &picture)


static void _init_f_drawPicture_3934 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("picture");
  decl->add_arg<const QPicture & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPicture_3934 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const QPicture &arg2 = args.read<const QPicture & > ();
  ((QPainter *)cls)->drawPicture (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawPicture_3934 ()
{
  return new qt_gsi::GenericMethod ("drawPicture", "@brief Method void QPainter::drawPicture(const QPoint &p, const QPicture &picture)\n", false, &_init_f_drawPicture_3934, &_call_f_drawPicture_3934);
}

// void QPainter::drawPie(const QRectF &rect, int a, int alen)


static void _init_f_drawPie_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPie_3180 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPainter *)cls)->drawPie (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawPie_3180 ()
{
  return new qt_gsi::GenericMethod ("drawPie", "@brief Method void QPainter::drawPie(const QRectF &rect, int a, int alen)\n", false, &_init_f_drawPie_3180, &_call_f_drawPie_3180);
}

// void QPainter::drawPie(int x, int y, int w, int h, int a, int alen)


static void _init_f_drawPie_4062 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("a");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("alen");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_drawPie_4062 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  int arg5 = args.read<int > ();
  int arg6 = args.read<int > ();
  ((QPainter *)cls)->drawPie (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_drawPie_4062 ()
{
  return new qt_gsi::GenericMethod ("drawPie", "@brief Method void QPainter::drawPie(int x, int y, int w, int h, int a, int alen)\n", false, &_init_f_drawPie_4062, &_call_f_drawPie_4062);
}

// void QPainter::drawPie(const QRect &, int a, int alen)


static void _init_f_drawPie_3110 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("a");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alen");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPie_3110 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPainter *)cls)->drawPie (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawPie_3110 ()
{
  return new qt_gsi::GenericMethod ("drawPie", "@brief Method void QPainter::drawPie(const QRect &, int a, int alen)\n", false, &_init_f_drawPie_3110, &_call_f_drawPie_3110);
}

// void QPainter::drawPixmap(const QRectF &targetRect, const QPixmap &pixmap, const QRectF &sourceRect)


static void _init_f_drawPixmap_5525 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("targetRect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5525 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QRectF &arg3 = args.read<const QRectF & > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_5525 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QRectF &targetRect, const QPixmap &pixmap, const QRectF &sourceRect)\n", false, &_init_f_drawPixmap_5525, &_call_f_drawPixmap_5525);
}

// void QPainter::drawPixmap(const QRect &targetRect, const QPixmap &pixmap, const QRect &sourceRect)


static void _init_f_drawPixmap_5385 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("targetRect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRect");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5385 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QRect &arg3 = args.read<const QRect & > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_5385 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QRect &targetRect, const QPixmap &pixmap, const QRect &sourceRect)\n", false, &_init_f_drawPixmap_5385, &_call_f_drawPixmap_5385);
}

// void QPainter::drawPixmap(int x, int y, int w, int h, const QPixmap &pm, int sx, int sy, int sw, int sh)


static void _init_f_drawPixmap_7289 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("pm");
  decl->add_arg<const QPixmap & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("sx");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("sy");
  decl->add_arg<int > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("sw");
  decl->add_arg<int > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("sh");
  decl->add_arg<int > (argspec_8);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_7289 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QPixmap &arg5 = args.read<const QPixmap & > ();
  int arg6 = args.read<int > ();
  int arg7 = args.read<int > ();
  int arg8 = args.read<int > ();
  int arg9 = args.read<int > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_7289 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(int x, int y, int w, int h, const QPixmap &pm, int sx, int sy, int sw, int sh)\n", false, &_init_f_drawPixmap_7289, &_call_f_drawPixmap_7289);
}

// void QPainter::drawPixmap(int x, int y, const QPixmap &pm, int sx, int sy, int sw, int sh)


static void _init_f_drawPixmap_5971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pm");
  decl->add_arg<const QPixmap & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("sx");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("sy");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("sw");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("sh");
  decl->add_arg<int > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5971 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QPixmap &arg3 = args.read<const QPixmap & > ();
  int arg4 = args.read<int > ();
  int arg5 = args.read<int > ();
  int arg6 = args.read<int > ();
  int arg7 = args.read<int > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_5971 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(int x, int y, const QPixmap &pm, int sx, int sy, int sw, int sh)\n", false, &_init_f_drawPixmap_5971, &_call_f_drawPixmap_5971);
}

// void QPainter::drawPixmap(const QPointF &p, const QPixmap &pm, const QRectF &sr)


static void _init_f_drawPixmap_5649 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5649 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QRectF &arg3 = args.read<const QRectF & > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_5649 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QPointF &p, const QPixmap &pm, const QRectF &sr)\n", false, &_init_f_drawPixmap_5649, &_call_f_drawPixmap_5649);
}

// void QPainter::drawPixmap(const QPoint &p, const QPixmap &pm, const QRect &sr)


static void _init_f_drawPixmap_5509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5509 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QRect &arg3 = args.read<const QRect & > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_5509 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QPoint &p, const QPixmap &pm, const QRect &sr)\n", false, &_init_f_drawPixmap_5509, &_call_f_drawPixmap_5509);
}

// void QPainter::drawPixmap(const QPointF &p, const QPixmap &pm)


static void _init_f_drawPixmap_3895 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_3895 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_3895 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QPointF &p, const QPixmap &pm)\n", false, &_init_f_drawPixmap_3895, &_call_f_drawPixmap_3895);
}

// void QPainter::drawPixmap(const QPoint &p, const QPixmap &pm)


static void _init_f_drawPixmap_3825 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_3825 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_3825 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QPoint &p, const QPixmap &pm)\n", false, &_init_f_drawPixmap_3825, &_call_f_drawPixmap_3825);
}

// void QPainter::drawPixmap(int x, int y, const QPixmap &pm)


static void _init_f_drawPixmap_3335 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pm");
  decl->add_arg<const QPixmap & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_3335 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QPixmap &arg3 = args.read<const QPixmap & > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_3335 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(int x, int y, const QPixmap &pm)\n", false, &_init_f_drawPixmap_3335, &_call_f_drawPixmap_3335);
}

// void QPainter::drawPixmap(const QRect &r, const QPixmap &pm)


static void _init_f_drawPixmap_3701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_3701 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_3701 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(const QRect &r, const QPixmap &pm)\n", false, &_init_f_drawPixmap_3701, &_call_f_drawPixmap_3701);
}

// void QPainter::drawPixmap(int x, int y, int w, int h, const QPixmap &pm)


static void _init_f_drawPixmap_4653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("pm");
  decl->add_arg<const QPixmap & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_4653 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QPixmap &arg5 = args.read<const QPixmap & > ();
  ((QPainter *)cls)->drawPixmap (arg1, arg2, arg3, arg4, arg5);
}

static qt_gsi::GenericMethod *_create_f_drawPixmap_4653 ()
{
  return new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPainter::drawPixmap(int x, int y, int w, int h, const QPixmap &pm)\n", false, &_init_f_drawPixmap_4653, &_call_f_drawPixmap_4653);
}

// void QPainter::drawPoint(const QPointF &pt)


static void _init_f_drawPoint_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPoint_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QPainter *)cls)->drawPoint (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawPoint_1986 ()
{
  return new qt_gsi::GenericMethod ("drawPoint", "@brief Method void QPainter::drawPoint(const QPointF &pt)\n", false, &_init_f_drawPoint_1986, &_call_f_drawPoint_1986);
}

// void QPainter::drawPoint(const QPoint &p)


static void _init_f_drawPoint_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPoint_1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ((QPainter *)cls)->drawPoint (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawPoint_1916 ()
{
  return new qt_gsi::GenericMethod ("drawPoint", "@brief Method void QPainter::drawPoint(const QPoint &p)\n", false, &_init_f_drawPoint_1916, &_call_f_drawPoint_1916);
}

// void QPainter::drawPoint(int x, int y)


static void _init_f_drawPoint_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPoint_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QPainter *)cls)->drawPoint (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawPoint_1426 ()
{
  return new qt_gsi::GenericMethod ("drawPoint", "@brief Method void QPainter::drawPoint(int x, int y)\n", false, &_init_f_drawPoint_1426, &_call_f_drawPoint_1426);
}

// void QPainter::drawPoints(const QPolygonF &points)


static void _init_f_drawPoints_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("points");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPoints_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  ((QPainter *)cls)->drawPoints (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawPoints_2208 ()
{
  return new qt_gsi::GenericMethod ("drawPoints", "@brief Method void QPainter::drawPoints(const QPolygonF &points)\n", false, &_init_f_drawPoints_2208, &_call_f_drawPoints_2208);
}

// void QPainter::drawPoints(const QPolygon &points)


static void _init_f_drawPoints_2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("points");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPoints_2138 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  ((QPainter *)cls)->drawPoints (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawPoints_2138 ()
{
  return new qt_gsi::GenericMethod ("drawPoints", "@brief Method void QPainter::drawPoints(const QPolygon &points)\n", false, &_init_f_drawPoints_2138, &_call_f_drawPoints_2138);
}

// void QPainter::drawPolygon(const QPolygonF &polygon, Qt::FillRule fillRule)


static void _init_f_drawPolygon_3648 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fillRule", true, "Qt::OddEvenFill");
  decl->add_arg<const qt_gsi::Converter<Qt::FillRule>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPolygon_3648 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::FillRule>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::FillRule>::target_type & > () : (const qt_gsi::Converter<Qt::FillRule>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::FillRule>(heap, Qt::OddEvenFill));
  ((QPainter *)cls)->drawPolygon (arg1, qt_gsi::QtToCppAdaptor<Qt::FillRule>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_drawPolygon_3648 ()
{
  return new qt_gsi::GenericMethod ("drawPolygon", "@brief Method void QPainter::drawPolygon(const QPolygonF &polygon, Qt::FillRule fillRule)\n", false, &_init_f_drawPolygon_3648, &_call_f_drawPolygon_3648);
}

// void QPainter::drawPolygon(const QPolygon &polygon, Qt::FillRule fillRule)


static void _init_f_drawPolygon_3578 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fillRule", true, "Qt::OddEvenFill");
  decl->add_arg<const qt_gsi::Converter<Qt::FillRule>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawPolygon_3578 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::FillRule>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::FillRule>::target_type & > () : (const qt_gsi::Converter<Qt::FillRule>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::FillRule>(heap, Qt::OddEvenFill));
  ((QPainter *)cls)->drawPolygon (arg1, qt_gsi::QtToCppAdaptor<Qt::FillRule>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_drawPolygon_3578 ()
{
  return new qt_gsi::GenericMethod ("drawPolygon", "@brief Method void QPainter::drawPolygon(const QPolygon &polygon, Qt::FillRule fillRule)\n", false, &_init_f_drawPolygon_3578, &_call_f_drawPolygon_3578);
}

// void QPainter::drawPolyline(const QPolygonF &polyline)


static void _init_f_drawPolyline_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polyline");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPolyline_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  ((QPainter *)cls)->drawPolyline (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawPolyline_2208 ()
{
  return new qt_gsi::GenericMethod ("drawPolyline", "@brief Method void QPainter::drawPolyline(const QPolygonF &polyline)\n", false, &_init_f_drawPolyline_2208, &_call_f_drawPolyline_2208);
}

// void QPainter::drawPolyline(const QPolygon &polygon)


static void _init_f_drawPolyline_2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPolyline_2138 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  ((QPainter *)cls)->drawPolyline (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawPolyline_2138 ()
{
  return new qt_gsi::GenericMethod ("drawPolyline", "@brief Method void QPainter::drawPolyline(const QPolygon &polygon)\n", false, &_init_f_drawPolyline_2138, &_call_f_drawPolyline_2138);
}

// void QPainter::drawRect(const QRectF &rect)


static void _init_f_drawRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawRect_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QPainter *)cls)->drawRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawRect_1862 ()
{
  return new qt_gsi::GenericMethod ("drawRect", "@brief Method void QPainter::drawRect(const QRectF &rect)\n", false, &_init_f_drawRect_1862, &_call_f_drawRect_1862);
}

// void QPainter::drawRect(int x1, int y1, int w, int h)


static void _init_f_drawRect_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawRect_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QPainter *)cls)->drawRect (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawRect_2744 ()
{
  return new qt_gsi::GenericMethod ("drawRect", "@brief Method void QPainter::drawRect(int x1, int y1, int w, int h)\n", false, &_init_f_drawRect_2744, &_call_f_drawRect_2744);
}

// void QPainter::drawRect(const QRect &rect)


static void _init_f_drawRect_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawRect_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QPainter *)cls)->drawRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_drawRect_1792 ()
{
  return new qt_gsi::GenericMethod ("drawRect", "@brief Method void QPainter::drawRect(const QRect &rect)\n", false, &_init_f_drawRect_1792, &_call_f_drawRect_1792);
}

// void QPainter::drawRects(const QVector<QRectF> &rectangles)


static void _init_f_drawRects_2692 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rectangles");
  decl->add_arg<const qt_gsi::Converter<QVector<QRectF> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawRects_2692 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVector<QRectF> >::target_type & arg1 = args.read<const qt_gsi::Converter<QVector<QRectF> >::target_type & > ();
  ((QPainter *)cls)->drawRects (qt_gsi::QtToCppAdaptor<QVector<QRectF> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_drawRects_2692 ()
{
  return new qt_gsi::GenericMethod ("drawRects_f", "@brief Method void QPainter::drawRects(const QVector<QRectF> &rectangles)\n", false, &_init_f_drawRects_2692, &_call_f_drawRects_2692);
}

// void QPainter::drawRects(const QVector<QRect> &rectangles)


static void _init_f_drawRects_2622 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rectangles");
  decl->add_arg<const qt_gsi::Converter<QVector<QRect> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawRects_2622 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVector<QRect> >::target_type & arg1 = args.read<const qt_gsi::Converter<QVector<QRect> >::target_type & > ();
  ((QPainter *)cls)->drawRects (qt_gsi::QtToCppAdaptor<QVector<QRect> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_drawRects_2622 ()
{
  return new qt_gsi::GenericMethod ("drawRects_i", "@brief Method void QPainter::drawRects(const QVector<QRect> &rectangles)\n", false, &_init_f_drawRects_2622, &_call_f_drawRects_2622);
}

// void QPainter::drawRoundRect(const QRectF &r, int xround, int yround)


static void _init_f_drawRoundRect_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xround", true, "25");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yround", true, "25");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawRoundRect_3180 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  int arg2 = args ? args.read<int > () : (int)(25);
  int arg3 = args ? args.read<int > () : (int)(25);
  ((QPainter *)cls)->drawRoundRect (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawRoundRect_3180 ()
{
  return new qt_gsi::GenericMethod ("drawRoundRect", "@brief Method void QPainter::drawRoundRect(const QRectF &r, int xround, int yround)\n", false, &_init_f_drawRoundRect_3180, &_call_f_drawRoundRect_3180);
}

// void QPainter::drawRoundRect(int x, int y, int w, int h, int, int)


static void _init_f_drawRoundRect_4062 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("arg5", true, "25");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("arg6", true, "25");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_drawRoundRect_4062 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  int arg5 = args ? args.read<int > () : (int)(25);
  int arg6 = args ? args.read<int > () : (int)(25);
  ((QPainter *)cls)->drawRoundRect (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_drawRoundRect_4062 ()
{
  return new qt_gsi::GenericMethod ("drawRoundRect", "@brief Method void QPainter::drawRoundRect(int x, int y, int w, int h, int, int)\n", false, &_init_f_drawRoundRect_4062, &_call_f_drawRoundRect_4062);
}

// void QPainter::drawRoundRect(const QRect &r, int xround, int yround)


static void _init_f_drawRoundRect_3110 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xround", true, "25");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yround", true, "25");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawRoundRect_3110 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  int arg2 = args ? args.read<int > () : (int)(25);
  int arg3 = args ? args.read<int > () : (int)(25);
  ((QPainter *)cls)->drawRoundRect (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawRoundRect_3110 ()
{
  return new qt_gsi::GenericMethod ("drawRoundRect", "@brief Method void QPainter::drawRoundRect(const QRect &r, int xround, int yround)\n", false, &_init_f_drawRoundRect_3110, &_call_f_drawRoundRect_3110);
}

// void QPainter::drawRoundedRect(const QRectF &rect, double xRadius, double yRadius, Qt::SizeMode mode)


static void _init_f_drawRoundedRect_5229 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xRadius");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yRadius");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "Qt::AbsoluteSize");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeMode>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawRoundedRect_5229 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeMode>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<Qt::SizeMode>::target_type & > () : (const qt_gsi::Converter<Qt::SizeMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::SizeMode>(heap, Qt::AbsoluteSize));
  ((QPainter *)cls)->drawRoundedRect (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::SizeMode>(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_drawRoundedRect_5229 ()
{
  return new qt_gsi::GenericMethod ("drawRoundedRect", "@brief Method void QPainter::drawRoundedRect(const QRectF &rect, double xRadius, double yRadius, Qt::SizeMode mode)\n", false, &_init_f_drawRoundedRect_5229, &_call_f_drawRoundedRect_5229);
}

// void QPainter::drawRoundedRect(int x, int y, int w, int h, double xRadius, double yRadius, Qt::SizeMode mode)


static void _init_f_drawRoundedRect_6111 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("xRadius");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("yRadius");
  decl->add_arg<double > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("mode", true, "Qt::AbsoluteSize");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeMode>::target_type & > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_drawRoundedRect_6111 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  double arg5 = args.read<double > ();
  double arg6 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeMode>::target_type & arg7 = args ? args.read<const qt_gsi::Converter<Qt::SizeMode>::target_type & > () : (const qt_gsi::Converter<Qt::SizeMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::SizeMode>(heap, Qt::AbsoluteSize));
  ((QPainter *)cls)->drawRoundedRect (arg1, arg2, arg3, arg4, arg5, arg6, qt_gsi::QtToCppAdaptor<Qt::SizeMode>(arg7).cref());
}

static qt_gsi::GenericMethod *_create_f_drawRoundedRect_6111 ()
{
  return new qt_gsi::GenericMethod ("drawRoundedRect", "@brief Method void QPainter::drawRoundedRect(int x, int y, int w, int h, double xRadius, double yRadius, Qt::SizeMode mode)\n", false, &_init_f_drawRoundedRect_6111, &_call_f_drawRoundedRect_6111);
}

// void QPainter::drawRoundedRect(const QRect &rect, double xRadius, double yRadius, Qt::SizeMode mode)


static void _init_f_drawRoundedRect_5159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xRadius");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yRadius");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "Qt::AbsoluteSize");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeMode>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawRoundedRect_5159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeMode>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<Qt::SizeMode>::target_type & > () : (const qt_gsi::Converter<Qt::SizeMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::SizeMode>(heap, Qt::AbsoluteSize));
  ((QPainter *)cls)->drawRoundedRect (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::SizeMode>(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_drawRoundedRect_5159 ()
{
  return new qt_gsi::GenericMethod ("drawRoundedRect", "@brief Method void QPainter::drawRoundedRect(const QRect &rect, double xRadius, double yRadius, Qt::SizeMode mode)\n", false, &_init_f_drawRoundedRect_5159, &_call_f_drawRoundedRect_5159);
}

// void QPainter::drawText(const QPointF &p, const QString &s)


static void _init_f_drawText_3903 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawText_3903 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QPainter *)cls)->drawText (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawText_3903 ()
{
  return new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QPointF &p, const QString &s)\n", false, &_init_f_drawText_3903, &_call_f_drawText_3903);
}

// void QPainter::drawText(const QPoint &p, const QString &s)


static void _init_f_drawText_3833 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawText_3833 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QPainter *)cls)->drawText (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawText_3833 ()
{
  return new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QPoint &p, const QString &s)\n", false, &_init_f_drawText_3833, &_call_f_drawText_3833);
}

// void QPainter::drawText(int x, int y, const QString &s)


static void _init_f_drawText_3343 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("s");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawText_3343 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QString &arg3 = args.read<const QString & > ();
  ((QPainter *)cls)->drawText (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawText_3343 ()
{
  return new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(int x, int y, const QString &s)\n", false, &_init_f_drawText_3343, &_call_f_drawText_3343);
}

// void QPainter::drawText(const QPointF &p, const QString &str, int tf, int justificationPadding)


static void _init_f_drawText_5221 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("str");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("tf");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("justificationPadding");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawText_5221 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QString &arg2 = args.read<const QString & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QPainter *)cls)->drawText (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawText_5221 ()
{
  return new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QPointF &p, const QString &str, int tf, int justificationPadding)\n", false, &_init_f_drawText_5221, &_call_f_drawText_5221);
}

// void QPainter::drawText(const QRectF &r, int flags, const QString &text, QRectF *br)


static void _init_f_drawText_5501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("br", true, "0");
  decl->add_arg<QRectF * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawText_5501 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  int arg2 = args.read<int > ();
  const QString &arg3 = args.read<const QString & > ();
  QRectF *arg4 = args ? args.read<QRectF * > () : (QRectF *)(0);
  ((QPainter *)cls)->drawText (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawText_5501 ()
{
  return new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QRectF &r, int flags, const QString &text, QRectF *br)\n", false, &_init_f_drawText_5501, &_call_f_drawText_5501);
}

// void QPainter::drawText(const QRect &r, int flags, const QString &text, QRect *br)


static void _init_f_drawText_5361 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("br", true, "0");
  decl->add_arg<QRect * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawText_5361 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  int arg2 = args.read<int > ();
  const QString &arg3 = args.read<const QString & > ();
  QRect *arg4 = args ? args.read<QRect * > () : (QRect *)(0);
  ((QPainter *)cls)->drawText (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawText_5361 ()
{
  return new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QRect &r, int flags, const QString &text, QRect *br)\n", false, &_init_f_drawText_5361, &_call_f_drawText_5361);
}

// void QPainter::drawText(int x, int y, int w, int h, int flags, const QString &text, QRect *br)


static void _init_f_drawText_6313 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("br", true, "0");
  decl->add_arg<QRect * > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_drawText_6313 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  int arg5 = args.read<int > ();
  const QString &arg6 = args.read<const QString & > ();
  QRect *arg7 = args ? args.read<QRect * > () : (QRect *)(0);
  ((QPainter *)cls)->drawText (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

static qt_gsi::GenericMethod *_create_f_drawText_6313 ()
{
  return new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(int x, int y, int w, int h, int flags, const QString &text, QRect *br)\n", false, &_init_f_drawText_6313, &_call_f_drawText_6313);
}

// void QPainter::drawText(const QRectF &r, const QString &text, const QTextOption &o)


static void _init_f_drawText_6119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("o", true, "QTextOption()");
  decl->add_arg<const QTextOption & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawText_6119 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QString &arg2 = args.read<const QString & > ();
  const QTextOption &arg3 = args ? args.read<const QTextOption & > () : (const QTextOption &)(QTextOption());
  ((QPainter *)cls)->drawText (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawText_6119 ()
{
  return new qt_gsi::GenericMethod ("drawText", "@brief Method void QPainter::drawText(const QRectF &r, const QString &text, const QTextOption &o)\n", false, &_init_f_drawText_6119, &_call_f_drawText_6119);
}

// void QPainter::drawTextItem(const QPointF &p, const QTextItem &ti)


static void _init_f_drawTextItem_4092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ti");
  decl->add_arg<const QTextItem & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawTextItem_4092 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QTextItem &arg2 = args.read<const QTextItem & > ();
  ((QPainter *)cls)->drawTextItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawTextItem_4092 ()
{
  return new qt_gsi::GenericMethod ("drawTextItem", "@brief Method void QPainter::drawTextItem(const QPointF &p, const QTextItem &ti)\n", false, &_init_f_drawTextItem_4092, &_call_f_drawTextItem_4092);
}

// void QPainter::drawTextItem(int x, int y, const QTextItem &ti)


static void _init_f_drawTextItem_3532 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ti");
  decl->add_arg<const QTextItem & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawTextItem_3532 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QTextItem &arg3 = args.read<const QTextItem & > ();
  ((QPainter *)cls)->drawTextItem (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawTextItem_3532 ()
{
  return new qt_gsi::GenericMethod ("drawTextItem", "@brief Method void QPainter::drawTextItem(int x, int y, const QTextItem &ti)\n", false, &_init_f_drawTextItem_3532, &_call_f_drawTextItem_3532);
}

// void QPainter::drawTextItem(const QPoint &p, const QTextItem &ti)


static void _init_f_drawTextItem_4022 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ti");
  decl->add_arg<const QTextItem & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawTextItem_4022 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const QTextItem &arg2 = args.read<const QTextItem & > ();
  ((QPainter *)cls)->drawTextItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawTextItem_4022 ()
{
  return new qt_gsi::GenericMethod ("drawTextItem", "@brief Method void QPainter::drawTextItem(const QPoint &p, const QTextItem &ti)\n", false, &_init_f_drawTextItem_4022, &_call_f_drawTextItem_4022);
}

// void QPainter::drawTiledPixmap(const QRectF &rect, const QPixmap &pm, const QPointF &offset)


static void _init_f_drawTiledPixmap_5649 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("offset", true, "QPointF()");
  decl->add_arg<const QPointF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawTiledPixmap_5649 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QPointF &arg3 = args ? args.read<const QPointF & > () : (const QPointF &)(QPointF());
  ((QPainter *)cls)->drawTiledPixmap (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawTiledPixmap_5649 ()
{
  return new qt_gsi::GenericMethod ("drawTiledPixmap", "@brief Method void QPainter::drawTiledPixmap(const QRectF &rect, const QPixmap &pm, const QPointF &offset)\n", false, &_init_f_drawTiledPixmap_5649, &_call_f_drawTiledPixmap_5649);
}

// void QPainter::drawTiledPixmap(int x, int y, int w, int h, const QPixmap &, int sx, int sy)


static void _init_f_drawTiledPixmap_5971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("arg5");
  decl->add_arg<const QPixmap & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("sx", true, "0");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("sy", true, "0");
  decl->add_arg<int > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_drawTiledPixmap_5971 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QPixmap &arg5 = args.read<const QPixmap & > ();
  int arg6 = args ? args.read<int > () : (int)(0);
  int arg7 = args ? args.read<int > () : (int)(0);
  ((QPainter *)cls)->drawTiledPixmap (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

static qt_gsi::GenericMethod *_create_f_drawTiledPixmap_5971 ()
{
  return new qt_gsi::GenericMethod ("drawTiledPixmap", "@brief Method void QPainter::drawTiledPixmap(int x, int y, int w, int h, const QPixmap &, int sx, int sy)\n", false, &_init_f_drawTiledPixmap_5971, &_call_f_drawTiledPixmap_5971);
}

// void QPainter::drawTiledPixmap(const QRect &, const QPixmap &, const QPoint &)


static void _init_f_drawTiledPixmap_5509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("arg3", true, "QPoint()");
  decl->add_arg<const QPoint & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawTiledPixmap_5509 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QPoint &arg3 = args ? args.read<const QPoint & > () : (const QPoint &)(QPoint());
  ((QPainter *)cls)->drawTiledPixmap (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_drawTiledPixmap_5509 ()
{
  return new qt_gsi::GenericMethod ("drawTiledPixmap", "@brief Method void QPainter::drawTiledPixmap(const QRect &, const QPixmap &, const QPoint &)\n", false, &_init_f_drawTiledPixmap_5509, &_call_f_drawTiledPixmap_5509);
}

// bool QPainter::end()


static void _init_f_end_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_end_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPainter *)cls)->end ());
}

static qt_gsi::GenericMethod *_create_f_end_0 ()
{
  return new qt_gsi::GenericMethod ("end", "@brief Method bool QPainter::end()\n", false, &_init_f_end_0, &_call_f_end_0);
}

// void QPainter::endNativePainting()


static void _init_f_endNativePainting_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endNativePainting_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPainter *)cls)->endNativePainting ();
}

static qt_gsi::GenericMethod *_create_f_endNativePainting_0 ()
{
  return new qt_gsi::GenericMethod ("endNativePainting", "@brief Method void QPainter::endNativePainting()\n", false, &_init_f_endNativePainting_0, &_call_f_endNativePainting_0);
}

// void QPainter::eraseRect(const QRectF &)


static void _init_f_eraseRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_eraseRect_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QPainter *)cls)->eraseRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_eraseRect_1862 ()
{
  return new qt_gsi::GenericMethod ("eraseRect", "@brief Method void QPainter::eraseRect(const QRectF &)\n", false, &_init_f_eraseRect_1862, &_call_f_eraseRect_1862);
}

// void QPainter::eraseRect(int x, int y, int w, int h)


static void _init_f_eraseRect_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_eraseRect_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QPainter *)cls)->eraseRect (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_eraseRect_2744 ()
{
  return new qt_gsi::GenericMethod ("eraseRect", "@brief Method void QPainter::eraseRect(int x, int y, int w, int h)\n", false, &_init_f_eraseRect_2744, &_call_f_eraseRect_2744);
}

// void QPainter::eraseRect(const QRect &)


static void _init_f_eraseRect_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_eraseRect_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QPainter *)cls)->eraseRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_eraseRect_1792 ()
{
  return new qt_gsi::GenericMethod ("eraseRect", "@brief Method void QPainter::eraseRect(const QRect &)\n", false, &_init_f_eraseRect_1792, &_call_f_eraseRect_1792);
}

// void QPainter::fillPath(const QPainterPath &path, const QBrush &brush)


static void _init_f_fillPath_4316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("brush");
  decl->add_arg<const QBrush & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillPath_4316 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const QBrush &arg2 = args.read<const QBrush & > ();
  ((QPainter *)cls)->fillPath (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_fillPath_4316 ()
{
  return new qt_gsi::GenericMethod ("fillPath", "@brief Method void QPainter::fillPath(const QPainterPath &path, const QBrush &brush)\n", false, &_init_f_fillPath_4316, &_call_f_fillPath_4316);
}

// void QPainter::fillRect(const QRectF &, const QBrush &)


static void _init_f_fillRect_3664 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QBrush & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3664 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QBrush &arg2 = args.read<const QBrush & > ();
  ((QPainter *)cls)->fillRect (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_fillRect_3664 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRectF &, const QBrush &)\n", false, &_init_f_fillRect_3664, &_call_f_fillRect_3664);
}

// void QPainter::fillRect(int x, int y, int w, int h, const QBrush &)


static void _init_f_fillRect_4546 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("arg5");
  decl->add_arg<const QBrush & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_fillRect_4546 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QBrush &arg5 = args.read<const QBrush & > ();
  ((QPainter *)cls)->fillRect (arg1, arg2, arg3, arg4, arg5);
}

static qt_gsi::GenericMethod *_create_f_fillRect_4546 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(int x, int y, int w, int h, const QBrush &)\n", false, &_init_f_fillRect_4546, &_call_f_fillRect_4546);
}

// void QPainter::fillRect(const QRect &, const QBrush &)


static void _init_f_fillRect_3594 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QBrush & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3594 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const QBrush &arg2 = args.read<const QBrush & > ();
  ((QPainter *)cls)->fillRect (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_fillRect_3594 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRect &, const QBrush &)\n", false, &_init_f_fillRect_3594, &_call_f_fillRect_3594);
}

// void QPainter::fillRect(const QRectF &, const QColor &color)


static void _init_f_fillRect_3659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("color");
  decl->add_arg<const QColor & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QColor &arg2 = args.read<const QColor & > ();
  ((QPainter *)cls)->fillRect (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_fillRect_3659 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRectF &, const QColor &color)\n", false, &_init_f_fillRect_3659, &_call_f_fillRect_3659);
}

// void QPainter::fillRect(int x, int y, int w, int h, const QColor &color)


static void _init_f_fillRect_4541 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("color");
  decl->add_arg<const QColor & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_fillRect_4541 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QColor &arg5 = args.read<const QColor & > ();
  ((QPainter *)cls)->fillRect (arg1, arg2, arg3, arg4, arg5);
}

static qt_gsi::GenericMethod *_create_f_fillRect_4541 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(int x, int y, int w, int h, const QColor &color)\n", false, &_init_f_fillRect_4541, &_call_f_fillRect_4541);
}

// void QPainter::fillRect(const QRect &, const QColor &color)


static void _init_f_fillRect_3589 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("color");
  decl->add_arg<const QColor & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3589 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const QColor &arg2 = args.read<const QColor & > ();
  ((QPainter *)cls)->fillRect (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_fillRect_3589 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRect &, const QColor &color)\n", false, &_init_f_fillRect_3589, &_call_f_fillRect_3589);
}

// void QPainter::fillRect(int x, int y, int w, int h, Qt::GlobalColor c)


static void _init_f_fillRect_4489 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("c");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_fillRect_4489 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg5 = args.read<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > ();
  ((QPainter *)cls)->fillRect (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg5).cref());
}

static qt_gsi::GenericMethod *_create_f_fillRect_4489 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(int x, int y, int w, int h, Qt::GlobalColor c)\n", false, &_init_f_fillRect_4489, &_call_f_fillRect_4489);
}

// void QPainter::fillRect(const QRect &r, Qt::GlobalColor c)


static void _init_f_fillRect_3537 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3537 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > ();
  ((QPainter *)cls)->fillRect (arg1, qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_fillRect_3537 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRect &r, Qt::GlobalColor c)\n", false, &_init_f_fillRect_3537, &_call_f_fillRect_3537);
}

// void QPainter::fillRect(const QRectF &r, Qt::GlobalColor c)


static void _init_f_fillRect_3607 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3607 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > ();
  ((QPainter *)cls)->fillRect (arg1, qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_fillRect_3607 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRectF &r, Qt::GlobalColor c)\n", false, &_init_f_fillRect_3607, &_call_f_fillRect_3607);
}

// void QPainter::fillRect(int x, int y, int w, int h, Qt::BrushStyle style)


static void _init_f_fillRect_4430 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("style");
  decl->add_arg<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_fillRect_4430 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const qt_gsi::Converter<Qt::BrushStyle>::target_type & arg5 = args.read<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > ();
  ((QPainter *)cls)->fillRect (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::BrushStyle>(arg5).cref());
}

static qt_gsi::GenericMethod *_create_f_fillRect_4430 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(int x, int y, int w, int h, Qt::BrushStyle style)\n", false, &_init_f_fillRect_4430, &_call_f_fillRect_4430);
}

// void QPainter::fillRect(const QRect &r, Qt::BrushStyle style)


static void _init_f_fillRect_3478 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style");
  decl->add_arg<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3478 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const qt_gsi::Converter<Qt::BrushStyle>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > ();
  ((QPainter *)cls)->fillRect (arg1, qt_gsi::QtToCppAdaptor<Qt::BrushStyle>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_fillRect_3478 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRect &r, Qt::BrushStyle style)\n", false, &_init_f_fillRect_3478, &_call_f_fillRect_3478);
}

// void QPainter::fillRect(const QRectF &r, Qt::BrushStyle style)


static void _init_f_fillRect_3548 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style");
  decl->add_arg<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fillRect_3548 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const qt_gsi::Converter<Qt::BrushStyle>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > ();
  ((QPainter *)cls)->fillRect (arg1, qt_gsi::QtToCppAdaptor<Qt::BrushStyle>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_fillRect_3548 ()
{
  return new qt_gsi::GenericMethod ("fillRect", "@brief Method void QPainter::fillRect(const QRectF &r, Qt::BrushStyle style)\n", false, &_init_f_fillRect_3548, &_call_f_fillRect_3548);
}

// const QFont &QPainter::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QFont & > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QFont & > ((const QFont &)((QPainter *)cls)->font ());
}

static qt_gsi::GenericMethod *_create_f_font_c0 ()
{
  return new qt_gsi::GenericMethod (":font", "@brief Method const QFont &QPainter::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
}

// QFontInfo QPainter::fontInfo()


static void _init_f_fontInfo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFontInfo > ();
}

static void _call_f_fontInfo_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFontInfo > ((QFontInfo)((QPainter *)cls)->fontInfo ());
}

static qt_gsi::GenericMethod *_create_f_fontInfo_c0 ()
{
  return new qt_gsi::GenericMethod ("fontInfo", "@brief Method QFontInfo QPainter::fontInfo()\n", true, &_init_f_fontInfo_c0, &_call_f_fontInfo_c0);
}

// QFontMetrics QPainter::fontMetrics()


static void _init_f_fontMetrics_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFontMetrics > ();
}

static void _call_f_fontMetrics_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFontMetrics > ((QFontMetrics)((QPainter *)cls)->fontMetrics ());
}

static qt_gsi::GenericMethod *_create_f_fontMetrics_c0 ()
{
  return new qt_gsi::GenericMethod ("fontMetrics", "@brief Method QFontMetrics QPainter::fontMetrics()\n", true, &_init_f_fontMetrics_c0, &_call_f_fontMetrics_c0);
}

// bool QPainter::hasClipping()


static void _init_f_hasClipping_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasClipping_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPainter *)cls)->hasClipping ());
}

static qt_gsi::GenericMethod *_create_f_hasClipping_c0 ()
{
  return new qt_gsi::GenericMethod ("hasClipping|:clipping", "@brief Method bool QPainter::hasClipping()\n", true, &_init_f_hasClipping_c0, &_call_f_hasClipping_c0);
}

// void QPainter::initFrom(const QWidget *widget)


static void _init_f_initFrom_2010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_initFrom_2010 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QWidget *arg1 = args.read<const QWidget * > ();
  ((QPainter *)cls)->initFrom (arg1);
}

static qt_gsi::GenericMethod *_create_f_initFrom_2010 ()
{
  return new qt_gsi::GenericMethod ("initFrom", "@brief Method void QPainter::initFrom(const QWidget *widget)\n", false, &_init_f_initFrom_2010, &_call_f_initFrom_2010);
}

// bool QPainter::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPainter *)cls)->isActive ());
}

static qt_gsi::GenericMethod *_create_f_isActive_c0 ()
{
  return new qt_gsi::GenericMethod ("isActive?", "@brief Method bool QPainter::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
}

// Qt::LayoutDirection QPainter::layoutDirection()


static void _init_f_layoutDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_layoutDirection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(((QPainter *)cls)->layoutDirection ()));
}

static qt_gsi::GenericMethod *_create_f_layoutDirection_c0 ()
{
  return new qt_gsi::GenericMethod (":layoutDirection", "@brief Method Qt::LayoutDirection QPainter::layoutDirection()\n", true, &_init_f_layoutDirection_c0, &_call_f_layoutDirection_c0);
}

// const QMatrix &QPainter::matrix()


static void _init_f_matrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMatrix & > ();
}

static void _call_f_matrix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMatrix & > ((const QMatrix &)((QPainter *)cls)->matrix ());
}

static qt_gsi::GenericMethod *_create_f_matrix_c0 ()
{
  return new qt_gsi::GenericMethod (":matrix", "@brief Method const QMatrix &QPainter::matrix()\n", true, &_init_f_matrix_c0, &_call_f_matrix_c0);
}

// bool QPainter::matrixEnabled()


static void _init_f_matrixEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_matrixEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPainter *)cls)->matrixEnabled ());
}

static qt_gsi::GenericMethod *_create_f_matrixEnabled_c0 ()
{
  return new qt_gsi::GenericMethod (":matrixEnabled", "@brief Method bool QPainter::matrixEnabled()\n", true, &_init_f_matrixEnabled_c0, &_call_f_matrixEnabled_c0);
}

// double QPainter::opacity()


static void _init_f_opacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_opacity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QPainter *)cls)->opacity ());
}

static qt_gsi::GenericMethod *_create_f_opacity_c0 ()
{
  return new qt_gsi::GenericMethod (":opacity", "@brief Method double QPainter::opacity()\n", true, &_init_f_opacity_c0, &_call_f_opacity_c0);
}

// QPaintEngine *QPainter::paintEngine()


static void _init_f_paintEngine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_f_paintEngine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPainter *)cls)->paintEngine ());
}

static qt_gsi::GenericMethod *_create_f_paintEngine_c0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Method QPaintEngine *QPainter::paintEngine()\n", true, &_init_f_paintEngine_c0, &_call_f_paintEngine_c0);
}

// const QPen &QPainter::pen()


static void _init_f_pen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QPen & > ();
}

static void _call_f_pen_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QPen & > ((const QPen &)((QPainter *)cls)->pen ());
}

static qt_gsi::GenericMethod *_create_f_pen_c0 ()
{
  return new qt_gsi::GenericMethod ("pen", "@brief Method const QPen &QPainter::pen()\n", true, &_init_f_pen_c0, &_call_f_pen_c0);
}

// QFlags<QPainter::RenderHint> QPainter::renderHints()


static void _init_f_renderHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type > ();
}

static void _call_f_renderHints_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type > ((qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QPainter::RenderHint> >(((QPainter *)cls)->renderHints ()));
}

static qt_gsi::GenericMethod *_create_f_renderHints_c0 ()
{
  return new qt_gsi::GenericMethod (":renderHints", "@brief Method QFlags<QPainter::RenderHint> QPainter::renderHints()\n", true, &_init_f_renderHints_c0, &_call_f_renderHints_c0);
}

// void QPainter::resetMatrix()


static void _init_f_resetMatrix_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetMatrix_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPainter *)cls)->resetMatrix ();
}

static qt_gsi::GenericMethod *_create_f_resetMatrix_0 ()
{
  return new qt_gsi::GenericMethod ("resetMatrix", "@brief Method void QPainter::resetMatrix()\n", false, &_init_f_resetMatrix_0, &_call_f_resetMatrix_0);
}

// void QPainter::resetTransform()


static void _init_f_resetTransform_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetTransform_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPainter *)cls)->resetTransform ();
}

static qt_gsi::GenericMethod *_create_f_resetTransform_0 ()
{
  return new qt_gsi::GenericMethod ("resetTransform", "@brief Method void QPainter::resetTransform()\n", false, &_init_f_resetTransform_0, &_call_f_resetTransform_0);
}

// void QPainter::restore()


static void _init_f_restore_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_restore_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPainter *)cls)->restore ();
}

static qt_gsi::GenericMethod *_create_f_restore_0 ()
{
  return new qt_gsi::GenericMethod ("restore", "@brief Method void QPainter::restore()\n", false, &_init_f_restore_0, &_call_f_restore_0);
}

// void QPainter::rotate(double a)


static void _init_f_rotate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_rotate_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QPainter *)cls)->rotate (arg1);
}

static qt_gsi::GenericMethod *_create_f_rotate_1071 ()
{
  return new qt_gsi::GenericMethod ("rotate", "@brief Method void QPainter::rotate(double a)\n", false, &_init_f_rotate_1071, &_call_f_rotate_1071);
}

// void QPainter::save()


static void _init_f_save_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_save_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPainter *)cls)->save ();
}

static qt_gsi::GenericMethod *_create_f_save_0 ()
{
  return new qt_gsi::GenericMethod ("save", "@brief Method void QPainter::save()\n", false, &_init_f_save_0, &_call_f_save_0);
}

// void QPainter::scale(double sx, double sy)


static void _init_f_scale_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scale_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QPainter *)cls)->scale (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_scale_2034 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QPainter::scale(double sx, double sy)\n", false, &_init_f_scale_2034, &_call_f_scale_2034);
}

// void QPainter::setBackground(const QBrush &bg)


static void _init_f_setBackground_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("bg");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackground_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QPainter *)cls)->setBackground (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBackground_1910 ()
{
  return new qt_gsi::GenericMethod ("setBackground|background=", "@brief Method void QPainter::setBackground(const QBrush &bg)\n", false, &_init_f_setBackground_1910, &_call_f_setBackground_1910);
}

// void QPainter::setBackgroundMode(Qt::BGMode mode)


static void _init_f_setBackgroundMode_1275 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::BGMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundMode_1275 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::BGMode>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::BGMode>::target_type & > ();
  ((QPainter *)cls)->setBackgroundMode (qt_gsi::QtToCppAdaptor<Qt::BGMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setBackgroundMode_1275 ()
{
  return new qt_gsi::GenericMethod ("setBackgroundMode|backgroundMode=", "@brief Method void QPainter::setBackgroundMode(Qt::BGMode mode)\n", false, &_init_f_setBackgroundMode_1275, &_call_f_setBackgroundMode_1275);
}

// void QPainter::setBrush(const QBrush &brush)


static void _init_f_setBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBrush_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QPainter *)cls)->setBrush (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBrush_1910 ()
{
  return new qt_gsi::GenericMethod ("setBrush|brush=", "@brief Method void QPainter::setBrush(const QBrush &brush)\n", false, &_init_f_setBrush_1910, &_call_f_setBrush_1910);
}

// void QPainter::setBrush(Qt::BrushStyle style)


static void _init_f_setBrush_1794 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBrush_1794 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::BrushStyle>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::BrushStyle>::target_type & > ();
  ((QPainter *)cls)->setBrush (qt_gsi::QtToCppAdaptor<Qt::BrushStyle>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setBrush_1794 ()
{
  return new qt_gsi::GenericMethod ("setBrush|brush=", "@brief Method void QPainter::setBrush(Qt::BrushStyle style)\n", false, &_init_f_setBrush_1794, &_call_f_setBrush_1794);
}

// void QPainter::setBrushOrigin(int x, int y)


static void _init_f_setBrushOrigin_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setBrushOrigin_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QPainter *)cls)->setBrushOrigin (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setBrushOrigin_1426 ()
{
  return new qt_gsi::GenericMethod ("setBrushOrigin", "@brief Method void QPainter::setBrushOrigin(int x, int y)\n", false, &_init_f_setBrushOrigin_1426, &_call_f_setBrushOrigin_1426);
}

// void QPainter::setBrushOrigin(const QPoint &)


static void _init_f_setBrushOrigin_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBrushOrigin_1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ((QPainter *)cls)->setBrushOrigin (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBrushOrigin_1916 ()
{
  return new qt_gsi::GenericMethod ("setBrushOrigin|brushOrigin=", "@brief Method void QPainter::setBrushOrigin(const QPoint &)\n", false, &_init_f_setBrushOrigin_1916, &_call_f_setBrushOrigin_1916);
}

// void QPainter::setBrushOrigin(const QPointF &)


static void _init_f_setBrushOrigin_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBrushOrigin_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QPainter *)cls)->setBrushOrigin (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBrushOrigin_1986 ()
{
  return new qt_gsi::GenericMethod ("setBrushOrigin|brushOrigin=", "@brief Method void QPainter::setBrushOrigin(const QPointF &)\n", false, &_init_f_setBrushOrigin_1986, &_call_f_setBrushOrigin_1986);
}

// void QPainter::setClipPath(const QPainterPath &path, Qt::ClipOperation op)


static void _init_f_setClipPath_4492 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("op", true, "Qt::ReplaceClip");
  decl->add_arg<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setClipPath_4492 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ClipOperation>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > () : (const qt_gsi::Converter<Qt::ClipOperation>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ClipOperation>(heap, Qt::ReplaceClip));
  ((QPainter *)cls)->setClipPath (arg1, qt_gsi::QtToCppAdaptor<Qt::ClipOperation>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setClipPath_4492 ()
{
  return new qt_gsi::GenericMethod ("setClipPath", "@brief Method void QPainter::setClipPath(const QPainterPath &path, Qt::ClipOperation op)\n", false, &_init_f_setClipPath_4492, &_call_f_setClipPath_4492);
}

// void QPainter::setClipRect(const QRectF &, Qt::ClipOperation op)


static void _init_f_setClipRect_3840 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("op", true, "Qt::ReplaceClip");
  decl->add_arg<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setClipRect_3840 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ClipOperation>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > () : (const qt_gsi::Converter<Qt::ClipOperation>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ClipOperation>(heap, Qt::ReplaceClip));
  ((QPainter *)cls)->setClipRect (arg1, qt_gsi::QtToCppAdaptor<Qt::ClipOperation>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setClipRect_3840 ()
{
  return new qt_gsi::GenericMethod ("setClipRect", "@brief Method void QPainter::setClipRect(const QRectF &, Qt::ClipOperation op)\n", false, &_init_f_setClipRect_3840, &_call_f_setClipRect_3840);
}

// void QPainter::setClipRect(const QRect &, Qt::ClipOperation op)


static void _init_f_setClipRect_3770 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("op", true, "Qt::ReplaceClip");
  decl->add_arg<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setClipRect_3770 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ClipOperation>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > () : (const qt_gsi::Converter<Qt::ClipOperation>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ClipOperation>(heap, Qt::ReplaceClip));
  ((QPainter *)cls)->setClipRect (arg1, qt_gsi::QtToCppAdaptor<Qt::ClipOperation>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setClipRect_3770 ()
{
  return new qt_gsi::GenericMethod ("setClipRect", "@brief Method void QPainter::setClipRect(const QRect &, Qt::ClipOperation op)\n", false, &_init_f_setClipRect_3770, &_call_f_setClipRect_3770);
}

// void QPainter::setClipRect(int x, int y, int w, int h, Qt::ClipOperation op)


static void _init_f_setClipRect_4722 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("op", true, "Qt::ReplaceClip");
  decl->add_arg<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_setClipRect_4722 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ClipOperation>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > () : (const qt_gsi::Converter<Qt::ClipOperation>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ClipOperation>(heap, Qt::ReplaceClip));
  ((QPainter *)cls)->setClipRect (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ClipOperation>(arg5).cref());
}

static qt_gsi::GenericMethod *_create_f_setClipRect_4722 ()
{
  return new qt_gsi::GenericMethod ("setClipRect", "@brief Method void QPainter::setClipRect(int x, int y, int w, int h, Qt::ClipOperation op)\n", false, &_init_f_setClipRect_4722, &_call_f_setClipRect_4722);
}

// void QPainter::setClipRegion(const QRegion &, Qt::ClipOperation op)


static void _init_f_setClipRegion_3984 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRegion & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("op", true, "Qt::ReplaceClip");
  decl->add_arg<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setClipRegion_3984 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ClipOperation>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ClipOperation>::target_type & > () : (const qt_gsi::Converter<Qt::ClipOperation>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ClipOperation>(heap, Qt::ReplaceClip));
  ((QPainter *)cls)->setClipRegion (arg1, qt_gsi::QtToCppAdaptor<Qt::ClipOperation>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setClipRegion_3984 ()
{
  return new qt_gsi::GenericMethod ("setClipRegion", "@brief Method void QPainter::setClipRegion(const QRegion &, Qt::ClipOperation op)\n", false, &_init_f_setClipRegion_3984, &_call_f_setClipRegion_3984);
}

// void QPainter::setClipping(bool enable)


static void _init_f_setClipping_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setClipping_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPainter *)cls)->setClipping (arg1);
}

static qt_gsi::GenericMethod *_create_f_setClipping_864 ()
{
  return new qt_gsi::GenericMethod ("setClipping|clipping=", "@brief Method void QPainter::setClipping(bool enable)\n", false, &_init_f_setClipping_864, &_call_f_setClipping_864);
}

// void QPainter::setCompositionMode(QPainter::CompositionMode mode)


static void _init_f_setCompositionMode_2917 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QPainter::CompositionMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCompositionMode_2917 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPainter::CompositionMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QPainter::CompositionMode>::target_type & > ();
  ((QPainter *)cls)->setCompositionMode (qt_gsi::QtToCppAdaptor<QPainter::CompositionMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setCompositionMode_2917 ()
{
  return new qt_gsi::GenericMethod ("setCompositionMode|compositionMode=", "@brief Method void QPainter::setCompositionMode(QPainter::CompositionMode mode)\n", false, &_init_f_setCompositionMode_2917, &_call_f_setCompositionMode_2917);
}

// void QPainter::setFont(const QFont &f)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QPainter *)cls)->setFont (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFont_1801 ()
{
  return new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QPainter::setFont(const QFont &f)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
}

// void QPainter::setLayoutDirection(Qt::LayoutDirection direction)


static void _init_f_setLayoutDirection_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayoutDirection_2316 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ();
  ((QPainter *)cls)->setLayoutDirection (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setLayoutDirection_2316 ()
{
  return new qt_gsi::GenericMethod ("setLayoutDirection|layoutDirection=", "@brief Method void QPainter::setLayoutDirection(Qt::LayoutDirection direction)\n", false, &_init_f_setLayoutDirection_2316, &_call_f_setLayoutDirection_2316);
}

// void QPainter::setMatrix(const QMatrix &matrix, bool combine)


static void _init_f_setMatrix_2779 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMatrix_2779 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args.read<const QMatrix & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ((QPainter *)cls)->setMatrix (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setMatrix_2779 ()
{
  return new qt_gsi::GenericMethod ("setMatrix", "@brief Method void QPainter::setMatrix(const QMatrix &matrix, bool combine)\n", false, &_init_f_setMatrix_2779, &_call_f_setMatrix_2779);
}

// void QPainter::setMatrixEnabled(bool enabled)


static void _init_f_setMatrixEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMatrixEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPainter *)cls)->setMatrixEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMatrixEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setMatrixEnabled|matrixEnabled=", "@brief Method void QPainter::setMatrixEnabled(bool enabled)\n", false, &_init_f_setMatrixEnabled_864, &_call_f_setMatrixEnabled_864);
}

// void QPainter::setOpacity(double opacity)


static void _init_f_setOpacity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opacity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpacity_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QPainter *)cls)->setOpacity (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOpacity_1071 ()
{
  return new qt_gsi::GenericMethod ("setOpacity|opacity=", "@brief Method void QPainter::setOpacity(double opacity)\n", false, &_init_f_setOpacity_1071, &_call_f_setOpacity_1071);
}

// void QPainter::setPen(const QColor &color)


static void _init_f_setPen_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPen_1905 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QColor &arg1 = args.read<const QColor & > ();
  ((QPainter *)cls)->setPen (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPen_1905 ()
{
  return new qt_gsi::GenericMethod ("setPen", "@brief Method void QPainter::setPen(const QColor &color)\n", false, &_init_f_setPen_1905, &_call_f_setPen_1905);
}

// void QPainter::setPen(const QPen &pen)


static void _init_f_setPen_1685 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pen");
  decl->add_arg<const QPen & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPen_1685 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPen &arg1 = args.read<const QPen & > ();
  ((QPainter *)cls)->setPen (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPen_1685 ()
{
  return new qt_gsi::GenericMethod ("setPen", "@brief Method void QPainter::setPen(const QPen &pen)\n", false, &_init_f_setPen_1685, &_call_f_setPen_1685);
}

// void QPainter::setPen(Qt::PenStyle style)


static void _init_f_setPen_1569 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<Qt::PenStyle>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPen_1569 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::PenStyle>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::PenStyle>::target_type & > ();
  ((QPainter *)cls)->setPen (qt_gsi::QtToCppAdaptor<Qt::PenStyle>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setPen_1569 ()
{
  return new qt_gsi::GenericMethod ("setPen", "@brief Method void QPainter::setPen(Qt::PenStyle style)\n", false, &_init_f_setPen_1569, &_call_f_setPen_1569);
}

// void QPainter::setRenderHint(QPainter::RenderHint hint, bool on)


static void _init_f_setRenderHint_3123 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint");
  decl->add_arg<const qt_gsi::Converter<QPainter::RenderHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRenderHint_3123 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPainter::RenderHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QPainter::RenderHint>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QPainter *)cls)->setRenderHint (qt_gsi::QtToCppAdaptor<QPainter::RenderHint>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setRenderHint_3123 ()
{
  return new qt_gsi::GenericMethod ("setRenderHint", "@brief Method void QPainter::setRenderHint(QPainter::RenderHint hint, bool on)\n", false, &_init_f_setRenderHint_3123, &_call_f_setRenderHint_3123);
}

// void QPainter::setRenderHints(QFlags<QPainter::RenderHint> hints, bool on)


static void _init_f_setRenderHints_3819 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<const qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRenderHints_3819 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QPainter *)cls)->setRenderHints (qt_gsi::QtToCppAdaptor<QFlags<QPainter::RenderHint> >(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setRenderHints_3819 ()
{
  return new qt_gsi::GenericMethod ("setRenderHints", "@brief Method void QPainter::setRenderHints(QFlags<QPainter::RenderHint> hints, bool on)\n", false, &_init_f_setRenderHints_3819, &_call_f_setRenderHints_3819);
}

// void QPainter::setTransform(const QTransform &transform, bool combine)


static void _init_f_setTransform_3106 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("transform");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTransform_3106 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ((QPainter *)cls)->setTransform (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setTransform_3106 ()
{
  return new qt_gsi::GenericMethod ("setTransform", "@brief Method void QPainter::setTransform(const QTransform &transform, bool combine)\n", false, &_init_f_setTransform_3106, &_call_f_setTransform_3106);
}

// void QPainter::setViewTransformEnabled(bool enable)


static void _init_f_setViewTransformEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewTransformEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPainter *)cls)->setViewTransformEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setViewTransformEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setViewTransformEnabled|viewTransformEnabled=", "@brief Method void QPainter::setViewTransformEnabled(bool enable)\n", false, &_init_f_setViewTransformEnabled_864, &_call_f_setViewTransformEnabled_864);
}

// void QPainter::setViewport(const QRect &viewport)


static void _init_f_setViewport_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewport_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QPainter *)cls)->setViewport (arg1);
}

static qt_gsi::GenericMethod *_create_f_setViewport_1792 ()
{
  return new qt_gsi::GenericMethod ("setViewport|viewport=", "@brief Method void QPainter::setViewport(const QRect &viewport)\n", false, &_init_f_setViewport_1792, &_call_f_setViewport_1792);
}

// void QPainter::setViewport(int x, int y, int w, int h)


static void _init_f_setViewport_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setViewport_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QPainter *)cls)->setViewport (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setViewport_2744 ()
{
  return new qt_gsi::GenericMethod ("setViewport", "@brief Method void QPainter::setViewport(int x, int y, int w, int h)\n", false, &_init_f_setViewport_2744, &_call_f_setViewport_2744);
}

// void QPainter::setWindow(const QRect &window)


static void _init_f_setWindow_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("window");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindow_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QPainter *)cls)->setWindow (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWindow_1792 ()
{
  return new qt_gsi::GenericMethod ("setWindow|window=", "@brief Method void QPainter::setWindow(const QRect &window)\n", false, &_init_f_setWindow_1792, &_call_f_setWindow_1792);
}

// void QPainter::setWindow(int x, int y, int w, int h)


static void _init_f_setWindow_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setWindow_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QPainter *)cls)->setWindow (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setWindow_2744 ()
{
  return new qt_gsi::GenericMethod ("setWindow", "@brief Method void QPainter::setWindow(int x, int y, int w, int h)\n", false, &_init_f_setWindow_2744, &_call_f_setWindow_2744);
}

// void QPainter::setWorldMatrix(const QMatrix &matrix, bool combine)


static void _init_f_setWorldMatrix_2779 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setWorldMatrix_2779 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args.read<const QMatrix & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ((QPainter *)cls)->setWorldMatrix (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setWorldMatrix_2779 ()
{
  return new qt_gsi::GenericMethod ("setWorldMatrix", "@brief Method void QPainter::setWorldMatrix(const QMatrix &matrix, bool combine)\n", false, &_init_f_setWorldMatrix_2779, &_call_f_setWorldMatrix_2779);
}

// void QPainter::setWorldMatrixEnabled(bool enabled)


static void _init_f_setWorldMatrixEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWorldMatrixEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPainter *)cls)->setWorldMatrixEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWorldMatrixEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setWorldMatrixEnabled|worldMatrixEnabled=", "@brief Method void QPainter::setWorldMatrixEnabled(bool enabled)\n", false, &_init_f_setWorldMatrixEnabled_864, &_call_f_setWorldMatrixEnabled_864);
}

// void QPainter::setWorldTransform(const QTransform &matrix, bool combine)


static void _init_f_setWorldTransform_3106 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setWorldTransform_3106 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ((QPainter *)cls)->setWorldTransform (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setWorldTransform_3106 ()
{
  return new qt_gsi::GenericMethod ("setWorldTransform", "@brief Method void QPainter::setWorldTransform(const QTransform &matrix, bool combine)\n", false, &_init_f_setWorldTransform_3106, &_call_f_setWorldTransform_3106);
}

// void QPainter::shear(double sh, double sv)


static void _init_f_shear_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sh");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sv");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_shear_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QPainter *)cls)->shear (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_shear_2034 ()
{
  return new qt_gsi::GenericMethod ("shear", "@brief Method void QPainter::shear(double sh, double sv)\n", false, &_init_f_shear_2034, &_call_f_shear_2034);
}

// void QPainter::strokePath(const QPainterPath &path, const QPen &pen)


static void _init_f_strokePath_4091 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen");
  decl->add_arg<const QPen & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_strokePath_4091 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const QPen &arg2 = args.read<const QPen & > ();
  ((QPainter *)cls)->strokePath (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_strokePath_4091 ()
{
  return new qt_gsi::GenericMethod ("strokePath", "@brief Method void QPainter::strokePath(const QPainterPath &path, const QPen &pen)\n", false, &_init_f_strokePath_4091, &_call_f_strokePath_4091);
}

// bool QPainter::testRenderHint(QPainter::RenderHint hint)


static void _init_f_testRenderHint_c2367 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint");
  decl->add_arg<const qt_gsi::Converter<QPainter::RenderHint>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testRenderHint_c2367 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPainter::RenderHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QPainter::RenderHint>::target_type & > ();
  ret.write<bool > ((bool)((QPainter *)cls)->testRenderHint (qt_gsi::QtToCppAdaptor<QPainter::RenderHint>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_testRenderHint_c2367 ()
{
  return new qt_gsi::GenericMethod ("testRenderHint", "@brief Method bool QPainter::testRenderHint(QPainter::RenderHint hint)\n", true, &_init_f_testRenderHint_c2367, &_call_f_testRenderHint_c2367);
}

// const QTransform &QPainter::transform()


static void _init_f_transform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QTransform & > ();
}

static void _call_f_transform_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QTransform & > ((const QTransform &)((QPainter *)cls)->transform ());
}

static qt_gsi::GenericMethod *_create_f_transform_c0 ()
{
  return new qt_gsi::GenericMethod (":transform", "@brief Method const QTransform &QPainter::transform()\n", true, &_init_f_transform_c0, &_call_f_transform_c0);
}

// void QPainter::translate(const QPointF &offset)


static void _init_f_translate_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QPainter *)cls)->translate (arg1);
}

static qt_gsi::GenericMethod *_create_f_translate_1986 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QPainter::translate(const QPointF &offset)\n", false, &_init_f_translate_1986, &_call_f_translate_1986);
}

// void QPainter::translate(const QPoint &offset)


static void _init_f_translate_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ((QPainter *)cls)->translate (arg1);
}

static qt_gsi::GenericMethod *_create_f_translate_1916 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QPainter::translate(const QPoint &offset)\n", false, &_init_f_translate_1916, &_call_f_translate_1916);
}

// void QPainter::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QPainter *)cls)->translate (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_translate_2034 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QPainter::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
}

// bool QPainter::viewTransformEnabled()


static void _init_f_viewTransformEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_viewTransformEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPainter *)cls)->viewTransformEnabled ());
}

static qt_gsi::GenericMethod *_create_f_viewTransformEnabled_c0 ()
{
  return new qt_gsi::GenericMethod (":viewTransformEnabled", "@brief Method bool QPainter::viewTransformEnabled()\n", true, &_init_f_viewTransformEnabled_c0, &_call_f_viewTransformEnabled_c0);
}

// QRect QPainter::viewport()


static void _init_f_viewport_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_viewport_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QPainter *)cls)->viewport ());
}

static qt_gsi::GenericMethod *_create_f_viewport_c0 ()
{
  return new qt_gsi::GenericMethod (":viewport", "@brief Method QRect QPainter::viewport()\n", true, &_init_f_viewport_c0, &_call_f_viewport_c0);
}

// QRect QPainter::window()


static void _init_f_window_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_window_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QPainter *)cls)->window ());
}

static qt_gsi::GenericMethod *_create_f_window_c0 ()
{
  return new qt_gsi::GenericMethod (":window", "@brief Method QRect QPainter::window()\n", true, &_init_f_window_c0, &_call_f_window_c0);
}

// const QMatrix &QPainter::worldMatrix()


static void _init_f_worldMatrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMatrix & > ();
}

static void _call_f_worldMatrix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMatrix & > ((const QMatrix &)((QPainter *)cls)->worldMatrix ());
}

static qt_gsi::GenericMethod *_create_f_worldMatrix_c0 ()
{
  return new qt_gsi::GenericMethod (":worldMatrix", "@brief Method const QMatrix &QPainter::worldMatrix()\n", true, &_init_f_worldMatrix_c0, &_call_f_worldMatrix_c0);
}

// bool QPainter::worldMatrixEnabled()


static void _init_f_worldMatrixEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_worldMatrixEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPainter *)cls)->worldMatrixEnabled ());
}

static qt_gsi::GenericMethod *_create_f_worldMatrixEnabled_c0 ()
{
  return new qt_gsi::GenericMethod (":worldMatrixEnabled", "@brief Method bool QPainter::worldMatrixEnabled()\n", true, &_init_f_worldMatrixEnabled_c0, &_call_f_worldMatrixEnabled_c0);
}

// const QTransform &QPainter::worldTransform()


static void _init_f_worldTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QTransform & > ();
}

static void _call_f_worldTransform_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QTransform & > ((const QTransform &)((QPainter *)cls)->worldTransform ());
}

static qt_gsi::GenericMethod *_create_f_worldTransform_c0 ()
{
  return new qt_gsi::GenericMethod (":worldTransform", "@brief Method const QTransform &QPainter::worldTransform()\n", true, &_init_f_worldTransform_c0, &_call_f_worldTransform_c0);
}

// static QPaintDevice *QPainter::redirected(const QPaintDevice *device, QPoint *offset)


static void _init_f_redirected_3615 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<const QPaintDevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "0");
  decl->add_arg<QPoint * > (argspec_1);
  decl->set_return<QPaintDevice * > ();
}

static void _call_f_redirected_3615 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPaintDevice *arg1 = args.read<const QPaintDevice * > ();
  QPoint *arg2 = args ? args.read<QPoint * > () : (QPoint *)(0);
  ret.write<QPaintDevice * > ((QPaintDevice *)QPainter::redirected (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_redirected_3615 ()
{
  return new qt_gsi::GenericStaticMethod ("redirected", "@brief Static method QPaintDevice *QPainter::redirected(const QPaintDevice *device, QPoint *offset)\nThis method is static and can be called without an instance.", &_init_f_redirected_3615, &_call_f_redirected_3615);
}

// static void QPainter::restoreRedirected(const QPaintDevice *device)


static void _init_f_restoreRedirected_2498 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<const QPaintDevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_restoreRedirected_2498 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPaintDevice *arg1 = args.read<const QPaintDevice * > ();
  QPainter::restoreRedirected (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_restoreRedirected_2498 ()
{
  return new qt_gsi::GenericStaticMethod ("restoreRedirected", "@brief Static method void QPainter::restoreRedirected(const QPaintDevice *device)\nThis method is static and can be called without an instance.", &_init_f_restoreRedirected_2498, &_call_f_restoreRedirected_2498);
}

// static void QPainter::setRedirected(const QPaintDevice *device, QPaintDevice *replacement, const QPoint &offset)


static void _init_f_setRedirected_6001 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<const QPaintDevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("replacement");
  decl->add_arg<QPaintDevice * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("offset", true, "QPoint()");
  decl->add_arg<const QPoint & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setRedirected_6001 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPaintDevice *arg1 = args.read<const QPaintDevice * > ();
  QPaintDevice *arg2 = args.read<QPaintDevice * > ();
  const QPoint &arg3 = args ? args.read<const QPoint & > () : (const QPoint &)(QPoint());
  QPainter::setRedirected (arg1, arg2, arg3);
}

static qt_gsi::GenericStaticMethod *_create_f_setRedirected_6001 ()
{
  return new qt_gsi::GenericStaticMethod ("setRedirected", "@brief Static method void QPainter::setRedirected(const QPaintDevice *device, QPaintDevice *replacement, const QPoint &offset)\nThis method is static and can be called without an instance.", &_init_f_setRedirected_6001, &_call_f_setRedirected_6001);
}


namespace gsi
{
gsi::Class<QPainter> decl_QPainter ("QPainter",
  gsi::Methods(_create_ctor_QPainter_0 ()) +
  gsi::Methods(_create_ctor_QPainter_1803 ()) +
  gsi::Methods(_create_f_background_c0 ()) +
  gsi::Methods(_create_f_backgroundMode_c0 ()) +
  gsi::Methods(_create_f_begin_1803 ()) +
  gsi::Methods(_create_f_beginNativePainting_0 ()) +
  gsi::Methods(_create_f_boundingRect_4438 ()) +
  gsi::Methods(_create_f_boundingRect_4368 ()) +
  gsi::Methods(_create_f_boundingRect_5320 ()) +
  gsi::Methods(_create_f_boundingRect_6119 ()) +
  gsi::Methods(_create_f_brush_c0 ()) +
  gsi::Methods(_create_f_brushOrigin_c0 ()) +
  gsi::Methods(_create_f_clipPath_c0 ()) +
  gsi::Methods(_create_f_clipRegion_c0 ()) +
  gsi::Methods(_create_f_combinedMatrix_c0 ()) +
  gsi::Methods(_create_f_combinedTransform_c0 ()) +
  gsi::Methods(_create_f_compositionMode_c0 ()) +
  gsi::Methods(_create_f_device_c0 ()) +
  gsi::Methods(_create_f_deviceMatrix_c0 ()) +
  gsi::Methods(_create_f_deviceTransform_c0 ()) +
  gsi::Methods(_create_f_drawArc_3180 ()) +
  gsi::Methods(_create_f_drawArc_3110 ()) +
  gsi::Methods(_create_f_drawArc_4062 ()) +
  gsi::Methods(_create_f_drawChord_3180 ()) +
  gsi::Methods(_create_f_drawChord_4062 ()) +
  gsi::Methods(_create_f_drawChord_3110 ()) +
  gsi::Methods(_create_f_drawConvexPolygon_2208 ()) +
  gsi::Methods(_create_f_drawConvexPolygon_2138 ()) +
  gsi::Methods(_create_f_drawEllipse_1862 ()) +
  gsi::Methods(_create_f_drawEllipse_1792 ()) +
  gsi::Methods(_create_f_drawEllipse_2744 ()) +
  gsi::Methods(_create_f_drawEllipse_3912 ()) +
  gsi::Methods(_create_f_drawEllipse_3234 ()) +
  gsi::Methods(_create_f_drawImage_8645 ()) +
  gsi::Methods(_create_f_drawImage_8505 ()) +
  gsi::Methods(_create_f_drawImage_8769 ()) +
  gsi::Methods(_create_f_drawImage_8629 ()) +
  gsi::Methods(_create_f_drawImage_3631 ()) +
  gsi::Methods(_create_f_drawImage_3561 ()) +
  gsi::Methods(_create_f_drawImage_3755 ()) +
  gsi::Methods(_create_f_drawImage_3685 ()) +
  gsi::Methods(_create_f_drawImage_9091 ()) +
  gsi::Methods(_create_f_drawLine_1856 ()) +
  gsi::Methods(_create_f_drawLine_1786 ()) +
  gsi::Methods(_create_f_drawLine_2744 ()) +
  gsi::Methods(_create_f_drawLine_3724 ()) +
  gsi::Methods(_create_f_drawLine_3864 ()) +
  gsi::Methods(_create_f_drawLines_2686 ()) +
  gsi::Methods(_create_f_drawLines_2816 ()) +
  gsi::Methods(_create_f_drawLines_2616 ()) +
  gsi::Methods(_create_f_drawLines_2746 ()) +
  gsi::Methods(_create_f_drawPath_2514 ()) +
  gsi::Methods(_create_f_drawPicture_4004 ()) +
  gsi::Methods(_create_f_drawPicture_3444 ()) +
  gsi::Methods(_create_f_drawPicture_3934 ()) +
  gsi::Methods(_create_f_drawPie_3180 ()) +
  gsi::Methods(_create_f_drawPie_4062 ()) +
  gsi::Methods(_create_f_drawPie_3110 ()) +
  gsi::Methods(_create_f_drawPixmap_5525 ()) +
  gsi::Methods(_create_f_drawPixmap_5385 ()) +
  gsi::Methods(_create_f_drawPixmap_7289 ()) +
  gsi::Methods(_create_f_drawPixmap_5971 ()) +
  gsi::Methods(_create_f_drawPixmap_5649 ()) +
  gsi::Methods(_create_f_drawPixmap_5509 ()) +
  gsi::Methods(_create_f_drawPixmap_3895 ()) +
  gsi::Methods(_create_f_drawPixmap_3825 ()) +
  gsi::Methods(_create_f_drawPixmap_3335 ()) +
  gsi::Methods(_create_f_drawPixmap_3701 ()) +
  gsi::Methods(_create_f_drawPixmap_4653 ()) +
  gsi::Methods(_create_f_drawPoint_1986 ()) +
  gsi::Methods(_create_f_drawPoint_1916 ()) +
  gsi::Methods(_create_f_drawPoint_1426 ()) +
  gsi::Methods(_create_f_drawPoints_2208 ()) +
  gsi::Methods(_create_f_drawPoints_2138 ()) +
  gsi::Methods(_create_f_drawPolygon_3648 ()) +
  gsi::Methods(_create_f_drawPolygon_3578 ()) +
  gsi::Methods(_create_f_drawPolyline_2208 ()) +
  gsi::Methods(_create_f_drawPolyline_2138 ()) +
  gsi::Methods(_create_f_drawRect_1862 ()) +
  gsi::Methods(_create_f_drawRect_2744 ()) +
  gsi::Methods(_create_f_drawRect_1792 ()) +
  gsi::Methods(_create_f_drawRects_2692 ()) +
  gsi::Methods(_create_f_drawRects_2622 ()) +
  gsi::Methods(_create_f_drawRoundRect_3180 ()) +
  gsi::Methods(_create_f_drawRoundRect_4062 ()) +
  gsi::Methods(_create_f_drawRoundRect_3110 ()) +
  gsi::Methods(_create_f_drawRoundedRect_5229 ()) +
  gsi::Methods(_create_f_drawRoundedRect_6111 ()) +
  gsi::Methods(_create_f_drawRoundedRect_5159 ()) +
  gsi::Methods(_create_f_drawText_3903 ()) +
  gsi::Methods(_create_f_drawText_3833 ()) +
  gsi::Methods(_create_f_drawText_3343 ()) +
  gsi::Methods(_create_f_drawText_5221 ()) +
  gsi::Methods(_create_f_drawText_5501 ()) +
  gsi::Methods(_create_f_drawText_5361 ()) +
  gsi::Methods(_create_f_drawText_6313 ()) +
  gsi::Methods(_create_f_drawText_6119 ()) +
  gsi::Methods(_create_f_drawTextItem_4092 ()) +
  gsi::Methods(_create_f_drawTextItem_3532 ()) +
  gsi::Methods(_create_f_drawTextItem_4022 ()) +
  gsi::Methods(_create_f_drawTiledPixmap_5649 ()) +
  gsi::Methods(_create_f_drawTiledPixmap_5971 ()) +
  gsi::Methods(_create_f_drawTiledPixmap_5509 ()) +
  gsi::Methods(_create_f_end_0 ()) +
  gsi::Methods(_create_f_endNativePainting_0 ()) +
  gsi::Methods(_create_f_eraseRect_1862 ()) +
  gsi::Methods(_create_f_eraseRect_2744 ()) +
  gsi::Methods(_create_f_eraseRect_1792 ()) +
  gsi::Methods(_create_f_fillPath_4316 ()) +
  gsi::Methods(_create_f_fillRect_3664 ()) +
  gsi::Methods(_create_f_fillRect_4546 ()) +
  gsi::Methods(_create_f_fillRect_3594 ()) +
  gsi::Methods(_create_f_fillRect_3659 ()) +
  gsi::Methods(_create_f_fillRect_4541 ()) +
  gsi::Methods(_create_f_fillRect_3589 ()) +
  gsi::Methods(_create_f_fillRect_4489 ()) +
  gsi::Methods(_create_f_fillRect_3537 ()) +
  gsi::Methods(_create_f_fillRect_3607 ()) +
  gsi::Methods(_create_f_fillRect_4430 ()) +
  gsi::Methods(_create_f_fillRect_3478 ()) +
  gsi::Methods(_create_f_fillRect_3548 ()) +
  gsi::Methods(_create_f_font_c0 ()) +
  gsi::Methods(_create_f_fontInfo_c0 ()) +
  gsi::Methods(_create_f_fontMetrics_c0 ()) +
  gsi::Methods(_create_f_hasClipping_c0 ()) +
  gsi::Methods(_create_f_initFrom_2010 ()) +
  gsi::Methods(_create_f_isActive_c0 ()) +
  gsi::Methods(_create_f_layoutDirection_c0 ()) +
  gsi::Methods(_create_f_matrix_c0 ()) +
  gsi::Methods(_create_f_matrixEnabled_c0 ()) +
  gsi::Methods(_create_f_opacity_c0 ()) +
  gsi::Methods(_create_f_paintEngine_c0 ()) +
  gsi::Methods(_create_f_pen_c0 ()) +
  gsi::Methods(_create_f_renderHints_c0 ()) +
  gsi::Methods(_create_f_resetMatrix_0 ()) +
  gsi::Methods(_create_f_resetTransform_0 ()) +
  gsi::Methods(_create_f_restore_0 ()) +
  gsi::Methods(_create_f_rotate_1071 ()) +
  gsi::Methods(_create_f_save_0 ()) +
  gsi::Methods(_create_f_scale_2034 ()) +
  gsi::Methods(_create_f_setBackground_1910 ()) +
  gsi::Methods(_create_f_setBackgroundMode_1275 ()) +
  gsi::Methods(_create_f_setBrush_1910 ()) +
  gsi::Methods(_create_f_setBrush_1794 ()) +
  gsi::Methods(_create_f_setBrushOrigin_1426 ()) +
  gsi::Methods(_create_f_setBrushOrigin_1916 ()) +
  gsi::Methods(_create_f_setBrushOrigin_1986 ()) +
  gsi::Methods(_create_f_setClipPath_4492 ()) +
  gsi::Methods(_create_f_setClipRect_3840 ()) +
  gsi::Methods(_create_f_setClipRect_3770 ()) +
  gsi::Methods(_create_f_setClipRect_4722 ()) +
  gsi::Methods(_create_f_setClipRegion_3984 ()) +
  gsi::Methods(_create_f_setClipping_864 ()) +
  gsi::Methods(_create_f_setCompositionMode_2917 ()) +
  gsi::Methods(_create_f_setFont_1801 ()) +
  gsi::Methods(_create_f_setLayoutDirection_2316 ()) +
  gsi::Methods(_create_f_setMatrix_2779 ()) +
  gsi::Methods(_create_f_setMatrixEnabled_864 ()) +
  gsi::Methods(_create_f_setOpacity_1071 ()) +
  gsi::Methods(_create_f_setPen_1905 ()) +
  gsi::Methods(_create_f_setPen_1685 ()) +
  gsi::Methods(_create_f_setPen_1569 ()) +
  gsi::Methods(_create_f_setRenderHint_3123 ()) +
  gsi::Methods(_create_f_setRenderHints_3819 ()) +
  gsi::Methods(_create_f_setTransform_3106 ()) +
  gsi::Methods(_create_f_setViewTransformEnabled_864 ()) +
  gsi::Methods(_create_f_setViewport_1792 ()) +
  gsi::Methods(_create_f_setViewport_2744 ()) +
  gsi::Methods(_create_f_setWindow_1792 ()) +
  gsi::Methods(_create_f_setWindow_2744 ()) +
  gsi::Methods(_create_f_setWorldMatrix_2779 ()) +
  gsi::Methods(_create_f_setWorldMatrixEnabled_864 ()) +
  gsi::Methods(_create_f_setWorldTransform_3106 ()) +
  gsi::Methods(_create_f_shear_2034 ()) +
  gsi::Methods(_create_f_strokePath_4091 ()) +
  gsi::Methods(_create_f_testRenderHint_c2367 ()) +
  gsi::Methods(_create_f_transform_c0 ()) +
  gsi::Methods(_create_f_translate_1986 ()) +
  gsi::Methods(_create_f_translate_1916 ()) +
  gsi::Methods(_create_f_translate_2034 ()) +
  gsi::Methods(_create_f_viewTransformEnabled_c0 ()) +
  gsi::Methods(_create_f_viewport_c0 ()) +
  gsi::Methods(_create_f_window_c0 ()) +
  gsi::Methods(_create_f_worldMatrix_c0 ()) +
  gsi::Methods(_create_f_worldMatrixEnabled_c0 ()) +
  gsi::Methods(_create_f_worldTransform_c0 ()) +
  gsi::Methods(_create_f_redirected_3615 ()) +
  gsi::Methods(_create_f_restoreRedirected_2498 ()) +
  gsi::Methods(_create_f_setRedirected_6001 ()),
  "@qt\n@brief Binding of QPainter");

}


//  Implementation of the enum wrapper class for QPainter::CompositionMode
namespace qt_gsi
{

static QPainter_CompositionMode_Enum *c_1_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_SourceOver); }
static QPainter_CompositionMode_Enum *c_2_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_DestinationOver); }
static QPainter_CompositionMode_Enum *c_3_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Clear); }
static QPainter_CompositionMode_Enum *c_4_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Source); }
static QPainter_CompositionMode_Enum *c_5_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Destination); }
static QPainter_CompositionMode_Enum *c_6_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_SourceIn); }
static QPainter_CompositionMode_Enum *c_7_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_DestinationIn); }
static QPainter_CompositionMode_Enum *c_8_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_SourceOut); }
static QPainter_CompositionMode_Enum *c_9_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_DestinationOut); }
static QPainter_CompositionMode_Enum *c_10_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_SourceAtop); }
static QPainter_CompositionMode_Enum *c_11_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_DestinationAtop); }
static QPainter_CompositionMode_Enum *c_12_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Xor); }
static QPainter_CompositionMode_Enum *c_13_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Plus); }
static QPainter_CompositionMode_Enum *c_14_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Multiply); }
static QPainter_CompositionMode_Enum *c_15_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Screen); }
static QPainter_CompositionMode_Enum *c_16_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Overlay); }
static QPainter_CompositionMode_Enum *c_17_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Darken); }
static QPainter_CompositionMode_Enum *c_18_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Lighten); }
static QPainter_CompositionMode_Enum *c_19_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_ColorDodge); }
static QPainter_CompositionMode_Enum *c_20_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_ColorBurn); }
static QPainter_CompositionMode_Enum *c_21_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_HardLight); }
static QPainter_CompositionMode_Enum *c_22_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_SoftLight); }
static QPainter_CompositionMode_Enum *c_23_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Difference); }
static QPainter_CompositionMode_Enum *c_24_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::CompositionMode_Exclusion); }
static QPainter_CompositionMode_Enum *c_25_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::RasterOp_SourceOrDestination); }
static QPainter_CompositionMode_Enum *c_26_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::RasterOp_SourceAndDestination); }
static QPainter_CompositionMode_Enum *c_27_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::RasterOp_SourceXorDestination); }
static QPainter_CompositionMode_Enum *c_28_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::RasterOp_NotSourceAndNotDestination); }
static QPainter_CompositionMode_Enum *c_29_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::RasterOp_NotSourceOrNotDestination); }
static QPainter_CompositionMode_Enum *c_30_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::RasterOp_NotSourceXorDestination); }
static QPainter_CompositionMode_Enum *c_31_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::RasterOp_NotSource); }
static QPainter_CompositionMode_Enum *c_32_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::RasterOp_NotSourceAndDestination); }
static QPainter_CompositionMode_Enum *c_33_QPainter_CompositionMode_Enum () { return new QPainter_CompositionMode_Enum (QPainter::RasterOp_SourceAndNotDestination); }

static gsi::Methods mkdefs_QPainter_CompositionMode () {
  return
    gsi::constant ("CompositionMode_SourceOver", &qt_gsi::c_1_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_SourceOver") +
    gsi::constant ("CompositionMode_DestinationOver", &qt_gsi::c_2_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_DestinationOver") +
    gsi::constant ("CompositionMode_Clear", &qt_gsi::c_3_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Clear") +
    gsi::constant ("CompositionMode_Source", &qt_gsi::c_4_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Source") +
    gsi::constant ("CompositionMode_Destination", &qt_gsi::c_5_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Destination") +
    gsi::constant ("CompositionMode_SourceIn", &qt_gsi::c_6_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_SourceIn") +
    gsi::constant ("CompositionMode_DestinationIn", &qt_gsi::c_7_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_DestinationIn") +
    gsi::constant ("CompositionMode_SourceOut", &qt_gsi::c_8_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_SourceOut") +
    gsi::constant ("CompositionMode_DestinationOut", &qt_gsi::c_9_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_DestinationOut") +
    gsi::constant ("CompositionMode_SourceAtop", &qt_gsi::c_10_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_SourceAtop") +
    gsi::constant ("CompositionMode_DestinationAtop", &qt_gsi::c_11_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_DestinationAtop") +
    gsi::constant ("CompositionMode_Xor", &qt_gsi::c_12_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Xor") +
    gsi::constant ("CompositionMode_Plus", &qt_gsi::c_13_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Plus") +
    gsi::constant ("CompositionMode_Multiply", &qt_gsi::c_14_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Multiply") +
    gsi::constant ("CompositionMode_Screen", &qt_gsi::c_15_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Screen") +
    gsi::constant ("CompositionMode_Overlay", &qt_gsi::c_16_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Overlay") +
    gsi::constant ("CompositionMode_Darken", &qt_gsi::c_17_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Darken") +
    gsi::constant ("CompositionMode_Lighten", &qt_gsi::c_18_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Lighten") +
    gsi::constant ("CompositionMode_ColorDodge", &qt_gsi::c_19_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_ColorDodge") +
    gsi::constant ("CompositionMode_ColorBurn", &qt_gsi::c_20_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_ColorBurn") +
    gsi::constant ("CompositionMode_HardLight", &qt_gsi::c_21_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_HardLight") +
    gsi::constant ("CompositionMode_SoftLight", &qt_gsi::c_22_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_SoftLight") +
    gsi::constant ("CompositionMode_Difference", &qt_gsi::c_23_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Difference") +
    gsi::constant ("CompositionMode_Exclusion", &qt_gsi::c_24_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::CompositionMode_Exclusion") +
    gsi::constant ("RasterOp_SourceOrDestination", &qt_gsi::c_25_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::RasterOp_SourceOrDestination") +
    gsi::constant ("RasterOp_SourceAndDestination", &qt_gsi::c_26_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::RasterOp_SourceAndDestination") +
    gsi::constant ("RasterOp_SourceXorDestination", &qt_gsi::c_27_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::RasterOp_SourceXorDestination") +
    gsi::constant ("RasterOp_NotSourceAndNotDestination", &qt_gsi::c_28_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::RasterOp_NotSourceAndNotDestination") +
    gsi::constant ("RasterOp_NotSourceOrNotDestination", &qt_gsi::c_29_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::RasterOp_NotSourceOrNotDestination") +
    gsi::constant ("RasterOp_NotSourceXorDestination", &qt_gsi::c_30_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::RasterOp_NotSourceXorDestination") +
    gsi::constant ("RasterOp_NotSource", &qt_gsi::c_31_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::RasterOp_NotSource") +
    gsi::constant ("RasterOp_NotSourceAndDestination", &qt_gsi::c_32_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::RasterOp_NotSourceAndDestination") +
    gsi::constant ("RasterOp_SourceAndNotDestination", &qt_gsi::c_33_QPainter_CompositionMode_Enum, "@brief Enum constant QPainter::RasterOp_SourceAndNotDestination");
}

static std::string to_s_QPainter_CompositionMode_Enum (const QPainter_CompositionMode_Enum *e)
{
  if (e->value () == QPainter::CompositionMode_SourceOver) { return tl::sprintf ("CompositionMode_SourceOver (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_DestinationOver) { return tl::sprintf ("CompositionMode_DestinationOver (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Clear) { return tl::sprintf ("CompositionMode_Clear (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Source) { return tl::sprintf ("CompositionMode_Source (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Destination) { return tl::sprintf ("CompositionMode_Destination (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_SourceIn) { return tl::sprintf ("CompositionMode_SourceIn (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_DestinationIn) { return tl::sprintf ("CompositionMode_DestinationIn (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_SourceOut) { return tl::sprintf ("CompositionMode_SourceOut (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_DestinationOut) { return tl::sprintf ("CompositionMode_DestinationOut (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_SourceAtop) { return tl::sprintf ("CompositionMode_SourceAtop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_DestinationAtop) { return tl::sprintf ("CompositionMode_DestinationAtop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Xor) { return tl::sprintf ("CompositionMode_Xor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Plus) { return tl::sprintf ("CompositionMode_Plus (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Multiply) { return tl::sprintf ("CompositionMode_Multiply (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Screen) { return tl::sprintf ("CompositionMode_Screen (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Overlay) { return tl::sprintf ("CompositionMode_Overlay (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Darken) { return tl::sprintf ("CompositionMode_Darken (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Lighten) { return tl::sprintf ("CompositionMode_Lighten (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_ColorDodge) { return tl::sprintf ("CompositionMode_ColorDodge (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_ColorBurn) { return tl::sprintf ("CompositionMode_ColorBurn (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_HardLight) { return tl::sprintf ("CompositionMode_HardLight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_SoftLight) { return tl::sprintf ("CompositionMode_SoftLight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Difference) { return tl::sprintf ("CompositionMode_Difference (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::CompositionMode_Exclusion) { return tl::sprintf ("CompositionMode_Exclusion (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::RasterOp_SourceOrDestination) { return tl::sprintf ("RasterOp_SourceOrDestination (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::RasterOp_SourceAndDestination) { return tl::sprintf ("RasterOp_SourceAndDestination (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::RasterOp_SourceXorDestination) { return tl::sprintf ("RasterOp_SourceXorDestination (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::RasterOp_NotSourceAndNotDestination) { return tl::sprintf ("RasterOp_NotSourceAndNotDestination (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::RasterOp_NotSourceOrNotDestination) { return tl::sprintf ("RasterOp_NotSourceOrNotDestination (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::RasterOp_NotSourceXorDestination) { return tl::sprintf ("RasterOp_NotSourceXorDestination (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::RasterOp_NotSource) { return tl::sprintf ("RasterOp_NotSource (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::RasterOp_NotSourceAndDestination) { return tl::sprintf ("RasterOp_NotSourceAndDestination (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::RasterOp_SourceAndNotDestination) { return tl::sprintf ("RasterOp_SourceAndNotDestination (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPainter_CompositionMode_Enum (const QPainter_CompositionMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPainter_CompositionMode_Enum *from_i_QPainter_CompositionMode_Enum (unsigned int i)
{
  return new QPainter_CompositionMode_Enum ((QPainter::CompositionMode) i);
}

static bool equalQPainter_CompositionMode_Enum (const QPainter_CompositionMode_Enum *e, QPainter_CompositionMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPainter_CompositionMode_Enum (const QPainter_CompositionMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPainter_CompositionMode_Enums oropQPainter_CompositionMode_Enums (const QPainter_CompositionMode_Enums *e, const QPainter_CompositionMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPainter_CompositionMode_Enums andopQPainter_CompositionMode_Enums (const QPainter_CompositionMode_Enums *e, const QPainter_CompositionMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPainter_CompositionMode_Enums xoropQPainter_CompositionMode_Enums (const QPainter_CompositionMode_Enums *e, const QPainter_CompositionMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPainter_CompositionMode_Enums (const QPainter_CompositionMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QPainter::CompositionMode_SourceOver)) { if (!l.empty ()) l += "|"; l += "CompositionMode_SourceOver"; }
  if (e->testFlag (QPainter::CompositionMode_DestinationOver)) { if (!l.empty ()) l += "|"; l += "CompositionMode_DestinationOver"; }
  if (e->testFlag (QPainter::CompositionMode_Clear)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Clear"; }
  if (e->testFlag (QPainter::CompositionMode_Source)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Source"; }
  if (e->testFlag (QPainter::CompositionMode_Destination)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Destination"; }
  if (e->testFlag (QPainter::CompositionMode_SourceIn)) { if (!l.empty ()) l += "|"; l += "CompositionMode_SourceIn"; }
  if (e->testFlag (QPainter::CompositionMode_DestinationIn)) { if (!l.empty ()) l += "|"; l += "CompositionMode_DestinationIn"; }
  if (e->testFlag (QPainter::CompositionMode_SourceOut)) { if (!l.empty ()) l += "|"; l += "CompositionMode_SourceOut"; }
  if (e->testFlag (QPainter::CompositionMode_DestinationOut)) { if (!l.empty ()) l += "|"; l += "CompositionMode_DestinationOut"; }
  if (e->testFlag (QPainter::CompositionMode_SourceAtop)) { if (!l.empty ()) l += "|"; l += "CompositionMode_SourceAtop"; }
  if (e->testFlag (QPainter::CompositionMode_DestinationAtop)) { if (!l.empty ()) l += "|"; l += "CompositionMode_DestinationAtop"; }
  if (e->testFlag (QPainter::CompositionMode_Xor)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Xor"; }
  if (e->testFlag (QPainter::CompositionMode_Plus)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Plus"; }
  if (e->testFlag (QPainter::CompositionMode_Multiply)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Multiply"; }
  if (e->testFlag (QPainter::CompositionMode_Screen)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Screen"; }
  if (e->testFlag (QPainter::CompositionMode_Overlay)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Overlay"; }
  if (e->testFlag (QPainter::CompositionMode_Darken)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Darken"; }
  if (e->testFlag (QPainter::CompositionMode_Lighten)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Lighten"; }
  if (e->testFlag (QPainter::CompositionMode_ColorDodge)) { if (!l.empty ()) l += "|"; l += "CompositionMode_ColorDodge"; }
  if (e->testFlag (QPainter::CompositionMode_ColorBurn)) { if (!l.empty ()) l += "|"; l += "CompositionMode_ColorBurn"; }
  if (e->testFlag (QPainter::CompositionMode_HardLight)) { if (!l.empty ()) l += "|"; l += "CompositionMode_HardLight"; }
  if (e->testFlag (QPainter::CompositionMode_SoftLight)) { if (!l.empty ()) l += "|"; l += "CompositionMode_SoftLight"; }
  if (e->testFlag (QPainter::CompositionMode_Difference)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Difference"; }
  if (e->testFlag (QPainter::CompositionMode_Exclusion)) { if (!l.empty ()) l += "|"; l += "CompositionMode_Exclusion"; }
  if (e->testFlag (QPainter::RasterOp_SourceOrDestination)) { if (!l.empty ()) l += "|"; l += "RasterOp_SourceOrDestination"; }
  if (e->testFlag (QPainter::RasterOp_SourceAndDestination)) { if (!l.empty ()) l += "|"; l += "RasterOp_SourceAndDestination"; }
  if (e->testFlag (QPainter::RasterOp_SourceXorDestination)) { if (!l.empty ()) l += "|"; l += "RasterOp_SourceXorDestination"; }
  if (e->testFlag (QPainter::RasterOp_NotSourceAndNotDestination)) { if (!l.empty ()) l += "|"; l += "RasterOp_NotSourceAndNotDestination"; }
  if (e->testFlag (QPainter::RasterOp_NotSourceOrNotDestination)) { if (!l.empty ()) l += "|"; l += "RasterOp_NotSourceOrNotDestination"; }
  if (e->testFlag (QPainter::RasterOp_NotSourceXorDestination)) { if (!l.empty ()) l += "|"; l += "RasterOp_NotSourceXorDestination"; }
  if (e->testFlag (QPainter::RasterOp_NotSource)) { if (!l.empty ()) l += "|"; l += "RasterOp_NotSource"; }
  if (e->testFlag (QPainter::RasterOp_NotSourceAndDestination)) { if (!l.empty ()) l += "|"; l += "RasterOp_NotSourceAndDestination"; }
  if (e->testFlag (QPainter::RasterOp_SourceAndNotDestination)) { if (!l.empty ()) l += "|"; l += "RasterOp_SourceAndNotDestination"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPainter_CompositionMode_Enums (const QPainter_CompositionMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPainter_CompositionMode_Enums (const QPainter_CompositionMode_Enums *e, const QPainter_CompositionMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPainter_CompositionMode_Enums> decl_QPainter_CompositionMode_Enums ("QPainter_QFlags_CompositionMode",
  gsi::method_ext ("|", &qt_gsi::oropQPainter_CompositionMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPainter_CompositionMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPainter_CompositionMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPainter_CompositionMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPainter_CompositionMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPainter_CompositionMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPainter::CompositionMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPainter_CompositionMode_Enum> decl_QPainter_CompositionMode_Enum (decl_QPainter_CompositionMode_Enums, "QPainter_CompositionMode",
  qt_gsi::mkdefs_QPainter_CompositionMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPainter_CompositionMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPainter_CompositionMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPainter_CompositionMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPainter_CompositionMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPainter_CompositionMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPainter::CompositionMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPainter> inject_QPainter_CompositionMode_Enum_in_parent (qt_gsi::mkdefs_QPainter_CompositionMode ());
static gsi::ClassExt<QPainter> decl_QPainter_CompositionMode_Enum_as_child (decl_QPainter_CompositionMode_Enum, "CompositionMode");

}


//  Implementation of the enum wrapper class for QPainter::RenderHint
namespace qt_gsi
{

static QPainter_RenderHint_Enum *c_1_QPainter_RenderHint_Enum () { return new QPainter_RenderHint_Enum (QPainter::Antialiasing); }
static QPainter_RenderHint_Enum *c_2_QPainter_RenderHint_Enum () { return new QPainter_RenderHint_Enum (QPainter::TextAntialiasing); }
static QPainter_RenderHint_Enum *c_3_QPainter_RenderHint_Enum () { return new QPainter_RenderHint_Enum (QPainter::SmoothPixmapTransform); }
static QPainter_RenderHint_Enum *c_4_QPainter_RenderHint_Enum () { return new QPainter_RenderHint_Enum (QPainter::HighQualityAntialiasing); }
static QPainter_RenderHint_Enum *c_5_QPainter_RenderHint_Enum () { return new QPainter_RenderHint_Enum (QPainter::NonCosmeticDefaultPen); }

static gsi::Methods mkdefs_QPainter_RenderHint () {
  return
    gsi::constant ("Antialiasing", &qt_gsi::c_1_QPainter_RenderHint_Enum, "@brief Enum constant QPainter::Antialiasing") +
    gsi::constant ("TextAntialiasing", &qt_gsi::c_2_QPainter_RenderHint_Enum, "@brief Enum constant QPainter::TextAntialiasing") +
    gsi::constant ("SmoothPixmapTransform", &qt_gsi::c_3_QPainter_RenderHint_Enum, "@brief Enum constant QPainter::SmoothPixmapTransform") +
    gsi::constant ("HighQualityAntialiasing", &qt_gsi::c_4_QPainter_RenderHint_Enum, "@brief Enum constant QPainter::HighQualityAntialiasing") +
    gsi::constant ("NonCosmeticDefaultPen", &qt_gsi::c_5_QPainter_RenderHint_Enum, "@brief Enum constant QPainter::NonCosmeticDefaultPen");
}

static std::string to_s_QPainter_RenderHint_Enum (const QPainter_RenderHint_Enum *e)
{
  if (e->value () == QPainter::Antialiasing) { return tl::sprintf ("Antialiasing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::TextAntialiasing) { return tl::sprintf ("TextAntialiasing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::SmoothPixmapTransform) { return tl::sprintf ("SmoothPixmapTransform (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::HighQualityAntialiasing) { return tl::sprintf ("HighQualityAntialiasing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPainter::NonCosmeticDefaultPen) { return tl::sprintf ("NonCosmeticDefaultPen (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPainter_RenderHint_Enum (const QPainter_RenderHint_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPainter_RenderHint_Enum *from_i_QPainter_RenderHint_Enum (unsigned int i)
{
  return new QPainter_RenderHint_Enum ((QPainter::RenderHint) i);
}

static bool equalQPainter_RenderHint_Enum (const QPainter_RenderHint_Enum *e, QPainter_RenderHint_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPainter_RenderHint_Enum (const QPainter_RenderHint_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPainter_RenderHint_Enums oropQPainter_RenderHint_Enums (const QPainter_RenderHint_Enums *e, const QPainter_RenderHint_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPainter_RenderHint_Enums andopQPainter_RenderHint_Enums (const QPainter_RenderHint_Enums *e, const QPainter_RenderHint_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPainter_RenderHint_Enums xoropQPainter_RenderHint_Enums (const QPainter_RenderHint_Enums *e, const QPainter_RenderHint_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPainter_RenderHint_Enums (const QPainter_RenderHint_Enums *e)
{
  std::string l;
  if (e->testFlag (QPainter::Antialiasing)) { if (!l.empty ()) l += "|"; l += "Antialiasing"; }
  if (e->testFlag (QPainter::TextAntialiasing)) { if (!l.empty ()) l += "|"; l += "TextAntialiasing"; }
  if (e->testFlag (QPainter::SmoothPixmapTransform)) { if (!l.empty ()) l += "|"; l += "SmoothPixmapTransform"; }
  if (e->testFlag (QPainter::HighQualityAntialiasing)) { if (!l.empty ()) l += "|"; l += "HighQualityAntialiasing"; }
  if (e->testFlag (QPainter::NonCosmeticDefaultPen)) { if (!l.empty ()) l += "|"; l += "NonCosmeticDefaultPen"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPainter_RenderHint_Enums (const QPainter_RenderHint_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPainter_RenderHint_Enums (const QPainter_RenderHint_Enums *e, const QPainter_RenderHint_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPainter_RenderHint_Enums> decl_QPainter_RenderHint_Enums ("QPainter_QFlags_RenderHint",
  gsi::method_ext ("|", &qt_gsi::oropQPainter_RenderHint_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPainter_RenderHint_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPainter_RenderHint_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPainter_RenderHint_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPainter_RenderHint_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPainter_RenderHint_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPainter::RenderHint> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPainter_RenderHint_Enum> decl_QPainter_RenderHint_Enum (decl_QPainter_RenderHint_Enums, "QPainter_RenderHint",
  qt_gsi::mkdefs_QPainter_RenderHint () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPainter_RenderHint_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPainter_RenderHint_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPainter_RenderHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPainter_RenderHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPainter_RenderHint_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPainter::RenderHint enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPainter> inject_QPainter_RenderHint_Enum_in_parent (qt_gsi::mkdefs_QPainter_RenderHint ());
static gsi::ClassExt<QPainter> decl_QPainter_RenderHint_Enum_as_child (decl_QPainter_RenderHint_Enum, "RenderHint");

}

