
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQNetworkReply.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQNetworkReply_EventAdaptor.h"
#include "gsiDeclQNetworkReply_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QNetworkReply

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QNetworkReply::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QNetworkReply::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QNetworkReply *)cls)->abort ();
}

static qt_gsi::GenericMethod *_create_f_abort_0 ()
{
  return new qt_gsi::GenericMethod ("abort", "@brief Method void QNetworkReply::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
}

// QVariant QNetworkReply::attribute(QNetworkRequest::Attribute code)


static void _init_f_attribute_c3072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("code");
  decl->add_arg<const qt_gsi::Converter<QNetworkRequest::Attribute>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_attribute_c3072 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QNetworkRequest::Attribute>::target_type & arg1 = args.read<const qt_gsi::Converter<QNetworkRequest::Attribute>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QNetworkReply *)cls)->attribute (qt_gsi::QtToCppAdaptor<QNetworkRequest::Attribute>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_attribute_c3072 ()
{
  return new qt_gsi::GenericMethod ("attribute", "@brief Method QVariant QNetworkReply::attribute(QNetworkRequest::Attribute code)\n", true, &_init_f_attribute_c3072, &_call_f_attribute_c3072);
}

// void QNetworkReply::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QNetworkReply *)cls)->close ();
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method void QNetworkReply::close()\nThis is a reimplementation of QIODevice::close", false, &_init_f_close_0, &_call_f_close_0);
}

// QNetworkReply::NetworkError QNetworkReply::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QNetworkReply::NetworkError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QNetworkReply::NetworkError>::target_type > ((qt_gsi::Converter<QNetworkReply::NetworkError>::target_type)qt_gsi::CppToQtAdaptor<QNetworkReply::NetworkError>(((QNetworkReply *)cls)->error ()));
}

static qt_gsi::GenericMethod *_create_f_error_c0 ()
{
  return new qt_gsi::GenericMethod ("error", "@brief Method QNetworkReply::NetworkError QNetworkReply::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
}

// bool QNetworkReply::hasRawHeader(const QByteArray &headerName)


static void _init_f_hasRawHeader_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("headerName");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasRawHeader_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<bool > ((bool)((QNetworkReply *)cls)->hasRawHeader (arg1));
}

static qt_gsi::GenericMethod *_create_f_hasRawHeader_c2309 ()
{
  return new qt_gsi::GenericMethod ("hasRawHeader", "@brief Method bool QNetworkReply::hasRawHeader(const QByteArray &headerName)\n", true, &_init_f_hasRawHeader_c2309, &_call_f_hasRawHeader_c2309);
}

// QVariant QNetworkReply::header(QNetworkRequest::KnownHeaders header)


static void _init_f_header_c3349 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("header");
  decl->add_arg<const qt_gsi::Converter<QNetworkRequest::KnownHeaders>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_header_c3349 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QNetworkRequest::KnownHeaders>::target_type & arg1 = args.read<const qt_gsi::Converter<QNetworkRequest::KnownHeaders>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QNetworkReply *)cls)->header (qt_gsi::QtToCppAdaptor<QNetworkRequest::KnownHeaders>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_header_c3349 ()
{
  return new qt_gsi::GenericMethod ("header", "@brief Method QVariant QNetworkReply::header(QNetworkRequest::KnownHeaders header)\n", true, &_init_f_header_c3349, &_call_f_header_c3349);
}

// void QNetworkReply::ignoreSslErrors(const QList<QSslError> &errors)


static void _init_f_ignoreSslErrors_2837 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("errors");
  decl->add_arg<const qt_gsi::Converter<QList<QSslError> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ignoreSslErrors_2837 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QSslError> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QSslError> >::target_type & > ();
  ((QNetworkReply *)cls)->ignoreSslErrors (qt_gsi::QtToCppAdaptor<QList<QSslError> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_ignoreSslErrors_2837 ()
{
  return new qt_gsi::GenericMethod ("ignoreSslErrors", "@brief Method void QNetworkReply::ignoreSslErrors(const QList<QSslError> &errors)\n", false, &_init_f_ignoreSslErrors_2837, &_call_f_ignoreSslErrors_2837);
}

// void QNetworkReply::ignoreSslErrors()


static void _init_f_ignoreSslErrors_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ignoreSslErrors_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QNetworkReply *)cls)->ignoreSslErrors ();
}

static qt_gsi::GenericMethod *_create_f_ignoreSslErrors_0 ()
{
  return new qt_gsi::GenericMethod ("ignoreSslErrors", "@brief Method void QNetworkReply::ignoreSslErrors()\n", false, &_init_f_ignoreSslErrors_0, &_call_f_ignoreSslErrors_0);
}

// bool QNetworkReply::isFinished()


static void _init_f_isFinished_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFinished_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QNetworkReply *)cls)->isFinished ());
}

static qt_gsi::GenericMethod *_create_f_isFinished_c0 ()
{
  return new qt_gsi::GenericMethod ("isFinished?", "@brief Method bool QNetworkReply::isFinished()\n", true, &_init_f_isFinished_c0, &_call_f_isFinished_c0);
}

// bool QNetworkReply::isRunning()


static void _init_f_isRunning_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRunning_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QNetworkReply *)cls)->isRunning ());
}

static qt_gsi::GenericMethod *_create_f_isRunning_c0 ()
{
  return new qt_gsi::GenericMethod ("isRunning?", "@brief Method bool QNetworkReply::isRunning()\n", true, &_init_f_isRunning_c0, &_call_f_isRunning_c0);
}

// bool QNetworkReply::isSequential()


static void _init_f_isSequential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSequential_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QNetworkReply *)cls)->isSequential ());
}

static qt_gsi::GenericMethod *_create_f_isSequential_c0 ()
{
  return new qt_gsi::GenericMethod ("isSequential?", "@brief Method bool QNetworkReply::isSequential()\nThis is a reimplementation of QIODevice::isSequential", true, &_init_f_isSequential_c0, &_call_f_isSequential_c0);
}

// QNetworkAccessManager *QNetworkReply::manager()


static void _init_f_manager_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkAccessManager * > ();
}

static void _call_f_manager_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QNetworkAccessManager * > ((QNetworkAccessManager *)((QNetworkReply *)cls)->manager ());
}

static qt_gsi::GenericMethod *_create_f_manager_c0 ()
{
  return new qt_gsi::GenericMethod ("manager", "@brief Method QNetworkAccessManager *QNetworkReply::manager()\n", true, &_init_f_manager_c0, &_call_f_manager_c0);
}

// QNetworkAccessManager::Operation QNetworkReply::operation()


static void _init_f_operation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type > ();
}

static void _call_f_operation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type > ((qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type)qt_gsi::CppToQtAdaptor<QNetworkAccessManager::Operation>(((QNetworkReply *)cls)->operation ()));
}

static qt_gsi::GenericMethod *_create_f_operation_c0 ()
{
  return new qt_gsi::GenericMethod ("operation", "@brief Method QNetworkAccessManager::Operation QNetworkReply::operation()\n", true, &_init_f_operation_c0, &_call_f_operation_c0);
}

// QByteArray QNetworkReply::rawHeader(const QByteArray &headerName)


static void _init_f_rawHeader_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("headerName");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_rawHeader_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<QByteArray > ((QByteArray)((QNetworkReply *)cls)->rawHeader (arg1));
}

static qt_gsi::GenericMethod *_create_f_rawHeader_c2309 ()
{
  return new qt_gsi::GenericMethod ("rawHeader", "@brief Method QByteArray QNetworkReply::rawHeader(const QByteArray &headerName)\n", true, &_init_f_rawHeader_c2309, &_call_f_rawHeader_c2309);
}

// QList<QByteArray> QNetworkReply::rawHeaderList()


static void _init_f_rawHeaderList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QByteArray> >::target_type > ();
}

static void _call_f_rawHeaderList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QByteArray> >::target_type > ((qt_gsi::Converter<QList<QByteArray> >::target_type)qt_gsi::CppToQtAdaptor<QList<QByteArray> >(((QNetworkReply *)cls)->rawHeaderList ()));
}

static qt_gsi::GenericMethod *_create_f_rawHeaderList_c0 ()
{
  return new qt_gsi::GenericMethod ("rawHeaderList", "@brief Method QList<QByteArray> QNetworkReply::rawHeaderList()\n", true, &_init_f_rawHeaderList_c0, &_call_f_rawHeaderList_c0);
}

// qint64 QNetworkReply::readBufferSize()


static void _init_f_readBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_readBufferSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QNetworkReply *)cls)->readBufferSize ());
}

static qt_gsi::GenericMethod *_create_f_readBufferSize_c0 ()
{
  return new qt_gsi::GenericMethod (":readBufferSize", "@brief Method qint64 QNetworkReply::readBufferSize()\n", true, &_init_f_readBufferSize_c0, &_call_f_readBufferSize_c0);
}

// QNetworkRequest QNetworkReply::request()


static void _init_f_request_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkRequest > ();
}

static void _call_f_request_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QNetworkRequest > ((QNetworkRequest)((QNetworkReply *)cls)->request ());
}

static qt_gsi::GenericMethod *_create_f_request_c0 ()
{
  return new qt_gsi::GenericMethod ("request", "@brief Method QNetworkRequest QNetworkReply::request()\n", true, &_init_f_request_c0, &_call_f_request_c0);
}

// void QNetworkReply::setReadBufferSize(qint64 size)


static void _init_f_setReadBufferSize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadBufferSize_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ((QNetworkReply *)cls)->setReadBufferSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setReadBufferSize_986 ()
{
  return new qt_gsi::GenericMethod ("setReadBufferSize|readBufferSize=", "@brief Method void QNetworkReply::setReadBufferSize(qint64 size)\n", false, &_init_f_setReadBufferSize_986, &_call_f_setReadBufferSize_986);
}

// void QNetworkReply::setSslConfiguration(const QSslConfiguration &configuration)


static void _init_f_setSslConfiguration_3068 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("configuration");
  decl->add_arg<const QSslConfiguration & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSslConfiguration_3068 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSslConfiguration &arg1 = args.read<const QSslConfiguration & > ();
  ((QNetworkReply *)cls)->setSslConfiguration (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSslConfiguration_3068 ()
{
  return new qt_gsi::GenericMethod ("setSslConfiguration|sslConfiguration=", "@brief Method void QNetworkReply::setSslConfiguration(const QSslConfiguration &configuration)\n", false, &_init_f_setSslConfiguration_3068, &_call_f_setSslConfiguration_3068);
}

// QSslConfiguration QNetworkReply::sslConfiguration()


static void _init_f_sslConfiguration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslConfiguration > ();
}

static void _call_f_sslConfiguration_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSslConfiguration > ((QSslConfiguration)((QNetworkReply *)cls)->sslConfiguration ());
}

static qt_gsi::GenericMethod *_create_f_sslConfiguration_c0 ()
{
  return new qt_gsi::GenericMethod (":sslConfiguration", "@brief Method QSslConfiguration QNetworkReply::sslConfiguration()\n", true, &_init_f_sslConfiguration_c0, &_call_f_sslConfiguration_c0);
}

// QUrl QNetworkReply::url()


static void _init_f_url_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_url_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QUrl > ((QUrl)((QNetworkReply *)cls)->url ());
}

static qt_gsi::GenericMethod *_create_f_url_c0 ()
{
  return new qt_gsi::GenericMethod ("url", "@brief Method QUrl QNetworkReply::url()\n", true, &_init_f_url_c0, &_call_f_url_c0);
}

// static QString QNetworkReply::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QNetworkReply::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QNetworkReply::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QNetworkReply::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QNetworkReply::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QNetworkReply::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QNetworkReply::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QNetworkReply::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QNetworkReply::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QNetworkReply::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QNetworkReply::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QNetworkReply::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QNetworkReply, QNetworkReply_EventAdaptor> ea_QNetworkReply;


namespace gsi
{
extern gsi::Class<QIODevice> decl_QIODevice;

gsi::Class<QNetworkReply> decl_QNetworkReply (ea_QNetworkReply, decl_QIODevice, "QNetworkReply",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_abort_0 ()) +
  gsi::Methods(_create_f_attribute_c3072 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_error_c0 ()) +
  gsi::Methods(_create_f_hasRawHeader_c2309 ()) +
  gsi::Methods(_create_f_header_c3349 ()) +
  gsi::Methods(_create_f_ignoreSslErrors_2837 ()) +
  gsi::Methods(_create_f_ignoreSslErrors_0 ()) +
  gsi::Methods(_create_f_isFinished_c0 ()) +
  gsi::Methods(_create_f_isRunning_c0 ()) +
  gsi::Methods(_create_f_isSequential_c0 ()) +
  gsi::Methods(_create_f_manager_c0 ()) +
  gsi::Methods(_create_f_operation_c0 ()) +
  gsi::Methods(_create_f_rawHeader_c2309 ()) +
  gsi::Methods(_create_f_rawHeaderList_c0 ()) +
  gsi::Methods(_create_f_readBufferSize_c0 ()) +
  gsi::Methods(_create_f_request_c0 ()) +
  gsi::Methods(_create_f_setReadBufferSize_986 ()) +
  gsi::Methods(_create_f_setSslConfiguration_3068 ()) +
  gsi::Methods(_create_f_sslConfiguration_c0 ()) +
  gsi::Methods(_create_f_url_c0 ()) +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor> ("aboutToClose", &QNetworkReply_EventAdaptor::aboutToClose_e_0, "@brief Signal declaration for QNetworkReply::aboutToClose()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor, qint64> ("bytesWritten", &QNetworkReply_EventAdaptor::bytesWritten_e_986, gsi::arg("bytes"), "@brief Signal declaration for QNetworkReply::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor, QObject *> ("destroyed", &QNetworkReply_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QNetworkReply::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor, qint64, qint64> ("downloadProgress", &QNetworkReply_EventAdaptor::downloadProgress_e_1864, gsi::arg("bytesReceived"), gsi::arg("bytesTotal"), "@brief Signal declaration for QNetworkReply::downloadProgress(qint64 bytesReceived, qint64 bytesTotal)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor, const qt_gsi::Converter<QNetworkReply::NetworkError>::target_type &> ("error", &QNetworkReply_EventAdaptor::error_e_3171, gsi::arg("arg1"), "@brief Signal declaration for QNetworkReply::error(QNetworkReply::NetworkError)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor> ("finished", &QNetworkReply_EventAdaptor::finished_e_0, "@brief Signal declaration for QNetworkReply::finished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor> ("metaDataChanged", &QNetworkReply_EventAdaptor::metaDataChanged_e_0, "@brief Signal declaration for QNetworkReply::metaDataChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor> ("readChannelFinished", &QNetworkReply_EventAdaptor::readChannelFinished_e_0, "@brief Signal declaration for QNetworkReply::readChannelFinished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor> ("readyRead", &QNetworkReply_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QNetworkReply::readyRead()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor, const qt_gsi::Converter<QList<QSslError> >::target_type &> ("sslErrors", &QNetworkReply_EventAdaptor::sslErrors_e_2837, gsi::arg("errors"), "@brief Signal declaration for QNetworkReply::sslErrors(const QList<QSslError> &errors)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkReply, QNetworkReply_EventAdaptor, qint64, qint64> ("uploadProgress", &QNetworkReply_EventAdaptor::uploadProgress_e_1864, gsi::arg("bytesSent"), gsi::arg("bytesTotal"), "@brief Signal declaration for QNetworkReply::uploadProgress(qint64 bytesSent, qint64 bytesTotal)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QNetworkReply");

}


//  Implementation of the enum wrapper class for QNetworkReply::NetworkError
namespace qt_gsi
{

static QNetworkReply_NetworkError_Enum *c_1_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::NoError); }
static QNetworkReply_NetworkError_Enum *c_2_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ConnectionRefusedError); }
static QNetworkReply_NetworkError_Enum *c_3_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::RemoteHostClosedError); }
static QNetworkReply_NetworkError_Enum *c_4_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::HostNotFoundError); }
static QNetworkReply_NetworkError_Enum *c_5_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::TimeoutError); }
static QNetworkReply_NetworkError_Enum *c_6_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::OperationCanceledError); }
static QNetworkReply_NetworkError_Enum *c_7_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::SslHandshakeFailedError); }
static QNetworkReply_NetworkError_Enum *c_8_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::UnknownNetworkError); }
static QNetworkReply_NetworkError_Enum *c_9_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ProxyConnectionRefusedError); }
static QNetworkReply_NetworkError_Enum *c_10_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ProxyConnectionClosedError); }
static QNetworkReply_NetworkError_Enum *c_11_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ProxyNotFoundError); }
static QNetworkReply_NetworkError_Enum *c_12_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ProxyTimeoutError); }
static QNetworkReply_NetworkError_Enum *c_13_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ProxyAuthenticationRequiredError); }
static QNetworkReply_NetworkError_Enum *c_14_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::UnknownProxyError); }
static QNetworkReply_NetworkError_Enum *c_15_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ContentAccessDenied); }
static QNetworkReply_NetworkError_Enum *c_16_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ContentOperationNotPermittedError); }
static QNetworkReply_NetworkError_Enum *c_17_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ContentNotFoundError); }
static QNetworkReply_NetworkError_Enum *c_18_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::AuthenticationRequiredError); }
static QNetworkReply_NetworkError_Enum *c_19_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ContentReSendError); }
static QNetworkReply_NetworkError_Enum *c_20_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::UnknownContentError); }
static QNetworkReply_NetworkError_Enum *c_21_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ProtocolUnknownError); }
static QNetworkReply_NetworkError_Enum *c_22_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ProtocolInvalidOperationError); }
static QNetworkReply_NetworkError_Enum *c_23_QNetworkReply_NetworkError_Enum () { return new QNetworkReply_NetworkError_Enum (QNetworkReply::ProtocolFailure); }

static gsi::Methods mkdefs_QNetworkReply_NetworkError () {
  return
    gsi::constant ("NoError", &qt_gsi::c_1_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::NoError") +
    gsi::constant ("ConnectionRefusedError", &qt_gsi::c_2_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ConnectionRefusedError") +
    gsi::constant ("RemoteHostClosedError", &qt_gsi::c_3_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::RemoteHostClosedError") +
    gsi::constant ("HostNotFoundError", &qt_gsi::c_4_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::HostNotFoundError") +
    gsi::constant ("TimeoutError", &qt_gsi::c_5_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::TimeoutError") +
    gsi::constant ("OperationCanceledError", &qt_gsi::c_6_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::OperationCanceledError") +
    gsi::constant ("SslHandshakeFailedError", &qt_gsi::c_7_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::SslHandshakeFailedError") +
    gsi::constant ("UnknownNetworkError", &qt_gsi::c_8_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::UnknownNetworkError") +
    gsi::constant ("ProxyConnectionRefusedError", &qt_gsi::c_9_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ProxyConnectionRefusedError") +
    gsi::constant ("ProxyConnectionClosedError", &qt_gsi::c_10_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ProxyConnectionClosedError") +
    gsi::constant ("ProxyNotFoundError", &qt_gsi::c_11_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ProxyNotFoundError") +
    gsi::constant ("ProxyTimeoutError", &qt_gsi::c_12_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ProxyTimeoutError") +
    gsi::constant ("ProxyAuthenticationRequiredError", &qt_gsi::c_13_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ProxyAuthenticationRequiredError") +
    gsi::constant ("UnknownProxyError", &qt_gsi::c_14_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::UnknownProxyError") +
    gsi::constant ("ContentAccessDenied", &qt_gsi::c_15_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ContentAccessDenied") +
    gsi::constant ("ContentOperationNotPermittedError", &qt_gsi::c_16_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ContentOperationNotPermittedError") +
    gsi::constant ("ContentNotFoundError", &qt_gsi::c_17_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ContentNotFoundError") +
    gsi::constant ("AuthenticationRequiredError", &qt_gsi::c_18_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::AuthenticationRequiredError") +
    gsi::constant ("ContentReSendError", &qt_gsi::c_19_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ContentReSendError") +
    gsi::constant ("UnknownContentError", &qt_gsi::c_20_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::UnknownContentError") +
    gsi::constant ("ProtocolUnknownError", &qt_gsi::c_21_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ProtocolUnknownError") +
    gsi::constant ("ProtocolInvalidOperationError", &qt_gsi::c_22_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ProtocolInvalidOperationError") +
    gsi::constant ("ProtocolFailure", &qt_gsi::c_23_QNetworkReply_NetworkError_Enum, "@brief Enum constant QNetworkReply::ProtocolFailure");
}

static std::string to_s_QNetworkReply_NetworkError_Enum (const QNetworkReply_NetworkError_Enum *e)
{
  if (e->value () == QNetworkReply::NoError) { return tl::sprintf ("NoError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ConnectionRefusedError) { return tl::sprintf ("ConnectionRefusedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::RemoteHostClosedError) { return tl::sprintf ("RemoteHostClosedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::HostNotFoundError) { return tl::sprintf ("HostNotFoundError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::TimeoutError) { return tl::sprintf ("TimeoutError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::OperationCanceledError) { return tl::sprintf ("OperationCanceledError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::SslHandshakeFailedError) { return tl::sprintf ("SslHandshakeFailedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::UnknownNetworkError) { return tl::sprintf ("UnknownNetworkError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ProxyConnectionRefusedError) { return tl::sprintf ("ProxyConnectionRefusedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ProxyConnectionClosedError) { return tl::sprintf ("ProxyConnectionClosedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ProxyNotFoundError) { return tl::sprintf ("ProxyNotFoundError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ProxyTimeoutError) { return tl::sprintf ("ProxyTimeoutError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ProxyAuthenticationRequiredError) { return tl::sprintf ("ProxyAuthenticationRequiredError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::UnknownProxyError) { return tl::sprintf ("UnknownProxyError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ContentAccessDenied) { return tl::sprintf ("ContentAccessDenied (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ContentOperationNotPermittedError) { return tl::sprintf ("ContentOperationNotPermittedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ContentNotFoundError) { return tl::sprintf ("ContentNotFoundError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::AuthenticationRequiredError) { return tl::sprintf ("AuthenticationRequiredError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ContentReSendError) { return tl::sprintf ("ContentReSendError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::UnknownContentError) { return tl::sprintf ("UnknownContentError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ProtocolUnknownError) { return tl::sprintf ("ProtocolUnknownError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ProtocolInvalidOperationError) { return tl::sprintf ("ProtocolInvalidOperationError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkReply::ProtocolFailure) { return tl::sprintf ("ProtocolFailure (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QNetworkReply_NetworkError_Enum (const QNetworkReply_NetworkError_Enum *e)
{
  return (unsigned int) e->value ();
}

static QNetworkReply_NetworkError_Enum *from_i_QNetworkReply_NetworkError_Enum (unsigned int i)
{
  return new QNetworkReply_NetworkError_Enum ((QNetworkReply::NetworkError) i);
}

static bool equalQNetworkReply_NetworkError_Enum (const QNetworkReply_NetworkError_Enum *e, QNetworkReply_NetworkError_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QNetworkReply_NetworkError_Enum (const QNetworkReply_NetworkError_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QNetworkReply_NetworkError_Enums oropQNetworkReply_NetworkError_Enums (const QNetworkReply_NetworkError_Enums *e, const QNetworkReply_NetworkError_Enums &d)
{
  return e->flags () | d.flags ();
}

static QNetworkReply_NetworkError_Enums andopQNetworkReply_NetworkError_Enums (const QNetworkReply_NetworkError_Enums *e, const QNetworkReply_NetworkError_Enums &d)
{
  return e->flags () & d.flags ();
}

static QNetworkReply_NetworkError_Enums xoropQNetworkReply_NetworkError_Enums (const QNetworkReply_NetworkError_Enums *e, const QNetworkReply_NetworkError_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QNetworkReply_NetworkError_Enums (const QNetworkReply_NetworkError_Enums *e)
{
  std::string l;
  if (e->testFlag (QNetworkReply::NoError)) { if (!l.empty ()) l += "|"; l += "NoError"; }
  if (e->testFlag (QNetworkReply::ConnectionRefusedError)) { if (!l.empty ()) l += "|"; l += "ConnectionRefusedError"; }
  if (e->testFlag (QNetworkReply::RemoteHostClosedError)) { if (!l.empty ()) l += "|"; l += "RemoteHostClosedError"; }
  if (e->testFlag (QNetworkReply::HostNotFoundError)) { if (!l.empty ()) l += "|"; l += "HostNotFoundError"; }
  if (e->testFlag (QNetworkReply::TimeoutError)) { if (!l.empty ()) l += "|"; l += "TimeoutError"; }
  if (e->testFlag (QNetworkReply::OperationCanceledError)) { if (!l.empty ()) l += "|"; l += "OperationCanceledError"; }
  if (e->testFlag (QNetworkReply::SslHandshakeFailedError)) { if (!l.empty ()) l += "|"; l += "SslHandshakeFailedError"; }
  if (e->testFlag (QNetworkReply::UnknownNetworkError)) { if (!l.empty ()) l += "|"; l += "UnknownNetworkError"; }
  if (e->testFlag (QNetworkReply::ProxyConnectionRefusedError)) { if (!l.empty ()) l += "|"; l += "ProxyConnectionRefusedError"; }
  if (e->testFlag (QNetworkReply::ProxyConnectionClosedError)) { if (!l.empty ()) l += "|"; l += "ProxyConnectionClosedError"; }
  if (e->testFlag (QNetworkReply::ProxyNotFoundError)) { if (!l.empty ()) l += "|"; l += "ProxyNotFoundError"; }
  if (e->testFlag (QNetworkReply::ProxyTimeoutError)) { if (!l.empty ()) l += "|"; l += "ProxyTimeoutError"; }
  if (e->testFlag (QNetworkReply::ProxyAuthenticationRequiredError)) { if (!l.empty ()) l += "|"; l += "ProxyAuthenticationRequiredError"; }
  if (e->testFlag (QNetworkReply::UnknownProxyError)) { if (!l.empty ()) l += "|"; l += "UnknownProxyError"; }
  if (e->testFlag (QNetworkReply::ContentAccessDenied)) { if (!l.empty ()) l += "|"; l += "ContentAccessDenied"; }
  if (e->testFlag (QNetworkReply::ContentOperationNotPermittedError)) { if (!l.empty ()) l += "|"; l += "ContentOperationNotPermittedError"; }
  if (e->testFlag (QNetworkReply::ContentNotFoundError)) { if (!l.empty ()) l += "|"; l += "ContentNotFoundError"; }
  if (e->testFlag (QNetworkReply::AuthenticationRequiredError)) { if (!l.empty ()) l += "|"; l += "AuthenticationRequiredError"; }
  if (e->testFlag (QNetworkReply::ContentReSendError)) { if (!l.empty ()) l += "|"; l += "ContentReSendError"; }
  if (e->testFlag (QNetworkReply::UnknownContentError)) { if (!l.empty ()) l += "|"; l += "UnknownContentError"; }
  if (e->testFlag (QNetworkReply::ProtocolUnknownError)) { if (!l.empty ()) l += "|"; l += "ProtocolUnknownError"; }
  if (e->testFlag (QNetworkReply::ProtocolInvalidOperationError)) { if (!l.empty ()) l += "|"; l += "ProtocolInvalidOperationError"; }
  if (e->testFlag (QNetworkReply::ProtocolFailure)) { if (!l.empty ()) l += "|"; l += "ProtocolFailure"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QNetworkReply_NetworkError_Enums (const QNetworkReply_NetworkError_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QNetworkReply_NetworkError_Enums (const QNetworkReply_NetworkError_Enums *e, const QNetworkReply_NetworkError_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QNetworkReply_NetworkError_Enums> decl_QNetworkReply_NetworkError_Enums ("QNetworkReply_QFlags_NetworkError",
  gsi::method_ext ("|", &qt_gsi::oropQNetworkReply_NetworkError_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQNetworkReply_NetworkError_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQNetworkReply_NetworkError_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QNetworkReply_NetworkError_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QNetworkReply_NetworkError_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QNetworkReply_NetworkError_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QNetworkReply::NetworkError> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QNetworkReply_NetworkError_Enum> decl_QNetworkReply_NetworkError_Enum (decl_QNetworkReply_NetworkError_Enums, "QNetworkReply_NetworkError",
  qt_gsi::mkdefs_QNetworkReply_NetworkError () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QNetworkReply_NetworkError_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QNetworkReply_NetworkError_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQNetworkReply_NetworkError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QNetworkReply_NetworkError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QNetworkReply_NetworkError_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QNetworkReply::NetworkError enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QNetworkReply> inject_QNetworkReply_NetworkError_Enum_in_parent (qt_gsi::mkdefs_QNetworkReply_NetworkError ());
static gsi::ClassExt<QNetworkReply> decl_QNetworkReply_NetworkError_Enum_as_child (decl_QNetworkReply_NetworkError_Enum, "NetworkError");

}

