
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsItem.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQGraphicsItem_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsItem

// bool QGraphicsItem::acceptDrops()


static void _init_f_acceptDrops_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptDrops_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->acceptDrops ());
}

static qt_gsi::GenericMethod *_create_f_acceptDrops_c0 ()
{
  return new qt_gsi::GenericMethod (":acceptDrops", "@brief Method bool QGraphicsItem::acceptDrops()\n", true, &_init_f_acceptDrops_c0, &_call_f_acceptDrops_c0);
}

// bool QGraphicsItem::acceptHoverEvents()


static void _init_f_acceptHoverEvents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptHoverEvents_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->acceptHoverEvents ());
}

static qt_gsi::GenericMethod *_create_f_acceptHoverEvents_c0 ()
{
  return new qt_gsi::GenericMethod (":acceptHoverEvents", "@brief Method bool QGraphicsItem::acceptHoverEvents()\n", true, &_init_f_acceptHoverEvents_c0, &_call_f_acceptHoverEvents_c0);
}

// bool QGraphicsItem::acceptTouchEvents()


static void _init_f_acceptTouchEvents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptTouchEvents_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->acceptTouchEvents ());
}

static qt_gsi::GenericMethod *_create_f_acceptTouchEvents_c0 ()
{
  return new qt_gsi::GenericMethod (":acceptTouchEvents", "@brief Method bool QGraphicsItem::acceptTouchEvents()\n", true, &_init_f_acceptTouchEvents_c0, &_call_f_acceptTouchEvents_c0);
}

// QFlags<Qt::MouseButton> QGraphicsItem::acceptedMouseButtons()


static void _init_f_acceptedMouseButtons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::MouseButton> >::target_type > ();
}

static void _call_f_acceptedMouseButtons_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::MouseButton> >::target_type > ((qt_gsi::Converter<QFlags<Qt::MouseButton> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::MouseButton> >(((QGraphicsItem *)cls)->acceptedMouseButtons ()));
}

static qt_gsi::GenericMethod *_create_f_acceptedMouseButtons_c0 ()
{
  return new qt_gsi::GenericMethod (":acceptedMouseButtons", "@brief Method QFlags<Qt::MouseButton> QGraphicsItem::acceptedMouseButtons()\n", true, &_init_f_acceptedMouseButtons_c0, &_call_f_acceptedMouseButtons_c0);
}

// bool QGraphicsItem::acceptsHoverEvents()


static void _init_f_acceptsHoverEvents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptsHoverEvents_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->acceptsHoverEvents ());
}

static qt_gsi::GenericMethod *_create_f_acceptsHoverEvents_c0 ()
{
  return new qt_gsi::GenericMethod (":acceptsHoverEvents", "@brief Method bool QGraphicsItem::acceptsHoverEvents()\n", true, &_init_f_acceptsHoverEvents_c0, &_call_f_acceptsHoverEvents_c0);
}

// void QGraphicsItem::advance(int phase)


static void _init_f_advance_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("phase");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_advance_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QGraphicsItem *)cls)->advance (arg1);
}

static qt_gsi::GenericMethod *_create_f_advance_767 ()
{
  return new qt_gsi::GenericMethod ("advance", "@brief Method void QGraphicsItem::advance(int phase)\n", false, &_init_f_advance_767, &_call_f_advance_767);
}

// QRectF QGraphicsItem::boundingRect()


static void _init_f_boundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->boundingRect ());
}

static qt_gsi::GenericMethod *_create_f_boundingRect_c0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QGraphicsItem::boundingRect()\n", true, &_init_f_boundingRect_c0, &_call_f_boundingRect_c0);
}

// QRegion QGraphicsItem::boundingRegion(const QTransform &itemToDeviceTransform)


static void _init_f_boundingRegion_c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("itemToDeviceTransform");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_f_boundingRegion_c2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<QRegion > ((QRegion)((QGraphicsItem *)cls)->boundingRegion (arg1));
}

static qt_gsi::GenericMethod *_create_f_boundingRegion_c2350 ()
{
  return new qt_gsi::GenericMethod ("boundingRegion", "@brief Method QRegion QGraphicsItem::boundingRegion(const QTransform &itemToDeviceTransform)\n", true, &_init_f_boundingRegion_c2350, &_call_f_boundingRegion_c2350);
}

// double QGraphicsItem::boundingRegionGranularity()


static void _init_f_boundingRegionGranularity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_boundingRegionGranularity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsItem *)cls)->boundingRegionGranularity ());
}

static qt_gsi::GenericMethod *_create_f_boundingRegionGranularity_c0 ()
{
  return new qt_gsi::GenericMethod (":boundingRegionGranularity", "@brief Method double QGraphicsItem::boundingRegionGranularity()\n", true, &_init_f_boundingRegionGranularity_c0, &_call_f_boundingRegionGranularity_c0);
}

// QGraphicsItem::CacheMode QGraphicsItem::cacheMode()


static void _init_f_cacheMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type > ();
}

static void _call_f_cacheMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type > ((qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsItem::CacheMode>(((QGraphicsItem *)cls)->cacheMode ()));
}

static qt_gsi::GenericMethod *_create_f_cacheMode_c0 ()
{
  return new qt_gsi::GenericMethod (":cacheMode", "@brief Method QGraphicsItem::CacheMode QGraphicsItem::cacheMode()\n", true, &_init_f_cacheMode_c0, &_call_f_cacheMode_c0);
}

// QList<QGraphicsItem *> QGraphicsItem::childItems()


static void _init_f_childItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_childItems_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsItem *)cls)->childItems ()));
}

static qt_gsi::GenericMethod *_create_f_childItems_c0 ()
{
  return new qt_gsi::GenericMethod ("childItems", "@brief Method QList<QGraphicsItem *> QGraphicsItem::childItems()\n", true, &_init_f_childItems_c0, &_call_f_childItems_c0);
}

// QList<QGraphicsItem *> QGraphicsItem::children()


static void _init_f_children_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_children_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsItem *)cls)->children ()));
}

static qt_gsi::GenericMethod *_create_f_children_c0 ()
{
  return new qt_gsi::GenericMethod ("children", "@brief Method QList<QGraphicsItem *> QGraphicsItem::children()\n", true, &_init_f_children_c0, &_call_f_children_c0);
}

// QRectF QGraphicsItem::childrenBoundingRect()


static void _init_f_childrenBoundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_childrenBoundingRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->childrenBoundingRect ());
}

static qt_gsi::GenericMethod *_create_f_childrenBoundingRect_c0 ()
{
  return new qt_gsi::GenericMethod ("childrenBoundingRect", "@brief Method QRectF QGraphicsItem::childrenBoundingRect()\n", true, &_init_f_childrenBoundingRect_c0, &_call_f_childrenBoundingRect_c0);
}

// void QGraphicsItem::clearFocus()


static void _init_f_clearFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem *)cls)->clearFocus ();
}

static qt_gsi::GenericMethod *_create_f_clearFocus_0 ()
{
  return new qt_gsi::GenericMethod ("clearFocus", "@brief Method void QGraphicsItem::clearFocus()\n", false, &_init_f_clearFocus_0, &_call_f_clearFocus_0);
}

// QPainterPath QGraphicsItem::clipPath()


static void _init_f_clipPath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_clipPath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->clipPath ());
}

static qt_gsi::GenericMethod *_create_f_clipPath_c0 ()
{
  return new qt_gsi::GenericMethod ("clipPath", "@brief Method QPainterPath QGraphicsItem::clipPath()\n", true, &_init_f_clipPath_c0, &_call_f_clipPath_c0);
}

// bool QGraphicsItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)


static void _init_f_collidesWithItem_c4977 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_collidesWithItem_c4977 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->collidesWithItem (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_collidesWithItem_c4977 ()
{
  return new qt_gsi::GenericMethod ("collidesWithItem", "@brief Method bool QGraphicsItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)\n", true, &_init_f_collidesWithItem_c4977, &_call_f_collidesWithItem_c4977);
}

// bool QGraphicsItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)


static void _init_f_collidesWithPath_c4877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_collidesWithPath_c4877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->collidesWithPath (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_collidesWithPath_c4877 ()
{
  return new qt_gsi::GenericMethod ("collidesWithPath", "@brief Method bool QGraphicsItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)\n", true, &_init_f_collidesWithPath_c4877, &_call_f_collidesWithPath_c4877);
}

// QList<QGraphicsItem *> QGraphicsItem::collidingItems(Qt::ItemSelectionMode mode)


static void _init_f_collidingItems_c2471 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_collidingItems_c2471 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsItem *)cls)->collidingItems (qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg1).cref())));
}

static qt_gsi::GenericMethod *_create_f_collidingItems_c2471 ()
{
  return new qt_gsi::GenericMethod ("collidingItems", "@brief Method QList<QGraphicsItem *> QGraphicsItem::collidingItems(Qt::ItemSelectionMode mode)\n", true, &_init_f_collidingItems_c2471, &_call_f_collidingItems_c2471);
}

// QGraphicsItem *QGraphicsItem::commonAncestorItem(const QGraphicsItem *other)


static void _init_f_commonAncestorItem_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_commonAncestorItem_c2614 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->commonAncestorItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_commonAncestorItem_c2614 ()
{
  return new qt_gsi::GenericMethod ("commonAncestorItem", "@brief Method QGraphicsItem *QGraphicsItem::commonAncestorItem(const QGraphicsItem *other)\n", true, &_init_f_commonAncestorItem_c2614, &_call_f_commonAncestorItem_c2614);
}

// bool QGraphicsItem::contains(const QPointF &point)


static void _init_f_contains_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_contains_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->contains (arg1));
}

static qt_gsi::GenericMethod *_create_f_contains_c1986 ()
{
  return new qt_gsi::GenericMethod ("contains", "@brief Method bool QGraphicsItem::contains(const QPointF &point)\n", true, &_init_f_contains_c1986, &_call_f_contains_c1986);
}

// QCursor QGraphicsItem::cursor()


static void _init_f_cursor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCursor > ();
}

static void _call_f_cursor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QCursor > ((QCursor)((QGraphicsItem *)cls)->cursor ());
}

static qt_gsi::GenericMethod *_create_f_cursor_c0 ()
{
  return new qt_gsi::GenericMethod (":cursor", "@brief Method QCursor QGraphicsItem::cursor()\n", true, &_init_f_cursor_c0, &_call_f_cursor_c0);
}

// QVariant QGraphicsItem::data(int key)


static void _init_f_data_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QGraphicsItem *)cls)->data (arg1));
}

static qt_gsi::GenericMethod *_create_f_data_c767 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Method QVariant QGraphicsItem::data(int key)\n", true, &_init_f_data_c767, &_call_f_data_c767);
}

// QTransform QGraphicsItem::deviceTransform(const QTransform &viewportTransform)


static void _init_f_deviceTransform_c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewportTransform");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QTransform > ();
}

static void _call_f_deviceTransform_c2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<QTransform > ((QTransform)((QGraphicsItem *)cls)->deviceTransform (arg1));
}

static qt_gsi::GenericMethod *_create_f_deviceTransform_c2350 ()
{
  return new qt_gsi::GenericMethod ("deviceTransform", "@brief Method QTransform QGraphicsItem::deviceTransform(const QTransform &viewportTransform)\n", true, &_init_f_deviceTransform_c2350, &_call_f_deviceTransform_c2350);
}

// double QGraphicsItem::effectiveOpacity()


static void _init_f_effectiveOpacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_effectiveOpacity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsItem *)cls)->effectiveOpacity ());
}

static qt_gsi::GenericMethod *_create_f_effectiveOpacity_c0 ()
{
  return new qt_gsi::GenericMethod ("effectiveOpacity", "@brief Method double QGraphicsItem::effectiveOpacity()\n", true, &_init_f_effectiveOpacity_c0, &_call_f_effectiveOpacity_c0);
}

// void QGraphicsItem::ensureVisible(const QRectF &rect, int xmargin, int ymargin)


static void _init_f_ensureVisible_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_3180 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  int arg2 = args ? args.read<int > () : (int)(50);
  int arg3 = args ? args.read<int > () : (int)(50);
  ((QGraphicsItem *)cls)->ensureVisible (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_ensureVisible_3180 ()
{
  return new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QGraphicsItem::ensureVisible(const QRectF &rect, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_3180, &_call_f_ensureVisible_3180);
}

// void QGraphicsItem::ensureVisible(double x, double y, double w, double h, int xmargin, int ymargin)


static void _init_f_ensureVisible_5278 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_5278 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  int arg5 = args ? args.read<int > () : (int)(50);
  int arg6 = args ? args.read<int > () : (int)(50);
  ((QGraphicsItem *)cls)->ensureVisible (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_ensureVisible_5278 ()
{
  return new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QGraphicsItem::ensureVisible(double x, double y, double w, double h, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_5278, &_call_f_ensureVisible_5278);
}

// bool QGraphicsItem::filtersChildEvents()


static void _init_f_filtersChildEvents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_filtersChildEvents_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->filtersChildEvents ());
}

static qt_gsi::GenericMethod *_create_f_filtersChildEvents_c0 ()
{
  return new qt_gsi::GenericMethod (":filtersChildEvents", "@brief Method bool QGraphicsItem::filtersChildEvents()\n", true, &_init_f_filtersChildEvents_c0, &_call_f_filtersChildEvents_c0);
}

// QFlags<QGraphicsItem::GraphicsItemFlag> QGraphicsItem::flags()


static void _init_f_flags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QGraphicsItem::GraphicsItemFlag> >::target_type > ();
}

static void _call_f_flags_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QGraphicsItem::GraphicsItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<QGraphicsItem::GraphicsItemFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QGraphicsItem::GraphicsItemFlag> >(((QGraphicsItem *)cls)->flags ()));
}

static qt_gsi::GenericMethod *_create_f_flags_c0 ()
{
  return new qt_gsi::GenericMethod (":flags", "@brief Method QFlags<QGraphicsItem::GraphicsItemFlag> QGraphicsItem::flags()\n", true, &_init_f_flags_c0, &_call_f_flags_c0);
}

// QGraphicsItem *QGraphicsItem::focusItem()


static void _init_f_focusItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_focusItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->focusItem ());
}

static qt_gsi::GenericMethod *_create_f_focusItem_c0 ()
{
  return new qt_gsi::GenericMethod ("focusItem", "@brief Method QGraphicsItem *QGraphicsItem::focusItem()\n", true, &_init_f_focusItem_c0, &_call_f_focusItem_c0);
}

// QGraphicsItem *QGraphicsItem::focusProxy()


static void _init_f_focusProxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_focusProxy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->focusProxy ());
}

static qt_gsi::GenericMethod *_create_f_focusProxy_c0 ()
{
  return new qt_gsi::GenericMethod (":focusProxy", "@brief Method QGraphicsItem *QGraphicsItem::focusProxy()\n", true, &_init_f_focusProxy_c0, &_call_f_focusProxy_c0);
}

// QGraphicsItem *QGraphicsItem::focusScopeItem()


static void _init_f_focusScopeItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_focusScopeItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->focusScopeItem ());
}

static qt_gsi::GenericMethod *_create_f_focusScopeItem_c0 ()
{
  return new qt_gsi::GenericMethod ("focusScopeItem", "@brief Method QGraphicsItem *QGraphicsItem::focusScopeItem()\n", true, &_init_f_focusScopeItem_c0, &_call_f_focusScopeItem_c0);
}

// void QGraphicsItem::grabKeyboard()


static void _init_f_grabKeyboard_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_grabKeyboard_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem *)cls)->grabKeyboard ();
}

static qt_gsi::GenericMethod *_create_f_grabKeyboard_0 ()
{
  return new qt_gsi::GenericMethod ("grabKeyboard", "@brief Method void QGraphicsItem::grabKeyboard()\n", false, &_init_f_grabKeyboard_0, &_call_f_grabKeyboard_0);
}

// void QGraphicsItem::grabMouse()


static void _init_f_grabMouse_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_grabMouse_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem *)cls)->grabMouse ();
}

static qt_gsi::GenericMethod *_create_f_grabMouse_0 ()
{
  return new qt_gsi::GenericMethod ("grabMouse", "@brief Method void QGraphicsItem::grabMouse()\n", false, &_init_f_grabMouse_0, &_call_f_grabMouse_0);
}

// QGraphicsEffect *QGraphicsItem::graphicsEffect()


static void _init_f_graphicsEffect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsEffect * > ();
}

static void _call_f_graphicsEffect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsEffect * > ((QGraphicsEffect *)((QGraphicsItem *)cls)->graphicsEffect ());
}

static qt_gsi::GenericMethod *_create_f_graphicsEffect_c0 ()
{
  return new qt_gsi::GenericMethod (":graphicsEffect", "@brief Method QGraphicsEffect *QGraphicsItem::graphicsEffect()\n", true, &_init_f_graphicsEffect_c0, &_call_f_graphicsEffect_c0);
}

// QGraphicsItemGroup *QGraphicsItem::group()


static void _init_f_group_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItemGroup * > ();
}

static void _call_f_group_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItemGroup * > ((QGraphicsItemGroup *)((QGraphicsItem *)cls)->group ());
}

static qt_gsi::GenericMethod *_create_f_group_c0 ()
{
  return new qt_gsi::GenericMethod (":group", "@brief Method QGraphicsItemGroup *QGraphicsItem::group()\n", true, &_init_f_group_c0, &_call_f_group_c0);
}

// bool QGraphicsItem::handlesChildEvents()


static void _init_f_handlesChildEvents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_handlesChildEvents_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->handlesChildEvents ());
}

static qt_gsi::GenericMethod *_create_f_handlesChildEvents_c0 ()
{
  return new qt_gsi::GenericMethod (":handlesChildEvents", "@brief Method bool QGraphicsItem::handlesChildEvents()\n", true, &_init_f_handlesChildEvents_c0, &_call_f_handlesChildEvents_c0);
}

// bool QGraphicsItem::hasCursor()


static void _init_f_hasCursor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasCursor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->hasCursor ());
}

static qt_gsi::GenericMethod *_create_f_hasCursor_c0 ()
{
  return new qt_gsi::GenericMethod ("hasCursor", "@brief Method bool QGraphicsItem::hasCursor()\n", true, &_init_f_hasCursor_c0, &_call_f_hasCursor_c0);
}

// bool QGraphicsItem::hasFocus()


static void _init_f_hasFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFocus_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->hasFocus ());
}

static qt_gsi::GenericMethod *_create_f_hasFocus_c0 ()
{
  return new qt_gsi::GenericMethod ("hasFocus", "@brief Method bool QGraphicsItem::hasFocus()\n", true, &_init_f_hasFocus_c0, &_call_f_hasFocus_c0);
}

// void QGraphicsItem::hide()


static void _init_f_hide_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_hide_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem *)cls)->hide ();
}

static qt_gsi::GenericMethod *_create_f_hide_0 ()
{
  return new qt_gsi::GenericMethod ("hide", "@brief Method void QGraphicsItem::hide()\n", false, &_init_f_hide_0, &_call_f_hide_0);
}

// QFlags<Qt::InputMethodHint> QGraphicsItem::inputMethodHints()


static void _init_f_inputMethodHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type > ();
}

static void _call_f_inputMethodHints_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type > ((qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::InputMethodHint> >(((QGraphicsItem *)cls)->inputMethodHints ()));
}

static qt_gsi::GenericMethod *_create_f_inputMethodHints_c0 ()
{
  return new qt_gsi::GenericMethod (":inputMethodHints", "@brief Method QFlags<Qt::InputMethodHint> QGraphicsItem::inputMethodHints()\n", true, &_init_f_inputMethodHints_c0, &_call_f_inputMethodHints_c0);
}

// void QGraphicsItem::installSceneEventFilter(QGraphicsItem *filterItem)


static void _init_f_installSceneEventFilter_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filterItem");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_installSceneEventFilter_1919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  ((QGraphicsItem *)cls)->installSceneEventFilter (arg1);
}

static qt_gsi::GenericMethod *_create_f_installSceneEventFilter_1919 ()
{
  return new qt_gsi::GenericMethod ("installSceneEventFilter", "@brief Method void QGraphicsItem::installSceneEventFilter(QGraphicsItem *filterItem)\n", false, &_init_f_installSceneEventFilter_1919, &_call_f_installSceneEventFilter_1919);
}

// bool QGraphicsItem::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isActive ());
}

static qt_gsi::GenericMethod *_create_f_isActive_c0 ()
{
  return new qt_gsi::GenericMethod ("isActive?|:active", "@brief Method bool QGraphicsItem::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
}

// bool QGraphicsItem::isAncestorOf(const QGraphicsItem *child)


static void _init_f_isAncestorOf_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isAncestorOf_c2614 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isAncestorOf (arg1));
}

static qt_gsi::GenericMethod *_create_f_isAncestorOf_c2614 ()
{
  return new qt_gsi::GenericMethod ("isAncestorOf?", "@brief Method bool QGraphicsItem::isAncestorOf(const QGraphicsItem *child)\n", true, &_init_f_isAncestorOf_c2614, &_call_f_isAncestorOf_c2614);
}

// bool QGraphicsItem::isClipped()


static void _init_f_isClipped_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isClipped_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isClipped ());
}

static qt_gsi::GenericMethod *_create_f_isClipped_c0 ()
{
  return new qt_gsi::GenericMethod ("isClipped?", "@brief Method bool QGraphicsItem::isClipped()\n", true, &_init_f_isClipped_c0, &_call_f_isClipped_c0);
}

// bool QGraphicsItem::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QGraphicsItem::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
}

// bool QGraphicsItem::isObscured()


static void _init_f_isObscured_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isObscured_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isObscured ());
}

static qt_gsi::GenericMethod *_create_f_isObscured_c0 ()
{
  return new qt_gsi::GenericMethod ("isObscured?", "@brief Method bool QGraphicsItem::isObscured()\n", true, &_init_f_isObscured_c0, &_call_f_isObscured_c0);
}

// bool QGraphicsItem::isObscured(const QRectF &rect)


static void _init_f_isObscured_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isObscured_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isObscured (arg1));
}

static qt_gsi::GenericMethod *_create_f_isObscured_c1862 ()
{
  return new qt_gsi::GenericMethod ("isObscured?", "@brief Method bool QGraphicsItem::isObscured(const QRectF &rect)\n", true, &_init_f_isObscured_c1862, &_call_f_isObscured_c1862);
}

// bool QGraphicsItem::isObscured(double x, double y, double w, double h)


static void _init_f_isObscured_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_isObscured_c3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isObscured (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_isObscured_c3960 ()
{
  return new qt_gsi::GenericMethod ("isObscured?", "@brief Method bool QGraphicsItem::isObscured(double x, double y, double w, double h)\n", true, &_init_f_isObscured_c3960, &_call_f_isObscured_c3960);
}

// bool QGraphicsItem::isObscuredBy(const QGraphicsItem *item)


static void _init_f_isObscuredBy_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isObscuredBy_c2614 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isObscuredBy (arg1));
}

static qt_gsi::GenericMethod *_create_f_isObscuredBy_c2614 ()
{
  return new qt_gsi::GenericMethod ("isObscuredBy?", "@brief Method bool QGraphicsItem::isObscuredBy(const QGraphicsItem *item)\n", true, &_init_f_isObscuredBy_c2614, &_call_f_isObscuredBy_c2614);
}

// bool QGraphicsItem::isPanel()


static void _init_f_isPanel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isPanel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isPanel ());
}

static qt_gsi::GenericMethod *_create_f_isPanel_c0 ()
{
  return new qt_gsi::GenericMethod ("isPanel?", "@brief Method bool QGraphicsItem::isPanel()\n", true, &_init_f_isPanel_c0, &_call_f_isPanel_c0);
}

// bool QGraphicsItem::isSelected()


static void _init_f_isSelected_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSelected_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isSelected ());
}

static qt_gsi::GenericMethod *_create_f_isSelected_c0 ()
{
  return new qt_gsi::GenericMethod ("isSelected?|:selected", "@brief Method bool QGraphicsItem::isSelected()\n", true, &_init_f_isSelected_c0, &_call_f_isSelected_c0);
}

// bool QGraphicsItem::isUnderMouse()


static void _init_f_isUnderMouse_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isUnderMouse_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isUnderMouse ());
}

static qt_gsi::GenericMethod *_create_f_isUnderMouse_c0 ()
{
  return new qt_gsi::GenericMethod ("isUnderMouse?", "@brief Method bool QGraphicsItem::isUnderMouse()\n", true, &_init_f_isUnderMouse_c0, &_call_f_isUnderMouse_c0);
}

// bool QGraphicsItem::isVisible()


static void _init_f_isVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVisible_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isVisible ());
}

static qt_gsi::GenericMethod *_create_f_isVisible_c0 ()
{
  return new qt_gsi::GenericMethod ("isVisible?|:visible", "@brief Method bool QGraphicsItem::isVisible()\n", true, &_init_f_isVisible_c0, &_call_f_isVisible_c0);
}

// bool QGraphicsItem::isVisibleTo(const QGraphicsItem *parent)


static void _init_f_isVisibleTo_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isVisibleTo_c2614 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isVisibleTo (arg1));
}

static qt_gsi::GenericMethod *_create_f_isVisibleTo_c2614 ()
{
  return new qt_gsi::GenericMethod ("isVisibleTo?", "@brief Method bool QGraphicsItem::isVisibleTo(const QGraphicsItem *parent)\n", true, &_init_f_isVisibleTo_c2614, &_call_f_isVisibleTo_c2614);
}

// bool QGraphicsItem::isWidget()


static void _init_f_isWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isWidget ());
}

static qt_gsi::GenericMethod *_create_f_isWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("isWidget?", "@brief Method bool QGraphicsItem::isWidget()\n", true, &_init_f_isWidget_c0, &_call_f_isWidget_c0);
}

// bool QGraphicsItem::isWindow()


static void _init_f_isWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWindow_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isWindow ());
}

static qt_gsi::GenericMethod *_create_f_isWindow_c0 ()
{
  return new qt_gsi::GenericMethod ("isWindow?", "@brief Method bool QGraphicsItem::isWindow()\n", true, &_init_f_isWindow_c0, &_call_f_isWindow_c0);
}

// QTransform QGraphicsItem::itemTransform(const QGraphicsItem *other, bool *ok)


static void _init_f_itemTransform_c3556 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QTransform > ();
}

static void _call_f_itemTransform_c3556 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  bool *arg2 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<QTransform > ((QTransform)((QGraphicsItem *)cls)->itemTransform (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_itemTransform_c3556 ()
{
  return new qt_gsi::GenericMethod ("itemTransform", "@brief Method QTransform QGraphicsItem::itemTransform(const QGraphicsItem *other, bool *ok)\n", true, &_init_f_itemTransform_c3556, &_call_f_itemTransform_c3556);
}

// QPointF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPointF &point)


static void _init_f_mapFromItem_c4492 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("point");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromItem_c4492 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapFromItem_c4492 ()
{
  return new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPointF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPointF &point)\n", true, &_init_f_mapFromItem_c4492, &_call_f_mapFromItem_c4492);
}

// QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QRectF &rect)


static void _init_f_mapFromItem_c4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromItem_c4368 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const QRectF &arg2 = args.read<const QRectF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapFromItem_c4368 ()
{
  return new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QRectF &rect)\n", true, &_init_f_mapFromItem_c4368, &_call_f_mapFromItem_c4368);
}

// QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPolygonF &polygon)


static void _init_f_mapFromItem_c4714 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_1);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromItem_c4714 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const QPolygonF &arg2 = args.read<const QPolygonF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapFromItem_c4714 ()
{
  return new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPolygonF &polygon)\n", true, &_init_f_mapFromItem_c4714, &_call_f_mapFromItem_c4714);
}

// QPainterPath QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPainterPath &path)


static void _init_f_mapFromItem_c5020 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("path");
  decl->add_arg<const QPainterPath & > (argspec_1);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapFromItem_c5020 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const QPainterPath &arg2 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapFromItem_c5020 ()
{
  return new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPainterPath QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPainterPath &path)\n", true, &_init_f_mapFromItem_c5020, &_call_f_mapFromItem_c5020);
}

// QPointF QGraphicsItem::mapFromItem(const QGraphicsItem *item, double x, double y)


static void _init_f_mapFromItem_c4540 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromItem_c4540 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_mapFromItem_c4540 ()
{
  return new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPointF QGraphicsItem::mapFromItem(const QGraphicsItem *item, double x, double y)\n", true, &_init_f_mapFromItem_c4540, &_call_f_mapFromItem_c4540);
}

// QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, double x, double y, double w, double h)


static void _init_f_mapFromItem_c6466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h");
  decl->add_arg<double > (argspec_4);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromItem_c6466 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_mapFromItem_c6466 ()
{
  return new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, double x, double y, double w, double h)\n", true, &_init_f_mapFromItem_c6466, &_call_f_mapFromItem_c6466);
}

// QPointF QGraphicsItem::mapFromParent(const QPointF &point)


static void _init_f_mapFromParent_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromParent_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromParent_c1986 ()
{
  return new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPointF QGraphicsItem::mapFromParent(const QPointF &point)\n", true, &_init_f_mapFromParent_c1986, &_call_f_mapFromParent_c1986);
}

// QPolygonF QGraphicsItem::mapFromParent(const QRectF &rect)


static void _init_f_mapFromParent_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromParent_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromParent_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPolygonF QGraphicsItem::mapFromParent(const QRectF &rect)\n", true, &_init_f_mapFromParent_c1862, &_call_f_mapFromParent_c1862);
}

// QPolygonF QGraphicsItem::mapFromParent(const QPolygonF &polygon)


static void _init_f_mapFromParent_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromParent_c2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromParent_c2208 ()
{
  return new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPolygonF QGraphicsItem::mapFromParent(const QPolygonF &polygon)\n", true, &_init_f_mapFromParent_c2208, &_call_f_mapFromParent_c2208);
}

// QPainterPath QGraphicsItem::mapFromParent(const QPainterPath &path)


static void _init_f_mapFromParent_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapFromParent_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapFromParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromParent_c2514 ()
{
  return new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPainterPath QGraphicsItem::mapFromParent(const QPainterPath &path)\n", true, &_init_f_mapFromParent_c2514, &_call_f_mapFromParent_c2514);
}

// QPointF QGraphicsItem::mapFromParent(double x, double y)


static void _init_f_mapFromParent_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromParent_c2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromParent (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapFromParent_c2034 ()
{
  return new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPointF QGraphicsItem::mapFromParent(double x, double y)\n", true, &_init_f_mapFromParent_c2034, &_call_f_mapFromParent_c2034);
}

// QPolygonF QGraphicsItem::mapFromParent(double x, double y, double w, double h)


static void _init_f_mapFromParent_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromParent_c3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromParent (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_mapFromParent_c3960 ()
{
  return new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPolygonF QGraphicsItem::mapFromParent(double x, double y, double w, double h)\n", true, &_init_f_mapFromParent_c3960, &_call_f_mapFromParent_c3960);
}

// QPointF QGraphicsItem::mapFromScene(const QPointF &point)


static void _init_f_mapFromScene_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromScene_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c1986 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPointF QGraphicsItem::mapFromScene(const QPointF &point)\n", true, &_init_f_mapFromScene_c1986, &_call_f_mapFromScene_c1986);
}

// QPolygonF QGraphicsItem::mapFromScene(const QRectF &rect)


static void _init_f_mapFromScene_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromScene_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygonF QGraphicsItem::mapFromScene(const QRectF &rect)\n", true, &_init_f_mapFromScene_c1862, &_call_f_mapFromScene_c1862);
}

// QPolygonF QGraphicsItem::mapFromScene(const QPolygonF &polygon)


static void _init_f_mapFromScene_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromScene_c2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c2208 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygonF QGraphicsItem::mapFromScene(const QPolygonF &polygon)\n", true, &_init_f_mapFromScene_c2208, &_call_f_mapFromScene_c2208);
}

// QPainterPath QGraphicsItem::mapFromScene(const QPainterPath &path)


static void _init_f_mapFromScene_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapFromScene_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapFromScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c2514 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPainterPath QGraphicsItem::mapFromScene(const QPainterPath &path)\n", true, &_init_f_mapFromScene_c2514, &_call_f_mapFromScene_c2514);
}

// QPointF QGraphicsItem::mapFromScene(double x, double y)


static void _init_f_mapFromScene_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromScene_c2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromScene (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c2034 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPointF QGraphicsItem::mapFromScene(double x, double y)\n", true, &_init_f_mapFromScene_c2034, &_call_f_mapFromScene_c2034);
}

// QPolygonF QGraphicsItem::mapFromScene(double x, double y, double w, double h)


static void _init_f_mapFromScene_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromScene_c3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromScene (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c3960 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygonF QGraphicsItem::mapFromScene(double x, double y, double w, double h)\n", true, &_init_f_mapFromScene_c3960, &_call_f_mapFromScene_c3960);
}

// QRectF QGraphicsItem::mapRectFromItem(const QGraphicsItem *item, const QRectF &rect)


static void _init_f_mapRectFromItem_c4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromItem_c4368 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const QRectF &arg2 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapRectFromItem_c4368 ()
{
  return new qt_gsi::GenericMethod ("mapRectFromItem", "@brief Method QRectF QGraphicsItem::mapRectFromItem(const QGraphicsItem *item, const QRectF &rect)\n", true, &_init_f_mapRectFromItem_c4368, &_call_f_mapRectFromItem_c4368);
}

// QRectF QGraphicsItem::mapRectFromItem(const QGraphicsItem *item, double x, double y, double w, double h)


static void _init_f_mapRectFromItem_c6466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h");
  decl->add_arg<double > (argspec_4);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromItem_c6466 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromItem (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_mapRectFromItem_c6466 ()
{
  return new qt_gsi::GenericMethod ("mapRectFromItem", "@brief Method QRectF QGraphicsItem::mapRectFromItem(const QGraphicsItem *item, double x, double y, double w, double h)\n", true, &_init_f_mapRectFromItem_c6466, &_call_f_mapRectFromItem_c6466);
}

// QRectF QGraphicsItem::mapRectFromParent(const QRectF &rect)


static void _init_f_mapRectFromParent_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromParent_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapRectFromParent_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapRectFromParent", "@brief Method QRectF QGraphicsItem::mapRectFromParent(const QRectF &rect)\n", true, &_init_f_mapRectFromParent_c1862, &_call_f_mapRectFromParent_c1862);
}

// QRectF QGraphicsItem::mapRectFromParent(double x, double y, double w, double h)


static void _init_f_mapRectFromParent_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromParent_c3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromParent (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_mapRectFromParent_c3960 ()
{
  return new qt_gsi::GenericMethod ("mapRectFromParent", "@brief Method QRectF QGraphicsItem::mapRectFromParent(double x, double y, double w, double h)\n", true, &_init_f_mapRectFromParent_c3960, &_call_f_mapRectFromParent_c3960);
}

// QRectF QGraphicsItem::mapRectFromScene(const QRectF &rect)


static void _init_f_mapRectFromScene_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromScene_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapRectFromScene_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapRectFromScene", "@brief Method QRectF QGraphicsItem::mapRectFromScene(const QRectF &rect)\n", true, &_init_f_mapRectFromScene_c1862, &_call_f_mapRectFromScene_c1862);
}

// QRectF QGraphicsItem::mapRectFromScene(double x, double y, double w, double h)


static void _init_f_mapRectFromScene_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromScene_c3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromScene (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_mapRectFromScene_c3960 ()
{
  return new qt_gsi::GenericMethod ("mapRectFromScene", "@brief Method QRectF QGraphicsItem::mapRectFromScene(double x, double y, double w, double h)\n", true, &_init_f_mapRectFromScene_c3960, &_call_f_mapRectFromScene_c3960);
}

// QRectF QGraphicsItem::mapRectToItem(const QGraphicsItem *item, const QRectF &rect)


static void _init_f_mapRectToItem_c4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToItem_c4368 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const QRectF &arg2 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapRectToItem_c4368 ()
{
  return new qt_gsi::GenericMethod ("mapRectToItem", "@brief Method QRectF QGraphicsItem::mapRectToItem(const QGraphicsItem *item, const QRectF &rect)\n", true, &_init_f_mapRectToItem_c4368, &_call_f_mapRectToItem_c4368);
}

// QRectF QGraphicsItem::mapRectToItem(const QGraphicsItem *item, double x, double y, double w, double h)


static void _init_f_mapRectToItem_c6466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h");
  decl->add_arg<double > (argspec_4);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToItem_c6466 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToItem (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_mapRectToItem_c6466 ()
{
  return new qt_gsi::GenericMethod ("mapRectToItem", "@brief Method QRectF QGraphicsItem::mapRectToItem(const QGraphicsItem *item, double x, double y, double w, double h)\n", true, &_init_f_mapRectToItem_c6466, &_call_f_mapRectToItem_c6466);
}

// QRectF QGraphicsItem::mapRectToParent(const QRectF &rect)


static void _init_f_mapRectToParent_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToParent_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapRectToParent_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapRectToParent", "@brief Method QRectF QGraphicsItem::mapRectToParent(const QRectF &rect)\n", true, &_init_f_mapRectToParent_c1862, &_call_f_mapRectToParent_c1862);
}

// QRectF QGraphicsItem::mapRectToParent(double x, double y, double w, double h)


static void _init_f_mapRectToParent_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToParent_c3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToParent (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_mapRectToParent_c3960 ()
{
  return new qt_gsi::GenericMethod ("mapRectToParent", "@brief Method QRectF QGraphicsItem::mapRectToParent(double x, double y, double w, double h)\n", true, &_init_f_mapRectToParent_c3960, &_call_f_mapRectToParent_c3960);
}

// QRectF QGraphicsItem::mapRectToScene(const QRectF &rect)


static void _init_f_mapRectToScene_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToScene_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapRectToScene_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapRectToScene", "@brief Method QRectF QGraphicsItem::mapRectToScene(const QRectF &rect)\n", true, &_init_f_mapRectToScene_c1862, &_call_f_mapRectToScene_c1862);
}

// QRectF QGraphicsItem::mapRectToScene(double x, double y, double w, double h)


static void _init_f_mapRectToScene_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToScene_c3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToScene (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_mapRectToScene_c3960 ()
{
  return new qt_gsi::GenericMethod ("mapRectToScene", "@brief Method QRectF QGraphicsItem::mapRectToScene(double x, double y, double w, double h)\n", true, &_init_f_mapRectToScene_c3960, &_call_f_mapRectToScene_c3960);
}

// QPointF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPointF &point)


static void _init_f_mapToItem_c4492 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("point");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToItem_c4492 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapToItem_c4492 ()
{
  return new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPointF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPointF &point)\n", true, &_init_f_mapToItem_c4492, &_call_f_mapToItem_c4492);
}

// QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QRectF &rect)


static void _init_f_mapToItem_c4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToItem_c4368 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const QRectF &arg2 = args.read<const QRectF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapToItem_c4368 ()
{
  return new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QRectF &rect)\n", true, &_init_f_mapToItem_c4368, &_call_f_mapToItem_c4368);
}

// QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPolygonF &polygon)


static void _init_f_mapToItem_c4714 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_1);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToItem_c4714 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const QPolygonF &arg2 = args.read<const QPolygonF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapToItem_c4714 ()
{
  return new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPolygonF &polygon)\n", true, &_init_f_mapToItem_c4714, &_call_f_mapToItem_c4714);
}

// QPainterPath QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPainterPath &path)


static void _init_f_mapToItem_c5020 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("path");
  decl->add_arg<const QPainterPath & > (argspec_1);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapToItem_c5020 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const QPainterPath &arg2 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapToItem (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapToItem_c5020 ()
{
  return new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPainterPath QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPainterPath &path)\n", true, &_init_f_mapToItem_c5020, &_call_f_mapToItem_c5020);
}

// QPointF QGraphicsItem::mapToItem(const QGraphicsItem *item, double x, double y)


static void _init_f_mapToItem_c4540 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToItem_c4540 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToItem (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_mapToItem_c4540 ()
{
  return new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPointF QGraphicsItem::mapToItem(const QGraphicsItem *item, double x, double y)\n", true, &_init_f_mapToItem_c4540, &_call_f_mapToItem_c4540);
}

// QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, double x, double y, double w, double h)


static void _init_f_mapToItem_c6466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h");
  decl->add_arg<double > (argspec_4);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToItem_c6466 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToItem (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_mapToItem_c6466 ()
{
  return new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, double x, double y, double w, double h)\n", true, &_init_f_mapToItem_c6466, &_call_f_mapToItem_c6466);
}

// QPointF QGraphicsItem::mapToParent(const QPointF &point)


static void _init_f_mapToParent_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToParent_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToParent_c1986 ()
{
  return new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPointF QGraphicsItem::mapToParent(const QPointF &point)\n", true, &_init_f_mapToParent_c1986, &_call_f_mapToParent_c1986);
}

// QPolygonF QGraphicsItem::mapToParent(const QRectF &rect)


static void _init_f_mapToParent_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToParent_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToParent_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPolygonF QGraphicsItem::mapToParent(const QRectF &rect)\n", true, &_init_f_mapToParent_c1862, &_call_f_mapToParent_c1862);
}

// QPolygonF QGraphicsItem::mapToParent(const QPolygonF &polygon)


static void _init_f_mapToParent_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToParent_c2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToParent_c2208 ()
{
  return new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPolygonF QGraphicsItem::mapToParent(const QPolygonF &polygon)\n", true, &_init_f_mapToParent_c2208, &_call_f_mapToParent_c2208);
}

// QPainterPath QGraphicsItem::mapToParent(const QPainterPath &path)


static void _init_f_mapToParent_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapToParent_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapToParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToParent_c2514 ()
{
  return new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPainterPath QGraphicsItem::mapToParent(const QPainterPath &path)\n", true, &_init_f_mapToParent_c2514, &_call_f_mapToParent_c2514);
}

// QPointF QGraphicsItem::mapToParent(double x, double y)


static void _init_f_mapToParent_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToParent_c2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToParent (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapToParent_c2034 ()
{
  return new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPointF QGraphicsItem::mapToParent(double x, double y)\n", true, &_init_f_mapToParent_c2034, &_call_f_mapToParent_c2034);
}

// QPolygonF QGraphicsItem::mapToParent(double x, double y, double w, double h)


static void _init_f_mapToParent_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToParent_c3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToParent (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_mapToParent_c3960 ()
{
  return new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPolygonF QGraphicsItem::mapToParent(double x, double y, double w, double h)\n", true, &_init_f_mapToParent_c3960, &_call_f_mapToParent_c3960);
}

// QPointF QGraphicsItem::mapToScene(const QPointF &point)


static void _init_f_mapToScene_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToScene_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c1986 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPointF QGraphicsItem::mapToScene(const QPointF &point)\n", true, &_init_f_mapToScene_c1986, &_call_f_mapToScene_c1986);
}

// QPolygonF QGraphicsItem::mapToScene(const QRectF &rect)


static void _init_f_mapToScene_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsItem::mapToScene(const QRectF &rect)\n", true, &_init_f_mapToScene_c1862, &_call_f_mapToScene_c1862);
}

// QPolygonF QGraphicsItem::mapToScene(const QPolygonF &polygon)


static void _init_f_mapToScene_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c2208 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsItem::mapToScene(const QPolygonF &polygon)\n", true, &_init_f_mapToScene_c2208, &_call_f_mapToScene_c2208);
}

// QPainterPath QGraphicsItem::mapToScene(const QPainterPath &path)


static void _init_f_mapToScene_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapToScene_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapToScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c2514 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPainterPath QGraphicsItem::mapToScene(const QPainterPath &path)\n", true, &_init_f_mapToScene_c2514, &_call_f_mapToScene_c2514);
}

// QPointF QGraphicsItem::mapToScene(double x, double y)


static void _init_f_mapToScene_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToScene_c2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToScene (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c2034 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPointF QGraphicsItem::mapToScene(double x, double y)\n", true, &_init_f_mapToScene_c2034, &_call_f_mapToScene_c2034);
}

// QPolygonF QGraphicsItem::mapToScene(double x, double y, double w, double h)


static void _init_f_mapToScene_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToScene (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c3960 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsItem::mapToScene(double x, double y, double w, double h)\n", true, &_init_f_mapToScene_c3960, &_call_f_mapToScene_c3960);
}

// QMatrix QGraphicsItem::matrix()


static void _init_f_matrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMatrix > ();
}

static void _call_f_matrix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMatrix > ((QMatrix)((QGraphicsItem *)cls)->matrix ());
}

static qt_gsi::GenericMethod *_create_f_matrix_c0 ()
{
  return new qt_gsi::GenericMethod (":matrix", "@brief Method QMatrix QGraphicsItem::matrix()\n", true, &_init_f_matrix_c0, &_call_f_matrix_c0);
}

// void QGraphicsItem::moveBy(double dx, double dy)


static void _init_f_moveBy_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_moveBy_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsItem *)cls)->moveBy (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_moveBy_2034 ()
{
  return new qt_gsi::GenericMethod ("moveBy", "@brief Method void QGraphicsItem::moveBy(double dx, double dy)\n", false, &_init_f_moveBy_2034, &_call_f_moveBy_2034);
}

// double QGraphicsItem::opacity()


static void _init_f_opacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_opacity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsItem *)cls)->opacity ());
}

static qt_gsi::GenericMethod *_create_f_opacity_c0 ()
{
  return new qt_gsi::GenericMethod (":opacity", "@brief Method double QGraphicsItem::opacity()\n", true, &_init_f_opacity_c0, &_call_f_opacity_c0);
}

// QPainterPath QGraphicsItem::opaqueArea()


static void _init_f_opaqueArea_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_opaqueArea_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->opaqueArea ());
}

static qt_gsi::GenericMethod *_create_f_opaqueArea_c0 ()
{
  return new qt_gsi::GenericMethod ("opaqueArea", "@brief Method QPainterPath QGraphicsItem::opaqueArea()\n", true, &_init_f_opaqueArea_c0, &_call_f_opaqueArea_c0);
}

// void QGraphicsItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)


static void _init_f_paint_6301 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_6301 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > ();
  QWidget *arg3 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ((QGraphicsItem *)cls)->paint (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_paint_6301 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Method void QGraphicsItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\n", false, &_init_f_paint_6301, &_call_f_paint_6301);
}

// QGraphicsItem *QGraphicsItem::panel()


static void _init_f_panel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_panel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->panel ());
}

static qt_gsi::GenericMethod *_create_f_panel_c0 ()
{
  return new qt_gsi::GenericMethod ("panel", "@brief Method QGraphicsItem *QGraphicsItem::panel()\n", true, &_init_f_panel_c0, &_call_f_panel_c0);
}

// QGraphicsItem::PanelModality QGraphicsItem::panelModality()


static void _init_f_panelModality_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type > ();
}

static void _call_f_panelModality_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type > ((qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsItem::PanelModality>(((QGraphicsItem *)cls)->panelModality ()));
}

static qt_gsi::GenericMethod *_create_f_panelModality_c0 ()
{
  return new qt_gsi::GenericMethod (":panelModality", "@brief Method QGraphicsItem::PanelModality QGraphicsItem::panelModality()\n", true, &_init_f_panelModality_c0, &_call_f_panelModality_c0);
}

// QGraphicsItem *QGraphicsItem::parentItem()


static void _init_f_parentItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_parentItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->parentItem ());
}

static qt_gsi::GenericMethod *_create_f_parentItem_c0 ()
{
  return new qt_gsi::GenericMethod (":parentItem", "@brief Method QGraphicsItem *QGraphicsItem::parentItem()\n", true, &_init_f_parentItem_c0, &_call_f_parentItem_c0);
}

// QGraphicsObject *QGraphicsItem::parentObject()


static void _init_f_parentObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsObject * > ();
}

static void _call_f_parentObject_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsObject * > ((QGraphicsObject *)((QGraphicsItem *)cls)->parentObject ());
}

static qt_gsi::GenericMethod *_create_f_parentObject_c0 ()
{
  return new qt_gsi::GenericMethod ("parentObject", "@brief Method QGraphicsObject *QGraphicsItem::parentObject()\n", true, &_init_f_parentObject_c0, &_call_f_parentObject_c0);
}

// QGraphicsWidget *QGraphicsItem::parentWidget()


static void _init_f_parentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsWidget * > ();
}

static void _call_f_parentWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsWidget * > ((QGraphicsWidget *)((QGraphicsItem *)cls)->parentWidget ());
}

static qt_gsi::GenericMethod *_create_f_parentWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("parentWidget", "@brief Method QGraphicsWidget *QGraphicsItem::parentWidget()\n", true, &_init_f_parentWidget_c0, &_call_f_parentWidget_c0);
}

// QPointF QGraphicsItem::pos()


static void _init_f_pos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_pos_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->pos ());
}

static qt_gsi::GenericMethod *_create_f_pos_c0 ()
{
  return new qt_gsi::GenericMethod (":pos", "@brief Method QPointF QGraphicsItem::pos()\n", true, &_init_f_pos_c0, &_call_f_pos_c0);
}

// void QGraphicsItem::removeSceneEventFilter(QGraphicsItem *filterItem)


static void _init_f_removeSceneEventFilter_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filterItem");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeSceneEventFilter_1919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  ((QGraphicsItem *)cls)->removeSceneEventFilter (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeSceneEventFilter_1919 ()
{
  return new qt_gsi::GenericMethod ("removeSceneEventFilter", "@brief Method void QGraphicsItem::removeSceneEventFilter(QGraphicsItem *filterItem)\n", false, &_init_f_removeSceneEventFilter_1919, &_call_f_removeSceneEventFilter_1919);
}

// void QGraphicsItem::resetMatrix()


static void _init_f_resetMatrix_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetMatrix_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem *)cls)->resetMatrix ();
}

static qt_gsi::GenericMethod *_create_f_resetMatrix_0 ()
{
  return new qt_gsi::GenericMethod ("resetMatrix", "@brief Method void QGraphicsItem::resetMatrix()\n", false, &_init_f_resetMatrix_0, &_call_f_resetMatrix_0);
}

// void QGraphicsItem::resetTransform()


static void _init_f_resetTransform_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetTransform_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem *)cls)->resetTransform ();
}

static qt_gsi::GenericMethod *_create_f_resetTransform_0 ()
{
  return new qt_gsi::GenericMethod ("resetTransform", "@brief Method void QGraphicsItem::resetTransform()\n", false, &_init_f_resetTransform_0, &_call_f_resetTransform_0);
}

// void QGraphicsItem::rotate(double angle)


static void _init_f_rotate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("angle");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_rotate_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItem *)cls)->rotate (arg1);
}

static qt_gsi::GenericMethod *_create_f_rotate_1071 ()
{
  return new qt_gsi::GenericMethod ("rotate", "@brief Method void QGraphicsItem::rotate(double angle)\n", false, &_init_f_rotate_1071, &_call_f_rotate_1071);
}

// double QGraphicsItem::rotation()


static void _init_f_rotation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_rotation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsItem *)cls)->rotation ());
}

static qt_gsi::GenericMethod *_create_f_rotation_c0 ()
{
  return new qt_gsi::GenericMethod (":rotation", "@brief Method double QGraphicsItem::rotation()\n", true, &_init_f_rotation_c0, &_call_f_rotation_c0);
}

// void QGraphicsItem::scale(double sx, double sy)


static void _init_f_scale_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scale_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsItem *)cls)->scale (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_scale_2034 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QGraphicsItem::scale(double sx, double sy)\n", false, &_init_f_scale_2034, &_call_f_scale_2034);
}

// double QGraphicsItem::scale()


static void _init_f_scale_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_scale_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsItem *)cls)->scale ());
}

static qt_gsi::GenericMethod *_create_f_scale_c0 ()
{
  return new qt_gsi::GenericMethod (":scale", "@brief Method double QGraphicsItem::scale()\n", true, &_init_f_scale_c0, &_call_f_scale_c0);
}

// QGraphicsScene *QGraphicsItem::scene()


static void _init_f_scene_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsScene * > ();
}

static void _call_f_scene_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsScene * > ((QGraphicsScene *)((QGraphicsItem *)cls)->scene ());
}

static qt_gsi::GenericMethod *_create_f_scene_c0 ()
{
  return new qt_gsi::GenericMethod ("scene", "@brief Method QGraphicsScene *QGraphicsItem::scene()\n", true, &_init_f_scene_c0, &_call_f_scene_c0);
}

// QRectF QGraphicsItem::sceneBoundingRect()


static void _init_f_sceneBoundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_sceneBoundingRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->sceneBoundingRect ());
}

static qt_gsi::GenericMethod *_create_f_sceneBoundingRect_c0 ()
{
  return new qt_gsi::GenericMethod ("sceneBoundingRect", "@brief Method QRectF QGraphicsItem::sceneBoundingRect()\n", true, &_init_f_sceneBoundingRect_c0, &_call_f_sceneBoundingRect_c0);
}

// QMatrix QGraphicsItem::sceneMatrix()


static void _init_f_sceneMatrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMatrix > ();
}

static void _call_f_sceneMatrix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMatrix > ((QMatrix)((QGraphicsItem *)cls)->sceneMatrix ());
}

static qt_gsi::GenericMethod *_create_f_sceneMatrix_c0 ()
{
  return new qt_gsi::GenericMethod ("sceneMatrix", "@brief Method QMatrix QGraphicsItem::sceneMatrix()\n", true, &_init_f_sceneMatrix_c0, &_call_f_sceneMatrix_c0);
}

// QPointF QGraphicsItem::scenePos()


static void _init_f_scenePos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_scenePos_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->scenePos ());
}

static qt_gsi::GenericMethod *_create_f_scenePos_c0 ()
{
  return new qt_gsi::GenericMethod ("scenePos", "@brief Method QPointF QGraphicsItem::scenePos()\n", true, &_init_f_scenePos_c0, &_call_f_scenePos_c0);
}

// QTransform QGraphicsItem::sceneTransform()


static void _init_f_sceneTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_sceneTransform_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTransform > ((QTransform)((QGraphicsItem *)cls)->sceneTransform ());
}

static qt_gsi::GenericMethod *_create_f_sceneTransform_c0 ()
{
  return new qt_gsi::GenericMethod ("sceneTransform", "@brief Method QTransform QGraphicsItem::sceneTransform()\n", true, &_init_f_sceneTransform_c0, &_call_f_sceneTransform_c0);
}

// void QGraphicsItem::scroll(double dx, double dy, const QRectF &rect)


static void _init_f_scroll_3788 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_scroll_3788 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  const QRectF &arg3 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  ((QGraphicsItem *)cls)->scroll (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_scroll_3788 ()
{
  return new qt_gsi::GenericMethod ("scroll", "@brief Method void QGraphicsItem::scroll(double dx, double dy, const QRectF &rect)\n", false, &_init_f_scroll_3788, &_call_f_scroll_3788);
}

// void QGraphicsItem::setAcceptDrops(bool on)


static void _init_f_setAcceptDrops_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("on");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptDrops_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsItem *)cls)->setAcceptDrops (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAcceptDrops_864 ()
{
  return new qt_gsi::GenericMethod ("setAcceptDrops|acceptDrops=", "@brief Method void QGraphicsItem::setAcceptDrops(bool on)\n", false, &_init_f_setAcceptDrops_864, &_call_f_setAcceptDrops_864);
}

// void QGraphicsItem::setAcceptHoverEvents(bool enabled)


static void _init_f_setAcceptHoverEvents_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptHoverEvents_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsItem *)cls)->setAcceptHoverEvents (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAcceptHoverEvents_864 ()
{
  return new qt_gsi::GenericMethod ("setAcceptHoverEvents|acceptHoverEvents=", "@brief Method void QGraphicsItem::setAcceptHoverEvents(bool enabled)\n", false, &_init_f_setAcceptHoverEvents_864, &_call_f_setAcceptHoverEvents_864);
}

// void QGraphicsItem::setAcceptTouchEvents(bool enabled)


static void _init_f_setAcceptTouchEvents_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptTouchEvents_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsItem *)cls)->setAcceptTouchEvents (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAcceptTouchEvents_864 ()
{
  return new qt_gsi::GenericMethod ("setAcceptTouchEvents|acceptTouchEvents=", "@brief Method void QGraphicsItem::setAcceptTouchEvents(bool enabled)\n", false, &_init_f_setAcceptTouchEvents_864, &_call_f_setAcceptTouchEvents_864);
}

// void QGraphicsItem::setAcceptedMouseButtons(QFlags<Qt::MouseButton> buttons)


static void _init_f_setAcceptedMouseButtons_2602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buttons");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MouseButton> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptedMouseButtons_2602 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::MouseButton> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::MouseButton> >::target_type & > ();
  ((QGraphicsItem *)cls)->setAcceptedMouseButtons (qt_gsi::QtToCppAdaptor<QFlags<Qt::MouseButton> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setAcceptedMouseButtons_2602 ()
{
  return new qt_gsi::GenericMethod ("setAcceptedMouseButtons|acceptedMouseButtons=", "@brief Method void QGraphicsItem::setAcceptedMouseButtons(QFlags<Qt::MouseButton> buttons)\n", false, &_init_f_setAcceptedMouseButtons_2602, &_call_f_setAcceptedMouseButtons_2602);
}

// void QGraphicsItem::setAcceptsHoverEvents(bool enabled)


static void _init_f_setAcceptsHoverEvents_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptsHoverEvents_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsItem *)cls)->setAcceptsHoverEvents (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAcceptsHoverEvents_864 ()
{
  return new qt_gsi::GenericMethod ("setAcceptsHoverEvents|acceptsHoverEvents=", "@brief Method void QGraphicsItem::setAcceptsHoverEvents(bool enabled)\n", false, &_init_f_setAcceptsHoverEvents_864, &_call_f_setAcceptsHoverEvents_864);
}

// void QGraphicsItem::setActive(bool active)


static void _init_f_setActive_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("active");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActive_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsItem *)cls)->setActive (arg1);
}

static qt_gsi::GenericMethod *_create_f_setActive_864 ()
{
  return new qt_gsi::GenericMethod ("setActive|active=", "@brief Method void QGraphicsItem::setActive(bool active)\n", false, &_init_f_setActive_864, &_call_f_setActive_864);
}

// void QGraphicsItem::setBoundingRegionGranularity(double granularity)


static void _init_f_setBoundingRegionGranularity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("granularity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBoundingRegionGranularity_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItem *)cls)->setBoundingRegionGranularity (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBoundingRegionGranularity_1071 ()
{
  return new qt_gsi::GenericMethod ("setBoundingRegionGranularity|boundingRegionGranularity=", "@brief Method void QGraphicsItem::setBoundingRegionGranularity(double granularity)\n", false, &_init_f_setBoundingRegionGranularity_1071, &_call_f_setBoundingRegionGranularity_1071);
}

// void QGraphicsItem::setCacheMode(QGraphicsItem::CacheMode mode, const QSize &cacheSize)


static void _init_f_setCacheMode_4403 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cacheSize", true, "QSize()");
  decl->add_arg<const QSize & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCacheMode_4403 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type & > ();
  const QSize &arg2 = args ? args.read<const QSize & > () : (const QSize &)(QSize());
  ((QGraphicsItem *)cls)->setCacheMode (qt_gsi::QtToCppAdaptor<QGraphicsItem::CacheMode>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setCacheMode_4403 ()
{
  return new qt_gsi::GenericMethod ("setCacheMode", "@brief Method void QGraphicsItem::setCacheMode(QGraphicsItem::CacheMode mode, const QSize &cacheSize)\n", false, &_init_f_setCacheMode_4403, &_call_f_setCacheMode_4403);
}

// void QGraphicsItem::setCursor(const QCursor &cursor)


static void _init_f_setCursor_2032 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursor_2032 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QCursor &arg1 = args.read<const QCursor & > ();
  ((QGraphicsItem *)cls)->setCursor (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCursor_2032 ()
{
  return new qt_gsi::GenericMethod ("setCursor|cursor=", "@brief Method void QGraphicsItem::setCursor(const QCursor &cursor)\n", false, &_init_f_setCursor_2032, &_call_f_setCursor_2032);
}

// void QGraphicsItem::setData(int key, const QVariant &value)


static void _init_f_setData_2778 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setData_2778 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QGraphicsItem *)cls)->setData (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setData_2778 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Method void QGraphicsItem::setData(int key, const QVariant &value)\n", false, &_init_f_setData_2778, &_call_f_setData_2778);
}

// void QGraphicsItem::setEnabled(bool enabled)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsItem *)cls)->setEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QGraphicsItem::setEnabled(bool enabled)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
}

// void QGraphicsItem::setFiltersChildEvents(bool enabled)


static void _init_f_setFiltersChildEvents_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFiltersChildEvents_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsItem *)cls)->setFiltersChildEvents (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFiltersChildEvents_864 ()
{
  return new qt_gsi::GenericMethod ("setFiltersChildEvents|filtersChildEvents=", "@brief Method void QGraphicsItem::setFiltersChildEvents(bool enabled)\n", false, &_init_f_setFiltersChildEvents_864, &_call_f_setFiltersChildEvents_864);
}

// void QGraphicsItem::setFlag(QGraphicsItem::GraphicsItemFlag flag, bool enabled)


static void _init_f_setFlag_4199 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flag");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::GraphicsItemFlag>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFlag_4199 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsItem::GraphicsItemFlag>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::GraphicsItemFlag>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QGraphicsItem *)cls)->setFlag (qt_gsi::QtToCppAdaptor<QGraphicsItem::GraphicsItemFlag>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setFlag_4199 ()
{
  return new qt_gsi::GenericMethod ("setFlag", "@brief Method void QGraphicsItem::setFlag(QGraphicsItem::GraphicsItemFlag flag, bool enabled)\n", false, &_init_f_setFlag_4199, &_call_f_setFlag_4199);
}

// void QGraphicsItem::setFlags(QFlags<QGraphicsItem::GraphicsItemFlag> flags)


static void _init_f_setFlags_4139 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsItem::GraphicsItemFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFlags_4139 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QGraphicsItem::GraphicsItemFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QGraphicsItem::GraphicsItemFlag> >::target_type & > ();
  ((QGraphicsItem *)cls)->setFlags (qt_gsi::QtToCppAdaptor<QFlags<QGraphicsItem::GraphicsItemFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFlags_4139 ()
{
  return new qt_gsi::GenericMethod ("setFlags|flags=", "@brief Method void QGraphicsItem::setFlags(QFlags<QGraphicsItem::GraphicsItemFlag> flags)\n", false, &_init_f_setFlags_4139, &_call_f_setFlags_4139);
}

// void QGraphicsItem::setFocus(Qt::FocusReason focusReason)


static void _init_f_setFocus_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focusReason", true, "Qt::OtherFocusReason");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusReason>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocus_1877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::FocusReason>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::FocusReason>::target_type & > () : (const qt_gsi::Converter<Qt::FocusReason>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::FocusReason>(heap, Qt::OtherFocusReason));
  ((QGraphicsItem *)cls)->setFocus (qt_gsi::QtToCppAdaptor<Qt::FocusReason>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFocus_1877 ()
{
  return new qt_gsi::GenericMethod ("setFocus", "@brief Method void QGraphicsItem::setFocus(Qt::FocusReason focusReason)\n", false, &_init_f_setFocus_1877, &_call_f_setFocus_1877);
}

// void QGraphicsItem::setFocusProxy(QGraphicsItem *item)


static void _init_f_setFocusProxy_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusProxy_1919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  ((QGraphicsItem *)cls)->setFocusProxy (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFocusProxy_1919 ()
{
  return new qt_gsi::GenericMethod ("setFocusProxy|focusProxy=", "@brief Method void QGraphicsItem::setFocusProxy(QGraphicsItem *item)\n", false, &_init_f_setFocusProxy_1919, &_call_f_setFocusProxy_1919);
}

// void QGraphicsItem::setGraphicsEffect(QGraphicsEffect *effect)


static void _init_f_setGraphicsEffect_2109 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("effect");
  decl->add_arg<QGraphicsEffect * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGraphicsEffect_2109 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsEffect *arg1 = args.read<QGraphicsEffect * > ();
  ((QGraphicsItem *)cls)->setGraphicsEffect (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGraphicsEffect_2109 ()
{
  return new qt_gsi::GenericMethod ("setGraphicsEffect|graphicsEffect=", "@brief Method void QGraphicsItem::setGraphicsEffect(QGraphicsEffect *effect)\n", false, &_init_f_setGraphicsEffect_2109, &_call_f_setGraphicsEffect_2109);
}

// void QGraphicsItem::setGroup(QGraphicsItemGroup *group)


static void _init_f_setGroup_2444 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("group");
  decl->add_arg<QGraphicsItemGroup * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGroup_2444 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItemGroup *arg1 = args.read<QGraphicsItemGroup * > ();
  ((QGraphicsItem *)cls)->setGroup (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGroup_2444 ()
{
  return new qt_gsi::GenericMethod ("setGroup|group=", "@brief Method void QGraphicsItem::setGroup(QGraphicsItemGroup *group)\n", false, &_init_f_setGroup_2444, &_call_f_setGroup_2444);
}

// void QGraphicsItem::setHandlesChildEvents(bool enabled)


static void _init_f_setHandlesChildEvents_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHandlesChildEvents_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsItem *)cls)->setHandlesChildEvents (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHandlesChildEvents_864 ()
{
  return new qt_gsi::GenericMethod ("setHandlesChildEvents|handlesChildEvents=", "@brief Method void QGraphicsItem::setHandlesChildEvents(bool enabled)\n", false, &_init_f_setHandlesChildEvents_864, &_call_f_setHandlesChildEvents_864);
}

// void QGraphicsItem::setInputMethodHints(QFlags<Qt::InputMethodHint> hints)


static void _init_f_setInputMethodHints_2985 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInputMethodHints_2985 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type & > ();
  ((QGraphicsItem *)cls)->setInputMethodHints (qt_gsi::QtToCppAdaptor<QFlags<Qt::InputMethodHint> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setInputMethodHints_2985 ()
{
  return new qt_gsi::GenericMethod ("setInputMethodHints|inputMethodHints=", "@brief Method void QGraphicsItem::setInputMethodHints(QFlags<Qt::InputMethodHint> hints)\n", false, &_init_f_setInputMethodHints_2985, &_call_f_setInputMethodHints_2985);
}

// void QGraphicsItem::setMatrix(const QMatrix &matrix, bool combine)


static void _init_f_setMatrix_2779 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMatrix_2779 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args.read<const QMatrix & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ((QGraphicsItem *)cls)->setMatrix (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setMatrix_2779 ()
{
  return new qt_gsi::GenericMethod ("setMatrix", "@brief Method void QGraphicsItem::setMatrix(const QMatrix &matrix, bool combine)\n", false, &_init_f_setMatrix_2779, &_call_f_setMatrix_2779);
}

// void QGraphicsItem::setOpacity(double opacity)


static void _init_f_setOpacity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opacity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpacity_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItem *)cls)->setOpacity (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOpacity_1071 ()
{
  return new qt_gsi::GenericMethod ("setOpacity|opacity=", "@brief Method void QGraphicsItem::setOpacity(double opacity)\n", false, &_init_f_setOpacity_1071, &_call_f_setOpacity_1071);
}

// void QGraphicsItem::setPanelModality(QGraphicsItem::PanelModality panelModality)


static void _init_f_setPanelModality_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("panelModality");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPanelModality_3180 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type & > ();
  ((QGraphicsItem *)cls)->setPanelModality (qt_gsi::QtToCppAdaptor<QGraphicsItem::PanelModality>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setPanelModality_3180 ()
{
  return new qt_gsi::GenericMethod ("setPanelModality|panelModality=", "@brief Method void QGraphicsItem::setPanelModality(QGraphicsItem::PanelModality panelModality)\n", false, &_init_f_setPanelModality_3180, &_call_f_setPanelModality_3180);
}

// void QGraphicsItem::setParentItem(QGraphicsItem *parent)


static void _init_f_setParentItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setParentItem_1919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  ((QGraphicsItem *)cls)->setParentItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_setParentItem_1919 ()
{
  return new qt_gsi::GenericMethod ("setParentItem|parentItem=", "@brief Method void QGraphicsItem::setParentItem(QGraphicsItem *parent)\n", false, &_init_f_setParentItem_1919, &_call_f_setParentItem_1919);
}

// void QGraphicsItem::setPos(const QPointF &pos)


static void _init_f_setPos_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPos_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QGraphicsItem *)cls)->setPos (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPos_1986 ()
{
  return new qt_gsi::GenericMethod ("setPos|pos=", "@brief Method void QGraphicsItem::setPos(const QPointF &pos)\n", false, &_init_f_setPos_1986, &_call_f_setPos_1986);
}

// void QGraphicsItem::setPos(double x, double y)


static void _init_f_setPos_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPos_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsItem *)cls)->setPos (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setPos_2034 ()
{
  return new qt_gsi::GenericMethod ("setPos", "@brief Method void QGraphicsItem::setPos(double x, double y)\n", false, &_init_f_setPos_2034, &_call_f_setPos_2034);
}

// void QGraphicsItem::setRotation(double angle)


static void _init_f_setRotation_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("angle");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRotation_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItem *)cls)->setRotation (arg1);
}

static qt_gsi::GenericMethod *_create_f_setRotation_1071 ()
{
  return new qt_gsi::GenericMethod ("setRotation|rotation=", "@brief Method void QGraphicsItem::setRotation(double angle)\n", false, &_init_f_setRotation_1071, &_call_f_setRotation_1071);
}

// void QGraphicsItem::setScale(double scale)


static void _init_f_setScale_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scale");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScale_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItem *)cls)->setScale (arg1);
}

static qt_gsi::GenericMethod *_create_f_setScale_1071 ()
{
  return new qt_gsi::GenericMethod ("setScale|scale=", "@brief Method void QGraphicsItem::setScale(double scale)\n", false, &_init_f_setScale_1071, &_call_f_setScale_1071);
}

// void QGraphicsItem::setSelected(bool selected)


static void _init_f_setSelected_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelected_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsItem *)cls)->setSelected (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSelected_864 ()
{
  return new qt_gsi::GenericMethod ("setSelected|selected=", "@brief Method void QGraphicsItem::setSelected(bool selected)\n", false, &_init_f_setSelected_864, &_call_f_setSelected_864);
}

// void QGraphicsItem::setToolTip(const QString &toolTip)


static void _init_f_setToolTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toolTip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTip_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QGraphicsItem *)cls)->setToolTip (arg1);
}

static qt_gsi::GenericMethod *_create_f_setToolTip_2025 ()
{
  return new qt_gsi::GenericMethod ("setToolTip|toolTip=", "@brief Method void QGraphicsItem::setToolTip(const QString &toolTip)\n", false, &_init_f_setToolTip_2025, &_call_f_setToolTip_2025);
}

// void QGraphicsItem::setTransform(const QTransform &matrix, bool combine)


static void _init_f_setTransform_3106 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTransform_3106 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ((QGraphicsItem *)cls)->setTransform (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setTransform_3106 ()
{
  return new qt_gsi::GenericMethod ("setTransform", "@brief Method void QGraphicsItem::setTransform(const QTransform &matrix, bool combine)\n", false, &_init_f_setTransform_3106, &_call_f_setTransform_3106);
}

// void QGraphicsItem::setTransformOriginPoint(const QPointF &origin)


static void _init_f_setTransformOriginPoint_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("origin");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTransformOriginPoint_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QGraphicsItem *)cls)->setTransformOriginPoint (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTransformOriginPoint_1986 ()
{
  return new qt_gsi::GenericMethod ("setTransformOriginPoint|transformOriginPoint=", "@brief Method void QGraphicsItem::setTransformOriginPoint(const QPointF &origin)\n", false, &_init_f_setTransformOriginPoint_1986, &_call_f_setTransformOriginPoint_1986);
}

// void QGraphicsItem::setTransformOriginPoint(double ax, double ay)


static void _init_f_setTransformOriginPoint_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ax");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ay");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTransformOriginPoint_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsItem *)cls)->setTransformOriginPoint (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setTransformOriginPoint_2034 ()
{
  return new qt_gsi::GenericMethod ("setTransformOriginPoint", "@brief Method void QGraphicsItem::setTransformOriginPoint(double ax, double ay)\n", false, &_init_f_setTransformOriginPoint_2034, &_call_f_setTransformOriginPoint_2034);
}

// void QGraphicsItem::setTransformations(const QList<QGraphicsTransform *> &transformations)


static void _init_f_setTransformations_3968 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("transformations");
  decl->add_arg<const qt_gsi::Converter<QList<QGraphicsTransform *> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTransformations_3968 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QGraphicsTransform *> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QGraphicsTransform *> >::target_type & > ();
  ((QGraphicsItem *)cls)->setTransformations (qt_gsi::QtToCppAdaptor<QList<QGraphicsTransform *> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setTransformations_3968 ()
{
  return new qt_gsi::GenericMethod ("setTransformations|transformations=", "@brief Method void QGraphicsItem::setTransformations(const QList<QGraphicsTransform *> &transformations)\n", false, &_init_f_setTransformations_3968, &_call_f_setTransformations_3968);
}

// void QGraphicsItem::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsItem *)cls)->setVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QGraphicsItem::setVisible(bool visible)\n", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
}

// void QGraphicsItem::setX(double x)


static void _init_f_setX_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setX_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItem *)cls)->setX (arg1);
}

static qt_gsi::GenericMethod *_create_f_setX_1071 ()
{
  return new qt_gsi::GenericMethod ("setX|x=", "@brief Method void QGraphicsItem::setX(double x)\n", false, &_init_f_setX_1071, &_call_f_setX_1071);
}

// void QGraphicsItem::setY(double y)


static void _init_f_setY_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setY_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItem *)cls)->setY (arg1);
}

static qt_gsi::GenericMethod *_create_f_setY_1071 ()
{
  return new qt_gsi::GenericMethod ("setY|y=", "@brief Method void QGraphicsItem::setY(double y)\n", false, &_init_f_setY_1071, &_call_f_setY_1071);
}

// void QGraphicsItem::setZValue(double z)


static void _init_f_setZValue_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("z");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setZValue_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItem *)cls)->setZValue (arg1);
}

static qt_gsi::GenericMethod *_create_f_setZValue_1071 ()
{
  return new qt_gsi::GenericMethod ("setZValue|zValue=", "@brief Method void QGraphicsItem::setZValue(double z)\n", false, &_init_f_setZValue_1071, &_call_f_setZValue_1071);
}

// QPainterPath QGraphicsItem::shape()


static void _init_f_shape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_shape_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->shape ());
}

static qt_gsi::GenericMethod *_create_f_shape_c0 ()
{
  return new qt_gsi::GenericMethod ("shape", "@brief Method QPainterPath QGraphicsItem::shape()\n", true, &_init_f_shape_c0, &_call_f_shape_c0);
}

// void QGraphicsItem::shear(double sh, double sv)


static void _init_f_shear_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sh");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sv");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_shear_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsItem *)cls)->shear (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_shear_2034 ()
{
  return new qt_gsi::GenericMethod ("shear", "@brief Method void QGraphicsItem::shear(double sh, double sv)\n", false, &_init_f_shear_2034, &_call_f_shear_2034);
}

// void QGraphicsItem::show()


static void _init_f_show_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_show_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem *)cls)->show ();
}

static qt_gsi::GenericMethod *_create_f_show_0 ()
{
  return new qt_gsi::GenericMethod ("show", "@brief Method void QGraphicsItem::show()\n", false, &_init_f_show_0, &_call_f_show_0);
}

// void QGraphicsItem::stackBefore(const QGraphicsItem *sibling)


static void _init_f_stackBefore_2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sibling");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stackBefore_2614 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ((QGraphicsItem *)cls)->stackBefore (arg1);
}

static qt_gsi::GenericMethod *_create_f_stackBefore_2614 ()
{
  return new qt_gsi::GenericMethod ("stackBefore", "@brief Method void QGraphicsItem::stackBefore(const QGraphicsItem *sibling)\n", false, &_init_f_stackBefore_2614, &_call_f_stackBefore_2614);
}

// QGraphicsObject *QGraphicsItem::toGraphicsObject()


static void _init_f_toGraphicsObject_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsObject * > ();
}

static void _call_f_toGraphicsObject_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsObject * > ((QGraphicsObject *)((QGraphicsItem *)cls)->toGraphicsObject ());
}

static qt_gsi::GenericMethod *_create_f_toGraphicsObject_0 ()
{
  return new qt_gsi::GenericMethod ("toGraphicsObject", "@brief Method QGraphicsObject *QGraphicsItem::toGraphicsObject()\n", false, &_init_f_toGraphicsObject_0, &_call_f_toGraphicsObject_0);
}

// const QGraphicsObject *QGraphicsItem::toGraphicsObject()


static void _init_f_toGraphicsObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QGraphicsObject * > ();
}

static void _call_f_toGraphicsObject_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QGraphicsObject * > ((const QGraphicsObject *)((QGraphicsItem *)cls)->toGraphicsObject ());
}

static qt_gsi::GenericMethod *_create_f_toGraphicsObject_c0 ()
{
  return new qt_gsi::GenericMethod ("toGraphicsObject", "@brief Method const QGraphicsObject *QGraphicsItem::toGraphicsObject()\n", true, &_init_f_toGraphicsObject_c0, &_call_f_toGraphicsObject_c0);
}

// QString QGraphicsItem::toolTip()


static void _init_f_toolTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toolTip_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QGraphicsItem *)cls)->toolTip ());
}

static qt_gsi::GenericMethod *_create_f_toolTip_c0 ()
{
  return new qt_gsi::GenericMethod (":toolTip", "@brief Method QString QGraphicsItem::toolTip()\n", true, &_init_f_toolTip_c0, &_call_f_toolTip_c0);
}

// QGraphicsItem *QGraphicsItem::topLevelItem()


static void _init_f_topLevelItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_topLevelItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->topLevelItem ());
}

static qt_gsi::GenericMethod *_create_f_topLevelItem_c0 ()
{
  return new qt_gsi::GenericMethod ("topLevelItem", "@brief Method QGraphicsItem *QGraphicsItem::topLevelItem()\n", true, &_init_f_topLevelItem_c0, &_call_f_topLevelItem_c0);
}

// QGraphicsWidget *QGraphicsItem::topLevelWidget()


static void _init_f_topLevelWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsWidget * > ();
}

static void _call_f_topLevelWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsWidget * > ((QGraphicsWidget *)((QGraphicsItem *)cls)->topLevelWidget ());
}

static qt_gsi::GenericMethod *_create_f_topLevelWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("topLevelWidget", "@brief Method QGraphicsWidget *QGraphicsItem::topLevelWidget()\n", true, &_init_f_topLevelWidget_c0, &_call_f_topLevelWidget_c0);
}

// QTransform QGraphicsItem::transform()


static void _init_f_transform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_transform_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTransform > ((QTransform)((QGraphicsItem *)cls)->transform ());
}

static qt_gsi::GenericMethod *_create_f_transform_c0 ()
{
  return new qt_gsi::GenericMethod (":transform", "@brief Method QTransform QGraphicsItem::transform()\n", true, &_init_f_transform_c0, &_call_f_transform_c0);
}

// QPointF QGraphicsItem::transformOriginPoint()


static void _init_f_transformOriginPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_transformOriginPoint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->transformOriginPoint ());
}

static qt_gsi::GenericMethod *_create_f_transformOriginPoint_c0 ()
{
  return new qt_gsi::GenericMethod (":transformOriginPoint", "@brief Method QPointF QGraphicsItem::transformOriginPoint()\n", true, &_init_f_transformOriginPoint_c0, &_call_f_transformOriginPoint_c0);
}

// QList<QGraphicsTransform *> QGraphicsItem::transformations()


static void _init_f_transformations_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QGraphicsTransform *> >::target_type > ();
}

static void _call_f_transformations_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QGraphicsTransform *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsTransform *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsTransform *> >(((QGraphicsItem *)cls)->transformations ()));
}

static qt_gsi::GenericMethod *_create_f_transformations_c0 ()
{
  return new qt_gsi::GenericMethod (":transformations", "@brief Method QList<QGraphicsTransform *> QGraphicsItem::transformations()\n", true, &_init_f_transformations_c0, &_call_f_transformations_c0);
}

// void QGraphicsItem::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsItem *)cls)->translate (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_translate_2034 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QGraphicsItem::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
}

// int QGraphicsItem::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QGraphicsItem *)cls)->type ());
}

static qt_gsi::GenericMethod *_create_f_type_c0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Method int QGraphicsItem::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
}

// void QGraphicsItem::ungrabKeyboard()


static void _init_f_ungrabKeyboard_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ungrabKeyboard_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem *)cls)->ungrabKeyboard ();
}

static qt_gsi::GenericMethod *_create_f_ungrabKeyboard_0 ()
{
  return new qt_gsi::GenericMethod ("ungrabKeyboard", "@brief Method void QGraphicsItem::ungrabKeyboard()\n", false, &_init_f_ungrabKeyboard_0, &_call_f_ungrabKeyboard_0);
}

// void QGraphicsItem::ungrabMouse()


static void _init_f_ungrabMouse_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ungrabMouse_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem *)cls)->ungrabMouse ();
}

static qt_gsi::GenericMethod *_create_f_ungrabMouse_0 ()
{
  return new qt_gsi::GenericMethod ("ungrabMouse", "@brief Method void QGraphicsItem::ungrabMouse()\n", false, &_init_f_ungrabMouse_0, &_call_f_ungrabMouse_0);
}

// void QGraphicsItem::unsetCursor()


static void _init_f_unsetCursor_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetCursor_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem *)cls)->unsetCursor ();
}

static qt_gsi::GenericMethod *_create_f_unsetCursor_0 ()
{
  return new qt_gsi::GenericMethod ("unsetCursor", "@brief Method void QGraphicsItem::unsetCursor()\n", false, &_init_f_unsetCursor_0, &_call_f_unsetCursor_0);
}

// void QGraphicsItem::update(const QRectF &rect)


static void _init_f_update_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  ((QGraphicsItem *)cls)->update (arg1);
}

static qt_gsi::GenericMethod *_create_f_update_1862 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QGraphicsItem::update(const QRectF &rect)\n", false, &_init_f_update_1862, &_call_f_update_1862);
}

// void QGraphicsItem::update(double x, double y, double width, double height)


static void _init_f_update_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("width");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("height");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_update_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QGraphicsItem *)cls)->update (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_update_3960 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QGraphicsItem::update(double x, double y, double width, double height)\n", false, &_init_f_update_3960, &_call_f_update_3960);
}

// QGraphicsWidget *QGraphicsItem::window()


static void _init_f_window_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsWidget * > ();
}

static void _call_f_window_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsWidget * > ((QGraphicsWidget *)((QGraphicsItem *)cls)->window ());
}

static qt_gsi::GenericMethod *_create_f_window_c0 ()
{
  return new qt_gsi::GenericMethod ("window", "@brief Method QGraphicsWidget *QGraphicsItem::window()\n", true, &_init_f_window_c0, &_call_f_window_c0);
}

// double QGraphicsItem::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsItem *)cls)->x ());
}

static qt_gsi::GenericMethod *_create_f_x_c0 ()
{
  return new qt_gsi::GenericMethod (":x", "@brief Method double QGraphicsItem::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
}

// double QGraphicsItem::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsItem *)cls)->y ());
}

static qt_gsi::GenericMethod *_create_f_y_c0 ()
{
  return new qt_gsi::GenericMethod (":y", "@brief Method double QGraphicsItem::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
}

// double QGraphicsItem::zValue()


static void _init_f_zValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_zValue_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsItem *)cls)->zValue ());
}

static qt_gsi::GenericMethod *_create_f_zValue_c0 ()
{
  return new qt_gsi::GenericMethod (":zValue", "@brief Method double QGraphicsItem::zValue()\n", true, &_init_f_zValue_c0, &_call_f_zValue_c0);
}

namespace gsi
{
gsi::Class<QGraphicsItem> decl_QGraphicsItem ("QGraphicsItem_Native",
  gsi::Methods(_create_f_acceptDrops_c0 ()) +
  gsi::Methods(_create_f_acceptHoverEvents_c0 ()) +
  gsi::Methods(_create_f_acceptTouchEvents_c0 ()) +
  gsi::Methods(_create_f_acceptedMouseButtons_c0 ()) +
  gsi::Methods(_create_f_acceptsHoverEvents_c0 ()) +
  gsi::Methods(_create_f_advance_767 ()) +
  gsi::Methods(_create_f_boundingRect_c0 ()) +
  gsi::Methods(_create_f_boundingRegion_c2350 ()) +
  gsi::Methods(_create_f_boundingRegionGranularity_c0 ()) +
  gsi::Methods(_create_f_cacheMode_c0 ()) +
  gsi::Methods(_create_f_childItems_c0 ()) +
  gsi::Methods(_create_f_children_c0 ()) +
  gsi::Methods(_create_f_childrenBoundingRect_c0 ()) +
  gsi::Methods(_create_f_clearFocus_0 ()) +
  gsi::Methods(_create_f_clipPath_c0 ()) +
  gsi::Methods(_create_f_collidesWithItem_c4977 ()) +
  gsi::Methods(_create_f_collidesWithPath_c4877 ()) +
  gsi::Methods(_create_f_collidingItems_c2471 ()) +
  gsi::Methods(_create_f_commonAncestorItem_c2614 ()) +
  gsi::Methods(_create_f_contains_c1986 ()) +
  gsi::Methods(_create_f_cursor_c0 ()) +
  gsi::Methods(_create_f_data_c767 ()) +
  gsi::Methods(_create_f_deviceTransform_c2350 ()) +
  gsi::Methods(_create_f_effectiveOpacity_c0 ()) +
  gsi::Methods(_create_f_ensureVisible_3180 ()) +
  gsi::Methods(_create_f_ensureVisible_5278 ()) +
  gsi::Methods(_create_f_filtersChildEvents_c0 ()) +
  gsi::Methods(_create_f_flags_c0 ()) +
  gsi::Methods(_create_f_focusItem_c0 ()) +
  gsi::Methods(_create_f_focusProxy_c0 ()) +
  gsi::Methods(_create_f_focusScopeItem_c0 ()) +
  gsi::Methods(_create_f_grabKeyboard_0 ()) +
  gsi::Methods(_create_f_grabMouse_0 ()) +
  gsi::Methods(_create_f_graphicsEffect_c0 ()) +
  gsi::Methods(_create_f_group_c0 ()) +
  gsi::Methods(_create_f_handlesChildEvents_c0 ()) +
  gsi::Methods(_create_f_hasCursor_c0 ()) +
  gsi::Methods(_create_f_hasFocus_c0 ()) +
  gsi::Methods(_create_f_hide_0 ()) +
  gsi::Methods(_create_f_inputMethodHints_c0 ()) +
  gsi::Methods(_create_f_installSceneEventFilter_1919 ()) +
  gsi::Methods(_create_f_isActive_c0 ()) +
  gsi::Methods(_create_f_isAncestorOf_c2614 ()) +
  gsi::Methods(_create_f_isClipped_c0 ()) +
  gsi::Methods(_create_f_isEnabled_c0 ()) +
  gsi::Methods(_create_f_isObscured_c0 ()) +
  gsi::Methods(_create_f_isObscured_c1862 ()) +
  gsi::Methods(_create_f_isObscured_c3960 ()) +
  gsi::Methods(_create_f_isObscuredBy_c2614 ()) +
  gsi::Methods(_create_f_isPanel_c0 ()) +
  gsi::Methods(_create_f_isSelected_c0 ()) +
  gsi::Methods(_create_f_isUnderMouse_c0 ()) +
  gsi::Methods(_create_f_isVisible_c0 ()) +
  gsi::Methods(_create_f_isVisibleTo_c2614 ()) +
  gsi::Methods(_create_f_isWidget_c0 ()) +
  gsi::Methods(_create_f_isWindow_c0 ()) +
  gsi::Methods(_create_f_itemTransform_c3556 ()) +
  gsi::Methods(_create_f_mapFromItem_c4492 ()) +
  gsi::Methods(_create_f_mapFromItem_c4368 ()) +
  gsi::Methods(_create_f_mapFromItem_c4714 ()) +
  gsi::Methods(_create_f_mapFromItem_c5020 ()) +
  gsi::Methods(_create_f_mapFromItem_c4540 ()) +
  gsi::Methods(_create_f_mapFromItem_c6466 ()) +
  gsi::Methods(_create_f_mapFromParent_c1986 ()) +
  gsi::Methods(_create_f_mapFromParent_c1862 ()) +
  gsi::Methods(_create_f_mapFromParent_c2208 ()) +
  gsi::Methods(_create_f_mapFromParent_c2514 ()) +
  gsi::Methods(_create_f_mapFromParent_c2034 ()) +
  gsi::Methods(_create_f_mapFromParent_c3960 ()) +
  gsi::Methods(_create_f_mapFromScene_c1986 ()) +
  gsi::Methods(_create_f_mapFromScene_c1862 ()) +
  gsi::Methods(_create_f_mapFromScene_c2208 ()) +
  gsi::Methods(_create_f_mapFromScene_c2514 ()) +
  gsi::Methods(_create_f_mapFromScene_c2034 ()) +
  gsi::Methods(_create_f_mapFromScene_c3960 ()) +
  gsi::Methods(_create_f_mapRectFromItem_c4368 ()) +
  gsi::Methods(_create_f_mapRectFromItem_c6466 ()) +
  gsi::Methods(_create_f_mapRectFromParent_c1862 ()) +
  gsi::Methods(_create_f_mapRectFromParent_c3960 ()) +
  gsi::Methods(_create_f_mapRectFromScene_c1862 ()) +
  gsi::Methods(_create_f_mapRectFromScene_c3960 ()) +
  gsi::Methods(_create_f_mapRectToItem_c4368 ()) +
  gsi::Methods(_create_f_mapRectToItem_c6466 ()) +
  gsi::Methods(_create_f_mapRectToParent_c1862 ()) +
  gsi::Methods(_create_f_mapRectToParent_c3960 ()) +
  gsi::Methods(_create_f_mapRectToScene_c1862 ()) +
  gsi::Methods(_create_f_mapRectToScene_c3960 ()) +
  gsi::Methods(_create_f_mapToItem_c4492 ()) +
  gsi::Methods(_create_f_mapToItem_c4368 ()) +
  gsi::Methods(_create_f_mapToItem_c4714 ()) +
  gsi::Methods(_create_f_mapToItem_c5020 ()) +
  gsi::Methods(_create_f_mapToItem_c4540 ()) +
  gsi::Methods(_create_f_mapToItem_c6466 ()) +
  gsi::Methods(_create_f_mapToParent_c1986 ()) +
  gsi::Methods(_create_f_mapToParent_c1862 ()) +
  gsi::Methods(_create_f_mapToParent_c2208 ()) +
  gsi::Methods(_create_f_mapToParent_c2514 ()) +
  gsi::Methods(_create_f_mapToParent_c2034 ()) +
  gsi::Methods(_create_f_mapToParent_c3960 ()) +
  gsi::Methods(_create_f_mapToScene_c1986 ()) +
  gsi::Methods(_create_f_mapToScene_c1862 ()) +
  gsi::Methods(_create_f_mapToScene_c2208 ()) +
  gsi::Methods(_create_f_mapToScene_c2514 ()) +
  gsi::Methods(_create_f_mapToScene_c2034 ()) +
  gsi::Methods(_create_f_mapToScene_c3960 ()) +
  gsi::Methods(_create_f_matrix_c0 ()) +
  gsi::Methods(_create_f_moveBy_2034 ()) +
  gsi::Methods(_create_f_opacity_c0 ()) +
  gsi::Methods(_create_f_opaqueArea_c0 ()) +
  gsi::Methods(_create_f_paint_6301 ()) +
  gsi::Methods(_create_f_panel_c0 ()) +
  gsi::Methods(_create_f_panelModality_c0 ()) +
  gsi::Methods(_create_f_parentItem_c0 ()) +
  gsi::Methods(_create_f_parentObject_c0 ()) +
  gsi::Methods(_create_f_parentWidget_c0 ()) +
  gsi::Methods(_create_f_pos_c0 ()) +
  gsi::Methods(_create_f_removeSceneEventFilter_1919 ()) +
  gsi::Methods(_create_f_resetMatrix_0 ()) +
  gsi::Methods(_create_f_resetTransform_0 ()) +
  gsi::Methods(_create_f_rotate_1071 ()) +
  gsi::Methods(_create_f_rotation_c0 ()) +
  gsi::Methods(_create_f_scale_2034 ()) +
  gsi::Methods(_create_f_scale_c0 ()) +
  gsi::Methods(_create_f_scene_c0 ()) +
  gsi::Methods(_create_f_sceneBoundingRect_c0 ()) +
  gsi::Methods(_create_f_sceneMatrix_c0 ()) +
  gsi::Methods(_create_f_scenePos_c0 ()) +
  gsi::Methods(_create_f_sceneTransform_c0 ()) +
  gsi::Methods(_create_f_scroll_3788 ()) +
  gsi::Methods(_create_f_setAcceptDrops_864 ()) +
  gsi::Methods(_create_f_setAcceptHoverEvents_864 ()) +
  gsi::Methods(_create_f_setAcceptTouchEvents_864 ()) +
  gsi::Methods(_create_f_setAcceptedMouseButtons_2602 ()) +
  gsi::Methods(_create_f_setAcceptsHoverEvents_864 ()) +
  gsi::Methods(_create_f_setActive_864 ()) +
  gsi::Methods(_create_f_setBoundingRegionGranularity_1071 ()) +
  gsi::Methods(_create_f_setCacheMode_4403 ()) +
  gsi::Methods(_create_f_setCursor_2032 ()) +
  gsi::Methods(_create_f_setData_2778 ()) +
  gsi::Methods(_create_f_setEnabled_864 ()) +
  gsi::Methods(_create_f_setFiltersChildEvents_864 ()) +
  gsi::Methods(_create_f_setFlag_4199 ()) +
  gsi::Methods(_create_f_setFlags_4139 ()) +
  gsi::Methods(_create_f_setFocus_1877 ()) +
  gsi::Methods(_create_f_setFocusProxy_1919 ()) +
  gsi::Methods(_create_f_setGraphicsEffect_2109 ()) +
  gsi::Methods(_create_f_setGroup_2444 ()) +
  gsi::Methods(_create_f_setHandlesChildEvents_864 ()) +
  gsi::Methods(_create_f_setInputMethodHints_2985 ()) +
  gsi::Methods(_create_f_setMatrix_2779 ()) +
  gsi::Methods(_create_f_setOpacity_1071 ()) +
  gsi::Methods(_create_f_setPanelModality_3180 ()) +
  gsi::Methods(_create_f_setParentItem_1919 ()) +
  gsi::Methods(_create_f_setPos_1986 ()) +
  gsi::Methods(_create_f_setPos_2034 ()) +
  gsi::Methods(_create_f_setRotation_1071 ()) +
  gsi::Methods(_create_f_setScale_1071 ()) +
  gsi::Methods(_create_f_setSelected_864 ()) +
  gsi::Methods(_create_f_setToolTip_2025 ()) +
  gsi::Methods(_create_f_setTransform_3106 ()) +
  gsi::Methods(_create_f_setTransformOriginPoint_1986 ()) +
  gsi::Methods(_create_f_setTransformOriginPoint_2034 ()) +
  gsi::Methods(_create_f_setTransformations_3968 ()) +
  gsi::Methods(_create_f_setVisible_864 ()) +
  gsi::Methods(_create_f_setX_1071 ()) +
  gsi::Methods(_create_f_setY_1071 ()) +
  gsi::Methods(_create_f_setZValue_1071 ()) +
  gsi::Methods(_create_f_shape_c0 ()) +
  gsi::Methods(_create_f_shear_2034 ()) +
  gsi::Methods(_create_f_show_0 ()) +
  gsi::Methods(_create_f_stackBefore_2614 ()) +
  gsi::Methods(_create_f_toGraphicsObject_0 ()) +
  gsi::Methods(_create_f_toGraphicsObject_c0 ()) +
  gsi::Methods(_create_f_toolTip_c0 ()) +
  gsi::Methods(_create_f_topLevelItem_c0 ()) +
  gsi::Methods(_create_f_topLevelWidget_c0 ()) +
  gsi::Methods(_create_f_transform_c0 ()) +
  gsi::Methods(_create_f_transformOriginPoint_c0 ()) +
  gsi::Methods(_create_f_transformations_c0 ()) +
  gsi::Methods(_create_f_translate_2034 ()) +
  gsi::Methods(_create_f_type_c0 ()) +
  gsi::Methods(_create_f_ungrabKeyboard_0 ()) +
  gsi::Methods(_create_f_ungrabMouse_0 ()) +
  gsi::Methods(_create_f_unsetCursor_0 ()) +
  gsi::Methods(_create_f_update_1862 ()) +
  gsi::Methods(_create_f_update_3960 ()) +
  gsi::Methods(_create_f_window_c0 ()) +
  gsi::Methods(_create_f_x_c0 ()) +
  gsi::Methods(_create_f_y_c0 ()) +
  gsi::Methods(_create_f_zValue_c0 ()),
  "@hide\n@alias QGraphicsItem");
}


class QGraphicsItem_Adaptor : public QGraphicsItem, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsItem_Adaptor();

  //  [adaptor ctor] QGraphicsItem::QGraphicsItem(QGraphicsItem *parent, QGraphicsScene *scene)
  QGraphicsItem_Adaptor() : QGraphicsItem()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsItem::QGraphicsItem(QGraphicsItem *parent, QGraphicsScene *scene)
  QGraphicsItem_Adaptor(QGraphicsItem *parent) : QGraphicsItem(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsItem::QGraphicsItem(QGraphicsItem *parent, QGraphicsScene *scene)
  QGraphicsItem_Adaptor(QGraphicsItem *parent, QGraphicsScene *scene) : QGraphicsItem(parent, scene)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QGraphicsItem::addToIndex()
  void fp_QGraphicsItem_addToIndex_0 () {
    QGraphicsItem::addToIndex();
  }

  //  void QGraphicsItem::prepareGeometryChange()
  void fp_QGraphicsItem_prepareGeometryChange_0 () {
    QGraphicsItem::prepareGeometryChange();
  }

  //  void QGraphicsItem::removeFromIndex()
  void fp_QGraphicsItem_removeFromIndex_0 () {
    QGraphicsItem::removeFromIndex();
  }

  //  [adaptor impl] void QGraphicsItem::advance(int phase)
  void cbs_advance_767_0(int phase)
  {
    QGraphicsItem::advance(phase);
  }

  virtual void advance(int phase)
  {
    if (cb_advance_767_0.can_issue()) {
      cb_advance_767_0.issue<QGraphicsItem_Adaptor, int>(&QGraphicsItem_Adaptor::cbs_advance_767_0, phase);
    } else {
      QGraphicsItem::advance(phase);
    }
  }

  //  [adaptor impl] QRectF QGraphicsItem::boundingRect()
  QRectF cbs_boundingRect_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("boundingRect");
  }

  virtual QRectF boundingRect() const
  {
    if (cb_boundingRect_c0_0.can_issue()) {
      return cb_boundingRect_c0_0.issue<QGraphicsItem_Adaptor, QRectF>(&QGraphicsItem_Adaptor::cbs_boundingRect_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("boundingRect");
    }
  }

  //  [adaptor impl] bool QGraphicsItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithItem_c4977_1(const QGraphicsItem *other, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsItem::collidesWithItem(other, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithItem_c4977_1.can_issue()) {
      return cb_collidesWithItem_c4977_1.issue<QGraphicsItem_Adaptor, bool, const QGraphicsItem *, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsItem_Adaptor::cbs_collidesWithItem_c4977_1, other, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsItem::collidesWithItem(other, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithPath_c4877_1(const QPainterPath &path, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsItem::collidesWithPath(path, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithPath_c4877_1.can_issue()) {
      return cb_collidesWithPath_c4877_1.issue<QGraphicsItem_Adaptor, bool, const QPainterPath &, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsItem_Adaptor::cbs_collidesWithPath_c4877_1, path, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsItem::collidesWithPath(path, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::contains(const QPointF &point)
  bool cbs_contains_c1986_0(const QPointF &point) const
  {
    return QGraphicsItem::contains(point);
  }

  virtual bool contains(const QPointF &point) const
  {
    if (cb_contains_c1986_0.can_issue()) {
      return cb_contains_c1986_0.issue<QGraphicsItem_Adaptor, bool, const QPointF &>(&QGraphicsItem_Adaptor::cbs_contains_c1986_0, point);
    } else {
      return QGraphicsItem::contains(point);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::isObscuredBy(const QGraphicsItem *item)
  bool cbs_isObscuredBy_c2614_0(const QGraphicsItem *item) const
  {
    return QGraphicsItem::isObscuredBy(item);
  }

  virtual bool isObscuredBy(const QGraphicsItem *item) const
  {
    if (cb_isObscuredBy_c2614_0.can_issue()) {
      return cb_isObscuredBy_c2614_0.issue<QGraphicsItem_Adaptor, bool, const QGraphicsItem *>(&QGraphicsItem_Adaptor::cbs_isObscuredBy_c2614_0, item);
    } else {
      return QGraphicsItem::isObscuredBy(item);
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsItem::opaqueArea()
  QPainterPath cbs_opaqueArea_c0_0() const
  {
    return QGraphicsItem::opaqueArea();
  }

  virtual QPainterPath opaqueArea() const
  {
    if (cb_opaqueArea_c0_0.can_issue()) {
      return cb_opaqueArea_c0_0.issue<QGraphicsItem_Adaptor, QPainterPath>(&QGraphicsItem_Adaptor::cbs_opaqueArea_c0_0);
    } else {
      return QGraphicsItem::opaqueArea();
    }
  }

  //  [adaptor impl] void QGraphicsItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paint_6301_1(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    throw qt_gsi::AbstractMethodCalledException("paint");
  }

  virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paint_6301_1.can_issue()) {
      cb_paint_6301_1.issue<QGraphicsItem_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QGraphicsItem_Adaptor::cbs_paint_6301_1, painter, option, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("paint");
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsItem::shape()
  QPainterPath cbs_shape_c0_0() const
  {
    return QGraphicsItem::shape();
  }

  virtual QPainterPath shape() const
  {
    if (cb_shape_c0_0.can_issue()) {
      return cb_shape_c0_0.issue<QGraphicsItem_Adaptor, QPainterPath>(&QGraphicsItem_Adaptor::cbs_shape_c0_0);
    } else {
      return QGraphicsItem::shape();
    }
  }

  //  [adaptor impl] int QGraphicsItem::type()
  int cbs_type_c0_0() const
  {
    return QGraphicsItem::type();
  }

  virtual int type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return cb_type_c0_0.issue<QGraphicsItem_Adaptor, int>(&QGraphicsItem_Adaptor::cbs_type_c0_0);
    } else {
      return QGraphicsItem::type();
    }
  }

  //  [adaptor impl] void QGraphicsItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  void cbs_contextMenuEvent_3674_0(QGraphicsSceneContextMenuEvent *event)
  {
    QGraphicsItem::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_3674_0.can_issue()) {
      cb_contextMenuEvent_3674_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneContextMenuEvent *>(&QGraphicsItem_Adaptor::cbs_contextMenuEvent_3674_0, event);
    } else {
      QGraphicsItem::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragEnterEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsItem::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragEnterEvent_3315_0.can_issue()) {
      cb_dragEnterEvent_3315_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsItem_Adaptor::cbs_dragEnterEvent_3315_0, event);
    } else {
      QGraphicsItem::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragLeaveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsItem::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragLeaveEvent_3315_0.can_issue()) {
      cb_dragLeaveEvent_3315_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsItem_Adaptor::cbs_dragLeaveEvent_3315_0, event);
    } else {
      QGraphicsItem::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragMoveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsItem::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragMoveEvent_3315_0.can_issue()) {
      cb_dragMoveEvent_3315_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsItem_Adaptor::cbs_dragMoveEvent_3315_0, event);
    } else {
      QGraphicsItem::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::dropEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dropEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsItem::dropEvent(event);
  }

  virtual void dropEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dropEvent_3315_0.can_issue()) {
      cb_dropEvent_3315_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsItem_Adaptor::cbs_dropEvent_3315_0, event);
    } else {
      QGraphicsItem::dropEvent(event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsItem::extension(const QVariant &variant)
  QVariant cbs_extension_c2119_0(const QVariant &variant) const
  {
    return QGraphicsItem::extension(variant);
  }

  virtual QVariant extension(const QVariant &variant) const
  {
    if (cb_extension_c2119_0.can_issue()) {
      return cb_extension_c2119_0.issue<QGraphicsItem_Adaptor, QVariant, const QVariant &>(&QGraphicsItem_Adaptor::cbs_extension_c2119_0, variant);
    } else {
      return QGraphicsItem::extension(variant);
    }
  }

  //  [adaptor impl] void QGraphicsItem::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsItem::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsItem_Adaptor, QFocusEvent *>(&QGraphicsItem_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsItem::focusInEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsItem::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsItem_Adaptor, QFocusEvent *>(&QGraphicsItem_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsItem::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverEnterEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsItem::hoverEnterEvent(event);
  }

  virtual void hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverEnterEvent_3044_0.can_issue()) {
      cb_hoverEnterEvent_3044_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsItem_Adaptor::cbs_hoverEnterEvent_3044_0, event);
    } else {
      QGraphicsItem::hoverEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverLeaveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsItem::hoverLeaveEvent(event);
  }

  virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverLeaveEvent_3044_0.can_issue()) {
      cb_hoverLeaveEvent_3044_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsItem_Adaptor::cbs_hoverLeaveEvent_3044_0, event);
    } else {
      QGraphicsItem::hoverLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverMoveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsItem::hoverMoveEvent(event);
  }

  virtual void hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverMoveEvent_3044_0.can_issue()) {
      cb_hoverMoveEvent_3044_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsItem_Adaptor::cbs_hoverMoveEvent_3044_0, event);
    } else {
      QGraphicsItem::hoverMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsItem::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsItem_Adaptor, QInputMethodEvent *>(&QGraphicsItem_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsItem::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsItem::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsItem::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsItem_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsItem_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsItem::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QVariant QGraphicsItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  QVariant cbs_itemChange_5658_0(const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & change, const QVariant &value)
  {
    return QGraphicsItem::itemChange(qt_gsi::QtToCppAdaptor<QGraphicsItem::GraphicsItemChange>(change).cref(), value);
  }

  virtual QVariant itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  {
    if (cb_itemChange_5658_0.can_issue()) {
      return cb_itemChange_5658_0.issue<QGraphicsItem_Adaptor, QVariant, const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type &, const QVariant &>(&QGraphicsItem_Adaptor::cbs_itemChange_5658_0, qt_gsi::CppToQtAdaptor<QGraphicsItem::GraphicsItemChange>(change), value);
    } else {
      return QGraphicsItem::itemChange(change, value);
    }
  }

  //  [adaptor impl] void QGraphicsItem::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsItem::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsItem_Adaptor, QKeyEvent *>(&QGraphicsItem_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsItem::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsItem::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsItem_Adaptor, QKeyEvent *>(&QGraphicsItem_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsItem::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseDoubleClickEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsItem::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_3049_0.can_issue()) {
      cb_mouseDoubleClickEvent_3049_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsItem_Adaptor::cbs_mouseDoubleClickEvent_3049_0, event);
    } else {
      QGraphicsItem::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseMoveEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsItem::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseMoveEvent_3049_0.can_issue()) {
      cb_mouseMoveEvent_3049_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsItem_Adaptor::cbs_mouseMoveEvent_3049_0, event);
    } else {
      QGraphicsItem::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::mousePressEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mousePressEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsItem::mousePressEvent(event);
  }

  virtual void mousePressEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mousePressEvent_3049_0.can_issue()) {
      cb_mousePressEvent_3049_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsItem_Adaptor::cbs_mousePressEvent_3049_0, event);
    } else {
      QGraphicsItem::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseReleaseEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsItem::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_3049_0.can_issue()) {
      cb_mouseReleaseEvent_3049_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsItem_Adaptor::cbs_mouseReleaseEvent_3049_0, event);
    } else {
      QGraphicsItem::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::sceneEvent(QEvent *event)
  bool cbs_sceneEvent_1217_0(QEvent *event)
  {
    return QGraphicsItem::sceneEvent(event);
  }

  virtual bool sceneEvent(QEvent *event)
  {
    if (cb_sceneEvent_1217_0.can_issue()) {
      return cb_sceneEvent_1217_0.issue<QGraphicsItem_Adaptor, bool, QEvent *>(&QGraphicsItem_Adaptor::cbs_sceneEvent_1217_0, event);
    } else {
      return QGraphicsItem::sceneEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  bool cbs_sceneEventFilter_3028_0(QGraphicsItem *watched, QEvent *event)
  {
    return QGraphicsItem::sceneEventFilter(watched, event);
  }

  virtual bool sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  {
    if (cb_sceneEventFilter_3028_0.can_issue()) {
      return cb_sceneEventFilter_3028_0.issue<QGraphicsItem_Adaptor, bool, QGraphicsItem *, QEvent *>(&QGraphicsItem_Adaptor::cbs_sceneEventFilter_3028_0, watched, event);
    } else {
      return QGraphicsItem::sceneEventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  void cbs_setExtension_4817_0(unsigned int extension, const QVariant &variant)
  {
    QGraphicsItem::setExtension(QGraphicsItem::Extension(extension), variant);
  }

  virtual void setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  {
    if (cb_setExtension_4817_0.can_issue()) {
      cb_setExtension_4817_0.issue<QGraphicsItem_Adaptor, unsigned int, const QVariant &>(&QGraphicsItem_Adaptor::cbs_setExtension_4817_0, (unsigned int)(extension), variant);
    } else {
      QGraphicsItem::setExtension(extension, variant);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::supportsExtension(QGraphicsItem::Extension extension)
  bool cbs_supportsExtension_c2806_0(unsigned int extension) const
  {
    return QGraphicsItem::supportsExtension(QGraphicsItem::Extension(extension));
  }

  virtual bool supportsExtension(QGraphicsItem::Extension extension) const
  {
    if (cb_supportsExtension_c2806_0.can_issue()) {
      return cb_supportsExtension_c2806_0.issue<QGraphicsItem_Adaptor, bool, unsigned int>(&QGraphicsItem_Adaptor::cbs_supportsExtension_c2806_0, (unsigned int)(extension));
    } else {
      return QGraphicsItem::supportsExtension(extension);
    }
  }

  //  [adaptor impl] void QGraphicsItem::wheelEvent(QGraphicsSceneWheelEvent *event)
  void cbs_wheelEvent_3029_0(QGraphicsSceneWheelEvent *event)
  {
    QGraphicsItem::wheelEvent(event);
  }

  virtual void wheelEvent(QGraphicsSceneWheelEvent *event)
  {
    if (cb_wheelEvent_3029_0.can_issue()) {
      cb_wheelEvent_3029_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneWheelEvent *>(&QGraphicsItem_Adaptor::cbs_wheelEvent_3029_0, event);
    } else {
      QGraphicsItem::wheelEvent(event);
    }
  }

  gsi::Callback cb_advance_767_0;
  gsi::Callback cb_boundingRect_c0_0;
  gsi::Callback cb_collidesWithItem_c4977_1;
  gsi::Callback cb_collidesWithPath_c4877_1;
  gsi::Callback cb_contains_c1986_0;
  gsi::Callback cb_isObscuredBy_c2614_0;
  gsi::Callback cb_opaqueArea_c0_0;
  gsi::Callback cb_paint_6301_1;
  gsi::Callback cb_shape_c0_0;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_contextMenuEvent_3674_0;
  gsi::Callback cb_dragEnterEvent_3315_0;
  gsi::Callback cb_dragLeaveEvent_3315_0;
  gsi::Callback cb_dragMoveEvent_3315_0;
  gsi::Callback cb_dropEvent_3315_0;
  gsi::Callback cb_extension_c2119_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hoverEnterEvent_3044_0;
  gsi::Callback cb_hoverLeaveEvent_3044_0;
  gsi::Callback cb_hoverMoveEvent_3044_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_itemChange_5658_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_3049_0;
  gsi::Callback cb_mouseMoveEvent_3049_0;
  gsi::Callback cb_mousePressEvent_3049_0;
  gsi::Callback cb_mouseReleaseEvent_3049_0;
  gsi::Callback cb_sceneEvent_1217_0;
  gsi::Callback cb_sceneEventFilter_3028_0;
  gsi::Callback cb_setExtension_4817_0;
  gsi::Callback cb_supportsExtension_c2806_0;
  gsi::Callback cb_wheelEvent_3029_0;
};

QGraphicsItem_Adaptor::~QGraphicsItem_Adaptor() { }

//  Constructor QGraphicsItem::QGraphicsItem(QGraphicsItem *parent, QGraphicsScene *scene) (adaptor class)

static void _init_ctor_QGraphicsItem_Adaptor_3825 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("scene", true, "0");
  decl->add_arg<QGraphicsScene * > (argspec_1);
  decl->set_return_new<QGraphicsItem_Adaptor *> ();
}

static void _call_ctor_QGraphicsItem_Adaptor_3825 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args ? args.read<QGraphicsItem * > () : (QGraphicsItem *)(0);
  QGraphicsScene *arg2 = args ? args.read<QGraphicsScene * > () : (QGraphicsScene *)(0);
  ret.write<QGraphicsItem_Adaptor *> (new QGraphicsItem_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsItem_Adaptor_3825 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsItem::QGraphicsItem(QGraphicsItem *parent, QGraphicsScene *scene)\nThis method creates an object of class QGraphicsItem.", &_init_ctor_QGraphicsItem_Adaptor_3825, &_call_ctor_QGraphicsItem_Adaptor_3825);
}

// void QGraphicsItem::addToIndex()

static void _init_fp_addToIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_addToIndex_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem_Adaptor *)cls)->fp_QGraphicsItem_addToIndex_0 ();
}

static qt_gsi::GenericMethod*_create_fp_addToIndex_0 ()
{
  return new qt_gsi::GenericMethod("*addToIndex", "@brief Method void QGraphicsItem::addToIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addToIndex_0, &_call_fp_addToIndex_0);
}


// void QGraphicsItem::prepareGeometryChange()

static void _init_fp_prepareGeometryChange_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_prepareGeometryChange_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem_Adaptor *)cls)->fp_QGraphicsItem_prepareGeometryChange_0 ();
}

static qt_gsi::GenericMethod*_create_fp_prepareGeometryChange_0 ()
{
  return new qt_gsi::GenericMethod("*prepareGeometryChange", "@brief Method void QGraphicsItem::prepareGeometryChange()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_prepareGeometryChange_0, &_call_fp_prepareGeometryChange_0);
}


// void QGraphicsItem::removeFromIndex()

static void _init_fp_removeFromIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_removeFromIndex_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItem_Adaptor *)cls)->fp_QGraphicsItem_removeFromIndex_0 ();
}

static qt_gsi::GenericMethod*_create_fp_removeFromIndex_0 ()
{
  return new qt_gsi::GenericMethod("*removeFromIndex", "@brief Method void QGraphicsItem::removeFromIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removeFromIndex_0, &_call_fp_removeFromIndex_0);
}


// void QGraphicsItem::advance(int phase)

static void _init_cbs_advance_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("phase");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_advance_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_advance_767_0 (arg1);
}

static void _set_callback_cbs_advance_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_advance_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_advance_767_0 ()
{
  return new qt_gsi::GenericMethod ("advance", "@hide", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_advance_767_0 ()
{
  return new qt_gsi::GenericMethod ("advance", "@brief Virtual method void QGraphicsItem::advance(int phase)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0, &_set_callback_cbs_advance_767_0);
}


// QRectF QGraphicsItem::boundingRect()

static void _init_cbs_boundingRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRect_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsItem_Adaptor *)cls)->cbs_boundingRect_c0_0 ());
}

static void _set_callback_cbs_boundingRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_boundingRect_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_boundingRect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@hide", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_boundingRect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Virtual method QRectF QGraphicsItem::boundingRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0, &_set_callback_cbs_boundingRect_c0_0);
}


// bool QGraphicsItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithItem_c4977_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithItem_c4977_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_collidesWithItem_c4977_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithItem_c4977_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_collidesWithItem_c4977_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_collidesWithItem_c4977_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithItem", "@hide", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_collidesWithItem_c4977_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithItem", "@brief Virtual method bool QGraphicsItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1, &_set_callback_cbs_collidesWithItem_c4977_1);
}


// bool QGraphicsItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithPath_c4877_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithPath_c4877_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_collidesWithPath_c4877_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithPath_c4877_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_collidesWithPath_c4877_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_collidesWithPath_c4877_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithPath", "@hide", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_collidesWithPath_c4877_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithPath", "@brief Virtual method bool QGraphicsItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1, &_set_callback_cbs_collidesWithPath_c4877_1);
}


// bool QGraphicsItem::contains(const QPointF &point)

static void _init_cbs_contains_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_contains_c1986_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_contains_c1986_0 (arg1));
}

static void _set_callback_cbs_contains_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_contains_c1986_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contains_c1986_0 ()
{
  return new qt_gsi::GenericMethod ("contains", "@hide", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contains_c1986_0 ()
{
  return new qt_gsi::GenericMethod ("contains", "@brief Virtual method bool QGraphicsItem::contains(const QPointF &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0, &_set_callback_cbs_contains_c1986_0);
}


// bool QGraphicsItem::isObscuredBy(const QGraphicsItem *item)

static void _init_cbs_isObscuredBy_c2614_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isObscuredBy_c2614_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_isObscuredBy_c2614_0 (arg1));
}

static void _set_callback_cbs_isObscuredBy_c2614_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_isObscuredBy_c2614_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isObscuredBy_c2614_0 ()
{
  return new qt_gsi::GenericMethod ("isObscuredBy", "@hide", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isObscuredBy_c2614_0 ()
{
  return new qt_gsi::GenericMethod ("isObscuredBy", "@brief Virtual method bool QGraphicsItem::isObscuredBy(const QGraphicsItem *item)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0, &_set_callback_cbs_isObscuredBy_c2614_0);
}


// QPainterPath QGraphicsItem::opaqueArea()

static void _init_cbs_opaqueArea_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_opaqueArea_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem_Adaptor *)cls)->cbs_opaqueArea_c0_0 ());
}

static void _set_callback_cbs_opaqueArea_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_opaqueArea_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_opaqueArea_c0_0 ()
{
  return new qt_gsi::GenericMethod ("opaqueArea", "@hide", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_opaqueArea_c0_0 ()
{
  return new qt_gsi::GenericMethod ("opaqueArea", "@brief Virtual method QPainterPath QGraphicsItem::opaqueArea()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0, &_set_callback_cbs_opaqueArea_c0_0);
}


// void QGraphicsItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paint_6301_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_6301_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > ();
  QWidget *arg3 = args.read<QWidget * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_paint_6301_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_6301_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_paint_6301_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paint_6301_1 ()
{
  return new qt_gsi::GenericMethod ("paint", "@hide", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paint_6301_1 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QGraphicsItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1, &_set_callback_cbs_paint_6301_1);
}


// QPainterPath QGraphicsItem::shape()

static void _init_cbs_shape_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_shape_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem_Adaptor *)cls)->cbs_shape_c0_0 ());
}

static void _set_callback_cbs_shape_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_shape_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_shape_c0_0 ()
{
  return new qt_gsi::GenericMethod ("shape", "@hide", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_shape_c0_0 ()
{
  return new qt_gsi::GenericMethod ("shape", "@brief Virtual method QPainterPath QGraphicsItem::shape()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0, &_set_callback_cbs_shape_c0_0);
}


// int QGraphicsItem::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QGraphicsItem_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_type_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_type_c0_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_type_c0_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Virtual method int QGraphicsItem::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
}


// void QGraphicsItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_3674_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_3674_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneContextMenuEvent *arg1 = args.read<QGraphicsSceneContextMenuEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_contextMenuEvent_3674_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_3674_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_contextMenuEvent_3674_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_3674_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_3674_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0, &_set_callback_cbs_contextMenuEvent_3674_0);
}


// void QGraphicsItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragEnterEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_dragEnterEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_dragEnterEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0, &_set_callback_cbs_dragEnterEvent_3315_0);
}


// void QGraphicsItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragLeaveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_dragLeaveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_dragLeaveEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0, &_set_callback_cbs_dragLeaveEvent_3315_0);
}


// void QGraphicsItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragMoveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_dragMoveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_dragMoveEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0, &_set_callback_cbs_dragMoveEvent_3315_0);
}


// void QGraphicsItem::dropEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dropEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_dropEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dropEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_dropEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsItem::dropEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0, &_set_callback_cbs_dropEvent_3315_0);
}


// QVariant QGraphicsItem::extension(const QVariant &variant)

static void _init_cbs_extension_c2119_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("variant");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_extension_c2119_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsItem_Adaptor *)cls)->cbs_extension_c2119_0 (arg1));
}

static void _set_callback_cbs_extension_c2119_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_extension_c2119_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_extension_c2119_0 ()
{
  return new qt_gsi::GenericMethod ("*extension", "@hide", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_extension_c2119_0 ()
{
  return new qt_gsi::GenericMethod ("*extension", "@brief Virtual method QVariant QGraphicsItem::extension(const QVariant &variant)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0, &_set_callback_cbs_extension_c2119_0);
}


// void QGraphicsItem::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsItem::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// void QGraphicsItem::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsItem::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QGraphicsItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverEnterEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverEnterEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_hoverEnterEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverEnterEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_hoverEnterEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverEnterEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverEnterEvent", "@hide", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverEnterEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverEnterEvent", "@brief Virtual method void QGraphicsItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0, &_set_callback_cbs_hoverEnterEvent_3044_0);
}


// void QGraphicsItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverLeaveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverLeaveEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_hoverLeaveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverLeaveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_hoverLeaveEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverLeaveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@hide", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverLeaveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@brief Virtual method void QGraphicsItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0, &_set_callback_cbs_hoverLeaveEvent_3044_0);
}


// void QGraphicsItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverMoveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverMoveEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_hoverMoveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverMoveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_hoverMoveEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverMoveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverMoveEvent", "@hide", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverMoveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverMoveEvent", "@brief Virtual method void QGraphicsItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0, &_set_callback_cbs_hoverMoveEvent_3044_0);
}


// void QGraphicsItem::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsItem::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// QVariant QGraphicsItem::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsItem_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodQuery", "@brief Virtual method QVariant QGraphicsItem::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QVariant QGraphicsItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)

static void _init_cbs_itemChange_5658_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("change");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_itemChange_5658_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsItem_Adaptor *)cls)->cbs_itemChange_5658_0 (arg1, arg2));
}

static void _set_callback_cbs_itemChange_5658_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_itemChange_5658_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemChange_5658_0 ()
{
  return new qt_gsi::GenericMethod ("*itemChange", "@hide", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemChange_5658_0 ()
{
  return new qt_gsi::GenericMethod ("*itemChange", "@brief Virtual method QVariant QGraphicsItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0, &_set_callback_cbs_itemChange_5658_0);
}


// void QGraphicsItem::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsItem::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QGraphicsItem::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsItem::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QGraphicsItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_mouseDoubleClickEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_mouseDoubleClickEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0, &_set_callback_cbs_mouseDoubleClickEvent_3049_0);
}


// void QGraphicsItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseMoveEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_mouseMoveEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_mouseMoveEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0, &_set_callback_cbs_mouseMoveEvent_3049_0);
}


// void QGraphicsItem::mousePressEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mousePressEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_mousePressEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_mousePressEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsItem::mousePressEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0, &_set_callback_cbs_mousePressEvent_3049_0);
}


// void QGraphicsItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_mouseReleaseEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_mouseReleaseEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0, &_set_callback_cbs_mouseReleaseEvent_3049_0);
}


// bool QGraphicsItem::sceneEvent(QEvent *event)

static void _init_cbs_sceneEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_sceneEvent_1217_0 (arg1));
}

static void _set_callback_cbs_sceneEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_sceneEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sceneEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEvent", "@hide", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sceneEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEvent", "@brief Virtual method bool QGraphicsItem::sceneEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0, &_set_callback_cbs_sceneEvent_1217_0);
}


// bool QGraphicsItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)

static void _init_cbs_sceneEventFilter_3028_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEventFilter_3028_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_sceneEventFilter_3028_0 (arg1, arg2));
}

static void _set_callback_cbs_sceneEventFilter_3028_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_sceneEventFilter_3028_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sceneEventFilter_3028_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEventFilter", "@hide", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sceneEventFilter_3028_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEventFilter", "@brief Virtual method bool QGraphicsItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0, &_set_callback_cbs_sceneEventFilter_3028_0);
}


// void QGraphicsItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)

static void _init_cbs_setExtension_4817_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("variant");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setExtension_4817_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_setExtension_4817_0 (arg1, arg2);
}

static void _set_callback_cbs_setExtension_4817_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_setExtension_4817_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setExtension_4817_0 ()
{
  return new qt_gsi::GenericMethod ("*setExtension", "@hide", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setExtension_4817_0 ()
{
  return new qt_gsi::GenericMethod ("*setExtension", "@brief Virtual method void QGraphicsItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0, &_set_callback_cbs_setExtension_4817_0);
}


// bool QGraphicsItem::supportsExtension(QGraphicsItem::Extension extension)

static void _init_cbs_supportsExtension_c2806_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_supportsExtension_c2806_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_supportsExtension_c2806_0 (arg1));
}

static void _set_callback_cbs_supportsExtension_c2806_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_supportsExtension_c2806_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportsExtension_c2806_0 ()
{
  return new qt_gsi::GenericMethod ("*supportsExtension", "@hide", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportsExtension_c2806_0 ()
{
  return new qt_gsi::GenericMethod ("*supportsExtension", "@brief Virtual method bool QGraphicsItem::supportsExtension(QGraphicsItem::Extension extension)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0, &_set_callback_cbs_supportsExtension_c2806_0);
}


// void QGraphicsItem::wheelEvent(QGraphicsSceneWheelEvent *event)

static void _init_cbs_wheelEvent_3029_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_3029_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneWheelEvent *arg1 = args.read<QGraphicsSceneWheelEvent * > ();
  ((QGraphicsItem_Adaptor *)cls)->cbs_wheelEvent_3029_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_3029_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_wheelEvent_3029_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_3029_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_3029_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsItem::wheelEvent(QGraphicsSceneWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0, &_set_callback_cbs_wheelEvent_3029_0);
}


namespace gsi
{

extern gsi::Class<QGraphicsItem> decl_QGraphicsItem;

gsi::Class<QGraphicsItem_Adaptor> decl_QGraphicsItem_Adaptor (decl_QGraphicsItem, "QGraphicsItem",
  gsi::Methods(_create_fp_addToIndex_0 ()) +
  gsi::Methods(_create_fp_prepareGeometryChange_0 ()) +
  gsi::Methods(_create_fp_removeFromIndex_0 ()) +
  gsi::Methods(_create_cbs_advance_767_0 ()) +
  gsi::Methods(_create_callback_cbs_advance_767_0 ()) +
  gsi::Methods(_create_cbs_boundingRect_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_boundingRect_c0_0 ()) +
  gsi::Methods(_create_cbs_collidesWithItem_c4977_1 ()) +
  gsi::Methods(_create_callback_cbs_collidesWithItem_c4977_1 ()) +
  gsi::Methods(_create_cbs_collidesWithPath_c4877_1 ()) +
  gsi::Methods(_create_callback_cbs_collidesWithPath_c4877_1 ()) +
  gsi::Methods(_create_cbs_contains_c1986_0 ()) +
  gsi::Methods(_create_callback_cbs_contains_c1986_0 ()) +
  gsi::Methods(_create_cbs_isObscuredBy_c2614_0 ()) +
  gsi::Methods(_create_callback_cbs_isObscuredBy_c2614_0 ()) +
  gsi::Methods(_create_cbs_opaqueArea_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_opaqueArea_c0_0 ()) +
  gsi::Methods(_create_cbs_paint_6301_1 ()) +
  gsi::Methods(_create_callback_cbs_paint_6301_1 ()) +
  gsi::Methods(_create_cbs_shape_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_shape_c0_0 ()) +
  gsi::Methods(_create_cbs_type_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_type_c0_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_3674_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_3674_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_extension_c2119_0 ()) +
  gsi::Methods(_create_callback_cbs_extension_c2119_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_hoverEnterEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverEnterEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_hoverLeaveEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverLeaveEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_hoverMoveEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverMoveEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_itemChange_5658_0 ()) +
  gsi::Methods(_create_callback_cbs_itemChange_5658_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_sceneEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_sceneEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_sceneEventFilter_3028_0 ()) +
  gsi::Methods(_create_callback_cbs_sceneEventFilter_3028_0 ()) +
  gsi::Methods(_create_cbs_setExtension_4817_0 ()) +
  gsi::Methods(_create_callback_cbs_setExtension_4817_0 ()) +
  gsi::Methods(_create_cbs_supportsExtension_c2806_0 ()) +
  gsi::Methods(_create_callback_cbs_supportsExtension_c2806_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_3029_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_3029_0 ()) +
  gsi::Methods(_create_ctor_QGraphicsItem_Adaptor_3825 ()),
  "@qt\n@brief Binding of QGraphicsItem");

}


//  Implementation of the enum wrapper class for QGraphicsItem::CacheMode
namespace qt_gsi
{

static QGraphicsItem_CacheMode_Enum *c_1_QGraphicsItem_CacheMode_Enum () { return new QGraphicsItem_CacheMode_Enum (QGraphicsItem::NoCache); }
static QGraphicsItem_CacheMode_Enum *c_2_QGraphicsItem_CacheMode_Enum () { return new QGraphicsItem_CacheMode_Enum (QGraphicsItem::ItemCoordinateCache); }
static QGraphicsItem_CacheMode_Enum *c_3_QGraphicsItem_CacheMode_Enum () { return new QGraphicsItem_CacheMode_Enum (QGraphicsItem::DeviceCoordinateCache); }

static gsi::Methods mkdefs_QGraphicsItem_CacheMode () {
  return
    gsi::constant ("NoCache", &qt_gsi::c_1_QGraphicsItem_CacheMode_Enum, "@brief Enum constant QGraphicsItem::NoCache") +
    gsi::constant ("ItemCoordinateCache", &qt_gsi::c_2_QGraphicsItem_CacheMode_Enum, "@brief Enum constant QGraphicsItem::ItemCoordinateCache") +
    gsi::constant ("DeviceCoordinateCache", &qt_gsi::c_3_QGraphicsItem_CacheMode_Enum, "@brief Enum constant QGraphicsItem::DeviceCoordinateCache");
}

static std::string to_s_QGraphicsItem_CacheMode_Enum (const QGraphicsItem_CacheMode_Enum *e)
{
  if (e->value () == QGraphicsItem::NoCache) { return tl::sprintf ("NoCache (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemCoordinateCache) { return tl::sprintf ("ItemCoordinateCache (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::DeviceCoordinateCache) { return tl::sprintf ("DeviceCoordinateCache (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsItem_CacheMode_Enum (const QGraphicsItem_CacheMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsItem_CacheMode_Enum *from_i_QGraphicsItem_CacheMode_Enum (unsigned int i)
{
  return new QGraphicsItem_CacheMode_Enum ((QGraphicsItem::CacheMode) i);
}

static bool equalQGraphicsItem_CacheMode_Enum (const QGraphicsItem_CacheMode_Enum *e, QGraphicsItem_CacheMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsItem_CacheMode_Enum (const QGraphicsItem_CacheMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsItem_CacheMode_Enums oropQGraphicsItem_CacheMode_Enums (const QGraphicsItem_CacheMode_Enums *e, const QGraphicsItem_CacheMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsItem_CacheMode_Enums andopQGraphicsItem_CacheMode_Enums (const QGraphicsItem_CacheMode_Enums *e, const QGraphicsItem_CacheMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsItem_CacheMode_Enums xoropQGraphicsItem_CacheMode_Enums (const QGraphicsItem_CacheMode_Enums *e, const QGraphicsItem_CacheMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsItem_CacheMode_Enums (const QGraphicsItem_CacheMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsItem::NoCache)) { if (!l.empty ()) l += "|"; l += "NoCache"; }
  if (e->testFlag (QGraphicsItem::ItemCoordinateCache)) { if (!l.empty ()) l += "|"; l += "ItemCoordinateCache"; }
  if (e->testFlag (QGraphicsItem::DeviceCoordinateCache)) { if (!l.empty ()) l += "|"; l += "DeviceCoordinateCache"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsItem_CacheMode_Enums (const QGraphicsItem_CacheMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsItem_CacheMode_Enums (const QGraphicsItem_CacheMode_Enums *e, const QGraphicsItem_CacheMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsItem_CacheMode_Enums> decl_QGraphicsItem_CacheMode_Enums ("QGraphicsItem_QFlags_CacheMode",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsItem_CacheMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsItem_CacheMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsItem_CacheMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsItem_CacheMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsItem_CacheMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsItem_CacheMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsItem::CacheMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsItem_CacheMode_Enum> decl_QGraphicsItem_CacheMode_Enum (decl_QGraphicsItem_CacheMode_Enums, "QGraphicsItem_CacheMode",
  qt_gsi::mkdefs_QGraphicsItem_CacheMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsItem_CacheMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsItem_CacheMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsItem_CacheMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsItem_CacheMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsItem_CacheMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsItem::CacheMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsItem> inject_QGraphicsItem_CacheMode_Enum_in_parent (qt_gsi::mkdefs_QGraphicsItem_CacheMode ());
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_CacheMode_Enum_as_child (decl_QGraphicsItem_CacheMode_Enum, "CacheMode");

}


//  Implementation of the enum wrapper class for QGraphicsItem::GraphicsItemChange
namespace qt_gsi
{

static QGraphicsItem_GraphicsItemChange_Enum *c_1_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemPositionChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_2_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemMatrixChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_3_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemVisibleChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_4_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemEnabledChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_5_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemSelectedChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_6_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemParentChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_7_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemChildAddedChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_8_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemChildRemovedChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_9_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemTransformChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_10_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemPositionHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_11_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemTransformHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_12_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemSceneChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_13_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemVisibleHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_14_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemEnabledHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_15_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemSelectedHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_16_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemParentHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_17_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemSceneHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_18_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemCursorChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_19_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemCursorHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_20_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemToolTipChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_21_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemToolTipHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_22_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemFlagsChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_23_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemFlagsHaveChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_24_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemZValueChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_25_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemZValueHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_26_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemOpacityChange); }
static QGraphicsItem_GraphicsItemChange_Enum *c_27_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemOpacityHasChanged); }
static QGraphicsItem_GraphicsItemChange_Enum *c_28_QGraphicsItem_GraphicsItemChange_Enum () { return new QGraphicsItem_GraphicsItemChange_Enum (QGraphicsItem::ItemScenePositionHasChanged); }

static gsi::Methods mkdefs_QGraphicsItem_GraphicsItemChange () {
  return
    gsi::constant ("ItemPositionChange", &qt_gsi::c_1_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemPositionChange") +
    gsi::constant ("ItemMatrixChange", &qt_gsi::c_2_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemMatrixChange") +
    gsi::constant ("ItemVisibleChange", &qt_gsi::c_3_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemVisibleChange") +
    gsi::constant ("ItemEnabledChange", &qt_gsi::c_4_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemEnabledChange") +
    gsi::constant ("ItemSelectedChange", &qt_gsi::c_5_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemSelectedChange") +
    gsi::constant ("ItemParentChange", &qt_gsi::c_6_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemParentChange") +
    gsi::constant ("ItemChildAddedChange", &qt_gsi::c_7_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemChildAddedChange") +
    gsi::constant ("ItemChildRemovedChange", &qt_gsi::c_8_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemChildRemovedChange") +
    gsi::constant ("ItemTransformChange", &qt_gsi::c_9_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemTransformChange") +
    gsi::constant ("ItemPositionHasChanged", &qt_gsi::c_10_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemPositionHasChanged") +
    gsi::constant ("ItemTransformHasChanged", &qt_gsi::c_11_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemTransformHasChanged") +
    gsi::constant ("ItemSceneChange", &qt_gsi::c_12_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemSceneChange") +
    gsi::constant ("ItemVisibleHasChanged", &qt_gsi::c_13_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemVisibleHasChanged") +
    gsi::constant ("ItemEnabledHasChanged", &qt_gsi::c_14_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemEnabledHasChanged") +
    gsi::constant ("ItemSelectedHasChanged", &qt_gsi::c_15_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemSelectedHasChanged") +
    gsi::constant ("ItemParentHasChanged", &qt_gsi::c_16_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemParentHasChanged") +
    gsi::constant ("ItemSceneHasChanged", &qt_gsi::c_17_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemSceneHasChanged") +
    gsi::constant ("ItemCursorChange", &qt_gsi::c_18_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemCursorChange") +
    gsi::constant ("ItemCursorHasChanged", &qt_gsi::c_19_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemCursorHasChanged") +
    gsi::constant ("ItemToolTipChange", &qt_gsi::c_20_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemToolTipChange") +
    gsi::constant ("ItemToolTipHasChanged", &qt_gsi::c_21_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemToolTipHasChanged") +
    gsi::constant ("ItemFlagsChange", &qt_gsi::c_22_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemFlagsChange") +
    gsi::constant ("ItemFlagsHaveChanged", &qt_gsi::c_23_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemFlagsHaveChanged") +
    gsi::constant ("ItemZValueChange", &qt_gsi::c_24_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemZValueChange") +
    gsi::constant ("ItemZValueHasChanged", &qt_gsi::c_25_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemZValueHasChanged") +
    gsi::constant ("ItemOpacityChange", &qt_gsi::c_26_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemOpacityChange") +
    gsi::constant ("ItemOpacityHasChanged", &qt_gsi::c_27_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemOpacityHasChanged") +
    gsi::constant ("ItemScenePositionHasChanged", &qt_gsi::c_28_QGraphicsItem_GraphicsItemChange_Enum, "@brief Enum constant QGraphicsItem::ItemScenePositionHasChanged");
}

static std::string to_s_QGraphicsItem_GraphicsItemChange_Enum (const QGraphicsItem_GraphicsItemChange_Enum *e)
{
  if (e->value () == QGraphicsItem::ItemPositionChange) { return tl::sprintf ("ItemPositionChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemMatrixChange) { return tl::sprintf ("ItemMatrixChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemVisibleChange) { return tl::sprintf ("ItemVisibleChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemEnabledChange) { return tl::sprintf ("ItemEnabledChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemSelectedChange) { return tl::sprintf ("ItemSelectedChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemParentChange) { return tl::sprintf ("ItemParentChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemChildAddedChange) { return tl::sprintf ("ItemChildAddedChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemChildRemovedChange) { return tl::sprintf ("ItemChildRemovedChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemTransformChange) { return tl::sprintf ("ItemTransformChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemPositionHasChanged) { return tl::sprintf ("ItemPositionHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemTransformHasChanged) { return tl::sprintf ("ItemTransformHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemSceneChange) { return tl::sprintf ("ItemSceneChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemVisibleHasChanged) { return tl::sprintf ("ItemVisibleHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemEnabledHasChanged) { return tl::sprintf ("ItemEnabledHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemSelectedHasChanged) { return tl::sprintf ("ItemSelectedHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemParentHasChanged) { return tl::sprintf ("ItemParentHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemSceneHasChanged) { return tl::sprintf ("ItemSceneHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemCursorChange) { return tl::sprintf ("ItemCursorChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemCursorHasChanged) { return tl::sprintf ("ItemCursorHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemToolTipChange) { return tl::sprintf ("ItemToolTipChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemToolTipHasChanged) { return tl::sprintf ("ItemToolTipHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemFlagsChange) { return tl::sprintf ("ItemFlagsChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemFlagsHaveChanged) { return tl::sprintf ("ItemFlagsHaveChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemZValueChange) { return tl::sprintf ("ItemZValueChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemZValueHasChanged) { return tl::sprintf ("ItemZValueHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemOpacityChange) { return tl::sprintf ("ItemOpacityChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemOpacityHasChanged) { return tl::sprintf ("ItemOpacityHasChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemScenePositionHasChanged) { return tl::sprintf ("ItemScenePositionHasChanged (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsItem_GraphicsItemChange_Enum (const QGraphicsItem_GraphicsItemChange_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsItem_GraphicsItemChange_Enum *from_i_QGraphicsItem_GraphicsItemChange_Enum (unsigned int i)
{
  return new QGraphicsItem_GraphicsItemChange_Enum ((QGraphicsItem::GraphicsItemChange) i);
}

static bool equalQGraphicsItem_GraphicsItemChange_Enum (const QGraphicsItem_GraphicsItemChange_Enum *e, QGraphicsItem_GraphicsItemChange_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsItem_GraphicsItemChange_Enum (const QGraphicsItem_GraphicsItemChange_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsItem_GraphicsItemChange_Enums oropQGraphicsItem_GraphicsItemChange_Enums (const QGraphicsItem_GraphicsItemChange_Enums *e, const QGraphicsItem_GraphicsItemChange_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsItem_GraphicsItemChange_Enums andopQGraphicsItem_GraphicsItemChange_Enums (const QGraphicsItem_GraphicsItemChange_Enums *e, const QGraphicsItem_GraphicsItemChange_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsItem_GraphicsItemChange_Enums xoropQGraphicsItem_GraphicsItemChange_Enums (const QGraphicsItem_GraphicsItemChange_Enums *e, const QGraphicsItem_GraphicsItemChange_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsItem_GraphicsItemChange_Enums (const QGraphicsItem_GraphicsItemChange_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsItem::ItemPositionChange)) { if (!l.empty ()) l += "|"; l += "ItemPositionChange"; }
  if (e->testFlag (QGraphicsItem::ItemMatrixChange)) { if (!l.empty ()) l += "|"; l += "ItemMatrixChange"; }
  if (e->testFlag (QGraphicsItem::ItemVisibleChange)) { if (!l.empty ()) l += "|"; l += "ItemVisibleChange"; }
  if (e->testFlag (QGraphicsItem::ItemEnabledChange)) { if (!l.empty ()) l += "|"; l += "ItemEnabledChange"; }
  if (e->testFlag (QGraphicsItem::ItemSelectedChange)) { if (!l.empty ()) l += "|"; l += "ItemSelectedChange"; }
  if (e->testFlag (QGraphicsItem::ItemParentChange)) { if (!l.empty ()) l += "|"; l += "ItemParentChange"; }
  if (e->testFlag (QGraphicsItem::ItemChildAddedChange)) { if (!l.empty ()) l += "|"; l += "ItemChildAddedChange"; }
  if (e->testFlag (QGraphicsItem::ItemChildRemovedChange)) { if (!l.empty ()) l += "|"; l += "ItemChildRemovedChange"; }
  if (e->testFlag (QGraphicsItem::ItemTransformChange)) { if (!l.empty ()) l += "|"; l += "ItemTransformChange"; }
  if (e->testFlag (QGraphicsItem::ItemPositionHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemPositionHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemTransformHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemTransformHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemSceneChange)) { if (!l.empty ()) l += "|"; l += "ItemSceneChange"; }
  if (e->testFlag (QGraphicsItem::ItemVisibleHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemVisibleHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemEnabledHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemEnabledHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemSelectedHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemSelectedHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemParentHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemParentHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemSceneHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemSceneHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemCursorChange)) { if (!l.empty ()) l += "|"; l += "ItemCursorChange"; }
  if (e->testFlag (QGraphicsItem::ItemCursorHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemCursorHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemToolTipChange)) { if (!l.empty ()) l += "|"; l += "ItemToolTipChange"; }
  if (e->testFlag (QGraphicsItem::ItemToolTipHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemToolTipHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemFlagsChange)) { if (!l.empty ()) l += "|"; l += "ItemFlagsChange"; }
  if (e->testFlag (QGraphicsItem::ItemFlagsHaveChanged)) { if (!l.empty ()) l += "|"; l += "ItemFlagsHaveChanged"; }
  if (e->testFlag (QGraphicsItem::ItemZValueChange)) { if (!l.empty ()) l += "|"; l += "ItemZValueChange"; }
  if (e->testFlag (QGraphicsItem::ItemZValueHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemZValueHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemOpacityChange)) { if (!l.empty ()) l += "|"; l += "ItemOpacityChange"; }
  if (e->testFlag (QGraphicsItem::ItemOpacityHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemOpacityHasChanged"; }
  if (e->testFlag (QGraphicsItem::ItemScenePositionHasChanged)) { if (!l.empty ()) l += "|"; l += "ItemScenePositionHasChanged"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsItem_GraphicsItemChange_Enums (const QGraphicsItem_GraphicsItemChange_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsItem_GraphicsItemChange_Enums (const QGraphicsItem_GraphicsItemChange_Enums *e, const QGraphicsItem_GraphicsItemChange_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsItem_GraphicsItemChange_Enums> decl_QGraphicsItem_GraphicsItemChange_Enums ("QGraphicsItem_QFlags_GraphicsItemChange",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsItem_GraphicsItemChange_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsItem_GraphicsItemChange_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsItem_GraphicsItemChange_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsItem_GraphicsItemChange_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsItem_GraphicsItemChange_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsItem_GraphicsItemChange_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsItem::GraphicsItemChange> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsItem_GraphicsItemChange_Enum> decl_QGraphicsItem_GraphicsItemChange_Enum (decl_QGraphicsItem_GraphicsItemChange_Enums, "QGraphicsItem_GraphicsItemChange",
  qt_gsi::mkdefs_QGraphicsItem_GraphicsItemChange () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsItem_GraphicsItemChange_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsItem_GraphicsItemChange_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsItem_GraphicsItemChange_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsItem_GraphicsItemChange_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsItem_GraphicsItemChange_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsItem::GraphicsItemChange enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsItem> inject_QGraphicsItem_GraphicsItemChange_Enum_in_parent (qt_gsi::mkdefs_QGraphicsItem_GraphicsItemChange ());
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_GraphicsItemChange_Enum_as_child (decl_QGraphicsItem_GraphicsItemChange_Enum, "GraphicsItemChange");

}


//  Implementation of the enum wrapper class for QGraphicsItem::GraphicsItemFlag
namespace qt_gsi
{

static QGraphicsItem_GraphicsItemFlag_Enum *c_1_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemIsMovable); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_2_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemIsSelectable); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_3_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemIsFocusable); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_4_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemClipsToShape); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_5_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemClipsChildrenToShape); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_6_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemIgnoresTransformations); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_7_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemIgnoresParentOpacity); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_8_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemDoesntPropagateOpacityToChildren); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_9_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemStacksBehindParent); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_10_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemUsesExtendedStyleOption); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_11_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemHasNoContents); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_12_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemSendsGeometryChanges); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_13_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemAcceptsInputMethod); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_14_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemNegativeZStacksBehindParent); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_15_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemIsPanel); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_16_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemIsFocusScope); }
static QGraphicsItem_GraphicsItemFlag_Enum *c_17_QGraphicsItem_GraphicsItemFlag_Enum () { return new QGraphicsItem_GraphicsItemFlag_Enum (QGraphicsItem::ItemSendsScenePositionChanges); }

static gsi::Methods mkdefs_QGraphicsItem_GraphicsItemFlag () {
  return
    gsi::constant ("ItemIsMovable", &qt_gsi::c_1_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemIsMovable") +
    gsi::constant ("ItemIsSelectable", &qt_gsi::c_2_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemIsSelectable") +
    gsi::constant ("ItemIsFocusable", &qt_gsi::c_3_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemIsFocusable") +
    gsi::constant ("ItemClipsToShape", &qt_gsi::c_4_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemClipsToShape") +
    gsi::constant ("ItemClipsChildrenToShape", &qt_gsi::c_5_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemClipsChildrenToShape") +
    gsi::constant ("ItemIgnoresTransformations", &qt_gsi::c_6_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemIgnoresTransformations") +
    gsi::constant ("ItemIgnoresParentOpacity", &qt_gsi::c_7_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemIgnoresParentOpacity") +
    gsi::constant ("ItemDoesntPropagateOpacityToChildren", &qt_gsi::c_8_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemDoesntPropagateOpacityToChildren") +
    gsi::constant ("ItemStacksBehindParent", &qt_gsi::c_9_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemStacksBehindParent") +
    gsi::constant ("ItemUsesExtendedStyleOption", &qt_gsi::c_10_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemUsesExtendedStyleOption") +
    gsi::constant ("ItemHasNoContents", &qt_gsi::c_11_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemHasNoContents") +
    gsi::constant ("ItemSendsGeometryChanges", &qt_gsi::c_12_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemSendsGeometryChanges") +
    gsi::constant ("ItemAcceptsInputMethod", &qt_gsi::c_13_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemAcceptsInputMethod") +
    gsi::constant ("ItemNegativeZStacksBehindParent", &qt_gsi::c_14_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemNegativeZStacksBehindParent") +
    gsi::constant ("ItemIsPanel", &qt_gsi::c_15_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemIsPanel") +
    gsi::constant ("ItemIsFocusScope", &qt_gsi::c_16_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemIsFocusScope") +
    gsi::constant ("ItemSendsScenePositionChanges", &qt_gsi::c_17_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Enum constant QGraphicsItem::ItemSendsScenePositionChanges");
}

static std::string to_s_QGraphicsItem_GraphicsItemFlag_Enum (const QGraphicsItem_GraphicsItemFlag_Enum *e)
{
  if (e->value () == QGraphicsItem::ItemIsMovable) { return tl::sprintf ("ItemIsMovable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemIsSelectable) { return tl::sprintf ("ItemIsSelectable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemIsFocusable) { return tl::sprintf ("ItemIsFocusable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemClipsToShape) { return tl::sprintf ("ItemClipsToShape (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemClipsChildrenToShape) { return tl::sprintf ("ItemClipsChildrenToShape (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemIgnoresTransformations) { return tl::sprintf ("ItemIgnoresTransformations (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemIgnoresParentOpacity) { return tl::sprintf ("ItemIgnoresParentOpacity (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemDoesntPropagateOpacityToChildren) { return tl::sprintf ("ItemDoesntPropagateOpacityToChildren (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemStacksBehindParent) { return tl::sprintf ("ItemStacksBehindParent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemUsesExtendedStyleOption) { return tl::sprintf ("ItemUsesExtendedStyleOption (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemHasNoContents) { return tl::sprintf ("ItemHasNoContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemSendsGeometryChanges) { return tl::sprintf ("ItemSendsGeometryChanges (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemAcceptsInputMethod) { return tl::sprintf ("ItemAcceptsInputMethod (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemNegativeZStacksBehindParent) { return tl::sprintf ("ItemNegativeZStacksBehindParent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemIsPanel) { return tl::sprintf ("ItemIsPanel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemIsFocusScope) { return tl::sprintf ("ItemIsFocusScope (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::ItemSendsScenePositionChanges) { return tl::sprintf ("ItemSendsScenePositionChanges (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsItem_GraphicsItemFlag_Enum (const QGraphicsItem_GraphicsItemFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsItem_GraphicsItemFlag_Enum *from_i_QGraphicsItem_GraphicsItemFlag_Enum (unsigned int i)
{
  return new QGraphicsItem_GraphicsItemFlag_Enum ((QGraphicsItem::GraphicsItemFlag) i);
}

static bool equalQGraphicsItem_GraphicsItemFlag_Enum (const QGraphicsItem_GraphicsItemFlag_Enum *e, QGraphicsItem_GraphicsItemFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsItem_GraphicsItemFlag_Enum (const QGraphicsItem_GraphicsItemFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsItem_GraphicsItemFlag_Enums oropQGraphicsItem_GraphicsItemFlag_Enums (const QGraphicsItem_GraphicsItemFlag_Enums *e, const QGraphicsItem_GraphicsItemFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsItem_GraphicsItemFlag_Enums andopQGraphicsItem_GraphicsItemFlag_Enums (const QGraphicsItem_GraphicsItemFlag_Enums *e, const QGraphicsItem_GraphicsItemFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsItem_GraphicsItemFlag_Enums xoropQGraphicsItem_GraphicsItemFlag_Enums (const QGraphicsItem_GraphicsItemFlag_Enums *e, const QGraphicsItem_GraphicsItemFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsItem_GraphicsItemFlag_Enums (const QGraphicsItem_GraphicsItemFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsItem::ItemIsMovable)) { if (!l.empty ()) l += "|"; l += "ItemIsMovable"; }
  if (e->testFlag (QGraphicsItem::ItemIsSelectable)) { if (!l.empty ()) l += "|"; l += "ItemIsSelectable"; }
  if (e->testFlag (QGraphicsItem::ItemIsFocusable)) { if (!l.empty ()) l += "|"; l += "ItemIsFocusable"; }
  if (e->testFlag (QGraphicsItem::ItemClipsToShape)) { if (!l.empty ()) l += "|"; l += "ItemClipsToShape"; }
  if (e->testFlag (QGraphicsItem::ItemClipsChildrenToShape)) { if (!l.empty ()) l += "|"; l += "ItemClipsChildrenToShape"; }
  if (e->testFlag (QGraphicsItem::ItemIgnoresTransformations)) { if (!l.empty ()) l += "|"; l += "ItemIgnoresTransformations"; }
  if (e->testFlag (QGraphicsItem::ItemIgnoresParentOpacity)) { if (!l.empty ()) l += "|"; l += "ItemIgnoresParentOpacity"; }
  if (e->testFlag (QGraphicsItem::ItemDoesntPropagateOpacityToChildren)) { if (!l.empty ()) l += "|"; l += "ItemDoesntPropagateOpacityToChildren"; }
  if (e->testFlag (QGraphicsItem::ItemStacksBehindParent)) { if (!l.empty ()) l += "|"; l += "ItemStacksBehindParent"; }
  if (e->testFlag (QGraphicsItem::ItemUsesExtendedStyleOption)) { if (!l.empty ()) l += "|"; l += "ItemUsesExtendedStyleOption"; }
  if (e->testFlag (QGraphicsItem::ItemHasNoContents)) { if (!l.empty ()) l += "|"; l += "ItemHasNoContents"; }
  if (e->testFlag (QGraphicsItem::ItemSendsGeometryChanges)) { if (!l.empty ()) l += "|"; l += "ItemSendsGeometryChanges"; }
  if (e->testFlag (QGraphicsItem::ItemAcceptsInputMethod)) { if (!l.empty ()) l += "|"; l += "ItemAcceptsInputMethod"; }
  if (e->testFlag (QGraphicsItem::ItemNegativeZStacksBehindParent)) { if (!l.empty ()) l += "|"; l += "ItemNegativeZStacksBehindParent"; }
  if (e->testFlag (QGraphicsItem::ItemIsPanel)) { if (!l.empty ()) l += "|"; l += "ItemIsPanel"; }
  if (e->testFlag (QGraphicsItem::ItemIsFocusScope)) { if (!l.empty ()) l += "|"; l += "ItemIsFocusScope"; }
  if (e->testFlag (QGraphicsItem::ItemSendsScenePositionChanges)) { if (!l.empty ()) l += "|"; l += "ItemSendsScenePositionChanges"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsItem_GraphicsItemFlag_Enums (const QGraphicsItem_GraphicsItemFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsItem_GraphicsItemFlag_Enums (const QGraphicsItem_GraphicsItemFlag_Enums *e, const QGraphicsItem_GraphicsItemFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsItem_GraphicsItemFlag_Enums> decl_QGraphicsItem_GraphicsItemFlag_Enums ("QGraphicsItem_QFlags_GraphicsItemFlag",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsItem_GraphicsItemFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsItem_GraphicsItemFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsItem_GraphicsItemFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsItem_GraphicsItemFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsItem_GraphicsItemFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsItem_GraphicsItemFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsItem::GraphicsItemFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsItem_GraphicsItemFlag_Enum> decl_QGraphicsItem_GraphicsItemFlag_Enum (decl_QGraphicsItem_GraphicsItemFlag_Enums, "QGraphicsItem_GraphicsItemFlag",
  qt_gsi::mkdefs_QGraphicsItem_GraphicsItemFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsItem_GraphicsItemFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsItem_GraphicsItemFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsItem_GraphicsItemFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsItem_GraphicsItemFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsItem::GraphicsItemFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsItem> inject_QGraphicsItem_GraphicsItemFlag_Enum_in_parent (qt_gsi::mkdefs_QGraphicsItem_GraphicsItemFlag ());
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_GraphicsItemFlag_Enum_as_child (decl_QGraphicsItem_GraphicsItemFlag_Enum, "GraphicsItemFlag");

}


//  Implementation of the enum wrapper class for QGraphicsItem::PanelModality
namespace qt_gsi
{

static QGraphicsItem_PanelModality_Enum *c_1_QGraphicsItem_PanelModality_Enum () { return new QGraphicsItem_PanelModality_Enum (QGraphicsItem::NonModal); }
static QGraphicsItem_PanelModality_Enum *c_2_QGraphicsItem_PanelModality_Enum () { return new QGraphicsItem_PanelModality_Enum (QGraphicsItem::PanelModal); }
static QGraphicsItem_PanelModality_Enum *c_3_QGraphicsItem_PanelModality_Enum () { return new QGraphicsItem_PanelModality_Enum (QGraphicsItem::SceneModal); }

static gsi::Methods mkdefs_QGraphicsItem_PanelModality () {
  return
    gsi::constant ("NonModal", &qt_gsi::c_1_QGraphicsItem_PanelModality_Enum, "@brief Enum constant QGraphicsItem::NonModal") +
    gsi::constant ("PanelModal", &qt_gsi::c_2_QGraphicsItem_PanelModality_Enum, "@brief Enum constant QGraphicsItem::PanelModal") +
    gsi::constant ("SceneModal", &qt_gsi::c_3_QGraphicsItem_PanelModality_Enum, "@brief Enum constant QGraphicsItem::SceneModal");
}

static std::string to_s_QGraphicsItem_PanelModality_Enum (const QGraphicsItem_PanelModality_Enum *e)
{
  if (e->value () == QGraphicsItem::NonModal) { return tl::sprintf ("NonModal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::PanelModal) { return tl::sprintf ("PanelModal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsItem::SceneModal) { return tl::sprintf ("SceneModal (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsItem_PanelModality_Enum (const QGraphicsItem_PanelModality_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsItem_PanelModality_Enum *from_i_QGraphicsItem_PanelModality_Enum (unsigned int i)
{
  return new QGraphicsItem_PanelModality_Enum ((QGraphicsItem::PanelModality) i);
}

static bool equalQGraphicsItem_PanelModality_Enum (const QGraphicsItem_PanelModality_Enum *e, QGraphicsItem_PanelModality_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsItem_PanelModality_Enum (const QGraphicsItem_PanelModality_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsItem_PanelModality_Enums oropQGraphicsItem_PanelModality_Enums (const QGraphicsItem_PanelModality_Enums *e, const QGraphicsItem_PanelModality_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsItem_PanelModality_Enums andopQGraphicsItem_PanelModality_Enums (const QGraphicsItem_PanelModality_Enums *e, const QGraphicsItem_PanelModality_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsItem_PanelModality_Enums xoropQGraphicsItem_PanelModality_Enums (const QGraphicsItem_PanelModality_Enums *e, const QGraphicsItem_PanelModality_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsItem_PanelModality_Enums (const QGraphicsItem_PanelModality_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsItem::NonModal)) { if (!l.empty ()) l += "|"; l += "NonModal"; }
  if (e->testFlag (QGraphicsItem::PanelModal)) { if (!l.empty ()) l += "|"; l += "PanelModal"; }
  if (e->testFlag (QGraphicsItem::SceneModal)) { if (!l.empty ()) l += "|"; l += "SceneModal"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsItem_PanelModality_Enums (const QGraphicsItem_PanelModality_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsItem_PanelModality_Enums (const QGraphicsItem_PanelModality_Enums *e, const QGraphicsItem_PanelModality_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsItem_PanelModality_Enums> decl_QGraphicsItem_PanelModality_Enums ("QGraphicsItem_QFlags_PanelModality",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsItem_PanelModality_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsItem_PanelModality_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsItem_PanelModality_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsItem_PanelModality_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsItem_PanelModality_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsItem_PanelModality_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsItem::PanelModality> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsItem_PanelModality_Enum> decl_QGraphicsItem_PanelModality_Enum (decl_QGraphicsItem_PanelModality_Enums, "QGraphicsItem_PanelModality",
  qt_gsi::mkdefs_QGraphicsItem_PanelModality () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsItem_PanelModality_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsItem_PanelModality_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsItem_PanelModality_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsItem_PanelModality_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsItem_PanelModality_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsItem::PanelModality enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsItem> inject_QGraphicsItem_PanelModality_Enum_in_parent (qt_gsi::mkdefs_QGraphicsItem_PanelModality ());
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_PanelModality_Enum_as_child (decl_QGraphicsItem_PanelModality_Enum, "PanelModality");

}

