
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFile.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQFile_EventAdaptor.h"
#include "gsiDeclQFile_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFile

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QFile::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

//  Constructor QFile::QFile()


static void _init_ctor_QFile_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QFile *> ();
}

static void _call_ctor_QFile_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFile *> (new QFile ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFile_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFile::QFile()\nThis method creates an object of class QFile.", &_init_ctor_QFile_0, &_call_ctor_QFile_0);
}

//  Constructor QFile::QFile(const QString &name)


static void _init_ctor_QFile_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QFile *> ();
}

static void _call_ctor_QFile_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QFile *> (new QFile (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFile_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFile::QFile(const QString &name)\nThis method creates an object of class QFile.", &_init_ctor_QFile_2025, &_call_ctor_QFile_2025);
}

//  Constructor QFile::QFile(QObject *parent)


static void _init_ctor_QFile_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QFile *> ();
}

static void _call_ctor_QFile_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ret.write<QFile *> (new QFile (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFile_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFile::QFile(QObject *parent)\nThis method creates an object of class QFile.", &_init_ctor_QFile_1302, &_call_ctor_QFile_1302);
}

//  Constructor QFile::QFile(const QString &name, QObject *parent)


static void _init_ctor_QFile_3219 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QFile *> ();
}

static void _call_ctor_QFile_3219 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QObject *arg2 = args.read<QObject * > ();
  ret.write<QFile *> (new QFile (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFile_3219 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFile::QFile(const QString &name, QObject *parent)\nThis method creates an object of class QFile.", &_init_ctor_QFile_3219, &_call_ctor_QFile_3219);
}

// bool QFile::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFile *)cls)->atEnd ());
}

static qt_gsi::GenericMethod *_create_f_atEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QFile::atEnd()\nThis is a reimplementation of QIODevice::atEnd", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
}

// void QFile::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFile *)cls)->close ();
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method void QFile::close()\nThis is a reimplementation of QIODevice::close", false, &_init_f_close_0, &_call_f_close_0);
}

// bool QFile::copy(const QString &newName)


static void _init_f_copy_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_copy_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QFile *)cls)->copy (arg1));
}

static qt_gsi::GenericMethod *_create_f_copy_2025 ()
{
  return new qt_gsi::GenericMethod ("copy", "@brief Method bool QFile::copy(const QString &newName)\n", false, &_init_f_copy_2025, &_call_f_copy_2025);
}

// QFile::FileError QFile::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFile::FileError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFile::FileError>::target_type > ((qt_gsi::Converter<QFile::FileError>::target_type)qt_gsi::CppToQtAdaptor<QFile::FileError>(((QFile *)cls)->error ()));
}

static qt_gsi::GenericMethod *_create_f_error_c0 ()
{
  return new qt_gsi::GenericMethod ("error", "@brief Method QFile::FileError QFile::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
}

// bool QFile::exists()


static void _init_f_exists_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_exists_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFile *)cls)->exists ());
}

static qt_gsi::GenericMethod *_create_f_exists_c0 ()
{
  return new qt_gsi::GenericMethod ("exists", "@brief Method bool QFile::exists()\n", true, &_init_f_exists_c0, &_call_f_exists_c0);
}

// QString QFile::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFile *)cls)->fileName ());
}

static qt_gsi::GenericMethod *_create_f_fileName_c0 ()
{
  return new qt_gsi::GenericMethod (":fileName", "@brief Method QString QFile::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
}

// bool QFile::flush()


static void _init_f_flush_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFile *)cls)->flush ());
}

static qt_gsi::GenericMethod *_create_f_flush_0 ()
{
  return new qt_gsi::GenericMethod ("flush", "@brief Method bool QFile::flush()\n", false, &_init_f_flush_0, &_call_f_flush_0);
}

// int QFile::handle()


static void _init_f_handle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_handle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFile *)cls)->handle ());
}

static qt_gsi::GenericMethod *_create_f_handle_c0 ()
{
  return new qt_gsi::GenericMethod ("handle", "@brief Method int QFile::handle()\n", true, &_init_f_handle_c0, &_call_f_handle_c0);
}

// bool QFile::isSequential()


static void _init_f_isSequential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSequential_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFile *)cls)->isSequential ());
}

static qt_gsi::GenericMethod *_create_f_isSequential_c0 ()
{
  return new qt_gsi::GenericMethod ("isSequential?", "@brief Method bool QFile::isSequential()\nThis is a reimplementation of QIODevice::isSequential", true, &_init_f_isSequential_c0, &_call_f_isSequential_c0);
}

// bool QFile::link(const QString &newName)


static void _init_f_link_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_link_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QFile *)cls)->link (arg1));
}

static qt_gsi::GenericMethod *_create_f_link_2025 ()
{
  return new qt_gsi::GenericMethod ("link", "@brief Method bool QFile::link(const QString &newName)\n", false, &_init_f_link_2025, &_call_f_link_2025);
}

// bool QFile::open(QFlags<QIODevice::OpenModeFlag> flags)


static void _init_f_open_3242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_open_3242 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > ();
  ret.write<bool > ((bool)((QFile *)cls)->open (qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_open_3242 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method bool QFile::open(QFlags<QIODevice::OpenModeFlag> flags)\nThis is a reimplementation of QIODevice::open", false, &_init_f_open_3242, &_call_f_open_3242);
}

// QFlags<QFile::Permission> QFile::permissions()


static void _init_f_permissions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QFile::Permission> >::target_type > ();
}

static void _call_f_permissions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QFile::Permission> >::target_type > ((qt_gsi::Converter<QFlags<QFile::Permission> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QFile::Permission> >(((QFile *)cls)->permissions ()));
}

static qt_gsi::GenericMethod *_create_f_permissions_c0 ()
{
  return new qt_gsi::GenericMethod ("permissions", "@brief Method QFlags<QFile::Permission> QFile::permissions()\n", true, &_init_f_permissions_c0, &_call_f_permissions_c0);
}

// qint64 QFile::pos()


static void _init_f_pos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_pos_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QFile *)cls)->pos ());
}

static qt_gsi::GenericMethod *_create_f_pos_c0 ()
{
  return new qt_gsi::GenericMethod ("pos", "@brief Method qint64 QFile::pos()\nThis is a reimplementation of QIODevice::pos", true, &_init_f_pos_c0, &_call_f_pos_c0);
}

// QString QFile::readLink()


static void _init_f_readLink_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_readLink_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFile *)cls)->readLink ());
}

static qt_gsi::GenericMethod *_create_f_readLink_c0 ()
{
  return new qt_gsi::GenericMethod ("readLink", "@brief Method QString QFile::readLink()\n", true, &_init_f_readLink_c0, &_call_f_readLink_c0);
}

// bool QFile::remove()


static void _init_f_remove_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_remove_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFile *)cls)->remove ());
}

static qt_gsi::GenericMethod *_create_f_remove_0 ()
{
  return new qt_gsi::GenericMethod ("remove", "@brief Method bool QFile::remove()\n", false, &_init_f_remove_0, &_call_f_remove_0);
}

// bool QFile::rename(const QString &newName)


static void _init_f_rename_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_rename_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QFile *)cls)->rename (arg1));
}

static qt_gsi::GenericMethod *_create_f_rename_2025 ()
{
  return new qt_gsi::GenericMethod ("rename", "@brief Method bool QFile::rename(const QString &newName)\n", false, &_init_f_rename_2025, &_call_f_rename_2025);
}

// bool QFile::resize(qint64 sz)


static void _init_f_resize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sz");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_resize_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ret.write<bool > ((bool)((QFile *)cls)->resize (arg1));
}

static qt_gsi::GenericMethod *_create_f_resize_986 ()
{
  return new qt_gsi::GenericMethod ("resize", "@brief Method bool QFile::resize(qint64 sz)\n", false, &_init_f_resize_986, &_call_f_resize_986);
}

// bool QFile::seek(qint64 offset)


static void _init_f_seek_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_seek_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ret.write<bool > ((bool)((QFile *)cls)->seek (arg1));
}

static qt_gsi::GenericMethod *_create_f_seek_986 ()
{
  return new qt_gsi::GenericMethod ("seek", "@brief Method bool QFile::seek(qint64 offset)\nThis is a reimplementation of QIODevice::seek", false, &_init_f_seek_986, &_call_f_seek_986);
}

// void QFile::setFileName(const QString &name)


static void _init_f_setFileName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileName_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFile *)cls)->setFileName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFileName_2025 ()
{
  return new qt_gsi::GenericMethod ("setFileName|fileName=", "@brief Method void QFile::setFileName(const QString &name)\n", false, &_init_f_setFileName_2025, &_call_f_setFileName_2025);
}

// bool QFile::setPermissions(QFlags<QFile::Permission> permissionSpec)


static void _init_f_setPermissions_2778 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("permissionSpec");
  decl->add_arg<const qt_gsi::Converter<QFlags<QFile::Permission> >::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setPermissions_2778 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QFile::Permission> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QFile::Permission> >::target_type & > ();
  ret.write<bool > ((bool)((QFile *)cls)->setPermissions (qt_gsi::QtToCppAdaptor<QFlags<QFile::Permission> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_setPermissions_2778 ()
{
  return new qt_gsi::GenericMethod ("setPermissions", "@brief Method bool QFile::setPermissions(QFlags<QFile::Permission> permissionSpec)\n", false, &_init_f_setPermissions_2778, &_call_f_setPermissions_2778);
}

// qint64 QFile::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QFile *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod ("size", "@brief Method qint64 QFile::size()\nThis is a reimplementation of QIODevice::size", true, &_init_f_size_c0, &_call_f_size_c0);
}

// QString QFile::symLinkTarget()


static void _init_f_symLinkTarget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_symLinkTarget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFile *)cls)->symLinkTarget ());
}

static qt_gsi::GenericMethod *_create_f_symLinkTarget_c0 ()
{
  return new qt_gsi::GenericMethod ("symLinkTarget", "@brief Method QString QFile::symLinkTarget()\n", true, &_init_f_symLinkTarget_c0, &_call_f_symLinkTarget_c0);
}

// void QFile::unsetError()


static void _init_f_unsetError_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetError_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFile *)cls)->unsetError ();
}

static qt_gsi::GenericMethod *_create_f_unsetError_0 ()
{
  return new qt_gsi::GenericMethod ("unsetError", "@brief Method void QFile::unsetError()\n", false, &_init_f_unsetError_0, &_call_f_unsetError_0);
}

// static bool QFile::copy(const QString &fileName, const QString &newName)


static void _init_f_copy_3942 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_copy_3942 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<bool > ((bool)QFile::copy (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_copy_3942 ()
{
  return new qt_gsi::GenericStaticMethod ("copy", "@brief Static method bool QFile::copy(const QString &fileName, const QString &newName)\nThis method is static and can be called without an instance.", &_init_f_copy_3942, &_call_f_copy_3942);
}

// static QString QFile::decodeName(const char *localFileName)


static void _init_f_decodeName_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("localFileName");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_decodeName_1731 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<QString > ((QString)QFile::decodeName (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_decodeName_1731 ()
{
  return new qt_gsi::GenericStaticMethod ("decodeName", "@brief Static method QString QFile::decodeName(const char *localFileName)\nThis method is static and can be called without an instance.", &_init_f_decodeName_1731, &_call_f_decodeName_1731);
}

// static QByteArray QFile::encodeName(const QString &fileName)


static void _init_f_encodeName_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_encodeName_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QByteArray > ((QByteArray)QFile::encodeName (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_encodeName_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("encodeName", "@brief Static method QByteArray QFile::encodeName(const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_encodeName_2025, &_call_f_encodeName_2025);
}

// static bool QFile::exists(const QString &fileName)


static void _init_f_exists_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_exists_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)QFile::exists (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_exists_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("exists", "@brief Static method bool QFile::exists(const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_exists_2025, &_call_f_exists_2025);
}

// static bool QFile::link(const QString &oldname, const QString &newName)


static void _init_f_link_3942 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldname");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_link_3942 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<bool > ((bool)QFile::link (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_link_3942 ()
{
  return new qt_gsi::GenericStaticMethod ("link", "@brief Static method bool QFile::link(const QString &oldname, const QString &newName)\nThis method is static and can be called without an instance.", &_init_f_link_3942, &_call_f_link_3942);
}

// static QFlags<QFile::Permission> QFile::permissions(const QString &filename)


static void _init_f_permissions_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<QFile::Permission> >::target_type > ();
}

static void _call_f_permissions_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<qt_gsi::Converter<QFlags<QFile::Permission> >::target_type > ((qt_gsi::Converter<QFlags<QFile::Permission> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QFile::Permission> >(QFile::permissions (arg1)));
}

static qt_gsi::GenericStaticMethod *_create_f_permissions_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("permissions", "@brief Static method QFlags<QFile::Permission> QFile::permissions(const QString &filename)\nThis method is static and can be called without an instance.", &_init_f_permissions_2025, &_call_f_permissions_2025);
}

// static QString QFile::readLink(const QString &fileName)


static void _init_f_readLink_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_readLink_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)QFile::readLink (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_readLink_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("readLink", "@brief Static method QString QFile::readLink(const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_readLink_2025, &_call_f_readLink_2025);
}

// static bool QFile::remove(const QString &fileName)


static void _init_f_remove_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_remove_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)QFile::remove (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_remove_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("remove", "@brief Static method bool QFile::remove(const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_remove_2025, &_call_f_remove_2025);
}

// static bool QFile::rename(const QString &oldName, const QString &newName)


static void _init_f_rename_3942 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_rename_3942 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<bool > ((bool)QFile::rename (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_rename_3942 ()
{
  return new qt_gsi::GenericStaticMethod ("rename", "@brief Static method bool QFile::rename(const QString &oldName, const QString &newName)\nThis method is static and can be called without an instance.", &_init_f_rename_3942, &_call_f_rename_3942);
}

// static bool QFile::resize(const QString &filename, qint64 sz)


static void _init_f_resize_2903 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sz");
  decl->add_arg<qint64 > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_resize_2903 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  qint64 arg2 = args.read<qint64 > ();
  ret.write<bool > ((bool)QFile::resize (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_resize_2903 ()
{
  return new qt_gsi::GenericStaticMethod ("resize", "@brief Static method bool QFile::resize(const QString &filename, qint64 sz)\nThis method is static and can be called without an instance.", &_init_f_resize_2903, &_call_f_resize_2903);
}

// static bool QFile::setPermissions(const QString &filename, QFlags<QFile::Permission> permissionSpec)


static void _init_f_setPermissions_4695 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("permissionSpec");
  decl->add_arg<const qt_gsi::Converter<QFlags<QFile::Permission> >::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setPermissions_4695 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QFlags<QFile::Permission> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QFile::Permission> >::target_type & > ();
  ret.write<bool > ((bool)QFile::setPermissions (arg1, qt_gsi::QtToCppAdaptor<QFlags<QFile::Permission> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_setPermissions_4695 ()
{
  return new qt_gsi::GenericStaticMethod ("setPermissions", "@brief Static method bool QFile::setPermissions(const QString &filename, QFlags<QFile::Permission> permissionSpec)\nThis method is static and can be called without an instance.", &_init_f_setPermissions_4695, &_call_f_setPermissions_4695);
}

// static QString QFile::symLinkTarget(const QString &fileName)


static void _init_f_symLinkTarget_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_symLinkTarget_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)QFile::symLinkTarget (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_symLinkTarget_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("symLinkTarget", "@brief Static method QString QFile::symLinkTarget(const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_symLinkTarget_2025, &_call_f_symLinkTarget_2025);
}

// static QString QFile::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QFile::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFile::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QFile::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QFile::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFile::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QFile::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QFile::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFile::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QFile::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QFile::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFile::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QFile, QFile_EventAdaptor> ea_QFile;


namespace gsi
{
extern gsi::Class<QIODevice> decl_QIODevice;

gsi::Class<QFile> decl_QFile (ea_QFile, decl_QIODevice, "QFile",
  gsi::Methods(_create_ctor_QFile_0 ()) +
  gsi::Methods(_create_ctor_QFile_2025 ()) +
  gsi::Methods(_create_ctor_QFile_1302 ()) +
  gsi::Methods(_create_ctor_QFile_3219 ()) +
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_atEnd_c0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_copy_2025 ()) +
  gsi::Methods(_create_f_error_c0 ()) +
  gsi::Methods(_create_f_exists_c0 ()) +
  gsi::Methods(_create_f_fileName_c0 ()) +
  gsi::Methods(_create_f_flush_0 ()) +
  gsi::Methods(_create_f_handle_c0 ()) +
  gsi::Methods(_create_f_isSequential_c0 ()) +
  gsi::Methods(_create_f_link_2025 ()) +
  gsi::Methods(_create_f_open_3242 ()) +
  gsi::Methods(_create_f_permissions_c0 ()) +
  gsi::Methods(_create_f_pos_c0 ()) +
  gsi::Methods(_create_f_readLink_c0 ()) +
  gsi::Methods(_create_f_remove_0 ()) +
  gsi::Methods(_create_f_rename_2025 ()) +
  gsi::Methods(_create_f_resize_986 ()) +
  gsi::Methods(_create_f_seek_986 ()) +
  gsi::Methods(_create_f_setFileName_2025 ()) +
  gsi::Methods(_create_f_setPermissions_2778 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_symLinkTarget_c0 ()) +
  gsi::Methods(_create_f_unsetError_0 ()) +
  qt_gsi::qt_signal<QFile, QFile_EventAdaptor> ("aboutToClose", &QFile_EventAdaptor::aboutToClose_e_0, "@brief Signal declaration for QFile::aboutToClose()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFile, QFile_EventAdaptor, qint64> ("bytesWritten", &QFile_EventAdaptor::bytesWritten_e_986, gsi::arg("bytes"), "@brief Signal declaration for QFile::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFile, QFile_EventAdaptor, QObject *> ("destroyed", &QFile_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QFile::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFile, QFile_EventAdaptor> ("readChannelFinished", &QFile_EventAdaptor::readChannelFinished_e_0, "@brief Signal declaration for QFile::readChannelFinished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFile, QFile_EventAdaptor> ("readyRead", &QFile_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QFile::readyRead()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_copy_3942 ()) +
  gsi::Methods(_create_f_decodeName_1731 ()) +
  gsi::Methods(_create_f_encodeName_2025 ()) +
  gsi::Methods(_create_f_exists_2025 ()) +
  gsi::Methods(_create_f_link_3942 ()) +
  gsi::Methods(_create_f_permissions_2025 ()) +
  gsi::Methods(_create_f_readLink_2025 ()) +
  gsi::Methods(_create_f_remove_2025 ()) +
  gsi::Methods(_create_f_rename_3942 ()) +
  gsi::Methods(_create_f_resize_2903 ()) +
  gsi::Methods(_create_f_setPermissions_4695 ()) +
  gsi::Methods(_create_f_symLinkTarget_2025 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QFile");

}


//  Implementation of the enum wrapper class for QFile::FileError
namespace qt_gsi
{

static QFile_FileError_Enum *c_1_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::NoError); }
static QFile_FileError_Enum *c_2_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::ReadError); }
static QFile_FileError_Enum *c_3_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::WriteError); }
static QFile_FileError_Enum *c_4_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::FatalError); }
static QFile_FileError_Enum *c_5_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::ResourceError); }
static QFile_FileError_Enum *c_6_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::OpenError); }
static QFile_FileError_Enum *c_7_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::AbortError); }
static QFile_FileError_Enum *c_8_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::TimeOutError); }
static QFile_FileError_Enum *c_9_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::UnspecifiedError); }
static QFile_FileError_Enum *c_10_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::RemoveError); }
static QFile_FileError_Enum *c_11_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::RenameError); }
static QFile_FileError_Enum *c_12_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::PositionError); }
static QFile_FileError_Enum *c_13_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::ResizeError); }
static QFile_FileError_Enum *c_14_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::PermissionsError); }
static QFile_FileError_Enum *c_15_QFile_FileError_Enum () { return new QFile_FileError_Enum (QFile::CopyError); }

static gsi::Methods mkdefs_QFile_FileError () {
  return
    gsi::constant ("NoError", &qt_gsi::c_1_QFile_FileError_Enum, "@brief Enum constant QFile::NoError") +
    gsi::constant ("ReadError", &qt_gsi::c_2_QFile_FileError_Enum, "@brief Enum constant QFile::ReadError") +
    gsi::constant ("WriteError", &qt_gsi::c_3_QFile_FileError_Enum, "@brief Enum constant QFile::WriteError") +
    gsi::constant ("FatalError", &qt_gsi::c_4_QFile_FileError_Enum, "@brief Enum constant QFile::FatalError") +
    gsi::constant ("ResourceError", &qt_gsi::c_5_QFile_FileError_Enum, "@brief Enum constant QFile::ResourceError") +
    gsi::constant ("OpenError", &qt_gsi::c_6_QFile_FileError_Enum, "@brief Enum constant QFile::OpenError") +
    gsi::constant ("AbortError", &qt_gsi::c_7_QFile_FileError_Enum, "@brief Enum constant QFile::AbortError") +
    gsi::constant ("TimeOutError", &qt_gsi::c_8_QFile_FileError_Enum, "@brief Enum constant QFile::TimeOutError") +
    gsi::constant ("UnspecifiedError", &qt_gsi::c_9_QFile_FileError_Enum, "@brief Enum constant QFile::UnspecifiedError") +
    gsi::constant ("RemoveError", &qt_gsi::c_10_QFile_FileError_Enum, "@brief Enum constant QFile::RemoveError") +
    gsi::constant ("RenameError", &qt_gsi::c_11_QFile_FileError_Enum, "@brief Enum constant QFile::RenameError") +
    gsi::constant ("PositionError", &qt_gsi::c_12_QFile_FileError_Enum, "@brief Enum constant QFile::PositionError") +
    gsi::constant ("ResizeError", &qt_gsi::c_13_QFile_FileError_Enum, "@brief Enum constant QFile::ResizeError") +
    gsi::constant ("PermissionsError", &qt_gsi::c_14_QFile_FileError_Enum, "@brief Enum constant QFile::PermissionsError") +
    gsi::constant ("CopyError", &qt_gsi::c_15_QFile_FileError_Enum, "@brief Enum constant QFile::CopyError");
}

static std::string to_s_QFile_FileError_Enum (const QFile_FileError_Enum *e)
{
  if (e->value () == QFile::NoError) { return tl::sprintf ("NoError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::ReadError) { return tl::sprintf ("ReadError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::WriteError) { return tl::sprintf ("WriteError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::FatalError) { return tl::sprintf ("FatalError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::ResourceError) { return tl::sprintf ("ResourceError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::OpenError) { return tl::sprintf ("OpenError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::AbortError) { return tl::sprintf ("AbortError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::TimeOutError) { return tl::sprintf ("TimeOutError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::UnspecifiedError) { return tl::sprintf ("UnspecifiedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::RemoveError) { return tl::sprintf ("RemoveError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::RenameError) { return tl::sprintf ("RenameError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::PositionError) { return tl::sprintf ("PositionError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::ResizeError) { return tl::sprintf ("ResizeError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::PermissionsError) { return tl::sprintf ("PermissionsError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::CopyError) { return tl::sprintf ("CopyError (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFile_FileError_Enum (const QFile_FileError_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFile_FileError_Enum *from_i_QFile_FileError_Enum (unsigned int i)
{
  return new QFile_FileError_Enum ((QFile::FileError) i);
}

static bool equalQFile_FileError_Enum (const QFile_FileError_Enum *e, QFile_FileError_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFile_FileError_Enum (const QFile_FileError_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFile_FileError_Enums oropQFile_FileError_Enums (const QFile_FileError_Enums *e, const QFile_FileError_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFile_FileError_Enums andopQFile_FileError_Enums (const QFile_FileError_Enums *e, const QFile_FileError_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFile_FileError_Enums xoropQFile_FileError_Enums (const QFile_FileError_Enums *e, const QFile_FileError_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFile_FileError_Enums (const QFile_FileError_Enums *e)
{
  std::string l;
  if (e->testFlag (QFile::NoError)) { if (!l.empty ()) l += "|"; l += "NoError"; }
  if (e->testFlag (QFile::ReadError)) { if (!l.empty ()) l += "|"; l += "ReadError"; }
  if (e->testFlag (QFile::WriteError)) { if (!l.empty ()) l += "|"; l += "WriteError"; }
  if (e->testFlag (QFile::FatalError)) { if (!l.empty ()) l += "|"; l += "FatalError"; }
  if (e->testFlag (QFile::ResourceError)) { if (!l.empty ()) l += "|"; l += "ResourceError"; }
  if (e->testFlag (QFile::OpenError)) { if (!l.empty ()) l += "|"; l += "OpenError"; }
  if (e->testFlag (QFile::AbortError)) { if (!l.empty ()) l += "|"; l += "AbortError"; }
  if (e->testFlag (QFile::TimeOutError)) { if (!l.empty ()) l += "|"; l += "TimeOutError"; }
  if (e->testFlag (QFile::UnspecifiedError)) { if (!l.empty ()) l += "|"; l += "UnspecifiedError"; }
  if (e->testFlag (QFile::RemoveError)) { if (!l.empty ()) l += "|"; l += "RemoveError"; }
  if (e->testFlag (QFile::RenameError)) { if (!l.empty ()) l += "|"; l += "RenameError"; }
  if (e->testFlag (QFile::PositionError)) { if (!l.empty ()) l += "|"; l += "PositionError"; }
  if (e->testFlag (QFile::ResizeError)) { if (!l.empty ()) l += "|"; l += "ResizeError"; }
  if (e->testFlag (QFile::PermissionsError)) { if (!l.empty ()) l += "|"; l += "PermissionsError"; }
  if (e->testFlag (QFile::CopyError)) { if (!l.empty ()) l += "|"; l += "CopyError"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFile_FileError_Enums (const QFile_FileError_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFile_FileError_Enums (const QFile_FileError_Enums *e, const QFile_FileError_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFile_FileError_Enums> decl_QFile_FileError_Enums ("QFile_QFlags_FileError",
  gsi::method_ext ("|", &qt_gsi::oropQFile_FileError_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFile_FileError_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFile_FileError_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFile_FileError_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFile_FileError_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFile_FileError_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFile::FileError> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFile_FileError_Enum> decl_QFile_FileError_Enum (decl_QFile_FileError_Enums, "QFile_FileError",
  qt_gsi::mkdefs_QFile_FileError () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFile_FileError_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFile_FileError_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFile_FileError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFile_FileError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFile_FileError_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFile::FileError enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFile> inject_QFile_FileError_Enum_in_parent (qt_gsi::mkdefs_QFile_FileError ());
static gsi::ClassExt<QFile> decl_QFile_FileError_Enum_as_child (decl_QFile_FileError_Enum, "FileError");

}


//  Implementation of the enum wrapper class for QFile::Permission
namespace qt_gsi
{

static QFile_Permission_Enum *c_1_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::ReadOwner); }
static QFile_Permission_Enum *c_2_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::WriteOwner); }
static QFile_Permission_Enum *c_3_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::ExeOwner); }
static QFile_Permission_Enum *c_4_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::ReadUser); }
static QFile_Permission_Enum *c_5_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::WriteUser); }
static QFile_Permission_Enum *c_6_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::ExeUser); }
static QFile_Permission_Enum *c_7_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::ReadGroup); }
static QFile_Permission_Enum *c_8_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::WriteGroup); }
static QFile_Permission_Enum *c_9_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::ExeGroup); }
static QFile_Permission_Enum *c_10_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::ReadOther); }
static QFile_Permission_Enum *c_11_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::WriteOther); }
static QFile_Permission_Enum *c_12_QFile_Permission_Enum () { return new QFile_Permission_Enum (QFile::ExeOther); }

static gsi::Methods mkdefs_QFile_Permission () {
  return
    gsi::constant ("ReadOwner", &qt_gsi::c_1_QFile_Permission_Enum, "@brief Enum constant QFile::ReadOwner") +
    gsi::constant ("WriteOwner", &qt_gsi::c_2_QFile_Permission_Enum, "@brief Enum constant QFile::WriteOwner") +
    gsi::constant ("ExeOwner", &qt_gsi::c_3_QFile_Permission_Enum, "@brief Enum constant QFile::ExeOwner") +
    gsi::constant ("ReadUser", &qt_gsi::c_4_QFile_Permission_Enum, "@brief Enum constant QFile::ReadUser") +
    gsi::constant ("WriteUser", &qt_gsi::c_5_QFile_Permission_Enum, "@brief Enum constant QFile::WriteUser") +
    gsi::constant ("ExeUser", &qt_gsi::c_6_QFile_Permission_Enum, "@brief Enum constant QFile::ExeUser") +
    gsi::constant ("ReadGroup", &qt_gsi::c_7_QFile_Permission_Enum, "@brief Enum constant QFile::ReadGroup") +
    gsi::constant ("WriteGroup", &qt_gsi::c_8_QFile_Permission_Enum, "@brief Enum constant QFile::WriteGroup") +
    gsi::constant ("ExeGroup", &qt_gsi::c_9_QFile_Permission_Enum, "@brief Enum constant QFile::ExeGroup") +
    gsi::constant ("ReadOther", &qt_gsi::c_10_QFile_Permission_Enum, "@brief Enum constant QFile::ReadOther") +
    gsi::constant ("WriteOther", &qt_gsi::c_11_QFile_Permission_Enum, "@brief Enum constant QFile::WriteOther") +
    gsi::constant ("ExeOther", &qt_gsi::c_12_QFile_Permission_Enum, "@brief Enum constant QFile::ExeOther");
}

static std::string to_s_QFile_Permission_Enum (const QFile_Permission_Enum *e)
{
  if (e->value () == QFile::ReadOwner) { return tl::sprintf ("ReadOwner (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::WriteOwner) { return tl::sprintf ("WriteOwner (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::ExeOwner) { return tl::sprintf ("ExeOwner (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::ReadUser) { return tl::sprintf ("ReadUser (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::WriteUser) { return tl::sprintf ("WriteUser (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::ExeUser) { return tl::sprintf ("ExeUser (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::ReadGroup) { return tl::sprintf ("ReadGroup (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::WriteGroup) { return tl::sprintf ("WriteGroup (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::ExeGroup) { return tl::sprintf ("ExeGroup (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::ReadOther) { return tl::sprintf ("ReadOther (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::WriteOther) { return tl::sprintf ("WriteOther (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFile::ExeOther) { return tl::sprintf ("ExeOther (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFile_Permission_Enum (const QFile_Permission_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFile_Permission_Enum *from_i_QFile_Permission_Enum (unsigned int i)
{
  return new QFile_Permission_Enum ((QFile::Permission) i);
}

static bool equalQFile_Permission_Enum (const QFile_Permission_Enum *e, QFile_Permission_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFile_Permission_Enum (const QFile_Permission_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFile_Permission_Enums oropQFile_Permission_Enums (const QFile_Permission_Enums *e, const QFile_Permission_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFile_Permission_Enums andopQFile_Permission_Enums (const QFile_Permission_Enums *e, const QFile_Permission_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFile_Permission_Enums xoropQFile_Permission_Enums (const QFile_Permission_Enums *e, const QFile_Permission_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFile_Permission_Enums (const QFile_Permission_Enums *e)
{
  std::string l;
  if (e->testFlag (QFile::ReadOwner)) { if (!l.empty ()) l += "|"; l += "ReadOwner"; }
  if (e->testFlag (QFile::WriteOwner)) { if (!l.empty ()) l += "|"; l += "WriteOwner"; }
  if (e->testFlag (QFile::ExeOwner)) { if (!l.empty ()) l += "|"; l += "ExeOwner"; }
  if (e->testFlag (QFile::ReadUser)) { if (!l.empty ()) l += "|"; l += "ReadUser"; }
  if (e->testFlag (QFile::WriteUser)) { if (!l.empty ()) l += "|"; l += "WriteUser"; }
  if (e->testFlag (QFile::ExeUser)) { if (!l.empty ()) l += "|"; l += "ExeUser"; }
  if (e->testFlag (QFile::ReadGroup)) { if (!l.empty ()) l += "|"; l += "ReadGroup"; }
  if (e->testFlag (QFile::WriteGroup)) { if (!l.empty ()) l += "|"; l += "WriteGroup"; }
  if (e->testFlag (QFile::ExeGroup)) { if (!l.empty ()) l += "|"; l += "ExeGroup"; }
  if (e->testFlag (QFile::ReadOther)) { if (!l.empty ()) l += "|"; l += "ReadOther"; }
  if (e->testFlag (QFile::WriteOther)) { if (!l.empty ()) l += "|"; l += "WriteOther"; }
  if (e->testFlag (QFile::ExeOther)) { if (!l.empty ()) l += "|"; l += "ExeOther"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFile_Permission_Enums (const QFile_Permission_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFile_Permission_Enums (const QFile_Permission_Enums *e, const QFile_Permission_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFile_Permission_Enums> decl_QFile_Permission_Enums ("QFile_QFlags_Permission",
  gsi::method_ext ("|", &qt_gsi::oropQFile_Permission_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFile_Permission_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFile_Permission_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFile_Permission_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFile_Permission_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFile_Permission_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFile::Permission> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFile_Permission_Enum> decl_QFile_Permission_Enum (decl_QFile_Permission_Enums, "QFile_Permission",
  qt_gsi::mkdefs_QFile_Permission () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFile_Permission_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFile_Permission_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFile_Permission_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFile_Permission_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFile_Permission_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFile::Permission enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFile> inject_QFile_Permission_Enum_in_parent (qt_gsi::mkdefs_QFile_Permission ());
static gsi::ClassExt<QFile> decl_QFile_Permission_Enum_as_child (decl_QFile_Permission_Enum, "Permission");

}

