
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDataWidgetMapper.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQDataWidgetMapper_EventAdaptor.h"
#include "gsiDeclQDataWidgetMapper_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDataWidgetMapper

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QDataWidgetMapper::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QDataWidgetMapper::addMapping(QWidget *widget, int section)


static void _init_f_addMapping_1974 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("section");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addMapping_1974 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  int arg2 = args.read<int > ();
  ((QDataWidgetMapper *)cls)->addMapping (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addMapping_1974 ()
{
  return new qt_gsi::GenericMethod ("addMapping", "@brief Method void QDataWidgetMapper::addMapping(QWidget *widget, int section)\n", false, &_init_f_addMapping_1974, &_call_f_addMapping_1974);
}

// void QDataWidgetMapper::addMapping(QWidget *widget, int section, const QByteArray &propertyName)


static void _init_f_addMapping_4175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("section");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("propertyName");
  decl->add_arg<const QByteArray & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addMapping_4175 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  int arg2 = args.read<int > ();
  const QByteArray &arg3 = args.read<const QByteArray & > ();
  ((QDataWidgetMapper *)cls)->addMapping (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_addMapping_4175 ()
{
  return new qt_gsi::GenericMethod ("addMapping", "@brief Method void QDataWidgetMapper::addMapping(QWidget *widget, int section, const QByteArray &propertyName)\n", false, &_init_f_addMapping_4175, &_call_f_addMapping_4175);
}

// void QDataWidgetMapper::clearMapping()


static void _init_f_clearMapping_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearMapping_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDataWidgetMapper *)cls)->clearMapping ();
}

static qt_gsi::GenericMethod *_create_f_clearMapping_0 ()
{
  return new qt_gsi::GenericMethod ("clearMapping", "@brief Method void QDataWidgetMapper::clearMapping()\n", false, &_init_f_clearMapping_0, &_call_f_clearMapping_0);
}

// int QDataWidgetMapper::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDataWidgetMapper *)cls)->currentIndex ());
}

static qt_gsi::GenericMethod *_create_f_currentIndex_c0 ()
{
  return new qt_gsi::GenericMethod (":currentIndex", "@brief Method int QDataWidgetMapper::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
}

// QAbstractItemDelegate *QDataWidgetMapper::itemDelegate()


static void _init_f_itemDelegate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QDataWidgetMapper *)cls)->itemDelegate ());
}

static qt_gsi::GenericMethod *_create_f_itemDelegate_c0 ()
{
  return new qt_gsi::GenericMethod (":itemDelegate", "@brief Method QAbstractItemDelegate *QDataWidgetMapper::itemDelegate()\n", true, &_init_f_itemDelegate_c0, &_call_f_itemDelegate_c0);
}

// QByteArray QDataWidgetMapper::mappedPropertyName(QWidget *widget)


static void _init_f_mappedPropertyName_c1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_mappedPropertyName_c1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<QByteArray > ((QByteArray)((QDataWidgetMapper *)cls)->mappedPropertyName (arg1));
}

static qt_gsi::GenericMethod *_create_f_mappedPropertyName_c1315 ()
{
  return new qt_gsi::GenericMethod ("mappedPropertyName", "@brief Method QByteArray QDataWidgetMapper::mappedPropertyName(QWidget *widget)\n", true, &_init_f_mappedPropertyName_c1315, &_call_f_mappedPropertyName_c1315);
}

// int QDataWidgetMapper::mappedSection(QWidget *widget)


static void _init_f_mappedSection_c1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_mappedSection_c1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<int > ((int)((QDataWidgetMapper *)cls)->mappedSection (arg1));
}

static qt_gsi::GenericMethod *_create_f_mappedSection_c1315 ()
{
  return new qt_gsi::GenericMethod ("mappedSection", "@brief Method int QDataWidgetMapper::mappedSection(QWidget *widget)\n", true, &_init_f_mappedSection_c1315, &_call_f_mappedSection_c1315);
}

// QWidget *QDataWidgetMapper::mappedWidgetAt(int section)


static void _init_f_mappedWidgetAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_mappedWidgetAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QWidget * > ((QWidget *)((QDataWidgetMapper *)cls)->mappedWidgetAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_mappedWidgetAt_c767 ()
{
  return new qt_gsi::GenericMethod ("mappedWidgetAt", "@brief Method QWidget *QDataWidgetMapper::mappedWidgetAt(int section)\n", true, &_init_f_mappedWidgetAt_c767, &_call_f_mappedWidgetAt_c767);
}

// QAbstractItemModel *QDataWidgetMapper::model()


static void _init_f_model_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemModel * > ();
}

static void _call_f_model_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractItemModel * > ((QAbstractItemModel *)((QDataWidgetMapper *)cls)->model ());
}

static qt_gsi::GenericMethod *_create_f_model_c0 ()
{
  return new qt_gsi::GenericMethod (":model", "@brief Method QAbstractItemModel *QDataWidgetMapper::model()\n", true, &_init_f_model_c0, &_call_f_model_c0);
}

// Qt::Orientation QDataWidgetMapper::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::Orientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::Orientation>::target_type > ((qt_gsi::Converter<Qt::Orientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::Orientation>(((QDataWidgetMapper *)cls)->orientation ()));
}

static qt_gsi::GenericMethod *_create_f_orientation_c0 ()
{
  return new qt_gsi::GenericMethod (":orientation", "@brief Method Qt::Orientation QDataWidgetMapper::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
}

// void QDataWidgetMapper::removeMapping(QWidget *widget)


static void _init_f_removeMapping_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeMapping_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QDataWidgetMapper *)cls)->removeMapping (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeMapping_1315 ()
{
  return new qt_gsi::GenericMethod ("removeMapping", "@brief Method void QDataWidgetMapper::removeMapping(QWidget *widget)\n", false, &_init_f_removeMapping_1315, &_call_f_removeMapping_1315);
}

// void QDataWidgetMapper::revert()


static void _init_f_revert_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_revert_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDataWidgetMapper *)cls)->revert ();
}

static qt_gsi::GenericMethod *_create_f_revert_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@brief Method void QDataWidgetMapper::revert()\n", false, &_init_f_revert_0, &_call_f_revert_0);
}

// QModelIndex QDataWidgetMapper::rootIndex()


static void _init_f_rootIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QModelIndex > ();
}

static void _call_f_rootIndex_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QModelIndex > ((QModelIndex)((QDataWidgetMapper *)cls)->rootIndex ());
}

static qt_gsi::GenericMethod *_create_f_rootIndex_c0 ()
{
  return new qt_gsi::GenericMethod (":rootIndex", "@brief Method QModelIndex QDataWidgetMapper::rootIndex()\n", true, &_init_f_rootIndex_c0, &_call_f_rootIndex_c0);
}

// void QDataWidgetMapper::setCurrentIndex(int index)


static void _init_f_setCurrentIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QDataWidgetMapper *)cls)->setCurrentIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentIndex_767 ()
{
  return new qt_gsi::GenericMethod ("setCurrentIndex|currentIndex=", "@brief Method void QDataWidgetMapper::setCurrentIndex(int index)\n", false, &_init_f_setCurrentIndex_767, &_call_f_setCurrentIndex_767);
}

// void QDataWidgetMapper::setCurrentModelIndex(const QModelIndex &index)


static void _init_f_setCurrentModelIndex_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentModelIndex_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QDataWidgetMapper *)cls)->setCurrentModelIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentModelIndex_2395 ()
{
  return new qt_gsi::GenericMethod ("setCurrentModelIndex", "@brief Method void QDataWidgetMapper::setCurrentModelIndex(const QModelIndex &index)\n", false, &_init_f_setCurrentModelIndex_2395, &_call_f_setCurrentModelIndex_2395);
}

// void QDataWidgetMapper::setItemDelegate(QAbstractItemDelegate *delegate)


static void _init_f_setItemDelegate_2717 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delegate");
  decl->add_arg<QAbstractItemDelegate * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemDelegate_2717 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemDelegate *arg1 = args.read<QAbstractItemDelegate * > ();
  ((QDataWidgetMapper *)cls)->setItemDelegate (arg1);
}

static qt_gsi::GenericMethod *_create_f_setItemDelegate_2717 ()
{
  return new qt_gsi::GenericMethod ("setItemDelegate|itemDelegate=", "@brief Method void QDataWidgetMapper::setItemDelegate(QAbstractItemDelegate *delegate)\n", false, &_init_f_setItemDelegate_2717, &_call_f_setItemDelegate_2717);
}

// void QDataWidgetMapper::setModel(QAbstractItemModel *model)


static void _init_f_setModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModel_2419 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > ();
  ((QDataWidgetMapper *)cls)->setModel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setModel_2419 ()
{
  return new qt_gsi::GenericMethod ("setModel|model=", "@brief Method void QDataWidgetMapper::setModel(QAbstractItemModel *model)\n", false, &_init_f_setModel_2419, &_call_f_setModel_2419);
}

// void QDataWidgetMapper::setOrientation(Qt::Orientation aOrientation)


static void _init_f_setOrientation_1913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("aOrientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrientation_1913 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  ((QDataWidgetMapper *)cls)->setOrientation (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setOrientation_1913 ()
{
  return new qt_gsi::GenericMethod ("setOrientation|orientation=", "@brief Method void QDataWidgetMapper::setOrientation(Qt::Orientation aOrientation)\n", false, &_init_f_setOrientation_1913, &_call_f_setOrientation_1913);
}

// void QDataWidgetMapper::setRootIndex(const QModelIndex &index)


static void _init_f_setRootIndex_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRootIndex_2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QDataWidgetMapper *)cls)->setRootIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setRootIndex_2395 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex|rootIndex=", "@brief Method void QDataWidgetMapper::setRootIndex(const QModelIndex &index)\n", false, &_init_f_setRootIndex_2395, &_call_f_setRootIndex_2395);
}

// void QDataWidgetMapper::setSubmitPolicy(QDataWidgetMapper::SubmitPolicy policy)


static void _init_f_setSubmitPolicy_3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSubmitPolicy_3488 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type & > ();
  ((QDataWidgetMapper *)cls)->setSubmitPolicy (qt_gsi::QtToCppAdaptor<QDataWidgetMapper::SubmitPolicy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSubmitPolicy_3488 ()
{
  return new qt_gsi::GenericMethod ("setSubmitPolicy|submitPolicy=", "@brief Method void QDataWidgetMapper::setSubmitPolicy(QDataWidgetMapper::SubmitPolicy policy)\n", false, &_init_f_setSubmitPolicy_3488, &_call_f_setSubmitPolicy_3488);
}

// bool QDataWidgetMapper::submit()


static void _init_f_submit_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_submit_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDataWidgetMapper *)cls)->submit ());
}

static qt_gsi::GenericMethod *_create_f_submit_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@brief Method bool QDataWidgetMapper::submit()\n", false, &_init_f_submit_0, &_call_f_submit_0);
}

// QDataWidgetMapper::SubmitPolicy QDataWidgetMapper::submitPolicy()


static void _init_f_submitPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type > ();
}

static void _call_f_submitPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type > ((qt_gsi::Converter<QDataWidgetMapper::SubmitPolicy>::target_type)qt_gsi::CppToQtAdaptor<QDataWidgetMapper::SubmitPolicy>(((QDataWidgetMapper *)cls)->submitPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_submitPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":submitPolicy", "@brief Method QDataWidgetMapper::SubmitPolicy QDataWidgetMapper::submitPolicy()\n", true, &_init_f_submitPolicy_c0, &_call_f_submitPolicy_c0);
}

// void QDataWidgetMapper::toFirst()


static void _init_f_toFirst_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toFirst_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDataWidgetMapper *)cls)->toFirst ();
}

static qt_gsi::GenericMethod *_create_f_toFirst_0 ()
{
  return new qt_gsi::GenericMethod ("toFirst", "@brief Method void QDataWidgetMapper::toFirst()\n", false, &_init_f_toFirst_0, &_call_f_toFirst_0);
}

// void QDataWidgetMapper::toLast()


static void _init_f_toLast_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toLast_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDataWidgetMapper *)cls)->toLast ();
}

static qt_gsi::GenericMethod *_create_f_toLast_0 ()
{
  return new qt_gsi::GenericMethod ("toLast", "@brief Method void QDataWidgetMapper::toLast()\n", false, &_init_f_toLast_0, &_call_f_toLast_0);
}

// void QDataWidgetMapper::toNext()


static void _init_f_toNext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toNext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDataWidgetMapper *)cls)->toNext ();
}

static qt_gsi::GenericMethod *_create_f_toNext_0 ()
{
  return new qt_gsi::GenericMethod ("toNext", "@brief Method void QDataWidgetMapper::toNext()\n", false, &_init_f_toNext_0, &_call_f_toNext_0);
}

// void QDataWidgetMapper::toPrevious()


static void _init_f_toPrevious_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toPrevious_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDataWidgetMapper *)cls)->toPrevious ();
}

static qt_gsi::GenericMethod *_create_f_toPrevious_0 ()
{
  return new qt_gsi::GenericMethod ("toPrevious", "@brief Method void QDataWidgetMapper::toPrevious()\n", false, &_init_f_toPrevious_0, &_call_f_toPrevious_0);
}

// static QString QDataWidgetMapper::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QDataWidgetMapper::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QDataWidgetMapper::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QDataWidgetMapper::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QDataWidgetMapper::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QDataWidgetMapper::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QDataWidgetMapper::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QDataWidgetMapper::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QDataWidgetMapper::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QDataWidgetMapper::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QDataWidgetMapper::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QDataWidgetMapper::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QDataWidgetMapper, QDataWidgetMapper_EventAdaptor> ea_QDataWidgetMapper;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QDataWidgetMapper> decl_QDataWidgetMapper (ea_QDataWidgetMapper, decl_QObject, "QDataWidgetMapper_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addMapping_1974 ()) +
  gsi::Methods(_create_f_addMapping_4175 ()) +
  gsi::Methods(_create_f_clearMapping_0 ()) +
  gsi::Methods(_create_f_currentIndex_c0 ()) +
  gsi::Methods(_create_f_itemDelegate_c0 ()) +
  gsi::Methods(_create_f_mappedPropertyName_c1315 ()) +
  gsi::Methods(_create_f_mappedSection_c1315 ()) +
  gsi::Methods(_create_f_mappedWidgetAt_c767 ()) +
  gsi::Methods(_create_f_model_c0 ()) +
  gsi::Methods(_create_f_orientation_c0 ()) +
  gsi::Methods(_create_f_removeMapping_1315 ()) +
  gsi::Methods(_create_f_revert_0 ()) +
  gsi::Methods(_create_f_rootIndex_c0 ()) +
  gsi::Methods(_create_f_setCurrentIndex_767 ()) +
  gsi::Methods(_create_f_setCurrentModelIndex_2395 ()) +
  gsi::Methods(_create_f_setItemDelegate_2717 ()) +
  gsi::Methods(_create_f_setModel_2419 ()) +
  gsi::Methods(_create_f_setOrientation_1913 ()) +
  gsi::Methods(_create_f_setRootIndex_2395 ()) +
  gsi::Methods(_create_f_setSubmitPolicy_3488 ()) +
  gsi::Methods(_create_f_submit_0 ()) +
  gsi::Methods(_create_f_submitPolicy_c0 ()) +
  gsi::Methods(_create_f_toFirst_0 ()) +
  gsi::Methods(_create_f_toLast_0 ()) +
  gsi::Methods(_create_f_toNext_0 ()) +
  gsi::Methods(_create_f_toPrevious_0 ()) +
  qt_gsi::qt_signal<QDataWidgetMapper, QDataWidgetMapper_EventAdaptor, int> ("currentIndexChanged", &QDataWidgetMapper_EventAdaptor::currentIndexChanged_e_767, gsi::arg("index"), "@brief Signal declaration for QDataWidgetMapper::currentIndexChanged(int index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QDataWidgetMapper, QDataWidgetMapper_EventAdaptor, QObject *> ("destroyed", &QDataWidgetMapper_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QDataWidgetMapper::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QDataWidgetMapper");
}


class QDataWidgetMapper_Adaptor : public QDataWidgetMapper, public qt_gsi::QtObjectBase
{
public:

  virtual ~QDataWidgetMapper_Adaptor();

  //  [adaptor ctor] QDataWidgetMapper::QDataWidgetMapper(QObject *parent)
  QDataWidgetMapper_Adaptor() : QDataWidgetMapper()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDataWidgetMapper::QDataWidgetMapper(QObject *parent)
  QDataWidgetMapper_Adaptor(QObject *parent) : QDataWidgetMapper(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QDataWidgetMapper::receivers(const char *signal)
  int fp_QDataWidgetMapper_receivers_c1731 (const char *signal) const {
    return QDataWidgetMapper::receivers(signal);
  }

  //  QObject *QDataWidgetMapper::sender()
  QObject * fp_QDataWidgetMapper_sender_c0 () const {
    return QDataWidgetMapper::sender();
  }

  //  [adaptor impl] bool QDataWidgetMapper::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QDataWidgetMapper::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QDataWidgetMapper_Adaptor, bool, QEvent *>(&QDataWidgetMapper_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QDataWidgetMapper::event(arg1);
    }
  }

  //  [adaptor impl] bool QDataWidgetMapper::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QDataWidgetMapper::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QDataWidgetMapper_Adaptor, bool, QObject *, QEvent *>(&QDataWidgetMapper_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QDataWidgetMapper::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QDataWidgetMapper::setCurrentIndex(int index)
  void cbs_setCurrentIndex_767_0(int index)
  {
    QDataWidgetMapper::setCurrentIndex(index);
  }

  virtual void setCurrentIndex(int index)
  {
    if (cb_setCurrentIndex_767_0.can_issue()) {
      cb_setCurrentIndex_767_0.issue<QDataWidgetMapper_Adaptor, int>(&QDataWidgetMapper_Adaptor::cbs_setCurrentIndex_767_0, index);
    } else {
      QDataWidgetMapper::setCurrentIndex(index);
    }
  }

  //  [adaptor impl] void QDataWidgetMapper::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QDataWidgetMapper::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QDataWidgetMapper_Adaptor, QChildEvent *>(&QDataWidgetMapper_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QDataWidgetMapper::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QDataWidgetMapper::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QDataWidgetMapper::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QDataWidgetMapper_Adaptor, QEvent *>(&QDataWidgetMapper_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QDataWidgetMapper::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QDataWidgetMapper::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QDataWidgetMapper::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QDataWidgetMapper_Adaptor, const char *>(&QDataWidgetMapper_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QDataWidgetMapper::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QDataWidgetMapper::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QDataWidgetMapper::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QDataWidgetMapper_Adaptor, QTimerEvent *>(&QDataWidgetMapper_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QDataWidgetMapper::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_setCurrentIndex_767_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QDataWidgetMapper_Adaptor::~QDataWidgetMapper_Adaptor() { }

//  Constructor QDataWidgetMapper::QDataWidgetMapper(QObject *parent) (adaptor class)

static void _init_ctor_QDataWidgetMapper_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QDataWidgetMapper_Adaptor *> ();
}

static void _call_ctor_QDataWidgetMapper_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QDataWidgetMapper_Adaptor *> (new QDataWidgetMapper_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDataWidgetMapper_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDataWidgetMapper::QDataWidgetMapper(QObject *parent)\nThis method creates an object of class QDataWidgetMapper.", &_init_ctor_QDataWidgetMapper_Adaptor_1302, &_call_ctor_QDataWidgetMapper_Adaptor_1302);
}

// int QDataWidgetMapper::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QDataWidgetMapper_Adaptor *)cls)->fp_QDataWidgetMapper_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QDataWidgetMapper::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QDataWidgetMapper::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QDataWidgetMapper_Adaptor *)cls)->fp_QDataWidgetMapper_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QDataWidgetMapper::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QDataWidgetMapper::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QDataWidgetMapper_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QDataWidgetMapper::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QDataWidgetMapper::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QDataWidgetMapper_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QDataWidgetMapper::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QDataWidgetMapper::setCurrentIndex(int index)

static void _init_cbs_setCurrentIndex_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setCurrentIndex_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QDataWidgetMapper_Adaptor *)cls)->cbs_setCurrentIndex_767_0 (arg1);
}

static void _set_callback_cbs_setCurrentIndex_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_setCurrentIndex_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setCurrentIndex_767_0 ()
{
  return new qt_gsi::GenericMethod ("setCurrentIndex", "@hide", false, &_init_cbs_setCurrentIndex_767_0, &_call_cbs_setCurrentIndex_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setCurrentIndex_767_0 ()
{
  return new qt_gsi::GenericMethod ("setCurrentIndex", "@brief Virtual method void QDataWidgetMapper::setCurrentIndex(int index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setCurrentIndex_767_0, &_call_cbs_setCurrentIndex_767_0, &_set_callback_cbs_setCurrentIndex_767_0);
}


// void QDataWidgetMapper::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QDataWidgetMapper_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QDataWidgetMapper::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QDataWidgetMapper::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QDataWidgetMapper_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QDataWidgetMapper::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QDataWidgetMapper::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QDataWidgetMapper_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QDataWidgetMapper::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QDataWidgetMapper::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QDataWidgetMapper_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QDataWidgetMapper_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QDataWidgetMapper::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QDataWidgetMapper> decl_QDataWidgetMapper;

gsi::Class<QDataWidgetMapper_Adaptor> decl_QDataWidgetMapper_Adaptor (decl_QDataWidgetMapper, "QDataWidgetMapper",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_setCurrentIndex_767_0 ()) +
  gsi::Methods(_create_callback_cbs_setCurrentIndex_767_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QDataWidgetMapper_Adaptor_1302 ()),
  "@qt\n@brief Binding of QDataWidgetMapper");

}


//  Implementation of the enum wrapper class for QDataWidgetMapper::SubmitPolicy
namespace qt_gsi
{

static QDataWidgetMapper_SubmitPolicy_Enum *c_1_QDataWidgetMapper_SubmitPolicy_Enum () { return new QDataWidgetMapper_SubmitPolicy_Enum (QDataWidgetMapper::AutoSubmit); }
static QDataWidgetMapper_SubmitPolicy_Enum *c_2_QDataWidgetMapper_SubmitPolicy_Enum () { return new QDataWidgetMapper_SubmitPolicy_Enum (QDataWidgetMapper::ManualSubmit); }

static gsi::Methods mkdefs_QDataWidgetMapper_SubmitPolicy () {
  return
    gsi::constant ("AutoSubmit", &qt_gsi::c_1_QDataWidgetMapper_SubmitPolicy_Enum, "@brief Enum constant QDataWidgetMapper::AutoSubmit") +
    gsi::constant ("ManualSubmit", &qt_gsi::c_2_QDataWidgetMapper_SubmitPolicy_Enum, "@brief Enum constant QDataWidgetMapper::ManualSubmit");
}

static std::string to_s_QDataWidgetMapper_SubmitPolicy_Enum (const QDataWidgetMapper_SubmitPolicy_Enum *e)
{
  if (e->value () == QDataWidgetMapper::AutoSubmit) { return tl::sprintf ("AutoSubmit (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDataWidgetMapper::ManualSubmit) { return tl::sprintf ("ManualSubmit (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDataWidgetMapper_SubmitPolicy_Enum (const QDataWidgetMapper_SubmitPolicy_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDataWidgetMapper_SubmitPolicy_Enum *from_i_QDataWidgetMapper_SubmitPolicy_Enum (unsigned int i)
{
  return new QDataWidgetMapper_SubmitPolicy_Enum ((QDataWidgetMapper::SubmitPolicy) i);
}

static bool equalQDataWidgetMapper_SubmitPolicy_Enum (const QDataWidgetMapper_SubmitPolicy_Enum *e, QDataWidgetMapper_SubmitPolicy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDataWidgetMapper_SubmitPolicy_Enum (const QDataWidgetMapper_SubmitPolicy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDataWidgetMapper_SubmitPolicy_Enums oropQDataWidgetMapper_SubmitPolicy_Enums (const QDataWidgetMapper_SubmitPolicy_Enums *e, const QDataWidgetMapper_SubmitPolicy_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDataWidgetMapper_SubmitPolicy_Enums andopQDataWidgetMapper_SubmitPolicy_Enums (const QDataWidgetMapper_SubmitPolicy_Enums *e, const QDataWidgetMapper_SubmitPolicy_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDataWidgetMapper_SubmitPolicy_Enums xoropQDataWidgetMapper_SubmitPolicy_Enums (const QDataWidgetMapper_SubmitPolicy_Enums *e, const QDataWidgetMapper_SubmitPolicy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDataWidgetMapper_SubmitPolicy_Enums (const QDataWidgetMapper_SubmitPolicy_Enums *e)
{
  std::string l;
  if (e->testFlag (QDataWidgetMapper::AutoSubmit)) { if (!l.empty ()) l += "|"; l += "AutoSubmit"; }
  if (e->testFlag (QDataWidgetMapper::ManualSubmit)) { if (!l.empty ()) l += "|"; l += "ManualSubmit"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDataWidgetMapper_SubmitPolicy_Enums (const QDataWidgetMapper_SubmitPolicy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDataWidgetMapper_SubmitPolicy_Enums (const QDataWidgetMapper_SubmitPolicy_Enums *e, const QDataWidgetMapper_SubmitPolicy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDataWidgetMapper_SubmitPolicy_Enums> decl_QDataWidgetMapper_SubmitPolicy_Enums ("QDataWidgetMapper_QFlags_SubmitPolicy",
  gsi::method_ext ("|", &qt_gsi::oropQDataWidgetMapper_SubmitPolicy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDataWidgetMapper_SubmitPolicy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDataWidgetMapper_SubmitPolicy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDataWidgetMapper_SubmitPolicy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDataWidgetMapper_SubmitPolicy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDataWidgetMapper_SubmitPolicy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDataWidgetMapper::SubmitPolicy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDataWidgetMapper_SubmitPolicy_Enum> decl_QDataWidgetMapper_SubmitPolicy_Enum (decl_QDataWidgetMapper_SubmitPolicy_Enums, "QDataWidgetMapper_SubmitPolicy",
  qt_gsi::mkdefs_QDataWidgetMapper_SubmitPolicy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDataWidgetMapper_SubmitPolicy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDataWidgetMapper_SubmitPolicy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDataWidgetMapper_SubmitPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDataWidgetMapper_SubmitPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDataWidgetMapper_SubmitPolicy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDataWidgetMapper::SubmitPolicy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDataWidgetMapper> inject_QDataWidgetMapper_SubmitPolicy_Enum_in_parent (qt_gsi::mkdefs_QDataWidgetMapper_SubmitPolicy ());
static gsi::ClassExt<QDataWidgetMapper> decl_QDataWidgetMapper_SubmitPolicy_Enum_as_child (decl_QDataWidgetMapper_SubmitPolicy_Enum, "SubmitPolicy");

}

