
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQBuffer.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQBuffer_EventAdaptor.h"
#include "gsiDeclQBuffer_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QBuffer

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QBuffer::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

//  Constructor QBuffer::QBuffer(QObject *parent)


static void _init_ctor_QBuffer_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QBuffer *> ();
}

static void _call_ctor_QBuffer_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QBuffer *> (new QBuffer (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QBuffer_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QBuffer::QBuffer(QObject *parent)\nThis method creates an object of class QBuffer.", &_init_ctor_QBuffer_1302, &_call_ctor_QBuffer_1302);
}

//  Constructor QBuffer::QBuffer(QByteArray *buf, QObject *parent)


static void _init_ctor_QBuffer_2812 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buf");
  decl->add_arg<QByteArray * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QBuffer *> ();
}

static void _call_ctor_QBuffer_2812 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QByteArray *arg1 = args.read<QByteArray * > ();
  QObject *arg2 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QBuffer *> (new QBuffer (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QBuffer_2812 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QBuffer::QBuffer(QByteArray *buf, QObject *parent)\nThis method creates an object of class QBuffer.", &_init_ctor_QBuffer_2812, &_call_ctor_QBuffer_2812);
}

// bool QBuffer::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QBuffer *)cls)->atEnd ());
}

static qt_gsi::GenericMethod *_create_f_atEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QBuffer::atEnd()\nThis is a reimplementation of QIODevice::atEnd", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
}

// QByteArray &QBuffer::buffer()


static void _init_f_buffer_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray & > ();
}

static void _call_f_buffer_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray & > ((QByteArray &)((QBuffer *)cls)->buffer ());
}

static qt_gsi::GenericMethod *_create_f_buffer_0 ()
{
  return new qt_gsi::GenericMethod ("buffer", "@brief Method QByteArray &QBuffer::buffer()\n", false, &_init_f_buffer_0, &_call_f_buffer_0);
}

// const QByteArray &QBuffer::buffer()


static void _init_f_buffer_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QByteArray & > ();
}

static void _call_f_buffer_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QByteArray & > ((const QByteArray &)((QBuffer *)cls)->buffer ());
}

static qt_gsi::GenericMethod *_create_f_buffer_c0 ()
{
  return new qt_gsi::GenericMethod ("buffer", "@brief Method const QByteArray &QBuffer::buffer()\n", true, &_init_f_buffer_c0, &_call_f_buffer_c0);
}

// bool QBuffer::canReadLine()


static void _init_f_canReadLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canReadLine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QBuffer *)cls)->canReadLine ());
}

static qt_gsi::GenericMethod *_create_f_canReadLine_c0 ()
{
  return new qt_gsi::GenericMethod ("canReadLine", "@brief Method bool QBuffer::canReadLine()\nThis is a reimplementation of QIODevice::canReadLine", true, &_init_f_canReadLine_c0, &_call_f_canReadLine_c0);
}

// void QBuffer::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QBuffer *)cls)->close ();
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method void QBuffer::close()\nThis is a reimplementation of QIODevice::close", false, &_init_f_close_0, &_call_f_close_0);
}

// const QByteArray &QBuffer::data()


static void _init_f_data_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QByteArray & > ();
}

static void _call_f_data_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QByteArray & > ((const QByteArray &)((QBuffer *)cls)->data ());
}

static qt_gsi::GenericMethod *_create_f_data_c0 ()
{
  return new qt_gsi::GenericMethod (":data", "@brief Method const QByteArray &QBuffer::data()\n", true, &_init_f_data_c0, &_call_f_data_c0);
}

// bool QBuffer::open(QFlags<QIODevice::OpenModeFlag> openMode)


static void _init_f_open_3242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("openMode");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_open_3242 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > ();
  ret.write<bool > ((bool)((QBuffer *)cls)->open (qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_open_3242 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method bool QBuffer::open(QFlags<QIODevice::OpenModeFlag> openMode)\nThis is a reimplementation of QIODevice::open", false, &_init_f_open_3242, &_call_f_open_3242);
}

// qint64 QBuffer::pos()


static void _init_f_pos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_pos_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QBuffer *)cls)->pos ());
}

static qt_gsi::GenericMethod *_create_f_pos_c0 ()
{
  return new qt_gsi::GenericMethod ("pos", "@brief Method qint64 QBuffer::pos()\nThis is a reimplementation of QIODevice::pos", true, &_init_f_pos_c0, &_call_f_pos_c0);
}

// bool QBuffer::seek(qint64 off)


static void _init_f_seek_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("off");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_seek_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ret.write<bool > ((bool)((QBuffer *)cls)->seek (arg1));
}

static qt_gsi::GenericMethod *_create_f_seek_986 ()
{
  return new qt_gsi::GenericMethod ("seek", "@brief Method bool QBuffer::seek(qint64 off)\nThis is a reimplementation of QIODevice::seek", false, &_init_f_seek_986, &_call_f_seek_986);
}

// void QBuffer::setBuffer(QByteArray *a)


static void _init_f_setBuffer_1618 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<QByteArray * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBuffer_1618 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QByteArray *arg1 = args.read<QByteArray * > ();
  ((QBuffer *)cls)->setBuffer (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBuffer_1618 ()
{
  return new qt_gsi::GenericMethod ("setBuffer", "@brief Method void QBuffer::setBuffer(QByteArray *a)\n", false, &_init_f_setBuffer_1618, &_call_f_setBuffer_1618);
}

// void QBuffer::setData(const QByteArray &data)


static void _init_f_setData_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setData_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QBuffer *)cls)->setData (arg1);
}

static qt_gsi::GenericMethod *_create_f_setData_2309 ()
{
  return new qt_gsi::GenericMethod ("setData|data=", "@brief Method void QBuffer::setData(const QByteArray &data)\n", false, &_init_f_setData_2309, &_call_f_setData_2309);
}

// void QBuffer::setData(const char *data, int len)


static void _init_f_setData_2390 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setData_2390 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  int arg2 = args.read<int > ();
  ((QBuffer *)cls)->setData (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setData_2390 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Method void QBuffer::setData(const char *data, int len)\n", false, &_init_f_setData_2390, &_call_f_setData_2390);
}

// qint64 QBuffer::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QBuffer *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod ("size", "@brief Method qint64 QBuffer::size()\nThis is a reimplementation of QIODevice::size", true, &_init_f_size_c0, &_call_f_size_c0);
}

// static QString QBuffer::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QBuffer::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QBuffer::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QBuffer::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QBuffer::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QBuffer::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QBuffer::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QBuffer::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QBuffer::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QBuffer::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QBuffer::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QBuffer::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QBuffer, QBuffer_EventAdaptor> ea_QBuffer;


namespace gsi
{
extern gsi::Class<QIODevice> decl_QIODevice;

gsi::Class<QBuffer> decl_QBuffer (ea_QBuffer, decl_QIODevice, "QBuffer",
  gsi::Methods(_create_ctor_QBuffer_1302 ()) +
  gsi::Methods(_create_ctor_QBuffer_2812 ()) +
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_atEnd_c0 ()) +
  gsi::Methods(_create_f_buffer_0 ()) +
  gsi::Methods(_create_f_buffer_c0 ()) +
  gsi::Methods(_create_f_canReadLine_c0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_data_c0 ()) +
  gsi::Methods(_create_f_open_3242 ()) +
  gsi::Methods(_create_f_pos_c0 ()) +
  gsi::Methods(_create_f_seek_986 ()) +
  gsi::Methods(_create_f_setBuffer_1618 ()) +
  gsi::Methods(_create_f_setData_2309 ()) +
  gsi::Methods(_create_f_setData_2390 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  qt_gsi::qt_signal<QBuffer, QBuffer_EventAdaptor> ("aboutToClose", &QBuffer_EventAdaptor::aboutToClose_e_0, "@brief Signal declaration for QBuffer::aboutToClose()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QBuffer, QBuffer_EventAdaptor, qint64> ("bytesWritten", &QBuffer_EventAdaptor::bytesWritten_e_986, gsi::arg("bytes"), "@brief Signal declaration for QBuffer::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QBuffer, QBuffer_EventAdaptor, QObject *> ("destroyed", &QBuffer_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QBuffer::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QBuffer, QBuffer_EventAdaptor> ("readChannelFinished", &QBuffer_EventAdaptor::readChannelFinished_e_0, "@brief Signal declaration for QBuffer::readChannelFinished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QBuffer, QBuffer_EventAdaptor> ("readyRead", &QBuffer_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QBuffer::readyRead()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QBuffer");

}

