
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractGraphicsShapeItem.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQAbstractGraphicsShapeItem_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractGraphicsShapeItem

// QBrush QAbstractGraphicsShapeItem::brush()


static void _init_f_brush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_brush_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBrush > ((QBrush)((QAbstractGraphicsShapeItem *)cls)->brush ());
}

static qt_gsi::GenericMethod *_create_f_brush_c0 ()
{
  return new qt_gsi::GenericMethod (":brush", "@brief Method QBrush QAbstractGraphicsShapeItem::brush()\n", true, &_init_f_brush_c0, &_call_f_brush_c0);
}

// bool QAbstractGraphicsShapeItem::isObscuredBy(const QGraphicsItem *item)


static void _init_f_isObscuredBy_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isObscuredBy_c2614 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ret.write<bool > ((bool)((QAbstractGraphicsShapeItem *)cls)->isObscuredBy (arg1));
}

static qt_gsi::GenericMethod *_create_f_isObscuredBy_c2614 ()
{
  return new qt_gsi::GenericMethod ("isObscuredBy?", "@brief Method bool QAbstractGraphicsShapeItem::isObscuredBy(const QGraphicsItem *item)\nThis is a reimplementation of QGraphicsItem::isObscuredBy", true, &_init_f_isObscuredBy_c2614, &_call_f_isObscuredBy_c2614);
}

// QPainterPath QAbstractGraphicsShapeItem::opaqueArea()


static void _init_f_opaqueArea_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_opaqueArea_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QAbstractGraphicsShapeItem *)cls)->opaqueArea ());
}

static qt_gsi::GenericMethod *_create_f_opaqueArea_c0 ()
{
  return new qt_gsi::GenericMethod ("opaqueArea", "@brief Method QPainterPath QAbstractGraphicsShapeItem::opaqueArea()\nThis is a reimplementation of QGraphicsItem::opaqueArea", true, &_init_f_opaqueArea_c0, &_call_f_opaqueArea_c0);
}

// QPen QAbstractGraphicsShapeItem::pen()


static void _init_f_pen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPen > ();
}

static void _call_f_pen_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPen > ((QPen)((QAbstractGraphicsShapeItem *)cls)->pen ());
}

static qt_gsi::GenericMethod *_create_f_pen_c0 ()
{
  return new qt_gsi::GenericMethod (":pen", "@brief Method QPen QAbstractGraphicsShapeItem::pen()\n", true, &_init_f_pen_c0, &_call_f_pen_c0);
}

// void QAbstractGraphicsShapeItem::setBrush(const QBrush &brush)


static void _init_f_setBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBrush_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QAbstractGraphicsShapeItem *)cls)->setBrush (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBrush_1910 ()
{
  return new qt_gsi::GenericMethod ("setBrush|brush=", "@brief Method void QAbstractGraphicsShapeItem::setBrush(const QBrush &brush)\n", false, &_init_f_setBrush_1910, &_call_f_setBrush_1910);
}

// void QAbstractGraphicsShapeItem::setPen(const QPen &pen)


static void _init_f_setPen_1685 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pen");
  decl->add_arg<const QPen & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPen_1685 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPen &arg1 = args.read<const QPen & > ();
  ((QAbstractGraphicsShapeItem *)cls)->setPen (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPen_1685 ()
{
  return new qt_gsi::GenericMethod ("setPen|pen=", "@brief Method void QAbstractGraphicsShapeItem::setPen(const QPen &pen)\n", false, &_init_f_setPen_1685, &_call_f_setPen_1685);
}

namespace gsi
{
extern gsi::Class<QGraphicsItem> decl_QGraphicsItem;

gsi::Class<QAbstractGraphicsShapeItem> decl_QAbstractGraphicsShapeItem (decl_QGraphicsItem, "QAbstractGraphicsShapeItem_Native",
  gsi::Methods(_create_f_brush_c0 ()) +
  gsi::Methods(_create_f_isObscuredBy_c2614 ()) +
  gsi::Methods(_create_f_opaqueArea_c0 ()) +
  gsi::Methods(_create_f_pen_c0 ()) +
  gsi::Methods(_create_f_setBrush_1910 ()) +
  gsi::Methods(_create_f_setPen_1685 ()),
  "@hide\n@alias QAbstractGraphicsShapeItem");
}


class QAbstractGraphicsShapeItem_Adaptor : public QAbstractGraphicsShapeItem, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractGraphicsShapeItem_Adaptor();

  //  [adaptor ctor] QAbstractGraphicsShapeItem::QAbstractGraphicsShapeItem(QGraphicsItem *parent, QGraphicsScene *scene)
  QAbstractGraphicsShapeItem_Adaptor() : QAbstractGraphicsShapeItem()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractGraphicsShapeItem::QAbstractGraphicsShapeItem(QGraphicsItem *parent, QGraphicsScene *scene)
  QAbstractGraphicsShapeItem_Adaptor(QGraphicsItem *parent) : QAbstractGraphicsShapeItem(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractGraphicsShapeItem::QAbstractGraphicsShapeItem(QGraphicsItem *parent, QGraphicsScene *scene)
  QAbstractGraphicsShapeItem_Adaptor(QGraphicsItem *parent, QGraphicsScene *scene) : QAbstractGraphicsShapeItem(parent, scene)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QAbstractGraphicsShapeItem::addToIndex()
  void fp_QAbstractGraphicsShapeItem_addToIndex_0 () {
    QAbstractGraphicsShapeItem::addToIndex();
  }

  //  void QAbstractGraphicsShapeItem::prepareGeometryChange()
  void fp_QAbstractGraphicsShapeItem_prepareGeometryChange_0 () {
    QAbstractGraphicsShapeItem::prepareGeometryChange();
  }

  //  void QAbstractGraphicsShapeItem::removeFromIndex()
  void fp_QAbstractGraphicsShapeItem_removeFromIndex_0 () {
    QAbstractGraphicsShapeItem::removeFromIndex();
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::advance(int phase)
  void cbs_advance_767_0(int phase)
  {
    QAbstractGraphicsShapeItem::advance(phase);
  }

  virtual void advance(int phase)
  {
    if (cb_advance_767_0.can_issue()) {
      cb_advance_767_0.issue<QAbstractGraphicsShapeItem_Adaptor, int>(&QAbstractGraphicsShapeItem_Adaptor::cbs_advance_767_0, phase);
    } else {
      QAbstractGraphicsShapeItem::advance(phase);
    }
  }

  //  [adaptor impl] QRectF QAbstractGraphicsShapeItem::boundingRect()
  QRectF cbs_boundingRect_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("boundingRect");
  }

  virtual QRectF boundingRect() const
  {
    if (cb_boundingRect_c0_0.can_issue()) {
      return cb_boundingRect_c0_0.issue<QAbstractGraphicsShapeItem_Adaptor, QRectF>(&QAbstractGraphicsShapeItem_Adaptor::cbs_boundingRect_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("boundingRect");
    }
  }

  //  [adaptor impl] bool QAbstractGraphicsShapeItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithItem_c4977_1(const QGraphicsItem *other, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QAbstractGraphicsShapeItem::collidesWithItem(other, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithItem_c4977_1.can_issue()) {
      return cb_collidesWithItem_c4977_1.issue<QAbstractGraphicsShapeItem_Adaptor, bool, const QGraphicsItem *, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QAbstractGraphicsShapeItem_Adaptor::cbs_collidesWithItem_c4977_1, other, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QAbstractGraphicsShapeItem::collidesWithItem(other, mode);
    }
  }

  //  [adaptor impl] bool QAbstractGraphicsShapeItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithPath_c4877_1(const QPainterPath &path, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QAbstractGraphicsShapeItem::collidesWithPath(path, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithPath_c4877_1.can_issue()) {
      return cb_collidesWithPath_c4877_1.issue<QAbstractGraphicsShapeItem_Adaptor, bool, const QPainterPath &, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QAbstractGraphicsShapeItem_Adaptor::cbs_collidesWithPath_c4877_1, path, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QAbstractGraphicsShapeItem::collidesWithPath(path, mode);
    }
  }

  //  [adaptor impl] bool QAbstractGraphicsShapeItem::contains(const QPointF &point)
  bool cbs_contains_c1986_0(const QPointF &point) const
  {
    return QAbstractGraphicsShapeItem::contains(point);
  }

  virtual bool contains(const QPointF &point) const
  {
    if (cb_contains_c1986_0.can_issue()) {
      return cb_contains_c1986_0.issue<QAbstractGraphicsShapeItem_Adaptor, bool, const QPointF &>(&QAbstractGraphicsShapeItem_Adaptor::cbs_contains_c1986_0, point);
    } else {
      return QAbstractGraphicsShapeItem::contains(point);
    }
  }

  //  [adaptor impl] bool QAbstractGraphicsShapeItem::isObscuredBy(const QGraphicsItem *item)
  bool cbs_isObscuredBy_c2614_0(const QGraphicsItem *item) const
  {
    return QAbstractGraphicsShapeItem::isObscuredBy(item);
  }

  virtual bool isObscuredBy(const QGraphicsItem *item) const
  {
    if (cb_isObscuredBy_c2614_0.can_issue()) {
      return cb_isObscuredBy_c2614_0.issue<QAbstractGraphicsShapeItem_Adaptor, bool, const QGraphicsItem *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_isObscuredBy_c2614_0, item);
    } else {
      return QAbstractGraphicsShapeItem::isObscuredBy(item);
    }
  }

  //  [adaptor impl] QPainterPath QAbstractGraphicsShapeItem::opaqueArea()
  QPainterPath cbs_opaqueArea_c0_0() const
  {
    return QAbstractGraphicsShapeItem::opaqueArea();
  }

  virtual QPainterPath opaqueArea() const
  {
    if (cb_opaqueArea_c0_0.can_issue()) {
      return cb_opaqueArea_c0_0.issue<QAbstractGraphicsShapeItem_Adaptor, QPainterPath>(&QAbstractGraphicsShapeItem_Adaptor::cbs_opaqueArea_c0_0);
    } else {
      return QAbstractGraphicsShapeItem::opaqueArea();
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paint_6301_1(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    throw qt_gsi::AbstractMethodCalledException("paint");
  }

  virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paint_6301_1.can_issue()) {
      cb_paint_6301_1.issue<QAbstractGraphicsShapeItem_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_paint_6301_1, painter, option, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("paint");
    }
  }

  //  [adaptor impl] QPainterPath QAbstractGraphicsShapeItem::shape()
  QPainterPath cbs_shape_c0_0() const
  {
    return QAbstractGraphicsShapeItem::shape();
  }

  virtual QPainterPath shape() const
  {
    if (cb_shape_c0_0.can_issue()) {
      return cb_shape_c0_0.issue<QAbstractGraphicsShapeItem_Adaptor, QPainterPath>(&QAbstractGraphicsShapeItem_Adaptor::cbs_shape_c0_0);
    } else {
      return QAbstractGraphicsShapeItem::shape();
    }
  }

  //  [adaptor impl] int QAbstractGraphicsShapeItem::type()
  int cbs_type_c0_0() const
  {
    return QAbstractGraphicsShapeItem::type();
  }

  virtual int type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return cb_type_c0_0.issue<QAbstractGraphicsShapeItem_Adaptor, int>(&QAbstractGraphicsShapeItem_Adaptor::cbs_type_c0_0);
    } else {
      return QAbstractGraphicsShapeItem::type();
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  void cbs_contextMenuEvent_3674_0(QGraphicsSceneContextMenuEvent *event)
  {
    QAbstractGraphicsShapeItem::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_3674_0.can_issue()) {
      cb_contextMenuEvent_3674_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneContextMenuEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_contextMenuEvent_3674_0, event);
    } else {
      QAbstractGraphicsShapeItem::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragEnterEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QAbstractGraphicsShapeItem::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragEnterEvent_3315_0.can_issue()) {
      cb_dragEnterEvent_3315_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_dragEnterEvent_3315_0, event);
    } else {
      QAbstractGraphicsShapeItem::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragLeaveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QAbstractGraphicsShapeItem::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragLeaveEvent_3315_0.can_issue()) {
      cb_dragLeaveEvent_3315_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_dragLeaveEvent_3315_0, event);
    } else {
      QAbstractGraphicsShapeItem::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragMoveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QAbstractGraphicsShapeItem::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragMoveEvent_3315_0.can_issue()) {
      cb_dragMoveEvent_3315_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_dragMoveEvent_3315_0, event);
    } else {
      QAbstractGraphicsShapeItem::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::dropEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dropEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QAbstractGraphicsShapeItem::dropEvent(event);
  }

  virtual void dropEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dropEvent_3315_0.can_issue()) {
      cb_dropEvent_3315_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_dropEvent_3315_0, event);
    } else {
      QAbstractGraphicsShapeItem::dropEvent(event);
    }
  }

  //  [adaptor impl] QVariant QAbstractGraphicsShapeItem::extension(const QVariant &variant)
  QVariant cbs_extension_c2119_0(const QVariant &variant) const
  {
    return QAbstractGraphicsShapeItem::extension(variant);
  }

  virtual QVariant extension(const QVariant &variant) const
  {
    if (cb_extension_c2119_0.can_issue()) {
      return cb_extension_c2119_0.issue<QAbstractGraphicsShapeItem_Adaptor, QVariant, const QVariant &>(&QAbstractGraphicsShapeItem_Adaptor::cbs_extension_c2119_0, variant);
    } else {
      return QAbstractGraphicsShapeItem::extension(variant);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QAbstractGraphicsShapeItem::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QAbstractGraphicsShapeItem_Adaptor, QFocusEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QAbstractGraphicsShapeItem::focusInEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QAbstractGraphicsShapeItem::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QAbstractGraphicsShapeItem_Adaptor, QFocusEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QAbstractGraphicsShapeItem::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverEnterEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QAbstractGraphicsShapeItem::hoverEnterEvent(event);
  }

  virtual void hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverEnterEvent_3044_0.can_issue()) {
      cb_hoverEnterEvent_3044_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneHoverEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_hoverEnterEvent_3044_0, event);
    } else {
      QAbstractGraphicsShapeItem::hoverEnterEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverLeaveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QAbstractGraphicsShapeItem::hoverLeaveEvent(event);
  }

  virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverLeaveEvent_3044_0.can_issue()) {
      cb_hoverLeaveEvent_3044_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneHoverEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_hoverLeaveEvent_3044_0, event);
    } else {
      QAbstractGraphicsShapeItem::hoverLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverMoveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QAbstractGraphicsShapeItem::hoverMoveEvent(event);
  }

  virtual void hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverMoveEvent_3044_0.can_issue()) {
      cb_hoverMoveEvent_3044_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneHoverEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_hoverMoveEvent_3044_0, event);
    } else {
      QAbstractGraphicsShapeItem::hoverMoveEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QAbstractGraphicsShapeItem::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QAbstractGraphicsShapeItem_Adaptor, QInputMethodEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QAbstractGraphicsShapeItem::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] QVariant QAbstractGraphicsShapeItem::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QAbstractGraphicsShapeItem::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QAbstractGraphicsShapeItem_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QAbstractGraphicsShapeItem_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QAbstractGraphicsShapeItem::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QVariant QAbstractGraphicsShapeItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  QVariant cbs_itemChange_5658_0(const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & change, const QVariant &value)
  {
    return QAbstractGraphicsShapeItem::itemChange(qt_gsi::QtToCppAdaptor<QGraphicsItem::GraphicsItemChange>(change).cref(), value);
  }

  virtual QVariant itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  {
    if (cb_itemChange_5658_0.can_issue()) {
      return cb_itemChange_5658_0.issue<QAbstractGraphicsShapeItem_Adaptor, QVariant, const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type &, const QVariant &>(&QAbstractGraphicsShapeItem_Adaptor::cbs_itemChange_5658_0, qt_gsi::CppToQtAdaptor<QGraphicsItem::GraphicsItemChange>(change), value);
    } else {
      return QAbstractGraphicsShapeItem::itemChange(change, value);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QAbstractGraphicsShapeItem::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QAbstractGraphicsShapeItem_Adaptor, QKeyEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QAbstractGraphicsShapeItem::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QAbstractGraphicsShapeItem::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QAbstractGraphicsShapeItem_Adaptor, QKeyEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QAbstractGraphicsShapeItem::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseDoubleClickEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QAbstractGraphicsShapeItem::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_3049_0.can_issue()) {
      cb_mouseDoubleClickEvent_3049_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneMouseEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_mouseDoubleClickEvent_3049_0, event);
    } else {
      QAbstractGraphicsShapeItem::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseMoveEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QAbstractGraphicsShapeItem::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseMoveEvent_3049_0.can_issue()) {
      cb_mouseMoveEvent_3049_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneMouseEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_mouseMoveEvent_3049_0, event);
    } else {
      QAbstractGraphicsShapeItem::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::mousePressEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mousePressEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QAbstractGraphicsShapeItem::mousePressEvent(event);
  }

  virtual void mousePressEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mousePressEvent_3049_0.can_issue()) {
      cb_mousePressEvent_3049_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneMouseEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_mousePressEvent_3049_0, event);
    } else {
      QAbstractGraphicsShapeItem::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseReleaseEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QAbstractGraphicsShapeItem::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_3049_0.can_issue()) {
      cb_mouseReleaseEvent_3049_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneMouseEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_mouseReleaseEvent_3049_0, event);
    } else {
      QAbstractGraphicsShapeItem::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] bool QAbstractGraphicsShapeItem::sceneEvent(QEvent *event)
  bool cbs_sceneEvent_1217_0(QEvent *event)
  {
    return QAbstractGraphicsShapeItem::sceneEvent(event);
  }

  virtual bool sceneEvent(QEvent *event)
  {
    if (cb_sceneEvent_1217_0.can_issue()) {
      return cb_sceneEvent_1217_0.issue<QAbstractGraphicsShapeItem_Adaptor, bool, QEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_sceneEvent_1217_0, event);
    } else {
      return QAbstractGraphicsShapeItem::sceneEvent(event);
    }
  }

  //  [adaptor impl] bool QAbstractGraphicsShapeItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  bool cbs_sceneEventFilter_3028_0(QGraphicsItem *watched, QEvent *event)
  {
    return QAbstractGraphicsShapeItem::sceneEventFilter(watched, event);
  }

  virtual bool sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  {
    if (cb_sceneEventFilter_3028_0.can_issue()) {
      return cb_sceneEventFilter_3028_0.issue<QAbstractGraphicsShapeItem_Adaptor, bool, QGraphicsItem *, QEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_sceneEventFilter_3028_0, watched, event);
    } else {
      return QAbstractGraphicsShapeItem::sceneEventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  void cbs_setExtension_4817_0(unsigned int extension, const QVariant &variant)
  {
    QAbstractGraphicsShapeItem::setExtension(QGraphicsItem::Extension(extension), variant);
  }

  virtual void setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  {
    if (cb_setExtension_4817_0.can_issue()) {
      cb_setExtension_4817_0.issue<QAbstractGraphicsShapeItem_Adaptor, unsigned int, const QVariant &>(&QAbstractGraphicsShapeItem_Adaptor::cbs_setExtension_4817_0, (unsigned int)(extension), variant);
    } else {
      QAbstractGraphicsShapeItem::setExtension(extension, variant);
    }
  }

  //  [adaptor impl] bool QAbstractGraphicsShapeItem::supportsExtension(QGraphicsItem::Extension extension)
  bool cbs_supportsExtension_c2806_0(unsigned int extension) const
  {
    return QAbstractGraphicsShapeItem::supportsExtension(QGraphicsItem::Extension(extension));
  }

  virtual bool supportsExtension(QGraphicsItem::Extension extension) const
  {
    if (cb_supportsExtension_c2806_0.can_issue()) {
      return cb_supportsExtension_c2806_0.issue<QAbstractGraphicsShapeItem_Adaptor, bool, unsigned int>(&QAbstractGraphicsShapeItem_Adaptor::cbs_supportsExtension_c2806_0, (unsigned int)(extension));
    } else {
      return QAbstractGraphicsShapeItem::supportsExtension(extension);
    }
  }

  //  [adaptor impl] void QAbstractGraphicsShapeItem::wheelEvent(QGraphicsSceneWheelEvent *event)
  void cbs_wheelEvent_3029_0(QGraphicsSceneWheelEvent *event)
  {
    QAbstractGraphicsShapeItem::wheelEvent(event);
  }

  virtual void wheelEvent(QGraphicsSceneWheelEvent *event)
  {
    if (cb_wheelEvent_3029_0.can_issue()) {
      cb_wheelEvent_3029_0.issue<QAbstractGraphicsShapeItem_Adaptor, QGraphicsSceneWheelEvent *>(&QAbstractGraphicsShapeItem_Adaptor::cbs_wheelEvent_3029_0, event);
    } else {
      QAbstractGraphicsShapeItem::wheelEvent(event);
    }
  }

  gsi::Callback cb_advance_767_0;
  gsi::Callback cb_boundingRect_c0_0;
  gsi::Callback cb_collidesWithItem_c4977_1;
  gsi::Callback cb_collidesWithPath_c4877_1;
  gsi::Callback cb_contains_c1986_0;
  gsi::Callback cb_isObscuredBy_c2614_0;
  gsi::Callback cb_opaqueArea_c0_0;
  gsi::Callback cb_paint_6301_1;
  gsi::Callback cb_shape_c0_0;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_contextMenuEvent_3674_0;
  gsi::Callback cb_dragEnterEvent_3315_0;
  gsi::Callback cb_dragLeaveEvent_3315_0;
  gsi::Callback cb_dragMoveEvent_3315_0;
  gsi::Callback cb_dropEvent_3315_0;
  gsi::Callback cb_extension_c2119_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hoverEnterEvent_3044_0;
  gsi::Callback cb_hoverLeaveEvent_3044_0;
  gsi::Callback cb_hoverMoveEvent_3044_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_itemChange_5658_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_3049_0;
  gsi::Callback cb_mouseMoveEvent_3049_0;
  gsi::Callback cb_mousePressEvent_3049_0;
  gsi::Callback cb_mouseReleaseEvent_3049_0;
  gsi::Callback cb_sceneEvent_1217_0;
  gsi::Callback cb_sceneEventFilter_3028_0;
  gsi::Callback cb_setExtension_4817_0;
  gsi::Callback cb_supportsExtension_c2806_0;
  gsi::Callback cb_wheelEvent_3029_0;
};

QAbstractGraphicsShapeItem_Adaptor::~QAbstractGraphicsShapeItem_Adaptor() { }

//  Constructor QAbstractGraphicsShapeItem::QAbstractGraphicsShapeItem(QGraphicsItem *parent, QGraphicsScene *scene) (adaptor class)

static void _init_ctor_QAbstractGraphicsShapeItem_Adaptor_3825 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("scene", true, "0");
  decl->add_arg<QGraphicsScene * > (argspec_1);
  decl->set_return_new<QAbstractGraphicsShapeItem_Adaptor *> ();
}

static void _call_ctor_QAbstractGraphicsShapeItem_Adaptor_3825 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args ? args.read<QGraphicsItem * > () : (QGraphicsItem *)(0);
  QGraphicsScene *arg2 = args ? args.read<QGraphicsScene * > () : (QGraphicsScene *)(0);
  ret.write<QAbstractGraphicsShapeItem_Adaptor *> (new QAbstractGraphicsShapeItem_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAbstractGraphicsShapeItem_Adaptor_3825 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractGraphicsShapeItem::QAbstractGraphicsShapeItem(QGraphicsItem *parent, QGraphicsScene *scene)\nThis method creates an object of class QAbstractGraphicsShapeItem.", &_init_ctor_QAbstractGraphicsShapeItem_Adaptor_3825, &_call_ctor_QAbstractGraphicsShapeItem_Adaptor_3825);
}

// void QAbstractGraphicsShapeItem::addToIndex()

static void _init_fp_addToIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_addToIndex_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->fp_QAbstractGraphicsShapeItem_addToIndex_0 ();
}

static qt_gsi::GenericMethod*_create_fp_addToIndex_0 ()
{
  return new qt_gsi::GenericMethod("*addToIndex", "@brief Method void QAbstractGraphicsShapeItem::addToIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addToIndex_0, &_call_fp_addToIndex_0);
}


// void QAbstractGraphicsShapeItem::prepareGeometryChange()

static void _init_fp_prepareGeometryChange_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_prepareGeometryChange_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->fp_QAbstractGraphicsShapeItem_prepareGeometryChange_0 ();
}

static qt_gsi::GenericMethod*_create_fp_prepareGeometryChange_0 ()
{
  return new qt_gsi::GenericMethod("*prepareGeometryChange", "@brief Method void QAbstractGraphicsShapeItem::prepareGeometryChange()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_prepareGeometryChange_0, &_call_fp_prepareGeometryChange_0);
}


// void QAbstractGraphicsShapeItem::removeFromIndex()

static void _init_fp_removeFromIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_removeFromIndex_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->fp_QAbstractGraphicsShapeItem_removeFromIndex_0 ();
}

static qt_gsi::GenericMethod*_create_fp_removeFromIndex_0 ()
{
  return new qt_gsi::GenericMethod("*removeFromIndex", "@brief Method void QAbstractGraphicsShapeItem::removeFromIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removeFromIndex_0, &_call_fp_removeFromIndex_0);
}


// void QAbstractGraphicsShapeItem::advance(int phase)

static void _init_cbs_advance_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("phase");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_advance_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_advance_767_0 (arg1);
}

static void _set_callback_cbs_advance_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_advance_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_advance_767_0 ()
{
  return new qt_gsi::GenericMethod ("advance", "@hide", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_advance_767_0 ()
{
  return new qt_gsi::GenericMethod ("advance", "@brief Virtual method void QAbstractGraphicsShapeItem::advance(int phase)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0, &_set_callback_cbs_advance_767_0);
}


// QRectF QAbstractGraphicsShapeItem::boundingRect()

static void _init_cbs_boundingRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRect_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_boundingRect_c0_0 ());
}

static void _set_callback_cbs_boundingRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_boundingRect_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_boundingRect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@hide", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_boundingRect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Virtual method QRectF QAbstractGraphicsShapeItem::boundingRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0, &_set_callback_cbs_boundingRect_c0_0);
}


// bool QAbstractGraphicsShapeItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithItem_c4977_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithItem_c4977_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  ret.write<bool > ((bool)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_collidesWithItem_c4977_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithItem_c4977_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_collidesWithItem_c4977_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_collidesWithItem_c4977_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithItem", "@hide", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_collidesWithItem_c4977_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithItem", "@brief Virtual method bool QAbstractGraphicsShapeItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1, &_set_callback_cbs_collidesWithItem_c4977_1);
}


// bool QAbstractGraphicsShapeItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithPath_c4877_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithPath_c4877_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  ret.write<bool > ((bool)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_collidesWithPath_c4877_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithPath_c4877_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_collidesWithPath_c4877_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_collidesWithPath_c4877_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithPath", "@hide", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_collidesWithPath_c4877_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithPath", "@brief Virtual method bool QAbstractGraphicsShapeItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1, &_set_callback_cbs_collidesWithPath_c4877_1);
}


// bool QAbstractGraphicsShapeItem::contains(const QPointF &point)

static void _init_cbs_contains_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_contains_c1986_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<bool > ((bool)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_contains_c1986_0 (arg1));
}

static void _set_callback_cbs_contains_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_contains_c1986_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contains_c1986_0 ()
{
  return new qt_gsi::GenericMethod ("contains", "@hide", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contains_c1986_0 ()
{
  return new qt_gsi::GenericMethod ("contains", "@brief Virtual method bool QAbstractGraphicsShapeItem::contains(const QPointF &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0, &_set_callback_cbs_contains_c1986_0);
}


// bool QAbstractGraphicsShapeItem::isObscuredBy(const QGraphicsItem *item)

static void _init_cbs_isObscuredBy_c2614_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isObscuredBy_c2614_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ret.write<bool > ((bool)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_isObscuredBy_c2614_0 (arg1));
}

static void _set_callback_cbs_isObscuredBy_c2614_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_isObscuredBy_c2614_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isObscuredBy_c2614_0 ()
{
  return new qt_gsi::GenericMethod ("isObscuredBy", "@hide", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isObscuredBy_c2614_0 ()
{
  return new qt_gsi::GenericMethod ("isObscuredBy", "@brief Virtual method bool QAbstractGraphicsShapeItem::isObscuredBy(const QGraphicsItem *item)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0, &_set_callback_cbs_isObscuredBy_c2614_0);
}


// QPainterPath QAbstractGraphicsShapeItem::opaqueArea()

static void _init_cbs_opaqueArea_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_opaqueArea_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_opaqueArea_c0_0 ());
}

static void _set_callback_cbs_opaqueArea_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_opaqueArea_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_opaqueArea_c0_0 ()
{
  return new qt_gsi::GenericMethod ("opaqueArea", "@hide", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_opaqueArea_c0_0 ()
{
  return new qt_gsi::GenericMethod ("opaqueArea", "@brief Virtual method QPainterPath QAbstractGraphicsShapeItem::opaqueArea()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0, &_set_callback_cbs_opaqueArea_c0_0);
}


// void QAbstractGraphicsShapeItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paint_6301_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_6301_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > ();
  QWidget *arg3 = args.read<QWidget * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_paint_6301_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_6301_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_paint_6301_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paint_6301_1 ()
{
  return new qt_gsi::GenericMethod ("paint", "@hide", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paint_6301_1 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QAbstractGraphicsShapeItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1, &_set_callback_cbs_paint_6301_1);
}


// QPainterPath QAbstractGraphicsShapeItem::shape()

static void _init_cbs_shape_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_shape_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_shape_c0_0 ());
}

static void _set_callback_cbs_shape_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_shape_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_shape_c0_0 ()
{
  return new qt_gsi::GenericMethod ("shape", "@hide", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_shape_c0_0 ()
{
  return new qt_gsi::GenericMethod ("shape", "@brief Virtual method QPainterPath QAbstractGraphicsShapeItem::shape()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0, &_set_callback_cbs_shape_c0_0);
}


// int QAbstractGraphicsShapeItem::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_type_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_type_c0_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_type_c0_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Virtual method int QAbstractGraphicsShapeItem::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
}


// void QAbstractGraphicsShapeItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_3674_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_3674_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneContextMenuEvent *arg1 = args.read<QGraphicsSceneContextMenuEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_contextMenuEvent_3674_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_3674_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_contextMenuEvent_3674_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_3674_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_3674_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0, &_set_callback_cbs_contextMenuEvent_3674_0);
}


// void QAbstractGraphicsShapeItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragEnterEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_dragEnterEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_dragEnterEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0, &_set_callback_cbs_dragEnterEvent_3315_0);
}


// void QAbstractGraphicsShapeItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragLeaveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_dragLeaveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_dragLeaveEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0, &_set_callback_cbs_dragLeaveEvent_3315_0);
}


// void QAbstractGraphicsShapeItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragMoveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_dragMoveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_dragMoveEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0, &_set_callback_cbs_dragMoveEvent_3315_0);
}


// void QAbstractGraphicsShapeItem::dropEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dropEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_dropEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dropEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_dropEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::dropEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0, &_set_callback_cbs_dropEvent_3315_0);
}


// QVariant QAbstractGraphicsShapeItem::extension(const QVariant &variant)

static void _init_cbs_extension_c2119_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("variant");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_extension_c2119_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  ret.write<QVariant > ((QVariant)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_extension_c2119_0 (arg1));
}

static void _set_callback_cbs_extension_c2119_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_extension_c2119_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_extension_c2119_0 ()
{
  return new qt_gsi::GenericMethod ("*extension", "@hide", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_extension_c2119_0 ()
{
  return new qt_gsi::GenericMethod ("*extension", "@brief Virtual method QVariant QAbstractGraphicsShapeItem::extension(const QVariant &variant)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0, &_set_callback_cbs_extension_c2119_0);
}


// void QAbstractGraphicsShapeItem::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// void QAbstractGraphicsShapeItem::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QAbstractGraphicsShapeItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverEnterEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverEnterEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_hoverEnterEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverEnterEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_hoverEnterEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverEnterEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverEnterEvent", "@hide", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverEnterEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverEnterEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0, &_set_callback_cbs_hoverEnterEvent_3044_0);
}


// void QAbstractGraphicsShapeItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverLeaveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverLeaveEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_hoverLeaveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverLeaveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_hoverLeaveEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverLeaveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@hide", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverLeaveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0, &_set_callback_cbs_hoverLeaveEvent_3044_0);
}


// void QAbstractGraphicsShapeItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverMoveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverMoveEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_hoverMoveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverMoveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_hoverMoveEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverMoveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverMoveEvent", "@hide", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverMoveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverMoveEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0, &_set_callback_cbs_hoverMoveEvent_3044_0);
}


// void QAbstractGraphicsShapeItem::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// QVariant QAbstractGraphicsShapeItem::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodQuery", "@brief Virtual method QVariant QAbstractGraphicsShapeItem::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QVariant QAbstractGraphicsShapeItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)

static void _init_cbs_itemChange_5658_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("change");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_itemChange_5658_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ret.write<QVariant > ((QVariant)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_itemChange_5658_0 (arg1, arg2));
}

static void _set_callback_cbs_itemChange_5658_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_itemChange_5658_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemChange_5658_0 ()
{
  return new qt_gsi::GenericMethod ("*itemChange", "@hide", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemChange_5658_0 ()
{
  return new qt_gsi::GenericMethod ("*itemChange", "@brief Virtual method QVariant QAbstractGraphicsShapeItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0, &_set_callback_cbs_itemChange_5658_0);
}


// void QAbstractGraphicsShapeItem::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QAbstractGraphicsShapeItem::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QAbstractGraphicsShapeItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_mouseDoubleClickEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_mouseDoubleClickEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0, &_set_callback_cbs_mouseDoubleClickEvent_3049_0);
}


// void QAbstractGraphicsShapeItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseMoveEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_mouseMoveEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_mouseMoveEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0, &_set_callback_cbs_mouseMoveEvent_3049_0);
}


// void QAbstractGraphicsShapeItem::mousePressEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mousePressEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_mousePressEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_mousePressEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::mousePressEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0, &_set_callback_cbs_mousePressEvent_3049_0);
}


// void QAbstractGraphicsShapeItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_mouseReleaseEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_mouseReleaseEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0, &_set_callback_cbs_mouseReleaseEvent_3049_0);
}


// bool QAbstractGraphicsShapeItem::sceneEvent(QEvent *event)

static void _init_cbs_sceneEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_sceneEvent_1217_0 (arg1));
}

static void _set_callback_cbs_sceneEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_sceneEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sceneEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEvent", "@hide", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sceneEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEvent", "@brief Virtual method bool QAbstractGraphicsShapeItem::sceneEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0, &_set_callback_cbs_sceneEvent_1217_0);
}


// bool QAbstractGraphicsShapeItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)

static void _init_cbs_sceneEventFilter_3028_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEventFilter_3028_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_sceneEventFilter_3028_0 (arg1, arg2));
}

static void _set_callback_cbs_sceneEventFilter_3028_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_sceneEventFilter_3028_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sceneEventFilter_3028_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEventFilter", "@hide", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sceneEventFilter_3028_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEventFilter", "@brief Virtual method bool QAbstractGraphicsShapeItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0, &_set_callback_cbs_sceneEventFilter_3028_0);
}


// void QAbstractGraphicsShapeItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)

static void _init_cbs_setExtension_4817_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("variant");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setExtension_4817_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_setExtension_4817_0 (arg1, arg2);
}

static void _set_callback_cbs_setExtension_4817_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_setExtension_4817_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setExtension_4817_0 ()
{
  return new qt_gsi::GenericMethod ("*setExtension", "@hide", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setExtension_4817_0 ()
{
  return new qt_gsi::GenericMethod ("*setExtension", "@brief Virtual method void QAbstractGraphicsShapeItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0, &_set_callback_cbs_setExtension_4817_0);
}


// bool QAbstractGraphicsShapeItem::supportsExtension(QGraphicsItem::Extension extension)

static void _init_cbs_supportsExtension_c2806_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_supportsExtension_c2806_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ret.write<bool > ((bool)((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_supportsExtension_c2806_0 (arg1));
}

static void _set_callback_cbs_supportsExtension_c2806_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_supportsExtension_c2806_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportsExtension_c2806_0 ()
{
  return new qt_gsi::GenericMethod ("*supportsExtension", "@hide", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportsExtension_c2806_0 ()
{
  return new qt_gsi::GenericMethod ("*supportsExtension", "@brief Virtual method bool QAbstractGraphicsShapeItem::supportsExtension(QGraphicsItem::Extension extension)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0, &_set_callback_cbs_supportsExtension_c2806_0);
}


// void QAbstractGraphicsShapeItem::wheelEvent(QGraphicsSceneWheelEvent *event)

static void _init_cbs_wheelEvent_3029_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_3029_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneWheelEvent *arg1 = args.read<QGraphicsSceneWheelEvent * > ();
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cbs_wheelEvent_3029_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_3029_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractGraphicsShapeItem_Adaptor *)cls)->cb_wheelEvent_3029_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_3029_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_3029_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QAbstractGraphicsShapeItem::wheelEvent(QGraphicsSceneWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0, &_set_callback_cbs_wheelEvent_3029_0);
}


namespace gsi
{

extern gsi::Class<QAbstractGraphicsShapeItem> decl_QAbstractGraphicsShapeItem;

gsi::Class<QAbstractGraphicsShapeItem_Adaptor> decl_QAbstractGraphicsShapeItem_Adaptor (decl_QAbstractGraphicsShapeItem, "QAbstractGraphicsShapeItem",
  gsi::Methods(_create_fp_addToIndex_0 ()) +
  gsi::Methods(_create_fp_prepareGeometryChange_0 ()) +
  gsi::Methods(_create_fp_removeFromIndex_0 ()) +
  gsi::Methods(_create_cbs_advance_767_0 ()) +
  gsi::Methods(_create_callback_cbs_advance_767_0 ()) +
  gsi::Methods(_create_cbs_boundingRect_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_boundingRect_c0_0 ()) +
  gsi::Methods(_create_cbs_collidesWithItem_c4977_1 ()) +
  gsi::Methods(_create_callback_cbs_collidesWithItem_c4977_1 ()) +
  gsi::Methods(_create_cbs_collidesWithPath_c4877_1 ()) +
  gsi::Methods(_create_callback_cbs_collidesWithPath_c4877_1 ()) +
  gsi::Methods(_create_cbs_contains_c1986_0 ()) +
  gsi::Methods(_create_callback_cbs_contains_c1986_0 ()) +
  gsi::Methods(_create_cbs_isObscuredBy_c2614_0 ()) +
  gsi::Methods(_create_callback_cbs_isObscuredBy_c2614_0 ()) +
  gsi::Methods(_create_cbs_opaqueArea_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_opaqueArea_c0_0 ()) +
  gsi::Methods(_create_cbs_paint_6301_1 ()) +
  gsi::Methods(_create_callback_cbs_paint_6301_1 ()) +
  gsi::Methods(_create_cbs_shape_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_shape_c0_0 ()) +
  gsi::Methods(_create_cbs_type_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_type_c0_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_3674_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_3674_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_extension_c2119_0 ()) +
  gsi::Methods(_create_callback_cbs_extension_c2119_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_hoverEnterEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverEnterEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_hoverLeaveEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverLeaveEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_hoverMoveEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverMoveEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_itemChange_5658_0 ()) +
  gsi::Methods(_create_callback_cbs_itemChange_5658_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_sceneEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_sceneEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_sceneEventFilter_3028_0 ()) +
  gsi::Methods(_create_callback_cbs_sceneEventFilter_3028_0 ()) +
  gsi::Methods(_create_cbs_setExtension_4817_0 ()) +
  gsi::Methods(_create_callback_cbs_setExtension_4817_0 ()) +
  gsi::Methods(_create_cbs_supportsExtension_c2806_0 ()) +
  gsi::Methods(_create_callback_cbs_supportsExtension_c2806_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_3029_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_3029_0 ()) +
  gsi::Methods(_create_ctor_QAbstractGraphicsShapeItem_Adaptor_3825 ()),
  "@qt\n@brief Binding of QAbstractGraphicsShapeItem");

}

