/*
 * Copyright @ 2015 Atlassian Pty Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.java.otr4j.session;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.List;

import net.java.otr4j.OtrEngineListener;
import net.java.otr4j.OtrException;
import net.java.otr4j.OtrPolicy;
import net.java.otr4j.io.messages.AbstractMessage;

/**
 * @author George Politis
 */
public interface Session {

	interface OTRv {
		int ONE = 1;

		int TWO = 2;

		int THREE = 3;
	}

	SessionStatus getSessionStatus();

	SessionID getSessionID();

	void injectMessage(AbstractMessage m) throws OtrException;

	KeyPair getLocalKeyPair() throws OtrException;

	OtrPolicy getSessionPolicy();

	String transformReceiving(String content)
			throws OtrException;

	String[] transformSending(String content, List<TLV> tlvs)
			throws OtrException;

	String[] transformSending(String content)
			throws OtrException;

	void startSession() throws OtrException;

	void endSession() throws OtrException;

	void refreshSession() throws OtrException;

	PublicKey getRemotePublicKey();

	void addOtrEngineListener(OtrEngineListener l);

	void removeOtrEngineListener(OtrEngineListener l);

	void initSmp(String question, String secret) throws OtrException;

	void respondSmp(String question, String secret) throws OtrException;

	void abortSmp() throws OtrException;

	boolean isSmpInProgress();

	BigInteger getS();

	// OTRv3 methods
	List<Session> getInstances();

	Session getOutgoingInstance();

	boolean setOutgoingInstance(InstanceTag tag);

	InstanceTag getSenderInstanceTag();

	InstanceTag getReceiverInstanceTag();

	void setReceiverInstanceTag(InstanceTag tag);

	void setProtocolVersion(int protocolVersion);

	int getProtocolVersion();

	void respondSmp(InstanceTag receiverTag, String question, String secret)
			throws OtrException;

	SessionStatus getSessionStatus(InstanceTag tag);

	PublicKey getRemotePublicKey(InstanceTag tag);
}
