/*
 * Jitsi, the OpenSource Java VoIP and Instant Messaging client.
 *
 * Copyright @ 2015 Atlassian Pty Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.java.sip.communicator.plugin.otr;

/**
 * Extends otr4j's <tt>SessionStatus</tt> with two additional states.
 * 
 * @author Marin Dzhigarov
 */
public enum ScSessionStatus
{
    PLAINTEXT,
    ENCRYPTED,
    FINISHED,
    /*
     * A Session transitions in LOADING state right before
     * Session.startSession() is invoked.
     */
    LOADING, 
    /*
     * A Session transitions in TIMED_OUT state after being in LOADING state for
     * a long period of time.
     */
    TIMED_OUT
}
