/**
 * Copyright (C) 2008 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.inject.spi;

import com.google.inject.Scope;

import junit.framework.AssertionFailedError;

import java.lang.annotation.Annotation;

public class FailingBindingScopingVisitor implements BindingScopingVisitor<Void> {

  public Void visitEagerSingleton() {
    throw new AssertionFailedError();
  }

  public Void visitScope(Scope scope) {
    throw new AssertionFailedError();
  }

  public Void visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
    throw new AssertionFailedError();
  }

  public Void visitNoScoping() {
    throw new AssertionFailedError();
  }
}