/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.INavigatorEditorInput;
import org.jkiss.dbeaver.ui.editors.NodeEditorInputFactory;

public class NodeEditorInput
implements INavigatorEditorInput,
IPersistableElement {
    private DBNNode node;

    public NodeEditorInput(DBNNode node) {
        this.node = node;
    }

    @Override
    public DBNNode getNavigatorNode() {
        return this.node;
    }

    public void setNavigatorNode(DBNNode node) {
        this.node = node;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return DBeaverIcons.getImageDescriptor((DBPImage)this.node.getNodeIcon());
    }

    public String getName() {
        return this.node.getNodeName();
    }

    public IPersistableElement getPersistable() {
        return this.node.isDisposed() ? null : this;
    }

    public String getToolTipText() {
        return this.node.getNodeDescription();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBNNode.class) {
            return adapter.cast(this.node);
        }
        return null;
    }

    public String getFactoryId() {
        return NodeEditorInputFactory.ID_FACTORY;
    }

    public void saveState(IMemento memento) {
        if (this.node.isDisposed()) {
            return;
        }
        NodeEditorInputFactory.saveState(memento, this);
    }
}

