/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.swt.editor;

import java.awt.Font;
import java.awt.Paint;
import java.util.ResourceBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.swt.editor.SWTNumberAxisEditor;
import org.jfree.chart.swt.editor.SWTPaintCanvas;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.swt.SWTUtils;

class SWTAxisEditor
extends Composite {
    private Text label;
    private FontData labelFont;
    private Color labelPaintColor;
    private FontData tickLabelFont;
    private Color tickLabelPaintColor;
    private Text labelFontField;
    private Text tickLabelFontField;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle((String)"org.jfree.chart.editor.LocalizationBundle");
    private org.eclipse.swt.graphics.Font font;
    private Button showTickLabelsCheckBox;
    private Button showTickMarksCheckBox;
    private TabFolder otherTabs;

    public SWTAxisEditor(Composite parent, int style, Axis axis) {
        super(parent, style);
        this.labelFont = SWTUtils.toSwtFontData((Device)this.getDisplay(), (Font)axis.getLabelFont(), (boolean)true);
        this.labelPaintColor = SWTUtils.toSwtColor((Device)this.getDisplay(), (Paint)axis.getLabelPaint());
        this.tickLabelFont = SWTUtils.toSwtFontData((Device)this.getDisplay(), (Font)axis.getTickLabelFont(), (boolean)true);
        this.tickLabelPaintColor = SWTUtils.toSwtColor((Device)this.getDisplay(), (Paint)axis.getTickLabelPaint());
        FillLayout layout = new FillLayout(512);
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        this.setLayout((Layout)layout);
        Group general = new Group((Composite)this, 0);
        general.setLayout((Layout)new GridLayout(3, false));
        general.setText(localizationResources.getString("General"));
        new Label((Composite)general, 0).setText(localizationResources.getString("Label"));
        this.label = new Text((Composite)general, 2048);
        if (axis.getLabel() != null) {
            this.label.setText(axis.getLabel());
        }
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)general, 0).setText("");
        new Label((Composite)general, 0).setText(localizationResources.getString("Font"));
        this.labelFontField = new Text((Composite)general, 2048);
        this.labelFontField.setText(this.labelFont.toString());
        this.labelFontField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button selectFontButton = new Button((Composite)general, 8);
        selectFontButton.setText(localizationResources.getString("Select..."));
        selectFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDialog dlg = new FontDialog(SWTAxisEditor.this.getShell());
                dlg.setText(localizationResources.getString("Font_Selection"));
                dlg.setFontList(new FontData[]{SWTAxisEditor.this.labelFont});
                if (dlg.open() != null) {
                    if (SWTAxisEditor.this.font != null) {
                        SWTAxisEditor.this.font.dispose();
                    }
                    SWTAxisEditor.this.font = new org.eclipse.swt.graphics.Font((Device)SWTAxisEditor.this.getShell().getDisplay(), dlg.getFontList());
                    SWTAxisEditor.this.labelFontField.setText(SWTAxisEditor.this.font.getFontData()[0].toString());
                    SWTAxisEditor.this.labelFont = SWTAxisEditor.this.font.getFontData()[0];
                }
            }
        });
        new Label((Composite)general, 0).setText(localizationResources.getString("Paint"));
        final SWTPaintCanvas colorCanvas = new SWTPaintCanvas((Composite)general, 0, this.labelPaintColor);
        GridData canvasGridData = new GridData(4, 0x1000000, true, false);
        canvasGridData.heightHint = 20;
        colorCanvas.setLayoutData(canvasGridData);
        Button selectColorButton = new Button((Composite)general, 8);
        selectColorButton.setText(localizationResources.getString("Select..."));
        selectColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(SWTAxisEditor.this.getShell());
                dlg.setText(localizationResources.getString("Title_Color"));
                dlg.setRGB(SWTAxisEditor.this.labelPaintColor.getRGB());
                RGB rgb = dlg.open();
                if (rgb != null) {
                    SWTAxisEditor.this.labelPaintColor = new Color((Device)SWTAxisEditor.this.getDisplay(), rgb);
                    colorCanvas.setColor(SWTAxisEditor.this.labelPaintColor);
                }
            }
        });
        Group other = new Group((Composite)this, 0);
        FillLayout tabLayout = new FillLayout();
        tabLayout.marginWidth = 4;
        tabLayout.marginHeight = 4;
        other.setLayout((Layout)tabLayout);
        other.setText(localizationResources.getString("Other"));
        this.otherTabs = new TabFolder((Composite)other, 0);
        TabItem item1 = new TabItem(this.otherTabs, 0);
        item1.setText(" " + localizationResources.getString("Ticks") + " ");
        Composite ticks = new Composite((Composite)this.otherTabs, 0);
        ticks.setLayout((Layout)new GridLayout(3, false));
        this.showTickLabelsCheckBox = new Button(ticks, 32);
        this.showTickLabelsCheckBox.setText(localizationResources.getString("Show_tick_labels"));
        this.showTickLabelsCheckBox.setSelection(axis.isTickLabelsVisible());
        this.showTickLabelsCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(ticks, 0).setText(localizationResources.getString("Tick_label_font"));
        this.tickLabelFontField = new Text(ticks, 2048);
        this.tickLabelFontField.setText(this.tickLabelFont.toString());
        this.tickLabelFontField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button selectTickLabelFontButton = new Button(ticks, 8);
        selectTickLabelFontButton.setText(localizationResources.getString("Select..."));
        selectTickLabelFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDialog dlg = new FontDialog(SWTAxisEditor.this.getShell());
                dlg.setText(localizationResources.getString("Font_Selection"));
                dlg.setFontList(new FontData[]{SWTAxisEditor.this.tickLabelFont});
                if (dlg.open() != null) {
                    if (SWTAxisEditor.this.font != null) {
                        SWTAxisEditor.this.font.dispose();
                    }
                    SWTAxisEditor.this.font = new org.eclipse.swt.graphics.Font((Device)SWTAxisEditor.this.getShell().getDisplay(), dlg.getFontList());
                    SWTAxisEditor.this.tickLabelFontField.setText(SWTAxisEditor.this.font.getFontData()[0].toString());
                    SWTAxisEditor.this.tickLabelFont = SWTAxisEditor.this.font.getFontData()[0];
                }
            }
        });
        this.showTickMarksCheckBox = new Button(ticks, 32);
        this.showTickMarksCheckBox.setText(localizationResources.getString("Show_tick_marks"));
        this.showTickMarksCheckBox.setSelection(axis.isTickMarksVisible());
        this.showTickMarksCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        item1.setControl((Control)ticks);
    }

    public static SWTAxisEditor getInstance(Composite parent, int style, Axis axis) {
        if (axis != null) {
            if (axis instanceof NumberAxis) {
                return new SWTNumberAxisEditor(parent, style, (NumberAxis)axis);
            }
            return new SWTAxisEditor(parent, style, axis);
        }
        return null;
    }

    public TabFolder getOtherTabs() {
        return this.otherTabs;
    }

    public String getLabel() {
        return this.label.getText();
    }

    public Font getLabelFont() {
        return SWTUtils.toAwtFont((Device)this.getDisplay(), (FontData)this.labelFont, (boolean)true);
    }

    public Paint getTickLabelPaint() {
        return SWTUtils.toAwtColor((Color)this.tickLabelPaintColor);
    }

    public Font getTickLabelFont() {
        return SWTUtils.toAwtFont((Device)this.getDisplay(), (FontData)this.tickLabelFont, (boolean)true);
    }

    public Paint getLabelPaint() {
        return SWTUtils.toAwtColor((Color)this.labelPaintColor);
    }

    public void setAxisProperties(Axis axis) {
        axis.setLabel(this.getLabel());
        axis.setLabelFont(this.getLabelFont());
        axis.setLabelPaint(this.getLabelPaint());
        axis.setTickMarksVisible(this.showTickMarksCheckBox.getSelection());
        axis.setTickLabelsVisible(this.showTickLabelsCheckBox.getSelection());
        axis.setTickLabelFont(this.getTickLabelFont());
        axis.setTickLabelPaint(this.getTickLabelPaint());
    }
}

