/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.properties;

import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.ui.IProgressControlProvider;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderPage;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.itemlist.ItemListControl;

class TabbedFolderPageNode
extends TabbedFolderPage
implements ISearchContextProvider,
IRefreshablePart,
INavigatorModelView,
IAdaptable {
    private final IDatabaseEditor mainEditor;
    private final DBNNode node;
    private final DBXTreeNode metaNode;
    private ItemListControl itemControl;
    private boolean activated;

    TabbedFolderPageNode(IDatabaseEditor mainEditor, DBNNode node, DBXTreeNode metaNode) {
        this.mainEditor = mainEditor;
        this.node = node;
        this.metaNode = metaNode;
    }

    public void setFocus() {
        if (this.itemControl != null) {
            this.itemControl.setFocus();
        }
    }

    public void createControl(Composite parent) {
        this.itemControl = new ItemListControl(parent, 0x10000000, (IWorkbenchSite)this.mainEditor.getSite(), this.node, this.metaNode);
        ProgressPageControl progressControl = null;
        if (this.mainEditor instanceof IProgressControlProvider) {
            progressControl = ((IProgressControlProvider)this.mainEditor).getProgressControl();
        }
        if (progressControl != null) {
            this.itemControl.substituteProgressPanel(progressControl);
        } else {
            this.itemControl.createProgressPanel();
        }
        parent.layout();
        this.itemControl.getItemsViewer().getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MultiPageEditorPart multiPageEditor;
                ISelectionProvider selectionProvider = TabbedFolderPageNode.this.itemControl.getSelectionProvider();
                if (TabbedFolderPageNode.this.mainEditor.getSite().getSelectionProvider() != selectionProvider) {
                    TabbedFolderPageNode.this.mainEditor.getSite().setSelectionProvider(selectionProvider);
                    selectionProvider.setSelection(selectionProvider.getSelection());
                }
                TabbedFolderPageNode.this.itemControl.activate(true);
                if (TabbedFolderPageNode.this.mainEditor.getSite() instanceof MultiPageEditorSite && (multiPageEditor = ((MultiPageEditorSite)TabbedFolderPageNode.this.mainEditor.getSite()).getMultiPageEditor()).getSelectedPage() != TabbedFolderPageNode.this.mainEditor) {
                    multiPageEditor.setActiveEditor((IEditorPart)TabbedFolderPageNode.this.mainEditor);
                }
            }

            public void focusLost(FocusEvent e) {
                TabbedFolderPageNode.this.itemControl.activate(false);
            }
        });
    }

    public void aboutToBeShown() {
        if (!this.activated) {
            this.activated = true;
            boolean isLazy = !(this.node instanceof DBNDatabaseNode) || ((DBNDatabaseNode)this.node).needsInitialization();
            this.itemControl.loadData(isLazy);
        }
    }

    public void aboutToBeHidden() {
    }

    public IEditorInput getEditorInput() {
        return this.mainEditor.getEditorInput();
    }

    public boolean isSearchPossible() {
        return this.itemControl.isSearchPossible();
    }

    public boolean isSearchEnabled() {
        return this.itemControl.isSearchEnabled();
    }

    public boolean performSearch(ISearchContextProvider.SearchType searchType) {
        return this.itemControl.performSearch(searchType);
    }

    public void refreshPart(Object source, boolean force) {
        if (!this.activated || this.itemControl == null || this.itemControl.isDisposed()) {
            return;
        }
        boolean loadNewData = true;
        if (!force && source instanceof DBNEvent) {
            DBNEvent event = (DBNEvent)source;
            DBNEvent.NodeChange nodeChange = event.getNodeChange();
            if (event.getAction() == DBNEvent.Action.UPDATE && nodeChange == DBNEvent.NodeChange.REFRESH) {
                loadNewData = this.isRefreshingEvent(event);
            } else if (nodeChange == DBNEvent.NodeChange.UNLOAD) {
                loadNewData = false;
            }
        }
        if (loadNewData) {
            this.itemControl.loadData(false);
        }
    }

    private boolean isRefreshingEvent(DBNEvent event) {
        if (event.getSource() == DBNEvent.UPDATE_ON_SAVE) {
            return true;
        }
        if (!(event.getSource() instanceof DBPEvent)) {
            return false;
        }
        DBPEvent dbEvent = (DBPEvent)event.getSource();
        if (dbEvent.getData() == DBPEvent.REORDER) {
            DBNNode rootNode = this.getRootNode();
            return rootNode instanceof DBNDatabaseNode && dbEvent.getObject() == ((DBNDatabaseNode)rootNode).getValueObject();
        }
        Object itemsInput = this.itemControl.getItemsViewer().getInput();
        return itemsInput instanceof Collection && ((Collection)itemsInput).contains(dbEvent.getObject());
    }

    @Override
    public DBNNode getRootNode() {
        return this.itemControl.getRootNode();
    }

    @Override
    public Viewer getNavigatorViewer() {
        return this.itemControl.getNavigatorViewer();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(this.itemControl.getClass())) {
            return adapter.cast(this.itemControl);
        }
        return null;
    }
}

