/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLDataSourceProvider;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizard;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLScriptExecuteWizard;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.nativetool.NativeToolConfigPanel;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;

public class MySQLTaskConfigurator
implements DBTTaskConfigurator {
    private static final Log log = Log.getLog(MySQLTaskConfigurator.class);

    public ConfigPanel createInputConfigurator(DBRRunnableContext runnableContext, @NotNull DBTTaskType taskType) {
        return new ConfigPanel(runnableContext, taskType);
    }

    public TaskConfigurationWizard createTaskConfigWizard(@NotNull DBTTask taskConfiguration) {
        switch (taskConfiguration.getType().getId()) {
            case "mysqlDatabaseBackup": {
                return new MySQLExportWizard(taskConfiguration);
            }
            case "mysqlDatabaseRestore": {
                return new MySQLScriptExecuteWizard(taskConfiguration, true);
            }
            case "mysqlScriptExecute": {
                return new MySQLScriptExecuteWizard(taskConfiguration, false);
            }
        }
        return null;
    }

    private static class ConfigPanel
    extends NativeToolConfigPanel<MySQLCatalog> {
        ConfigPanel(DBRRunnableContext runnableContext, DBTTaskType taskType) {
            super(runnableContext, taskType, MySQLCatalog.class, MySQLDataSourceProvider.class);
        }
    }
}

