/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class PropertySourceCollection
implements DBPPropertySource {
    private List<DBPPropertyDescriptor> props = new ArrayList<DBPPropertyDescriptor>();
    private List<Object> items;

    public PropertySourceCollection(Collection<?> collection) {
        this.items = new ArrayList(collection);
        int i = 0;
        while (i < this.items.size()) {
            this.props.add(new ItemPropertyDescriptor(String.valueOf(i), this.items.get(i)));
            ++i;
        }
    }

    @Override
    public Object getEditableValue() {
        return this;
    }

    @Override
    public DBPPropertyDescriptor[] getProperties() {
        return this.props.toArray(new DBPPropertyDescriptor[0]);
    }

    @Override
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, String id) {
        return this.items.get(CommonUtils.toInt((Object)id));
    }

    @Override
    public boolean isPropertySet(String id) {
        return false;
    }

    @Override
    public boolean isPropertyResettable(String id) {
        return false;
    }

    @Override
    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, String id) {
    }

    @Override
    public void resetPropertyValueToDefault(String id) {
    }

    @Override
    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, String id, Object value) {
    }

    public String toString() {
        return "[...]";
    }

    private class ItemPropertyDescriptor
    implements DBPPropertyDescriptor {
        private String id;
        private Object item;

        private ItemPropertyDescriptor(String id, Object item) {
            this.id = id;
            this.item = item;
        }

        @Override
        public String getCategory() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public Class<?> getDataType() {
            return Object.class;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }

        @Override
        public boolean isEditable(Object object) {
            return false;
        }

        @Override
        @Nullable
        public String[] getFeatures() {
            return null;
        }

        @Override
        public boolean hasFeature(@NotNull String feature) {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return DBUtils.getObjectShortName(this.item);
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }
    }
}

