/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.dbeaver.Log;

public class JDBCTransaction
implements AutoCloseable {
    private static final Log log = Log.getLog(JDBCTransaction.class);
    private final Connection dbCon;
    private final boolean oldAutoCommit;

    public JDBCTransaction(Connection dbCon) throws SQLException {
        this.dbCon = dbCon;
        this.oldAutoCommit = dbCon.getAutoCommit();
        if (this.oldAutoCommit) {
            dbCon.setAutoCommit(false);
        }
    }

    public void commit() throws SQLException {
        this.dbCon.commit();
    }

    public void rollback() throws SQLException {
        this.dbCon.rollback();
    }

    @Override
    public void close() {
        if (this.oldAutoCommit) {
            try {
                this.dbCon.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error("Error recovering auto-commit mode after transaction end", e);
            }
        }
    }
}

