/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql;

import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerAuthentication;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCConnectionImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.utils.CommonUtils;

public class SQLServerUtils {
    private static final Log log = Log.getLog(SQLServerUtils.class);

    public static boolean isDriverSqlServer(DBPDriver driver) {
        return driver.getSampleURL().contains(":sqlserver");
    }

    public static boolean isDriverGeneric(DBPDriver driver) {
        return driver.getId().contains("generic");
    }

    public static boolean isDriverAzure(DBPDriver driver) {
        return driver.getId().contains("azure");
    }

    public static boolean isDriverJtds(DBPDriver driver) {
        return driver.getSampleURL().startsWith("jdbc:jtds");
    }

    public static boolean isWindowsAuth(DBPConnectionConfiguration connectionInfo) {
        return CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-connection-windows-auth@")) || CommonUtils.toBoolean(connectionInfo.getProperties().get("integratedSecurity"));
    }

    public static boolean isActiveDirectoryAuth(DBPConnectionConfiguration connectionInfo) {
        return "ActiveDirectoryPassword".equals(connectionInfo.getProperty("authentication"));
    }

    public static void setCurrentDatabase(JDBCSession session, String schema) throws SQLException {
        JDBCUtils.executeSQL((Connection)session, (String)("use " + DBUtils.getQuotedIdentifier((DBPDataSource)session.getDataSource(), (String)schema)), (Object[])new Object[0]);
    }

    public static void setCurrentSchema(JDBCSession session, String currentUser, String schema) throws SQLException {
        if (!CommonUtils.isEmpty((String)currentUser)) {
            JDBCUtils.executeSQL((Connection)session, (String)("alter user " + DBUtils.getQuotedIdentifier((DBPDataSource)session.getDataSource(), (String)currentUser) + " with default_schema = " + DBUtils.getQuotedIdentifier((DBPDataSource)session.getDataSource(), (String)schema)), (Object[])new Object[0]);
        }
    }

    public static String getCurrentUser(JDBCSession session) throws SQLException {
        return JDBCUtils.queryString((JDBCSession)session, (String)"select original_login()", (Object[])new Object[0]);
    }

    public static String getCurrentDatabase(JDBCSession session) throws SQLException {
        return JDBCUtils.queryString((JDBCSession)session, (String)"select db_name()", (Object[])new Object[0]);
    }

    public static String getCurrentSchema(JDBCSession session) throws SQLException {
        return JDBCUtils.queryString((JDBCSession)session, (String)"select schema_name()", (Object[])new Object[0]);
    }

    public static boolean isShowAllSchemas(DBPDataSource dataSource) {
        return CommonUtils.toBoolean((Object)dataSource.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-show-all-schemas@"));
    }

    public static boolean supportsCrossDatabaseQueries(JDBCDataSource dataSource) {
        boolean isDriverAzure;
        boolean isSqlServer = SQLServerUtils.isDriverSqlServer(dataSource.getContainer().getDriver());
        if (isSqlServer && !dataSource.isServerVersionAtLeast(9, 0)) {
            return false;
        }
        boolean bl = isDriverAzure = isSqlServer && SQLServerUtils.isDriverAzure(dataSource.getContainer().getDriver());
        return !isDriverAzure || dataSource.isServerVersionAtLeast(11, 0);
    }

    public static String getSystemSchemaFQN(JDBCDataSource dataSource, String catalog, String systemSchema) {
        return catalog != null && SQLServerUtils.supportsCrossDatabaseQueries(dataSource) ? String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)catalog)) + "." + systemSchema : systemSchema;
    }

    public static String getSystemTableName(SQLServerDatabase database, String tableName) {
        return String.valueOf(SQLServerUtils.getSystemSchemaFQN(database.getDataSource(), database.getName(), "sys")) + "." + tableName;
    }

    public static String getExtendedPropsTableName(SQLServerDatabase database) {
        return SQLServerUtils.getSystemTableName(database, "extended_properties");
    }

    public static DBSForeignKeyModifyRule getForeignKeyModifyRule(int actionNum) {
        switch (actionNum) {
            case 0: {
                return DBSForeignKeyModifyRule.NO_ACTION;
            }
            case 1: {
                return DBSForeignKeyModifyRule.CASCADE;
            }
            case 2: {
                return DBSForeignKeyModifyRule.SET_NULL;
            }
            case 3: {
                return DBSForeignKeyModifyRule.SET_DEFAULT;
            }
        }
        return DBSForeignKeyModifyRule.NO_ACTION;
    }

    /*
     * Exception decompiling
     */
    public static String extractSource(@NotNull DBRProgressMonitor monitor, @NotNull SQLServerDatabase database, @NotNull SQLServerObject object) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String extractSource(@NotNull DBRProgressMonitor monitor, @NotNull SQLServerSchema schema, @NotNull String objectName) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean isCommentSet(DBRProgressMonitor monitor, SQLServerDatabase database, SQLServerObjectClass objectClass, long majorId, long minorId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public static SQLServerAuthentication detectAuthSchema(DBPConnectionConfiguration connectionInfo) {
        SQLServerAuthentication auth = SQLServerUtils.isWindowsAuth(connectionInfo) ? SQLServerAuthentication.WINDOWS_INTEGRATED : (SQLServerUtils.isActiveDirectoryAuth(connectionInfo) ? SQLServerAuthentication.AD_PASSWORD : SQLServerAuthentication.SQL_SERVER_PASSWORD);
        String authProp = connectionInfo.getProviderProperty("@dbeaver-authentication@");
        if (authProp != null) {
            try {
                auth = SQLServerAuthentication.valueOf(authProp);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn((Object)("Bad auth schema: " + authProp));
            }
        }
        return auth;
    }

    public static String changeCreateToAlterDDL(SQLDialect sqlDialect, String ddl) {
        String firstKeyword = SQLUtils.getFirstKeyword((SQLDialect)sqlDialect, (String)ddl);
        if ("CREATE".equalsIgnoreCase(firstKeyword)) {
            return ddl.replaceFirst(firstKeyword, "ALTER");
        }
        return ddl;
    }

    public static boolean isTableType(SQLServerTableBase table) {
        return table instanceof SQLServerTableType;
    }

    public static SQLServerTableBase getTableFromQuery(DBCSession session, SQLQuery sqlQuery, SQLServerDataSource dataSource) throws DBException, SQLException {
        DBCEntityMetaData singleSource = sqlQuery.getSingleSource();
        String catalogName = null;
        if (singleSource != null) {
            catalogName = singleSource.getCatalogName();
        }
        Connection original = null;
        if (session instanceof JDBCConnectionImpl) {
            original = ((JDBCConnectionImpl)session).getOriginal();
        }
        if (catalogName == null && original != null) {
            catalogName = original.getCatalog();
        }
        if (catalogName != null) {
            SQLServerSchema schema;
            SQLServerDatabase database = dataSource.getDatabase(catalogName);
            String schemaName = null;
            if (singleSource != null) {
                schemaName = singleSource.getSchemaName();
            }
            if (schemaName == null && original != null) {
                schemaName = original.getSchema();
            }
            if (database != null && schemaName != null && (schema = database.getSchema(schemaName)) != null && singleSource != null) {
                return schema.getTable(session.getProgressMonitor(), singleSource.getEntityName());
            }
        }
        return null;
    }
}

