// ISO-639-3 Language registry.
// License: Public Domain.
// This file is autogenerated.
// Based on data from https://iso639-3.sil.org/code_tables/download_tables
// file: iso-639-3.tab
// url: https://iso639-3.sil.org/sites/iso639-3/files/downloads/iso-639-3.tab

#include "iso-639-3_data.h"

#include <stddef.h>

const struct iso639_3_rec iso639_3_data[] = {
	{"aaa", NULL, NULL, NULL, "Ghotuo"},
	{"aab", NULL, NULL, NULL, "Alumu-Tesu"},
	{"aac", NULL, NULL, NULL, "Ari"},
	{"aad", NULL, NULL, NULL, "Amal"},
	{"aae", NULL, NULL, NULL, "Arbëreshë Albanian"},
	{"aaf", NULL, NULL, NULL, "Aranadan"},
	{"aag", NULL, NULL, NULL, "Ambrak"},
	{"aah", NULL, NULL, NULL, "Abu' Arapesh"},
	{"aai", NULL, NULL, NULL, "Arifama-Miniafia"},
	{"aak", NULL, NULL, NULL, "Ankave"},
	{"aal", NULL, NULL, NULL, "Afade"},
	{"aan", NULL, NULL, NULL, "Anambé"},
	{"aao", NULL, NULL, NULL, "Algerian Saharan Arabic"},
	{"aap", NULL, NULL, NULL, "Pará Arára"},
	{"aaq", NULL, NULL, NULL, "Eastern Abnaki"},
	{"aar", "aar", "aar", "aa", "Afar"},
	{"aas", NULL, NULL, NULL, "Aasáx"},
	{"aat", NULL, NULL, NULL, "Arvanitika Albanian"},
	{"aau", NULL, NULL, NULL, "Abau"},
	{"aaw", NULL, NULL, NULL, "Solong"},
	{"aax", NULL, NULL, NULL, "Mandobo Atas"},
	{"aaz", NULL, NULL, NULL, "Amarasi"},
	{"aba", NULL, NULL, NULL, "Abé"},
	{"abb", NULL, NULL, NULL, "Bankon"},
	{"abc", NULL, NULL, NULL, "Ambala Ayta"},
	{"abd", NULL, NULL, NULL, "Manide"},
	{"abe", NULL, NULL, NULL, "Western Abnaki"},
	{"abf", NULL, NULL, NULL, "Abai Sungai"},
	{"abg", NULL, NULL, NULL, "Abaga"},
	{"abh", NULL, NULL, NULL, "Tajiki Arabic"},
	{"abi", NULL, NULL, NULL, "Abidji"},
	{"abj", NULL, NULL, NULL, "Aka-Bea"},
	{"abk", "abk", "abk", "ab", "Abkhazian"},
	{"abl", NULL, NULL, NULL, "Lampung Nyo"},
	{"abm", NULL, NULL, NULL, "Abanyom"},
	{"abn", NULL, NULL, NULL, "Abua"},
	{"abo", NULL, NULL, NULL, "Abon"},
	{"abp", NULL, NULL, NULL, "Abellen Ayta"},
	{"abq", NULL, NULL, NULL, "Abaza"},
	{"abr", NULL, NULL, NULL, "Abron"},
	{"abs", NULL, NULL, NULL, "Ambonese Malay"},
	{"abt", NULL, NULL, NULL, "Ambulas"},
	{"abu", NULL, NULL, NULL, "Abure"},
	{"abv", NULL, NULL, NULL, "Baharna Arabic"},
	{"abw", NULL, NULL, NULL, "Pal"},
	{"abx", NULL, NULL, NULL, "Inabaknon"},
	{"aby", NULL, NULL, NULL, "Aneme Wake"},
	{"abz", NULL, NULL, NULL, "Abui"},
	{"aca", NULL, NULL, NULL, "Achagua"},
	{"acb", NULL, NULL, NULL, "Áncá"},
	{"acd", NULL, NULL, NULL, "Gikyode"},
	{"ace", "ace", "ace", NULL, "Achinese"},
	{"acf", NULL, NULL, NULL, "Saint Lucian Creole French"},
	{"ach", "ach", "ach", NULL, "Acoli"},
	{"aci", NULL, NULL, NULL, "Aka-Cari"},
	{"ack", NULL, NULL, NULL, "Aka-Kora"},
	{"acl", NULL, NULL, NULL, "Akar-Bale"},
	{"acm", NULL, NULL, NULL, "Mesopotamian Arabic"},
	{"acn", NULL, NULL, NULL, "Achang"},
	{"acp", NULL, NULL, NULL, "Eastern Acipa"},
	{"acq", NULL, NULL, NULL, "Ta'izzi-Adeni Arabic"},
	{"acr", NULL, NULL, NULL, "Achi"},
	{"acs", NULL, NULL, NULL, "Acroá"},
	{"act", NULL, NULL, NULL, "Achterhoeks"},
	{"acu", NULL, NULL, NULL, "Achuar-Shiwiar"},
	{"acv", NULL, NULL, NULL, "Achumawi"},
	{"acw", NULL, NULL, NULL, "Hijazi Arabic"},
	{"acx", NULL, NULL, NULL, "Omani Arabic"},
	{"acy", NULL, NULL, NULL, "Cypriot Arabic"},
	{"acz", NULL, NULL, NULL, "Acheron"},
	{"ada", "ada", "ada", NULL, "Adangme"},
	{"adb", NULL, NULL, NULL, "Atauran"},
	{"add", NULL, NULL, NULL, "Lidzonka"},
	{"ade", NULL, NULL, NULL, "Adele"},
	{"adf", NULL, NULL, NULL, "Dhofari Arabic"},
	{"adg", NULL, NULL, NULL, "Andegerebinha"},
	{"adh", NULL, NULL, NULL, "Adhola"},
	{"adi", NULL, NULL, NULL, "Adi"},
	{"adj", NULL, NULL, NULL, "Adioukrou"},
	{"adl", NULL, NULL, NULL, "Galo"},
	{"adn", NULL, NULL, NULL, "Adang"},
	{"ado", NULL, NULL, NULL, "Abu"},
	{"adq", NULL, NULL, NULL, "Adangbe"},
	{"adr", NULL, NULL, NULL, "Adonara"},
	{"ads", NULL, NULL, NULL, "Adamorobe Sign Language"},
	{"adt", NULL, NULL, NULL, "Adnyamathanha"},
	{"adu", NULL, NULL, NULL, "Aduge"},
	{"adw", NULL, NULL, NULL, "Amundava"},
	{"adx", NULL, NULL, NULL, "Amdo Tibetan"},
	{"ady", "ady", "ady", NULL, "Adyghe"},
	{"adz", NULL, NULL, NULL, "Adzera"},
	{"aea", NULL, NULL, NULL, "Areba"},
	{"aeb", NULL, NULL, NULL, "Tunisian Arabic"},
	{"aec", NULL, NULL, NULL, "Saidi Arabic"},
	{"aed", NULL, NULL, NULL, "Argentine Sign Language"},
	{"aee", NULL, NULL, NULL, "Northeast Pashai"},
	{"aek", NULL, NULL, NULL, "Haeke"},
	{"ael", NULL, NULL, NULL, "Ambele"},
	{"aem", NULL, NULL, NULL, "Arem"},
	{"aen", NULL, NULL, NULL, "Armenian Sign Language"},
	{"aeq", NULL, NULL, NULL, "Aer"},
	{"aer", NULL, NULL, NULL, "Eastern Arrernte"},
	{"aes", NULL, NULL, NULL, "Alsea"},
	{"aeu", NULL, NULL, NULL, "Akeu"},
	{"aew", NULL, NULL, NULL, "Ambakich"},
	{"aey", NULL, NULL, NULL, "Amele"},
	{"aez", NULL, NULL, NULL, "Aeka"},
	{"afb", NULL, NULL, NULL, "Gulf Arabic"},
	{"afd", NULL, NULL, NULL, "Andai"},
	{"afe", NULL, NULL, NULL, "Putukwam"},
	{"afg", NULL, NULL, NULL, "Afghan Sign Language"},
	{"afh", "afh", "afh", NULL, "Afrihili"},
	{"afi", NULL, NULL, NULL, "Akrukay"},
	{"afk", NULL, NULL, NULL, "Nanubae"},
	{"afn", NULL, NULL, NULL, "Defaka"},
	{"afo", NULL, NULL, NULL, "Eloyi"},
	{"afp", NULL, NULL, NULL, "Tapei"},
	{"afr", "afr", "afr", "af", "Afrikaans"},
	{"afs", NULL, NULL, NULL, "Afro-Seminole Creole"},
	{"aft", NULL, NULL, NULL, "Afitti"},
	{"afu", NULL, NULL, NULL, "Awutu"},
	{"afz", NULL, NULL, NULL, "Obokuitai"},
	{"aga", NULL, NULL, NULL, "Aguano"},
	{"agb", NULL, NULL, NULL, "Legbo"},
	{"agc", NULL, NULL, NULL, "Agatu"},
	{"agd", NULL, NULL, NULL, "Agarabi"},
	{"age", NULL, NULL, NULL, "Angal"},
	{"agf", NULL, NULL, NULL, "Arguni"},
	{"agg", NULL, NULL, NULL, "Angor"},
	{"agh", NULL, NULL, NULL, "Ngelima"},
	{"agi", NULL, NULL, NULL, "Agariya"},
	{"agj", NULL, NULL, NULL, "Argobba"},
	{"agk", NULL, NULL, NULL, "Isarog Agta"},
	{"agl", NULL, NULL, NULL, "Fembe"},
	{"agm", NULL, NULL, NULL, "Angaataha"},
	{"agn", NULL, NULL, NULL, "Agutaynen"},
	{"ago", NULL, NULL, NULL, "Tainae"},
	{"agq", NULL, NULL, NULL, "Aghem"},
	{"agr", NULL, NULL, NULL, "Aguaruna"},
	{"ags", NULL, NULL, NULL, "Esimbi"},
	{"agt", NULL, NULL, NULL, "Central Cagayan Agta"},
	{"agu", NULL, NULL, NULL, "Aguacateco"},
	{"agv", NULL, NULL, NULL, "Remontado Dumagat"},
	{"agw", NULL, NULL, NULL, "Kahua"},
	{"agx", NULL, NULL, NULL, "Aghul"},
	{"agy", NULL, NULL, NULL, "Southern Alta"},
	{"agz", NULL, NULL, NULL, "Mt. Iriga Agta"},
	{"aha", NULL, NULL, NULL, "Ahanta"},
	{"ahb", NULL, NULL, NULL, "Axamb"},
	{"ahg", NULL, NULL, NULL, "Qimant"},
	{"ahh", NULL, NULL, NULL, "Aghu"},
	{"ahi", NULL, NULL, NULL, "Tiagbamrin Aizi"},
	{"ahk", NULL, NULL, NULL, "Akha"},
	{"ahl", NULL, NULL, NULL, "Igo"},
	{"ahm", NULL, NULL, NULL, "Mobumrin Aizi"},
	{"ahn", NULL, NULL, NULL, "Àhàn"},
	{"aho", NULL, NULL, NULL, "Ahom"},
	{"ahp", NULL, NULL, NULL, "Aproumu Aizi"},
	{"ahr", NULL, NULL, NULL, "Ahirani"},
	{"ahs", NULL, NULL, NULL, "Ashe"},
	{"aht", NULL, NULL, NULL, "Ahtena"},
	{"aia", NULL, NULL, NULL, "Arosi"},
	{"aib", NULL, NULL, NULL, "Ainu (China)"},
	{"aic", NULL, NULL, NULL, "Ainbai"},
	{"aid", NULL, NULL, NULL, "Alngith"},
	{"aie", NULL, NULL, NULL, "Amara"},
	{"aif", NULL, NULL, NULL, "Agi"},
	{"aig", NULL, NULL, NULL, "Antigua and Barbuda Creole English"},
	{"aih", NULL, NULL, NULL, "Ai-Cham"},
	{"aii", NULL, NULL, NULL, "Assyrian Neo-Aramaic"},
	{"aij", NULL, NULL, NULL, "Lishanid Noshan"},
	{"aik", NULL, NULL, NULL, "Ake"},
	{"ail", NULL, NULL, NULL, "Aimele"},
	{"aim", NULL, NULL, NULL, "Aimol"},
	{"ain", "ain", "ain", NULL, "Ainu (Japan)"},
	{"aio", NULL, NULL, NULL, "Aiton"},
	{"aip", NULL, NULL, NULL, "Burumakok"},
	{"aiq", NULL, NULL, NULL, "Aimaq"},
	{"air", NULL, NULL, NULL, "Airoran"},
	{"ait", NULL, NULL, NULL, "Arikem"},
	{"aiw", NULL, NULL, NULL, "Aari"},
	{"aix", NULL, NULL, NULL, "Aighon"},
	{"aiy", NULL, NULL, NULL, "Ali"},
	{"aja", NULL, NULL, NULL, "Aja (South Sudan)"},
	{"ajg", NULL, NULL, NULL, "Aja (Benin)"},
	{"aji", NULL, NULL, NULL, "Ajië"},
	{"ajn", NULL, NULL, NULL, "Andajin"},
	{"ajp", NULL, NULL, NULL, "South Levantine Arabic"},
	{"ajt", NULL, NULL, NULL, "Judeo-Tunisian Arabic"},
	{"aju", NULL, NULL, NULL, "Judeo-Moroccan Arabic"},
	{"ajw", NULL, NULL, NULL, "Ajawa"},
	{"ajz", NULL, NULL, NULL, "Amri Karbi"},
	{"aka", "aka", "aka", "ak", "Akan"},
	{"akb", NULL, NULL, NULL, "Batak Angkola"},
	{"akc", NULL, NULL, NULL, "Mpur"},
	{"akd", NULL, NULL, NULL, "Ukpet-Ehom"},
	{"ake", NULL, NULL, NULL, "Akawaio"},
	{"akf", NULL, NULL, NULL, "Akpa"},
	{"akg", NULL, NULL, NULL, "Anakalangu"},
	{"akh", NULL, NULL, NULL, "Angal Heneng"},
	{"aki", NULL, NULL, NULL, "Aiome"},
	{"akj", NULL, NULL, NULL, "Aka-Jeru"},
	{"akk", "akk", "akk", NULL, "Akkadian"},
	{"akl", NULL, NULL, NULL, "Aklanon"},
	{"akm", NULL, NULL, NULL, "Aka-Bo"},
	{"ako", NULL, NULL, NULL, "Akurio"},
	{"akp", NULL, NULL, NULL, "Siwu"},
	{"akq", NULL, NULL, NULL, "Ak"},
	{"akr", NULL, NULL, NULL, "Araki"},
	{"aks", NULL, NULL, NULL, "Akaselem"},
	{"akt", NULL, NULL, NULL, "Akolet"},
	{"aku", NULL, NULL, NULL, "Akum"},
	{"akv", NULL, NULL, NULL, "Akhvakh"},
	{"akw", NULL, NULL, NULL, "Akwa"},
	{"akx", NULL, NULL, NULL, "Aka-Kede"},
	{"aky", NULL, NULL, NULL, "Aka-Kol"},
	{"akz", NULL, NULL, NULL, "Alabama"},
	{"ala", NULL, NULL, NULL, "Alago"},
	{"alc", NULL, NULL, NULL, "Qawasqar"},
	{"ald", NULL, NULL, NULL, "Alladian"},
	{"ale", "ale", "ale", NULL, "Aleut"},
	{"alf", NULL, NULL, NULL, "Alege"},
	{"alh", NULL, NULL, NULL, "Alawa"},
	{"ali", NULL, NULL, NULL, "Amaimon"},
	{"alj", NULL, NULL, NULL, "Alangan"},
	{"alk", NULL, NULL, NULL, "Alak"},
	{"all", NULL, NULL, NULL, "Allar"},
	{"alm", NULL, NULL, NULL, "Amblong"},
	{"aln", NULL, NULL, NULL, "Gheg Albanian"},
	{"alo", NULL, NULL, NULL, "Larike-Wakasihu"},
	{"alp", NULL, NULL, NULL, "Alune"},
	{"alq", NULL, NULL, NULL, "Algonquin"},
	{"alr", NULL, NULL, NULL, "Alutor"},
	{"als", NULL, NULL, NULL, "Tosk Albanian"},
	{"alt", "alt", "alt", NULL, "Southern Altai"},
	{"alu", NULL, NULL, NULL, "'Are'are"},
	{"alw", NULL, NULL, NULL, "Alaba-K’abeena"},
	{"alx", NULL, NULL, NULL, "Amol"},
	{"aly", NULL, NULL, NULL, "Alyawarr"},
	{"alz", NULL, NULL, NULL, "Alur"},
	{"ama", NULL, NULL, NULL, "Amanayé"},
	{"amb", NULL, NULL, NULL, "Ambo"},
	{"amc", NULL, NULL, NULL, "Amahuaca"},
	{"ame", NULL, NULL, NULL, "Yanesha'"},
	{"amf", NULL, NULL, NULL, "Hamer-Banna"},
	{"amg", NULL, NULL, NULL, "Amurdak"},
	{"amh", "amh", "amh", "am", "Amharic"},
	{"ami", NULL, NULL, NULL, "Amis"},
	{"amj", NULL, NULL, NULL, "Amdang"},
	{"amk", NULL, NULL, NULL, "Ambai"},
	{"aml", NULL, NULL, NULL, "War-Jaintia"},
	{"amm", NULL, NULL, NULL, "Ama (Papua New Guinea)"},
	{"amn", NULL, NULL, NULL, "Amanab"},
	{"amo", NULL, NULL, NULL, "Amo"},
	{"amp", NULL, NULL, NULL, "Alamblak"},
	{"amq", NULL, NULL, NULL, "Amahai"},
	{"amr", NULL, NULL, NULL, "Amarakaeri"},
	{"ams", NULL, NULL, NULL, "Southern Amami-Oshima"},
	{"amt", NULL, NULL, NULL, "Amto"},
	{"amu", NULL, NULL, NULL, "Guerrero Amuzgo"},
	{"amv", NULL, NULL, NULL, "Ambelau"},
	{"amw", NULL, NULL, NULL, "Western Neo-Aramaic"},
	{"amx", NULL, NULL, NULL, "Anmatyerre"},
	{"amy", NULL, NULL, NULL, "Ami"},
	{"amz", NULL, NULL, NULL, "Atampaya"},
	{"ana", NULL, NULL, NULL, "Andaqui"},
	{"anb", NULL, NULL, NULL, "Andoa"},
	{"anc", NULL, NULL, NULL, "Ngas"},
	{"and", NULL, NULL, NULL, "Ansus"},
	{"ane", NULL, NULL, NULL, "Xârâcùù"},
	{"anf", NULL, NULL, NULL, "Animere"},
	{"ang", "ang", "ang", NULL, "Old English (ca. 450-1100)"},
	{"anh", NULL, NULL, NULL, "Nend"},
	{"ani", NULL, NULL, NULL, "Andi"},
	{"anj", NULL, NULL, NULL, "Anor"},
	{"ank", NULL, NULL, NULL, "Goemai"},
	{"anl", NULL, NULL, NULL, "Anu-Hkongso Chin"},
	{"anm", NULL, NULL, NULL, "Anal"},
	{"ann", NULL, NULL, NULL, "Obolo"},
	{"ano", NULL, NULL, NULL, "Andoque"},
	{"anp", "anp", "anp", NULL, "Angika"},
	{"anq", NULL, NULL, NULL, "Jarawa (India)"},
	{"anr", NULL, NULL, NULL, "Andh"},
	{"ans", NULL, NULL, NULL, "Anserma"},
	{"ant", NULL, NULL, NULL, "Antakarinya"},
	{"anu", NULL, NULL, NULL, "Anuak"},
	{"anv", NULL, NULL, NULL, "Denya"},
	{"anw", NULL, NULL, NULL, "Anaang"},
	{"anx", NULL, NULL, NULL, "Andra-Hus"},
	{"any", NULL, NULL, NULL, "Anyin"},
	{"anz", NULL, NULL, NULL, "Anem"},
	{"aoa", NULL, NULL, NULL, "Angolar"},
	{"aob", NULL, NULL, NULL, "Abom"},
	{"aoc", NULL, NULL, NULL, "Pemon"},
	{"aod", NULL, NULL, NULL, "Andarum"},
	{"aoe", NULL, NULL, NULL, "Angal Enen"},
	{"aof", NULL, NULL, NULL, "Bragat"},
	{"aog", NULL, NULL, NULL, "Angoram"},
	{"aoi", NULL, NULL, NULL, "Anindilyakwa"},
	{"aoj", NULL, NULL, NULL, "Mufian"},
	{"aok", NULL, NULL, NULL, "Arhö"},
	{"aol", NULL, NULL, NULL, "Alor"},
	{"aom", NULL, NULL, NULL, "Ömie"},
	{"aon", NULL, NULL, NULL, "Bumbita Arapesh"},
	{"aor", NULL, NULL, NULL, "Aore"},
	{"aos", NULL, NULL, NULL, "Taikat"},
	{"aot", NULL, NULL, NULL, "Atong (India)"},
	{"aou", NULL, NULL, NULL, "A'ou"},
	{"aox", NULL, NULL, NULL, "Atorada"},
	{"aoz", NULL, NULL, NULL, "Uab Meto"},
	{"apb", NULL, NULL, NULL, "Sa'a"},
	{"apc", NULL, NULL, NULL, "North Levantine Arabic"},
	{"apd", NULL, NULL, NULL, "Sudanese Arabic"},
	{"ape", NULL, NULL, NULL, "Bukiyip"},
	{"apf", NULL, NULL, NULL, "Pahanan Agta"},
	{"apg", NULL, NULL, NULL, "Ampanang"},
	{"aph", NULL, NULL, NULL, "Athpariya"},
	{"api", NULL, NULL, NULL, "Apiaká"},
	{"apj", NULL, NULL, NULL, "Jicarilla Apache"},
	{"apk", NULL, NULL, NULL, "Kiowa Apache"},
	{"apl", NULL, NULL, NULL, "Lipan Apache"},
	{"apm", NULL, NULL, NULL, "Mescalero-Chiricahua Apache"},
	{"apn", NULL, NULL, NULL, "Apinayé"},
	{"apo", NULL, NULL, NULL, "Ambul"},
	{"app", NULL, NULL, NULL, "Apma"},
	{"apq", NULL, NULL, NULL, "A-Pucikwar"},
	{"apr", NULL, NULL, NULL, "Arop-Lokep"},
	{"aps", NULL, NULL, NULL, "Arop-Sissano"},
	{"apt", NULL, NULL, NULL, "Apatani"},
	{"apu", NULL, NULL, NULL, "Apurinã"},
	{"apv", NULL, NULL, NULL, "Alapmunte"},
	{"apw", NULL, NULL, NULL, "Western Apache"},
	{"apx", NULL, NULL, NULL, "Aputai"},
	{"apy", NULL, NULL, NULL, "Apalaí"},
	{"apz", NULL, NULL, NULL, "Safeyoka"},
	{"aqc", NULL, NULL, NULL, "Archi"},
	{"aqd", NULL, NULL, NULL, "Ampari Dogon"},
	{"aqg", NULL, NULL, NULL, "Arigidi"},
	{"aqk", NULL, NULL, NULL, "Aninka"},
	{"aqm", NULL, NULL, NULL, "Atohwaim"},
	{"aqn", NULL, NULL, NULL, "Northern Alta"},
	{"aqp", NULL, NULL, NULL, "Atakapa"},
	{"aqr", NULL, NULL, NULL, "Arhâ"},
	{"aqt", NULL, NULL, NULL, "Angaité"},
	{"aqz", NULL, NULL, NULL, "Akuntsu"},
	{"ara", "ara", "ara", "ar", "Arabic"},
	{"arb", NULL, NULL, NULL, "Standard Arabic"},
	{"arc", "arc", "arc", NULL, "Official Aramaic (700-300 BCE)"},
	{"ard", NULL, NULL, NULL, "Arabana"},
	{"are", NULL, NULL, NULL, "Western Arrarnta"},
	{"arg", "arg", "arg", "an", "Aragonese"},
	{"arh", NULL, NULL, NULL, "Arhuaco"},
	{"ari", NULL, NULL, NULL, "Arikara"},
	{"arj", NULL, NULL, NULL, "Arapaso"},
	{"ark", NULL, NULL, NULL, "Arikapú"},
	{"arl", NULL, NULL, NULL, "Arabela"},
	{"arn", "arn", "arn", NULL, "Mapudungun"},
	{"aro", NULL, NULL, NULL, "Araona"},
	{"arp", "arp", "arp", NULL, "Arapaho"},
	{"arq", NULL, NULL, NULL, "Algerian Arabic"},
	{"arr", NULL, NULL, NULL, "Karo (Brazil)"},
	{"ars", NULL, NULL, NULL, "Najdi Arabic"},
	{"aru", NULL, NULL, NULL, "Aruá (Amazonas State)"},
	{"arv", NULL, NULL, NULL, "Arbore"},
	{"arw", "arw", "arw", NULL, "Arawak"},
	{"arx", NULL, NULL, NULL, "Aruá (Rodonia State)"},
	{"ary", NULL, NULL, NULL, "Moroccan Arabic"},
	{"arz", NULL, NULL, NULL, "Egyptian Arabic"},
	{"asa", NULL, NULL, NULL, "Asu (Tanzania)"},
	{"asb", NULL, NULL, NULL, "Assiniboine"},
	{"asc", NULL, NULL, NULL, "Casuarina Coast Asmat"},
	{"ase", NULL, NULL, NULL, "American Sign Language"},
	{"asf", NULL, NULL, NULL, "Auslan"},
	{"asg", NULL, NULL, NULL, "Cishingini"},
	{"ash", NULL, NULL, NULL, "Abishira"},
	{"asi", NULL, NULL, NULL, "Buruwai"},
	{"asj", NULL, NULL, NULL, "Sari"},
	{"ask", NULL, NULL, NULL, "Ashkun"},
	{"asl", NULL, NULL, NULL, "Asilulu"},
	{"asm", "asm", "asm", "as", "Assamese"},
	{"asn", NULL, NULL, NULL, "Xingú Asuriní"},
	{"aso", NULL, NULL, NULL, "Dano"},
	{"asp", NULL, NULL, NULL, "Algerian Sign Language"},
	{"asq", NULL, NULL, NULL, "Austrian Sign Language"},
	{"asr", NULL, NULL, NULL, "Asuri"},
	{"ass", NULL, NULL, NULL, "Ipulo"},
	{"ast", "ast", "ast", NULL, "Asturian"},
	{"asu", NULL, NULL, NULL, "Tocantins Asurini"},
	{"asv", NULL, NULL, NULL, "Asoa"},
	{"asw", NULL, NULL, NULL, "Australian Aborigines Sign Language"},
	{"asx", NULL, NULL, NULL, "Muratayak"},
	{"asy", NULL, NULL, NULL, "Yaosakor Asmat"},
	{"asz", NULL, NULL, NULL, "As"},
	{"ata", NULL, NULL, NULL, "Pele-Ata"},
	{"atb", NULL, NULL, NULL, "Zaiwa"},
	{"atc", NULL, NULL, NULL, "Atsahuaca"},
	{"atd", NULL, NULL, NULL, "Ata Manobo"},
	{"ate", NULL, NULL, NULL, "Atemble"},
	{"atg", NULL, NULL, NULL, "Ivbie North-Okpela-Arhe"},
	{"ati", NULL, NULL, NULL, "Attié"},
	{"atj", NULL, NULL, NULL, "Atikamekw"},
	{"atk", NULL, NULL, NULL, "Ati"},
	{"atl", NULL, NULL, NULL, "Mt. Iraya Agta"},
	{"atm", NULL, NULL, NULL, "Ata"},
	{"atn", NULL, NULL, NULL, "Ashtiani"},
	{"ato", NULL, NULL, NULL, "Atong (Cameroon)"},
	{"atp", NULL, NULL, NULL, "Pudtol Atta"},
	{"atq", NULL, NULL, NULL, "Aralle-Tabulahan"},
	{"atr", NULL, NULL, NULL, "Waimiri-Atroari"},
	{"ats", NULL, NULL, NULL, "Gros Ventre"},
	{"att", NULL, NULL, NULL, "Pamplona Atta"},
	{"atu", NULL, NULL, NULL, "Reel"},
	{"atv", NULL, NULL, NULL, "Northern Altai"},
	{"atw", NULL, NULL, NULL, "Atsugewi"},
	{"atx", NULL, NULL, NULL, "Arutani"},
	{"aty", NULL, NULL, NULL, "Aneityum"},
	{"atz", NULL, NULL, NULL, "Arta"},
	{"aua", NULL, NULL, NULL, "Asumboa"},
	{"aub", NULL, NULL, NULL, "Alugu"},
	{"auc", NULL, NULL, NULL, "Waorani"},
	{"aud", NULL, NULL, NULL, "Anuta"},
	{"aug", NULL, NULL, NULL, "Aguna"},
	{"auh", NULL, NULL, NULL, "Aushi"},
	{"aui", NULL, NULL, NULL, "Anuki"},
	{"auj", NULL, NULL, NULL, "Awjilah"},
	{"auk", NULL, NULL, NULL, "Heyo"},
	{"aul", NULL, NULL, NULL, "Aulua"},
	{"aum", NULL, NULL, NULL, "Asu (Nigeria)"},
	{"aun", NULL, NULL, NULL, "Molmo One"},
	{"auo", NULL, NULL, NULL, "Auyokawa"},
	{"aup", NULL, NULL, NULL, "Makayam"},
	{"auq", NULL, NULL, NULL, "Anus"},
	{"aur", NULL, NULL, NULL, "Aruek"},
	{"aut", NULL, NULL, NULL, "Austral"},
	{"auu", NULL, NULL, NULL, "Auye"},
	{"auw", NULL, NULL, NULL, "Awyi"},
	{"aux", NULL, NULL, NULL, "Aurá"},
	{"auy", NULL, NULL, NULL, "Awiyaana"},
	{"auz", NULL, NULL, NULL, "Uzbeki Arabic"},
	{"ava", "ava", "ava", "av", "Avaric"},
	{"avb", NULL, NULL, NULL, "Avau"},
	{"avd", NULL, NULL, NULL, "Alviri-Vidari"},
	{"ave", "ave", "ave", "ae", "Avestan"},
	{"avi", NULL, NULL, NULL, "Avikam"},
	{"avk", NULL, NULL, NULL, "Kotava"},
	{"avl", NULL, NULL, NULL, "Eastern Egyptian Bedawi Arabic"},
	{"avm", NULL, NULL, NULL, "Angkamuthi"},
	{"avn", NULL, NULL, NULL, "Avatime"},
	{"avo", NULL, NULL, NULL, "Agavotaguerra"},
	{"avs", NULL, NULL, NULL, "Aushiri"},
	{"avt", NULL, NULL, NULL, "Au"},
	{"avu", NULL, NULL, NULL, "Avokaya"},
	{"avv", NULL, NULL, NULL, "Avá-Canoeiro"},
	{"awa", "awa", "awa", NULL, "Awadhi"},
	{"awb", NULL, NULL, NULL, "Awa (Papua New Guinea)"},
	{"awc", NULL, NULL, NULL, "Cicipu"},
	{"awe", NULL, NULL, NULL, "Awetí"},
	{"awg", NULL, NULL, NULL, "Anguthimri"},
	{"awh", NULL, NULL, NULL, "Awbono"},
	{"awi", NULL, NULL, NULL, "Aekyom"},
	{"awk", NULL, NULL, NULL, "Awabakal"},
	{"awm", NULL, NULL, NULL, "Arawum"},
	{"awn", NULL, NULL, NULL, "Awngi"},
	{"awo", NULL, NULL, NULL, "Awak"},
	{"awr", NULL, NULL, NULL, "Awera"},
	{"aws", NULL, NULL, NULL, "South Awyu"},
	{"awt", NULL, NULL, NULL, "Araweté"},
	{"awu", NULL, NULL, NULL, "Central Awyu"},
	{"awv", NULL, NULL, NULL, "Jair Awyu"},
	{"aww", NULL, NULL, NULL, "Awun"},
	{"awx", NULL, NULL, NULL, "Awara"},
	{"awy", NULL, NULL, NULL, "Edera Awyu"},
	{"axb", NULL, NULL, NULL, "Abipon"},
	{"axe", NULL, NULL, NULL, "Ayerrerenge"},
	{"axg", NULL, NULL, NULL, "Mato Grosso Arára"},
	{"axk", NULL, NULL, NULL, "Yaka (Central African Republic)"},
	{"axl", NULL, NULL, NULL, "Lower Southern Aranda"},
	{"axm", NULL, NULL, NULL, "Middle Armenian"},
	{"axx", NULL, NULL, NULL, "Xârâgurè"},
	{"aya", NULL, NULL, NULL, "Awar"},
	{"ayb", NULL, NULL, NULL, "Ayizo Gbe"},
	{"ayc", NULL, NULL, NULL, "Southern Aymara"},
	{"ayd", NULL, NULL, NULL, "Ayabadhu"},
	{"aye", NULL, NULL, NULL, "Ayere"},
	{"ayg", NULL, NULL, NULL, "Ginyanga"},
	{"ayh", NULL, NULL, NULL, "Hadrami Arabic"},
	{"ayi", NULL, NULL, NULL, "Leyigha"},
	{"ayk", NULL, NULL, NULL, "Akuku"},
	{"ayl", NULL, NULL, NULL, "Libyan Arabic"},
	{"aym", "aym", "aym", "ay", "Aymara"},
	{"ayn", NULL, NULL, NULL, "Sanaani Arabic"},
	{"ayo", NULL, NULL, NULL, "Ayoreo"},
	{"ayp", NULL, NULL, NULL, "North Mesopotamian Arabic"},
	{"ayq", NULL, NULL, NULL, "Ayi (Papua New Guinea)"},
	{"ayr", NULL, NULL, NULL, "Central Aymara"},
	{"ays", NULL, NULL, NULL, "Sorsogon Ayta"},
	{"ayt", NULL, NULL, NULL, "Magbukun Ayta"},
	{"ayu", NULL, NULL, NULL, "Ayu"},
	{"ayz", NULL, NULL, NULL, "Mai Brat"},
	{"aza", NULL, NULL, NULL, "Azha"},
	{"azb", NULL, NULL, NULL, "South Azerbaijani"},
	{"azd", NULL, NULL, NULL, "Eastern Durango Nahuatl"},
	{"aze", "aze", "aze", "az", "Azerbaijani"},
	{"azg", NULL, NULL, NULL, "San Pedro Amuzgos Amuzgo"},
	{"azj", NULL, NULL, NULL, "North Azerbaijani"},
	{"azm", NULL, NULL, NULL, "Ipalapa Amuzgo"},
	{"azn", NULL, NULL, NULL, "Western Durango Nahuatl"},
	{"azo", NULL, NULL, NULL, "Awing"},
	{"azt", NULL, NULL, NULL, "Faire Atta"},
	{"azz", NULL, NULL, NULL, "Highland Puebla Nahuatl"},
	{"baa", NULL, NULL, NULL, "Babatana"},
	{"bab", NULL, NULL, NULL, "Bainouk-Gunyuño"},
	{"bac", NULL, NULL, NULL, "Badui"},
	{"bae", NULL, NULL, NULL, "Baré"},
	{"baf", NULL, NULL, NULL, "Nubaca"},
	{"bag", NULL, NULL, NULL, "Tuki"},
	{"bah", NULL, NULL, NULL, "Bahamas Creole English"},
	{"baj", NULL, NULL, NULL, "Barakai"},
	{"bak", "bak", "bak", "ba", "Bashkir"},
	{"bal", "bal", "bal", NULL, "Baluchi"},
	{"bam", "bam", "bam", "bm", "Bambara"},
	{"ban", "ban", "ban", NULL, "Balinese"},
	{"bao", NULL, NULL, NULL, "Waimaha"},
	{"bap", NULL, NULL, NULL, "Bantawa"},
	{"bar", NULL, NULL, NULL, "Bavarian"},
	{"bas", "bas", "bas", NULL, "Basa (Cameroon)"},
	{"bau", NULL, NULL, NULL, "Bada (Nigeria)"},
	{"bav", NULL, NULL, NULL, "Vengo"},
	{"baw", NULL, NULL, NULL, "Bambili-Bambui"},
	{"bax", NULL, NULL, NULL, "Bamun"},
	{"bay", NULL, NULL, NULL, "Batuley"},
	{"bba", NULL, NULL, NULL, "Baatonum"},
	{"bbb", NULL, NULL, NULL, "Barai"},
	{"bbc", NULL, NULL, NULL, "Batak Toba"},
	{"bbd", NULL, NULL, NULL, "Bau"},
	{"bbe", NULL, NULL, NULL, "Bangba"},
	{"bbf", NULL, NULL, NULL, "Baibai"},
	{"bbg", NULL, NULL, NULL, "Barama"},
	{"bbh", NULL, NULL, NULL, "Bugan"},
	{"bbi", NULL, NULL, NULL, "Barombi"},
	{"bbj", NULL, NULL, NULL, "Ghomálá'"},
	{"bbk", NULL, NULL, NULL, "Babanki"},
	{"bbl", NULL, NULL, NULL, "Bats"},
	{"bbm", NULL, NULL, NULL, "Babango"},
	{"bbn", NULL, NULL, NULL, "Uneapa"},
	{"bbo", NULL, NULL, NULL, "Northern Bobo Madaré"},
	{"bbp", NULL, NULL, NULL, "West Central Banda"},
	{"bbq", NULL, NULL, NULL, "Bamali"},
	{"bbr", NULL, NULL, NULL, "Girawa"},
	{"bbs", NULL, NULL, NULL, "Bakpinka"},
	{"bbt", NULL, NULL, NULL, "Mburku"},
	{"bbu", NULL, NULL, NULL, "Kulung (Nigeria)"},
	{"bbv", NULL, NULL, NULL, "Karnai"},
	{"bbw", NULL, NULL, NULL, "Baba"},
	{"bbx", NULL, NULL, NULL, "Bubia"},
	{"bby", NULL, NULL, NULL, "Befang"},
	{"bca", NULL, NULL, NULL, "Central Bai"},
	{"bcb", NULL, NULL, NULL, "Bainouk-Samik"},
	{"bcc", NULL, NULL, NULL, "Southern Balochi"},
	{"bcd", NULL, NULL, NULL, "North Babar"},
	{"bce", NULL, NULL, NULL, "Bamenyam"},
	{"bcf", NULL, NULL, NULL, "Bamu"},
	{"bcg", NULL, NULL, NULL, "Baga Pokur"},
	{"bch", NULL, NULL, NULL, "Bariai"},
	{"bci", NULL, NULL, NULL, "Baoulé"},
	{"bcj", NULL, NULL, NULL, "Bardi"},
	{"bck", NULL, NULL, NULL, "Bunuba"},
	{"bcl", NULL, NULL, NULL, "Central Bikol"},
	{"bcm", NULL, NULL, NULL, "Bannoni"},
	{"bcn", NULL, NULL, NULL, "Bali (Nigeria)"},
	{"bco", NULL, NULL, NULL, "Kaluli"},
	{"bcp", NULL, NULL, NULL, "Bali (Democratic Republic of Congo)"},
	{"bcq", NULL, NULL, NULL, "Bench"},
	{"bcr", NULL, NULL, NULL, "Babine"},
	{"bcs", NULL, NULL, NULL, "Kohumono"},
	{"bct", NULL, NULL, NULL, "Bendi"},
	{"bcu", NULL, NULL, NULL, "Awad Bing"},
	{"bcv", NULL, NULL, NULL, "Shoo-Minda-Nye"},
	{"bcw", NULL, NULL, NULL, "Bana"},
	{"bcy", NULL, NULL, NULL, "Bacama"},
	{"bcz", NULL, NULL, NULL, "Bainouk-Gunyaamolo"},
	{"bda", NULL, NULL, NULL, "Bayot"},
	{"bdb", NULL, NULL, NULL, "Basap"},
	{"bdc", NULL, NULL, NULL, "Emberá-Baudó"},
	{"bdd", NULL, NULL, NULL, "Bunama"},
	{"bde", NULL, NULL, NULL, "Bade"},
	{"bdf", NULL, NULL, NULL, "Biage"},
	{"bdg", NULL, NULL, NULL, "Bonggi"},
	{"bdh", NULL, NULL, NULL, "Baka (South Sudan)"},
	{"bdi", NULL, NULL, NULL, "Burun"},
	{"bdj", NULL, NULL, NULL, "Bai (South Sudan)"},
	{"bdk", NULL, NULL, NULL, "Budukh"},
	{"bdl", NULL, NULL, NULL, "Indonesian Bajau"},
	{"bdm", NULL, NULL, NULL, "Buduma"},
	{"bdn", NULL, NULL, NULL, "Baldemu"},
	{"bdo", NULL, NULL, NULL, "Morom"},
	{"bdp", NULL, NULL, NULL, "Bende"},
	{"bdq", NULL, NULL, NULL, "Bahnar"},
	{"bdr", NULL, NULL, NULL, "West Coast Bajau"},
	{"bds", NULL, NULL, NULL, "Burunge"},
	{"bdt", NULL, NULL, NULL, "Bokoto"},
	{"bdu", NULL, NULL, NULL, "Oroko"},
	{"bdv", NULL, NULL, NULL, "Bodo Parja"},
	{"bdw", NULL, NULL, NULL, "Baham"},
	{"bdx", NULL, NULL, NULL, "Budong-Budong"},
	{"bdy", NULL, NULL, NULL, "Bandjalang"},
	{"bdz", NULL, NULL, NULL, "Badeshi"},
	{"bea", NULL, NULL, NULL, "Beaver"},
	{"beb", NULL, NULL, NULL, "Bebele"},
	{"bec", NULL, NULL, NULL, "Iceve-Maci"},
	{"bed", NULL, NULL, NULL, "Bedoanas"},
	{"bee", NULL, NULL, NULL, "Byangsi"},
	{"bef", NULL, NULL, NULL, "Benabena"},
	{"beg", NULL, NULL, NULL, "Belait"},
	{"beh", NULL, NULL, NULL, "Biali"},
	{"bei", NULL, NULL, NULL, "Bekati'"},
	{"bej", "bej", "bej", NULL, "Beja"},
	{"bek", NULL, NULL, NULL, "Bebeli"},
	{"bel", "bel", "bel", "be", "Belarusian"},
	{"bem", "bem", "bem", NULL, "Bemba (Zambia)"},
	{"ben", "ben", "ben", "bn", "Bengali"},
	{"beo", NULL, NULL, NULL, "Beami"},
	{"bep", NULL, NULL, NULL, "Besoa"},
	{"beq", NULL, NULL, NULL, "Beembe"},
	{"bes", NULL, NULL, NULL, "Besme"},
	{"bet", NULL, NULL, NULL, "Guiberoua Béte"},
	{"beu", NULL, NULL, NULL, "Blagar"},
	{"bev", NULL, NULL, NULL, "Daloa Bété"},
	{"bew", NULL, NULL, NULL, "Betawi"},
	{"bex", NULL, NULL, NULL, "Jur Modo"},
	{"bey", NULL, NULL, NULL, "Beli (Papua New Guinea)"},
	{"bez", NULL, NULL, NULL, "Bena (Tanzania)"},
	{"bfa", NULL, NULL, NULL, "Bari"},
	{"bfb", NULL, NULL, NULL, "Pauri Bareli"},
	{"bfc", NULL, NULL, NULL, "Panyi Bai"},
	{"bfd", NULL, NULL, NULL, "Bafut"},
	{"bfe", NULL, NULL, NULL, "Betaf"},
	{"bff", NULL, NULL, NULL, "Bofi"},
	{"bfg", NULL, NULL, NULL, "Busang Kayan"},
	{"bfh", NULL, NULL, NULL, "Blafe"},
	{"bfi", NULL, NULL, NULL, "British Sign Language"},
	{"bfj", NULL, NULL, NULL, "Bafanji"},
	{"bfk", NULL, NULL, NULL, "Ban Khor Sign Language"},
	{"bfl", NULL, NULL, NULL, "Banda-Ndélé"},
	{"bfm", NULL, NULL, NULL, "Mmen"},
	{"bfn", NULL, NULL, NULL, "Bunak"},
	{"bfo", NULL, NULL, NULL, "Malba Birifor"},
	{"bfp", NULL, NULL, NULL, "Beba"},
	{"bfq", NULL, NULL, NULL, "Badaga"},
	{"bfr", NULL, NULL, NULL, "Bazigar"},
	{"bfs", NULL, NULL, NULL, "Southern Bai"},
	{"bft", NULL, NULL, NULL, "Balti"},
	{"bfu", NULL, NULL, NULL, "Gahri"},
	{"bfw", NULL, NULL, NULL, "Bondo"},
	{"bfx", NULL, NULL, NULL, "Bantayanon"},
	{"bfy", NULL, NULL, NULL, "Bagheli"},
	{"bfz", NULL, NULL, NULL, "Mahasu Pahari"},
	{"bga", NULL, NULL, NULL, "Gwamhi-Wuri"},
	{"bgb", NULL, NULL, NULL, "Bobongko"},
	{"bgc", NULL, NULL, NULL, "Haryanvi"},
	{"bgd", NULL, NULL, NULL, "Rathwi Bareli"},
	{"bge", NULL, NULL, NULL, "Bauria"},
	{"bgf", NULL, NULL, NULL, "Bangandu"},
	{"bgg", NULL, NULL, NULL, "Bugun"},
	{"bgi", NULL, NULL, NULL, "Giangan"},
	{"bgj", NULL, NULL, NULL, "Bangolan"},
	{"bgk", NULL, NULL, NULL, "Bit"},
	{"bgl", NULL, NULL, NULL, "Bo (Laos)"},
	{"bgn", NULL, NULL, NULL, "Western Balochi"},
	{"bgo", NULL, NULL, NULL, "Baga Koga"},
	{"bgp", NULL, NULL, NULL, "Eastern Balochi"},
	{"bgq", NULL, NULL, NULL, "Bagri"},
	{"bgr", NULL, NULL, NULL, "Bawm Chin"},
	{"bgs", NULL, NULL, NULL, "Tagabawa"},
	{"bgt", NULL, NULL, NULL, "Bughotu"},
	{"bgu", NULL, NULL, NULL, "Mbongno"},
	{"bgv", NULL, NULL, NULL, "Warkay-Bipim"},
	{"bgw", NULL, NULL, NULL, "Bhatri"},
	{"bgx", NULL, NULL, NULL, "Balkan Gagauz Turkish"},
	{"bgy", NULL, NULL, NULL, "Benggoi"},
	{"bgz", NULL, NULL, NULL, "Banggai"},
	{"bha", NULL, NULL, NULL, "Bharia"},
	{"bhb", NULL, NULL, NULL, "Bhili"},
	{"bhc", NULL, NULL, NULL, "Biga"},
	{"bhd", NULL, NULL, NULL, "Bhadrawahi"},
	{"bhe", NULL, NULL, NULL, "Bhaya"},
	{"bhf", NULL, NULL, NULL, "Odiai"},
	{"bhg", NULL, NULL, NULL, "Binandere"},
	{"bhh", NULL, NULL, NULL, "Bukharic"},
	{"bhi", NULL, NULL, NULL, "Bhilali"},
	{"bhj", NULL, NULL, NULL, "Bahing"},
	{"bhl", NULL, NULL, NULL, "Bimin"},
	{"bhm", NULL, NULL, NULL, "Bathari"},
	{"bhn", NULL, NULL, NULL, "Bohtan Neo-Aramaic"},
	{"bho", "bho", "bho", NULL, "Bhojpuri"},
	{"bhp", NULL, NULL, NULL, "Bima"},
	{"bhq", NULL, NULL, NULL, "Tukang Besi South"},
	{"bhr", NULL, NULL, NULL, "Bara Malagasy"},
	{"bhs", NULL, NULL, NULL, "Buwal"},
	{"bht", NULL, NULL, NULL, "Bhattiyali"},
	{"bhu", NULL, NULL, NULL, "Bhunjia"},
	{"bhv", NULL, NULL, NULL, "Bahau"},
	{"bhw", NULL, NULL, NULL, "Biak"},
	{"bhx", NULL, NULL, NULL, "Bhalay"},
	{"bhy", NULL, NULL, NULL, "Bhele"},
	{"bhz", NULL, NULL, NULL, "Bada (Indonesia)"},
	{"bia", NULL, NULL, NULL, "Badimaya"},
	{"bib", NULL, NULL, NULL, "Bissa"},
	{"bid", NULL, NULL, NULL, "Bidiyo"},
	{"bie", NULL, NULL, NULL, "Bepour"},
	{"bif", NULL, NULL, NULL, "Biafada"},
	{"big", NULL, NULL, NULL, "Biangai"},
	{"bik", "bik", "bik", NULL, "Bikol"},
	{"bil", NULL, NULL, NULL, "Bile"},
	{"bim", NULL, NULL, NULL, "Bimoba"},
	{"bin", "bin", "bin", NULL, "Bini"},
	{"bio", NULL, NULL, NULL, "Nai"},
	{"bip", NULL, NULL, NULL, "Bila"},
	{"biq", NULL, NULL, NULL, "Bipi"},
	{"bir", NULL, NULL, NULL, "Bisorio"},
	{"bis", "bis", "bis", "bi", "Bislama"},
	{"bit", NULL, NULL, NULL, "Berinomo"},
	{"biu", NULL, NULL, NULL, "Biete"},
	{"biv", NULL, NULL, NULL, "Southern Birifor"},
	{"biw", NULL, NULL, NULL, "Kol (Cameroon)"},
	{"bix", NULL, NULL, NULL, "Bijori"},
	{"biy", NULL, NULL, NULL, "Birhor"},
	{"biz", NULL, NULL, NULL, "Baloi"},
	{"bja", NULL, NULL, NULL, "Budza"},
	{"bjb", NULL, NULL, NULL, "Banggarla"},
	{"bjc", NULL, NULL, NULL, "Bariji"},
	{"bje", NULL, NULL, NULL, "Biao-Jiao Mien"},
	{"bjf", NULL, NULL, NULL, "Barzani Jewish Neo-Aramaic"},
	{"bjg", NULL, NULL, NULL, "Bidyogo"},
	{"bjh", NULL, NULL, NULL, "Bahinemo"},
	{"bji", NULL, NULL, NULL, "Burji"},
	{"bjj", NULL, NULL, NULL, "Kanauji"},
	{"bjk", NULL, NULL, NULL, "Barok"},
	{"bjl", NULL, NULL, NULL, "Bulu (Papua New Guinea)"},
	{"bjm", NULL, NULL, NULL, "Bajelani"},
	{"bjn", NULL, NULL, NULL, "Banjar"},
	{"bjo", NULL, NULL, NULL, "Mid-Southern Banda"},
	{"bjp", NULL, NULL, NULL, "Fanamaket"},
	{"bjr", NULL, NULL, NULL, "Binumarien"},
	{"bjs", NULL, NULL, NULL, "Bajan"},
	{"bjt", NULL, NULL, NULL, "Balanta-Ganja"},
	{"bju", NULL, NULL, NULL, "Busuu"},
	{"bjv", NULL, NULL, NULL, "Bedjond"},
	{"bjw", NULL, NULL, NULL, "Bakwé"},
	{"bjx", NULL, NULL, NULL, "Banao Itneg"},
	{"bjy", NULL, NULL, NULL, "Bayali"},
	{"bjz", NULL, NULL, NULL, "Baruga"},
	{"bka", NULL, NULL, NULL, "Kyak"},
	{"bkc", NULL, NULL, NULL, "Baka (Cameroon)"},
	{"bkd", NULL, NULL, NULL, "Binukid"},
	{"bkf", NULL, NULL, NULL, "Beeke"},
	{"bkg", NULL, NULL, NULL, "Buraka"},
	{"bkh", NULL, NULL, NULL, "Bakoko"},
	{"bki", NULL, NULL, NULL, "Baki"},
	{"bkj", NULL, NULL, NULL, "Pande"},
	{"bkk", NULL, NULL, NULL, "Brokskat"},
	{"bkl", NULL, NULL, NULL, "Berik"},
	{"bkm", NULL, NULL, NULL, "Kom (Cameroon)"},
	{"bkn", NULL, NULL, NULL, "Bukitan"},
	{"bko", NULL, NULL, NULL, "Kwa'"},
	{"bkp", NULL, NULL, NULL, "Boko (Democratic Republic of Congo)"},
	{"bkq", NULL, NULL, NULL, "Bakairí"},
	{"bkr", NULL, NULL, NULL, "Bakumpai"},
	{"bks", NULL, NULL, NULL, "Northern Sorsoganon"},
	{"bkt", NULL, NULL, NULL, "Boloki"},
	{"bku", NULL, NULL, NULL, "Buhid"},
	{"bkv", NULL, NULL, NULL, "Bekwarra"},
	{"bkw", NULL, NULL, NULL, "Bekwel"},
	{"bkx", NULL, NULL, NULL, "Baikeno"},
	{"bky", NULL, NULL, NULL, "Bokyi"},
	{"bkz", NULL, NULL, NULL, "Bungku"},
	{"bla", "bla", "bla", NULL, "Siksika"},
	{"blb", NULL, NULL, NULL, "Bilua"},
	{"blc", NULL, NULL, NULL, "Bella Coola"},
	{"bld", NULL, NULL, NULL, "Bolango"},
	{"ble", NULL, NULL, NULL, "Balanta-Kentohe"},
	{"blf", NULL, NULL, NULL, "Buol"},
	{"blh", NULL, NULL, NULL, "Kuwaa"},
	{"bli", NULL, NULL, NULL, "Bolia"},
	{"blj", NULL, NULL, NULL, "Bolongan"},
	{"blk", NULL, NULL, NULL, "Pa'o Karen"},
	{"bll", NULL, NULL, NULL, "Biloxi"},
	{"blm", NULL, NULL, NULL, "Beli (South Sudan)"},
	{"bln", NULL, NULL, NULL, "Southern Catanduanes Bikol"},
	{"blo", NULL, NULL, NULL, "Anii"},
	{"blp", NULL, NULL, NULL, "Blablanga"},
	{"blq", NULL, NULL, NULL, "Baluan-Pam"},
	{"blr", NULL, NULL, NULL, "Blang"},
	{"bls", NULL, NULL, NULL, "Balaesang"},
	{"blt", NULL, NULL, NULL, "Tai Dam"},
	{"blv", NULL, NULL, NULL, "Kibala"},
	{"blw", NULL, NULL, NULL, "Balangao"},
	{"blx", NULL, NULL, NULL, "Mag-Indi Ayta"},
	{"bly", NULL, NULL, NULL, "Notre"},
	{"blz", NULL, NULL, NULL, "Balantak"},
	{"bma", NULL, NULL, NULL, "Lame"},
	{"bmb", NULL, NULL, NULL, "Bembe"},
	{"bmc", NULL, NULL, NULL, "Biem"},
	{"bmd", NULL, NULL, NULL, "Baga Manduri"},
	{"bme", NULL, NULL, NULL, "Limassa"},
	{"bmf", NULL, NULL, NULL, "Bom-Kim"},
	{"bmg", NULL, NULL, NULL, "Bamwe"},
	{"bmh", NULL, NULL, NULL, "Kein"},
	{"bmi", NULL, NULL, NULL, "Bagirmi"},
	{"bmj", NULL, NULL, NULL, "Bote-Majhi"},
	{"bmk", NULL, NULL, NULL, "Ghayavi"},
	{"bml", NULL, NULL, NULL, "Bomboli"},
	{"bmm", NULL, NULL, NULL, "Northern Betsimisaraka Malagasy"},
	{"bmn", NULL, NULL, NULL, "Bina (Papua New Guinea)"},
	{"bmo", NULL, NULL, NULL, "Bambalang"},
	{"bmp", NULL, NULL, NULL, "Bulgebi"},
	{"bmq", NULL, NULL, NULL, "Bomu"},
	{"bmr", NULL, NULL, NULL, "Muinane"},
	{"bms", NULL, NULL, NULL, "Bilma Kanuri"},
	{"bmt", NULL, NULL, NULL, "Biao Mon"},
	{"bmu", NULL, NULL, NULL, "Somba-Siawari"},
	{"bmv", NULL, NULL, NULL, "Bum"},
	{"bmw", NULL, NULL, NULL, "Bomwali"},
	{"bmx", NULL, NULL, NULL, "Baimak"},
	{"bmz", NULL, NULL, NULL, "Baramu"},
	{"bna", NULL, NULL, NULL, "Bonerate"},
	{"bnb", NULL, NULL, NULL, "Bookan"},
	{"bnc", NULL, NULL, NULL, "Bontok"},
	{"bnd", NULL, NULL, NULL, "Banda (Indonesia)"},
	{"bne", NULL, NULL, NULL, "Bintauna"},
	{"bnf", NULL, NULL, NULL, "Masiwang"},
	{"bng", NULL, NULL, NULL, "Benga"},
	{"bni", NULL, NULL, NULL, "Bangi"},
	{"bnj", NULL, NULL, NULL, "Eastern Tawbuid"},
	{"bnk", NULL, NULL, NULL, "Bierebo"},
	{"bnl", NULL, NULL, NULL, "Boon"},
	{"bnm", NULL, NULL, NULL, "Batanga"},
	{"bnn", NULL, NULL, NULL, "Bunun"},
	{"bno", NULL, NULL, NULL, "Bantoanon"},
	{"bnp", NULL, NULL, NULL, "Bola"},
	{"bnq", NULL, NULL, NULL, "Bantik"},
	{"bnr", NULL, NULL, NULL, "Butmas-Tur"},
	{"bns", NULL, NULL, NULL, "Bundeli"},
	{"bnu", NULL, NULL, NULL, "Bentong"},
	{"bnv", NULL, NULL, NULL, "Bonerif"},
	{"bnw", NULL, NULL, NULL, "Bisis"},
	{"bnx", NULL, NULL, NULL, "Bangubangu"},
	{"bny", NULL, NULL, NULL, "Bintulu"},
	{"bnz", NULL, NULL, NULL, "Beezen"},
	{"boa", NULL, NULL, NULL, "Bora"},
	{"bob", NULL, NULL, NULL, "Aweer"},
	{"bod", "tib", "bod", "bo", "Tibetan"},
	{"boe", NULL, NULL, NULL, "Mundabli"},
	{"bof", NULL, NULL, NULL, "Bolon"},
	{"bog", NULL, NULL, NULL, "Bamako Sign Language"},
	{"boh", NULL, NULL, NULL, "Boma"},
	{"boi", NULL, NULL, NULL, "Barbareño"},
	{"boj", NULL, NULL, NULL, "Anjam"},
	{"bok", NULL, NULL, NULL, "Bonjo"},
	{"bol", NULL, NULL, NULL, "Bole"},
	{"bom", NULL, NULL, NULL, "Berom"},
	{"bon", NULL, NULL, NULL, "Bine"},
	{"boo", NULL, NULL, NULL, "Tiemacèwè Bozo"},
	{"bop", NULL, NULL, NULL, "Bonkiman"},
	{"boq", NULL, NULL, NULL, "Bogaya"},
	{"bor", NULL, NULL, NULL, "Borôro"},
	{"bos", "bos", "bos", "bs", "Bosnian"},
	{"bot", NULL, NULL, NULL, "Bongo"},
	{"bou", NULL, NULL, NULL, "Bondei"},
	{"bov", NULL, NULL, NULL, "Tuwuli"},
	{"bow", NULL, NULL, NULL, "Rema"},
	{"box", NULL, NULL, NULL, "Buamu"},
	{"boy", NULL, NULL, NULL, "Bodo (Central African Republic)"},
	{"boz", NULL, NULL, NULL, "Tiéyaxo Bozo"},
	{"bpa", NULL, NULL, NULL, "Daakaka"},
	{"bpd", NULL, NULL, NULL, "Banda-Banda"},
	{"bpe", NULL, NULL, NULL, "Bauni"},
	{"bpg", NULL, NULL, NULL, "Bonggo"},
	{"bph", NULL, NULL, NULL, "Botlikh"},
	{"bpi", NULL, NULL, NULL, "Bagupi"},
	{"bpj", NULL, NULL, NULL, "Binji"},
	{"bpk", NULL, NULL, NULL, "Orowe"},
	{"bpl", NULL, NULL, NULL, "Broome Pearling Lugger Pidgin"},
	{"bpm", NULL, NULL, NULL, "Biyom"},
	{"bpn", NULL, NULL, NULL, "Dzao Min"},
	{"bpo", NULL, NULL, NULL, "Anasi"},
	{"bpp", NULL, NULL, NULL, "Kaure"},
	{"bpq", NULL, NULL, NULL, "Banda Malay"},
	{"bpr", NULL, NULL, NULL, "Koronadal Blaan"},
	{"bps", NULL, NULL, NULL, "Sarangani Blaan"},
	{"bpt", NULL, NULL, NULL, "Barrow Point"},
	{"bpu", NULL, NULL, NULL, "Bongu"},
	{"bpv", NULL, NULL, NULL, "Bian Marind"},
	{"bpw", NULL, NULL, NULL, "Bo (Papua New Guinea)"},
	{"bpx", NULL, NULL, NULL, "Palya Bareli"},
	{"bpy", NULL, NULL, NULL, "Bishnupriya"},
	{"bpz", NULL, NULL, NULL, "Bilba"},
	{"bqa", NULL, NULL, NULL, "Tchumbuli"},
	{"bqb", NULL, NULL, NULL, "Bagusa"},
	{"bqc", NULL, NULL, NULL, "Boko (Benin)"},
	{"bqd", NULL, NULL, NULL, "Bung"},
	{"bqf", NULL, NULL, NULL, "Baga Kaloum"},
	{"bqg", NULL, NULL, NULL, "Bago-Kusuntu"},
	{"bqh", NULL, NULL, NULL, "Baima"},
	{"bqi", NULL, NULL, NULL, "Bakhtiari"},
	{"bqj", NULL, NULL, NULL, "Bandial"},
	{"bqk", NULL, NULL, NULL, "Banda-Mbrès"},
	{"bql", NULL, NULL, NULL, "Bilakura"},
	{"bqm", NULL, NULL, NULL, "Wumboko"},
	{"bqn", NULL, NULL, NULL, "Bulgarian Sign Language"},
	{"bqo", NULL, NULL, NULL, "Balo"},
	{"bqp", NULL, NULL, NULL, "Busa"},
	{"bqq", NULL, NULL, NULL, "Biritai"},
	{"bqr", NULL, NULL, NULL, "Burusu"},
	{"bqs", NULL, NULL, NULL, "Bosngun"},
	{"bqt", NULL, NULL, NULL, "Bamukumbit"},
	{"bqu", NULL, NULL, NULL, "Boguru"},
	{"bqv", NULL, NULL, NULL, "Koro Wachi"},
	{"bqw", NULL, NULL, NULL, "Buru (Nigeria)"},
	{"bqx", NULL, NULL, NULL, "Baangi"},
	{"bqy", NULL, NULL, NULL, "Bengkala Sign Language"},
	{"bqz", NULL, NULL, NULL, "Bakaka"},
	{"bra", "bra", "bra", NULL, "Braj"},
	{"brb", NULL, NULL, NULL, "Lave"},
	{"brc", NULL, NULL, NULL, "Berbice Creole Dutch"},
	{"brd", NULL, NULL, NULL, "Baraamu"},
	{"bre", "bre", "bre", "br", "Breton"},
	{"brf", NULL, NULL, NULL, "Bira"},
	{"brg", NULL, NULL, NULL, "Baure"},
	{"brh", NULL, NULL, NULL, "Brahui"},
	{"bri", NULL, NULL, NULL, "Mokpwe"},
	{"brj", NULL, NULL, NULL, "Bieria"},
	{"brk", NULL, NULL, NULL, "Birked"},
	{"brl", NULL, NULL, NULL, "Birwa"},
	{"brm", NULL, NULL, NULL, "Barambu"},
	{"brn", NULL, NULL, NULL, "Boruca"},
	{"bro", NULL, NULL, NULL, "Brokkat"},
	{"brp", NULL, NULL, NULL, "Barapasi"},
	{"brq", NULL, NULL, NULL, "Breri"},
	{"brr", NULL, NULL, NULL, "Birao"},
	{"brs", NULL, NULL, NULL, "Baras"},
	{"brt", NULL, NULL, NULL, "Bitare"},
	{"bru", NULL, NULL, NULL, "Eastern Bru"},
	{"brv", NULL, NULL, NULL, "Western Bru"},
	{"brw", NULL, NULL, NULL, "Bellari"},
	{"brx", NULL, NULL, NULL, "Bodo (India)"},
	{"bry", NULL, NULL, NULL, "Burui"},
	{"brz", NULL, NULL, NULL, "Bilbil"},
	{"bsa", NULL, NULL, NULL, "Abinomn"},
	{"bsb", NULL, NULL, NULL, "Brunei Bisaya"},
	{"bsc", NULL, NULL, NULL, "Bassari"},
	{"bse", NULL, NULL, NULL, "Wushi"},
	{"bsf", NULL, NULL, NULL, "Bauchi"},
	{"bsg", NULL, NULL, NULL, "Bashkardi"},
	{"bsh", NULL, NULL, NULL, "Kati"},
	{"bsi", NULL, NULL, NULL, "Bassossi"},
	{"bsj", NULL, NULL, NULL, "Bangwinji"},
	{"bsk", NULL, NULL, NULL, "Burushaski"},
	{"bsl", NULL, NULL, NULL, "Basa-Gumna"},
	{"bsm", NULL, NULL, NULL, "Busami"},
	{"bsn", NULL, NULL, NULL, "Barasana-Eduria"},
	{"bso", NULL, NULL, NULL, "Buso"},
	{"bsp", NULL, NULL, NULL, "Baga Sitemu"},
	{"bsq", NULL, NULL, NULL, "Bassa"},
	{"bsr", NULL, NULL, NULL, "Bassa-Kontagora"},
	{"bss", NULL, NULL, NULL, "Akoose"},
	{"bst", NULL, NULL, NULL, "Basketo"},
	{"bsu", NULL, NULL, NULL, "Bahonsuai"},
	{"bsv", NULL, NULL, NULL, "Baga Sobané"},
	{"bsw", NULL, NULL, NULL, "Baiso"},
	{"bsx", NULL, NULL, NULL, "Yangkam"},
	{"bsy", NULL, NULL, NULL, "Sabah Bisaya"},
	{"bta", NULL, NULL, NULL, "Bata"},
	{"btc", NULL, NULL, NULL, "Bati (Cameroon)"},
	{"btd", NULL, NULL, NULL, "Batak Dairi"},
	{"bte", NULL, NULL, NULL, "Gamo-Ningi"},
	{"btf", NULL, NULL, NULL, "Birgit"},
	{"btg", NULL, NULL, NULL, "Gagnoa Bété"},
	{"bth", NULL, NULL, NULL, "Biatah Bidayuh"},
	{"bti", NULL, NULL, NULL, "Burate"},
	{"btj", NULL, NULL, NULL, "Bacanese Malay"},
	{"btm", NULL, NULL, NULL, "Batak Mandailing"},
	{"btn", NULL, NULL, NULL, "Ratagnon"},
	{"bto", NULL, NULL, NULL, "Rinconada Bikol"},
	{"btp", NULL, NULL, NULL, "Budibud"},
	{"btq", NULL, NULL, NULL, "Batek"},
	{"btr", NULL, NULL, NULL, "Baetora"},
	{"bts", NULL, NULL, NULL, "Batak Simalungun"},
	{"btt", NULL, NULL, NULL, "Bete-Bendi"},
	{"btu", NULL, NULL, NULL, "Batu"},
	{"btv", NULL, NULL, NULL, "Bateri"},
	{"btw", NULL, NULL, NULL, "Butuanon"},
	{"btx", NULL, NULL, NULL, "Batak Karo"},
	{"bty", NULL, NULL, NULL, "Bobot"},
	{"btz", NULL, NULL, NULL, "Batak Alas-Kluet"},
	{"bua", "bua", "bua", NULL, "Buriat"},
	{"bub", NULL, NULL, NULL, "Bua"},
	{"buc", NULL, NULL, NULL, "Bushi"},
	{"bud", NULL, NULL, NULL, "Ntcham"},
	{"bue", NULL, NULL, NULL, "Beothuk"},
	{"buf", NULL, NULL, NULL, "Bushoong"},
	{"bug", "bug", "bug", NULL, "Buginese"},
	{"buh", NULL, NULL, NULL, "Younuo Bunu"},
	{"bui", NULL, NULL, NULL, "Bongili"},
	{"buj", NULL, NULL, NULL, "Basa-Gurmana"},
	{"buk", NULL, NULL, NULL, "Bugawac"},
	{"bul", "bul", "bul", "bg", "Bulgarian"},
	{"bum", NULL, NULL, NULL, "Bulu (Cameroon)"},
	{"bun", NULL, NULL, NULL, "Sherbro"},
	{"buo", NULL, NULL, NULL, "Terei"},
	{"bup", NULL, NULL, NULL, "Busoa"},
	{"buq", NULL, NULL, NULL, "Brem"},
	{"bus", NULL, NULL, NULL, "Bokobaru"},
	{"but", NULL, NULL, NULL, "Bungain"},
	{"buu", NULL, NULL, NULL, "Budu"},
	{"buv", NULL, NULL, NULL, "Bun"},
	{"buw", NULL, NULL, NULL, "Bubi"},
	{"bux", NULL, NULL, NULL, "Boghom"},
	{"buy", NULL, NULL, NULL, "Bullom So"},
	{"buz", NULL, NULL, NULL, "Bukwen"},
	{"bva", NULL, NULL, NULL, "Barein"},
	{"bvb", NULL, NULL, NULL, "Bube"},
	{"bvc", NULL, NULL, NULL, "Baelelea"},
	{"bvd", NULL, NULL, NULL, "Baeggu"},
	{"bve", NULL, NULL, NULL, "Berau Malay"},
	{"bvf", NULL, NULL, NULL, "Boor"},
	{"bvg", NULL, NULL, NULL, "Bonkeng"},
	{"bvh", NULL, NULL, NULL, "Bure"},
	{"bvi", NULL, NULL, NULL, "Belanda Viri"},
	{"bvj", NULL, NULL, NULL, "Baan"},
	{"bvk", NULL, NULL, NULL, "Bukat"},
	{"bvl", NULL, NULL, NULL, "Bolivian Sign Language"},
	{"bvm", NULL, NULL, NULL, "Bamunka"},
	{"bvn", NULL, NULL, NULL, "Buna"},
	{"bvo", NULL, NULL, NULL, "Bolgo"},
	{"bvp", NULL, NULL, NULL, "Bumang"},
	{"bvq", NULL, NULL, NULL, "Birri"},
	{"bvr", NULL, NULL, NULL, "Burarra"},
	{"bvt", NULL, NULL, NULL, "Bati (Indonesia)"},
	{"bvu", NULL, NULL, NULL, "Bukit Malay"},
	{"bvv", NULL, NULL, NULL, "Baniva"},
	{"bvw", NULL, NULL, NULL, "Boga"},
	{"bvx", NULL, NULL, NULL, "Dibole"},
	{"bvy", NULL, NULL, NULL, "Baybayanon"},
	{"bvz", NULL, NULL, NULL, "Bauzi"},
	{"bwa", NULL, NULL, NULL, "Bwatoo"},
	{"bwb", NULL, NULL, NULL, "Namosi-Naitasiri-Serua"},
	{"bwc", NULL, NULL, NULL, "Bwile"},
	{"bwd", NULL, NULL, NULL, "Bwaidoka"},
	{"bwe", NULL, NULL, NULL, "Bwe Karen"},
	{"bwf", NULL, NULL, NULL, "Boselewa"},
	{"bwg", NULL, NULL, NULL, "Barwe"},
	{"bwh", NULL, NULL, NULL, "Bishuo"},
	{"bwi", NULL, NULL, NULL, "Baniwa"},
	{"bwj", NULL, NULL, NULL, "Láá Láá Bwamu"},
	{"bwk", NULL, NULL, NULL, "Bauwaki"},
	{"bwl", NULL, NULL, NULL, "Bwela"},
	{"bwm", NULL, NULL, NULL, "Biwat"},
	{"bwn", NULL, NULL, NULL, "Wunai Bunu"},
	{"bwo", NULL, NULL, NULL, "Boro (Ethiopia)"},
	{"bwp", NULL, NULL, NULL, "Mandobo Bawah"},
	{"bwq", NULL, NULL, NULL, "Southern Bobo Madaré"},
	{"bwr", NULL, NULL, NULL, "Bura-Pabir"},
	{"bws", NULL, NULL, NULL, "Bomboma"},
	{"bwt", NULL, NULL, NULL, "Bafaw-Balong"},
	{"bwu", NULL, NULL, NULL, "Buli (Ghana)"},
	{"bww", NULL, NULL, NULL, "Bwa"},
	{"bwx", NULL, NULL, NULL, "Bu-Nao Bunu"},
	{"bwy", NULL, NULL, NULL, "Cwi Bwamu"},
	{"bwz", NULL, NULL, NULL, "Bwisi"},
	{"bxa", NULL, NULL, NULL, "Tairaha"},
	{"bxb", NULL, NULL, NULL, "Belanda Bor"},
	{"bxc", NULL, NULL, NULL, "Molengue"},
	{"bxd", NULL, NULL, NULL, "Pela"},
	{"bxe", NULL, NULL, NULL, "Birale"},
	{"bxf", NULL, NULL, NULL, "Bilur"},
	{"bxg", NULL, NULL, NULL, "Bangala"},
	{"bxh", NULL, NULL, NULL, "Buhutu"},
	{"bxi", NULL, NULL, NULL, "Pirlatapa"},
	{"bxj", NULL, NULL, NULL, "Bayungu"},
	{"bxk", NULL, NULL, NULL, "Bukusu"},
	{"bxl", NULL, NULL, NULL, "Jalkunan"},
	{"bxm", NULL, NULL, NULL, "Mongolia Buriat"},
	{"bxn", NULL, NULL, NULL, "Burduna"},
	{"bxo", NULL, NULL, NULL, "Barikanchi"},
	{"bxp", NULL, NULL, NULL, "Bebil"},
	{"bxq", NULL, NULL, NULL, "Beele"},
	{"bxr", NULL, NULL, NULL, "Russia Buriat"},
	{"bxs", NULL, NULL, NULL, "Busam"},
	{"bxu", NULL, NULL, NULL, "China Buriat"},
	{"bxv", NULL, NULL, NULL, "Berakou"},
	{"bxw", NULL, NULL, NULL, "Bankagooma"},
	{"bxz", NULL, NULL, NULL, "Binahari"},
	{"bya", NULL, NULL, NULL, "Batak"},
	{"byb", NULL, NULL, NULL, "Bikya"},
	{"byc", NULL, NULL, NULL, "Ubaghara"},
	{"byd", NULL, NULL, NULL, "Benyadu'"},
	{"bye", NULL, NULL, NULL, "Pouye"},
	{"byf", NULL, NULL, NULL, "Bete"},
	{"byg", NULL, NULL, NULL, "Baygo"},
	{"byh", NULL, NULL, NULL, "Bhujel"},
	{"byi", NULL, NULL, NULL, "Buyu"},
	{"byj", NULL, NULL, NULL, "Bina (Nigeria)"},
	{"byk", NULL, NULL, NULL, "Biao"},
	{"byl", NULL, NULL, NULL, "Bayono"},
	{"bym", NULL, NULL, NULL, "Bidjara"},
	{"byn", "byn", "byn", NULL, "Bilin"},
	{"byo", NULL, NULL, NULL, "Biyo"},
	{"byp", NULL, NULL, NULL, "Bumaji"},
	{"byq", NULL, NULL, NULL, "Basay"},
	{"byr", NULL, NULL, NULL, "Baruya"},
	{"bys", NULL, NULL, NULL, "Burak"},
	{"byt", NULL, NULL, NULL, "Berti"},
	{"byv", NULL, NULL, NULL, "Medumba"},
	{"byw", NULL, NULL, NULL, "Belhariya"},
	{"byx", NULL, NULL, NULL, "Qaqet"},
	{"byz", NULL, NULL, NULL, "Banaro"},
	{"bza", NULL, NULL, NULL, "Bandi"},
	{"bzb", NULL, NULL, NULL, "Andio"},
	{"bzc", NULL, NULL, NULL, "Southern Betsimisaraka Malagasy"},
	{"bzd", NULL, NULL, NULL, "Bribri"},
	{"bze", NULL, NULL, NULL, "Jenaama Bozo"},
	{"bzf", NULL, NULL, NULL, "Boikin"},
	{"bzg", NULL, NULL, NULL, "Babuza"},
	{"bzh", NULL, NULL, NULL, "Mapos Buang"},
	{"bzi", NULL, NULL, NULL, "Bisu"},
	{"bzj", NULL, NULL, NULL, "Belize Kriol English"},
	{"bzk", NULL, NULL, NULL, "Nicaragua Creole English"},
	{"bzl", NULL, NULL, NULL, "Boano (Sulawesi)"},
	{"bzm", NULL, NULL, NULL, "Bolondo"},
	{"bzn", NULL, NULL, NULL, "Boano (Maluku)"},
	{"bzo", NULL, NULL, NULL, "Bozaba"},
	{"bzp", NULL, NULL, NULL, "Kemberano"},
	{"bzq", NULL, NULL, NULL, "Buli (Indonesia)"},
	{"bzr", NULL, NULL, NULL, "Biri"},
	{"bzs", NULL, NULL, NULL, "Brazilian Sign Language"},
	{"bzt", NULL, NULL, NULL, "Brithenig"},
	{"bzu", NULL, NULL, NULL, "Burmeso"},
	{"bzv", NULL, NULL, NULL, "Naami"},
	{"bzw", NULL, NULL, NULL, "Basa (Nigeria)"},
	{"bzx", NULL, NULL, NULL, "Kɛlɛngaxo Bozo"},
	{"bzy", NULL, NULL, NULL, "Obanliku"},
	{"bzz", NULL, NULL, NULL, "Evant"},
	{"caa", NULL, NULL, NULL, "Chortí"},
	{"cab", NULL, NULL, NULL, "Garifuna"},
	{"cac", NULL, NULL, NULL, "Chuj"},
	{"cad", "cad", "cad", NULL, "Caddo"},
	{"cae", NULL, NULL, NULL, "Lehar"},
	{"caf", NULL, NULL, NULL, "Southern Carrier"},
	{"cag", NULL, NULL, NULL, "Nivaclé"},
	{"cah", NULL, NULL, NULL, "Cahuarano"},
	{"caj", NULL, NULL, NULL, "Chané"},
	{"cak", NULL, NULL, NULL, "Kaqchikel"},
	{"cal", NULL, NULL, NULL, "Carolinian"},
	{"cam", NULL, NULL, NULL, "Cemuhî"},
	{"can", NULL, NULL, NULL, "Chambri"},
	{"cao", NULL, NULL, NULL, "Chácobo"},
	{"cap", NULL, NULL, NULL, "Chipaya"},
	{"caq", NULL, NULL, NULL, "Car Nicobarese"},
	{"car", "car", "car", NULL, "Galibi Carib"},
	{"cas", NULL, NULL, NULL, "Tsimané"},
	{"cat", "cat", "cat", "ca", "Catalan"},
	{"cav", NULL, NULL, NULL, "Cavineña"},
	{"caw", NULL, NULL, NULL, "Callawalla"},
	{"cax", NULL, NULL, NULL, "Chiquitano"},
	{"cay", NULL, NULL, NULL, "Cayuga"},
	{"caz", NULL, NULL, NULL, "Canichana"},
	{"cbb", NULL, NULL, NULL, "Cabiyarí"},
	{"cbc", NULL, NULL, NULL, "Carapana"},
	{"cbd", NULL, NULL, NULL, "Carijona"},
	{"cbg", NULL, NULL, NULL, "Chimila"},
	{"cbi", NULL, NULL, NULL, "Chachi"},
	{"cbj", NULL, NULL, NULL, "Ede Cabe"},
	{"cbk", NULL, NULL, NULL, "Chavacano"},
	{"cbl", NULL, NULL, NULL, "Bualkhaw Chin"},
	{"cbn", NULL, NULL, NULL, "Nyahkur"},
	{"cbo", NULL, NULL, NULL, "Izora"},
	{"cbq", NULL, NULL, NULL, "Tsucuba"},
	{"cbr", NULL, NULL, NULL, "Cashibo-Cacataibo"},
	{"cbs", NULL, NULL, NULL, "Cashinahua"},
	{"cbt", NULL, NULL, NULL, "Chayahuita"},
	{"cbu", NULL, NULL, NULL, "Candoshi-Shapra"},
	{"cbv", NULL, NULL, NULL, "Cacua"},
	{"cbw", NULL, NULL, NULL, "Kinabalian"},
	{"cby", NULL, NULL, NULL, "Carabayo"},
	{"ccc", NULL, NULL, NULL, "Chamicuro"},
	{"ccd", NULL, NULL, NULL, "Cafundo Creole"},
	{"cce", NULL, NULL, NULL, "Chopi"},
	{"ccg", NULL, NULL, NULL, "Samba Daka"},
	{"cch", NULL, NULL, NULL, "Atsam"},
	{"ccj", NULL, NULL, NULL, "Kasanga"},
	{"ccl", NULL, NULL, NULL, "Cutchi-Swahili"},
	{"ccm", NULL, NULL, NULL, "Malaccan Creole Malay"},
	{"cco", NULL, NULL, NULL, "Comaltepec Chinantec"},
	{"ccp", NULL, NULL, NULL, "Chakma"},
	{"ccr", NULL, NULL, NULL, "Cacaopera"},
	{"cda", NULL, NULL, NULL, "Choni"},
	{"cde", NULL, NULL, NULL, "Chenchu"},
	{"cdf", NULL, NULL, NULL, "Chiru"},
	{"cdh", NULL, NULL, NULL, "Chambeali"},
	{"cdi", NULL, NULL, NULL, "Chodri"},
	{"cdj", NULL, NULL, NULL, "Churahi"},
	{"cdm", NULL, NULL, NULL, "Chepang"},
	{"cdn", NULL, NULL, NULL, "Chaudangsi"},
	{"cdo", NULL, NULL, NULL, "Min Dong Chinese"},
	{"cdr", NULL, NULL, NULL, "Cinda-Regi-Tiyal"},
	{"cds", NULL, NULL, NULL, "Chadian Sign Language"},
	{"cdy", NULL, NULL, NULL, "Chadong"},
	{"cdz", NULL, NULL, NULL, "Koda"},
	{"cea", NULL, NULL, NULL, "Lower Chehalis"},
	{"ceb", "ceb", "ceb", NULL, "Cebuano"},
	{"ceg", NULL, NULL, NULL, "Chamacoco"},
	{"cek", NULL, NULL, NULL, "Eastern Khumi Chin"},
	{"cen", NULL, NULL, NULL, "Cen"},
	{"ces", "cze", "ces", "cs", "Czech"},
	{"cet", NULL, NULL, NULL, "Centúúm"},
	{"cey", NULL, NULL, NULL, "Ekai Chin"},
	{"cfa", NULL, NULL, NULL, "Dijim-Bwilim"},
	{"cfd", NULL, NULL, NULL, "Cara"},
	{"cfg", NULL, NULL, NULL, "Como Karim"},
	{"cfm", NULL, NULL, NULL, "Falam Chin"},
	{"cga", NULL, NULL, NULL, "Changriwa"},
	{"cgc", NULL, NULL, NULL, "Kagayanen"},
	{"cgg", NULL, NULL, NULL, "Chiga"},
	{"cgk", NULL, NULL, NULL, "Chocangacakha"},
	{"cha", "cha", "cha", "ch", "Chamorro"},
	{"chb", "chb", "chb", NULL, "Chibcha"},
	{"chc", NULL, NULL, NULL, "Catawba"},
	{"chd", NULL, NULL, NULL, "Highland Oaxaca Chontal"},
	{"che", "che", "che", "ce", "Chechen"},
	{"chf", NULL, NULL, NULL, "Tabasco Chontal"},
	{"chg", "chg", "chg", NULL, "Chagatai"},
	{"chh", NULL, NULL, NULL, "Chinook"},
	{"chj", NULL, NULL, NULL, "Ojitlán Chinantec"},
	{"chk", "chk", "chk", NULL, "Chuukese"},
	{"chl", NULL, NULL, NULL, "Cahuilla"},
	{"chm", "chm", "chm", NULL, "Mari (Russia)"},
	{"chn", "chn", "chn", NULL, "Chinook jargon"},
	{"cho", "cho", "cho", NULL, "Choctaw"},
	{"chp", "chp", "chp", NULL, "Chipewyan"},
	{"chq", NULL, NULL, NULL, "Quiotepec Chinantec"},
	{"chr", "chr", "chr", NULL, "Cherokee"},
	{"cht", NULL, NULL, NULL, "Cholón"},
	{"chu", "chu", "chu", "cu", "Church Slavic"},
	{"chv", "chv", "chv", "cv", "Chuvash"},
	{"chw", NULL, NULL, NULL, "Chuwabu"},
	{"chx", NULL, NULL, NULL, "Chantyal"},
	{"chy", "chy", "chy", NULL, "Cheyenne"},
	{"chz", NULL, NULL, NULL, "Ozumacín Chinantec"},
	{"cia", NULL, NULL, NULL, "Cia-Cia"},
	{"cib", NULL, NULL, NULL, "Ci Gbe"},
	{"cic", NULL, NULL, NULL, "Chickasaw"},
	{"cid", NULL, NULL, NULL, "Chimariko"},
	{"cie", NULL, NULL, NULL, "Cineni"},
	{"cih", NULL, NULL, NULL, "Chinali"},
	{"cik", NULL, NULL, NULL, "Chitkuli Kinnauri"},
	{"cim", NULL, NULL, NULL, "Cimbrian"},
	{"cin", NULL, NULL, NULL, "Cinta Larga"},
	{"cip", NULL, NULL, NULL, "Chiapanec"},
	{"cir", NULL, NULL, NULL, "Tiri"},
	{"ciw", NULL, NULL, NULL, "Chippewa"},
	{"ciy", NULL, NULL, NULL, "Chaima"},
	{"cja", NULL, NULL, NULL, "Western Cham"},
	{"cje", NULL, NULL, NULL, "Chru"},
	{"cjh", NULL, NULL, NULL, "Upper Chehalis"},
	{"cji", NULL, NULL, NULL, "Chamalal"},
	{"cjk", NULL, NULL, NULL, "Chokwe"},
	{"cjm", NULL, NULL, NULL, "Eastern Cham"},
	{"cjn", NULL, NULL, NULL, "Chenapian"},
	{"cjo", NULL, NULL, NULL, "Ashéninka Pajonal"},
	{"cjp", NULL, NULL, NULL, "Cabécar"},
	{"cjs", NULL, NULL, NULL, "Shor"},
	{"cjv", NULL, NULL, NULL, "Chuave"},
	{"cjy", NULL, NULL, NULL, "Jinyu Chinese"},
	{"ckb", NULL, NULL, NULL, "Central Kurdish"},
	{"ckh", NULL, NULL, NULL, "Chak"},
	{"ckl", NULL, NULL, NULL, "Cibak"},
	{"ckm", NULL, NULL, NULL, "Chakavian"},
	{"ckn", NULL, NULL, NULL, "Kaang Chin"},
	{"cko", NULL, NULL, NULL, "Anufo"},
	{"ckq", NULL, NULL, NULL, "Kajakse"},
	{"ckr", NULL, NULL, NULL, "Kairak"},
	{"cks", NULL, NULL, NULL, "Tayo"},
	{"ckt", NULL, NULL, NULL, "Chukot"},
	{"cku", NULL, NULL, NULL, "Koasati"},
	{"ckv", NULL, NULL, NULL, "Kavalan"},
	{"ckx", NULL, NULL, NULL, "Caka"},
	{"cky", NULL, NULL, NULL, "Cakfem-Mushere"},
	{"ckz", NULL, NULL, NULL, "Cakchiquel-Quiché Mixed Language"},
	{"cla", NULL, NULL, NULL, "Ron"},
	{"clc", NULL, NULL, NULL, "Chilcotin"},
	{"cld", NULL, NULL, NULL, "Chaldean Neo-Aramaic"},
	{"cle", NULL, NULL, NULL, "Lealao Chinantec"},
	{"clh", NULL, NULL, NULL, "Chilisso"},
	{"cli", NULL, NULL, NULL, "Chakali"},
	{"clj", NULL, NULL, NULL, "Laitu Chin"},
	{"clk", NULL, NULL, NULL, "Idu-Mishmi"},
	{"cll", NULL, NULL, NULL, "Chala"},
	{"clm", NULL, NULL, NULL, "Clallam"},
	{"clo", NULL, NULL, NULL, "Lowland Oaxaca Chontal"},
	{"clt", NULL, NULL, NULL, "Lautu Chin"},
	{"clu", NULL, NULL, NULL, "Caluyanun"},
	{"clw", NULL, NULL, NULL, "Chulym"},
	{"cly", NULL, NULL, NULL, "Eastern Highland Chatino"},
	{"cma", NULL, NULL, NULL, "Maa"},
	{"cme", NULL, NULL, NULL, "Cerma"},
	{"cmg", NULL, NULL, NULL, "Classical Mongolian"},
	{"cmi", NULL, NULL, NULL, "Emberá-Chamí"},
	{"cml", NULL, NULL, NULL, "Campalagian"},
	{"cmm", NULL, NULL, NULL, "Michigamea"},
	{"cmn", NULL, NULL, NULL, "Mandarin Chinese"},
	{"cmo", NULL, NULL, NULL, "Central Mnong"},
	{"cmr", NULL, NULL, NULL, "Mro-Khimi Chin"},
	{"cms", NULL, NULL, NULL, "Messapic"},
	{"cmt", NULL, NULL, NULL, "Camtho"},
	{"cna", NULL, NULL, NULL, "Changthang"},
	{"cnb", NULL, NULL, NULL, "Chinbon Chin"},
	{"cnc", NULL, NULL, NULL, "Côông"},
	{"cng", NULL, NULL, NULL, "Northern Qiang"},
	{"cnh", NULL, NULL, NULL, "Hakha Chin"},
	{"cni", NULL, NULL, NULL, "Asháninka"},
	{"cnk", NULL, NULL, NULL, "Khumi Chin"},
	{"cnl", NULL, NULL, NULL, "Lalana Chinantec"},
	{"cno", NULL, NULL, NULL, "Con"},
	{"cnp", NULL, NULL, NULL, "Northern Ping Chinese"},
	{"cnr", "cnr", "cnr", NULL, "Montenegrin"},
	{"cns", NULL, NULL, NULL, "Central Asmat"},
	{"cnt", NULL, NULL, NULL, "Tepetotutla Chinantec"},
	{"cnu", NULL, NULL, NULL, "Chenoua"},
	{"cnw", NULL, NULL, NULL, "Ngawn Chin"},
	{"cnx", NULL, NULL, NULL, "Middle Cornish"},
	{"coa", NULL, NULL, NULL, "Cocos Islands Malay"},
	{"cob", NULL, NULL, NULL, "Chicomuceltec"},
	{"coc", NULL, NULL, NULL, "Cocopa"},
	{"cod", NULL, NULL, NULL, "Cocama-Cocamilla"},
	{"coe", NULL, NULL, NULL, "Koreguaje"},
	{"cof", NULL, NULL, NULL, "Colorado"},
	{"cog", NULL, NULL, NULL, "Chong"},
	{"coh", NULL, NULL, NULL, "Chonyi-Dzihana-Kauma"},
	{"coj", NULL, NULL, NULL, "Cochimi"},
	{"cok", NULL, NULL, NULL, "Santa Teresa Cora"},
	{"col", NULL, NULL, NULL, "Columbia-Wenatchi"},
	{"com", NULL, NULL, NULL, "Comanche"},
	{"con", NULL, NULL, NULL, "Cofán"},
	{"coo", NULL, NULL, NULL, "Comox"},
	{"cop", "cop", "cop", NULL, "Coptic"},
	{"coq", NULL, NULL, NULL, "Coquille"},
	{"cor", "cor", "cor", "kw", "Cornish"},
	{"cos", "cos", "cos", "co", "Corsican"},
	{"cot", NULL, NULL, NULL, "Caquinte"},
	{"cou", NULL, NULL, NULL, "Wamey"},
	{"cov", NULL, NULL, NULL, "Cao Miao"},
	{"cow", NULL, NULL, NULL, "Cowlitz"},
	{"cox", NULL, NULL, NULL, "Nanti"},
	{"coz", NULL, NULL, NULL, "Chochotec"},
	{"cpa", NULL, NULL, NULL, "Palantla Chinantec"},
	{"cpb", NULL, NULL, NULL, "Ucayali-Yurúa Ashéninka"},
	{"cpc", NULL, NULL, NULL, "Ajyíninka Apurucayali"},
	{"cpg", NULL, NULL, NULL, "Cappadocian Greek"},
	{"cpi", NULL, NULL, NULL, "Chinese Pidgin English"},
	{"cpn", NULL, NULL, NULL, "Cherepon"},
	{"cpo", NULL, NULL, NULL, "Kpeego"},
	{"cps", NULL, NULL, NULL, "Capiznon"},
	{"cpu", NULL, NULL, NULL, "Pichis Ashéninka"},
	{"cpx", NULL, NULL, NULL, "Pu-Xian Chinese"},
	{"cpy", NULL, NULL, NULL, "South Ucayali Ashéninka"},
	{"cqd", NULL, NULL, NULL, "Chuanqiandian Cluster Miao"},
	{"cra", NULL, NULL, NULL, "Chara"},
	{"crb", NULL, NULL, NULL, "Island Carib"},
	{"crc", NULL, NULL, NULL, "Lonwolwol"},
	{"crd", NULL, NULL, NULL, "Coeur d'Alene"},
	{"cre", "cre", "cre", "cr", "Cree"},
	{"crf", NULL, NULL, NULL, "Caramanta"},
	{"crg", NULL, NULL, NULL, "Michif"},
	{"crh", "crh", "crh", NULL, "Crimean Tatar"},
	{"cri", NULL, NULL, NULL, "Sãotomense"},
	{"crj", NULL, NULL, NULL, "Southern East Cree"},
	{"crk", NULL, NULL, NULL, "Plains Cree"},
	{"crl", NULL, NULL, NULL, "Northern East Cree"},
	{"crm", NULL, NULL, NULL, "Moose Cree"},
	{"crn", NULL, NULL, NULL, "El Nayar Cora"},
	{"cro", NULL, NULL, NULL, "Crow"},
	{"crq", NULL, NULL, NULL, "Iyo'wujwa Chorote"},
	{"crr", NULL, NULL, NULL, "Carolina Algonquian"},
	{"crs", NULL, NULL, NULL, "Seselwa Creole French"},
	{"crt", NULL, NULL, NULL, "Iyojwa'ja Chorote"},
	{"crv", NULL, NULL, NULL, "Chaura"},
	{"crw", NULL, NULL, NULL, "Chrau"},
	{"crx", NULL, NULL, NULL, "Carrier"},
	{"cry", NULL, NULL, NULL, "Cori"},
	{"crz", NULL, NULL, NULL, "Cruzeño"},
	{"csa", NULL, NULL, NULL, "Chiltepec Chinantec"},
	{"csb", "csb", "csb", NULL, "Kashubian"},
	{"csc", NULL, NULL, NULL, "Catalan Sign Language"},
	{"csd", NULL, NULL, NULL, "Chiangmai Sign Language"},
	{"cse", NULL, NULL, NULL, "Czech Sign Language"},
	{"csf", NULL, NULL, NULL, "Cuba Sign Language"},
	{"csg", NULL, NULL, NULL, "Chilean Sign Language"},
	{"csh", NULL, NULL, NULL, "Asho Chin"},
	{"csi", NULL, NULL, NULL, "Coast Miwok"},
	{"csj", NULL, NULL, NULL, "Songlai Chin"},
	{"csk", NULL, NULL, NULL, "Jola-Kasa"},
	{"csl", NULL, NULL, NULL, "Chinese Sign Language"},
	{"csm", NULL, NULL, NULL, "Central Sierra Miwok"},
	{"csn", NULL, NULL, NULL, "Colombian Sign Language"},
	{"cso", NULL, NULL, NULL, "Sochiapam Chinantec"},
	{"csp", NULL, NULL, NULL, "Southern Ping Chinese"},
	{"csq", NULL, NULL, NULL, "Croatia Sign Language"},
	{"csr", NULL, NULL, NULL, "Costa Rican Sign Language"},
	{"css", NULL, NULL, NULL, "Southern Ohlone"},
	{"cst", NULL, NULL, NULL, "Northern Ohlone"},
	{"csv", NULL, NULL, NULL, "Sumtu Chin"},
	{"csw", NULL, NULL, NULL, "Swampy Cree"},
	{"csx", NULL, NULL, NULL, "Cambodian Sign Language"},
	{"csy", NULL, NULL, NULL, "Siyin Chin"},
	{"csz", NULL, NULL, NULL, "Coos"},
	{"cta", NULL, NULL, NULL, "Tataltepec Chatino"},
	{"ctc", NULL, NULL, NULL, "Chetco"},
	{"ctd", NULL, NULL, NULL, "Tedim Chin"},
	{"cte", NULL, NULL, NULL, "Tepinapa Chinantec"},
	{"ctg", NULL, NULL, NULL, "Chittagonian"},
	{"cth", NULL, NULL, NULL, "Thaiphum Chin"},
	{"ctl", NULL, NULL, NULL, "Tlacoatzintepec Chinantec"},
	{"ctm", NULL, NULL, NULL, "Chitimacha"},
	{"ctn", NULL, NULL, NULL, "Chhintange"},
	{"cto", NULL, NULL, NULL, "Emberá-Catío"},
	{"ctp", NULL, NULL, NULL, "Western Highland Chatino"},
	{"cts", NULL, NULL, NULL, "Northern Catanduanes Bikol"},
	{"ctt", NULL, NULL, NULL, "Wayanad Chetti"},
	{"ctu", NULL, NULL, NULL, "Chol"},
	{"cty", NULL, NULL, NULL, "Moundadan Chetty"},
	{"ctz", NULL, NULL, NULL, "Zacatepec Chatino"},
	{"cua", NULL, NULL, NULL, "Cua"},
	{"cub", NULL, NULL, NULL, "Cubeo"},
	{"cuc", NULL, NULL, NULL, "Usila Chinantec"},
	{"cug", NULL, NULL, NULL, "Chungmboko"},
	{"cuh", NULL, NULL, NULL, "Chuka"},
	{"cui", NULL, NULL, NULL, "Cuiba"},
	{"cuj", NULL, NULL, NULL, "Mashco Piro"},
	{"cuk", NULL, NULL, NULL, "San Blas Kuna"},
	{"cul", NULL, NULL, NULL, "Culina"},
	{"cuo", NULL, NULL, NULL, "Cumanagoto"},
	{"cup", NULL, NULL, NULL, "Cupeño"},
	{"cuq", NULL, NULL, NULL, "Cun"},
	{"cur", NULL, NULL, NULL, "Chhulung"},
	{"cut", NULL, NULL, NULL, "Teutila Cuicatec"},
	{"cuu", NULL, NULL, NULL, "Tai Ya"},
	{"cuv", NULL, NULL, NULL, "Cuvok"},
	{"cuw", NULL, NULL, NULL, "Chukwa"},
	{"cux", NULL, NULL, NULL, "Tepeuxila Cuicatec"},
	{"cuy", NULL, NULL, NULL, "Cuitlatec"},
	{"cvg", NULL, NULL, NULL, "Chug"},
	{"cvn", NULL, NULL, NULL, "Valle Nacional Chinantec"},
	{"cwa", NULL, NULL, NULL, "Kabwa"},
	{"cwb", NULL, NULL, NULL, "Maindo"},
	{"cwd", NULL, NULL, NULL, "Woods Cree"},
	{"cwe", NULL, NULL, NULL, "Kwere"},
	{"cwg", NULL, NULL, NULL, "Chewong"},
	{"cwt", NULL, NULL, NULL, "Kuwaataay"},
	{"cya", NULL, NULL, NULL, "Nopala Chatino"},
	{"cyb", NULL, NULL, NULL, "Cayubaba"},
	{"cym", "wel", "cym", "cy", "Welsh"},
	{"cyo", NULL, NULL, NULL, "Cuyonon"},
	{"czh", NULL, NULL, NULL, "Huizhou Chinese"},
	{"czk", NULL, NULL, NULL, "Knaanic"},
	{"czn", NULL, NULL, NULL, "Zenzontepec Chatino"},
	{"czo", NULL, NULL, NULL, "Min Zhong Chinese"},
	{"czt", NULL, NULL, NULL, "Zotung Chin"},
	{"daa", NULL, NULL, NULL, "Dangaléat"},
	{"dac", NULL, NULL, NULL, "Dambi"},
	{"dad", NULL, NULL, NULL, "Marik"},
	{"dae", NULL, NULL, NULL, "Duupa"},
	{"dag", NULL, NULL, NULL, "Dagbani"},
	{"dah", NULL, NULL, NULL, "Gwahatike"},
	{"dai", NULL, NULL, NULL, "Day"},
	{"daj", NULL, NULL, NULL, "Dar Fur Daju"},
	{"dak", "dak", "dak", NULL, "Dakota"},
	{"dal", NULL, NULL, NULL, "Dahalo"},
	{"dam", NULL, NULL, NULL, "Damakawa"},
	{"dan", "dan", "dan", "da", "Danish"},
	{"dao", NULL, NULL, NULL, "Daai Chin"},
	{"daq", NULL, NULL, NULL, "Dandami Maria"},
	{"dar", "dar", "dar", NULL, "Dargwa"},
	{"das", NULL, NULL, NULL, "Daho-Doo"},
	{"dau", NULL, NULL, NULL, "Dar Sila Daju"},
	{"dav", NULL, NULL, NULL, "Taita"},
	{"daw", NULL, NULL, NULL, "Davawenyo"},
	{"dax", NULL, NULL, NULL, "Dayi"},
	{"daz", NULL, NULL, NULL, "Dao"},
	{"dba", NULL, NULL, NULL, "Bangime"},
	{"dbb", NULL, NULL, NULL, "Deno"},
	{"dbd", NULL, NULL, NULL, "Dadiya"},
	{"dbe", NULL, NULL, NULL, "Dabe"},
	{"dbf", NULL, NULL, NULL, "Edopi"},
	{"dbg", NULL, NULL, NULL, "Dogul Dom Dogon"},
	{"dbi", NULL, NULL, NULL, "Doka"},
	{"dbj", NULL, NULL, NULL, "Ida'an"},
	{"dbl", NULL, NULL, NULL, "Dyirbal"},
	{"dbm", NULL, NULL, NULL, "Duguri"},
	{"dbn", NULL, NULL, NULL, "Duriankere"},
	{"dbo", NULL, NULL, NULL, "Dulbu"},
	{"dbp", NULL, NULL, NULL, "Duwai"},
	{"dbq", NULL, NULL, NULL, "Daba"},
	{"dbr", NULL, NULL, NULL, "Dabarre"},
	{"dbt", NULL, NULL, NULL, "Ben Tey Dogon"},
	{"dbu", NULL, NULL, NULL, "Bondum Dom Dogon"},
	{"dbv", NULL, NULL, NULL, "Dungu"},
	{"dbw", NULL, NULL, NULL, "Bankan Tey Dogon"},
	{"dby", NULL, NULL, NULL, "Dibiyaso"},
	{"dcc", NULL, NULL, NULL, "Deccan"},
	{"dcr", NULL, NULL, NULL, "Negerhollands"},
	{"dda", NULL, NULL, NULL, "Dadi Dadi"},
	{"ddd", NULL, NULL, NULL, "Dongotono"},
	{"dde", NULL, NULL, NULL, "Doondo"},
	{"ddg", NULL, NULL, NULL, "Fataluku"},
	{"ddi", NULL, NULL, NULL, "West Goodenough"},
	{"ddj", NULL, NULL, NULL, "Jaru"},
	{"ddn", NULL, NULL, NULL, "Dendi (Benin)"},
	{"ddo", NULL, NULL, NULL, "Dido"},
	{"ddr", NULL, NULL, NULL, "Dhudhuroa"},
	{"dds", NULL, NULL, NULL, "Donno So Dogon"},
	{"ddw", NULL, NULL, NULL, "Dawera-Daweloor"},
	{"dec", NULL, NULL, NULL, "Dagik"},
	{"ded", NULL, NULL, NULL, "Dedua"},
	{"dee", NULL, NULL, NULL, "Dewoin"},
	{"def", NULL, NULL, NULL, "Dezfuli"},
	{"deg", NULL, NULL, NULL, "Degema"},
	{"deh", NULL, NULL, NULL, "Dehwari"},
	{"dei", NULL, NULL, NULL, "Demisa"},
	{"dek", NULL, NULL, NULL, "Dek"},
	{"del", "del", "del", NULL, "Delaware"},
	{"dem", NULL, NULL, NULL, "Dem"},
	{"den", "den", "den", NULL, "Slave (Athapascan)"},
	{"dep", NULL, NULL, NULL, "Pidgin Delaware"},
	{"deq", NULL, NULL, NULL, "Dendi (Central African Republic)"},
	{"der", NULL, NULL, NULL, "Deori"},
	{"des", NULL, NULL, NULL, "Desano"},
	{"deu", "ger", "deu", "de", "German"},
	{"dev", NULL, NULL, NULL, "Domung"},
	{"dez", NULL, NULL, NULL, "Dengese"},
	{"dga", NULL, NULL, NULL, "Southern Dagaare"},
	{"dgb", NULL, NULL, NULL, "Bunoge Dogon"},
	{"dgc", NULL, NULL, NULL, "Casiguran Dumagat Agta"},
	{"dgd", NULL, NULL, NULL, "Dagaari Dioula"},
	{"dge", NULL, NULL, NULL, "Degenan"},
	{"dgg", NULL, NULL, NULL, "Doga"},
	{"dgh", NULL, NULL, NULL, "Dghwede"},
	{"dgi", NULL, NULL, NULL, "Northern Dagara"},
	{"dgk", NULL, NULL, NULL, "Dagba"},
	{"dgl", NULL, NULL, NULL, "Andaandi"},
	{"dgn", NULL, NULL, NULL, "Dagoman"},
	{"dgo", NULL, NULL, NULL, "Dogri (individual language)"},
	{"dgr", "dgr", "dgr", NULL, "Dogrib"},
	{"dgs", NULL, NULL, NULL, "Dogoso"},
	{"dgt", NULL, NULL, NULL, "Ndra'ngith"},
	{"dgw", NULL, NULL, NULL, "Daungwurrung"},
	{"dgx", NULL, NULL, NULL, "Doghoro"},
	{"dgz", NULL, NULL, NULL, "Daga"},
	{"dhd", NULL, NULL, NULL, "Dhundari"},
	{"dhg", NULL, NULL, NULL, "Dhangu-Djangu"},
	{"dhi", NULL, NULL, NULL, "Dhimal"},
	{"dhl", NULL, NULL, NULL, "Dhalandji"},
	{"dhm", NULL, NULL, NULL, "Zemba"},
	{"dhn", NULL, NULL, NULL, "Dhanki"},
	{"dho", NULL, NULL, NULL, "Dhodia"},
	{"dhr", NULL, NULL, NULL, "Dhargari"},
	{"dhs", NULL, NULL, NULL, "Dhaiso"},
	{"dhu", NULL, NULL, NULL, "Dhurga"},
	{"dhv", NULL, NULL, NULL, "Dehu"},
	{"dhw", NULL, NULL, NULL, "Dhanwar (Nepal)"},
	{"dhx", NULL, NULL, NULL, "Dhungaloo"},
	{"dia", NULL, NULL, NULL, "Dia"},
	{"dib", NULL, NULL, NULL, "South Central Dinka"},
	{"dic", NULL, NULL, NULL, "Lakota Dida"},
	{"did", NULL, NULL, NULL, "Didinga"},
	{"dif", NULL, NULL, NULL, "Dieri"},
	{"dig", NULL, NULL, NULL, "Digo"},
	{"dih", NULL, NULL, NULL, "Kumiai"},
	{"dii", NULL, NULL, NULL, "Dimbong"},
	{"dij", NULL, NULL, NULL, "Dai"},
	{"dik", NULL, NULL, NULL, "Southwestern Dinka"},
	{"dil", NULL, NULL, NULL, "Dilling"},
	{"dim", NULL, NULL, NULL, "Dime"},
	{"din", "din", "din", NULL, "Dinka"},
	{"dio", NULL, NULL, NULL, "Dibo"},
	{"dip", NULL, NULL, NULL, "Northeastern Dinka"},
	{"diq", NULL, NULL, NULL, "Dimli (individual language)"},
	{"dir", NULL, NULL, NULL, "Dirim"},
	{"dis", NULL, NULL, NULL, "Dimasa"},
	{"diu", NULL, NULL, NULL, "Diriku"},
	{"div", "div", "div", "dv", "Dhivehi"},
	{"diw", NULL, NULL, NULL, "Northwestern Dinka"},
	{"dix", NULL, NULL, NULL, "Dixon Reef"},
	{"diy", NULL, NULL, NULL, "Diuwe"},
	{"diz", NULL, NULL, NULL, "Ding"},
	{"dja", NULL, NULL, NULL, "Djadjawurrung"},
	{"djb", NULL, NULL, NULL, "Djinba"},
	{"djc", NULL, NULL, NULL, "Dar Daju Daju"},
	{"djd", NULL, NULL, NULL, "Djamindjung"},
	{"dje", NULL, NULL, NULL, "Zarma"},
	{"djf", NULL, NULL, NULL, "Djangun"},
	{"dji", NULL, NULL, NULL, "Djinang"},
	{"djj", NULL, NULL, NULL, "Djeebbana"},
	{"djk", NULL, NULL, NULL, "Eastern Maroon Creole"},
	{"djm", NULL, NULL, NULL, "Jamsay Dogon"},
	{"djn", NULL, NULL, NULL, "Jawoyn"},
	{"djo", NULL, NULL, NULL, "Jangkang"},
	{"djr", NULL, NULL, NULL, "Djambarrpuyngu"},
	{"dju", NULL, NULL, NULL, "Kapriman"},
	{"djw", NULL, NULL, NULL, "Djawi"},
	{"dka", NULL, NULL, NULL, "Dakpakha"},
	{"dkg", NULL, NULL, NULL, "Kadung"},
	{"dkk", NULL, NULL, NULL, "Dakka"},
	{"dkr", NULL, NULL, NULL, "Kuijau"},
	{"dks", NULL, NULL, NULL, "Southeastern Dinka"},
	{"dkx", NULL, NULL, NULL, "Mazagway"},
	{"dlg", NULL, NULL, NULL, "Dolgan"},
	{"dlk", NULL, NULL, NULL, "Dahalik"},
	{"dlm", NULL, NULL, NULL, "Dalmatian"},
	{"dln", NULL, NULL, NULL, "Darlong"},
	{"dma", NULL, NULL, NULL, "Duma"},
	{"dmb", NULL, NULL, NULL, "Mombo Dogon"},
	{"dmc", NULL, NULL, NULL, "Gavak"},
	{"dmd", NULL, NULL, NULL, "Madhi Madhi"},
	{"dme", NULL, NULL, NULL, "Dugwor"},
	{"dmf", NULL, NULL, NULL, "Medefaidrin"},
	{"dmg", NULL, NULL, NULL, "Upper Kinabatangan"},
	{"dmk", NULL, NULL, NULL, "Domaaki"},
	{"dml", NULL, NULL, NULL, "Dameli"},
	{"dmm", NULL, NULL, NULL, "Dama"},
	{"dmo", NULL, NULL, NULL, "Kemedzung"},
	{"dmr", NULL, NULL, NULL, "East Damar"},
	{"dms", NULL, NULL, NULL, "Dampelas"},
	{"dmu", NULL, NULL, NULL, "Dubu"},
	{"dmv", NULL, NULL, NULL, "Dumpas"},
	{"dmw", NULL, NULL, NULL, "Mudburra"},
	{"dmx", NULL, NULL, NULL, "Dema"},
	{"dmy", NULL, NULL, NULL, "Demta"},
	{"dna", NULL, NULL, NULL, "Upper Grand Valley Dani"},
	{"dnd", NULL, NULL, NULL, "Daonda"},
	{"dne", NULL, NULL, NULL, "Ndendeule"},
	{"dng", NULL, NULL, NULL, "Dungan"},
	{"dni", NULL, NULL, NULL, "Lower Grand Valley Dani"},
	{"dnj", NULL, NULL, NULL, "Dan"},
	{"dnk", NULL, NULL, NULL, "Dengka"},
	{"dnn", NULL, NULL, NULL, "Dzùùngoo"},
	{"dno", NULL, NULL, NULL, "Ndrulo"},
	{"dnr", NULL, NULL, NULL, "Danaru"},
	{"dnt", NULL, NULL, NULL, "Mid Grand Valley Dani"},
	{"dnu", NULL, NULL, NULL, "Danau"},
	{"dnv", NULL, NULL, NULL, "Danu"},
	{"dnw", NULL, NULL, NULL, "Western Dani"},
	{"dny", NULL, NULL, NULL, "Dení"},
	{"doa", NULL, NULL, NULL, "Dom"},
	{"dob", NULL, NULL, NULL, "Dobu"},
	{"doc", NULL, NULL, NULL, "Northern Dong"},
	{"doe", NULL, NULL, NULL, "Doe"},
	{"dof", NULL, NULL, NULL, "Domu"},
	{"doh", NULL, NULL, NULL, "Dong"},
	{"doi", "doi", "doi", NULL, "Dogri (macrolanguage)"},
	{"dok", NULL, NULL, NULL, "Dondo"},
	{"dol", NULL, NULL, NULL, "Doso"},
	{"don", NULL, NULL, NULL, "Toura (Papua New Guinea)"},
	{"doo", NULL, NULL, NULL, "Dongo"},
	{"dop", NULL, NULL, NULL, "Lukpa"},
	{"doq", NULL, NULL, NULL, "Dominican Sign Language"},
	{"dor", NULL, NULL, NULL, "Dori'o"},
	{"dos", NULL, NULL, NULL, "Dogosé"},
	{"dot", NULL, NULL, NULL, "Dass"},
	{"dov", NULL, NULL, NULL, "Dombe"},
	{"dow", NULL, NULL, NULL, "Doyayo"},
	{"dox", NULL, NULL, NULL, "Bussa"},
	{"doy", NULL, NULL, NULL, "Dompo"},
	{"doz", NULL, NULL, NULL, "Dorze"},
	{"dpp", NULL, NULL, NULL, "Papar"},
	{"drb", NULL, NULL, NULL, "Dair"},
	{"drc", NULL, NULL, NULL, "Minderico"},
	{"drd", NULL, NULL, NULL, "Darmiya"},
	{"dre", NULL, NULL, NULL, "Dolpo"},
	{"drg", NULL, NULL, NULL, "Rungus"},
	{"dri", NULL, NULL, NULL, "C'Lela"},
	{"drl", NULL, NULL, NULL, "Paakantyi"},
	{"drn", NULL, NULL, NULL, "West Damar"},
	{"dro", NULL, NULL, NULL, "Daro-Matu Melanau"},
	{"drq", NULL, NULL, NULL, "Dura"},
	{"drs", NULL, NULL, NULL, "Gedeo"},
	{"drt", NULL, NULL, NULL, "Drents"},
	{"dru", NULL, NULL, NULL, "Rukai"},
	{"dry", NULL, NULL, NULL, "Darai"},
	{"dsb", "dsb", "dsb", NULL, "Lower Sorbian"},
	{"dse", NULL, NULL, NULL, "Dutch Sign Language"},
	{"dsh", NULL, NULL, NULL, "Daasanach"},
	{"dsi", NULL, NULL, NULL, "Disa"},
	{"dsl", NULL, NULL, NULL, "Danish Sign Language"},
	{"dsn", NULL, NULL, NULL, "Dusner"},
	{"dso", NULL, NULL, NULL, "Desiya"},
	{"dsq", NULL, NULL, NULL, "Tadaksahak"},
	{"dta", NULL, NULL, NULL, "Daur"},
	{"dtb", NULL, NULL, NULL, "Labuk-Kinabatangan Kadazan"},
	{"dtd", NULL, NULL, NULL, "Ditidaht"},
	{"dth", NULL, NULL, NULL, "Adithinngithigh"},
	{"dti", NULL, NULL, NULL, "Ana Tinga Dogon"},
	{"dtk", NULL, NULL, NULL, "Tene Kan Dogon"},
	{"dtm", NULL, NULL, NULL, "Tomo Kan Dogon"},
	{"dtn", NULL, NULL, NULL, "Daatsʼíin"},
	{"dto", NULL, NULL, NULL, "Tommo So Dogon"},
	{"dtp", NULL, NULL, NULL, "Kadazan Dusun"},
	{"dtr", NULL, NULL, NULL, "Lotud"},
	{"dts", NULL, NULL, NULL, "Toro So Dogon"},
	{"dtt", NULL, NULL, NULL, "Toro Tegu Dogon"},
	{"dtu", NULL, NULL, NULL, "Tebul Ure Dogon"},
	{"dty", NULL, NULL, NULL, "Dotyali"},
	{"dua", "dua", "dua", NULL, "Duala"},
	{"dub", NULL, NULL, NULL, "Dubli"},
	{"duc", NULL, NULL, NULL, "Duna"},
	{"due", NULL, NULL, NULL, "Umiray Dumaget Agta"},
	{"duf", NULL, NULL, NULL, "Dumbea"},
	{"dug", NULL, NULL, NULL, "Duruma"},
	{"duh", NULL, NULL, NULL, "Dungra Bhil"},
	{"dui", NULL, NULL, NULL, "Dumun"},
	{"duk", NULL, NULL, NULL, "Uyajitaya"},
	{"dul", NULL, NULL, NULL, "Alabat Island Agta"},
	{"dum", "dum", "dum", NULL, "Middle Dutch (ca. 1050-1350)"},
	{"dun", NULL, NULL, NULL, "Dusun Deyah"},
	{"duo", NULL, NULL, NULL, "Dupaninan Agta"},
	{"dup", NULL, NULL, NULL, "Duano"},
	{"duq", NULL, NULL, NULL, "Dusun Malang"},
	{"dur", NULL, NULL, NULL, "Dii"},
	{"dus", NULL, NULL, NULL, "Dumi"},
	{"duu", NULL, NULL, NULL, "Drung"},
	{"duv", NULL, NULL, NULL, "Duvle"},
	{"duw", NULL, NULL, NULL, "Dusun Witu"},
	{"dux", NULL, NULL, NULL, "Duungooma"},
	{"duy", NULL, NULL, NULL, "Dicamay Agta"},
	{"duz", NULL, NULL, NULL, "Duli-Gey"},
	{"dva", NULL, NULL, NULL, "Duau"},
	{"dwa", NULL, NULL, NULL, "Diri"},
	{"dwk", NULL, NULL, NULL, "Dawik Kui"},
	{"dwr", NULL, NULL, NULL, "Dawro"},
	{"dws", NULL, NULL, NULL, "Dutton World Speedwords"},
	{"dwu", NULL, NULL, NULL, "Dhuwal"},
	{"dww", NULL, NULL, NULL, "Dawawa"},
	{"dwy", NULL, NULL, NULL, "Dhuwaya"},
	{"dwz", NULL, NULL, NULL, "Dewas Rai"},
	{"dya", NULL, NULL, NULL, "Dyan"},
	{"dyb", NULL, NULL, NULL, "Dyaberdyaber"},
	{"dyd", NULL, NULL, NULL, "Dyugun"},
	{"dyg", NULL, NULL, NULL, "Villa Viciosa Agta"},
	{"dyi", NULL, NULL, NULL, "Djimini Senoufo"},
	{"dym", NULL, NULL, NULL, "Yanda Dom Dogon"},
	{"dyn", NULL, NULL, NULL, "Dyangadi"},
	{"dyo", NULL, NULL, NULL, "Jola-Fonyi"},
	{"dyu", "dyu", "dyu", NULL, "Dyula"},
	{"dyy", NULL, NULL, NULL, "Djabugay"},
	{"dza", NULL, NULL, NULL, "Tunzu"},
	{"dze", NULL, NULL, NULL, "Djiwarli"},
	{"dzg", NULL, NULL, NULL, "Dazaga"},
	{"dzl", NULL, NULL, NULL, "Dzalakha"},
	{"dzn", NULL, NULL, NULL, "Dzando"},
	{"dzo", "dzo", "dzo", "dz", "Dzongkha"},
	{"eaa", NULL, NULL, NULL, "Karenggapa"},
	{"ebc", NULL, NULL, NULL, "Beginci"},
	{"ebg", NULL, NULL, NULL, "Ebughu"},
	{"ebk", NULL, NULL, NULL, "Eastern Bontok"},
	{"ebo", NULL, NULL, NULL, "Teke-Ebo"},
	{"ebr", NULL, NULL, NULL, "Ebrié"},
	{"ebu", NULL, NULL, NULL, "Embu"},
	{"ecr", NULL, NULL, NULL, "Eteocretan"},
	{"ecs", NULL, NULL, NULL, "Ecuadorian Sign Language"},
	{"ecy", NULL, NULL, NULL, "Eteocypriot"},
	{"eee", NULL, NULL, NULL, "E"},
	{"efa", NULL, NULL, NULL, "Efai"},
	{"efe", NULL, NULL, NULL, "Efe"},
	{"efi", "efi", "efi", NULL, "Efik"},
	{"ega", NULL, NULL, NULL, "Ega"},
	{"egl", NULL, NULL, NULL, "Emilian"},
	{"ego", NULL, NULL, NULL, "Eggon"},
	{"egy", "egy", "egy", NULL, "Egyptian (Ancient)"},
	{"ehs", NULL, NULL, NULL, "Miyakubo Sign Language"},
	{"ehu", NULL, NULL, NULL, "Ehueun"},
	{"eip", NULL, NULL, NULL, "Eipomek"},
	{"eit", NULL, NULL, NULL, "Eitiep"},
	{"eiv", NULL, NULL, NULL, "Askopan"},
	{"eja", NULL, NULL, NULL, "Ejamat"},
	{"eka", "eka", "eka", NULL, "Ekajuk"},
	{"eke", NULL, NULL, NULL, "Ekit"},
	{"ekg", NULL, NULL, NULL, "Ekari"},
	{"eki", NULL, NULL, NULL, "Eki"},
	{"ekk", NULL, NULL, NULL, "Standard Estonian"},
	{"ekl", NULL, NULL, NULL, "Kol (Bangladesh)"},
	{"ekm", NULL, NULL, NULL, "Elip"},
	{"eko", NULL, NULL, NULL, "Koti"},
	{"ekp", NULL, NULL, NULL, "Ekpeye"},
	{"ekr", NULL, NULL, NULL, "Yace"},
	{"eky", NULL, NULL, NULL, "Eastern Kayah"},
	{"ele", NULL, NULL, NULL, "Elepi"},
	{"elh", NULL, NULL, NULL, "El Hugeirat"},
	{"eli", NULL, NULL, NULL, "Nding"},
	{"elk", NULL, NULL, NULL, "Elkei"},
	{"ell", "gre", "ell", "el", "Modern Greek (1453-)"},
	{"elm", NULL, NULL, NULL, "Eleme"},
	{"elo", NULL, NULL, NULL, "El Molo"},
	{"elu", NULL, NULL, NULL, "Elu"},
	{"elx", "elx", "elx", NULL, "Elamite"},
	{"ema", NULL, NULL, NULL, "Emai-Iuleha-Ora"},
	{"emb", NULL, NULL, NULL, "Embaloh"},
	{"eme", NULL, NULL, NULL, "Emerillon"},
	{"emg", NULL, NULL, NULL, "Eastern Meohang"},
	{"emi", NULL, NULL, NULL, "Mussau-Emira"},
	{"emk", NULL, NULL, NULL, "Eastern Maninkakan"},
	{"emm", NULL, NULL, NULL, "Mamulique"},
	{"emn", NULL, NULL, NULL, "Eman"},
	{"emp", NULL, NULL, NULL, "Northern Emberá"},
	{"emq", NULL, NULL, NULL, "Eastern Minyag"},
	{"ems", NULL, NULL, NULL, "Pacific Gulf Yupik"},
	{"emu", NULL, NULL, NULL, "Eastern Muria"},
	{"emw", NULL, NULL, NULL, "Emplawas"},
	{"emx", NULL, NULL, NULL, "Erromintxela"},
	{"emy", NULL, NULL, NULL, "Epigraphic Mayan"},
	{"emz", NULL, NULL, NULL, "Mbessa"},
	{"ena", NULL, NULL, NULL, "Apali"},
	{"enb", NULL, NULL, NULL, "Markweeta"},
	{"enc", NULL, NULL, NULL, "En"},
	{"end", NULL, NULL, NULL, "Ende"},
	{"enf", NULL, NULL, NULL, "Forest Enets"},
	{"eng", "eng", "eng", "en", "English"},
	{"enh", NULL, NULL, NULL, "Tundra Enets"},
	{"enl", NULL, NULL, NULL, "Enlhet"},
	{"enm", "enm", "enm", NULL, "Middle English (1100-1500)"},
	{"enn", NULL, NULL, NULL, "Engenni"},
	{"eno", NULL, NULL, NULL, "Enggano"},
	{"enq", NULL, NULL, NULL, "Enga"},
	{"enr", NULL, NULL, NULL, "Emumu"},
	{"enu", NULL, NULL, NULL, "Enu"},
	{"env", NULL, NULL, NULL, "Enwan (Edu State)"},
	{"enw", NULL, NULL, NULL, "Enwan (Akwa Ibom State)"},
	{"enx", NULL, NULL, NULL, "Enxet"},
	{"eot", NULL, NULL, NULL, "Beti (Côte d'Ivoire)"},
	{"epi", NULL, NULL, NULL, "Epie"},
	{"epo", "epo", "epo", "eo", "Esperanto"},
	{"era", NULL, NULL, NULL, "Eravallan"},
	{"erg", NULL, NULL, NULL, "Sie"},
	{"erh", NULL, NULL, NULL, "Eruwa"},
	{"eri", NULL, NULL, NULL, "Ogea"},
	{"erk", NULL, NULL, NULL, "South Efate"},
	{"ero", NULL, NULL, NULL, "Horpa"},
	{"err", NULL, NULL, NULL, "Erre"},
	{"ers", NULL, NULL, NULL, "Ersu"},
	{"ert", NULL, NULL, NULL, "Eritai"},
	{"erw", NULL, NULL, NULL, "Erokwanas"},
	{"ese", NULL, NULL, NULL, "Ese Ejja"},
	{"esg", NULL, NULL, NULL, "Aheri Gondi"},
	{"esh", NULL, NULL, NULL, "Eshtehardi"},
	{"esi", NULL, NULL, NULL, "North Alaskan Inupiatun"},
	{"esk", NULL, NULL, NULL, "Northwest Alaska Inupiatun"},
	{"esl", NULL, NULL, NULL, "Egypt Sign Language"},
	{"esm", NULL, NULL, NULL, "Esuma"},
	{"esn", NULL, NULL, NULL, "Salvadoran Sign Language"},
	{"eso", NULL, NULL, NULL, "Estonian Sign Language"},
	{"esq", NULL, NULL, NULL, "Esselen"},
	{"ess", NULL, NULL, NULL, "Central Siberian Yupik"},
	{"est", "est", "est", "et", "Estonian"},
	{"esu", NULL, NULL, NULL, "Central Yupik"},
	{"esy", NULL, NULL, NULL, "Eskayan"},
	{"etb", NULL, NULL, NULL, "Etebi"},
	{"etc", NULL, NULL, NULL, "Etchemin"},
	{"eth", NULL, NULL, NULL, "Ethiopian Sign Language"},
	{"etn", NULL, NULL, NULL, "Eton (Vanuatu)"},
	{"eto", NULL, NULL, NULL, "Eton (Cameroon)"},
	{"etr", NULL, NULL, NULL, "Edolo"},
	{"ets", NULL, NULL, NULL, "Yekhee"},
	{"ett", NULL, NULL, NULL, "Etruscan"},
	{"etu", NULL, NULL, NULL, "Ejagham"},
	{"etx", NULL, NULL, NULL, "Eten"},
	{"etz", NULL, NULL, NULL, "Semimi"},
	{"eus", "baq", "eus", "eu", "Basque"},
	{"eve", NULL, NULL, NULL, "Even"},
	{"evh", NULL, NULL, NULL, "Uvbie"},
	{"evn", NULL, NULL, NULL, "Evenki"},
	{"ewe", "ewe", "ewe", "ee", "Ewe"},
	{"ewo", "ewo", "ewo", NULL, "Ewondo"},
	{"ext", NULL, NULL, NULL, "Extremaduran"},
	{"eya", NULL, NULL, NULL, "Eyak"},
	{"eyo", NULL, NULL, NULL, "Keiyo"},
	{"eza", NULL, NULL, NULL, "Ezaa"},
	{"eze", NULL, NULL, NULL, "Uzekwe"},
	{"faa", NULL, NULL, NULL, "Fasu"},
	{"fab", NULL, NULL, NULL, "Fa d'Ambu"},
	{"fad", NULL, NULL, NULL, "Wagi"},
	{"faf", NULL, NULL, NULL, "Fagani"},
	{"fag", NULL, NULL, NULL, "Finongan"},
	{"fah", NULL, NULL, NULL, "Baissa Fali"},
	{"fai", NULL, NULL, NULL, "Faiwol"},
	{"faj", NULL, NULL, NULL, "Faita"},
	{"fak", NULL, NULL, NULL, "Fang (Cameroon)"},
	{"fal", NULL, NULL, NULL, "South Fali"},
	{"fam", NULL, NULL, NULL, "Fam"},
	{"fan", "fan", "fan", NULL, "Fang (Equatorial Guinea)"},
	{"fao", "fao", "fao", "fo", "Faroese"},
	{"fap", NULL, NULL, NULL, "Paloor"},
	{"far", NULL, NULL, NULL, "Fataleka"},
	{"fas", "per", "fas", "fa", "Persian"},
	{"fat", "fat", "fat", NULL, "Fanti"},
	{"fau", NULL, NULL, NULL, "Fayu"},
	{"fax", NULL, NULL, NULL, "Fala"},
	{"fay", NULL, NULL, NULL, "Southwestern Fars"},
	{"faz", NULL, NULL, NULL, "Northwestern Fars"},
	{"fbl", NULL, NULL, NULL, "West Albay Bikol"},
	{"fcs", NULL, NULL, NULL, "Quebec Sign Language"},
	{"fer", NULL, NULL, NULL, "Feroge"},
	{"ffi", NULL, NULL, NULL, "Foia Foia"},
	{"ffm", NULL, NULL, NULL, "Maasina Fulfulde"},
	{"fgr", NULL, NULL, NULL, "Fongoro"},
	{"fia", NULL, NULL, NULL, "Nobiin"},
	{"fie", NULL, NULL, NULL, "Fyer"},
	{"fif", NULL, NULL, NULL, "Faifi"},
	{"fij", "fij", "fij", "fj", "Fijian"},
	{"fil", "fil", "fil", NULL, "Filipino"},
	{"fin", "fin", "fin", "fi", "Finnish"},
	{"fip", NULL, NULL, NULL, "Fipa"},
	{"fir", NULL, NULL, NULL, "Firan"},
	{"fit", NULL, NULL, NULL, "Tornedalen Finnish"},
	{"fiw", NULL, NULL, NULL, "Fiwaga"},
	{"fkk", NULL, NULL, NULL, "Kirya-Konzəl"},
	{"fkv", NULL, NULL, NULL, "Kven Finnish"},
	{"fla", NULL, NULL, NULL, "Kalispel-Pend d'Oreille"},
	{"flh", NULL, NULL, NULL, "Foau"},
	{"fli", NULL, NULL, NULL, "Fali"},
	{"fll", NULL, NULL, NULL, "North Fali"},
	{"fln", NULL, NULL, NULL, "Flinders Island"},
	{"flr", NULL, NULL, NULL, "Fuliiru"},
	{"fly", NULL, NULL, NULL, "Flaaitaal"},
	{"fmp", NULL, NULL, NULL, "Fe'fe'"},
	{"fmu", NULL, NULL, NULL, "Far Western Muria"},
	{"fnb", NULL, NULL, NULL, "Fanbak"},
	{"fng", NULL, NULL, NULL, "Fanagalo"},
	{"fni", NULL, NULL, NULL, "Fania"},
	{"fod", NULL, NULL, NULL, "Foodo"},
	{"foi", NULL, NULL, NULL, "Foi"},
	{"fom", NULL, NULL, NULL, "Foma"},
	{"fon", "fon", "fon", NULL, "Fon"},
	{"for", NULL, NULL, NULL, "Fore"},
	{"fos", NULL, NULL, NULL, "Siraya"},
	{"fpe", NULL, NULL, NULL, "Fernando Po Creole English"},
	{"fqs", NULL, NULL, NULL, "Fas"},
	{"fra", "fre", "fra", "fr", "French"},
	{"frc", NULL, NULL, NULL, "Cajun French"},
	{"frd", NULL, NULL, NULL, "Fordata"},
	{"frk", NULL, NULL, NULL, "Frankish"},
	{"frm", "frm", "frm", NULL, "Middle French (ca. 1400-1600)"},
	{"fro", "fro", "fro", NULL, "Old French (842-ca. 1400)"},
	{"frp", NULL, NULL, NULL, "Arpitan"},
	{"frq", NULL, NULL, NULL, "Forak"},
	{"frr", "frr", "frr", NULL, "Northern Frisian"},
	{"frs", "frs", "frs", NULL, "Eastern Frisian"},
	{"frt", NULL, NULL, NULL, "Fortsenal"},
	{"fry", "fry", "fry", "fy", "Western Frisian"},
	{"fse", NULL, NULL, NULL, "Finnish Sign Language"},
	{"fsl", NULL, NULL, NULL, "French Sign Language"},
	{"fss", NULL, NULL, NULL, "Finland-Swedish Sign Language"},
	{"fub", NULL, NULL, NULL, "Adamawa Fulfulde"},
	{"fuc", NULL, NULL, NULL, "Pulaar"},
	{"fud", NULL, NULL, NULL, "East Futuna"},
	{"fue", NULL, NULL, NULL, "Borgu Fulfulde"},
	{"fuf", NULL, NULL, NULL, "Pular"},
	{"fuh", NULL, NULL, NULL, "Western Niger Fulfulde"},
	{"fui", NULL, NULL, NULL, "Bagirmi Fulfulde"},
	{"fuj", NULL, NULL, NULL, "Ko"},
	{"ful", "ful", "ful", "ff", "Fulah"},
	{"fum", NULL, NULL, NULL, "Fum"},
	{"fun", NULL, NULL, NULL, "Fulniô"},
	{"fuq", NULL, NULL, NULL, "Central-Eastern Niger Fulfulde"},
	{"fur", "fur", "fur", NULL, "Friulian"},
	{"fut", NULL, NULL, NULL, "Futuna-Aniwa"},
	{"fuu", NULL, NULL, NULL, "Furu"},
	{"fuv", NULL, NULL, NULL, "Nigerian Fulfulde"},
	{"fuy", NULL, NULL, NULL, "Fuyug"},
	{"fvr", NULL, NULL, NULL, "Fur"},
	{"fwa", NULL, NULL, NULL, "Fwâi"},
	{"fwe", NULL, NULL, NULL, "Fwe"},
	{"gaa", "gaa", "gaa", NULL, "Ga"},
	{"gab", NULL, NULL, NULL, "Gabri"},
	{"gac", NULL, NULL, NULL, "Mixed Great Andamanese"},
	{"gad", NULL, NULL, NULL, "Gaddang"},
	{"gae", NULL, NULL, NULL, "Guarequena"},
	{"gaf", NULL, NULL, NULL, "Gende"},
	{"gag", NULL, NULL, NULL, "Gagauz"},
	{"gah", NULL, NULL, NULL, "Alekano"},
	{"gai", NULL, NULL, NULL, "Borei"},
	{"gaj", NULL, NULL, NULL, "Gadsup"},
	{"gak", NULL, NULL, NULL, "Gamkonora"},
	{"gal", NULL, NULL, NULL, "Galolen"},
	{"gam", NULL, NULL, NULL, "Kandawo"},
	{"gan", NULL, NULL, NULL, "Gan Chinese"},
	{"gao", NULL, NULL, NULL, "Gants"},
	{"gap", NULL, NULL, NULL, "Gal"},
	{"gaq", NULL, NULL, NULL, "Gata'"},
	{"gar", NULL, NULL, NULL, "Galeya"},
	{"gas", NULL, NULL, NULL, "Adiwasi Garasia"},
	{"gat", NULL, NULL, NULL, "Kenati"},
	{"gau", NULL, NULL, NULL, "Mudhili Gadaba"},
	{"gaw", NULL, NULL, NULL, "Nobonob"},
	{"gax", NULL, NULL, NULL, "Borana-Arsi-Guji Oromo"},
	{"gay", "gay", "gay", NULL, "Gayo"},
	{"gaz", NULL, NULL, NULL, "West Central Oromo"},
	{"gba", "gba", "gba", NULL, "Gbaya (Central African Republic)"},
	{"gbb", NULL, NULL, NULL, "Kaytetye"},
	{"gbd", NULL, NULL, NULL, "Karajarri"},
	{"gbe", NULL, NULL, NULL, "Niksek"},
	{"gbf", NULL, NULL, NULL, "Gaikundi"},
	{"gbg", NULL, NULL, NULL, "Gbanziri"},
	{"gbh", NULL, NULL, NULL, "Defi Gbe"},
	{"gbi", NULL, NULL, NULL, "Galela"},
	{"gbj", NULL, NULL, NULL, "Bodo Gadaba"},
	{"gbk", NULL, NULL, NULL, "Gaddi"},
	{"gbl", NULL, NULL, NULL, "Gamit"},
	{"gbm", NULL, NULL, NULL, "Garhwali"},
	{"gbn", NULL, NULL, NULL, "Mo'da"},
	{"gbo", NULL, NULL, NULL, "Northern Grebo"},
	{"gbp", NULL, NULL, NULL, "Gbaya-Bossangoa"},
	{"gbq", NULL, NULL, NULL, "Gbaya-Bozoum"},
	{"gbr", NULL, NULL, NULL, "Gbagyi"},
	{"gbs", NULL, NULL, NULL, "Gbesi Gbe"},
	{"gbu", NULL, NULL, NULL, "Gagadu"},
	{"gbv", NULL, NULL, NULL, "Gbanu"},
	{"gbw", NULL, NULL, NULL, "Gabi-Gabi"},
	{"gbx", NULL, NULL, NULL, "Eastern Xwla Gbe"},
	{"gby", NULL, NULL, NULL, "Gbari"},
	{"gbz", NULL, NULL, NULL, "Zoroastrian Dari"},
	{"gcc", NULL, NULL, NULL, "Mali"},
	{"gcd", NULL, NULL, NULL, "Ganggalida"},
	{"gce", NULL, NULL, NULL, "Galice"},
	{"gcf", NULL, NULL, NULL, "Guadeloupean Creole French"},
	{"gcl", NULL, NULL, NULL, "Grenadian Creole English"},
	{"gcn", NULL, NULL, NULL, "Gaina"},
	{"gcr", NULL, NULL, NULL, "Guianese Creole French"},
	{"gct", NULL, NULL, NULL, "Colonia Tovar German"},
	{"gda", NULL, NULL, NULL, "Gade Lohar"},
	{"gdb", NULL, NULL, NULL, "Pottangi Ollar Gadaba"},
	{"gdc", NULL, NULL, NULL, "Gugu Badhun"},
	{"gdd", NULL, NULL, NULL, "Gedaged"},
	{"gde", NULL, NULL, NULL, "Gude"},
	{"gdf", NULL, NULL, NULL, "Guduf-Gava"},
	{"gdg", NULL, NULL, NULL, "Ga'dang"},
	{"gdh", NULL, NULL, NULL, "Gadjerawang"},
	{"gdi", NULL, NULL, NULL, "Gundi"},
	{"gdj", NULL, NULL, NULL, "Gurdjar"},
	{"gdk", NULL, NULL, NULL, "Gadang"},
	{"gdl", NULL, NULL, NULL, "Dirasha"},
	{"gdm", NULL, NULL, NULL, "Laal"},
	{"gdn", NULL, NULL, NULL, "Umanakaina"},
	{"gdo", NULL, NULL, NULL, "Ghodoberi"},
	{"gdq", NULL, NULL, NULL, "Mehri"},
	{"gdr", NULL, NULL, NULL, "Wipi"},
	{"gds", NULL, NULL, NULL, "Ghandruk Sign Language"},
	{"gdt", NULL, NULL, NULL, "Kungardutyi"},
	{"gdu", NULL, NULL, NULL, "Gudu"},
	{"gdx", NULL, NULL, NULL, "Godwari"},
	{"gea", NULL, NULL, NULL, "Geruma"},
	{"geb", NULL, NULL, NULL, "Kire"},
	{"gec", NULL, NULL, NULL, "Gboloo Grebo"},
	{"ged", NULL, NULL, NULL, "Gade"},
	{"gef", NULL, NULL, NULL, "Gerai"},
	{"geg", NULL, NULL, NULL, "Gengle"},
	{"geh", NULL, NULL, NULL, "Hutterite German"},
	{"gei", NULL, NULL, NULL, "Gebe"},
	{"gej", NULL, NULL, NULL, "Gen"},
	{"gek", NULL, NULL, NULL, "Ywom"},
	{"gel", NULL, NULL, NULL, "ut-Ma'in"},
	{"geq", NULL, NULL, NULL, "Geme"},
	{"ges", NULL, NULL, NULL, "Geser-Gorom"},
	{"gev", NULL, NULL, NULL, "Eviya"},
	{"gew", NULL, NULL, NULL, "Gera"},
	{"gex", NULL, NULL, NULL, "Garre"},
	{"gey", NULL, NULL, NULL, "Enya"},
	{"gez", "gez", "gez", NULL, "Geez"},
	{"gfk", NULL, NULL, NULL, "Patpatar"},
	{"gft", NULL, NULL, NULL, "Gafat"},
	{"gga", NULL, NULL, NULL, "Gao"},
	{"ggb", NULL, NULL, NULL, "Gbii"},
	{"ggd", NULL, NULL, NULL, "Gugadj"},
	{"gge", NULL, NULL, NULL, "Gurr-goni"},
	{"ggg", NULL, NULL, NULL, "Gurgula"},
	{"ggk", NULL, NULL, NULL, "Kungarakany"},
	{"ggl", NULL, NULL, NULL, "Ganglau"},
	{"ggt", NULL, NULL, NULL, "Gitua"},
	{"ggu", NULL, NULL, NULL, "Gagu"},
	{"ggw", NULL, NULL, NULL, "Gogodala"},
	{"gha", NULL, NULL, NULL, "Ghadamès"},
	{"ghc", NULL, NULL, NULL, "Hiberno-Scottish Gaelic"},
	{"ghe", NULL, NULL, NULL, "Southern Ghale"},
	{"ghh", NULL, NULL, NULL, "Northern Ghale"},
	{"ghk", NULL, NULL, NULL, "Geko Karen"},
	{"ghl", NULL, NULL, NULL, "Ghulfan"},
	{"ghn", NULL, NULL, NULL, "Ghanongga"},
	{"gho", NULL, NULL, NULL, "Ghomara"},
	{"ghr", NULL, NULL, NULL, "Ghera"},
	{"ghs", NULL, NULL, NULL, "Guhu-Samane"},
	{"ght", NULL, NULL, NULL, "Kuke"},
	{"gia", NULL, NULL, NULL, "Kija"},
	{"gib", NULL, NULL, NULL, "Gibanawa"},
	{"gic", NULL, NULL, NULL, "Gail"},
	{"gid", NULL, NULL, NULL, "Gidar"},
	{"gie", NULL, NULL, NULL, "Gaɓogbo"},
	{"gig", NULL, NULL, NULL, "Goaria"},
	{"gih", NULL, NULL, NULL, "Githabul"},
	{"gii", NULL, NULL, NULL, "Girirra"},
	{"gil", "gil", "gil", NULL, "Gilbertese"},
	{"gim", NULL, NULL, NULL, "Gimi (Eastern Highlands)"},
	{"gin", NULL, NULL, NULL, "Hinukh"},
	{"gip", NULL, NULL, NULL, "Gimi (West New Britain)"},
	{"giq", NULL, NULL, NULL, "Green Gelao"},
	{"gir", NULL, NULL, NULL, "Red Gelao"},
	{"gis", NULL, NULL, NULL, "North Giziga"},
	{"git", NULL, NULL, NULL, "Gitxsan"},
	{"giu", NULL, NULL, NULL, "Mulao"},
	{"giw", NULL, NULL, NULL, "White Gelao"},
	{"gix", NULL, NULL, NULL, "Gilima"},
	{"giy", NULL, NULL, NULL, "Giyug"},
	{"giz", NULL, NULL, NULL, "South Giziga"},
	{"gjk", NULL, NULL, NULL, "Kachi Koli"},
	{"gjm", NULL, NULL, NULL, "Gunditjmara"},
	{"gjn", NULL, NULL, NULL, "Gonja"},
	{"gjr", NULL, NULL, NULL, "Gurindji Kriol"},
	{"gju", NULL, NULL, NULL, "Gujari"},
	{"gka", NULL, NULL, NULL, "Guya"},
	{"gkd", NULL, NULL, NULL, "Magɨ (Madang Province)"},
	{"gke", NULL, NULL, NULL, "Ndai"},
	{"gkn", NULL, NULL, NULL, "Gokana"},
	{"gko", NULL, NULL, NULL, "Kok-Nar"},
	{"gkp", NULL, NULL, NULL, "Guinea Kpelle"},
	{"gku", NULL, NULL, NULL, "ǂUngkue"},
	{"gla", "gla", "gla", "gd", "Scottish Gaelic"},
	{"glb", NULL, NULL, NULL, "Belning"},
	{"glc", NULL, NULL, NULL, "Bon Gula"},
	{"gld", NULL, NULL, NULL, "Nanai"},
	{"gle", "gle", "gle", "ga", "Irish"},
	{"glg", "glg", "glg", "gl", "Galician"},
	{"glh", NULL, NULL, NULL, "Northwest Pashai"},
	{"glj", NULL, NULL, NULL, "Gula Iro"},
	{"glk", NULL, NULL, NULL, "Gilaki"},
	{"gll", NULL, NULL, NULL, "Garlali"},
	{"glo", NULL, NULL, NULL, "Galambu"},
	{"glr", NULL, NULL, NULL, "Glaro-Twabo"},
	{"glu", NULL, NULL, NULL, "Gula (Chad)"},
	{"glv", "glv", "glv", "gv", "Manx"},
	{"glw", NULL, NULL, NULL, "Glavda"},
	{"gly", NULL, NULL, NULL, "Gule"},
	{"gma", NULL, NULL, NULL, "Gambera"},
	{"gmb", NULL, NULL, NULL, "Gula'alaa"},
	{"gmd", NULL, NULL, NULL, "Mághdì"},
	{"gmg", NULL, NULL, NULL, "Magɨyi"},
	{"gmh", "gmh", "gmh", NULL, "Middle High German (ca. 1050-1500)"},
	{"gml", NULL, NULL, NULL, "Middle Low German"},
	{"gmm", NULL, NULL, NULL, "Gbaya-Mbodomo"},
	{"gmn", NULL, NULL, NULL, "Gimnime"},
	{"gmr", NULL, NULL, NULL, "Mirning"},
	{"gmu", NULL, NULL, NULL, "Gumalu"},
	{"gmv", NULL, NULL, NULL, "Gamo"},
	{"gmx", NULL, NULL, NULL, "Magoma"},
	{"gmy", NULL, NULL, NULL, "Mycenaean Greek"},
	{"gmz", NULL, NULL, NULL, "Mgbolizhia"},
	{"gna", NULL, NULL, NULL, "Kaansa"},
	{"gnb", NULL, NULL, NULL, "Gangte"},
	{"gnc", NULL, NULL, NULL, "Guanche"},
	{"gnd", NULL, NULL, NULL, "Zulgo-Gemzek"},
	{"gne", NULL, NULL, NULL, "Ganang"},
	{"gng", NULL, NULL, NULL, "Ngangam"},
	{"gnh", NULL, NULL, NULL, "Lere"},
	{"gni", NULL, NULL, NULL, "Gooniyandi"},
	{"gnj", NULL, NULL, NULL, "Ngen"},
	{"gnk", NULL, NULL, NULL, "ǁGana"},
	{"gnl", NULL, NULL, NULL, "Gangulu"},
	{"gnm", NULL, NULL, NULL, "Ginuman"},
	{"gnn", NULL, NULL, NULL, "Gumatj"},
	{"gno", NULL, NULL, NULL, "Northern Gondi"},
	{"gnq", NULL, NULL, NULL, "Gana"},
	{"gnr", NULL, NULL, NULL, "Gureng Gureng"},
	{"gnt", NULL, NULL, NULL, "Guntai"},
	{"gnu", NULL, NULL, NULL, "Gnau"},
	{"gnw", NULL, NULL, NULL, "Western Bolivian Guaraní"},
	{"gnz", NULL, NULL, NULL, "Ganzi"},
	{"goa", NULL, NULL, NULL, "Guro"},
	{"gob", NULL, NULL, NULL, "Playero"},
	{"goc", NULL, NULL, NULL, "Gorakor"},
	{"god", NULL, NULL, NULL, "Godié"},
	{"goe", NULL, NULL, NULL, "Gongduk"},
	{"gof", NULL, NULL, NULL, "Gofa"},
	{"gog", NULL, NULL, NULL, "Gogo"},
	{"goh", "goh", "goh", NULL, "Old High German (ca. 750-1050)"},
	{"goi", NULL, NULL, NULL, "Gobasi"},
	{"goj", NULL, NULL, NULL, "Gowlan"},
	{"gok", NULL, NULL, NULL, "Gowli"},
	{"gol", NULL, NULL, NULL, "Gola"},
	{"gom", NULL, NULL, NULL, "Goan Konkani"},
	{"gon", "gon", "gon", NULL, "Gondi"},
	{"goo", NULL, NULL, NULL, "Gone Dau"},
	{"gop", NULL, NULL, NULL, "Yeretuar"},
	{"goq", NULL, NULL, NULL, "Gorap"},
	{"gor", "gor", "gor", NULL, "Gorontalo"},
	{"gos", NULL, NULL, NULL, "Gronings"},
	{"got", "got", "got", NULL, "Gothic"},
	{"gou", NULL, NULL, NULL, "Gavar"},
	{"gow", NULL, NULL, NULL, "Gorowa"},
	{"gox", NULL, NULL, NULL, "Gobu"},
	{"goy", NULL, NULL, NULL, "Goundo"},
	{"goz", NULL, NULL, NULL, "Gozarkhani"},
	{"gpa", NULL, NULL, NULL, "Gupa-Abawa"},
	{"gpe", NULL, NULL, NULL, "Ghanaian Pidgin English"},
	{"gpn", NULL, NULL, NULL, "Taiap"},
	{"gqa", NULL, NULL, NULL, "Ga'anda"},
	{"gqi", NULL, NULL, NULL, "Guiqiong"},
	{"gqn", NULL, NULL, NULL, "Guana (Brazil)"},
	{"gqr", NULL, NULL, NULL, "Gor"},
	{"gqu", NULL, NULL, NULL, "Qau"},
	{"gra", NULL, NULL, NULL, "Rajput Garasia"},
	{"grb", "grb", "grb", NULL, "Grebo"},
	{"grc", "grc", "grc", NULL, "Ancient Greek (to 1453)"},
	{"grd", NULL, NULL, NULL, "Guruntum-Mbaaru"},
	{"grg", NULL, NULL, NULL, "Madi"},
	{"grh", NULL, NULL, NULL, "Gbiri-Niragu"},
	{"gri", NULL, NULL, NULL, "Ghari"},
	{"grj", NULL, NULL, NULL, "Southern Grebo"},
	{"grm", NULL, NULL, NULL, "Kota Marudu Talantang"},
	{"grn", "grn", "grn", "gn", "Guarani"},
	{"gro", NULL, NULL, NULL, "Groma"},
	{"grq", NULL, NULL, NULL, "Gorovu"},
	{"grr", NULL, NULL, NULL, "Taznatit"},
	{"grs", NULL, NULL, NULL, "Gresi"},
	{"grt", NULL, NULL, NULL, "Garo"},
	{"gru", NULL, NULL, NULL, "Kistane"},
	{"grv", NULL, NULL, NULL, "Central Grebo"},
	{"grw", NULL, NULL, NULL, "Gweda"},
	{"grx", NULL, NULL, NULL, "Guriaso"},
	{"gry", NULL, NULL, NULL, "Barclayville Grebo"},
	{"grz", NULL, NULL, NULL, "Guramalum"},
	{"gse", NULL, NULL, NULL, "Ghanaian Sign Language"},
	{"gsg", NULL, NULL, NULL, "German Sign Language"},
	{"gsl", NULL, NULL, NULL, "Gusilay"},
	{"gsm", NULL, NULL, NULL, "Guatemalan Sign Language"},
	{"gsn", NULL, NULL, NULL, "Nema"},
	{"gso", NULL, NULL, NULL, "Southwest Gbaya"},
	{"gsp", NULL, NULL, NULL, "Wasembo"},
	{"gss", NULL, NULL, NULL, "Greek Sign Language"},
	{"gsw", "gsw", "gsw", NULL, "Swiss German"},
	{"gta", NULL, NULL, NULL, "Guató"},
	{"gtu", NULL, NULL, NULL, "Aghu-Tharnggala"},
	{"gua", NULL, NULL, NULL, "Shiki"},
	{"gub", NULL, NULL, NULL, "Guajajára"},
	{"guc", NULL, NULL, NULL, "Wayuu"},
	{"gud", NULL, NULL, NULL, "Yocoboué Dida"},
	{"gue", NULL, NULL, NULL, "Gurindji"},
	{"guf", NULL, NULL, NULL, "Gupapuyngu"},
	{"gug", NULL, NULL, NULL, "Paraguayan Guaraní"},
	{"guh", NULL, NULL, NULL, "Guahibo"},
	{"gui", NULL, NULL, NULL, "Eastern Bolivian Guaraní"},
	{"guj", "guj", "guj", "gu", "Gujarati"},
	{"guk", NULL, NULL, NULL, "Gumuz"},
	{"gul", NULL, NULL, NULL, "Sea Island Creole English"},
	{"gum", NULL, NULL, NULL, "Guambiano"},
	{"gun", NULL, NULL, NULL, "Mbyá Guaraní"},
	{"guo", NULL, NULL, NULL, "Guayabero"},
	{"gup", NULL, NULL, NULL, "Gunwinggu"},
	{"guq", NULL, NULL, NULL, "Aché"},
	{"gur", NULL, NULL, NULL, "Farefare"},
	{"gus", NULL, NULL, NULL, "Guinean Sign Language"},
	{"gut", NULL, NULL, NULL, "Maléku Jaíka"},
	{"guu", NULL, NULL, NULL, "Yanomamö"},
	{"guw", NULL, NULL, NULL, "Gun"},
	{"gux", NULL, NULL, NULL, "Gourmanchéma"},
	{"guz", NULL, NULL, NULL, "Gusii"},
	{"gva", NULL, NULL, NULL, "Guana (Paraguay)"},
	{"gvc", NULL, NULL, NULL, "Guanano"},
	{"gve", NULL, NULL, NULL, "Duwet"},
	{"gvf", NULL, NULL, NULL, "Golin"},
	{"gvj", NULL, NULL, NULL, "Guajá"},
	{"gvl", NULL, NULL, NULL, "Gulay"},
	{"gvm", NULL, NULL, NULL, "Gurmana"},
	{"gvn", NULL, NULL, NULL, "Kuku-Yalanji"},
	{"gvo", NULL, NULL, NULL, "Gavião Do Jiparaná"},
	{"gvp", NULL, NULL, NULL, "Pará Gavião"},
	{"gvr", NULL, NULL, NULL, "Gurung"},
	{"gvs", NULL, NULL, NULL, "Gumawana"},
	{"gvy", NULL, NULL, NULL, "Guyani"},
	{"gwa", NULL, NULL, NULL, "Mbato"},
	{"gwb", NULL, NULL, NULL, "Gwa"},
	{"gwc", NULL, NULL, NULL, "Gawri"},
	{"gwd", NULL, NULL, NULL, "Gawwada"},
	{"gwe", NULL, NULL, NULL, "Gweno"},
	{"gwf", NULL, NULL, NULL, "Gowro"},
	{"gwg", NULL, NULL, NULL, "Moo"},
	{"gwi", "gwi", "gwi", NULL, "Gwichʼin"},
	{"gwj", NULL, NULL, NULL, "ǀGwi"},
	{"gwm", NULL, NULL, NULL, "Awngthim"},
	{"gwn", NULL, NULL, NULL, "Gwandara"},
	{"gwr", NULL, NULL, NULL, "Gwere"},
	{"gwt", NULL, NULL, NULL, "Gawar-Bati"},
	{"gwu", NULL, NULL, NULL, "Guwamu"},
	{"gww", NULL, NULL, NULL, "Kwini"},
	{"gwx", NULL, NULL, NULL, "Gua"},
	{"gxx", NULL, NULL, NULL, "Wè Southern"},
	{"gya", NULL, NULL, NULL, "Northwest Gbaya"},
	{"gyb", NULL, NULL, NULL, "Garus"},
	{"gyd", NULL, NULL, NULL, "Kayardild"},
	{"gye", NULL, NULL, NULL, "Gyem"},
	{"gyf", NULL, NULL, NULL, "Gungabula"},
	{"gyg", NULL, NULL, NULL, "Gbayi"},
	{"gyi", NULL, NULL, NULL, "Gyele"},
	{"gyl", NULL, NULL, NULL, "Gayil"},
	{"gym", NULL, NULL, NULL, "Ngäbere"},
	{"gyn", NULL, NULL, NULL, "Guyanese Creole English"},
	{"gyo", NULL, NULL, NULL, "Gyalsumdo"},
	{"gyr", NULL, NULL, NULL, "Guarayu"},
	{"gyy", NULL, NULL, NULL, "Gunya"},
	{"gyz", NULL, NULL, NULL, "Geji"},
	{"gza", NULL, NULL, NULL, "Ganza"},
	{"gzi", NULL, NULL, NULL, "Gazi"},
	{"gzn", NULL, NULL, NULL, "Gane"},
	{"haa", NULL, NULL, NULL, "Han"},
	{"hab", NULL, NULL, NULL, "Hanoi Sign Language"},
	{"hac", NULL, NULL, NULL, "Gurani"},
	{"had", NULL, NULL, NULL, "Hatam"},
	{"hae", NULL, NULL, NULL, "Eastern Oromo"},
	{"haf", NULL, NULL, NULL, "Haiphong Sign Language"},
	{"hag", NULL, NULL, NULL, "Hanga"},
	{"hah", NULL, NULL, NULL, "Hahon"},
	{"hai", "hai", "hai", NULL, "Haida"},
	{"haj", NULL, NULL, NULL, "Hajong"},
	{"hak", NULL, NULL, NULL, "Hakka Chinese"},
	{"hal", NULL, NULL, NULL, "Halang"},
	{"ham", NULL, NULL, NULL, "Hewa"},
	{"han", NULL, NULL, NULL, "Hangaza"},
	{"hao", NULL, NULL, NULL, "Hakö"},
	{"hap", NULL, NULL, NULL, "Hupla"},
	{"haq", NULL, NULL, NULL, "Ha"},
	{"har", NULL, NULL, NULL, "Harari"},
	{"has", NULL, NULL, NULL, "Haisla"},
	{"hat", "hat", "hat", "ht", "Haitian"},
	{"hau", "hau", "hau", "ha", "Hausa"},
	{"hav", NULL, NULL, NULL, "Havu"},
	{"haw", "haw", "haw", NULL, "Hawaiian"},
	{"hax", NULL, NULL, NULL, "Southern Haida"},
	{"hay", NULL, NULL, NULL, "Haya"},
	{"haz", NULL, NULL, NULL, "Hazaragi"},
	{"hba", NULL, NULL, NULL, "Hamba"},
	{"hbb", NULL, NULL, NULL, "Huba"},
	{"hbn", NULL, NULL, NULL, "Heiban"},
	{"hbo", NULL, NULL, NULL, "Ancient Hebrew"},
	{"hbs", NULL, NULL, "sh", "Serbo-Croatian"},
	{"hbu", NULL, NULL, NULL, "Habu"},
	{"hca", NULL, NULL, NULL, "Andaman Creole Hindi"},
	{"hch", NULL, NULL, NULL, "Huichol"},
	{"hdn", NULL, NULL, NULL, "Northern Haida"},
	{"hds", NULL, NULL, NULL, "Honduras Sign Language"},
	{"hdy", NULL, NULL, NULL, "Hadiyya"},
	{"hea", NULL, NULL, NULL, "Northern Qiandong Miao"},
	{"heb", "heb", "heb", "he", "Hebrew"},
	{"hed", NULL, NULL, NULL, "Herdé"},
	{"heg", NULL, NULL, NULL, "Helong"},
	{"heh", NULL, NULL, NULL, "Hehe"},
	{"hei", NULL, NULL, NULL, "Heiltsuk"},
	{"hem", NULL, NULL, NULL, "Hemba"},
	{"her", "her", "her", "hz", "Herero"},
	{"hgm", NULL, NULL, NULL, "Haiǁom"},
	{"hgw", NULL, NULL, NULL, "Haigwai"},
	{"hhi", NULL, NULL, NULL, "Hoia Hoia"},
	{"hhr", NULL, NULL, NULL, "Kerak"},
	{"hhy", NULL, NULL, NULL, "Hoyahoya"},
	{"hia", NULL, NULL, NULL, "Lamang"},
	{"hib", NULL, NULL, NULL, "Hibito"},
	{"hid", NULL, NULL, NULL, "Hidatsa"},
	{"hif", NULL, NULL, NULL, "Fiji Hindi"},
	{"hig", NULL, NULL, NULL, "Kamwe"},
	{"hih", NULL, NULL, NULL, "Pamosu"},
	{"hii", NULL, NULL, NULL, "Hinduri"},
	{"hij", NULL, NULL, NULL, "Hijuk"},
	{"hik", NULL, NULL, NULL, "Seit-Kaitetu"},
	{"hil", "hil", "hil", NULL, "Hiligaynon"},
	{"hin", "hin", "hin", "hi", "Hindi"},
	{"hio", NULL, NULL, NULL, "Tsoa"},
	{"hir", NULL, NULL, NULL, "Himarimã"},
	{"hit", "hit", "hit", NULL, "Hittite"},
	{"hiw", NULL, NULL, NULL, "Hiw"},
	{"hix", NULL, NULL, NULL, "Hixkaryána"},
	{"hji", NULL, NULL, NULL, "Haji"},
	{"hka", NULL, NULL, NULL, "Kahe"},
	{"hke", NULL, NULL, NULL, "Hunde"},
	{"hkh", NULL, NULL, NULL, "Khah"},
	{"hkk", NULL, NULL, NULL, "Hunjara-Kaina Ke"},
	{"hkn", NULL, NULL, NULL, "Mel-Khaonh"},
	{"hks", NULL, NULL, NULL, "Hong Kong Sign Language"},
	{"hla", NULL, NULL, NULL, "Halia"},
	{"hlb", NULL, NULL, NULL, "Halbi"},
	{"hld", NULL, NULL, NULL, "Halang Doan"},
	{"hle", NULL, NULL, NULL, "Hlersu"},
	{"hlt", NULL, NULL, NULL, "Matu Chin"},
	{"hlu", NULL, NULL, NULL, "Hieroglyphic Luwian"},
	{"hma", NULL, NULL, NULL, "Southern Mashan Hmong"},
	{"hmb", NULL, NULL, NULL, "Humburi Senni Songhay"},
	{"hmc", NULL, NULL, NULL, "Central Huishui Hmong"},
	{"hmd", NULL, NULL, NULL, "Large Flowery Miao"},
	{"hme", NULL, NULL, NULL, "Eastern Huishui Hmong"},
	{"hmf", NULL, NULL, NULL, "Hmong Don"},
	{"hmg", NULL, NULL, NULL, "Southwestern Guiyang Hmong"},
	{"hmh", NULL, NULL, NULL, "Southwestern Huishui Hmong"},
	{"hmi", NULL, NULL, NULL, "Northern Huishui Hmong"},
	{"hmj", NULL, NULL, NULL, "Ge"},
	{"hmk", NULL, NULL, NULL, "Maek"},
	{"hml", NULL, NULL, NULL, "Luopohe Hmong"},
	{"hmm", NULL, NULL, NULL, "Central Mashan Hmong"},
	{"hmn", "hmn", "hmn", NULL, "Hmong"},
	{"hmo", "hmo", "hmo", "ho", "Hiri Motu"},
	{"hmp", NULL, NULL, NULL, "Northern Mashan Hmong"},
	{"hmq", NULL, NULL, NULL, "Eastern Qiandong Miao"},
	{"hmr", NULL, NULL, NULL, "Hmar"},
	{"hms", NULL, NULL, NULL, "Southern Qiandong Miao"},
	{"hmt", NULL, NULL, NULL, "Hamtai"},
	{"hmu", NULL, NULL, NULL, "Hamap"},
	{"hmv", NULL, NULL, NULL, "Hmong Dô"},
	{"hmw", NULL, NULL, NULL, "Western Mashan Hmong"},
	{"hmy", NULL, NULL, NULL, "Southern Guiyang Hmong"},
	{"hmz", NULL, NULL, NULL, "Hmong Shua"},
	{"hna", NULL, NULL, NULL, "Mina (Cameroon)"},
	{"hnd", NULL, NULL, NULL, "Southern Hindko"},
	{"hne", NULL, NULL, NULL, "Chhattisgarhi"},
	{"hng", NULL, NULL, NULL, "Hungu"},
	{"hnh", NULL, NULL, NULL, "ǁAni"},
	{"hni", NULL, NULL, NULL, "Hani"},
	{"hnj", NULL, NULL, NULL, "Hmong Njua"},
	{"hnn", NULL, NULL, NULL, "Hanunoo"},
	{"hno", NULL, NULL, NULL, "Northern Hindko"},
	{"hns", NULL, NULL, NULL, "Caribbean Hindustani"},
	{"hnu", NULL, NULL, NULL, "Hung"},
	{"hoa", NULL, NULL, NULL, "Hoava"},
	{"hob", NULL, NULL, NULL, "Mari (Madang Province)"},
	{"hoc", NULL, NULL, NULL, "Ho"},
	{"hod", NULL, NULL, NULL, "Holma"},
	{"hoe", NULL, NULL, NULL, "Horom"},
	{"hoh", NULL, NULL, NULL, "Hobyót"},
	{"hoi", NULL, NULL, NULL, "Holikachuk"},
	{"hoj", NULL, NULL, NULL, "Hadothi"},
	{"hol", NULL, NULL, NULL, "Holu"},
	{"hom", NULL, NULL, NULL, "Homa"},
	{"hoo", NULL, NULL, NULL, "Holoholo"},
	{"hop", NULL, NULL, NULL, "Hopi"},
	{"hor", NULL, NULL, NULL, "Horo"},
	{"hos", NULL, NULL, NULL, "Ho Chi Minh City Sign Language"},
	{"hot", NULL, NULL, NULL, "Hote"},
	{"hov", NULL, NULL, NULL, "Hovongan"},
	{"how", NULL, NULL, NULL, "Honi"},
	{"hoy", NULL, NULL, NULL, "Holiya"},
	{"hoz", NULL, NULL, NULL, "Hozo"},
	{"hpo", NULL, NULL, NULL, "Hpon"},
	{"hps", NULL, NULL, NULL, "Hawai'i Sign Language (HSL)"},
	{"hra", NULL, NULL, NULL, "Hrangkhol"},
	{"hrc", NULL, NULL, NULL, "Niwer Mil"},
	{"hre", NULL, NULL, NULL, "Hre"},
	{"hrk", NULL, NULL, NULL, "Haruku"},
	{"hrm", NULL, NULL, NULL, "Horned Miao"},
	{"hro", NULL, NULL, NULL, "Haroi"},
	{"hrp", NULL, NULL, NULL, "Nhirrpi"},
	{"hrt", NULL, NULL, NULL, "Hértevin"},
	{"hru", NULL, NULL, NULL, "Hruso"},
	{"hrv", "hrv", "hrv", "hr", "Croatian"},
	{"hrw", NULL, NULL, NULL, "Warwar Feni"},
	{"hrx", NULL, NULL, NULL, "Hunsrik"},
	{"hrz", NULL, NULL, NULL, "Harzani"},
	{"hsb", "hsb", "hsb", NULL, "Upper Sorbian"},
	{"hsh", NULL, NULL, NULL, "Hungarian Sign Language"},
	{"hsl", NULL, NULL, NULL, "Hausa Sign Language"},
	{"hsn", NULL, NULL, NULL, "Xiang Chinese"},
	{"hss", NULL, NULL, NULL, "Harsusi"},
	{"hti", NULL, NULL, NULL, "Hoti"},
	{"hto", NULL, NULL, NULL, "Minica Huitoto"},
	{"hts", NULL, NULL, NULL, "Hadza"},
	{"htu", NULL, NULL, NULL, "Hitu"},
	{"htx", NULL, NULL, NULL, "Middle Hittite"},
	{"hub", NULL, NULL, NULL, "Huambisa"},
	{"huc", NULL, NULL, NULL, "ǂHua"},
	{"hud", NULL, NULL, NULL, "Huaulu"},
	{"hue", NULL, NULL, NULL, "San Francisco Del Mar Huave"},
	{"huf", NULL, NULL, NULL, "Humene"},
	{"hug", NULL, NULL, NULL, "Huachipaeri"},
	{"huh", NULL, NULL, NULL, "Huilliche"},
	{"hui", NULL, NULL, NULL, "Huli"},
	{"huj", NULL, NULL, NULL, "Northern Guiyang Hmong"},
	{"huk", NULL, NULL, NULL, "Hulung"},
	{"hul", NULL, NULL, NULL, "Hula"},
	{"hum", NULL, NULL, NULL, "Hungana"},
	{"hun", "hun", "hun", "hu", "Hungarian"},
	{"huo", NULL, NULL, NULL, "Hu"},
	{"hup", "hup", "hup", NULL, "Hupa"},
	{"huq", NULL, NULL, NULL, "Tsat"},
	{"hur", NULL, NULL, NULL, "Halkomelem"},
	{"hus", NULL, NULL, NULL, "Huastec"},
	{"hut", NULL, NULL, NULL, "Humla"},
	{"huu", NULL, NULL, NULL, "Murui Huitoto"},
	{"huv", NULL, NULL, NULL, "San Mateo Del Mar Huave"},
	{"huw", NULL, NULL, NULL, "Hukumina"},
	{"hux", NULL, NULL, NULL, "Nüpode Huitoto"},
	{"huy", NULL, NULL, NULL, "Hulaulá"},
	{"huz", NULL, NULL, NULL, "Hunzib"},
	{"hvc", NULL, NULL, NULL, "Haitian Vodoun Culture Language"},
	{"hve", NULL, NULL, NULL, "San Dionisio Del Mar Huave"},
	{"hvk", NULL, NULL, NULL, "Haveke"},
	{"hvn", NULL, NULL, NULL, "Sabu"},
	{"hvv", NULL, NULL, NULL, "Santa María Del Mar Huave"},
	{"hwa", NULL, NULL, NULL, "Wané"},
	{"hwc", NULL, NULL, NULL, "Hawai'i Creole English"},
	{"hwo", NULL, NULL, NULL, "Hwana"},
	{"hya", NULL, NULL, NULL, "Hya"},
	{"hye", "arm", "hye", "hy", "Armenian"},
	{"hyw", NULL, NULL, NULL, "Western Armenian"},
	{"iai", NULL, NULL, NULL, "Iaai"},
	{"ian", NULL, NULL, NULL, "Iatmul"},
	{"iar", NULL, NULL, NULL, "Purari"},
	{"iba", "iba", "iba", NULL, "Iban"},
	{"ibb", NULL, NULL, NULL, "Ibibio"},
	{"ibd", NULL, NULL, NULL, "Iwaidja"},
	{"ibe", NULL, NULL, NULL, "Akpes"},
	{"ibg", NULL, NULL, NULL, "Ibanag"},
	{"ibh", NULL, NULL, NULL, "Bih"},
	{"ibl", NULL, NULL, NULL, "Ibaloi"},
	{"ibm", NULL, NULL, NULL, "Agoi"},
	{"ibn", NULL, NULL, NULL, "Ibino"},
	{"ibo", "ibo", "ibo", "ig", "Igbo"},
	{"ibr", NULL, NULL, NULL, "Ibuoro"},
	{"ibu", NULL, NULL, NULL, "Ibu"},
	{"iby", NULL, NULL, NULL, "Ibani"},
	{"ica", NULL, NULL, NULL, "Ede Ica"},
	{"ich", NULL, NULL, NULL, "Etkywan"},
	{"icl", NULL, NULL, NULL, "Icelandic Sign Language"},
	{"icr", NULL, NULL, NULL, "Islander Creole English"},
	{"ida", NULL, NULL, NULL, "Idakho-Isukha-Tiriki"},
	{"idb", NULL, NULL, NULL, "Indo-Portuguese"},
	{"idc", NULL, NULL, NULL, "Idon"},
	{"idd", NULL, NULL, NULL, "Ede Idaca"},
	{"ide", NULL, NULL, NULL, "Idere"},
	{"idi", NULL, NULL, NULL, "Idi"},
	{"ido", "ido", "ido", "io", "Ido"},
	{"idr", NULL, NULL, NULL, "Indri"},
	{"ids", NULL, NULL, NULL, "Idesa"},
	{"idt", NULL, NULL, NULL, "Idaté"},
	{"idu", NULL, NULL, NULL, "Idoma"},
	{"ifa", NULL, NULL, NULL, "Amganad Ifugao"},
	{"ifb", NULL, NULL, NULL, "Batad Ifugao"},
	{"ife", NULL, NULL, NULL, "Ifè"},
	{"iff", NULL, NULL, NULL, "Ifo"},
	{"ifk", NULL, NULL, NULL, "Tuwali Ifugao"},
	{"ifm", NULL, NULL, NULL, "Teke-Fuumu"},
	{"ifu", NULL, NULL, NULL, "Mayoyao Ifugao"},
	{"ify", NULL, NULL, NULL, "Keley-I Kallahan"},
	{"igb", NULL, NULL, NULL, "Ebira"},
	{"ige", NULL, NULL, NULL, "Igede"},
	{"igg", NULL, NULL, NULL, "Igana"},
	{"igl", NULL, NULL, NULL, "Igala"},
	{"igm", NULL, NULL, NULL, "Kanggape"},
	{"ign", NULL, NULL, NULL, "Ignaciano"},
	{"igo", NULL, NULL, NULL, "Isebe"},
	{"igs", NULL, NULL, NULL, "Interglossa"},
	{"igw", NULL, NULL, NULL, "Igwe"},
	{"ihb", NULL, NULL, NULL, "Iha Based Pidgin"},
	{"ihi", NULL, NULL, NULL, "Ihievbe"},
	{"ihp", NULL, NULL, NULL, "Iha"},
	{"ihw", NULL, NULL, NULL, "Bidhawal"},
	{"iii", "iii", "iii", "ii", "Sichuan Yi"},
	{"iin", NULL, NULL, NULL, "Thiin"},
	{"ijc", NULL, NULL, NULL, "Izon"},
	{"ije", NULL, NULL, NULL, "Biseni"},
	{"ijj", NULL, NULL, NULL, "Ede Ije"},
	{"ijn", NULL, NULL, NULL, "Kalabari"},
	{"ijs", NULL, NULL, NULL, "Southeast Ijo"},
	{"ike", NULL, NULL, NULL, "Eastern Canadian Inuktitut"},
	{"iki", NULL, NULL, NULL, "Iko"},
	{"ikk", NULL, NULL, NULL, "Ika"},
	{"ikl", NULL, NULL, NULL, "Ikulu"},
	{"iko", NULL, NULL, NULL, "Olulumo-Ikom"},
	{"ikp", NULL, NULL, NULL, "Ikpeshi"},
	{"ikr", NULL, NULL, NULL, "Ikaranggal"},
	{"iks", NULL, NULL, NULL, "Inuit Sign Language"},
	{"ikt", NULL, NULL, NULL, "Inuinnaqtun"},
	{"iku", "iku", "iku", "iu", "Inuktitut"},
	{"ikv", NULL, NULL, NULL, "Iku-Gora-Ankwa"},
	{"ikw", NULL, NULL, NULL, "Ikwere"},
	{"ikx", NULL, NULL, NULL, "Ik"},
	{"ikz", NULL, NULL, NULL, "Ikizu"},
	{"ila", NULL, NULL, NULL, "Ile Ape"},
	{"ilb", NULL, NULL, NULL, "Ila"},
	{"ile", "ile", "ile", "ie", "Interlingue"},
	{"ilg", NULL, NULL, NULL, "Garig-Ilgar"},
	{"ili", NULL, NULL, NULL, "Ili Turki"},
	{"ilk", NULL, NULL, NULL, "Ilongot"},
	{"ilm", NULL, NULL, NULL, "Iranun (Malaysia)"},
	{"ilo", "ilo", "ilo", NULL, "Iloko"},
	{"ilp", NULL, NULL, NULL, "Iranun (Philippines)"},
	{"ils", NULL, NULL, NULL, "International Sign"},
	{"ilu", NULL, NULL, NULL, "Ili'uun"},
	{"ilv", NULL, NULL, NULL, "Ilue"},
	{"ima", NULL, NULL, NULL, "Mala Malasar"},
	{"imi", NULL, NULL, NULL, "Anamgura"},
	{"iml", NULL, NULL, NULL, "Miluk"},
	{"imn", NULL, NULL, NULL, "Imonda"},
	{"imo", NULL, NULL, NULL, "Imbongu"},
	{"imr", NULL, NULL, NULL, "Imroing"},
	{"ims", NULL, NULL, NULL, "Marsian"},
	{"imy", NULL, NULL, NULL, "Milyan"},
	{"ina", "ina", "ina", "ia", "Interlingua (International Auxiliary Language Association)"},
	{"inb", NULL, NULL, NULL, "Inga"},
	{"ind", "ind", "ind", "id", "Indonesian"},
	{"ing", NULL, NULL, NULL, "Degexit'an"},
	{"inh", "inh", "inh", NULL, "Ingush"},
	{"inj", NULL, NULL, NULL, "Jungle Inga"},
	{"inl", NULL, NULL, NULL, "Indonesian Sign Language"},
	{"inm", NULL, NULL, NULL, "Minaean"},
	{"inn", NULL, NULL, NULL, "Isinai"},
	{"ino", NULL, NULL, NULL, "Inoke-Yate"},
	{"inp", NULL, NULL, NULL, "Iñapari"},
	{"ins", NULL, NULL, NULL, "Indian Sign Language"},
	{"int", NULL, NULL, NULL, "Intha"},
	{"inz", NULL, NULL, NULL, "Ineseño"},
	{"ior", NULL, NULL, NULL, "Inor"},
	{"iou", NULL, NULL, NULL, "Tuma-Irumu"},
	{"iow", NULL, NULL, NULL, "Iowa-Oto"},
	{"ipi", NULL, NULL, NULL, "Ipili"},
	{"ipk", "ipk", "ipk", "ik", "Inupiaq"},
	{"ipo", NULL, NULL, NULL, "Ipiko"},
	{"iqu", NULL, NULL, NULL, "Iquito"},
	{"iqw", NULL, NULL, NULL, "Ikwo"},
	{"ire", NULL, NULL, NULL, "Iresim"},
	{"irh", NULL, NULL, NULL, "Irarutu"},
	{"iri", NULL, NULL, NULL, "Rigwe"},
	{"irk", NULL, NULL, NULL, "Iraqw"},
	{"irn", NULL, NULL, NULL, "Irántxe"},
	{"irr", NULL, NULL, NULL, "Ir"},
	{"iru", NULL, NULL, NULL, "Irula"},
	{"irx", NULL, NULL, NULL, "Kamberau"},
	{"iry", NULL, NULL, NULL, "Iraya"},
	{"isa", NULL, NULL, NULL, "Isabi"},
	{"isc", NULL, NULL, NULL, "Isconahua"},
	{"isd", NULL, NULL, NULL, "Isnag"},
	{"ise", NULL, NULL, NULL, "Italian Sign Language"},
	{"isg", NULL, NULL, NULL, "Irish Sign Language"},
	{"ish", NULL, NULL, NULL, "Esan"},
	{"isi", NULL, NULL, NULL, "Nkem-Nkum"},
	{"isk", NULL, NULL, NULL, "Ishkashimi"},
	{"isl", "ice", "isl", "is", "Icelandic"},
	{"ism", NULL, NULL, NULL, "Masimasi"},
	{"isn", NULL, NULL, NULL, "Isanzu"},
	{"iso", NULL, NULL, NULL, "Isoko"},
	{"isr", NULL, NULL, NULL, "Israeli Sign Language"},
	{"ist", NULL, NULL, NULL, "Istriot"},
	{"isu", NULL, NULL, NULL, "Isu (Menchum Division)"},
	{"ita", "ita", "ita", "it", "Italian"},
	{"itb", NULL, NULL, NULL, "Binongan Itneg"},
	{"itd", NULL, NULL, NULL, "Southern Tidung"},
	{"ite", NULL, NULL, NULL, "Itene"},
	{"iti", NULL, NULL, NULL, "Inlaod Itneg"},
	{"itk", NULL, NULL, NULL, "Judeo-Italian"},
	{"itl", NULL, NULL, NULL, "Itelmen"},
	{"itm", NULL, NULL, NULL, "Itu Mbon Uzo"},
	{"ito", NULL, NULL, NULL, "Itonama"},
	{"itr", NULL, NULL, NULL, "Iteri"},
	{"its", NULL, NULL, NULL, "Isekiri"},
	{"itt", NULL, NULL, NULL, "Maeng Itneg"},
	{"itv", NULL, NULL, NULL, "Itawit"},
	{"itw", NULL, NULL, NULL, "Ito"},
	{"itx", NULL, NULL, NULL, "Itik"},
	{"ity", NULL, NULL, NULL, "Moyadan Itneg"},
	{"itz", NULL, NULL, NULL, "Itzá"},
	{"ium", NULL, NULL, NULL, "Iu Mien"},
	{"ivb", NULL, NULL, NULL, "Ibatan"},
	{"ivv", NULL, NULL, NULL, "Ivatan"},
	{"iwk", NULL, NULL, NULL, "I-Wak"},
	{"iwm", NULL, NULL, NULL, "Iwam"},
	{"iwo", NULL, NULL, NULL, "Iwur"},
	{"iws", NULL, NULL, NULL, "Sepik Iwam"},
	{"ixc", NULL, NULL, NULL, "Ixcatec"},
	{"ixl", NULL, NULL, NULL, "Ixil"},
	{"iya", NULL, NULL, NULL, "Iyayu"},
	{"iyo", NULL, NULL, NULL, "Mesaka"},
	{"iyx", NULL, NULL, NULL, "Yaka (Congo)"},
	{"izh", NULL, NULL, NULL, "Ingrian"},
	{"izr", NULL, NULL, NULL, "Izere"},
	{"izz", NULL, NULL, NULL, "Izii"},
	{"jaa", NULL, NULL, NULL, "Jamamadí"},
	{"jab", NULL, NULL, NULL, "Hyam"},
	{"jac", NULL, NULL, NULL, "Popti'"},
	{"jad", NULL, NULL, NULL, "Jahanka"},
	{"jae", NULL, NULL, NULL, "Yabem"},
	{"jaf", NULL, NULL, NULL, "Jara"},
	{"jah", NULL, NULL, NULL, "Jah Hut"},
	{"jaj", NULL, NULL, NULL, "Zazao"},
	{"jak", NULL, NULL, NULL, "Jakun"},
	{"jal", NULL, NULL, NULL, "Yalahatan"},
	{"jam", NULL, NULL, NULL, "Jamaican Creole English"},
	{"jan", NULL, NULL, NULL, "Jandai"},
	{"jao", NULL, NULL, NULL, "Yanyuwa"},
	{"jaq", NULL, NULL, NULL, "Yaqay"},
	{"jas", NULL, NULL, NULL, "New Caledonian Javanese"},
	{"jat", NULL, NULL, NULL, "Jakati"},
	{"jau", NULL, NULL, NULL, "Yaur"},
	{"jav", "jav", "jav", "jv", "Javanese"},
	{"jax", NULL, NULL, NULL, "Jambi Malay"},
	{"jay", NULL, NULL, NULL, "Yan-nhangu"},
	{"jaz", NULL, NULL, NULL, "Jawe"},
	{"jbe", NULL, NULL, NULL, "Judeo-Berber"},
	{"jbi", NULL, NULL, NULL, "Badjiri"},
	{"jbj", NULL, NULL, NULL, "Arandai"},
	{"jbk", NULL, NULL, NULL, "Barikewa"},
	{"jbm", NULL, NULL, NULL, "Bijim"},
	{"jbn", NULL, NULL, NULL, "Nafusi"},
	{"jbo", "jbo", "jbo", NULL, "Lojban"},
	{"jbr", NULL, NULL, NULL, "Jofotek-Bromnya"},
	{"jbt", NULL, NULL, NULL, "Jabutí"},
	{"jbu", NULL, NULL, NULL, "Jukun Takum"},
	{"jbw", NULL, NULL, NULL, "Yawijibaya"},
	{"jcs", NULL, NULL, NULL, "Jamaican Country Sign Language"},
	{"jct", NULL, NULL, NULL, "Krymchak"},
	{"jda", NULL, NULL, NULL, "Jad"},
	{"jdg", NULL, NULL, NULL, "Jadgali"},
	{"jdt", NULL, NULL, NULL, "Judeo-Tat"},
	{"jeb", NULL, NULL, NULL, "Jebero"},
	{"jee", NULL, NULL, NULL, "Jerung"},
	{"jeh", NULL, NULL, NULL, "Jeh"},
	{"jei", NULL, NULL, NULL, "Yei"},
	{"jek", NULL, NULL, NULL, "Jeri Kuo"},
	{"jel", NULL, NULL, NULL, "Yelmek"},
	{"jen", NULL, NULL, NULL, "Dza"},
	{"jer", NULL, NULL, NULL, "Jere"},
	{"jet", NULL, NULL, NULL, "Manem"},
	{"jeu", NULL, NULL, NULL, "Jonkor Bourmataguil"},
	{"jgb", NULL, NULL, NULL, "Ngbee"},
	{"jge", NULL, NULL, NULL, "Judeo-Georgian"},
	{"jgk", NULL, NULL, NULL, "Gwak"},
	{"jgo", NULL, NULL, NULL, "Ngomba"},
	{"jhi", NULL, NULL, NULL, "Jehai"},
	{"jhs", NULL, NULL, NULL, "Jhankot Sign Language"},
	{"jia", NULL, NULL, NULL, "Jina"},
	{"jib", NULL, NULL, NULL, "Jibu"},
	{"jic", NULL, NULL, NULL, "Tol"},
	{"jid", NULL, NULL, NULL, "Bu (Kaduna State)"},
	{"jie", NULL, NULL, NULL, "Jilbe"},
	{"jig", NULL, NULL, NULL, "Jingulu"},
	{"jih", NULL, NULL, NULL, "sTodsde"},
	{"jii", NULL, NULL, NULL, "Jiiddu"},
	{"jil", NULL, NULL, NULL, "Jilim"},
	{"jim", NULL, NULL, NULL, "Jimi (Cameroon)"},
	{"jio", NULL, NULL, NULL, "Jiamao"},
	{"jiq", NULL, NULL, NULL, "Guanyinqiao"},
	{"jit", NULL, NULL, NULL, "Jita"},
	{"jiu", NULL, NULL, NULL, "Youle Jinuo"},
	{"jiv", NULL, NULL, NULL, "Shuar"},
	{"jiy", NULL, NULL, NULL, "Buyuan Jinuo"},
	{"jje", NULL, NULL, NULL, "Jejueo"},
	{"jjr", NULL, NULL, NULL, "Bankal"},
	{"jka", NULL, NULL, NULL, "Kaera"},
	{"jkm", NULL, NULL, NULL, "Mobwa Karen"},
	{"jko", NULL, NULL, NULL, "Kubo"},
	{"jkp", NULL, NULL, NULL, "Paku Karen"},
	{"jkr", NULL, NULL, NULL, "Koro (India)"},
	{"jks", NULL, NULL, NULL, "Amami Koniya Sign Language"},
	{"jku", NULL, NULL, NULL, "Labir"},
	{"jle", NULL, NULL, NULL, "Ngile"},
	{"jls", NULL, NULL, NULL, "Jamaican Sign Language"},
	{"jma", NULL, NULL, NULL, "Dima"},
	{"jmb", NULL, NULL, NULL, "Zumbun"},
	{"jmc", NULL, NULL, NULL, "Machame"},
	{"jmd", NULL, NULL, NULL, "Yamdena"},
	{"jmi", NULL, NULL, NULL, "Jimi (Nigeria)"},
	{"jml", NULL, NULL, NULL, "Jumli"},
	{"jmn", NULL, NULL, NULL, "Makuri Naga"},
	{"jmr", NULL, NULL, NULL, "Kamara"},
	{"jms", NULL, NULL, NULL, "Mashi (Nigeria)"},
	{"jmw", NULL, NULL, NULL, "Mouwase"},
	{"jmx", NULL, NULL, NULL, "Western Juxtlahuaca Mixtec"},
	{"jna", NULL, NULL, NULL, "Jangshung"},
	{"jnd", NULL, NULL, NULL, "Jandavra"},
	{"jng", NULL, NULL, NULL, "Yangman"},
	{"jni", NULL, NULL, NULL, "Janji"},
	{"jnj", NULL, NULL, NULL, "Yemsa"},
	{"jnl", NULL, NULL, NULL, "Rawat"},
	{"jns", NULL, NULL, NULL, "Jaunsari"},
	{"job", NULL, NULL, NULL, "Joba"},
	{"jod", NULL, NULL, NULL, "Wojenaka"},
	{"jog", NULL, NULL, NULL, "Jogi"},
	{"jor", NULL, NULL, NULL, "Jorá"},
	{"jos", NULL, NULL, NULL, "Jordanian Sign Language"},
	{"jow", NULL, NULL, NULL, "Jowulu"},
	{"jpa", NULL, NULL, NULL, "Jewish Palestinian Aramaic"},
	{"jpn", "jpn", "jpn", "ja", "Japanese"},
	{"jpr", "jpr", "jpr", NULL, "Judeo-Persian"},
	{"jqr", NULL, NULL, NULL, "Jaqaru"},
	{"jra", NULL, NULL, NULL, "Jarai"},
	{"jrb", "jrb", "jrb", NULL, "Judeo-Arabic"},
	{"jrr", NULL, NULL, NULL, "Jiru"},
	{"jrt", NULL, NULL, NULL, "Jakattoe"},
	{"jru", NULL, NULL, NULL, "Japrería"},
	{"jsl", NULL, NULL, NULL, "Japanese Sign Language"},
	{"jua", NULL, NULL, NULL, "Júma"},
	{"jub", NULL, NULL, NULL, "Wannu"},
	{"juc", NULL, NULL, NULL, "Jurchen"},
	{"jud", NULL, NULL, NULL, "Worodougou"},
	{"juh", NULL, NULL, NULL, "Hõne"},
	{"jui", NULL, NULL, NULL, "Ngadjuri"},
	{"juk", NULL, NULL, NULL, "Wapan"},
	{"jul", NULL, NULL, NULL, "Jirel"},
	{"jum", NULL, NULL, NULL, "Jumjum"},
	{"jun", NULL, NULL, NULL, "Juang"},
	{"juo", NULL, NULL, NULL, "Jiba"},
	{"jup", NULL, NULL, NULL, "Hupdë"},
	{"jur", NULL, NULL, NULL, "Jurúna"},
	{"jus", NULL, NULL, NULL, "Jumla Sign Language"},
	{"jut", NULL, NULL, NULL, "Jutish"},
	{"juu", NULL, NULL, NULL, "Ju"},
	{"juw", NULL, NULL, NULL, "Wãpha"},
	{"juy", NULL, NULL, NULL, "Juray"},
	{"jvd", NULL, NULL, NULL, "Javindo"},
	{"jvn", NULL, NULL, NULL, "Caribbean Javanese"},
	{"jwi", NULL, NULL, NULL, "Jwira-Pepesa"},
	{"jya", NULL, NULL, NULL, "Jiarong"},
	{"jye", NULL, NULL, NULL, "Judeo-Yemeni Arabic"},
	{"jyy", NULL, NULL, NULL, "Jaya"},
	{"kaa", "kaa", "kaa", NULL, "Kara-Kalpak"},
	{"kab", "kab", "kab", NULL, "Kabyle"},
	{"kac", "kac", "kac", NULL, "Kachin"},
	{"kad", NULL, NULL, NULL, "Adara"},
	{"kae", NULL, NULL, NULL, "Ketangalan"},
	{"kaf", NULL, NULL, NULL, "Katso"},
	{"kag", NULL, NULL, NULL, "Kajaman"},
	{"kah", NULL, NULL, NULL, "Kara (Central African Republic)"},
	{"kai", NULL, NULL, NULL, "Karekare"},
	{"kaj", NULL, NULL, NULL, "Jju"},
	{"kak", NULL, NULL, NULL, "Kalanguya"},
	{"kal", "kal", "kal", "kl", "Kalaallisut"},
	{"kam", "kam", "kam", NULL, "Kamba (Kenya)"},
	{"kan", "kan", "kan", "kn", "Kannada"},
	{"kao", NULL, NULL, NULL, "Xaasongaxango"},
	{"kap", NULL, NULL, NULL, "Bezhta"},
	{"kaq", NULL, NULL, NULL, "Capanahua"},
	{"kas", "kas", "kas", "ks", "Kashmiri"},
	{"kat", "geo", "kat", "ka", "Georgian"},
	{"kau", "kau", "kau", "kr", "Kanuri"},
	{"kav", NULL, NULL, NULL, "Katukína"},
	{"kaw", "kaw", "kaw", NULL, "Kawi"},
	{"kax", NULL, NULL, NULL, "Kao"},
	{"kay", NULL, NULL, NULL, "Kamayurá"},
	{"kaz", "kaz", "kaz", "kk", "Kazakh"},
	{"kba", NULL, NULL, NULL, "Kalarko"},
	{"kbb", NULL, NULL, NULL, "Kaxuiâna"},
	{"kbc", NULL, NULL, NULL, "Kadiwéu"},
	{"kbd", "kbd", "kbd", NULL, "Kabardian"},
	{"kbe", NULL, NULL, NULL, "Kanju"},
	{"kbg", NULL, NULL, NULL, "Khamba"},
	{"kbh", NULL, NULL, NULL, "Camsá"},
	{"kbi", NULL, NULL, NULL, "Kaptiau"},
	{"kbj", NULL, NULL, NULL, "Kari"},
	{"kbk", NULL, NULL, NULL, "Grass Koiari"},
	{"kbl", NULL, NULL, NULL, "Kanembu"},
	{"kbm", NULL, NULL, NULL, "Iwal"},
	{"kbn", NULL, NULL, NULL, "Kare (Central African Republic)"},
	{"kbo", NULL, NULL, NULL, "Keliko"},
	{"kbp", NULL, NULL, NULL, "Kabiyè"},
	{"kbq", NULL, NULL, NULL, "Kamano"},
	{"kbr", NULL, NULL, NULL, "Kafa"},
	{"kbs", NULL, NULL, NULL, "Kande"},
	{"kbt", NULL, NULL, NULL, "Abadi"},
	{"kbu", NULL, NULL, NULL, "Kabutra"},
	{"kbv", NULL, NULL, NULL, "Dera (Indonesia)"},
	{"kbw", NULL, NULL, NULL, "Kaiep"},
	{"kbx", NULL, NULL, NULL, "Ap Ma"},
	{"kby", NULL, NULL, NULL, "Manga Kanuri"},
	{"kbz", NULL, NULL, NULL, "Duhwa"},
	{"kca", NULL, NULL, NULL, "Khanty"},
	{"kcb", NULL, NULL, NULL, "Kawacha"},
	{"kcc", NULL, NULL, NULL, "Lubila"},
	{"kcd", NULL, NULL, NULL, "Ngkâlmpw Kanum"},
	{"kce", NULL, NULL, NULL, "Kaivi"},
	{"kcf", NULL, NULL, NULL, "Ukaan"},
	{"kcg", NULL, NULL, NULL, "Tyap"},
	{"kch", NULL, NULL, NULL, "Vono"},
	{"kci", NULL, NULL, NULL, "Kamantan"},
	{"kcj", NULL, NULL, NULL, "Kobiana"},
	{"kck", NULL, NULL, NULL, "Kalanga"},
	{"kcl", NULL, NULL, NULL, "Kela (Papua New Guinea)"},
	{"kcm", NULL, NULL, NULL, "Gula (Central African Republic)"},
	{"kcn", NULL, NULL, NULL, "Nubi"},
	{"kco", NULL, NULL, NULL, "Kinalakna"},
	{"kcp", NULL, NULL, NULL, "Kanga"},
	{"kcq", NULL, NULL, NULL, "Kamo"},
	{"kcr", NULL, NULL, NULL, "Katla"},
	{"kcs", NULL, NULL, NULL, "Koenoem"},
	{"kct", NULL, NULL, NULL, "Kaian"},
	{"kcu", NULL, NULL, NULL, "Kami (Tanzania)"},
	{"kcv", NULL, NULL, NULL, "Kete"},
	{"kcw", NULL, NULL, NULL, "Kabwari"},
	{"kcx", NULL, NULL, NULL, "Kachama-Ganjule"},
	{"kcy", NULL, NULL, NULL, "Korandje"},
	{"kcz", NULL, NULL, NULL, "Konongo"},
	{"kda", NULL, NULL, NULL, "Worimi"},
	{"kdc", NULL, NULL, NULL, "Kutu"},
	{"kdd", NULL, NULL, NULL, "Yankunytjatjara"},
	{"kde", NULL, NULL, NULL, "Makonde"},
	{"kdf", NULL, NULL, NULL, "Mamusi"},
	{"kdg", NULL, NULL, NULL, "Seba"},
	{"kdh", NULL, NULL, NULL, "Tem"},
	{"kdi", NULL, NULL, NULL, "Kumam"},
	{"kdj", NULL, NULL, NULL, "Karamojong"},
	{"kdk", NULL, NULL, NULL, "Numèè"},
	{"kdl", NULL, NULL, NULL, "Tsikimba"},
	{"kdm", NULL, NULL, NULL, "Kagoma"},
	{"kdn", NULL, NULL, NULL, "Kunda"},
	{"kdp", NULL, NULL, NULL, "Kaningdon-Nindem"},
	{"kdq", NULL, NULL, NULL, "Koch"},
	{"kdr", NULL, NULL, NULL, "Karaim"},
	{"kdt", NULL, NULL, NULL, "Kuy"},
	{"kdu", NULL, NULL, NULL, "Kadaru"},
	{"kdw", NULL, NULL, NULL, "Koneraw"},
	{"kdx", NULL, NULL, NULL, "Kam"},
	{"kdy", NULL, NULL, NULL, "Keder"},
	{"kdz", NULL, NULL, NULL, "Kwaja"},
	{"kea", NULL, NULL, NULL, "Kabuverdianu"},
	{"keb", NULL, NULL, NULL, "Kélé"},
	{"kec", NULL, NULL, NULL, "Keiga"},
	{"ked", NULL, NULL, NULL, "Kerewe"},
	{"kee", NULL, NULL, NULL, "Eastern Keres"},
	{"kef", NULL, NULL, NULL, "Kpessi"},
	{"keg", NULL, NULL, NULL, "Tese"},
	{"keh", NULL, NULL, NULL, "Keak"},
	{"kei", NULL, NULL, NULL, "Kei"},
	{"kej", NULL, NULL, NULL, "Kadar"},
	{"kek", NULL, NULL, NULL, "Kekchí"},
	{"kel", NULL, NULL, NULL, "Kela (Democratic Republic of Congo)"},
	{"kem", NULL, NULL, NULL, "Kemak"},
	{"ken", NULL, NULL, NULL, "Kenyang"},
	{"keo", NULL, NULL, NULL, "Kakwa"},
	{"kep", NULL, NULL, NULL, "Kaikadi"},
	{"keq", NULL, NULL, NULL, "Kamar"},
	{"ker", NULL, NULL, NULL, "Kera"},
	{"kes", NULL, NULL, NULL, "Kugbo"},
	{"ket", NULL, NULL, NULL, "Ket"},
	{"keu", NULL, NULL, NULL, "Akebu"},
	{"kev", NULL, NULL, NULL, "Kanikkaran"},
	{"kew", NULL, NULL, NULL, "West Kewa"},
	{"kex", NULL, NULL, NULL, "Kukna"},
	{"key", NULL, NULL, NULL, "Kupia"},
	{"kez", NULL, NULL, NULL, "Kukele"},
	{"kfa", NULL, NULL, NULL, "Kodava"},
	{"kfb", NULL, NULL, NULL, "Northwestern Kolami"},
	{"kfc", NULL, NULL, NULL, "Konda-Dora"},
	{"kfd", NULL, NULL, NULL, "Korra Koraga"},
	{"kfe", NULL, NULL, NULL, "Kota (India)"},
	{"kff", NULL, NULL, NULL, "Koya"},
	{"kfg", NULL, NULL, NULL, "Kudiya"},
	{"kfh", NULL, NULL, NULL, "Kurichiya"},
	{"kfi", NULL, NULL, NULL, "Kannada Kurumba"},
	{"kfj", NULL, NULL, NULL, "Kemiehua"},
	{"kfk", NULL, NULL, NULL, "Kinnauri"},
	{"kfl", NULL, NULL, NULL, "Kung"},
	{"kfm", NULL, NULL, NULL, "Khunsari"},
	{"kfn", NULL, NULL, NULL, "Kuk"},
	{"kfo", NULL, NULL, NULL, "Koro (Côte d'Ivoire)"},
	{"kfp", NULL, NULL, NULL, "Korwa"},
	{"kfq", NULL, NULL, NULL, "Korku"},
	{"kfr", NULL, NULL, NULL, "Kachhi"},
	{"kfs", NULL, NULL, NULL, "Bilaspuri"},
	{"kft", NULL, NULL, NULL, "Kanjari"},
	{"kfu", NULL, NULL, NULL, "Katkari"},
	{"kfv", NULL, NULL, NULL, "Kurmukar"},
	{"kfw", NULL, NULL, NULL, "Kharam Naga"},
	{"kfx", NULL, NULL, NULL, "Kullu Pahari"},
	{"kfy", NULL, NULL, NULL, "Kumaoni"},
	{"kfz", NULL, NULL, NULL, "Koromfé"},
	{"kga", NULL, NULL, NULL, "Koyaga"},
	{"kgb", NULL, NULL, NULL, "Kawe"},
	{"kge", NULL, NULL, NULL, "Komering"},
	{"kgf", NULL, NULL, NULL, "Kube"},
	{"kgg", NULL, NULL, NULL, "Kusunda"},
	{"kgi", NULL, NULL, NULL, "Selangor Sign Language"},
	{"kgj", NULL, NULL, NULL, "Gamale Kham"},
	{"kgk", NULL, NULL, NULL, "Kaiwá"},
	{"kgl", NULL, NULL, NULL, "Kunggari"},
	{"kgm", NULL, NULL, NULL, "Karipúna"},
	{"kgn", NULL, NULL, NULL, "Karingani"},
	{"kgo", NULL, NULL, NULL, "Krongo"},
	{"kgp", NULL, NULL, NULL, "Kaingang"},
	{"kgq", NULL, NULL, NULL, "Kamoro"},
	{"kgr", NULL, NULL, NULL, "Abun"},
	{"kgs", NULL, NULL, NULL, "Kumbainggar"},
	{"kgt", NULL, NULL, NULL, "Somyev"},
	{"kgu", NULL, NULL, NULL, "Kobol"},
	{"kgv", NULL, NULL, NULL, "Karas"},
	{"kgw", NULL, NULL, NULL, "Karon Dori"},
	{"kgx", NULL, NULL, NULL, "Kamaru"},
	{"kgy", NULL, NULL, NULL, "Kyerung"},
	{"kha", "kha", "kha", NULL, "Khasi"},
	{"khb", NULL, NULL, NULL, "Lü"},
	{"khc", NULL, NULL, NULL, "Tukang Besi North"},
	{"khd", NULL, NULL, NULL, "Bädi Kanum"},
	{"khe", NULL, NULL, NULL, "Korowai"},
	{"khf", NULL, NULL, NULL, "Khuen"},
	{"khg", NULL, NULL, NULL, "Khams Tibetan"},
	{"khh", NULL, NULL, NULL, "Kehu"},
	{"khj", NULL, NULL, NULL, "Kuturmi"},
	{"khk", NULL, NULL, NULL, "Halh Mongolian"},
	{"khl", NULL, NULL, NULL, "Lusi"},
	{"khm", "khm", "khm", "km", "Khmer"},
	{"khn", NULL, NULL, NULL, "Khandesi"},
	{"kho", "kho", "kho", NULL, "Khotanese"},
	{"khp", NULL, NULL, NULL, "Kapori"},
	{"khq", NULL, NULL, NULL, "Koyra Chiini Songhay"},
	{"khr", NULL, NULL, NULL, "Kharia"},
	{"khs", NULL, NULL, NULL, "Kasua"},
	{"kht", NULL, NULL, NULL, "Khamti"},
	{"khu", NULL, NULL, NULL, "Nkhumbi"},
	{"khv", NULL, NULL, NULL, "Khvarshi"},
	{"khw", NULL, NULL, NULL, "Khowar"},
	{"khx", NULL, NULL, NULL, "Kanu"},
	{"khy", NULL, NULL, NULL, "Kele (Democratic Republic of Congo)"},
	{"khz", NULL, NULL, NULL, "Keapara"},
	{"kia", NULL, NULL, NULL, "Kim"},
	{"kib", NULL, NULL, NULL, "Koalib"},
	{"kic", NULL, NULL, NULL, "Kickapoo"},
	{"kid", NULL, NULL, NULL, "Koshin"},
	{"kie", NULL, NULL, NULL, "Kibet"},
	{"kif", NULL, NULL, NULL, "Eastern Parbate Kham"},
	{"kig", NULL, NULL, NULL, "Kimaama"},
	{"kih", NULL, NULL, NULL, "Kilmeri"},
	{"kii", NULL, NULL, NULL, "Kitsai"},
	{"kij", NULL, NULL, NULL, "Kilivila"},
	{"kik", "kik", "kik", "ki", "Kikuyu"},
	{"kil", NULL, NULL, NULL, "Kariya"},
	{"kim", NULL, NULL, NULL, "Karagas"},
	{"kin", "kin", "kin", "rw", "Kinyarwanda"},
	{"kio", NULL, NULL, NULL, "Kiowa"},
	{"kip", NULL, NULL, NULL, "Sheshi Kham"},
	{"kiq", NULL, NULL, NULL, "Kosadle"},
	{"kir", "kir", "kir", "ky", "Kirghiz"},
	{"kis", NULL, NULL, NULL, "Kis"},
	{"kit", NULL, NULL, NULL, "Agob"},
	{"kiu", NULL, NULL, NULL, "Kirmanjki (individual language)"},
	{"kiv", NULL, NULL, NULL, "Kimbu"},
	{"kiw", NULL, NULL, NULL, "Northeast Kiwai"},
	{"kix", NULL, NULL, NULL, "Khiamniungan Naga"},
	{"kiy", NULL, NULL, NULL, "Kirikiri"},
	{"kiz", NULL, NULL, NULL, "Kisi"},
	{"kja", NULL, NULL, NULL, "Mlap"},
	{"kjb", NULL, NULL, NULL, "Q'anjob'al"},
	{"kjc", NULL, NULL, NULL, "Coastal Konjo"},
	{"kjd", NULL, NULL, NULL, "Southern Kiwai"},
	{"kje", NULL, NULL, NULL, "Kisar"},
	{"kjg", NULL, NULL, NULL, "Khmu"},
	{"kjh", NULL, NULL, NULL, "Khakas"},
	{"kji", NULL, NULL, NULL, "Zabana"},
	{"kjj", NULL, NULL, NULL, "Khinalugh"},
	{"kjk", NULL, NULL, NULL, "Highland Konjo"},
	{"kjl", NULL, NULL, NULL, "Western Parbate Kham"},
	{"kjm", NULL, NULL, NULL, "Kháng"},
	{"kjn", NULL, NULL, NULL, "Kunjen"},
	{"kjo", NULL, NULL, NULL, "Harijan Kinnauri"},
	{"kjp", NULL, NULL, NULL, "Pwo Eastern Karen"},
	{"kjq", NULL, NULL, NULL, "Western Keres"},
	{"kjr", NULL, NULL, NULL, "Kurudu"},
	{"kjs", NULL, NULL, NULL, "East Kewa"},
	{"kjt", NULL, NULL, NULL, "Phrae Pwo Karen"},
	{"kju", NULL, NULL, NULL, "Kashaya"},
	{"kjv", NULL, NULL, NULL, "Kaikavian Literary Language"},
	{"kjx", NULL, NULL, NULL, "Ramopa"},
	{"kjy", NULL, NULL, NULL, "Erave"},
	{"kjz", NULL, NULL, NULL, "Bumthangkha"},
	{"kka", NULL, NULL, NULL, "Kakanda"},
	{"kkb", NULL, NULL, NULL, "Kwerisa"},
	{"kkc", NULL, NULL, NULL, "Odoodee"},
	{"kkd", NULL, NULL, NULL, "Kinuku"},
	{"kke", NULL, NULL, NULL, "Kakabe"},
	{"kkf", NULL, NULL, NULL, "Kalaktang Monpa"},
	{"kkg", NULL, NULL, NULL, "Mabaka Valley Kalinga"},
	{"kkh", NULL, NULL, NULL, "Khün"},
	{"kki", NULL, NULL, NULL, "Kagulu"},
	{"kkj", NULL, NULL, NULL, "Kako"},
	{"kkk", NULL, NULL, NULL, "Kokota"},
	{"kkl", NULL, NULL, NULL, "Kosarek Yale"},
	{"kkm", NULL, NULL, NULL, "Kiong"},
	{"kkn", NULL, NULL, NULL, "Kon Keu"},
	{"kko", NULL, NULL, NULL, "Karko"},
	{"kkp", NULL, NULL, NULL, "Gugubera"},
	{"kkq", NULL, NULL, NULL, "Kaeku"},
	{"kkr", NULL, NULL, NULL, "Kir-Balar"},
	{"kks", NULL, NULL, NULL, "Giiwo"},
	{"kkt", NULL, NULL, NULL, "Koi"},
	{"kku", NULL, NULL, NULL, "Tumi"},
	{"kkv", NULL, NULL, NULL, "Kangean"},
	{"kkw", NULL, NULL, NULL, "Teke-Kukuya"},
	{"kkx", NULL, NULL, NULL, "Kohin"},
	{"kky", NULL, NULL, NULL, "Guugu Yimidhirr"},
	{"kkz", NULL, NULL, NULL, "Kaska"},
	{"kla", NULL, NULL, NULL, "Klamath-Modoc"},
	{"klb", NULL, NULL, NULL, "Kiliwa"},
	{"klc", NULL, NULL, NULL, "Kolbila"},
	{"kld", NULL, NULL, NULL, "Gamilaraay"},
	{"kle", NULL, NULL, NULL, "Kulung (Nepal)"},
	{"klf", NULL, NULL, NULL, "Kendeje"},
	{"klg", NULL, NULL, NULL, "Tagakaulo"},
	{"klh", NULL, NULL, NULL, "Weliki"},
	{"kli", NULL, NULL, NULL, "Kalumpang"},
	{"klj", NULL, NULL, NULL, "Khalaj"},
	{"klk", NULL, NULL, NULL, "Kono (Nigeria)"},
	{"kll", NULL, NULL, NULL, "Kagan Kalagan"},
	{"klm", NULL, NULL, NULL, "Migum"},
	{"kln", NULL, NULL, NULL, "Kalenjin"},
	{"klo", NULL, NULL, NULL, "Kapya"},
	{"klp", NULL, NULL, NULL, "Kamasa"},
	{"klq", NULL, NULL, NULL, "Rumu"},
	{"klr", NULL, NULL, NULL, "Khaling"},
	{"kls", NULL, NULL, NULL, "Kalasha"},
	{"klt", NULL, NULL, NULL, "Nukna"},
	{"klu", NULL, NULL, NULL, "Klao"},
	{"klv", NULL, NULL, NULL, "Maskelynes"},
	{"klw", NULL, NULL, NULL, "Tado"},
	{"klx", NULL, NULL, NULL, "Koluwawa"},
	{"kly", NULL, NULL, NULL, "Kalao"},
	{"klz", NULL, NULL, NULL, "Kabola"},
	{"kma", NULL, NULL, NULL, "Konni"},
	{"kmb", "kmb", "kmb", NULL, "Kimbundu"},
	{"kmc", NULL, NULL, NULL, "Southern Dong"},
	{"kmd", NULL, NULL, NULL, "Majukayang Kalinga"},
	{"kme", NULL, NULL, NULL, "Bakole"},
	{"kmf", NULL, NULL, NULL, "Kare (Papua New Guinea)"},
	{"kmg", NULL, NULL, NULL, "Kâte"},
	{"kmh", NULL, NULL, NULL, "Kalam"},
	{"kmi", NULL, NULL, NULL, "Kami (Nigeria)"},
	{"kmj", NULL, NULL, NULL, "Kumarbhag Paharia"},
	{"kmk", NULL, NULL, NULL, "Limos Kalinga"},
	{"kml", NULL, NULL, NULL, "Tanudan Kalinga"},
	{"kmm", NULL, NULL, NULL, "Kom (India)"},
	{"kmn", NULL, NULL, NULL, "Awtuw"},
	{"kmo", NULL, NULL, NULL, "Kwoma"},
	{"kmp", NULL, NULL, NULL, "Gimme"},
	{"kmq", NULL, NULL, NULL, "Kwama"},
	{"kmr", NULL, NULL, NULL, "Northern Kurdish"},
	{"kms", NULL, NULL, NULL, "Kamasau"},
	{"kmt", NULL, NULL, NULL, "Kemtuik"},
	{"kmu", NULL, NULL, NULL, "Kanite"},
	{"kmv", NULL, NULL, NULL, "Karipúna Creole French"},
	{"kmw", NULL, NULL, NULL, "Komo (Democratic Republic of Congo)"},
	{"kmx", NULL, NULL, NULL, "Waboda"},
	{"kmy", NULL, NULL, NULL, "Koma"},
	{"kmz", NULL, NULL, NULL, "Khorasani Turkish"},
	{"kna", NULL, NULL, NULL, "Dera (Nigeria)"},
	{"knb", NULL, NULL, NULL, "Lubuagan Kalinga"},
	{"knc", NULL, NULL, NULL, "Central Kanuri"},
	{"knd", NULL, NULL, NULL, "Konda"},
	{"kne", NULL, NULL, NULL, "Kankanaey"},
	{"knf", NULL, NULL, NULL, "Mankanya"},
	{"kng", NULL, NULL, NULL, "Koongo"},
	{"kni", NULL, NULL, NULL, "Kanufi"},
	{"knj", NULL, NULL, NULL, "Western Kanjobal"},
	{"knk", NULL, NULL, NULL, "Kuranko"},
	{"knl", NULL, NULL, NULL, "Keninjal"},
	{"knm", NULL, NULL, NULL, "Kanamarí"},
	{"knn", NULL, NULL, NULL, "Konkani (individual language)"},
	{"kno", NULL, NULL, NULL, "Kono (Sierra Leone)"},
	{"knp", NULL, NULL, NULL, "Kwanja"},
	{"knq", NULL, NULL, NULL, "Kintaq"},
	{"knr", NULL, NULL, NULL, "Kaningra"},
	{"kns", NULL, NULL, NULL, "Kensiu"},
	{"knt", NULL, NULL, NULL, "Panoan Katukína"},
	{"knu", NULL, NULL, NULL, "Kono (Guinea)"},
	{"knv", NULL, NULL, NULL, "Tabo"},
	{"knw", NULL, NULL, NULL, "Kung-Ekoka"},
	{"knx", NULL, NULL, NULL, "Kendayan"},
	{"kny", NULL, NULL, NULL, "Kanyok"},
	{"knz", NULL, NULL, NULL, "Kalamsé"},
	{"koa", NULL, NULL, NULL, "Konomala"},
	{"koc", NULL, NULL, NULL, "Kpati"},
	{"kod", NULL, NULL, NULL, "Kodi"},
	{"koe", NULL, NULL, NULL, "Kacipo-Bale Suri"},
	{"kof", NULL, NULL, NULL, "Kubi"},
	{"kog", NULL, NULL, NULL, "Cogui"},
	{"koh", NULL, NULL, NULL, "Koyo"},
	{"koi", NULL, NULL, NULL, "Komi-Permyak"},
	{"kok", "kok", "kok", NULL, "Konkani (macrolanguage)"},
	{"kol", NULL, NULL, NULL, "Kol (Papua New Guinea)"},
	{"kom", "kom", "kom", "kv", "Komi"},
	{"kon", "kon", "kon", "kg", "Kongo"},
	{"koo", NULL, NULL, NULL, "Konzo"},
	{"kop", NULL, NULL, NULL, "Waube"},
	{"koq", NULL, NULL, NULL, "Kota (Gabon)"},
	{"kor", "kor", "kor", "ko", "Korean"},
	{"kos", "kos", "kos", NULL, "Kosraean"},
	{"kot", NULL, NULL, NULL, "Lagwan"},
	{"kou", NULL, NULL, NULL, "Koke"},
	{"kov", NULL, NULL, NULL, "Kudu-Camo"},
	{"kow", NULL, NULL, NULL, "Kugama"},
	{"koy", NULL, NULL, NULL, "Koyukon"},
	{"koz", NULL, NULL, NULL, "Korak"},
	{"kpa", NULL, NULL, NULL, "Kutto"},
	{"kpb", NULL, NULL, NULL, "Mullu Kurumba"},
	{"kpc", NULL, NULL, NULL, "Curripaco"},
	{"kpd", NULL, NULL, NULL, "Koba"},
	{"kpe", "kpe", "kpe", NULL, "Kpelle"},
	{"kpf", NULL, NULL, NULL, "Komba"},
	{"kpg", NULL, NULL, NULL, "Kapingamarangi"},
	{"kph", NULL, NULL, NULL, "Kplang"},
	{"kpi", NULL, NULL, NULL, "Kofei"},
	{"kpj", NULL, NULL, NULL, "Karajá"},
	{"kpk", NULL, NULL, NULL, "Kpan"},
	{"kpl", NULL, NULL, NULL, "Kpala"},
	{"kpm", NULL, NULL, NULL, "Koho"},
	{"kpn", NULL, NULL, NULL, "Kepkiriwát"},
	{"kpo", NULL, NULL, NULL, "Ikposo"},
	{"kpq", NULL, NULL, NULL, "Korupun-Sela"},
	{"kpr", NULL, NULL, NULL, "Korafe-Yegha"},
	{"kps", NULL, NULL, NULL, "Tehit"},
	{"kpt", NULL, NULL, NULL, "Karata"},
	{"kpu", NULL, NULL, NULL, "Kafoa"},
	{"kpv", NULL, NULL, NULL, "Komi-Zyrian"},
	{"kpw", NULL, NULL, NULL, "Kobon"},
	{"kpx", NULL, NULL, NULL, "Mountain Koiali"},
	{"kpy", NULL, NULL, NULL, "Koryak"},
	{"kpz", NULL, NULL, NULL, "Kupsabiny"},
	{"kqa", NULL, NULL, NULL, "Mum"},
	{"kqb", NULL, NULL, NULL, "Kovai"},
	{"kqc", NULL, NULL, NULL, "Doromu-Koki"},
	{"kqd", NULL, NULL, NULL, "Koy Sanjaq Surat"},
	{"kqe", NULL, NULL, NULL, "Kalagan"},
	{"kqf", NULL, NULL, NULL, "Kakabai"},
	{"kqg", NULL, NULL, NULL, "Khe"},
	{"kqh", NULL, NULL, NULL, "Kisankasa"},
	{"kqi", NULL, NULL, NULL, "Koitabu"},
	{"kqj", NULL, NULL, NULL, "Koromira"},
	{"kqk", NULL, NULL, NULL, "Kotafon Gbe"},
	{"kql", NULL, NULL, NULL, "Kyenele"},
	{"kqm", NULL, NULL, NULL, "Khisa"},
	{"kqn", NULL, NULL, NULL, "Kaonde"},
	{"kqo", NULL, NULL, NULL, "Eastern Krahn"},
	{"kqp", NULL, NULL, NULL, "Kimré"},
	{"kqq", NULL, NULL, NULL, "Krenak"},
	{"kqr", NULL, NULL, NULL, "Kimaragang"},
	{"kqs", NULL, NULL, NULL, "Northern Kissi"},
	{"kqt", NULL, NULL, NULL, "Klias River Kadazan"},
	{"kqu", NULL, NULL, NULL, "Seroa"},
	{"kqv", NULL, NULL, NULL, "Okolod"},
	{"kqw", NULL, NULL, NULL, "Kandas"},
	{"kqx", NULL, NULL, NULL, "Mser"},
	{"kqy", NULL, NULL, NULL, "Koorete"},
	{"kqz", NULL, NULL, NULL, "Korana"},
	{"kra", NULL, NULL, NULL, "Kumhali"},
	{"krb", NULL, NULL, NULL, "Karkin"},
	{"krc", "krc", "krc", NULL, "Karachay-Balkar"},
	{"krd", NULL, NULL, NULL, "Kairui-Midiki"},
	{"kre", NULL, NULL, NULL, "Panará"},
	{"krf", NULL, NULL, NULL, "Koro (Vanuatu)"},
	{"krh", NULL, NULL, NULL, "Kurama"},
	{"kri", NULL, NULL, NULL, "Krio"},
	{"krj", NULL, NULL, NULL, "Kinaray-A"},
	{"krk", NULL, NULL, NULL, "Kerek"},
	{"krl", "krl", "krl", NULL, "Karelian"},
	{"krn", NULL, NULL, NULL, "Sapo"},
	{"krp", NULL, NULL, NULL, "Korop"},
	{"krr", NULL, NULL, NULL, "Krung"},
	{"krs", NULL, NULL, NULL, "Gbaya (Sudan)"},
	{"krt", NULL, NULL, NULL, "Tumari Kanuri"},
	{"kru", "kru", "kru", NULL, "Kurukh"},
	{"krv", NULL, NULL, NULL, "Kavet"},
	{"krw", NULL, NULL, NULL, "Western Krahn"},
	{"krx", NULL, NULL, NULL, "Karon"},
	{"kry", NULL, NULL, NULL, "Kryts"},
	{"krz", NULL, NULL, NULL, "Sota Kanum"},
	{"ksa", NULL, NULL, NULL, "Shuwa-Zamani"},
	{"ksb", NULL, NULL, NULL, "Shambala"},
	{"ksc", NULL, NULL, NULL, "Southern Kalinga"},
	{"ksd", NULL, NULL, NULL, "Kuanua"},
	{"kse", NULL, NULL, NULL, "Kuni"},
	{"ksf", NULL, NULL, NULL, "Bafia"},
	{"ksg", NULL, NULL, NULL, "Kusaghe"},
	{"ksh", NULL, NULL, NULL, "Kölsch"},
	{"ksi", NULL, NULL, NULL, "Krisa"},
	{"ksj", NULL, NULL, NULL, "Uare"},
	{"ksk", NULL, NULL, NULL, "Kansa"},
	{"ksl", NULL, NULL, NULL, "Kumalu"},
	{"ksm", NULL, NULL, NULL, "Kumba"},
	{"ksn", NULL, NULL, NULL, "Kasiguranin"},
	{"kso", NULL, NULL, NULL, "Kofa"},
	{"ksp", NULL, NULL, NULL, "Kaba"},
	{"ksq", NULL, NULL, NULL, "Kwaami"},
	{"ksr", NULL, NULL, NULL, "Borong"},
	{"kss", NULL, NULL, NULL, "Southern Kisi"},
	{"kst", NULL, NULL, NULL, "Winyé"},
	{"ksu", NULL, NULL, NULL, "Khamyang"},
	{"ksv", NULL, NULL, NULL, "Kusu"},
	{"ksw", NULL, NULL, NULL, "S'gaw Karen"},
	{"ksx", NULL, NULL, NULL, "Kedang"},
	{"ksy", NULL, NULL, NULL, "Kharia Thar"},
	{"ksz", NULL, NULL, NULL, "Kodaku"},
	{"kta", NULL, NULL, NULL, "Katua"},
	{"ktb", NULL, NULL, NULL, "Kambaata"},
	{"ktc", NULL, NULL, NULL, "Kholok"},
	{"ktd", NULL, NULL, NULL, "Kokata"},
	{"kte", NULL, NULL, NULL, "Nubri"},
	{"ktf", NULL, NULL, NULL, "Kwami"},
	{"ktg", NULL, NULL, NULL, "Kalkutung"},
	{"kth", NULL, NULL, NULL, "Karanga"},
	{"kti", NULL, NULL, NULL, "North Muyu"},
	{"ktj", NULL, NULL, NULL, "Plapo Krumen"},
	{"ktk", NULL, NULL, NULL, "Kaniet"},
	{"ktl", NULL, NULL, NULL, "Koroshi"},
	{"ktm", NULL, NULL, NULL, "Kurti"},
	{"ktn", NULL, NULL, NULL, "Karitiâna"},
	{"kto", NULL, NULL, NULL, "Kuot"},
	{"ktp", NULL, NULL, NULL, "Kaduo"},
	{"ktq", NULL, NULL, NULL, "Katabaga"},
	{"kts", NULL, NULL, NULL, "South Muyu"},
	{"ktt", NULL, NULL, NULL, "Ketum"},
	{"ktu", NULL, NULL, NULL, "Kituba (Democratic Republic of Congo)"},
	{"ktv", NULL, NULL, NULL, "Eastern Katu"},
	{"ktw", NULL, NULL, NULL, "Kato"},
	{"ktx", NULL, NULL, NULL, "Kaxararí"},
	{"kty", NULL, NULL, NULL, "Kango (Bas-Uélé District)"},
	{"ktz", NULL, NULL, NULL, "Juǀʼhoan"},
	{"kua", "kua", "kua", "kj", "Kuanyama"},
	{"kub", NULL, NULL, NULL, "Kutep"},
	{"kuc", NULL, NULL, NULL, "Kwinsu"},
	{"kud", NULL, NULL, NULL, "'Auhelawa"},
	{"kue", NULL, NULL, NULL, "Kuman (Papua New Guinea)"},
	{"kuf", NULL, NULL, NULL, "Western Katu"},
	{"kug", NULL, NULL, NULL, "Kupa"},
	{"kuh", NULL, NULL, NULL, "Kushi"},
	{"kui", NULL, NULL, NULL, "Kuikúro-Kalapálo"},
	{"kuj", NULL, NULL, NULL, "Kuria"},
	{"kuk", NULL, NULL, NULL, "Kepo'"},
	{"kul", NULL, NULL, NULL, "Kulere"},
	{"kum", "kum", "kum", NULL, "Kumyk"},
	{"kun", NULL, NULL, NULL, "Kunama"},
	{"kuo", NULL, NULL, NULL, "Kumukio"},
	{"kup", NULL, NULL, NULL, "Kunimaipa"},
	{"kuq", NULL, NULL, NULL, "Karipuna"},
	{"kur", "kur", "kur", "ku", "Kurdish"},
	{"kus", NULL, NULL, NULL, "Kusaal"},
	{"kut", "kut", "kut", NULL, "Kutenai"},
	{"kuu", NULL, NULL, NULL, "Upper Kuskokwim"},
	{"kuv", NULL, NULL, NULL, "Kur"},
	{"kuw", NULL, NULL, NULL, "Kpagua"},
	{"kux", NULL, NULL, NULL, "Kukatja"},
	{"kuy", NULL, NULL, NULL, "Kuuku-Ya'u"},
	{"kuz", NULL, NULL, NULL, "Kunza"},
	{"kva", NULL, NULL, NULL, "Bagvalal"},
	{"kvb", NULL, NULL, NULL, "Kubu"},
	{"kvc", NULL, NULL, NULL, "Kove"},
	{"kvd", NULL, NULL, NULL, "Kui (Indonesia)"},
	{"kve", NULL, NULL, NULL, "Kalabakan"},
	{"kvf", NULL, NULL, NULL, "Kabalai"},
	{"kvg", NULL, NULL, NULL, "Kuni-Boazi"},
	{"kvh", NULL, NULL, NULL, "Komodo"},
	{"kvi", NULL, NULL, NULL, "Kwang"},
	{"kvj", NULL, NULL, NULL, "Psikye"},
	{"kvk", NULL, NULL, NULL, "Korean Sign Language"},
	{"kvl", NULL, NULL, NULL, "Kayaw"},
	{"kvm", NULL, NULL, NULL, "Kendem"},
	{"kvn", NULL, NULL, NULL, "Border Kuna"},
	{"kvo", NULL, NULL, NULL, "Dobel"},
	{"kvp", NULL, NULL, NULL, "Kompane"},
	{"kvq", NULL, NULL, NULL, "Geba Karen"},
	{"kvr", NULL, NULL, NULL, "Kerinci"},
	{"kvt", NULL, NULL, NULL, "Lahta Karen"},
	{"kvu", NULL, NULL, NULL, "Yinbaw Karen"},
	{"kvv", NULL, NULL, NULL, "Kola"},
	{"kvw", NULL, NULL, NULL, "Wersing"},
	{"kvx", NULL, NULL, NULL, "Parkari Koli"},
	{"kvy", NULL, NULL, NULL, "Yintale Karen"},
	{"kvz", NULL, NULL, NULL, "Tsakwambo"},
	{"kwa", NULL, NULL, NULL, "Dâw"},
	{"kwb", NULL, NULL, NULL, "Kwa"},
	{"kwc", NULL, NULL, NULL, "Likwala"},
	{"kwd", NULL, NULL, NULL, "Kwaio"},
	{"kwe", NULL, NULL, NULL, "Kwerba"},
	{"kwf", NULL, NULL, NULL, "Kwara'ae"},
	{"kwg", NULL, NULL, NULL, "Sara Kaba Deme"},
	{"kwh", NULL, NULL, NULL, "Kowiai"},
	{"kwi", NULL, NULL, NULL, "Awa-Cuaiquer"},
	{"kwj", NULL, NULL, NULL, "Kwanga"},
	{"kwk", NULL, NULL, NULL, "Kwakiutl"},
	{"kwl", NULL, NULL, NULL, "Kofyar"},
	{"kwm", NULL, NULL, NULL, "Kwambi"},
	{"kwn", NULL, NULL, NULL, "Kwangali"},
	{"kwo", NULL, NULL, NULL, "Kwomtari"},
	{"kwp", NULL, NULL, NULL, "Kodia"},
	{"kwr", NULL, NULL, NULL, "Kwer"},
	{"kws", NULL, NULL, NULL, "Kwese"},
	{"kwt", NULL, NULL, NULL, "Kwesten"},
	{"kwu", NULL, NULL, NULL, "Kwakum"},
	{"kwv", NULL, NULL, NULL, "Sara Kaba Náà"},
	{"kww", NULL, NULL, NULL, "Kwinti"},
	{"kwx", NULL, NULL, NULL, "Khirwar"},
	{"kwy", NULL, NULL, NULL, "San Salvador Kongo"},
	{"kwz", NULL, NULL, NULL, "Kwadi"},
	{"kxa", NULL, NULL, NULL, "Kairiru"},
	{"kxb", NULL, NULL, NULL, "Krobu"},
	{"kxc", NULL, NULL, NULL, "Konso"},
	{"kxd", NULL, NULL, NULL, "Brunei"},
	{"kxf", NULL, NULL, NULL, "Manumanaw Karen"},
	{"kxh", NULL, NULL, NULL, "Karo (Ethiopia)"},
	{"kxi", NULL, NULL, NULL, "Keningau Murut"},
	{"kxj", NULL, NULL, NULL, "Kulfa"},
	{"kxk", NULL, NULL, NULL, "Zayein Karen"},
	{"kxm", NULL, NULL, NULL, "Northern Khmer"},
	{"kxn", NULL, NULL, NULL, "Kanowit-Tanjong Melanau"},
	{"kxo", NULL, NULL, NULL, "Kanoé"},
	{"kxp", NULL, NULL, NULL, "Wadiyara Koli"},
	{"kxq", NULL, NULL, NULL, "Smärky Kanum"},
	{"kxr", NULL, NULL, NULL, "Koro (Papua New Guinea)"},
	{"kxs", NULL, NULL, NULL, "Kangjia"},
	{"kxt", NULL, NULL, NULL, "Koiwat"},
	{"kxv", NULL, NULL, NULL, "Kuvi"},
	{"kxw", NULL, NULL, NULL, "Konai"},
	{"kxx", NULL, NULL, NULL, "Likuba"},
	{"kxy", NULL, NULL, NULL, "Kayong"},
	{"kxz", NULL, NULL, NULL, "Kerewo"},
	{"kya", NULL, NULL, NULL, "Kwaya"},
	{"kyb", NULL, NULL, NULL, "Butbut Kalinga"},
	{"kyc", NULL, NULL, NULL, "Kyaka"},
	{"kyd", NULL, NULL, NULL, "Karey"},
	{"kye", NULL, NULL, NULL, "Krache"},
	{"kyf", NULL, NULL, NULL, "Kouya"},
	{"kyg", NULL, NULL, NULL, "Keyagana"},
	{"kyh", NULL, NULL, NULL, "Karok"},
	{"kyi", NULL, NULL, NULL, "Kiput"},
	{"kyj", NULL, NULL, NULL, "Karao"},
	{"kyk", NULL, NULL, NULL, "Kamayo"},
	{"kyl", NULL, NULL, NULL, "Kalapuya"},
	{"kym", NULL, NULL, NULL, "Kpatili"},
	{"kyn", NULL, NULL, NULL, "Northern Binukidnon"},
	{"kyo", NULL, NULL, NULL, "Kelon"},
	{"kyp", NULL, NULL, NULL, "Kang"},
	{"kyq", NULL, NULL, NULL, "Kenga"},
	{"kyr", NULL, NULL, NULL, "Kuruáya"},
	{"kys", NULL, NULL, NULL, "Baram Kayan"},
	{"kyt", NULL, NULL, NULL, "Kayagar"},
	{"kyu", NULL, NULL, NULL, "Western Kayah"},
	{"kyv", NULL, NULL, NULL, "Kayort"},
	{"kyw", NULL, NULL, NULL, "Kudmali"},
	{"kyx", NULL, NULL, NULL, "Rapoisi"},
	{"kyy", NULL, NULL, NULL, "Kambaira"},
	{"kyz", NULL, NULL, NULL, "Kayabí"},
	{"kza", NULL, NULL, NULL, "Western Karaboro"},
	{"kzb", NULL, NULL, NULL, "Kaibobo"},
	{"kzc", NULL, NULL, NULL, "Bondoukou Kulango"},
	{"kzd", NULL, NULL, NULL, "Kadai"},
	{"kze", NULL, NULL, NULL, "Kosena"},
	{"kzf", NULL, NULL, NULL, "Da'a Kaili"},
	{"kzg", NULL, NULL, NULL, "Kikai"},
	{"kzi", NULL, NULL, NULL, "Kelabit"},
	{"kzk", NULL, NULL, NULL, "Kazukuru"},
	{"kzl", NULL, NULL, NULL, "Kayeli"},
	{"kzm", NULL, NULL, NULL, "Kais"},
	{"kzn", NULL, NULL, NULL, "Kokola"},
	{"kzo", NULL, NULL, NULL, "Kaningi"},
	{"kzp", NULL, NULL, NULL, "Kaidipang"},
	{"kzq", NULL, NULL, NULL, "Kaike"},
	{"kzr", NULL, NULL, NULL, "Karang"},
	{"kzs", NULL, NULL, NULL, "Sugut Dusun"},
	{"kzu", NULL, NULL, NULL, "Kayupulau"},
	{"kzv", NULL, NULL, NULL, "Komyandaret"},
	{"kzw", NULL, NULL, NULL, "Karirí-Xocó"},
	{"kzx", NULL, NULL, NULL, "Kamarian"},
	{"kzy", NULL, NULL, NULL, "Kango (Tshopo District)"},
	{"kzz", NULL, NULL, NULL, "Kalabra"},
	{"laa", NULL, NULL, NULL, "Southern Subanen"},
	{"lab", NULL, NULL, NULL, "Linear A"},
	{"lac", NULL, NULL, NULL, "Lacandon"},
	{"lad", "lad", "lad", NULL, "Ladino"},
	{"lae", NULL, NULL, NULL, "Pattani"},
	{"laf", NULL, NULL, NULL, "Lafofa"},
	{"lag", NULL, NULL, NULL, "Langi"},
	{"lah", "lah", "lah", NULL, "Lahnda"},
	{"lai", NULL, NULL, NULL, "Lambya"},
	{"laj", NULL, NULL, NULL, "Lango (Uganda)"},
	{"lak", NULL, NULL, NULL, "Laka (Nigeria)"},
	{"lal", NULL, NULL, NULL, "Lalia"},
	{"lam", "lam", "lam", NULL, "Lamba"},
	{"lan", NULL, NULL, NULL, "Laru"},
	{"lao", "lao", "lao", "lo", "Lao"},
	{"lap", NULL, NULL, NULL, "Laka (Chad)"},
	{"laq", NULL, NULL, NULL, "Qabiao"},
	{"lar", NULL, NULL, NULL, "Larteh"},
	{"las", NULL, NULL, NULL, "Lama (Togo)"},
	{"lat", "lat", "lat", "la", "Latin"},
	{"lau", NULL, NULL, NULL, "Laba"},
	{"lav", "lav", "lav", "lv", "Latvian"},
	{"law", NULL, NULL, NULL, "Lauje"},
	{"lax", NULL, NULL, NULL, "Tiwa"},
	{"lay", NULL, NULL, NULL, "Lama Bai"},
	{"laz", NULL, NULL, NULL, "Aribwatsa"},
	{"lbb", NULL, NULL, NULL, "Label"},
	{"lbc", NULL, NULL, NULL, "Lakkia"},
	{"lbe", NULL, NULL, NULL, "Lak"},
	{"lbf", NULL, NULL, NULL, "Tinani"},
	{"lbg", NULL, NULL, NULL, "Laopang"},
	{"lbi", NULL, NULL, NULL, "La'bi"},
	{"lbj", NULL, NULL, NULL, "Ladakhi"},
	{"lbk", NULL, NULL, NULL, "Central Bontok"},
	{"lbl", NULL, NULL, NULL, "Libon Bikol"},
	{"lbm", NULL, NULL, NULL, "Lodhi"},
	{"lbn", NULL, NULL, NULL, "Rmeet"},
	{"lbo", NULL, NULL, NULL, "Laven"},
	{"lbq", NULL, NULL, NULL, "Wampar"},
	{"lbr", NULL, NULL, NULL, "Lohorung"},
	{"lbs", NULL, NULL, NULL, "Libyan Sign Language"},
	{"lbt", NULL, NULL, NULL, "Lachi"},
	{"lbu", NULL, NULL, NULL, "Labu"},
	{"lbv", NULL, NULL, NULL, "Lavatbura-Lamusong"},
	{"lbw", NULL, NULL, NULL, "Tolaki"},
	{"lbx", NULL, NULL, NULL, "Lawangan"},
	{"lby", NULL, NULL, NULL, "Lamalama"},
	{"lbz", NULL, NULL, NULL, "Lardil"},
	{"lcc", NULL, NULL, NULL, "Legenyem"},
	{"lcd", NULL, NULL, NULL, "Lola"},
	{"lce", NULL, NULL, NULL, "Loncong"},
	{"lcf", NULL, NULL, NULL, "Lubu"},
	{"lch", NULL, NULL, NULL, "Luchazi"},
	{"lcl", NULL, NULL, NULL, "Lisela"},
	{"lcm", NULL, NULL, NULL, "Tungag"},
	{"lcp", NULL, NULL, NULL, "Western Lawa"},
	{"lcq", NULL, NULL, NULL, "Luhu"},
	{"lcs", NULL, NULL, NULL, "Lisabata-Nuniali"},
	{"lda", NULL, NULL, NULL, "Kla-Dan"},
	{"ldb", NULL, NULL, NULL, "Dũya"},
	{"ldd", NULL, NULL, NULL, "Luri"},
	{"ldg", NULL, NULL, NULL, "Lenyima"},
	{"ldh", NULL, NULL, NULL, "Lamja-Dengsa-Tola"},
	{"ldi", NULL, NULL, NULL, "Laari"},
	{"ldj", NULL, NULL, NULL, "Lemoro"},
	{"ldk", NULL, NULL, NULL, "Leelau"},
	{"ldl", NULL, NULL, NULL, "Kaan"},
	{"ldm", NULL, NULL, NULL, "Landoma"},
	{"ldn", NULL, NULL, NULL, "Láadan"},
	{"ldo", NULL, NULL, NULL, "Loo"},
	{"ldp", NULL, NULL, NULL, "Tso"},
	{"ldq", NULL, NULL, NULL, "Lufu"},
	{"lea", NULL, NULL, NULL, "Lega-Shabunda"},
	{"leb", NULL, NULL, NULL, "Lala-Bisa"},
	{"lec", NULL, NULL, NULL, "Leco"},
	{"led", NULL, NULL, NULL, "Lendu"},
	{"lee", NULL, NULL, NULL, "Lyélé"},
	{"lef", NULL, NULL, NULL, "Lelemi"},
	{"leh", NULL, NULL, NULL, "Lenje"},
	{"lei", NULL, NULL, NULL, "Lemio"},
	{"lej", NULL, NULL, NULL, "Lengola"},
	{"lek", NULL, NULL, NULL, "Leipon"},
	{"lel", NULL, NULL, NULL, "Lele (Democratic Republic of Congo)"},
	{"lem", NULL, NULL, NULL, "Nomaande"},
	{"len", NULL, NULL, NULL, "Lenca"},
	{"leo", NULL, NULL, NULL, "Leti (Cameroon)"},
	{"lep", NULL, NULL, NULL, "Lepcha"},
	{"leq", NULL, NULL, NULL, "Lembena"},
	{"ler", NULL, NULL, NULL, "Lenkau"},
	{"les", NULL, NULL, NULL, "Lese"},
	{"let", NULL, NULL, NULL, "Lesing-Gelimi"},
	{"leu", NULL, NULL, NULL, "Kara (Papua New Guinea)"},
	{"lev", NULL, NULL, NULL, "Lamma"},
	{"lew", NULL, NULL, NULL, "Ledo Kaili"},
	{"lex", NULL, NULL, NULL, "Luang"},
	{"ley", NULL, NULL, NULL, "Lemolang"},
	{"lez", "lez", "lez", NULL, "Lezghian"},
	{"lfa", NULL, NULL, NULL, "Lefa"},
	{"lfn", NULL, NULL, NULL, "Lingua Franca Nova"},
	{"lga", NULL, NULL, NULL, "Lungga"},
	{"lgb", NULL, NULL, NULL, "Laghu"},
	{"lgg", NULL, NULL, NULL, "Lugbara"},
	{"lgh", NULL, NULL, NULL, "Laghuu"},
	{"lgi", NULL, NULL, NULL, "Lengilu"},
	{"lgk", NULL, NULL, NULL, "Lingarak"},
	{"lgl", NULL, NULL, NULL, "Wala"},
	{"lgm", NULL, NULL, NULL, "Lega-Mwenga"},
	{"lgn", NULL, NULL, NULL, "T'apo"},
	{"lgq", NULL, NULL, NULL, "Logba"},
	{"lgr", NULL, NULL, NULL, "Lengo"},
	{"lgt", NULL, NULL, NULL, "Pahi"},
	{"lgu", NULL, NULL, NULL, "Longgu"},
	{"lgz", NULL, NULL, NULL, "Ligenza"},
	{"lha", NULL, NULL, NULL, "Laha (Viet Nam)"},
	{"lhh", NULL, NULL, NULL, "Laha (Indonesia)"},
	{"lhi", NULL, NULL, NULL, "Lahu Shi"},
	{"lhl", NULL, NULL, NULL, "Lahul Lohar"},
	{"lhm", NULL, NULL, NULL, "Lhomi"},
	{"lhn", NULL, NULL, NULL, "Lahanan"},
	{"lhp", NULL, NULL, NULL, "Lhokpu"},
	{"lhs", NULL, NULL, NULL, "Mlahsö"},
	{"lht", NULL, NULL, NULL, "Lo-Toga"},
	{"lhu", NULL, NULL, NULL, "Lahu"},
	{"lia", NULL, NULL, NULL, "West-Central Limba"},
	{"lib", NULL, NULL, NULL, "Likum"},
	{"lic", NULL, NULL, NULL, "Hlai"},
	{"lid", NULL, NULL, NULL, "Nyindrou"},
	{"lie", NULL, NULL, NULL, "Likila"},
	{"lif", NULL, NULL, NULL, "Limbu"},
	{"lig", NULL, NULL, NULL, "Ligbi"},
	{"lih", NULL, NULL, NULL, "Lihir"},
	{"lij", NULL, NULL, NULL, "Ligurian"},
	{"lik", NULL, NULL, NULL, "Lika"},
	{"lil", NULL, NULL, NULL, "Lillooet"},
	{"lim", "lim", "lim", "li", "Limburgan"},
	{"lin", "lin", "lin", "ln", "Lingala"},
	{"lio", NULL, NULL, NULL, "Liki"},
	{"lip", NULL, NULL, NULL, "Sekpele"},
	{"liq", NULL, NULL, NULL, "Libido"},
	{"lir", NULL, NULL, NULL, "Liberian English"},
	{"lis", NULL, NULL, NULL, "Lisu"},
	{"lit", "lit", "lit", "lt", "Lithuanian"},
	{"liu", NULL, NULL, NULL, "Logorik"},
	{"liv", NULL, NULL, NULL, "Liv"},
	{"liw", NULL, NULL, NULL, "Col"},
	{"lix", NULL, NULL, NULL, "Liabuku"},
	{"liy", NULL, NULL, NULL, "Banda-Bambari"},
	{"liz", NULL, NULL, NULL, "Libinza"},
	{"lja", NULL, NULL, NULL, "Golpa"},
	{"lje", NULL, NULL, NULL, "Rampi"},
	{"lji", NULL, NULL, NULL, "Laiyolo"},
	{"ljl", NULL, NULL, NULL, "Li'o"},
	{"ljp", NULL, NULL, NULL, "Lampung Api"},
	{"ljw", NULL, NULL, NULL, "Yirandali"},
	{"ljx", NULL, NULL, NULL, "Yuru"},
	{"lka", NULL, NULL, NULL, "Lakalei"},
	{"lkb", NULL, NULL, NULL, "Kabras"},
	{"lkc", NULL, NULL, NULL, "Kucong"},
	{"lkd", NULL, NULL, NULL, "Lakondê"},
	{"lke", NULL, NULL, NULL, "Kenyi"},
	{"lkh", NULL, NULL, NULL, "Lakha"},
	{"lki", NULL, NULL, NULL, "Laki"},
	{"lkj", NULL, NULL, NULL, "Remun"},
	{"lkl", NULL, NULL, NULL, "Laeko-Libuat"},
	{"lkm", NULL, NULL, NULL, "Kalaamaya"},
	{"lkn", NULL, NULL, NULL, "Lakon"},
	{"lko", NULL, NULL, NULL, "Khayo"},
	{"lkr", NULL, NULL, NULL, "Päri"},
	{"lks", NULL, NULL, NULL, "Kisa"},
	{"lkt", NULL, NULL, NULL, "Lakota"},
	{"lku", NULL, NULL, NULL, "Kungkari"},
	{"lky", NULL, NULL, NULL, "Lokoya"},
	{"lla", NULL, NULL, NULL, "Lala-Roba"},
	{"llb", NULL, NULL, NULL, "Lolo"},
	{"llc", NULL, NULL, NULL, "Lele (Guinea)"},
	{"lld", NULL, NULL, NULL, "Ladin"},
	{"lle", NULL, NULL, NULL, "Lele (Papua New Guinea)"},
	{"llf", NULL, NULL, NULL, "Hermit"},
	{"llg", NULL, NULL, NULL, "Lole"},
	{"llh", NULL, NULL, NULL, "Lamu"},
	{"lli", NULL, NULL, NULL, "Teke-Laali"},
	{"llj", NULL, NULL, NULL, "Ladji Ladji"},
	{"llk", NULL, NULL, NULL, "Lelak"},
	{"lll", NULL, NULL, NULL, "Lilau"},
	{"llm", NULL, NULL, NULL, "Lasalimu"},
	{"lln", NULL, NULL, NULL, "Lele (Chad)"},
	{"llp", NULL, NULL, NULL, "North Efate"},
	{"llq", NULL, NULL, NULL, "Lolak"},
	{"lls", NULL, NULL, NULL, "Lithuanian Sign Language"},
	{"llu", NULL, NULL, NULL, "Lau"},
	{"llx", NULL, NULL, NULL, "Lauan"},
	{"lma", NULL, NULL, NULL, "East Limba"},
	{"lmb", NULL, NULL, NULL, "Merei"},
	{"lmc", NULL, NULL, NULL, "Limilngan"},
	{"lmd", NULL, NULL, NULL, "Lumun"},
	{"lme", NULL, NULL, NULL, "Pévé"},
	{"lmf", NULL, NULL, NULL, "South Lembata"},
	{"lmg", NULL, NULL, NULL, "Lamogai"},
	{"lmh", NULL, NULL, NULL, "Lambichhong"},
	{"lmi", NULL, NULL, NULL, "Lombi"},
	{"lmj", NULL, NULL, NULL, "West Lembata"},
	{"lmk", NULL, NULL, NULL, "Lamkang"},
	{"lml", NULL, NULL, NULL, "Hano"},
	{"lmn", NULL, NULL, NULL, "Lambadi"},
	{"lmo", NULL, NULL, NULL, "Lombard"},
	{"lmp", NULL, NULL, NULL, "Limbum"},
	{"lmq", NULL, NULL, NULL, "Lamatuka"},
	{"lmr", NULL, NULL, NULL, "Lamalera"},
	{"lmu", NULL, NULL, NULL, "Lamenu"},
	{"lmv", NULL, NULL, NULL, "Lomaiviti"},
	{"lmw", NULL, NULL, NULL, "Lake Miwok"},
	{"lmx", NULL, NULL, NULL, "Laimbue"},
	{"lmy", NULL, NULL, NULL, "Lamboya"},
	{"lna", NULL, NULL, NULL, "Langbashe"},
	{"lnb", NULL, NULL, NULL, "Mbalanhu"},
	{"lnd", NULL, NULL, NULL, "Lundayeh"},
	{"lng", NULL, NULL, NULL, "Langobardic"},
	{"lnh", NULL, NULL, NULL, "Lanoh"},
	{"lni", NULL, NULL, NULL, "Daantanai'"},
	{"lnj", NULL, NULL, NULL, "Leningitij"},
	{"lnl", NULL, NULL, NULL, "South Central Banda"},
	{"lnm", NULL, NULL, NULL, "Langam"},
	{"lnn", NULL, NULL, NULL, "Lorediakarkar"},
	{"lno", NULL, NULL, NULL, "Lango (South Sudan)"},
	{"lns", NULL, NULL, NULL, "Lamnso'"},
	{"lnu", NULL, NULL, NULL, "Longuda"},
	{"lnw", NULL, NULL, NULL, "Lanima"},
	{"lnz", NULL, NULL, NULL, "Lonzo"},
	{"loa", NULL, NULL, NULL, "Loloda"},
	{"lob", NULL, NULL, NULL, "Lobi"},
	{"loc", NULL, NULL, NULL, "Inonhan"},
	{"loe", NULL, NULL, NULL, "Saluan"},
	{"lof", NULL, NULL, NULL, "Logol"},
	{"log", NULL, NULL, NULL, "Logo"},
	{"loh", NULL, NULL, NULL, "Narim"},
	{"loi", NULL, NULL, NULL, "Loma (Côte d'Ivoire)"},
	{"loj", NULL, NULL, NULL, "Lou"},
	{"lok", NULL, NULL, NULL, "Loko"},
	{"lol", "lol", "lol", NULL, "Mongo"},
	{"lom", NULL, NULL, NULL, "Loma (Liberia)"},
	{"lon", NULL, NULL, NULL, "Malawi Lomwe"},
	{"loo", NULL, NULL, NULL, "Lombo"},
	{"lop", NULL, NULL, NULL, "Lopa"},
	{"loq", NULL, NULL, NULL, "Lobala"},
	{"lor", NULL, NULL, NULL, "Téén"},
	{"los", NULL, NULL, NULL, "Loniu"},
	{"lot", NULL, NULL, NULL, "Otuho"},
	{"lou", NULL, NULL, NULL, "Louisiana Creole"},
	{"lov", NULL, NULL, NULL, "Lopi"},
	{"low", NULL, NULL, NULL, "Tampias Lobu"},
	{"lox", NULL, NULL, NULL, "Loun"},
	{"loy", NULL, NULL, NULL, "Loke"},
	{"loz", "loz", "loz", NULL, "Lozi"},
	{"lpa", NULL, NULL, NULL, "Lelepa"},
	{"lpe", NULL, NULL, NULL, "Lepki"},
	{"lpn", NULL, NULL, NULL, "Long Phuri Naga"},
	{"lpo", NULL, NULL, NULL, "Lipo"},
	{"lpx", NULL, NULL, NULL, "Lopit"},
	{"lra", NULL, NULL, NULL, "Rara Bakati'"},
	{"lrc", NULL, NULL, NULL, "Northern Luri"},
	{"lre", NULL, NULL, NULL, "Laurentian"},
	{"lrg", NULL, NULL, NULL, "Laragia"},
	{"lri", NULL, NULL, NULL, "Marachi"},
	{"lrk", NULL, NULL, NULL, "Loarki"},
	{"lrl", NULL, NULL, NULL, "Lari"},
	{"lrm", NULL, NULL, NULL, "Marama"},
	{"lrn", NULL, NULL, NULL, "Lorang"},
	{"lro", NULL, NULL, NULL, "Laro"},
	{"lrr", NULL, NULL, NULL, "Southern Yamphu"},
	{"lrt", NULL, NULL, NULL, "Larantuka Malay"},
	{"lrv", NULL, NULL, NULL, "Larevat"},
	{"lrz", NULL, NULL, NULL, "Lemerig"},
	{"lsa", NULL, NULL, NULL, "Lasgerdi"},
	{"lsb", NULL, NULL, NULL, "Burundian Sign Language"},
	{"lsd", NULL, NULL, NULL, "Lishana Deni"},
	{"lse", NULL, NULL, NULL, "Lusengo"},
	{"lsh", NULL, NULL, NULL, "Lish"},
	{"lsi", NULL, NULL, NULL, "Lashi"},
	{"lsl", NULL, NULL, NULL, "Latvian Sign Language"},
	{"lsm", NULL, NULL, NULL, "Saamia"},
	{"lsn", NULL, NULL, NULL, "Tibetan Sign Language"},
	{"lso", NULL, NULL, NULL, "Laos Sign Language"},
	{"lsp", NULL, NULL, NULL, "Panamanian Sign Language"},
	{"lsr", NULL, NULL, NULL, "Aruop"},
	{"lss", NULL, NULL, NULL, "Lasi"},
	{"lst", NULL, NULL, NULL, "Trinidad and Tobago Sign Language"},
	{"lsv", NULL, NULL, NULL, "Sivia Sign Language"},
	{"lsy", NULL, NULL, NULL, "Mauritian Sign Language"},
	{"ltc", NULL, NULL, NULL, "Late Middle Chinese"},
	{"ltg", NULL, NULL, NULL, "Latgalian"},
	{"lth", NULL, NULL, NULL, "Thur"},
	{"lti", NULL, NULL, NULL, "Leti (Indonesia)"},
	{"ltn", NULL, NULL, NULL, "Latundê"},
	{"lto", NULL, NULL, NULL, "Tsotso"},
	{"lts", NULL, NULL, NULL, "Tachoni"},
	{"ltu", NULL, NULL, NULL, "Latu"},
	{"ltz", "ltz", "ltz", "lb", "Luxembourgish"},
	{"lua", "lua", "lua", NULL, "Luba-Lulua"},
	{"lub", "lub", "lub", "lu", "Luba-Katanga"},
	{"luc", NULL, NULL, NULL, "Aringa"},
	{"lud", NULL, NULL, NULL, "Ludian"},
	{"lue", NULL, NULL, NULL, "Luvale"},
	{"luf", NULL, NULL, NULL, "Laua"},
	{"lug", "lug", "lug", "lg", "Ganda"},
	{"lui", "lui", "lui", NULL, "Luiseno"},
	{"luj", NULL, NULL, NULL, "Luna"},
	{"luk", NULL, NULL, NULL, "Lunanakha"},
	{"lul", NULL, NULL, NULL, "Olu'bo"},
	{"lum", NULL, NULL, NULL, "Luimbi"},
	{"lun", "lun", "lun", NULL, "Lunda"},
	{"luo", "luo", "luo", NULL, "Luo (Kenya and Tanzania)"},
	{"lup", NULL, NULL, NULL, "Lumbu"},
	{"luq", NULL, NULL, NULL, "Lucumi"},
	{"lur", NULL, NULL, NULL, "Laura"},
	{"lus", "lus", "lus", NULL, "Lushai"},
	{"lut", NULL, NULL, NULL, "Lushootseed"},
	{"luu", NULL, NULL, NULL, "Lumba-Yakkha"},
	{"luv", NULL, NULL, NULL, "Luwati"},
	{"luw", NULL, NULL, NULL, "Luo (Cameroon)"},
	{"luy", NULL, NULL, NULL, "Luyia"},
	{"luz", NULL, NULL, NULL, "Southern Luri"},
	{"lva", NULL, NULL, NULL, "Maku'a"},
	{"lvi", NULL, NULL, NULL, "Lavi"},
	{"lvk", NULL, NULL, NULL, "Lavukaleve"},
	{"lvs", NULL, NULL, NULL, "Standard Latvian"},
	{"lvu", NULL, NULL, NULL, "Levuka"},
	{"lwa", NULL, NULL, NULL, "Lwalu"},
	{"lwe", NULL, NULL, NULL, "Lewo Eleng"},
	{"lwg", NULL, NULL, NULL, "Wanga"},
	{"lwh", NULL, NULL, NULL, "White Lachi"},
	{"lwl", NULL, NULL, NULL, "Eastern Lawa"},
	{"lwm", NULL, NULL, NULL, "Laomian"},
	{"lwo", NULL, NULL, NULL, "Luwo"},
	{"lws", NULL, NULL, NULL, "Malawian Sign Language"},
	{"lwt", NULL, NULL, NULL, "Lewotobi"},
	{"lwu", NULL, NULL, NULL, "Lawu"},
	{"lww", NULL, NULL, NULL, "Lewo"},
	{"lxm", NULL, NULL, NULL, "Lakurumau"},
	{"lya", NULL, NULL, NULL, "Layakha"},
	{"lyg", NULL, NULL, NULL, "Lyngngam"},
	{"lyn", NULL, NULL, NULL, "Luyana"},
	{"lzh", NULL, NULL, NULL, "Literary Chinese"},
	{"lzl", NULL, NULL, NULL, "Litzlitz"},
	{"lzn", NULL, NULL, NULL, "Leinong Naga"},
	{"lzz", NULL, NULL, NULL, "Laz"},
	{"maa", NULL, NULL, NULL, "San Jerónimo Tecóatl Mazatec"},
	{"mab", NULL, NULL, NULL, "Yutanduchi Mixtec"},
	{"mad", "mad", "mad", NULL, "Madurese"},
	{"mae", NULL, NULL, NULL, "Bo-Rukul"},
	{"maf", NULL, NULL, NULL, "Mafa"},
	{"mag", "mag", "mag", NULL, "Magahi"},
	{"mah", "mah", "mah", "mh", "Marshallese"},
	{"mai", "mai", "mai", NULL, "Maithili"},
	{"maj", NULL, NULL, NULL, "Jalapa De Díaz Mazatec"},
	{"mak", "mak", "mak", NULL, "Makasar"},
	{"mal", "mal", "mal", "ml", "Malayalam"},
	{"mam", NULL, NULL, NULL, "Mam"},
	{"man", "man", "man", NULL, "Mandingo"},
	{"maq", NULL, NULL, NULL, "Chiquihuitlán Mazatec"},
	{"mar", "mar", "mar", "mr", "Marathi"},
	{"mas", "mas", "mas", NULL, "Masai"},
	{"mat", NULL, NULL, NULL, "San Francisco Matlatzinca"},
	{"mau", NULL, NULL, NULL, "Huautla Mazatec"},
	{"mav", NULL, NULL, NULL, "Sateré-Mawé"},
	{"maw", NULL, NULL, NULL, "Mampruli"},
	{"max", NULL, NULL, NULL, "North Moluccan Malay"},
	{"maz", NULL, NULL, NULL, "Central Mazahua"},
	{"mba", NULL, NULL, NULL, "Higaonon"},
	{"mbb", NULL, NULL, NULL, "Western Bukidnon Manobo"},
	{"mbc", NULL, NULL, NULL, "Macushi"},
	{"mbd", NULL, NULL, NULL, "Dibabawon Manobo"},
	{"mbe", NULL, NULL, NULL, "Molale"},
	{"mbf", NULL, NULL, NULL, "Baba Malay"},
	{"mbh", NULL, NULL, NULL, "Mangseng"},
	{"mbi", NULL, NULL, NULL, "Ilianen Manobo"},
	{"mbj", NULL, NULL, NULL, "Nadëb"},
	{"mbk", NULL, NULL, NULL, "Malol"},
	{"mbl", NULL, NULL, NULL, "Maxakalí"},
	{"mbm", NULL, NULL, NULL, "Ombamba"},
	{"mbn", NULL, NULL, NULL, "Macaguán"},
	{"mbo", NULL, NULL, NULL, "Mbo (Cameroon)"},
	{"mbp", NULL, NULL, NULL, "Malayo"},
	{"mbq", NULL, NULL, NULL, "Maisin"},
	{"mbr", NULL, NULL, NULL, "Nukak Makú"},
	{"mbs", NULL, NULL, NULL, "Sarangani Manobo"},
	{"mbt", NULL, NULL, NULL, "Matigsalug Manobo"},
	{"mbu", NULL, NULL, NULL, "Mbula-Bwazza"},
	{"mbv", NULL, NULL, NULL, "Mbulungish"},
	{"mbw", NULL, NULL, NULL, "Maring"},
	{"mbx", NULL, NULL, NULL, "Mari (East Sepik Province)"},
	{"mby", NULL, NULL, NULL, "Memoni"},
	{"mbz", NULL, NULL, NULL, "Amoltepec Mixtec"},
	{"mca", NULL, NULL, NULL, "Maca"},
	{"mcb", NULL, NULL, NULL, "Machiguenga"},
	{"mcc", NULL, NULL, NULL, "Bitur"},
	{"mcd", NULL, NULL, NULL, "Sharanahua"},
	{"mce", NULL, NULL, NULL, "Itundujia Mixtec"},
	{"mcf", NULL, NULL, NULL, "Matsés"},
	{"mcg", NULL, NULL, NULL, "Mapoyo"},
	{"mch", NULL, NULL, NULL, "Maquiritari"},
	{"mci", NULL, NULL, NULL, "Mese"},
	{"mcj", NULL, NULL, NULL, "Mvanip"},
	{"mck", NULL, NULL, NULL, "Mbunda"},
	{"mcl", NULL, NULL, NULL, "Macaguaje"},
	{"mcm", NULL, NULL, NULL, "Malaccan Creole Portuguese"},
	{"mcn", NULL, NULL, NULL, "Masana"},
	{"mco", NULL, NULL, NULL, "Coatlán Mixe"},
	{"mcp", NULL, NULL, NULL, "Makaa"},
	{"mcq", NULL, NULL, NULL, "Ese"},
	{"mcr", NULL, NULL, NULL, "Menya"},
	{"mcs", NULL, NULL, NULL, "Mambai"},
	{"mct", NULL, NULL, NULL, "Mengisa"},
	{"mcu", NULL, NULL, NULL, "Cameroon Mambila"},
	{"mcv", NULL, NULL, NULL, "Minanibai"},
	{"mcw", NULL, NULL, NULL, "Mawa (Chad)"},
	{"mcx", NULL, NULL, NULL, "Mpiemo"},
	{"mcy", NULL, NULL, NULL, "South Watut"},
	{"mcz", NULL, NULL, NULL, "Mawan"},
	{"mda", NULL, NULL, NULL, "Mada (Nigeria)"},
	{"mdb", NULL, NULL, NULL, "Morigi"},
	{"mdc", NULL, NULL, NULL, "Male (Papua New Guinea)"},
	{"mdd", NULL, NULL, NULL, "Mbum"},
	{"mde", NULL, NULL, NULL, "Maba (Chad)"},
	{"mdf", "mdf", "mdf", NULL, "Moksha"},
	{"mdg", NULL, NULL, NULL, "Massalat"},
	{"mdh", NULL, NULL, NULL, "Maguindanaon"},
	{"mdi", NULL, NULL, NULL, "Mamvu"},
	{"mdj", NULL, NULL, NULL, "Mangbetu"},
	{"mdk", NULL, NULL, NULL, "Mangbutu"},
	{"mdl", NULL, NULL, NULL, "Maltese Sign Language"},
	{"mdm", NULL, NULL, NULL, "Mayogo"},
	{"mdn", NULL, NULL, NULL, "Mbati"},
	{"mdp", NULL, NULL, NULL, "Mbala"},
	{"mdq", NULL, NULL, NULL, "Mbole"},
	{"mdr", "mdr", "mdr", NULL, "Mandar"},
	{"mds", NULL, NULL, NULL, "Maria (Papua New Guinea)"},
	{"mdt", NULL, NULL, NULL, "Mbere"},
	{"mdu", NULL, NULL, NULL, "Mboko"},
	{"mdv", NULL, NULL, NULL, "Santa Lucía Monteverde Mixtec"},
	{"mdw", NULL, NULL, NULL, "Mbosi"},
	{"mdx", NULL, NULL, NULL, "Dizin"},
	{"mdy", NULL, NULL, NULL, "Male (Ethiopia)"},
	{"mdz", NULL, NULL, NULL, "Suruí Do Pará"},
	{"mea", NULL, NULL, NULL, "Menka"},
	{"meb", NULL, NULL, NULL, "Ikobi"},
	{"mec", NULL, NULL, NULL, "Marra"},
	{"med", NULL, NULL, NULL, "Melpa"},
	{"mee", NULL, NULL, NULL, "Mengen"},
	{"mef", NULL, NULL, NULL, "Megam"},
	{"meh", NULL, NULL, NULL, "Southwestern Tlaxiaco Mixtec"},
	{"mei", NULL, NULL, NULL, "Midob"},
	{"mej", NULL, NULL, NULL, "Meyah"},
	{"mek", NULL, NULL, NULL, "Mekeo"},
	{"mel", NULL, NULL, NULL, "Central Melanau"},
	{"mem", NULL, NULL, NULL, "Mangala"},
	{"men", "men", "men", NULL, "Mende (Sierra Leone)"},
	{"meo", NULL, NULL, NULL, "Kedah Malay"},
	{"mep", NULL, NULL, NULL, "Miriwoong"},
	{"meq", NULL, NULL, NULL, "Merey"},
	{"mer", NULL, NULL, NULL, "Meru"},
	{"mes", NULL, NULL, NULL, "Masmaje"},
	{"met", NULL, NULL, NULL, "Mato"},
	{"meu", NULL, NULL, NULL, "Motu"},
	{"mev", NULL, NULL, NULL, "Mano"},
	{"mew", NULL, NULL, NULL, "Maaka"},
	{"mey", NULL, NULL, NULL, "Hassaniyya"},
	{"mez", NULL, NULL, NULL, "Menominee"},
	{"mfa", NULL, NULL, NULL, "Pattani Malay"},
	{"mfb", NULL, NULL, NULL, "Bangka"},
	{"mfc", NULL, NULL, NULL, "Mba"},
	{"mfd", NULL, NULL, NULL, "Mendankwe-Nkwen"},
	{"mfe", NULL, NULL, NULL, "Morisyen"},
	{"mff", NULL, NULL, NULL, "Naki"},
	{"mfg", NULL, NULL, NULL, "Mogofin"},
	{"mfh", NULL, NULL, NULL, "Matal"},
	{"mfi", NULL, NULL, NULL, "Wandala"},
	{"mfj", NULL, NULL, NULL, "Mefele"},
	{"mfk", NULL, NULL, NULL, "North Mofu"},
	{"mfl", NULL, NULL, NULL, "Putai"},
	{"mfm", NULL, NULL, NULL, "Marghi South"},
	{"mfn", NULL, NULL, NULL, "Cross River Mbembe"},
	{"mfo", NULL, NULL, NULL, "Mbe"},
	{"mfp", NULL, NULL, NULL, "Makassar Malay"},
	{"mfq", NULL, NULL, NULL, "Moba"},
	{"mfr", NULL, NULL, NULL, "Marrithiyel"},
	{"mfs", NULL, NULL, NULL, "Mexican Sign Language"},
	{"mft", NULL, NULL, NULL, "Mokerang"},
	{"mfu", NULL, NULL, NULL, "Mbwela"},
	{"mfv", NULL, NULL, NULL, "Mandjak"},
	{"mfw", NULL, NULL, NULL, "Mulaha"},
	{"mfx", NULL, NULL, NULL, "Melo"},
	{"mfy", NULL, NULL, NULL, "Mayo"},
	{"mfz", NULL, NULL, NULL, "Mabaan"},
	{"mga", "mga", "mga", NULL, "Middle Irish (900-1200)"},
	{"mgb", NULL, NULL, NULL, "Mararit"},
	{"mgc", NULL, NULL, NULL, "Morokodo"},
	{"mgd", NULL, NULL, NULL, "Moru"},
	{"mge", NULL, NULL, NULL, "Mango"},
	{"mgf", NULL, NULL, NULL, "Maklew"},
	{"mgg", NULL, NULL, NULL, "Mpumpong"},
	{"mgh", NULL, NULL, NULL, "Makhuwa-Meetto"},
	{"mgi", NULL, NULL, NULL, "Lijili"},
	{"mgj", NULL, NULL, NULL, "Abureni"},
	{"mgk", NULL, NULL, NULL, "Mawes"},
	{"mgl", NULL, NULL, NULL, "Maleu-Kilenge"},
	{"mgm", NULL, NULL, NULL, "Mambae"},
	{"mgn", NULL, NULL, NULL, "Mbangi"},
	{"mgo", NULL, NULL, NULL, "Meta'"},
	{"mgp", NULL, NULL, NULL, "Eastern Magar"},
	{"mgq", NULL, NULL, NULL, "Malila"},
	{"mgr", NULL, NULL, NULL, "Mambwe-Lungu"},
	{"mgs", NULL, NULL, NULL, "Manda (Tanzania)"},
	{"mgt", NULL, NULL, NULL, "Mongol"},
	{"mgu", NULL, NULL, NULL, "Mailu"},
	{"mgv", NULL, NULL, NULL, "Matengo"},
	{"mgw", NULL, NULL, NULL, "Matumbi"},
	{"mgy", NULL, NULL, NULL, "Mbunga"},
	{"mgz", NULL, NULL, NULL, "Mbugwe"},
	{"mha", NULL, NULL, NULL, "Manda (India)"},
	{"mhb", NULL, NULL, NULL, "Mahongwe"},
	{"mhc", NULL, NULL, NULL, "Mocho"},
	{"mhd", NULL, NULL, NULL, "Mbugu"},
	{"mhe", NULL, NULL, NULL, "Besisi"},
	{"mhf", NULL, NULL, NULL, "Mamaa"},
	{"mhg", NULL, NULL, NULL, "Margu"},
	{"mhi", NULL, NULL, NULL, "Ma'di"},
	{"mhj", NULL, NULL, NULL, "Mogholi"},
	{"mhk", NULL, NULL, NULL, "Mungaka"},
	{"mhl", NULL, NULL, NULL, "Mauwake"},
	{"mhm", NULL, NULL, NULL, "Makhuwa-Moniga"},
	{"mhn", NULL, NULL, NULL, "Mócheno"},
	{"mho", NULL, NULL, NULL, "Mashi (Zambia)"},
	{"mhp", NULL, NULL, NULL, "Balinese Malay"},
	{"mhq", NULL, NULL, NULL, "Mandan"},
	{"mhr", NULL, NULL, NULL, "Eastern Mari"},
	{"mhs", NULL, NULL, NULL, "Buru (Indonesia)"},
	{"mht", NULL, NULL, NULL, "Mandahuaca"},
	{"mhu", NULL, NULL, NULL, "Digaro-Mishmi"},
	{"mhw", NULL, NULL, NULL, "Mbukushu"},
	{"mhx", NULL, NULL, NULL, "Maru"},
	{"mhy", NULL, NULL, NULL, "Ma'anyan"},
	{"mhz", NULL, NULL, NULL, "Mor (Mor Islands)"},
	{"mia", NULL, NULL, NULL, "Miami"},
	{"mib", NULL, NULL, NULL, "Atatláhuca Mixtec"},
	{"mic", "mic", "mic", NULL, "Mi'kmaq"},
	{"mid", NULL, NULL, NULL, "Mandaic"},
	{"mie", NULL, NULL, NULL, "Ocotepec Mixtec"},
	{"mif", NULL, NULL, NULL, "Mofu-Gudur"},
	{"mig", NULL, NULL, NULL, "San Miguel El Grande Mixtec"},
	{"mih", NULL, NULL, NULL, "Chayuco Mixtec"},
	{"mii", NULL, NULL, NULL, "Chigmecatitlán Mixtec"},
	{"mij", NULL, NULL, NULL, "Abar"},
	{"mik", NULL, NULL, NULL, "Mikasuki"},
	{"mil", NULL, NULL, NULL, "Peñoles Mixtec"},
	{"mim", NULL, NULL, NULL, "Alacatlatzala Mixtec"},
	{"min", "min", "min", NULL, "Minangkabau"},
	{"mio", NULL, NULL, NULL, "Pinotepa Nacional Mixtec"},
	{"mip", NULL, NULL, NULL, "Apasco-Apoala Mixtec"},
	{"miq", NULL, NULL, NULL, "Mískito"},
	{"mir", NULL, NULL, NULL, "Isthmus Mixe"},
	{"mis", "mis", "mis", NULL, "Uncoded languages"},
	{"mit", NULL, NULL, NULL, "Southern Puebla Mixtec"},
	{"miu", NULL, NULL, NULL, "Cacaloxtepec Mixtec"},
	{"miw", NULL, NULL, NULL, "Akoye"},
	{"mix", NULL, NULL, NULL, "Mixtepec Mixtec"},
	{"miy", NULL, NULL, NULL, "Ayutla Mixtec"},
	{"miz", NULL, NULL, NULL, "Coatzospan Mixtec"},
	{"mjb", NULL, NULL, NULL, "Makalero"},
	{"mjc", NULL, NULL, NULL, "San Juan Colorado Mixtec"},
	{"mjd", NULL, NULL, NULL, "Northwest Maidu"},
	{"mje", NULL, NULL, NULL, "Muskum"},
	{"mjg", NULL, NULL, NULL, "Tu"},
	{"mjh", NULL, NULL, NULL, "Mwera (Nyasa)"},
	{"mji", NULL, NULL, NULL, "Kim Mun"},
	{"mjj", NULL, NULL, NULL, "Mawak"},
	{"mjk", NULL, NULL, NULL, "Matukar"},
	{"mjl", NULL, NULL, NULL, "Mandeali"},
	{"mjm", NULL, NULL, NULL, "Medebur"},
	{"mjn", NULL, NULL, NULL, "Ma (Papua New Guinea)"},
	{"mjo", NULL, NULL, NULL, "Malankuravan"},
	{"mjp", NULL, NULL, NULL, "Malapandaram"},
	{"mjq", NULL, NULL, NULL, "Malaryan"},
	{"mjr", NULL, NULL, NULL, "Malavedan"},
	{"mjs", NULL, NULL, NULL, "Miship"},
	{"mjt", NULL, NULL, NULL, "Sauria Paharia"},
	{"mju", NULL, NULL, NULL, "Manna-Dora"},
	{"mjv", NULL, NULL, NULL, "Mannan"},
	{"mjw", NULL, NULL, NULL, "Karbi"},
	{"mjx", NULL, NULL, NULL, "Mahali"},
	{"mjy", NULL, NULL, NULL, "Mahican"},
	{"mjz", NULL, NULL, NULL, "Majhi"},
	{"mka", NULL, NULL, NULL, "Mbre"},
	{"mkb", NULL, NULL, NULL, "Mal Paharia"},
	{"mkc", NULL, NULL, NULL, "Siliput"},
	{"mkd", "mac", "mkd", "mk", "Macedonian"},
	{"mke", NULL, NULL, NULL, "Mawchi"},
	{"mkf", NULL, NULL, NULL, "Miya"},
	{"mkg", NULL, NULL, NULL, "Mak (China)"},
	{"mki", NULL, NULL, NULL, "Dhatki"},
	{"mkj", NULL, NULL, NULL, "Mokilese"},
	{"mkk", NULL, NULL, NULL, "Byep"},
	{"mkl", NULL, NULL, NULL, "Mokole"},
	{"mkm", NULL, NULL, NULL, "Moklen"},
	{"mkn", NULL, NULL, NULL, "Kupang Malay"},
	{"mko", NULL, NULL, NULL, "Mingang Doso"},
	{"mkp", NULL, NULL, NULL, "Moikodi"},
	{"mkq", NULL, NULL, NULL, "Bay Miwok"},
	{"mkr", NULL, NULL, NULL, "Malas"},
	{"mks", NULL, NULL, NULL, "Silacayoapan Mixtec"},
	{"mkt", NULL, NULL, NULL, "Vamale"},
	{"mku", NULL, NULL, NULL, "Konyanka Maninka"},
	{"mkv", NULL, NULL, NULL, "Mafea"},
	{"mkw", NULL, NULL, NULL, "Kituba (Congo)"},
	{"mkx", NULL, NULL, NULL, "Kinamiging Manobo"},
	{"mky", NULL, NULL, NULL, "East Makian"},
	{"mkz", NULL, NULL, NULL, "Makasae"},
	{"mla", NULL, NULL, NULL, "Malo"},
	{"mlb", NULL, NULL, NULL, "Mbule"},
	{"mlc", NULL, NULL, NULL, "Cao Lan"},
	{"mle", NULL, NULL, NULL, "Manambu"},
	{"mlf", NULL, NULL, NULL, "Mal"},
	{"mlg", "mlg", "mlg", "mg", "Malagasy"},
	{"mlh", NULL, NULL, NULL, "Mape"},
	{"mli", NULL, NULL, NULL, "Malimpung"},
	{"mlj", NULL, NULL, NULL, "Miltu"},
	{"mlk", NULL, NULL, NULL, "Ilwana"},
	{"mll", NULL, NULL, NULL, "Malua Bay"},
	{"mlm", NULL, NULL, NULL, "Mulam"},
	{"mln", NULL, NULL, NULL, "Malango"},
	{"mlo", NULL, NULL, NULL, "Mlomp"},
	{"mlp", NULL, NULL, NULL, "Bargam"},
	{"mlq", NULL, NULL, NULL, "Western Maninkakan"},
	{"mlr", NULL, NULL, NULL, "Vame"},
	{"mls", NULL, NULL, NULL, "Masalit"},
	{"mlt", "mlt", "mlt", "mt", "Maltese"},
	{"mlu", NULL, NULL, NULL, "To'abaita"},
	{"mlv", NULL, NULL, NULL, "Motlav"},
	{"mlw", NULL, NULL, NULL, "Moloko"},
	{"mlx", NULL, NULL, NULL, "Malfaxal"},
	{"mlz", NULL, NULL, NULL, "Malaynon"},
	{"mma", NULL, NULL, NULL, "Mama"},
	{"mmb", NULL, NULL, NULL, "Momina"},
	{"mmc", NULL, NULL, NULL, "Michoacán Mazahua"},
	{"mmd", NULL, NULL, NULL, "Maonan"},
	{"mme", NULL, NULL, NULL, "Mae"},
	{"mmf", NULL, NULL, NULL, "Mundat"},
	{"mmg", NULL, NULL, NULL, "North Ambrym"},
	{"mmh", NULL, NULL, NULL, "Mehináku"},
	{"mmi", NULL, NULL, NULL, "Musar"},
	{"mmj", NULL, NULL, NULL, "Majhwar"},
	{"mmk", NULL, NULL, NULL, "Mukha-Dora"},
	{"mml", NULL, NULL, NULL, "Man Met"},
	{"mmm", NULL, NULL, NULL, "Maii"},
	{"mmn", NULL, NULL, NULL, "Mamanwa"},
	{"mmo", NULL, NULL, NULL, "Mangga Buang"},
	{"mmp", NULL, NULL, NULL, "Siawi"},
	{"mmq", NULL, NULL, NULL, "Musak"},
	{"mmr", NULL, NULL, NULL, "Western Xiangxi Miao"},
	{"mmt", NULL, NULL, NULL, "Malalamai"},
	{"mmu", NULL, NULL, NULL, "Mmaala"},
	{"mmv", NULL, NULL, NULL, "Miriti"},
	{"mmw", NULL, NULL, NULL, "Emae"},
	{"mmx", NULL, NULL, NULL, "Madak"},
	{"mmy", NULL, NULL, NULL, "Migaama"},
	{"mmz", NULL, NULL, NULL, "Mabaale"},
	{"mna", NULL, NULL, NULL, "Mbula"},
	{"mnb", NULL, NULL, NULL, "Muna"},
	{"mnc", "mnc", "mnc", NULL, "Manchu"},
	{"mnd", NULL, NULL, NULL, "Mondé"},
	{"mne", NULL, NULL, NULL, "Naba"},
	{"mnf", NULL, NULL, NULL, "Mundani"},
	{"mng", NULL, NULL, NULL, "Eastern Mnong"},
	{"mnh", NULL, NULL, NULL, "Mono (Democratic Republic of Congo)"},
	{"mni", "mni", "mni", NULL, "Manipuri"},
	{"mnj", NULL, NULL, NULL, "Munji"},
	{"mnk", NULL, NULL, NULL, "Mandinka"},
	{"mnl", NULL, NULL, NULL, "Tiale"},
	{"mnm", NULL, NULL, NULL, "Mapena"},
	{"mnn", NULL, NULL, NULL, "Southern Mnong"},
	{"mnp", NULL, NULL, NULL, "Min Bei Chinese"},
	{"mnq", NULL, NULL, NULL, "Minriq"},
	{"mnr", NULL, NULL, NULL, "Mono (USA)"},
	{"mns", NULL, NULL, NULL, "Mansi"},
	{"mnu", NULL, NULL, NULL, "Mer"},
	{"mnv", NULL, NULL, NULL, "Rennell-Bellona"},
	{"mnw", NULL, NULL, NULL, "Mon"},
	{"mnx", NULL, NULL, NULL, "Manikion"},
	{"mny", NULL, NULL, NULL, "Manyawa"},
	{"mnz", NULL, NULL, NULL, "Moni"},
	{"moa", NULL, NULL, NULL, "Mwan"},
	{"moc", NULL, NULL, NULL, "Mocoví"},
	{"mod", NULL, NULL, NULL, "Mobilian"},
	{"moe", NULL, NULL, NULL, "Innu"},
	{"mog", NULL, NULL, NULL, "Mongondow"},
	{"moh", "moh", "moh", NULL, "Mohawk"},
	{"moi", NULL, NULL, NULL, "Mboi"},
	{"moj", NULL, NULL, NULL, "Monzombo"},
	{"mok", NULL, NULL, NULL, "Morori"},
	{"mom", NULL, NULL, NULL, "Mangue"},
	{"mon", "mon", "mon", "mn", "Mongolian"},
	{"moo", NULL, NULL, NULL, "Monom"},
	{"mop", NULL, NULL, NULL, "Mopán Maya"},
	{"moq", NULL, NULL, NULL, "Mor (Bomberai Peninsula)"},
	{"mor", NULL, NULL, NULL, "Moro"},
	{"mos", "mos", "mos", NULL, "Mossi"},
	{"mot", NULL, NULL, NULL, "Barí"},
	{"mou", NULL, NULL, NULL, "Mogum"},
	{"mov", NULL, NULL, NULL, "Mohave"},
	{"mow", NULL, NULL, NULL, "Moi (Congo)"},
	{"mox", NULL, NULL, NULL, "Molima"},
	{"moy", NULL, NULL, NULL, "Shekkacho"},
	{"moz", NULL, NULL, NULL, "Mukulu"},
	{"mpa", NULL, NULL, NULL, "Mpoto"},
	{"mpb", NULL, NULL, NULL, "Malak Malak"},
	{"mpc", NULL, NULL, NULL, "Mangarrayi"},
	{"mpd", NULL, NULL, NULL, "Machinere"},
	{"mpe", NULL, NULL, NULL, "Majang"},
	{"mpg", NULL, NULL, NULL, "Marba"},
	{"mph", NULL, NULL, NULL, "Maung"},
	{"mpi", NULL, NULL, NULL, "Mpade"},
	{"mpj", NULL, NULL, NULL, "Martu Wangka"},
	{"mpk", NULL, NULL, NULL, "Mbara (Chad)"},
	{"mpl", NULL, NULL, NULL, "Middle Watut"},
	{"mpm", NULL, NULL, NULL, "Yosondúa Mixtec"},
	{"mpn", NULL, NULL, NULL, "Mindiri"},
	{"mpo", NULL, NULL, NULL, "Miu"},
	{"mpp", NULL, NULL, NULL, "Migabac"},
	{"mpq", NULL, NULL, NULL, "Matís"},
	{"mpr", NULL, NULL, NULL, "Vangunu"},
	{"mps", NULL, NULL, NULL, "Dadibi"},
	{"mpt", NULL, NULL, NULL, "Mian"},
	{"mpu", NULL, NULL, NULL, "Makuráp"},
	{"mpv", NULL, NULL, NULL, "Mungkip"},
	{"mpw", NULL, NULL, NULL, "Mapidian"},
	{"mpx", NULL, NULL, NULL, "Misima-Panaeati"},
	{"mpy", NULL, NULL, NULL, "Mapia"},
	{"mpz", NULL, NULL, NULL, "Mpi"},
	{"mqa", NULL, NULL, NULL, "Maba (Indonesia)"},
	{"mqb", NULL, NULL, NULL, "Mbuko"},
	{"mqc", NULL, NULL, NULL, "Mangole"},
	{"mqe", NULL, NULL, NULL, "Matepi"},
	{"mqf", NULL, NULL, NULL, "Momuna"},
	{"mqg", NULL, NULL, NULL, "Kota Bangun Kutai Malay"},
	{"mqh", NULL, NULL, NULL, "Tlazoyaltepec Mixtec"},
	{"mqi", NULL, NULL, NULL, "Mariri"},
	{"mqj", NULL, NULL, NULL, "Mamasa"},
	{"mqk", NULL, NULL, NULL, "Rajah Kabunsuwan Manobo"},
	{"mql", NULL, NULL, NULL, "Mbelime"},
	{"mqm", NULL, NULL, NULL, "South Marquesan"},
	{"mqn", NULL, NULL, NULL, "Moronene"},
	{"mqo", NULL, NULL, NULL, "Modole"},
	{"mqp", NULL, NULL, NULL, "Manipa"},
	{"mqq", NULL, NULL, NULL, "Minokok"},
	{"mqr", NULL, NULL, NULL, "Mander"},
	{"mqs", NULL, NULL, NULL, "West Makian"},
	{"mqt", NULL, NULL, NULL, "Mok"},
	{"mqu", NULL, NULL, NULL, "Mandari"},
	{"mqv", NULL, NULL, NULL, "Mosimo"},
	{"mqw", NULL, NULL, NULL, "Murupi"},
	{"mqx", NULL, NULL, NULL, "Mamuju"},
	{"mqy", NULL, NULL, NULL, "Manggarai"},
	{"mqz", NULL, NULL, NULL, "Pano"},
	{"mra", NULL, NULL, NULL, "Mlabri"},
	{"mrb", NULL, NULL, NULL, "Marino"},
	{"mrc", NULL, NULL, NULL, "Maricopa"},
	{"mrd", NULL, NULL, NULL, "Western Magar"},
	{"mre", NULL, NULL, NULL, "Martha's Vineyard Sign Language"},
	{"mrf", NULL, NULL, NULL, "Elseng"},
	{"mrg", NULL, NULL, NULL, "Mising"},
	{"mrh", NULL, NULL, NULL, "Mara Chin"},
	{"mri", "mao", "mri", "mi", "Maori"},
	{"mrj", NULL, NULL, NULL, "Western Mari"},
	{"mrk", NULL, NULL, NULL, "Hmwaveke"},
	{"mrl", NULL, NULL, NULL, "Mortlockese"},
	{"mrm", NULL, NULL, NULL, "Merlav"},
	{"mrn", NULL, NULL, NULL, "Cheke Holo"},
	{"mro", NULL, NULL, NULL, "Mru"},
	{"mrp", NULL, NULL, NULL, "Morouas"},
	{"mrq", NULL, NULL, NULL, "North Marquesan"},
	{"mrr", NULL, NULL, NULL, "Maria (India)"},
	{"mrs", NULL, NULL, NULL, "Maragus"},
	{"mrt", NULL, NULL, NULL, "Marghi Central"},
	{"mru", NULL, NULL, NULL, "Mono (Cameroon)"},
	{"mrv", NULL, NULL, NULL, "Mangareva"},
	{"mrw", NULL, NULL, NULL, "Maranao"},
	{"mrx", NULL, NULL, NULL, "Maremgi"},
	{"mry", NULL, NULL, NULL, "Mandaya"},
	{"mrz", NULL, NULL, NULL, "Marind"},
	{"msa", "may", "msa", "ms", "Malay (macrolanguage)"},
	{"msb", NULL, NULL, NULL, "Masbatenyo"},
	{"msc", NULL, NULL, NULL, "Sankaran Maninka"},
	{"msd", NULL, NULL, NULL, "Yucatec Maya Sign Language"},
	{"mse", NULL, NULL, NULL, "Musey"},
	{"msf", NULL, NULL, NULL, "Mekwei"},
	{"msg", NULL, NULL, NULL, "Moraid"},
	{"msh", NULL, NULL, NULL, "Masikoro Malagasy"},
	{"msi", NULL, NULL, NULL, "Sabah Malay"},
	{"msj", NULL, NULL, NULL, "Ma (Democratic Republic of Congo)"},
	{"msk", NULL, NULL, NULL, "Mansaka"},
	{"msl", NULL, NULL, NULL, "Molof"},
	{"msm", NULL, NULL, NULL, "Agusan Manobo"},
	{"msn", NULL, NULL, NULL, "Vurës"},
	{"mso", NULL, NULL, NULL, "Mombum"},
	{"msp", NULL, NULL, NULL, "Maritsauá"},
	{"msq", NULL, NULL, NULL, "Caac"},
	{"msr", NULL, NULL, NULL, "Mongolian Sign Language"},
	{"mss", NULL, NULL, NULL, "West Masela"},
	{"msu", NULL, NULL, NULL, "Musom"},
	{"msv", NULL, NULL, NULL, "Maslam"},
	{"msw", NULL, NULL, NULL, "Mansoanka"},
	{"msx", NULL, NULL, NULL, "Moresada"},
	{"msy", NULL, NULL, NULL, "Aruamu"},
	{"msz", NULL, NULL, NULL, "Momare"},
	{"mta", NULL, NULL, NULL, "Cotabato Manobo"},
	{"mtb", NULL, NULL, NULL, "Anyin Morofo"},
	{"mtc", NULL, NULL, NULL, "Munit"},
	{"mtd", NULL, NULL, NULL, "Mualang"},
	{"mte", NULL, NULL, NULL, "Mono (Solomon Islands)"},
	{"mtf", NULL, NULL, NULL, "Murik (Papua New Guinea)"},
	{"mtg", NULL, NULL, NULL, "Una"},
	{"mth", NULL, NULL, NULL, "Munggui"},
	{"mti", NULL, NULL, NULL, "Maiwa (Papua New Guinea)"},
	{"mtj", NULL, NULL, NULL, "Moskona"},
	{"mtk", NULL, NULL, NULL, "Mbe'"},
	{"mtl", NULL, NULL, NULL, "Montol"},
	{"mtm", NULL, NULL, NULL, "Mator"},
	{"mtn", NULL, NULL, NULL, "Matagalpa"},
	{"mto", NULL, NULL, NULL, "Totontepec Mixe"},
	{"mtp", NULL, NULL, NULL, "Wichí Lhamtés Nocten"},
	{"mtq", NULL, NULL, NULL, "Muong"},
	{"mtr", NULL, NULL, NULL, "Mewari"},
	{"mts", NULL, NULL, NULL, "Yora"},
	{"mtt", NULL, NULL, NULL, "Mota"},
	{"mtu", NULL, NULL, NULL, "Tututepec Mixtec"},
	{"mtv", NULL, NULL, NULL, "Asaro'o"},
	{"mtw", NULL, NULL, NULL, "Southern Binukidnon"},
	{"mtx", NULL, NULL, NULL, "Tidaá Mixtec"},
	{"mty", NULL, NULL, NULL, "Nabi"},
	{"mua", NULL, NULL, NULL, "Mundang"},
	{"mub", NULL, NULL, NULL, "Mubi"},
	{"muc", NULL, NULL, NULL, "Ajumbu"},
	{"mud", NULL, NULL, NULL, "Mednyj Aleut"},
	{"mue", NULL, NULL, NULL, "Media Lengua"},
	{"mug", NULL, NULL, NULL, "Musgu"},
	{"muh", NULL, NULL, NULL, "Mündü"},
	{"mui", NULL, NULL, NULL, "Musi"},
	{"muj", NULL, NULL, NULL, "Mabire"},
	{"muk", NULL, NULL, NULL, "Mugom"},
	{"mul", "mul", "mul", NULL, "Multiple languages"},
	{"mum", NULL, NULL, NULL, "Maiwala"},
	{"muo", NULL, NULL, NULL, "Nyong"},
	{"mup", NULL, NULL, NULL, "Malvi"},
	{"muq", NULL, NULL, NULL, "Eastern Xiangxi Miao"},
	{"mur", NULL, NULL, NULL, "Murle"},
	{"mus", "mus", "mus", NULL, "Creek"},
	{"mut", NULL, NULL, NULL, "Western Muria"},
	{"muu", NULL, NULL, NULL, "Yaaku"},
	{"muv", NULL, NULL, NULL, "Muthuvan"},
	{"mux", NULL, NULL, NULL, "Bo-Ung"},
	{"muy", NULL, NULL, NULL, "Muyang"},
	{"muz", NULL, NULL, NULL, "Mursi"},
	{"mva", NULL, NULL, NULL, "Manam"},
	{"mvb", NULL, NULL, NULL, "Mattole"},
	{"mvd", NULL, NULL, NULL, "Mamboru"},
	{"mve", NULL, NULL, NULL, "Marwari (Pakistan)"},
	{"mvf", NULL, NULL, NULL, "Peripheral Mongolian"},
	{"mvg", NULL, NULL, NULL, "Yucuañe Mixtec"},
	{"mvh", NULL, NULL, NULL, "Mulgi"},
	{"mvi", NULL, NULL, NULL, "Miyako"},
	{"mvk", NULL, NULL, NULL, "Mekmek"},
	{"mvl", NULL, NULL, NULL, "Mbara (Australia)"},
	{"mvn", NULL, NULL, NULL, "Minaveha"},
	{"mvo", NULL, NULL, NULL, "Marovo"},
	{"mvp", NULL, NULL, NULL, "Duri"},
	{"mvq", NULL, NULL, NULL, "Moere"},
	{"mvr", NULL, NULL, NULL, "Marau"},
	{"mvs", NULL, NULL, NULL, "Massep"},
	{"mvt", NULL, NULL, NULL, "Mpotovoro"},
	{"mvu", NULL, NULL, NULL, "Marfa"},
	{"mvv", NULL, NULL, NULL, "Tagal Murut"},
	{"mvw", NULL, NULL, NULL, "Machinga"},
	{"mvx", NULL, NULL, NULL, "Meoswar"},
	{"mvy", NULL, NULL, NULL, "Indus Kohistani"},
	{"mvz", NULL, NULL, NULL, "Mesqan"},
	{"mwa", NULL, NULL, NULL, "Mwatebu"},
	{"mwb", NULL, NULL, NULL, "Juwal"},
	{"mwc", NULL, NULL, NULL, "Are"},
	{"mwe", NULL, NULL, NULL, "Mwera (Chimwera)"},
	{"mwf", NULL, NULL, NULL, "Murrinh-Patha"},
	{"mwg", NULL, NULL, NULL, "Aiklep"},
	{"mwh", NULL, NULL, NULL, "Mouk-Aria"},
	{"mwi", NULL, NULL, NULL, "Labo"},
	{"mwk", NULL, NULL, NULL, "Kita Maninkakan"},
	{"mwl", "mwl", "mwl", NULL, "Mirandese"},
	{"mwm", NULL, NULL, NULL, "Sar"},
	{"mwn", NULL, NULL, NULL, "Nyamwanga"},
	{"mwo", NULL, NULL, NULL, "Central Maewo"},
	{"mwp", NULL, NULL, NULL, "Kala Lagaw Ya"},
	{"mwq", NULL, NULL, NULL, "Mün Chin"},
	{"mwr", "mwr", "mwr", NULL, "Marwari"},
	{"mws", NULL, NULL, NULL, "Mwimbi-Muthambi"},
	{"mwt", NULL, NULL, NULL, "Moken"},
	{"mwu", NULL, NULL, NULL, "Mittu"},
	{"mwv", NULL, NULL, NULL, "Mentawai"},
	{"mww", NULL, NULL, NULL, "Hmong Daw"},
	{"mwz", NULL, NULL, NULL, "Moingi"},
	{"mxa", NULL, NULL, NULL, "Northwest Oaxaca Mixtec"},
	{"mxb", NULL, NULL, NULL, "Tezoatlán Mixtec"},
	{"mxc", NULL, NULL, NULL, "Manyika"},
	{"mxd", NULL, NULL, NULL, "Modang"},
	{"mxe", NULL, NULL, NULL, "Mele-Fila"},
	{"mxf", NULL, NULL, NULL, "Malgbe"},
	{"mxg", NULL, NULL, NULL, "Mbangala"},
	{"mxh", NULL, NULL, NULL, "Mvuba"},
	{"mxi", NULL, NULL, NULL, "Mozarabic"},
	{"mxj", NULL, NULL, NULL, "Miju-Mishmi"},
	{"mxk", NULL, NULL, NULL, "Monumbo"},
	{"mxl", NULL, NULL, NULL, "Maxi Gbe"},
	{"mxm", NULL, NULL, NULL, "Meramera"},
	{"mxn", NULL, NULL, NULL, "Moi (Indonesia)"},
	{"mxo", NULL, NULL, NULL, "Mbowe"},
	{"mxp", NULL, NULL, NULL, "Tlahuitoltepec Mixe"},
	{"mxq", NULL, NULL, NULL, "Juquila Mixe"},
	{"mxr", NULL, NULL, NULL, "Murik (Malaysia)"},
	{"mxs", NULL, NULL, NULL, "Huitepec Mixtec"},
	{"mxt", NULL, NULL, NULL, "Jamiltepec Mixtec"},
	{"mxu", NULL, NULL, NULL, "Mada (Cameroon)"},
	{"mxv", NULL, NULL, NULL, "Metlatónoc Mixtec"},
	{"mxw", NULL, NULL, NULL, "Namo"},
	{"mxx", NULL, NULL, NULL, "Mahou"},
	{"mxy", NULL, NULL, NULL, "Southeastern Nochixtlán Mixtec"},
	{"mxz", NULL, NULL, NULL, "Central Masela"},
	{"mya", "bur", "mya", "my", "Burmese"},
	{"myb", NULL, NULL, NULL, "Mbay"},
	{"myc", NULL, NULL, NULL, "Mayeka"},
	{"mye", NULL, NULL, NULL, "Myene"},
	{"myf", NULL, NULL, NULL, "Bambassi"},
	{"myg", NULL, NULL, NULL, "Manta"},
	{"myh", NULL, NULL, NULL, "Makah"},
	{"myj", NULL, NULL, NULL, "Mangayat"},
	{"myk", NULL, NULL, NULL, "Mamara Senoufo"},
	{"myl", NULL, NULL, NULL, "Moma"},
	{"mym", NULL, NULL, NULL, "Me'en"},
	{"myo", NULL, NULL, NULL, "Anfillo"},
	{"myp", NULL, NULL, NULL, "Pirahã"},
	{"myr", NULL, NULL, NULL, "Muniche"},
	{"mys", NULL, NULL, NULL, "Mesmes"},
	{"myu", NULL, NULL, NULL, "Mundurukú"},
	{"myv", "myv", "myv", NULL, "Erzya"},
	{"myw", NULL, NULL, NULL, "Muyuw"},
	{"myx", NULL, NULL, NULL, "Masaaba"},
	{"myy", NULL, NULL, NULL, "Macuna"},
	{"myz", NULL, NULL, NULL, "Classical Mandaic"},
	{"mza", NULL, NULL, NULL, "Santa María Zacatepec Mixtec"},
	{"mzb", NULL, NULL, NULL, "Tumzabt"},
	{"mzc", NULL, NULL, NULL, "Madagascar Sign Language"},
	{"mzd", NULL, NULL, NULL, "Malimba"},
	{"mze", NULL, NULL, NULL, "Morawa"},
	{"mzg", NULL, NULL, NULL, "Monastic Sign Language"},
	{"mzh", NULL, NULL, NULL, "Wichí Lhamtés Güisnay"},
	{"mzi", NULL, NULL, NULL, "Ixcatlán Mazatec"},
	{"mzj", NULL, NULL, NULL, "Manya"},
	{"mzk", NULL, NULL, NULL, "Nigeria Mambila"},
	{"mzl", NULL, NULL, NULL, "Mazatlán Mixe"},
	{"mzm", NULL, NULL, NULL, "Mumuye"},
	{"mzn", NULL, NULL, NULL, "Mazanderani"},
	{"mzo", NULL, NULL, NULL, "Matipuhy"},
	{"mzp", NULL, NULL, NULL, "Movima"},
	{"mzq", NULL, NULL, NULL, "Mori Atas"},
	{"mzr", NULL, NULL, NULL, "Marúbo"},
	{"mzs", NULL, NULL, NULL, "Macanese"},
	{"mzt", NULL, NULL, NULL, "Mintil"},
	{"mzu", NULL, NULL, NULL, "Inapang"},
	{"mzv", NULL, NULL, NULL, "Manza"},
	{"mzw", NULL, NULL, NULL, "Deg"},
	{"mzx", NULL, NULL, NULL, "Mawayana"},
	{"mzy", NULL, NULL, NULL, "Mozambican Sign Language"},
	{"mzz", NULL, NULL, NULL, "Maiadomu"},
	{"naa", NULL, NULL, NULL, "Namla"},
	{"nab", NULL, NULL, NULL, "Southern Nambikuára"},
	{"nac", NULL, NULL, NULL, "Narak"},
	{"nae", NULL, NULL, NULL, "Naka'ela"},
	{"naf", NULL, NULL, NULL, "Nabak"},
	{"nag", NULL, NULL, NULL, "Naga Pidgin"},
	{"naj", NULL, NULL, NULL, "Nalu"},
	{"nak", NULL, NULL, NULL, "Nakanai"},
	{"nal", NULL, NULL, NULL, "Nalik"},
	{"nam", NULL, NULL, NULL, "Ngan'gityemerri"},
	{"nan", NULL, NULL, NULL, "Min Nan Chinese"},
	{"nao", NULL, NULL, NULL, "Naaba"},
	{"nap", "nap", "nap", NULL, "Neapolitan"},
	{"naq", NULL, NULL, NULL, "Khoekhoe"},
	{"nar", NULL, NULL, NULL, "Iguta"},
	{"nas", NULL, NULL, NULL, "Naasioi"},
	{"nat", NULL, NULL, NULL, "Ca̱hungwa̱rya̱"},
	{"nau", "nau", "nau", "na", "Nauru"},
	{"nav", "nav", "nav", "nv", "Navajo"},
	{"naw", NULL, NULL, NULL, "Nawuri"},
	{"nax", NULL, NULL, NULL, "Nakwi"},
	{"nay", NULL, NULL, NULL, "Ngarrindjeri"},
	{"naz", NULL, NULL, NULL, "Coatepec Nahuatl"},
	{"nba", NULL, NULL, NULL, "Nyemba"},
	{"nbb", NULL, NULL, NULL, "Ndoe"},
	{"nbc", NULL, NULL, NULL, "Chang Naga"},
	{"nbd", NULL, NULL, NULL, "Ngbinda"},
	{"nbe", NULL, NULL, NULL, "Konyak Naga"},
	{"nbg", NULL, NULL, NULL, "Nagarchal"},
	{"nbh", NULL, NULL, NULL, "Ngamo"},
	{"nbi", NULL, NULL, NULL, "Mao Naga"},
	{"nbj", NULL, NULL, NULL, "Ngarinyman"},
	{"nbk", NULL, NULL, NULL, "Nake"},
	{"nbl", "nbl", "nbl", "nr", "South Ndebele"},
	{"nbm", NULL, NULL, NULL, "Ngbaka Ma'bo"},
	{"nbn", NULL, NULL, NULL, "Kuri"},
	{"nbo", NULL, NULL, NULL, "Nkukoli"},
	{"nbp", NULL, NULL, NULL, "Nnam"},
	{"nbq", NULL, NULL, NULL, "Nggem"},
	{"nbr", NULL, NULL, NULL, "Numana"},
	{"nbs", NULL, NULL, NULL, "Namibian Sign Language"},
	{"nbt", NULL, NULL, NULL, "Na"},
	{"nbu", NULL, NULL, NULL, "Rongmei Naga"},
	{"nbv", NULL, NULL, NULL, "Ngamambo"},
	{"nbw", NULL, NULL, NULL, "Southern Ngbandi"},
	{"nby", NULL, NULL, NULL, "Ningera"},
	{"nca", NULL, NULL, NULL, "Iyo"},
	{"ncb", NULL, NULL, NULL, "Central Nicobarese"},
	{"ncc", NULL, NULL, NULL, "Ponam"},
	{"ncd", NULL, NULL, NULL, "Nachering"},
	{"nce", NULL, NULL, NULL, "Yale"},
	{"ncf", NULL, NULL, NULL, "Notsi"},
	{"ncg", NULL, NULL, NULL, "Nisga'a"},
	{"nch", NULL, NULL, NULL, "Central Huasteca Nahuatl"},
	{"nci", NULL, NULL, NULL, "Classical Nahuatl"},
	{"ncj", NULL, NULL, NULL, "Northern Puebla Nahuatl"},
	{"nck", NULL, NULL, NULL, "Na-kara"},
	{"ncl", NULL, NULL, NULL, "Michoacán Nahuatl"},
	{"ncm", NULL, NULL, NULL, "Nambo"},
	{"ncn", NULL, NULL, NULL, "Nauna"},
	{"nco", NULL, NULL, NULL, "Sibe"},
	{"ncq", NULL, NULL, NULL, "Northern Katang"},
	{"ncr", NULL, NULL, NULL, "Ncane"},
	{"ncs", NULL, NULL, NULL, "Nicaraguan Sign Language"},
	{"nct", NULL, NULL, NULL, "Chothe Naga"},
	{"ncu", NULL, NULL, NULL, "Chumburung"},
	{"ncx", NULL, NULL, NULL, "Central Puebla Nahuatl"},
	{"ncz", NULL, NULL, NULL, "Natchez"},
	{"nda", NULL, NULL, NULL, "Ndasa"},
	{"ndb", NULL, NULL, NULL, "Kenswei Nsei"},
	{"ndc", NULL, NULL, NULL, "Ndau"},
	{"ndd", NULL, NULL, NULL, "Nde-Nsele-Nta"},
	{"nde", "nde", "nde", "nd", "North Ndebele"},
	{"ndf", NULL, NULL, NULL, "Nadruvian"},
	{"ndg", NULL, NULL, NULL, "Ndengereko"},
	{"ndh", NULL, NULL, NULL, "Ndali"},
	{"ndi", NULL, NULL, NULL, "Samba Leko"},
	{"ndj", NULL, NULL, NULL, "Ndamba"},
	{"ndk", NULL, NULL, NULL, "Ndaka"},
	{"ndl", NULL, NULL, NULL, "Ndolo"},
	{"ndm", NULL, NULL, NULL, "Ndam"},
	{"ndn", NULL, NULL, NULL, "Ngundi"},
	{"ndo", "ndo", "ndo", "ng", "Ndonga"},
	{"ndp", NULL, NULL, NULL, "Ndo"},
	{"ndq", NULL, NULL, NULL, "Ndombe"},
	{"ndr", NULL, NULL, NULL, "Ndoola"},
	{"nds", "nds", "nds", NULL, "Low German"},
	{"ndt", NULL, NULL, NULL, "Ndunga"},
	{"ndu", NULL, NULL, NULL, "Dugun"},
	{"ndv", NULL, NULL, NULL, "Ndut"},
	{"ndw", NULL, NULL, NULL, "Ndobo"},
	{"ndx", NULL, NULL, NULL, "Nduga"},
	{"ndy", NULL, NULL, NULL, "Lutos"},
	{"ndz", NULL, NULL, NULL, "Ndogo"},
	{"nea", NULL, NULL, NULL, "Eastern Ngad'a"},
	{"neb", NULL, NULL, NULL, "Toura (Côte d'Ivoire)"},
	{"nec", NULL, NULL, NULL, "Nedebang"},
	{"ned", NULL, NULL, NULL, "Nde-Gbite"},
	{"nee", NULL, NULL, NULL, "Nêlêmwa-Nixumwak"},
	{"nef", NULL, NULL, NULL, "Nefamese"},
	{"neg", NULL, NULL, NULL, "Negidal"},
	{"neh", NULL, NULL, NULL, "Nyenkha"},
	{"nei", NULL, NULL, NULL, "Neo-Hittite"},
	{"nej", NULL, NULL, NULL, "Neko"},
	{"nek", NULL, NULL, NULL, "Neku"},
	{"nem", NULL, NULL, NULL, "Nemi"},
	{"nen", NULL, NULL, NULL, "Nengone"},
	{"neo", NULL, NULL, NULL, "Ná-Meo"},
	{"nep", "nep", "nep", "ne", "Nepali (macrolanguage)"},
	{"neq", NULL, NULL, NULL, "North Central Mixe"},
	{"ner", NULL, NULL, NULL, "Yahadian"},
	{"nes", NULL, NULL, NULL, "Bhoti Kinnauri"},
	{"net", NULL, NULL, NULL, "Nete"},
	{"neu", NULL, NULL, NULL, "Neo"},
	{"nev", NULL, NULL, NULL, "Nyaheun"},
	{"new", "new", "new", NULL, "Newari"},
	{"nex", NULL, NULL, NULL, "Neme"},
	{"ney", NULL, NULL, NULL, "Neyo"},
	{"nez", NULL, NULL, NULL, "Nez Perce"},
	{"nfa", NULL, NULL, NULL, "Dhao"},
	{"nfd", NULL, NULL, NULL, "Ahwai"},
	{"nfl", NULL, NULL, NULL, "Ayiwo"},
	{"nfr", NULL, NULL, NULL, "Nafaanra"},
	{"nfu", NULL, NULL, NULL, "Mfumte"},
	{"nga", NULL, NULL, NULL, "Ngbaka"},
	{"ngb", NULL, NULL, NULL, "Northern Ngbandi"},
	{"ngc", NULL, NULL, NULL, "Ngombe (Democratic Republic of Congo)"},
	{"ngd", NULL, NULL, NULL, "Ngando (Central African Republic)"},
	{"nge", NULL, NULL, NULL, "Ngemba"},
	{"ngg", NULL, NULL, NULL, "Ngbaka Manza"},
	{"ngh", NULL, NULL, NULL, "Nǁng"},
	{"ngi", NULL, NULL, NULL, "Ngizim"},
	{"ngj", NULL, NULL, NULL, "Ngie"},
	{"ngk", NULL, NULL, NULL, "Dalabon"},
	{"ngl", NULL, NULL, NULL, "Lomwe"},
	{"ngm", NULL, NULL, NULL, "Ngatik Men's Creole"},
	{"ngn", NULL, NULL, NULL, "Ngwo"},
	{"ngp", NULL, NULL, NULL, "Ngulu"},
	{"ngq", NULL, NULL, NULL, "Ngurimi"},
	{"ngr", NULL, NULL, NULL, "Engdewu"},
	{"ngs", NULL, NULL, NULL, "Gvoko"},
	{"ngt", NULL, NULL, NULL, "Kriang"},
	{"ngu", NULL, NULL, NULL, "Guerrero Nahuatl"},
	{"ngv", NULL, NULL, NULL, "Nagumi"},
	{"ngw", NULL, NULL, NULL, "Ngwaba"},
	{"ngx", NULL, NULL, NULL, "Nggwahyi"},
	{"ngy", NULL, NULL, NULL, "Tibea"},
	{"ngz", NULL, NULL, NULL, "Ngungwel"},
	{"nha", NULL, NULL, NULL, "Nhanda"},
	{"nhb", NULL, NULL, NULL, "Beng"},
	{"nhc", NULL, NULL, NULL, "Tabasco Nahuatl"},
	{"nhd", NULL, NULL, NULL, "Chiripá"},
	{"nhe", NULL, NULL, NULL, "Eastern Huasteca Nahuatl"},
	{"nhf", NULL, NULL, NULL, "Nhuwala"},
	{"nhg", NULL, NULL, NULL, "Tetelcingo Nahuatl"},
	{"nhh", NULL, NULL, NULL, "Nahari"},
	{"nhi", NULL, NULL, NULL, "Zacatlán-Ahuacatlán-Tepetzintla Nahuatl"},
	{"nhk", NULL, NULL, NULL, "Isthmus-Cosoleacaque Nahuatl"},
	{"nhm", NULL, NULL, NULL, "Morelos Nahuatl"},
	{"nhn", NULL, NULL, NULL, "Central Nahuatl"},
	{"nho", NULL, NULL, NULL, "Takuu"},
	{"nhp", NULL, NULL, NULL, "Isthmus-Pajapan Nahuatl"},
	{"nhq", NULL, NULL, NULL, "Huaxcaleca Nahuatl"},
	{"nhr", NULL, NULL, NULL, "Naro"},
	{"nht", NULL, NULL, NULL, "Ometepec Nahuatl"},
	{"nhu", NULL, NULL, NULL, "Noone"},
	{"nhv", NULL, NULL, NULL, "Temascaltepec Nahuatl"},
	{"nhw", NULL, NULL, NULL, "Western Huasteca Nahuatl"},
	{"nhx", NULL, NULL, NULL, "Isthmus-Mecayapan Nahuatl"},
	{"nhy", NULL, NULL, NULL, "Northern Oaxaca Nahuatl"},
	{"nhz", NULL, NULL, NULL, "Santa María La Alta Nahuatl"},
	{"nia", "nia", "nia", NULL, "Nias"},
	{"nib", NULL, NULL, NULL, "Nakame"},
	{"nid", NULL, NULL, NULL, "Ngandi"},
	{"nie", NULL, NULL, NULL, "Niellim"},
	{"nif", NULL, NULL, NULL, "Nek"},
	{"nig", NULL, NULL, NULL, "Ngalakgan"},
	{"nih", NULL, NULL, NULL, "Nyiha (Tanzania)"},
	{"nii", NULL, NULL, NULL, "Nii"},
	{"nij", NULL, NULL, NULL, "Ngaju"},
	{"nik", NULL, NULL, NULL, "Southern Nicobarese"},
	{"nil", NULL, NULL, NULL, "Nila"},
	{"nim", NULL, NULL, NULL, "Nilamba"},
	{"nin", NULL, NULL, NULL, "Ninzo"},
	{"nio", NULL, NULL, NULL, "Nganasan"},
	{"niq", NULL, NULL, NULL, "Nandi"},
	{"nir", NULL, NULL, NULL, "Nimboran"},
	{"nis", NULL, NULL, NULL, "Nimi"},
	{"nit", NULL, NULL, NULL, "Southeastern Kolami"},
	{"niu", "niu", "niu", NULL, "Niuean"},
	{"niv", NULL, NULL, NULL, "Gilyak"},
	{"niw", NULL, NULL, NULL, "Nimo"},
	{"nix", NULL, NULL, NULL, "Hema"},
	{"niy", NULL, NULL, NULL, "Ngiti"},
	{"niz", NULL, NULL, NULL, "Ningil"},
	{"nja", NULL, NULL, NULL, "Nzanyi"},
	{"njb", NULL, NULL, NULL, "Nocte Naga"},
	{"njd", NULL, NULL, NULL, "Ndonde Hamba"},
	{"njh", NULL, NULL, NULL, "Lotha Naga"},
	{"nji", NULL, NULL, NULL, "Gudanji"},
	{"njj", NULL, NULL, NULL, "Njen"},
	{"njl", NULL, NULL, NULL, "Njalgulgule"},
	{"njm", NULL, NULL, NULL, "Angami Naga"},
	{"njn", NULL, NULL, NULL, "Liangmai Naga"},
	{"njo", NULL, NULL, NULL, "Ao Naga"},
	{"njr", NULL, NULL, NULL, "Njerep"},
	{"njs", NULL, NULL, NULL, "Nisa"},
	{"njt", NULL, NULL, NULL, "Ndyuka-Trio Pidgin"},
	{"nju", NULL, NULL, NULL, "Ngadjunmaya"},
	{"njx", NULL, NULL, NULL, "Kunyi"},
	{"njy", NULL, NULL, NULL, "Njyem"},
	{"njz", NULL, NULL, NULL, "Nyishi"},
	{"nka", NULL, NULL, NULL, "Nkoya"},
	{"nkb", NULL, NULL, NULL, "Khoibu Naga"},
	{"nkc", NULL, NULL, NULL, "Nkongho"},
	{"nkd", NULL, NULL, NULL, "Koireng"},
	{"nke", NULL, NULL, NULL, "Duke"},
	{"nkf", NULL, NULL, NULL, "Inpui Naga"},
	{"nkg", NULL, NULL, NULL, "Nekgini"},
	{"nkh", NULL, NULL, NULL, "Khezha Naga"},
	{"nki", NULL, NULL, NULL, "Thangal Naga"},
	{"nkj", NULL, NULL, NULL, "Nakai"},
	{"nkk", NULL, NULL, NULL, "Nokuku"},
	{"nkm", NULL, NULL, NULL, "Namat"},
	{"nkn", NULL, NULL, NULL, "Nkangala"},
	{"nko", NULL, NULL, NULL, "Nkonya"},
	{"nkp", NULL, NULL, NULL, "Niuatoputapu"},
	{"nkq", NULL, NULL, NULL, "Nkami"},
	{"nkr", NULL, NULL, NULL, "Nukuoro"},
	{"nks", NULL, NULL, NULL, "North Asmat"},
	{"nkt", NULL, NULL, NULL, "Nyika (Tanzania)"},
	{"nku", NULL, NULL, NULL, "Bouna Kulango"},
	{"nkv", NULL, NULL, NULL, "Nyika (Malawi and Zambia)"},
	{"nkw", NULL, NULL, NULL, "Nkutu"},
	{"nkx", NULL, NULL, NULL, "Nkoroo"},
	{"nkz", NULL, NULL, NULL, "Nkari"},
	{"nla", NULL, NULL, NULL, "Ngombale"},
	{"nlc", NULL, NULL, NULL, "Nalca"},
	{"nld", "dut", "nld", "nl", "Dutch"},
	{"nle", NULL, NULL, NULL, "East Nyala"},
	{"nlg", NULL, NULL, NULL, "Gela"},
	{"nli", NULL, NULL, NULL, "Grangali"},
	{"nlj", NULL, NULL, NULL, "Nyali"},
	{"nlk", NULL, NULL, NULL, "Ninia Yali"},
	{"nll", NULL, NULL, NULL, "Nihali"},
	{"nlm", NULL, NULL, NULL, "Mankiyali"},
	{"nlo", NULL, NULL, NULL, "Ngul"},
	{"nlq", NULL, NULL, NULL, "Lao Naga"},
	{"nlu", NULL, NULL, NULL, "Nchumbulu"},
	{"nlv", NULL, NULL, NULL, "Orizaba Nahuatl"},
	{"nlw", NULL, NULL, NULL, "Walangama"},
	{"nlx", NULL, NULL, NULL, "Nahali"},
	{"nly", NULL, NULL, NULL, "Nyamal"},
	{"nlz", NULL, NULL, NULL, "Nalögo"},
	{"nma", NULL, NULL, NULL, "Maram Naga"},
	{"nmb", NULL, NULL, NULL, "Big Nambas"},
	{"nmc", NULL, NULL, NULL, "Ngam"},
	{"nmd", NULL, NULL, NULL, "Ndumu"},
	{"nme", NULL, NULL, NULL, "Mzieme Naga"},
	{"nmf", NULL, NULL, NULL, "Tangkhul Naga (India)"},
	{"nmg", NULL, NULL, NULL, "Kwasio"},
	{"nmh", NULL, NULL, NULL, "Monsang Naga"},
	{"nmi", NULL, NULL, NULL, "Nyam"},
	{"nmj", NULL, NULL, NULL, "Ngombe (Central African Republic)"},
	{"nmk", NULL, NULL, NULL, "Namakura"},
	{"nml", NULL, NULL, NULL, "Ndemli"},
	{"nmm", NULL, NULL, NULL, "Manangba"},
	{"nmn", NULL, NULL, NULL, "ǃXóõ"},
	{"nmo", NULL, NULL, NULL, "Moyon Naga"},
	{"nmp", NULL, NULL, NULL, "Nimanbur"},
	{"nmq", NULL, NULL, NULL, "Nambya"},
	{"nmr", NULL, NULL, NULL, "Nimbari"},
	{"nms", NULL, NULL, NULL, "Letemboi"},
	{"nmt", NULL, NULL, NULL, "Namonuito"},
	{"nmu", NULL, NULL, NULL, "Northeast Maidu"},
	{"nmv", NULL, NULL, NULL, "Ngamini"},
	{"nmw", NULL, NULL, NULL, "Nimoa"},
	{"nmx", NULL, NULL, NULL, "Nama (Papua New Guinea)"},
	{"nmy", NULL, NULL, NULL, "Namuyi"},
	{"nmz", NULL, NULL, NULL, "Nawdm"},
	{"nna", NULL, NULL, NULL, "Nyangumarta"},
	{"nnb", NULL, NULL, NULL, "Nande"},
	{"nnc", NULL, NULL, NULL, "Nancere"},
	{"nnd", NULL, NULL, NULL, "West Ambae"},
	{"nne", NULL, NULL, NULL, "Ngandyera"},
	{"nnf", NULL, NULL, NULL, "Ngaing"},
	{"nng", NULL, NULL, NULL, "Maring Naga"},
	{"nnh", NULL, NULL, NULL, "Ngiemboon"},
	{"nni", NULL, NULL, NULL, "North Nuaulu"},
	{"nnj", NULL, NULL, NULL, "Nyangatom"},
	{"nnk", NULL, NULL, NULL, "Nankina"},
	{"nnl", NULL, NULL, NULL, "Northern Rengma Naga"},
	{"nnm", NULL, NULL, NULL, "Namia"},
	{"nnn", NULL, NULL, NULL, "Ngete"},
	{"nno", "nno", "nno", "nn", "Norwegian Nynorsk"},
	{"nnp", NULL, NULL, NULL, "Wancho Naga"},
	{"nnq", NULL, NULL, NULL, "Ngindo"},
	{"nnr", NULL, NULL, NULL, "Narungga"},
	{"nnt", NULL, NULL, NULL, "Nanticoke"},
	{"nnu", NULL, NULL, NULL, "Dwang"},
	{"nnv", NULL, NULL, NULL, "Nugunu (Australia)"},
	{"nnw", NULL, NULL, NULL, "Southern Nuni"},
	{"nny", NULL, NULL, NULL, "Nyangga"},
	{"nnz", NULL, NULL, NULL, "Nda'nda'"},
	{"noa", NULL, NULL, NULL, "Woun Meu"},
	{"nob", "nob", "nob", "nb", "Norwegian Bokmål"},
	{"noc", NULL, NULL, NULL, "Nuk"},
	{"nod", NULL, NULL, NULL, "Northern Thai"},
	{"noe", NULL, NULL, NULL, "Nimadi"},
	{"nof", NULL, NULL, NULL, "Nomane"},
	{"nog", "nog", "nog", NULL, "Nogai"},
	{"noh", NULL, NULL, NULL, "Nomu"},
	{"noi", NULL, NULL, NULL, "Noiri"},
	{"noj", NULL, NULL, NULL, "Nonuya"},
	{"nok", NULL, NULL, NULL, "Nooksack"},
	{"nol", NULL, NULL, NULL, "Nomlaki"},
	{"nom", NULL, NULL, NULL, "Nocamán"},
	{"non", "non", "non", NULL, "Old Norse"},
	{"nop", NULL, NULL, NULL, "Numanggang"},
	{"noq", NULL, NULL, NULL, "Ngongo"},
	{"nor", "nor", "nor", "no", "Norwegian"},
	{"nos", NULL, NULL, NULL, "Eastern Nisu"},
	{"not", NULL, NULL, NULL, "Nomatsiguenga"},
	{"nou", NULL, NULL, NULL, "Ewage-Notu"},
	{"nov", NULL, NULL, NULL, "Novial"},
	{"now", NULL, NULL, NULL, "Nyambo"},
	{"noy", NULL, NULL, NULL, "Noy"},
	{"noz", NULL, NULL, NULL, "Nayi"},
	{"npa", NULL, NULL, NULL, "Nar Phu"},
	{"npb", NULL, NULL, NULL, "Nupbikha"},
	{"npg", NULL, NULL, NULL, "Ponyo-Gongwang Naga"},
	{"nph", NULL, NULL, NULL, "Phom Naga"},
	{"npi", NULL, NULL, NULL, "Nepali (individual language)"},
	{"npl", NULL, NULL, NULL, "Southeastern Puebla Nahuatl"},
	{"npn", NULL, NULL, NULL, "Mondropolon"},
	{"npo", NULL, NULL, NULL, "Pochuri Naga"},
	{"nps", NULL, NULL, NULL, "Nipsan"},
	{"npu", NULL, NULL, NULL, "Puimei Naga"},
	{"npx", NULL, NULL, NULL, "Noipx"},
	{"npy", NULL, NULL, NULL, "Napu"},
	{"nqg", NULL, NULL, NULL, "Southern Nago"},
	{"nqk", NULL, NULL, NULL, "Kura Ede Nago"},
	{"nql", NULL, NULL, NULL, "Ngendelengo"},
	{"nqm", NULL, NULL, NULL, "Ndom"},
	{"nqn", NULL, NULL, NULL, "Nen"},
	{"nqo", "nqo", "nqo", NULL, "N'Ko"},
	{"nqq", NULL, NULL, NULL, "Kyan-Karyaw Naga"},
	{"nqt", NULL, NULL, NULL, "Nteng"},
	{"nqy", NULL, NULL, NULL, "Akyaung Ari Naga"},
	{"nra", NULL, NULL, NULL, "Ngom"},
	{"nrb", NULL, NULL, NULL, "Nara"},
	{"nrc", NULL, NULL, NULL, "Noric"},
	{"nre", NULL, NULL, NULL, "Southern Rengma Naga"},
	{"nrf", NULL, NULL, NULL, "Jèrriais"},
	{"nrg", NULL, NULL, NULL, "Narango"},
	{"nri", NULL, NULL, NULL, "Chokri Naga"},
	{"nrk", NULL, NULL, NULL, "Ngarla"},
	{"nrl", NULL, NULL, NULL, "Ngarluma"},
	{"nrm", NULL, NULL, NULL, "Narom"},
	{"nrn", NULL, NULL, NULL, "Norn"},
	{"nrp", NULL, NULL, NULL, "North Picene"},
	{"nrr", NULL, NULL, NULL, "Norra"},
	{"nrt", NULL, NULL, NULL, "Northern Kalapuya"},
	{"nru", NULL, NULL, NULL, "Narua"},
	{"nrx", NULL, NULL, NULL, "Ngurmbur"},
	{"nrz", NULL, NULL, NULL, "Lala"},
	{"nsa", NULL, NULL, NULL, "Sangtam Naga"},
	{"nsb", NULL, NULL, NULL, "Lower Nossob"},
	{"nsc", NULL, NULL, NULL, "Nshi"},
	{"nsd", NULL, NULL, NULL, "Southern Nisu"},
	{"nse", NULL, NULL, NULL, "Nsenga"},
	{"nsf", NULL, NULL, NULL, "Northwestern Nisu"},
	{"nsg", NULL, NULL, NULL, "Ngasa"},
	{"nsh", NULL, NULL, NULL, "Ngoshie"},
	{"nsi", NULL, NULL, NULL, "Nigerian Sign Language"},
	{"nsk", NULL, NULL, NULL, "Naskapi"},
	{"nsl", NULL, NULL, NULL, "Norwegian Sign Language"},
	{"nsm", NULL, NULL, NULL, "Sumi Naga"},
	{"nsn", NULL, NULL, NULL, "Nehan"},
	{"nso", "nso", "nso", NULL, "Pedi"},
	{"nsp", NULL, NULL, NULL, "Nepalese Sign Language"},
	{"nsq", NULL, NULL, NULL, "Northern Sierra Miwok"},
	{"nsr", NULL, NULL, NULL, "Maritime Sign Language"},
	{"nss", NULL, NULL, NULL, "Nali"},
	{"nst", NULL, NULL, NULL, "Tase Naga"},
	{"nsu", NULL, NULL, NULL, "Sierra Negra Nahuatl"},
	{"nsv", NULL, NULL, NULL, "Southwestern Nisu"},
	{"nsw", NULL, NULL, NULL, "Navut"},
	{"nsx", NULL, NULL, NULL, "Nsongo"},
	{"nsy", NULL, NULL, NULL, "Nasal"},
	{"nsz", NULL, NULL, NULL, "Nisenan"},
	{"ntd", NULL, NULL, NULL, "Northern Tidung"},
	{"nte", NULL, NULL, NULL, "Nathembo"},
	{"ntg", NULL, NULL, NULL, "Ngantangarra"},
	{"nti", NULL, NULL, NULL, "Natioro"},
	{"ntj", NULL, NULL, NULL, "Ngaanyatjarra"},
	{"ntk", NULL, NULL, NULL, "Ikoma-Nata-Isenye"},
	{"ntm", NULL, NULL, NULL, "Nateni"},
	{"nto", NULL, NULL, NULL, "Ntomba"},
	{"ntp", NULL, NULL, NULL, "Northern Tepehuan"},
	{"ntr", NULL, NULL, NULL, "Delo"},
	{"ntu", NULL, NULL, NULL, "Natügu"},
	{"ntw", NULL, NULL, NULL, "Nottoway"},
	{"ntx", NULL, NULL, NULL, "Tangkhul Naga (Myanmar)"},
	{"nty", NULL, NULL, NULL, "Mantsi"},
	{"ntz", NULL, NULL, NULL, "Natanzi"},
	{"nua", NULL, NULL, NULL, "Yuanga"},
	{"nuc", NULL, NULL, NULL, "Nukuini"},
	{"nud", NULL, NULL, NULL, "Ngala"},
	{"nue", NULL, NULL, NULL, "Ngundu"},
	{"nuf", NULL, NULL, NULL, "Nusu"},
	{"nug", NULL, NULL, NULL, "Nungali"},
	{"nuh", NULL, NULL, NULL, "Ndunda"},
	{"nui", NULL, NULL, NULL, "Ngumbi"},
	{"nuj", NULL, NULL, NULL, "Nyole"},
	{"nuk", NULL, NULL, NULL, "Nuu-chah-nulth"},
	{"nul", NULL, NULL, NULL, "Nusa Laut"},
	{"num", NULL, NULL, NULL, "Niuafo'ou"},
	{"nun", NULL, NULL, NULL, "Anong"},
	{"nuo", NULL, NULL, NULL, "Nguôn"},
	{"nup", NULL, NULL, NULL, "Nupe-Nupe-Tako"},
	{"nuq", NULL, NULL, NULL, "Nukumanu"},
	{"nur", NULL, NULL, NULL, "Nukuria"},
	{"nus", NULL, NULL, NULL, "Nuer"},
	{"nut", NULL, NULL, NULL, "Nung (Viet Nam)"},
	{"nuu", NULL, NULL, NULL, "Ngbundu"},
	{"nuv", NULL, NULL, NULL, "Northern Nuni"},
	{"nuw", NULL, NULL, NULL, "Nguluwan"},
	{"nux", NULL, NULL, NULL, "Mehek"},
	{"nuy", NULL, NULL, NULL, "Nunggubuyu"},
	{"nuz", NULL, NULL, NULL, "Tlamacazapa Nahuatl"},
	{"nvh", NULL, NULL, NULL, "Nasarian"},
	{"nvm", NULL, NULL, NULL, "Namiae"},
	{"nvo", NULL, NULL, NULL, "Nyokon"},
	{"nwa", NULL, NULL, NULL, "Nawathinehena"},
	{"nwb", NULL, NULL, NULL, "Nyabwa"},
	{"nwc", "nwc", "nwc", NULL, "Classical Newari"},
	{"nwe", NULL, NULL, NULL, "Ngwe"},
	{"nwg", NULL, NULL, NULL, "Ngayawung"},
	{"nwi", NULL, NULL, NULL, "Southwest Tanna"},
	{"nwm", NULL, NULL, NULL, "Nyamusa-Molo"},
	{"nwo", NULL, NULL, NULL, "Nauo"},
	{"nwr", NULL, NULL, NULL, "Nawaru"},
	{"nwx", NULL, NULL, NULL, "Middle Newar"},
	{"nwy", NULL, NULL, NULL, "Nottoway-Meherrin"},
	{"nxa", NULL, NULL, NULL, "Nauete"},
	{"nxd", NULL, NULL, NULL, "Ngando (Democratic Republic of Congo)"},
	{"nxe", NULL, NULL, NULL, "Nage"},
	{"nxg", NULL, NULL, NULL, "Ngad'a"},
	{"nxi", NULL, NULL, NULL, "Nindi"},
	{"nxk", NULL, NULL, NULL, "Koki Naga"},
	{"nxl", NULL, NULL, NULL, "South Nuaulu"},
	{"nxm", NULL, NULL, NULL, "Numidian"},
	{"nxn", NULL, NULL, NULL, "Ngawun"},
	{"nxo", NULL, NULL, NULL, "Ndambomo"},
	{"nxq", NULL, NULL, NULL, "Naxi"},
	{"nxr", NULL, NULL, NULL, "Ninggerum"},
	{"nxx", NULL, NULL, NULL, "Nafri"},
	{"nya", "nya", "nya", "ny", "Nyanja"},
	{"nyb", NULL, NULL, NULL, "Nyangbo"},
	{"nyc", NULL, NULL, NULL, "Nyanga-li"},
	{"nyd", NULL, NULL, NULL, "Nyore"},
	{"nye", NULL, NULL, NULL, "Nyengo"},
	{"nyf", NULL, NULL, NULL, "Giryama"},
	{"nyg", NULL, NULL, NULL, "Nyindu"},
	{"nyh", NULL, NULL, NULL, "Nyikina"},
	{"nyi", NULL, NULL, NULL, "Ama (Sudan)"},
	{"nyj", NULL, NULL, NULL, "Nyanga"},
	{"nyk", NULL, NULL, NULL, "Nyaneka"},
	{"nyl", NULL, NULL, NULL, "Nyeu"},
	{"nym", "nym", "nym", NULL, "Nyamwezi"},
	{"nyn", "nyn", "nyn", NULL, "Nyankole"},
	{"nyo", "nyo", "nyo", NULL, "Nyoro"},
	{"nyp", NULL, NULL, NULL, "Nyang'i"},
	{"nyq", NULL, NULL, NULL, "Nayini"},
	{"nyr", NULL, NULL, NULL, "Nyiha (Malawi)"},
	{"nys", NULL, NULL, NULL, "Nyungar"},
	{"nyt", NULL, NULL, NULL, "Nyawaygi"},
	{"nyu", NULL, NULL, NULL, "Nyungwe"},
	{"nyv", NULL, NULL, NULL, "Nyulnyul"},
	{"nyw", NULL, NULL, NULL, "Nyaw"},
	{"nyx", NULL, NULL, NULL, "Nganyaywana"},
	{"nyy", NULL, NULL, NULL, "Nyakyusa-Ngonde"},
	{"nza", NULL, NULL, NULL, "Tigon Mbembe"},
	{"nzb", NULL, NULL, NULL, "Njebi"},
	{"nzd", NULL, NULL, NULL, "Nzadi"},
	{"nzi", "nzi", "nzi", NULL, "Nzima"},
	{"nzk", NULL, NULL, NULL, "Nzakara"},
	{"nzm", NULL, NULL, NULL, "Zeme Naga"},
	{"nzs", NULL, NULL, NULL, "New Zealand Sign Language"},
	{"nzu", NULL, NULL, NULL, "Teke-Nzikou"},
	{"nzy", NULL, NULL, NULL, "Nzakambay"},
	{"nzz", NULL, NULL, NULL, "Nanga Dama Dogon"},
	{"oaa", NULL, NULL, NULL, "Orok"},
	{"oac", NULL, NULL, NULL, "Oroch"},
	{"oar", NULL, NULL, NULL, "Old Aramaic (up to 700 BCE)"},
	{"oav", NULL, NULL, NULL, "Old Avar"},
	{"obi", NULL, NULL, NULL, "Obispeño"},
	{"obk", NULL, NULL, NULL, "Southern Bontok"},
	{"obl", NULL, NULL, NULL, "Oblo"},
	{"obm", NULL, NULL, NULL, "Moabite"},
	{"obo", NULL, NULL, NULL, "Obo Manobo"},
	{"obr", NULL, NULL, NULL, "Old Burmese"},
	{"obt", NULL, NULL, NULL, "Old Breton"},
	{"obu", NULL, NULL, NULL, "Obulom"},
	{"oca", NULL, NULL, NULL, "Ocaina"},
	{"och", NULL, NULL, NULL, "Old Chinese"},
	{"oci", "oci", "oci", "oc", "Occitan (post 1500)"},
	{"ocm", NULL, NULL, NULL, "Old Cham"},
	{"oco", NULL, NULL, NULL, "Old Cornish"},
	{"ocu", NULL, NULL, NULL, "Atzingo Matlatzinca"},
	{"oda", NULL, NULL, NULL, "Odut"},
	{"odk", NULL, NULL, NULL, "Od"},
	{"odt", NULL, NULL, NULL, "Old Dutch"},
	{"odu", NULL, NULL, NULL, "Odual"},
	{"ofo", NULL, NULL, NULL, "Ofo"},
	{"ofs", NULL, NULL, NULL, "Old Frisian"},
	{"ofu", NULL, NULL, NULL, "Efutop"},
	{"ogb", NULL, NULL, NULL, "Ogbia"},
	{"ogc", NULL, NULL, NULL, "Ogbah"},
	{"oge", NULL, NULL, NULL, "Old Georgian"},
	{"ogg", NULL, NULL, NULL, "Ogbogolo"},
	{"ogo", NULL, NULL, NULL, "Khana"},
	{"ogu", NULL, NULL, NULL, "Ogbronuagum"},
	{"oht", NULL, NULL, NULL, "Old Hittite"},
	{"ohu", NULL, NULL, NULL, "Old Hungarian"},
	{"oia", NULL, NULL, NULL, "Oirata"},
	{"oin", NULL, NULL, NULL, "Inebu One"},
	{"ojb", NULL, NULL, NULL, "Northwestern Ojibwa"},
	{"ojc", NULL, NULL, NULL, "Central Ojibwa"},
	{"ojg", NULL, NULL, NULL, "Eastern Ojibwa"},
	{"oji", "oji", "oji", "oj", "Ojibwa"},
	{"ojp", NULL, NULL, NULL, "Old Japanese"},
	{"ojs", NULL, NULL, NULL, "Severn Ojibwa"},
	{"ojv", NULL, NULL, NULL, "Ontong Java"},
	{"ojw", NULL, NULL, NULL, "Western Ojibwa"},
	{"oka", NULL, NULL, NULL, "Okanagan"},
	{"okb", NULL, NULL, NULL, "Okobo"},
	{"okc", NULL, NULL, NULL, "Kobo"},
	{"okd", NULL, NULL, NULL, "Okodia"},
	{"oke", NULL, NULL, NULL, "Okpe (Southwestern Edo)"},
	{"okg", NULL, NULL, NULL, "Koko Babangk"},
	{"okh", NULL, NULL, NULL, "Koresh-e Rostam"},
	{"oki", NULL, NULL, NULL, "Okiek"},
	{"okj", NULL, NULL, NULL, "Oko-Juwoi"},
	{"okk", NULL, NULL, NULL, "Kwamtim One"},
	{"okl", NULL, NULL, NULL, "Old Kentish Sign Language"},
	{"okm", NULL, NULL, NULL, "Middle Korean (10th-16th cent.)"},
	{"okn", NULL, NULL, NULL, "Oki-No-Erabu"},
	{"oko", NULL, NULL, NULL, "Old Korean (3rd-9th cent.)"},
	{"okr", NULL, NULL, NULL, "Kirike"},
	{"oks", NULL, NULL, NULL, "Oko-Eni-Osayen"},
	{"oku", NULL, NULL, NULL, "Oku"},
	{"okv", NULL, NULL, NULL, "Orokaiva"},
	{"okx", NULL, NULL, NULL, "Okpe (Northwestern Edo)"},
	{"okz", NULL, NULL, NULL, "Old Khmer"},
	{"ola", NULL, NULL, NULL, "Walungge"},
	{"old", NULL, NULL, NULL, "Mochi"},
	{"ole", NULL, NULL, NULL, "Olekha"},
	{"olk", NULL, NULL, NULL, "Olkol"},
	{"olm", NULL, NULL, NULL, "Oloma"},
	{"olo", NULL, NULL, NULL, "Livvi"},
	{"olr", NULL, NULL, NULL, "Olrat"},
	{"olt", NULL, NULL, NULL, "Old Lithuanian"},
	{"olu", NULL, NULL, NULL, "Kuvale"},
	{"oma", NULL, NULL, NULL, "Omaha-Ponca"},
	{"omb", NULL, NULL, NULL, "East Ambae"},
	{"omc", NULL, NULL, NULL, "Mochica"},
	{"omg", NULL, NULL, NULL, "Omagua"},
	{"omi", NULL, NULL, NULL, "Omi"},
	{"omk", NULL, NULL, NULL, "Omok"},
	{"oml", NULL, NULL, NULL, "Ombo"},
	{"omn", NULL, NULL, NULL, "Minoan"},
	{"omo", NULL, NULL, NULL, "Utarmbung"},
	{"omp", NULL, NULL, NULL, "Old Manipuri"},
	{"omr", NULL, NULL, NULL, "Old Marathi"},
	{"omt", NULL, NULL, NULL, "Omotik"},
	{"omu", NULL, NULL, NULL, "Omurano"},
	{"omw", NULL, NULL, NULL, "South Tairora"},
	{"omx", NULL, NULL, NULL, "Old Mon"},
	{"omy", NULL, NULL, NULL, "Old Malay"},
	{"ona", NULL, NULL, NULL, "Ona"},
	{"onb", NULL, NULL, NULL, "Lingao"},
	{"one", NULL, NULL, NULL, "Oneida"},
	{"ong", NULL, NULL, NULL, "Olo"},
	{"oni", NULL, NULL, NULL, "Onin"},
	{"onj", NULL, NULL, NULL, "Onjob"},
	{"onk", NULL, NULL, NULL, "Kabore One"},
	{"onn", NULL, NULL, NULL, "Onobasulu"},
	{"ono", NULL, NULL, NULL, "Onondaga"},
	{"onp", NULL, NULL, NULL, "Sartang"},
	{"onr", NULL, NULL, NULL, "Northern One"},
	{"ons", NULL, NULL, NULL, "Ono"},
	{"ont", NULL, NULL, NULL, "Ontenu"},
	{"onu", NULL, NULL, NULL, "Unua"},
	{"onw", NULL, NULL, NULL, "Old Nubian"},
	{"onx", NULL, NULL, NULL, "Onin Based Pidgin"},
	{"ood", NULL, NULL, NULL, "Tohono O'odham"},
	{"oog", NULL, NULL, NULL, "Ong"},
	{"oon", NULL, NULL, NULL, "Önge"},
	{"oor", NULL, NULL, NULL, "Oorlams"},
	{"oos", NULL, NULL, NULL, "Old Ossetic"},
	{"opa", NULL, NULL, NULL, "Okpamheri"},
	{"opk", NULL, NULL, NULL, "Kopkaka"},
	{"opm", NULL, NULL, NULL, "Oksapmin"},
	{"opo", NULL, NULL, NULL, "Opao"},
	{"opt", NULL, NULL, NULL, "Opata"},
	{"opy", NULL, NULL, NULL, "Ofayé"},
	{"ora", NULL, NULL, NULL, "Oroha"},
	{"orc", NULL, NULL, NULL, "Orma"},
	{"ore", NULL, NULL, NULL, "Orejón"},
	{"org", NULL, NULL, NULL, "Oring"},
	{"orh", NULL, NULL, NULL, "Oroqen"},
	{"ori", "ori", "ori", "or", "Oriya (macrolanguage)"},
	{"orm", "orm", "orm", "om", "Oromo"},
	{"orn", NULL, NULL, NULL, "Orang Kanaq"},
	{"oro", NULL, NULL, NULL, "Orokolo"},
	{"orr", NULL, NULL, NULL, "Oruma"},
	{"ors", NULL, NULL, NULL, "Orang Seletar"},
	{"ort", NULL, NULL, NULL, "Adivasi Oriya"},
	{"oru", NULL, NULL, NULL, "Ormuri"},
	{"orv", NULL, NULL, NULL, "Old Russian"},
	{"orw", NULL, NULL, NULL, "Oro Win"},
	{"orx", NULL, NULL, NULL, "Oro"},
	{"ory", NULL, NULL, NULL, "Odia"},
	{"orz", NULL, NULL, NULL, "Ormu"},
	{"osa", "osa", "osa", NULL, "Osage"},
	{"osc", NULL, NULL, NULL, "Oscan"},
	{"osi", NULL, NULL, NULL, "Osing"},
	{"osn", NULL, NULL, NULL, "Old Sundanese"},
	{"oso", NULL, NULL, NULL, "Ososo"},
	{"osp", NULL, NULL, NULL, "Old Spanish"},
	{"oss", "oss", "oss", "os", "Ossetian"},
	{"ost", NULL, NULL, NULL, "Osatu"},
	{"osu", NULL, NULL, NULL, "Southern One"},
	{"osx", NULL, NULL, NULL, "Old Saxon"},
	{"ota", "ota", "ota", NULL, "Ottoman Turkish (1500-1928)"},
	{"otb", NULL, NULL, NULL, "Old Tibetan"},
	{"otd", NULL, NULL, NULL, "Ot Danum"},
	{"ote", NULL, NULL, NULL, "Mezquital Otomi"},
	{"oti", NULL, NULL, NULL, "Oti"},
	{"otk", NULL, NULL, NULL, "Old Turkish"},
	{"otl", NULL, NULL, NULL, "Tilapa Otomi"},
	{"otm", NULL, NULL, NULL, "Eastern Highland Otomi"},
	{"otn", NULL, NULL, NULL, "Tenango Otomi"},
	{"otq", NULL, NULL, NULL, "Querétaro Otomi"},
	{"otr", NULL, NULL, NULL, "Otoro"},
	{"ots", NULL, NULL, NULL, "Estado de México Otomi"},
	{"ott", NULL, NULL, NULL, "Temoaya Otomi"},
	{"otu", NULL, NULL, NULL, "Otuke"},
	{"otw", NULL, NULL, NULL, "Ottawa"},
	{"otx", NULL, NULL, NULL, "Texcatepec Otomi"},
	{"oty", NULL, NULL, NULL, "Old Tamil"},
	{"otz", NULL, NULL, NULL, "Ixtenco Otomi"},
	{"oua", NULL, NULL, NULL, "Tagargrent"},
	{"oub", NULL, NULL, NULL, "Glio-Oubi"},
	{"oue", NULL, NULL, NULL, "Oune"},
	{"oui", NULL, NULL, NULL, "Old Uighur"},
	{"oum", NULL, NULL, NULL, "Ouma"},
	{"ovd", NULL, NULL, NULL, "Elfdalian"},
	{"owi", NULL, NULL, NULL, "Owiniga"},
	{"owl", NULL, NULL, NULL, "Old Welsh"},
	{"oyb", NULL, NULL, NULL, "Oy"},
	{"oyd", NULL, NULL, NULL, "Oyda"},
	{"oym", NULL, NULL, NULL, "Wayampi"},
	{"oyy", NULL, NULL, NULL, "Oya'oya"},
	{"ozm", NULL, NULL, NULL, "Koonzime"},
	{"pab", NULL, NULL, NULL, "Parecís"},
	{"pac", NULL, NULL, NULL, "Pacoh"},
	{"pad", NULL, NULL, NULL, "Paumarí"},
	{"pae", NULL, NULL, NULL, "Pagibete"},
	{"paf", NULL, NULL, NULL, "Paranawát"},
	{"pag", "pag", "pag", NULL, "Pangasinan"},
	{"pah", NULL, NULL, NULL, "Tenharim"},
	{"pai", NULL, NULL, NULL, "Pe"},
	{"pak", NULL, NULL, NULL, "Parakanã"},
	{"pal", "pal", "pal", NULL, "Pahlavi"},
	{"pam", "pam", "pam", NULL, "Pampanga"},
	{"pan", "pan", "pan", "pa", "Panjabi"},
	{"pao", NULL, NULL, NULL, "Northern Paiute"},
	{"pap", "pap", "pap", NULL, "Papiamento"},
	{"paq", NULL, NULL, NULL, "Parya"},
	{"par", NULL, NULL, NULL, "Panamint"},
	{"pas", NULL, NULL, NULL, "Papasena"},
	{"pau", "pau", "pau", NULL, "Palauan"},
	{"pav", NULL, NULL, NULL, "Pakaásnovos"},
	{"paw", NULL, NULL, NULL, "Pawnee"},
	{"pax", NULL, NULL, NULL, "Pankararé"},
	{"pay", NULL, NULL, NULL, "Pech"},
	{"paz", NULL, NULL, NULL, "Pankararú"},
	{"pbb", NULL, NULL, NULL, "Páez"},
	{"pbc", NULL, NULL, NULL, "Patamona"},
	{"pbe", NULL, NULL, NULL, "Mezontla Popoloca"},
	{"pbf", NULL, NULL, NULL, "Coyotepec Popoloca"},
	{"pbg", NULL, NULL, NULL, "Paraujano"},
	{"pbh", NULL, NULL, NULL, "E'ñapa Woromaipu"},
	{"pbi", NULL, NULL, NULL, "Parkwa"},
	{"pbl", NULL, NULL, NULL, "Mak (Nigeria)"},
	{"pbm", NULL, NULL, NULL, "Puebla Mazatec"},
	{"pbn", NULL, NULL, NULL, "Kpasam"},
	{"pbo", NULL, NULL, NULL, "Papel"},
	{"pbp", NULL, NULL, NULL, "Badyara"},
	{"pbr", NULL, NULL, NULL, "Pangwa"},
	{"pbs", NULL, NULL, NULL, "Central Pame"},
	{"pbt", NULL, NULL, NULL, "Southern Pashto"},
	{"pbu", NULL, NULL, NULL, "Northern Pashto"},
	{"pbv", NULL, NULL, NULL, "Pnar"},
	{"pby", NULL, NULL, NULL, "Pyu (Papua New Guinea)"},
	{"pca", NULL, NULL, NULL, "Santa Inés Ahuatempan Popoloca"},
	{"pcb", NULL, NULL, NULL, "Pear"},
	{"pcc", NULL, NULL, NULL, "Bouyei"},
	{"pcd", NULL, NULL, NULL, "Picard"},
	{"pce", NULL, NULL, NULL, "Ruching Palaung"},
	{"pcf", NULL, NULL, NULL, "Paliyan"},
	{"pcg", NULL, NULL, NULL, "Paniya"},
	{"pch", NULL, NULL, NULL, "Pardhan"},
	{"pci", NULL, NULL, NULL, "Duruwa"},
	{"pcj", NULL, NULL, NULL, "Parenga"},
	{"pck", NULL, NULL, NULL, "Paite Chin"},
	{"pcl", NULL, NULL, NULL, "Pardhi"},
	{"pcm", NULL, NULL, NULL, "Nigerian Pidgin"},
	{"pcn", NULL, NULL, NULL, "Piti"},
	{"pcp", NULL, NULL, NULL, "Pacahuara"},
	{"pcw", NULL, NULL, NULL, "Pyapun"},
	{"pda", NULL, NULL, NULL, "Anam"},
	{"pdc", NULL, NULL, NULL, "Pennsylvania German"},
	{"pdi", NULL, NULL, NULL, "Pa Di"},
	{"pdn", NULL, NULL, NULL, "Podena"},
	{"pdo", NULL, NULL, NULL, "Padoe"},
	{"pdt", NULL, NULL, NULL, "Plautdietsch"},
	{"pdu", NULL, NULL, NULL, "Kayan"},
	{"pea", NULL, NULL, NULL, "Peranakan Indonesian"},
	{"peb", NULL, NULL, NULL, "Eastern Pomo"},
	{"ped", NULL, NULL, NULL, "Mala (Papua New Guinea)"},
	{"pee", NULL, NULL, NULL, "Taje"},
	{"pef", NULL, NULL, NULL, "Northeastern Pomo"},
	{"peg", NULL, NULL, NULL, "Pengo"},
	{"peh", NULL, NULL, NULL, "Bonan"},
	{"pei", NULL, NULL, NULL, "Chichimeca-Jonaz"},
	{"pej", NULL, NULL, NULL, "Northern Pomo"},
	{"pek", NULL, NULL, NULL, "Penchal"},
	{"pel", NULL, NULL, NULL, "Pekal"},
	{"pem", NULL, NULL, NULL, "Phende"},
	{"peo", "peo", "peo", NULL, "Old Persian (ca. 600-400 B.C.)"},
	{"pep", NULL, NULL, NULL, "Kunja"},
	{"peq", NULL, NULL, NULL, "Southern Pomo"},
	{"pes", NULL, NULL, NULL, "Iranian Persian"},
	{"pev", NULL, NULL, NULL, "Pémono"},
	{"pex", NULL, NULL, NULL, "Petats"},
	{"pey", NULL, NULL, NULL, "Petjo"},
	{"pez", NULL, NULL, NULL, "Eastern Penan"},
	{"pfa", NULL, NULL, NULL, "Pááfang"},
	{"pfe", NULL, NULL, NULL, "Pere"},
	{"pfl", NULL, NULL, NULL, "Pfaelzisch"},
	{"pga", NULL, NULL, NULL, "Sudanese Creole Arabic"},
	{"pgd", NULL, NULL, NULL, "Gāndhārī"},
	{"pgg", NULL, NULL, NULL, "Pangwali"},
	{"pgi", NULL, NULL, NULL, "Pagi"},
	{"pgk", NULL, NULL, NULL, "Rerep"},
	{"pgl", NULL, NULL, NULL, "Primitive Irish"},
	{"pgn", NULL, NULL, NULL, "Paelignian"},
	{"pgs", NULL, NULL, NULL, "Pangseng"},
	{"pgu", NULL, NULL, NULL, "Pagu"},
	{"pgz", NULL, NULL, NULL, "Papua New Guinean Sign Language"},
	{"pha", NULL, NULL, NULL, "Pa-Hng"},
	{"phd", NULL, NULL, NULL, "Phudagi"},
	{"phg", NULL, NULL, NULL, "Phuong"},
	{"phh", NULL, NULL, NULL, "Phukha"},
	{"phk", NULL, NULL, NULL, "Phake"},
	{"phl", NULL, NULL, NULL, "Phalura"},
	{"phm", NULL, NULL, NULL, "Phimbi"},
	{"phn", "phn", "phn", NULL, "Phoenician"},
	{"pho", NULL, NULL, NULL, "Phunoi"},
	{"phq", NULL, NULL, NULL, "Phana'"},
	{"phr", NULL, NULL, NULL, "Pahari-Potwari"},
	{"pht", NULL, NULL, NULL, "Phu Thai"},
	{"phu", NULL, NULL, NULL, "Phuan"},
	{"phv", NULL, NULL, NULL, "Pahlavani"},
	{"phw", NULL, NULL, NULL, "Phangduwali"},
	{"pia", NULL, NULL, NULL, "Pima Bajo"},
	{"pib", NULL, NULL, NULL, "Yine"},
	{"pic", NULL, NULL, NULL, "Pinji"},
	{"pid", NULL, NULL, NULL, "Piaroa"},
	{"pie", NULL, NULL, NULL, "Piro"},
	{"pif", NULL, NULL, NULL, "Pingelapese"},
	{"pig", NULL, NULL, NULL, "Pisabo"},
	{"pih", NULL, NULL, NULL, "Pitcairn-Norfolk"},
	{"pii", NULL, NULL, NULL, "Pini"},
	{"pij", NULL, NULL, NULL, "Pijao"},
	{"pil", NULL, NULL, NULL, "Yom"},
	{"pim", NULL, NULL, NULL, "Powhatan"},
	{"pin", NULL, NULL, NULL, "Piame"},
	{"pio", NULL, NULL, NULL, "Piapoco"},
	{"pip", NULL, NULL, NULL, "Pero"},
	{"pir", NULL, NULL, NULL, "Piratapuyo"},
	{"pis", NULL, NULL, NULL, "Pijin"},
	{"pit", NULL, NULL, NULL, "Pitta Pitta"},
	{"piu", NULL, NULL, NULL, "Pintupi-Luritja"},
	{"piv", NULL, NULL, NULL, "Pileni"},
	{"piw", NULL, NULL, NULL, "Pimbwe"},
	{"pix", NULL, NULL, NULL, "Piu"},
	{"piy", NULL, NULL, NULL, "Piya-Kwonci"},
	{"piz", NULL, NULL, NULL, "Pije"},
	{"pjt", NULL, NULL, NULL, "Pitjantjatjara"},
	{"pka", NULL, NULL, NULL, "Ardhamāgadhī Prākrit"},
	{"pkb", NULL, NULL, NULL, "Pokomo"},
	{"pkc", NULL, NULL, NULL, "Paekche"},
	{"pkg", NULL, NULL, NULL, "Pak-Tong"},
	{"pkh", NULL, NULL, NULL, "Pankhu"},
	{"pkn", NULL, NULL, NULL, "Pakanha"},
	{"pko", NULL, NULL, NULL, "Pökoot"},
	{"pkp", NULL, NULL, NULL, "Pukapuka"},
	{"pkr", NULL, NULL, NULL, "Attapady Kurumba"},
	{"pks", NULL, NULL, NULL, "Pakistan Sign Language"},
	{"pkt", NULL, NULL, NULL, "Maleng"},
	{"pku", NULL, NULL, NULL, "Paku"},
	{"pla", NULL, NULL, NULL, "Miani"},
	{"plb", NULL, NULL, NULL, "Polonombauk"},
	{"plc", NULL, NULL, NULL, "Central Palawano"},
	{"pld", NULL, NULL, NULL, "Polari"},
	{"ple", NULL, NULL, NULL, "Palu'e"},
	{"plg", NULL, NULL, NULL, "Pilagá"},
	{"plh", NULL, NULL, NULL, "Paulohi"},
	{"pli", "pli", "pli", "pi", "Pali"},
	{"plj", NULL, NULL, NULL, "Polci"},
	{"plk", NULL, NULL, NULL, "Kohistani Shina"},
	{"pll", NULL, NULL, NULL, "Shwe Palaung"},
	{"pln", NULL, NULL, NULL, "Palenquero"},
	{"plo", NULL, NULL, NULL, "Oluta Popoluca"},
	{"plq", NULL, NULL, NULL, "Palaic"},
	{"plr", NULL, NULL, NULL, "Palaka Senoufo"},
	{"pls", NULL, NULL, NULL, "San Marcos Tlacoyalco Popoloca"},
	{"plt", NULL, NULL, NULL, "Plateau Malagasy"},
	{"plu", NULL, NULL, NULL, "Palikúr"},
	{"plv", NULL, NULL, NULL, "Southwest Palawano"},
	{"plw", NULL, NULL, NULL, "Brooke's Point Palawano"},
	{"ply", NULL, NULL, NULL, "Bolyu"},
	{"plz", NULL, NULL, NULL, "Paluan"},
	{"pma", NULL, NULL, NULL, "Paama"},
	{"pmb", NULL, NULL, NULL, "Pambia"},
	{"pmd", NULL, NULL, NULL, "Pallanganmiddang"},
	{"pme", NULL, NULL, NULL, "Pwaamei"},
	{"pmf", NULL, NULL, NULL, "Pamona"},
	{"pmh", NULL, NULL, NULL, "Māhārāṣṭri Prākrit"},
	{"pmi", NULL, NULL, NULL, "Northern Pumi"},
	{"pmj", NULL, NULL, NULL, "Southern Pumi"},
	{"pmk", NULL, NULL, NULL, "Pamlico"},
	{"pml", NULL, NULL, NULL, "Lingua Franca"},
	{"pmm", NULL, NULL, NULL, "Pomo"},
	{"pmn", NULL, NULL, NULL, "Pam"},
	{"pmo", NULL, NULL, NULL, "Pom"},
	{"pmq", NULL, NULL, NULL, "Northern Pame"},
	{"pmr", NULL, NULL, NULL, "Paynamar"},
	{"pms", NULL, NULL, NULL, "Piemontese"},
	{"pmt", NULL, NULL, NULL, "Tuamotuan"},
	{"pmw", NULL, NULL, NULL, "Plains Miwok"},
	{"pmx", NULL, NULL, NULL, "Poumei Naga"},
	{"pmy", NULL, NULL, NULL, "Papuan Malay"},
	{"pmz", NULL, NULL, NULL, "Southern Pame"},
	{"pna", NULL, NULL, NULL, "Punan Bah-Biau"},
	{"pnb", NULL, NULL, NULL, "Western Panjabi"},
	{"pnc", NULL, NULL, NULL, "Pannei"},
	{"pnd", NULL, NULL, NULL, "Mpinda"},
	{"pne", NULL, NULL, NULL, "Western Penan"},
	{"png", NULL, NULL, NULL, "Pangu"},
	{"pnh", NULL, NULL, NULL, "Penrhyn"},
	{"pni", NULL, NULL, NULL, "Aoheng"},
	{"pnj", NULL, NULL, NULL, "Pinjarup"},
	{"pnk", NULL, NULL, NULL, "Paunaka"},
	{"pnl", NULL, NULL, NULL, "Paleni"},
	{"pnm", NULL, NULL, NULL, "Punan Batu 1"},
	{"pnn", NULL, NULL, NULL, "Pinai-Hagahai"},
	{"pno", NULL, NULL, NULL, "Panobo"},
	{"pnp", NULL, NULL, NULL, "Pancana"},
	{"pnq", NULL, NULL, NULL, "Pana (Burkina Faso)"},
	{"pnr", NULL, NULL, NULL, "Panim"},
	{"pns", NULL, NULL, NULL, "Ponosakan"},
	{"pnt", NULL, NULL, NULL, "Pontic"},
	{"pnu", NULL, NULL, NULL, "Jiongnai Bunu"},
	{"pnv", NULL, NULL, NULL, "Pinigura"},
	{"pnw", NULL, NULL, NULL, "Banyjima"},
	{"pnx", NULL, NULL, NULL, "Phong-Kniang"},
	{"pny", NULL, NULL, NULL, "Pinyin"},
	{"pnz", NULL, NULL, NULL, "Pana (Central African Republic)"},
	{"poc", NULL, NULL, NULL, "Poqomam"},
	{"poe", NULL, NULL, NULL, "San Juan Atzingo Popoloca"},
	{"pof", NULL, NULL, NULL, "Poke"},
	{"pog", NULL, NULL, NULL, "Potiguára"},
	{"poh", NULL, NULL, NULL, "Poqomchi'"},
	{"poi", NULL, NULL, NULL, "Highland Popoluca"},
	{"pok", NULL, NULL, NULL, "Pokangá"},
	{"pol", "pol", "pol", "pl", "Polish"},
	{"pom", NULL, NULL, NULL, "Southeastern Pomo"},
	{"pon", "pon", "pon", NULL, "Pohnpeian"},
	{"poo", NULL, NULL, NULL, "Central Pomo"},
	{"pop", NULL, NULL, NULL, "Pwapwâ"},
	{"poq", NULL, NULL, NULL, "Texistepec Popoluca"},
	{"por", "por", "por", "pt", "Portuguese"},
	{"pos", NULL, NULL, NULL, "Sayula Popoluca"},
	{"pot", NULL, NULL, NULL, "Potawatomi"},
	{"pov", NULL, NULL, NULL, "Upper Guinea Crioulo"},
	{"pow", NULL, NULL, NULL, "San Felipe Otlaltepec Popoloca"},
	{"pox", NULL, NULL, NULL, "Polabian"},
	{"poy", NULL, NULL, NULL, "Pogolo"},
	{"ppe", NULL, NULL, NULL, "Papi"},
	{"ppi", NULL, NULL, NULL, "Paipai"},
	{"ppk", NULL, NULL, NULL, "Uma"},
	{"ppl", NULL, NULL, NULL, "Pipil"},
	{"ppm", NULL, NULL, NULL, "Papuma"},
	{"ppn", NULL, NULL, NULL, "Papapana"},
	{"ppo", NULL, NULL, NULL, "Folopa"},
	{"ppp", NULL, NULL, NULL, "Pelende"},
	{"ppq", NULL, NULL, NULL, "Pei"},
	{"pps", NULL, NULL, NULL, "San Luís Temalacayuca Popoloca"},
	{"ppt", NULL, NULL, NULL, "Pare"},
	{"ppu", NULL, NULL, NULL, "Papora"},
	{"pqa", NULL, NULL, NULL, "Pa'a"},
	{"pqm", NULL, NULL, NULL, "Malecite-Passamaquoddy"},
	{"prc", NULL, NULL, NULL, "Parachi"},
	{"prd", NULL, NULL, NULL, "Parsi-Dari"},
	{"pre", NULL, NULL, NULL, "Principense"},
	{"prf", NULL, NULL, NULL, "Paranan"},
	{"prg", NULL, NULL, NULL, "Prussian"},
	{"prh", NULL, NULL, NULL, "Porohanon"},
	{"pri", NULL, NULL, NULL, "Paicî"},
	{"prk", NULL, NULL, NULL, "Parauk"},
	{"prl", NULL, NULL, NULL, "Peruvian Sign Language"},
	{"prm", NULL, NULL, NULL, "Kibiri"},
	{"prn", NULL, NULL, NULL, "Prasuni"},
	{"pro", "pro", "pro", NULL, "Old Provençal (to 1500)"},
	{"prp", NULL, NULL, NULL, "Parsi"},
	{"prq", NULL, NULL, NULL, "Ashéninka Perené"},
	{"prr", NULL, NULL, NULL, "Puri"},
	{"prs", NULL, NULL, NULL, "Dari"},
	{"prt", NULL, NULL, NULL, "Phai"},
	{"pru", NULL, NULL, NULL, "Puragi"},
	{"prw", NULL, NULL, NULL, "Parawen"},
	{"prx", NULL, NULL, NULL, "Purik"},
	{"prz", NULL, NULL, NULL, "Providencia Sign Language"},
	{"psa", NULL, NULL, NULL, "Asue Awyu"},
	{"psc", NULL, NULL, NULL, "Persian Sign Language"},
	{"psd", NULL, NULL, NULL, "Plains Indian Sign Language"},
	{"pse", NULL, NULL, NULL, "Central Malay"},
	{"psg", NULL, NULL, NULL, "Penang Sign Language"},
	{"psh", NULL, NULL, NULL, "Southwest Pashai"},
	{"psi", NULL, NULL, NULL, "Southeast Pashai"},
	{"psl", NULL, NULL, NULL, "Puerto Rican Sign Language"},
	{"psm", NULL, NULL, NULL, "Pauserna"},
	{"psn", NULL, NULL, NULL, "Panasuan"},
	{"pso", NULL, NULL, NULL, "Polish Sign Language"},
	{"psp", NULL, NULL, NULL, "Philippine Sign Language"},
	{"psq", NULL, NULL, NULL, "Pasi"},
	{"psr", NULL, NULL, NULL, "Portuguese Sign Language"},
	{"pss", NULL, NULL, NULL, "Kaulong"},
	{"pst", NULL, NULL, NULL, "Central Pashto"},
	{"psu", NULL, NULL, NULL, "Sauraseni Prākrit"},
	{"psw", NULL, NULL, NULL, "Port Sandwich"},
	{"psy", NULL, NULL, NULL, "Piscataway"},
	{"pta", NULL, NULL, NULL, "Pai Tavytera"},
	{"pth", NULL, NULL, NULL, "Pataxó Hã-Ha-Hãe"},
	{"pti", NULL, NULL, NULL, "Pindiini"},
	{"ptn", NULL, NULL, NULL, "Patani"},
	{"pto", NULL, NULL, NULL, "Zo'é"},
	{"ptp", NULL, NULL, NULL, "Patep"},
	{"ptq", NULL, NULL, NULL, "Pattapu"},
	{"ptr", NULL, NULL, NULL, "Piamatsina"},
	{"ptt", NULL, NULL, NULL, "Enrekang"},
	{"ptu", NULL, NULL, NULL, "Bambam"},
	{"ptv", NULL, NULL, NULL, "Port Vato"},
	{"ptw", NULL, NULL, NULL, "Pentlatch"},
	{"pty", NULL, NULL, NULL, "Pathiya"},
	{"pua", NULL, NULL, NULL, "Western Highland Purepecha"},
	{"pub", NULL, NULL, NULL, "Purum"},
	{"puc", NULL, NULL, NULL, "Punan Merap"},
	{"pud", NULL, NULL, NULL, "Punan Aput"},
	{"pue", NULL, NULL, NULL, "Puelche"},
	{"puf", NULL, NULL, NULL, "Punan Merah"},
	{"pug", NULL, NULL, NULL, "Phuie"},
	{"pui", NULL, NULL, NULL, "Puinave"},
	{"puj", NULL, NULL, NULL, "Punan Tubu"},
	{"pum", NULL, NULL, NULL, "Puma"},
	{"puo", NULL, NULL, NULL, "Puoc"},
	{"pup", NULL, NULL, NULL, "Pulabu"},
	{"puq", NULL, NULL, NULL, "Puquina"},
	{"pur", NULL, NULL, NULL, "Puruborá"},
	{"pus", "pus", "pus", "ps", "Pushto"},
	{"put", NULL, NULL, NULL, "Putoh"},
	{"puu", NULL, NULL, NULL, "Punu"},
	{"puw", NULL, NULL, NULL, "Puluwatese"},
	{"pux", NULL, NULL, NULL, "Puare"},
	{"puy", NULL, NULL, NULL, "Purisimeño"},
	{"pwa", NULL, NULL, NULL, "Pawaia"},
	{"pwb", NULL, NULL, NULL, "Panawa"},
	{"pwg", NULL, NULL, NULL, "Gapapaiwa"},
	{"pwi", NULL, NULL, NULL, "Patwin"},
	{"pwm", NULL, NULL, NULL, "Molbog"},
	{"pwn", NULL, NULL, NULL, "Paiwan"},
	{"pwo", NULL, NULL, NULL, "Pwo Western Karen"},
	{"pwr", NULL, NULL, NULL, "Powari"},
	{"pww", NULL, NULL, NULL, "Pwo Northern Karen"},
	{"pxm", NULL, NULL, NULL, "Quetzaltepec Mixe"},
	{"pye", NULL, NULL, NULL, "Pye Krumen"},
	{"pym", NULL, NULL, NULL, "Fyam"},
	{"pyn", NULL, NULL, NULL, "Poyanáwa"},
	{"pys", NULL, NULL, NULL, "Paraguayan Sign Language"},
	{"pyu", NULL, NULL, NULL, "Puyuma"},
	{"pyx", NULL, NULL, NULL, "Pyu (Myanmar)"},
	{"pyy", NULL, NULL, NULL, "Pyen"},
	{"pzn", NULL, NULL, NULL, "Para Naga"},
	{"qua", NULL, NULL, NULL, "Quapaw"},
	{"qub", NULL, NULL, NULL, "Huallaga Huánuco Quechua"},
	{"quc", NULL, NULL, NULL, "K'iche'"},
	{"qud", NULL, NULL, NULL, "Calderón Highland Quichua"},
	{"que", "que", "que", "qu", "Quechua"},
	{"quf", NULL, NULL, NULL, "Lambayeque Quechua"},
	{"qug", NULL, NULL, NULL, "Chimborazo Highland Quichua"},
	{"quh", NULL, NULL, NULL, "South Bolivian Quechua"},
	{"qui", NULL, NULL, NULL, "Quileute"},
	{"quk", NULL, NULL, NULL, "Chachapoyas Quechua"},
	{"qul", NULL, NULL, NULL, "North Bolivian Quechua"},
	{"qum", NULL, NULL, NULL, "Sipacapense"},
	{"qun", NULL, NULL, NULL, "Quinault"},
	{"qup", NULL, NULL, NULL, "Southern Pastaza Quechua"},
	{"quq", NULL, NULL, NULL, "Quinqui"},
	{"qur", NULL, NULL, NULL, "Yanahuanca Pasco Quechua"},
	{"qus", NULL, NULL, NULL, "Santiago del Estero Quichua"},
	{"quv", NULL, NULL, NULL, "Sacapulteco"},
	{"quw", NULL, NULL, NULL, "Tena Lowland Quichua"},
	{"qux", NULL, NULL, NULL, "Yauyos Quechua"},
	{"quy", NULL, NULL, NULL, "Ayacucho Quechua"},
	{"quz", NULL, NULL, NULL, "Cusco Quechua"},
	{"qva", NULL, NULL, NULL, "Ambo-Pasco Quechua"},
	{"qvc", NULL, NULL, NULL, "Cajamarca Quechua"},
	{"qve", NULL, NULL, NULL, "Eastern Apurímac Quechua"},
	{"qvh", NULL, NULL, NULL, "Huamalíes-Dos de Mayo Huánuco Quechua"},
	{"qvi", NULL, NULL, NULL, "Imbabura Highland Quichua"},
	{"qvj", NULL, NULL, NULL, "Loja Highland Quichua"},
	{"qvl", NULL, NULL, NULL, "Cajatambo North Lima Quechua"},
	{"qvm", NULL, NULL, NULL, "Margos-Yarowilca-Lauricocha Quechua"},
	{"qvn", NULL, NULL, NULL, "North Junín Quechua"},
	{"qvo", NULL, NULL, NULL, "Napo Lowland Quechua"},
	{"qvp", NULL, NULL, NULL, "Pacaraos Quechua"},
	{"qvs", NULL, NULL, NULL, "San Martín Quechua"},
	{"qvw", NULL, NULL, NULL, "Huaylla Wanca Quechua"},
	{"qvy", NULL, NULL, NULL, "Queyu"},
	{"qvz", NULL, NULL, NULL, "Northern Pastaza Quichua"},
	{"qwa", NULL, NULL, NULL, "Corongo Ancash Quechua"},
	{"qwc", NULL, NULL, NULL, "Classical Quechua"},
	{"qwh", NULL, NULL, NULL, "Huaylas Ancash Quechua"},
	{"qwm", NULL, NULL, NULL, "Kuman (Russia)"},
	{"qws", NULL, NULL, NULL, "Sihuas Ancash Quechua"},
	{"qwt", NULL, NULL, NULL, "Kwalhioqua-Tlatskanai"},
	{"qxa", NULL, NULL, NULL, "Chiquián Ancash Quechua"},
	{"qxc", NULL, NULL, NULL, "Chincha Quechua"},
	{"qxh", NULL, NULL, NULL, "Panao Huánuco Quechua"},
	{"qxl", NULL, NULL, NULL, "Salasaca Highland Quichua"},
	{"qxn", NULL, NULL, NULL, "Northern Conchucos Ancash Quechua"},
	{"qxo", NULL, NULL, NULL, "Southern Conchucos Ancash Quechua"},
	{"qxp", NULL, NULL, NULL, "Puno Quechua"},
	{"qxq", NULL, NULL, NULL, "Qashqa'i"},
	{"qxr", NULL, NULL, NULL, "Cañar Highland Quichua"},
	{"qxs", NULL, NULL, NULL, "Southern Qiang"},
	{"qxt", NULL, NULL, NULL, "Santa Ana de Tusi Pasco Quechua"},
	{"qxu", NULL, NULL, NULL, "Arequipa-La Unión Quechua"},
	{"qxw", NULL, NULL, NULL, "Jauja Wanca Quechua"},
	{"qya", NULL, NULL, NULL, "Quenya"},
	{"qyp", NULL, NULL, NULL, "Quiripi"},
	{"raa", NULL, NULL, NULL, "Dungmali"},
	{"rab", NULL, NULL, NULL, "Camling"},
	{"rac", NULL, NULL, NULL, "Rasawa"},
	{"rad", NULL, NULL, NULL, "Rade"},
	{"raf", NULL, NULL, NULL, "Western Meohang"},
	{"rag", NULL, NULL, NULL, "Logooli"},
	{"rah", NULL, NULL, NULL, "Rabha"},
	{"rai", NULL, NULL, NULL, "Ramoaaina"},
	{"raj", "raj", "raj", NULL, "Rajasthani"},
	{"rak", NULL, NULL, NULL, "Tulu-Bohuai"},
	{"ral", NULL, NULL, NULL, "Ralte"},
	{"ram", NULL, NULL, NULL, "Canela"},
	{"ran", NULL, NULL, NULL, "Riantana"},
	{"rao", NULL, NULL, NULL, "Rao"},
	{"rap", "rap", "rap", NULL, "Rapanui"},
	{"raq", NULL, NULL, NULL, "Saam"},
	{"rar", "rar", "rar", NULL, "Rarotongan"},
	{"ras", NULL, NULL, NULL, "Tegali"},
	{"rat", NULL, NULL, NULL, "Razajerdi"},
	{"rau", NULL, NULL, NULL, "Raute"},
	{"rav", NULL, NULL, NULL, "Sampang"},
	{"raw", NULL, NULL, NULL, "Rawang"},
	{"rax", NULL, NULL, NULL, "Rang"},
	{"ray", NULL, NULL, NULL, "Rapa"},
	{"raz", NULL, NULL, NULL, "Rahambuu"},
	{"rbb", NULL, NULL, NULL, "Rumai Palaung"},
	{"rbk", NULL, NULL, NULL, "Northern Bontok"},
	{"rbl", NULL, NULL, NULL, "Miraya Bikol"},
	{"rbp", NULL, NULL, NULL, "Barababaraba"},
	{"rcf", NULL, NULL, NULL, "Réunion Creole French"},
	{"rdb", NULL, NULL, NULL, "Rudbari"},
	{"rea", NULL, NULL, NULL, "Rerau"},
	{"reb", NULL, NULL, NULL, "Rembong"},
	{"ree", NULL, NULL, NULL, "Rejang Kayan"},
	{"reg", NULL, NULL, NULL, "Kara (Tanzania)"},
	{"rei", NULL, NULL, NULL, "Reli"},
	{"rej", NULL, NULL, NULL, "Rejang"},
	{"rel", NULL, NULL, NULL, "Rendille"},
	{"rem", NULL, NULL, NULL, "Remo"},
	{"ren", NULL, NULL, NULL, "Rengao"},
	{"rer", NULL, NULL, NULL, "Rer Bare"},
	{"res", NULL, NULL, NULL, "Reshe"},
	{"ret", NULL, NULL, NULL, "Retta"},
	{"rey", NULL, NULL, NULL, "Reyesano"},
	{"rga", NULL, NULL, NULL, "Roria"},
	{"rge", NULL, NULL, NULL, "Romano-Greek"},
	{"rgk", NULL, NULL, NULL, "Rangkas"},
	{"rgn", NULL, NULL, NULL, "Romagnol"},
	{"rgr", NULL, NULL, NULL, "Resígaro"},
	{"rgs", NULL, NULL, NULL, "Southern Roglai"},
	{"rgu", NULL, NULL, NULL, "Ringgou"},
	{"rhg", NULL, NULL, NULL, "Rohingya"},
	{"rhp", NULL, NULL, NULL, "Yahang"},
	{"ria", NULL, NULL, NULL, "Riang (India)"},
	{"rif", NULL, NULL, NULL, "Tarifit"},
	{"ril", NULL, NULL, NULL, "Riang Lang"},
	{"rim", NULL, NULL, NULL, "Nyaturu"},
	{"rin", NULL, NULL, NULL, "Nungu"},
	{"rir", NULL, NULL, NULL, "Ribun"},
	{"rit", NULL, NULL, NULL, "Ritharrngu"},
	{"riu", NULL, NULL, NULL, "Riung"},
	{"rjg", NULL, NULL, NULL, "Rajong"},
	{"rji", NULL, NULL, NULL, "Raji"},
	{"rjs", NULL, NULL, NULL, "Rajbanshi"},
	{"rka", NULL, NULL, NULL, "Kraol"},
	{"rkb", NULL, NULL, NULL, "Rikbaktsa"},
	{"rkh", NULL, NULL, NULL, "Rakahanga-Manihiki"},
	{"rki", NULL, NULL, NULL, "Rakhine"},
	{"rkm", NULL, NULL, NULL, "Marka"},
	{"rkt", NULL, NULL, NULL, "Rangpuri"},
	{"rkw", NULL, NULL, NULL, "Arakwal"},
	{"rma", NULL, NULL, NULL, "Rama"},
	{"rmb", NULL, NULL, NULL, "Rembarrnga"},
	{"rmc", NULL, NULL, NULL, "Carpathian Romani"},
	{"rmd", NULL, NULL, NULL, "Traveller Danish"},
	{"rme", NULL, NULL, NULL, "Angloromani"},
	{"rmf", NULL, NULL, NULL, "Kalo Finnish Romani"},
	{"rmg", NULL, NULL, NULL, "Traveller Norwegian"},
	{"rmh", NULL, NULL, NULL, "Murkim"},
	{"rmi", NULL, NULL, NULL, "Lomavren"},
	{"rmk", NULL, NULL, NULL, "Romkun"},
	{"rml", NULL, NULL, NULL, "Baltic Romani"},
	{"rmm", NULL, NULL, NULL, "Roma"},
	{"rmn", NULL, NULL, NULL, "Balkan Romani"},
	{"rmo", NULL, NULL, NULL, "Sinte Romani"},
	{"rmp", NULL, NULL, NULL, "Rempi"},
	{"rmq", NULL, NULL, NULL, "Caló"},
	{"rms", NULL, NULL, NULL, "Romanian Sign Language"},
	{"rmt", NULL, NULL, NULL, "Domari"},
	{"rmu", NULL, NULL, NULL, "Tavringer Romani"},
	{"rmv", NULL, NULL, NULL, "Romanova"},
	{"rmw", NULL, NULL, NULL, "Welsh Romani"},
	{"rmx", NULL, NULL, NULL, "Romam"},
	{"rmy", NULL, NULL, NULL, "Vlax Romani"},
	{"rmz", NULL, NULL, NULL, "Marma"},
	{"rnd", NULL, NULL, NULL, "Ruund"},
	{"rng", NULL, NULL, NULL, "Ronga"},
	{"rnl", NULL, NULL, NULL, "Ranglong"},
	{"rnn", NULL, NULL, NULL, "Roon"},
	{"rnp", NULL, NULL, NULL, "Rongpo"},
	{"rnr", NULL, NULL, NULL, "Nari Nari"},
	{"rnw", NULL, NULL, NULL, "Rungwa"},
	{"rob", NULL, NULL, NULL, "Tae'"},
	{"roc", NULL, NULL, NULL, "Cacgia Roglai"},
	{"rod", NULL, NULL, NULL, "Rogo"},
	{"roe", NULL, NULL, NULL, "Ronji"},
	{"rof", NULL, NULL, NULL, "Rombo"},
	{"rog", NULL, NULL, NULL, "Northern Roglai"},
	{"roh", "roh", "roh", "rm", "Romansh"},
	{"rol", NULL, NULL, NULL, "Romblomanon"},
	{"rom", "rom", "rom", NULL, "Romany"},
	{"ron", "rum", "ron", "ro", "Romanian"},
	{"roo", NULL, NULL, NULL, "Rotokas"},
	{"rop", NULL, NULL, NULL, "Kriol"},
	{"ror", NULL, NULL, NULL, "Rongga"},
	{"rou", NULL, NULL, NULL, "Runga"},
	{"row", NULL, NULL, NULL, "Dela-Oenale"},
	{"rpn", NULL, NULL, NULL, "Repanbitip"},
	{"rpt", NULL, NULL, NULL, "Rapting"},
	{"rri", NULL, NULL, NULL, "Ririo"},
	{"rro", NULL, NULL, NULL, "Waima"},
	{"rrt", NULL, NULL, NULL, "Arritinngithigh"},
	{"rsb", NULL, NULL, NULL, "Romano-Serbian"},
	{"rsl", NULL, NULL, NULL, "Russian Sign Language"},
	{"rsm", NULL, NULL, NULL, "Miriwoong Sign Language"},
	{"rtc", NULL, NULL, NULL, "Rungtu Chin"},
	{"rth", NULL, NULL, NULL, "Ratahan"},
	{"rtm", NULL, NULL, NULL, "Rotuman"},
	{"rts", NULL, NULL, NULL, "Yurats"},
	{"rtw", NULL, NULL, NULL, "Rathawi"},
	{"rub", NULL, NULL, NULL, "Gungu"},
	{"ruc", NULL, NULL, NULL, "Ruuli"},
	{"rue", NULL, NULL, NULL, "Rusyn"},
	{"ruf", NULL, NULL, NULL, "Luguru"},
	{"rug", NULL, NULL, NULL, "Roviana"},
	{"ruh", NULL, NULL, NULL, "Ruga"},
	{"rui", NULL, NULL, NULL, "Rufiji"},
	{"ruk", NULL, NULL, NULL, "Che"},
	{"run", "run", "run", "rn", "Rundi"},
	{"ruo", NULL, NULL, NULL, "Istro Romanian"},
	{"rup", "rup", "rup", NULL, "Macedo-Romanian"},
	{"ruq", NULL, NULL, NULL, "Megleno Romanian"},
	{"rus", "rus", "rus", "ru", "Russian"},
	{"rut", NULL, NULL, NULL, "Rutul"},
	{"ruu", NULL, NULL, NULL, "Lanas Lobu"},
	{"ruy", NULL, NULL, NULL, "Mala (Nigeria)"},
	{"ruz", NULL, NULL, NULL, "Ruma"},
	{"rwa", NULL, NULL, NULL, "Rawo"},
	{"rwk", NULL, NULL, NULL, "Rwa"},
	{"rwl", NULL, NULL, NULL, "Ruwila"},
	{"rwm", NULL, NULL, NULL, "Amba (Uganda)"},
	{"rwo", NULL, NULL, NULL, "Rawa"},
	{"rwr", NULL, NULL, NULL, "Marwari (India)"},
	{"rxd", NULL, NULL, NULL, "Ngardi"},
	{"rxw", NULL, NULL, NULL, "Karuwali"},
	{"ryn", NULL, NULL, NULL, "Northern Amami-Oshima"},
	{"rys", NULL, NULL, NULL, "Yaeyama"},
	{"ryu", NULL, NULL, NULL, "Central Okinawan"},
	{"rzh", NULL, NULL, NULL, "Rāziḥī"},
	{"saa", NULL, NULL, NULL, "Saba"},
	{"sab", NULL, NULL, NULL, "Buglere"},
	{"sac", NULL, NULL, NULL, "Meskwaki"},
	{"sad", "sad", "sad", NULL, "Sandawe"},
	{"sae", NULL, NULL, NULL, "Sabanê"},
	{"saf", NULL, NULL, NULL, "Safaliba"},
	{"sag", "sag", "sag", "sg", "Sango"},
	{"sah", "sah", "sah", NULL, "Yakut"},
	{"saj", NULL, NULL, NULL, "Sahu"},
	{"sak", NULL, NULL, NULL, "Sake"},
	{"sam", "sam", "sam", NULL, "Samaritan Aramaic"},
	{"san", "san", "san", "sa", "Sanskrit"},
	{"sao", NULL, NULL, NULL, "Sause"},
	{"saq", NULL, NULL, NULL, "Samburu"},
	{"sar", NULL, NULL, NULL, "Saraveca"},
	{"sas", "sas", "sas", NULL, "Sasak"},
	{"sat", "sat", "sat", NULL, "Santali"},
	{"sau", NULL, NULL, NULL, "Saleman"},
	{"sav", NULL, NULL, NULL, "Saafi-Saafi"},
	{"saw", NULL, NULL, NULL, "Sawi"},
	{"sax", NULL, NULL, NULL, "Sa"},
	{"say", NULL, NULL, NULL, "Saya"},
	{"saz", NULL, NULL, NULL, "Saurashtra"},
	{"sba", NULL, NULL, NULL, "Ngambay"},
	{"sbb", NULL, NULL, NULL, "Simbo"},
	{"sbc", NULL, NULL, NULL, "Kele (Papua New Guinea)"},
	{"sbd", NULL, NULL, NULL, "Southern Samo"},
	{"sbe", NULL, NULL, NULL, "Saliba"},
	{"sbf", NULL, NULL, NULL, "Chabu"},
	{"sbg", NULL, NULL, NULL, "Seget"},
	{"sbh", NULL, NULL, NULL, "Sori-Harengan"},
	{"sbi", NULL, NULL, NULL, "Seti"},
	{"sbj", NULL, NULL, NULL, "Surbakhal"},
	{"sbk", NULL, NULL, NULL, "Safwa"},
	{"sbl", NULL, NULL, NULL, "Botolan Sambal"},
	{"sbm", NULL, NULL, NULL, "Sagala"},
	{"sbn", NULL, NULL, NULL, "Sindhi Bhil"},
	{"sbo", NULL, NULL, NULL, "Sabüm"},
	{"sbp", NULL, NULL, NULL, "Sangu (Tanzania)"},
	{"sbq", NULL, NULL, NULL, "Sileibi"},
	{"sbr", NULL, NULL, NULL, "Sembakung Murut"},
	{"sbs", NULL, NULL, NULL, "Subiya"},
	{"sbt", NULL, NULL, NULL, "Kimki"},
	{"sbu", NULL, NULL, NULL, "Stod Bhoti"},
	{"sbv", NULL, NULL, NULL, "Sabine"},
	{"sbw", NULL, NULL, NULL, "Simba"},
	{"sbx", NULL, NULL, NULL, "Seberuang"},
	{"sby", NULL, NULL, NULL, "Soli"},
	{"sbz", NULL, NULL, NULL, "Sara Kaba"},
	{"scb", NULL, NULL, NULL, "Chut"},
	{"sce", NULL, NULL, NULL, "Dongxiang"},
	{"scf", NULL, NULL, NULL, "San Miguel Creole French"},
	{"scg", NULL, NULL, NULL, "Sanggau"},
	{"sch", NULL, NULL, NULL, "Sakachep"},
	{"sci", NULL, NULL, NULL, "Sri Lankan Creole Malay"},
	{"sck", NULL, NULL, NULL, "Sadri"},
	{"scl", NULL, NULL, NULL, "Shina"},
	{"scn", "scn", "scn", NULL, "Sicilian"},
	{"sco", "sco", "sco", NULL, "Scots"},
	{"scp", NULL, NULL, NULL, "Hyolmo"},
	{"scq", NULL, NULL, NULL, "Sa'och"},
	{"scs", NULL, NULL, NULL, "North Slavey"},
	{"sct", NULL, NULL, NULL, "Southern Katang"},
	{"scu", NULL, NULL, NULL, "Shumcho"},
	{"scv", NULL, NULL, NULL, "Sheni"},
	{"scw", NULL, NULL, NULL, "Sha"},
	{"scx", NULL, NULL, NULL, "Sicel"},
	{"sda", NULL, NULL, NULL, "Toraja-Sa'dan"},
	{"sdb", NULL, NULL, NULL, "Shabak"},
	{"sdc", NULL, NULL, NULL, "Sassarese Sardinian"},
	{"sde", NULL, NULL, NULL, "Surubu"},
	{"sdf", NULL, NULL, NULL, "Sarli"},
	{"sdg", NULL, NULL, NULL, "Savi"},
	{"sdh", NULL, NULL, NULL, "Southern Kurdish"},
	{"sdj", NULL, NULL, NULL, "Suundi"},
	{"sdk", NULL, NULL, NULL, "Sos Kundi"},
	{"sdl", NULL, NULL, NULL, "Saudi Arabian Sign Language"},
	{"sdn", NULL, NULL, NULL, "Gallurese Sardinian"},
	{"sdo", NULL, NULL, NULL, "Bukar-Sadung Bidayuh"},
	{"sdp", NULL, NULL, NULL, "Sherdukpen"},
	{"sdq", NULL, NULL, NULL, "Semandang"},
	{"sdr", NULL, NULL, NULL, "Oraon Sadri"},
	{"sds", NULL, NULL, NULL, "Sened"},
	{"sdt", NULL, NULL, NULL, "Shuadit"},
	{"sdu", NULL, NULL, NULL, "Sarudu"},
	{"sdx", NULL, NULL, NULL, "Sibu Melanau"},
	{"sdz", NULL, NULL, NULL, "Sallands"},
	{"sea", NULL, NULL, NULL, "Semai"},
	{"seb", NULL, NULL, NULL, "Shempire Senoufo"},
	{"sec", NULL, NULL, NULL, "Sechelt"},
	{"sed", NULL, NULL, NULL, "Sedang"},
	{"see", NULL, NULL, NULL, "Seneca"},
	{"sef", NULL, NULL, NULL, "Cebaara Senoufo"},
	{"seg", NULL, NULL, NULL, "Segeju"},
	{"seh", NULL, NULL, NULL, "Sena"},
	{"sei", NULL, NULL, NULL, "Seri"},
	{"sej", NULL, NULL, NULL, "Sene"},
	{"sek", NULL, NULL, NULL, "Sekani"},
	{"sel", "sel", "sel", NULL, "Selkup"},
	{"sen", NULL, NULL, NULL, "Nanerigé Sénoufo"},
	{"seo", NULL, NULL, NULL, "Suarmin"},
	{"sep", NULL, NULL, NULL, "Sìcìté Sénoufo"},
	{"seq", NULL, NULL, NULL, "Senara Sénoufo"},
	{"ser", NULL, NULL, NULL, "Serrano"},
	{"ses", NULL, NULL, NULL, "Koyraboro Senni Songhai"},
	{"set", NULL, NULL, NULL, "Sentani"},
	{"seu", NULL, NULL, NULL, "Serui-Laut"},
	{"sev", NULL, NULL, NULL, "Nyarafolo Senoufo"},
	{"sew", NULL, NULL, NULL, "Sewa Bay"},
	{"sey", NULL, NULL, NULL, "Secoya"},
	{"sez", NULL, NULL, NULL, "Senthang Chin"},
	{"sfb", NULL, NULL, NULL, "Langue des signes de Belgique Francophone"},
	{"sfe", NULL, NULL, NULL, "Eastern Subanen"},
	{"sfm", NULL, NULL, NULL, "Small Flowery Miao"},
	{"sfs", NULL, NULL, NULL, "South African Sign Language"},
	{"sfw", NULL, NULL, NULL, "Sehwi"},
	{"sga", "sga", "sga", NULL, "Old Irish (to 900)"},
	{"sgb", NULL, NULL, NULL, "Mag-antsi Ayta"},
	{"sgc", NULL, NULL, NULL, "Kipsigis"},
	{"sgd", NULL, NULL, NULL, "Surigaonon"},
	{"sge", NULL, NULL, NULL, "Segai"},
	{"sgg", NULL, NULL, NULL, "Swiss-German Sign Language"},
	{"sgh", NULL, NULL, NULL, "Shughni"},
	{"sgi", NULL, NULL, NULL, "Suga"},
	{"sgj", NULL, NULL, NULL, "Surgujia"},
	{"sgk", NULL, NULL, NULL, "Sangkong"},
	{"sgm", NULL, NULL, NULL, "Singa"},
	{"sgp", NULL, NULL, NULL, "Singpho"},
	{"sgr", NULL, NULL, NULL, "Sangisari"},
	{"sgs", NULL, NULL, NULL, "Samogitian"},
	{"sgt", NULL, NULL, NULL, "Brokpake"},
	{"sgu", NULL, NULL, NULL, "Salas"},
	{"sgw", NULL, NULL, NULL, "Sebat Bet Gurage"},
	{"sgx", NULL, NULL, NULL, "Sierra Leone Sign Language"},
	{"sgy", NULL, NULL, NULL, "Sanglechi"},
	{"sgz", NULL, NULL, NULL, "Sursurunga"},
	{"sha", NULL, NULL, NULL, "Shall-Zwall"},
	{"shb", NULL, NULL, NULL, "Ninam"},
	{"shc", NULL, NULL, NULL, "Sonde"},
	{"shd", NULL, NULL, NULL, "Kundal Shahi"},
	{"she", NULL, NULL, NULL, "Sheko"},
	{"shg", NULL, NULL, NULL, "Shua"},
	{"shh", NULL, NULL, NULL, "Shoshoni"},
	{"shi", NULL, NULL, NULL, "Tachelhit"},
	{"shj", NULL, NULL, NULL, "Shatt"},
	{"shk", NULL, NULL, NULL, "Shilluk"},
	{"shl", NULL, NULL, NULL, "Shendu"},
	{"shm", NULL, NULL, NULL, "Shahrudi"},
	{"shn", "shn", "shn", NULL, "Shan"},
	{"sho", NULL, NULL, NULL, "Shanga"},
	{"shp", NULL, NULL, NULL, "Shipibo-Conibo"},
	{"shq", NULL, NULL, NULL, "Sala"},
	{"shr", NULL, NULL, NULL, "Shi"},
	{"shs", NULL, NULL, NULL, "Shuswap"},
	{"sht", NULL, NULL, NULL, "Shasta"},
	{"shu", NULL, NULL, NULL, "Chadian Arabic"},
	{"shv", NULL, NULL, NULL, "Shehri"},
	{"shw", NULL, NULL, NULL, "Shwai"},
	{"shx", NULL, NULL, NULL, "She"},
	{"shy", NULL, NULL, NULL, "Tachawit"},
	{"shz", NULL, NULL, NULL, "Syenara Senoufo"},
	{"sia", NULL, NULL, NULL, "Akkala Sami"},
	{"sib", NULL, NULL, NULL, "Sebop"},
	{"sid", "sid", "sid", NULL, "Sidamo"},
	{"sie", NULL, NULL, NULL, "Simaa"},
	{"sif", NULL, NULL, NULL, "Siamou"},
	{"sig", NULL, NULL, NULL, "Paasaal"},
	{"sih", NULL, NULL, NULL, "Zire"},
	{"sii", NULL, NULL, NULL, "Shom Peng"},
	{"sij", NULL, NULL, NULL, "Numbami"},
	{"sik", NULL, NULL, NULL, "Sikiana"},
	{"sil", NULL, NULL, NULL, "Tumulung Sisaala"},
	{"sim", NULL, NULL, NULL, "Mende (Papua New Guinea)"},
	{"sin", "sin", "sin", "si", "Sinhala"},
	{"sip", NULL, NULL, NULL, "Sikkimese"},
	{"siq", NULL, NULL, NULL, "Sonia"},
	{"sir", NULL, NULL, NULL, "Siri"},
	{"sis", NULL, NULL, NULL, "Siuslaw"},
	{"siu", NULL, NULL, NULL, "Sinagen"},
	{"siv", NULL, NULL, NULL, "Sumariup"},
	{"siw", NULL, NULL, NULL, "Siwai"},
	{"six", NULL, NULL, NULL, "Sumau"},
	{"siy", NULL, NULL, NULL, "Sivandi"},
	{"siz", NULL, NULL, NULL, "Siwi"},
	{"sja", NULL, NULL, NULL, "Epena"},
	{"sjb", NULL, NULL, NULL, "Sajau Basap"},
	{"sjd", NULL, NULL, NULL, "Kildin Sami"},
	{"sje", NULL, NULL, NULL, "Pite Sami"},
	{"sjg", NULL, NULL, NULL, "Assangori"},
	{"sjk", NULL, NULL, NULL, "Kemi Sami"},
	{"sjl", NULL, NULL, NULL, "Sajalong"},
	{"sjm", NULL, NULL, NULL, "Mapun"},
	{"sjn", NULL, NULL, NULL, "Sindarin"},
	{"sjo", NULL, NULL, NULL, "Xibe"},
	{"sjp", NULL, NULL, NULL, "Surjapuri"},
	{"sjr", NULL, NULL, NULL, "Siar-Lak"},
	{"sjs", NULL, NULL, NULL, "Senhaja De Srair"},
	{"sjt", NULL, NULL, NULL, "Ter Sami"},
	{"sju", NULL, NULL, NULL, "Ume Sami"},
	{"sjw", NULL, NULL, NULL, "Shawnee"},
	{"ska", NULL, NULL, NULL, "Skagit"},
	{"skb", NULL, NULL, NULL, "Saek"},
	{"skc", NULL, NULL, NULL, "Ma Manda"},
	{"skd", NULL, NULL, NULL, "Southern Sierra Miwok"},
	{"ske", NULL, NULL, NULL, "Seke (Vanuatu)"},
	{"skf", NULL, NULL, NULL, "Sakirabiá"},
	{"skg", NULL, NULL, NULL, "Sakalava Malagasy"},
	{"skh", NULL, NULL, NULL, "Sikule"},
	{"ski", NULL, NULL, NULL, "Sika"},
	{"skj", NULL, NULL, NULL, "Seke (Nepal)"},
	{"skm", NULL, NULL, NULL, "Kutong"},
	{"skn", NULL, NULL, NULL, "Kolibugan Subanon"},
	{"sko", NULL, NULL, NULL, "Seko Tengah"},
	{"skp", NULL, NULL, NULL, "Sekapan"},
	{"skq", NULL, NULL, NULL, "Sininkere"},
	{"skr", NULL, NULL, NULL, "Saraiki"},
	{"sks", NULL, NULL, NULL, "Maia"},
	{"skt", NULL, NULL, NULL, "Sakata"},
	{"sku", NULL, NULL, NULL, "Sakao"},
	{"skv", NULL, NULL, NULL, "Skou"},
	{"skw", NULL, NULL, NULL, "Skepi Creole Dutch"},
	{"skx", NULL, NULL, NULL, "Seko Padang"},
	{"sky", NULL, NULL, NULL, "Sikaiana"},
	{"skz", NULL, NULL, NULL, "Sekar"},
	{"slc", NULL, NULL, NULL, "Sáliba"},
	{"sld", NULL, NULL, NULL, "Sissala"},
	{"sle", NULL, NULL, NULL, "Sholaga"},
	{"slf", NULL, NULL, NULL, "Swiss-Italian Sign Language"},
	{"slg", NULL, NULL, NULL, "Selungai Murut"},
	{"slh", NULL, NULL, NULL, "Southern Puget Sound Salish"},
	{"sli", NULL, NULL, NULL, "Lower Silesian"},
	{"slj", NULL, NULL, NULL, "Salumá"},
	{"slk", "slo", "slk", "sk", "Slovak"},
	{"sll", NULL, NULL, NULL, "Salt-Yui"},
	{"slm", NULL, NULL, NULL, "Pangutaran Sama"},
	{"sln", NULL, NULL, NULL, "Salinan"},
	{"slp", NULL, NULL, NULL, "Lamaholot"},
	{"slq", NULL, NULL, NULL, "Salchuq"},
	{"slr", NULL, NULL, NULL, "Salar"},
	{"sls", NULL, NULL, NULL, "Singapore Sign Language"},
	{"slt", NULL, NULL, NULL, "Sila"},
	{"slu", NULL, NULL, NULL, "Selaru"},
	{"slv", "slv", "slv", "sl", "Slovenian"},
	{"slw", NULL, NULL, NULL, "Sialum"},
	{"slx", NULL, NULL, NULL, "Salampasu"},
	{"sly", NULL, NULL, NULL, "Selayar"},
	{"slz", NULL, NULL, NULL, "Ma'ya"},
	{"sma", "sma", "sma", NULL, "Southern Sami"},
	{"smb", NULL, NULL, NULL, "Simbari"},
	{"smc", NULL, NULL, NULL, "Som"},
	{"smd", NULL, NULL, NULL, "Sama"},
	{"sme", "sme", "sme", "se", "Northern Sami"},
	{"smf", NULL, NULL, NULL, "Auwe"},
	{"smg", NULL, NULL, NULL, "Simbali"},
	{"smh", NULL, NULL, NULL, "Samei"},
	{"smj", "smj", "smj", NULL, "Lule Sami"},
	{"smk", NULL, NULL, NULL, "Bolinao"},
	{"sml", NULL, NULL, NULL, "Central Sama"},
	{"smm", NULL, NULL, NULL, "Musasa"},
	{"smn", "smn", "smn", NULL, "Inari Sami"},
	{"smo", "smo", "smo", "sm", "Samoan"},
	{"smp", NULL, NULL, NULL, "Samaritan"},
	{"smq", NULL, NULL, NULL, "Samo"},
	{"smr", NULL, NULL, NULL, "Simeulue"},
	{"sms", "sms", "sms", NULL, "Skolt Sami"},
	{"smt", NULL, NULL, NULL, "Simte"},
	{"smu", NULL, NULL, NULL, "Somray"},
	{"smv", NULL, NULL, NULL, "Samvedi"},
	{"smw", NULL, NULL, NULL, "Sumbawa"},
	{"smx", NULL, NULL, NULL, "Samba"},
	{"smy", NULL, NULL, NULL, "Semnani"},
	{"smz", NULL, NULL, NULL, "Simeku"},
	{"sna", "sna", "sna", "sn", "Shona"},
	{"snb", NULL, NULL, NULL, "Sebuyau"},
	{"snc", NULL, NULL, NULL, "Sinaugoro"},
	{"snd", "snd", "snd", "sd", "Sindhi"},
	{"sne", NULL, NULL, NULL, "Bau Bidayuh"},
	{"snf", NULL, NULL, NULL, "Noon"},
	{"sng", NULL, NULL, NULL, "Sanga (Democratic Republic of Congo)"},
	{"sni", NULL, NULL, NULL, "Sensi"},
	{"snj", NULL, NULL, NULL, "Riverain Sango"},
	{"snk", "snk", "snk", NULL, "Soninke"},
	{"snl", NULL, NULL, NULL, "Sangil"},
	{"snm", NULL, NULL, NULL, "Southern Ma'di"},
	{"snn", NULL, NULL, NULL, "Siona"},
	{"sno", NULL, NULL, NULL, "Snohomish"},
	{"snp", NULL, NULL, NULL, "Siane"},
	{"snq", NULL, NULL, NULL, "Sangu (Gabon)"},
	{"snr", NULL, NULL, NULL, "Sihan"},
	{"sns", NULL, NULL, NULL, "South West Bay"},
	{"snu", NULL, NULL, NULL, "Senggi"},
	{"snv", NULL, NULL, NULL, "Sa'ban"},
	{"snw", NULL, NULL, NULL, "Selee"},
	{"snx", NULL, NULL, NULL, "Sam"},
	{"sny", NULL, NULL, NULL, "Saniyo-Hiyewe"},
	{"snz", NULL, NULL, NULL, "Kou"},
	{"soa", NULL, NULL, NULL, "Thai Song"},
	{"sob", NULL, NULL, NULL, "Sobei"},
	{"soc", NULL, NULL, NULL, "So (Democratic Republic of Congo)"},
	{"sod", NULL, NULL, NULL, "Songoora"},
	{"soe", NULL, NULL, NULL, "Songomeno"},
	{"sog", "sog", "sog", NULL, "Sogdian"},
	{"soh", NULL, NULL, NULL, "Aka"},
	{"soi", NULL, NULL, NULL, "Sonha"},
	{"soj", NULL, NULL, NULL, "Soi"},
	{"sok", NULL, NULL, NULL, "Sokoro"},
	{"sol", NULL, NULL, NULL, "Solos"},
	{"som", "som", "som", "so", "Somali"},
	{"soo", NULL, NULL, NULL, "Songo"},
	{"sop", NULL, NULL, NULL, "Songe"},
	{"soq", NULL, NULL, NULL, "Kanasi"},
	{"sor", NULL, NULL, NULL, "Somrai"},
	{"sos", NULL, NULL, NULL, "Seeku"},
	{"sot", "sot", "sot", "st", "Southern Sotho"},
	{"sou", NULL, NULL, NULL, "Southern Thai"},
	{"sov", NULL, NULL, NULL, "Sonsorol"},
	{"sow", NULL, NULL, NULL, "Sowanda"},
	{"sox", NULL, NULL, NULL, "Swo"},
	{"soy", NULL, NULL, NULL, "Miyobe"},
	{"soz", NULL, NULL, NULL, "Temi"},
	{"spa", "spa", "spa", "es", "Spanish"},
	{"spb", NULL, NULL, NULL, "Sepa (Indonesia)"},
	{"spc", NULL, NULL, NULL, "Sapé"},
	{"spd", NULL, NULL, NULL, "Saep"},
	{"spe", NULL, NULL, NULL, "Sepa (Papua New Guinea)"},
	{"spg", NULL, NULL, NULL, "Sian"},
	{"spi", NULL, NULL, NULL, "Saponi"},
	{"spk", NULL, NULL, NULL, "Sengo"},
	{"spl", NULL, NULL, NULL, "Selepet"},
	{"spm", NULL, NULL, NULL, "Akukem"},
	{"spn", NULL, NULL, NULL, "Sanapaná"},
	{"spo", NULL, NULL, NULL, "Spokane"},
	{"spp", NULL, NULL, NULL, "Supyire Senoufo"},
	{"spq", NULL, NULL, NULL, "Loreto-Ucayali Spanish"},
	{"spr", NULL, NULL, NULL, "Saparua"},
	{"sps", NULL, NULL, NULL, "Saposa"},
	{"spt", NULL, NULL, NULL, "Spiti Bhoti"},
	{"spu", NULL, NULL, NULL, "Sapuan"},
	{"spv", NULL, NULL, NULL, "Sambalpuri"},
	{"spx", NULL, NULL, NULL, "South Picene"},
	{"spy", NULL, NULL, NULL, "Sabaot"},
	{"sqa", NULL, NULL, NULL, "Shama-Sambuga"},
	{"sqh", NULL, NULL, NULL, "Shau"},
	{"sqi", "alb", "sqi", "sq", "Albanian"},
	{"sqk", NULL, NULL, NULL, "Albanian Sign Language"},
	{"sqm", NULL, NULL, NULL, "Suma"},
	{"sqn", NULL, NULL, NULL, "Susquehannock"},
	{"sqo", NULL, NULL, NULL, "Sorkhei"},
	{"sqq", NULL, NULL, NULL, "Sou"},
	{"sqr", NULL, NULL, NULL, "Siculo Arabic"},
	{"sqs", NULL, NULL, NULL, "Sri Lankan Sign Language"},
	{"sqt", NULL, NULL, NULL, "Soqotri"},
	{"squ", NULL, NULL, NULL, "Squamish"},
	{"sqx", NULL, NULL, NULL, "Kufr Qassem Sign Language (KQSL)"},
	{"sra", NULL, NULL, NULL, "Saruga"},
	{"srb", NULL, NULL, NULL, "Sora"},
	{"src", NULL, NULL, NULL, "Logudorese Sardinian"},
	{"srd", "srd", "srd", "sc", "Sardinian"},
	{"sre", NULL, NULL, NULL, "Sara"},
	{"srf", NULL, NULL, NULL, "Nafi"},
	{"srg", NULL, NULL, NULL, "Sulod"},
	{"srh", NULL, NULL, NULL, "Sarikoli"},
	{"sri", NULL, NULL, NULL, "Siriano"},
	{"srk", NULL, NULL, NULL, "Serudung Murut"},
	{"srl", NULL, NULL, NULL, "Isirawa"},
	{"srm", NULL, NULL, NULL, "Saramaccan"},
	{"srn", "srn", "srn", NULL, "Sranan Tongo"},
	{"sro", NULL, NULL, NULL, "Campidanese Sardinian"},
	{"srp", "srp", "srp", "sr", "Serbian"},
	{"srq", NULL, NULL, NULL, "Sirionó"},
	{"srr", "srr", "srr", NULL, "Serer"},
	{"srs", NULL, NULL, NULL, "Sarsi"},
	{"srt", NULL, NULL, NULL, "Sauri"},
	{"sru", NULL, NULL, NULL, "Suruí"},
	{"srv", NULL, NULL, NULL, "Southern Sorsoganon"},
	{"srw", NULL, NULL, NULL, "Serua"},
	{"srx", NULL, NULL, NULL, "Sirmauri"},
	{"sry", NULL, NULL, NULL, "Sera"},
	{"srz", NULL, NULL, NULL, "Shahmirzadi"},
	{"ssb", NULL, NULL, NULL, "Southern Sama"},
	{"ssc", NULL, NULL, NULL, "Suba-Simbiti"},
	{"ssd", NULL, NULL, NULL, "Siroi"},
	{"sse", NULL, NULL, NULL, "Balangingi"},
	{"ssf", NULL, NULL, NULL, "Thao"},
	{"ssg", NULL, NULL, NULL, "Seimat"},
	{"ssh", NULL, NULL, NULL, "Shihhi Arabic"},
	{"ssi", NULL, NULL, NULL, "Sansi"},
	{"ssj", NULL, NULL, NULL, "Sausi"},
	{"ssk", NULL, NULL, NULL, "Sunam"},
	{"ssl", NULL, NULL, NULL, "Western Sisaala"},
	{"ssm", NULL, NULL, NULL, "Semnam"},
	{"ssn", NULL, NULL, NULL, "Waata"},
	{"sso", NULL, NULL, NULL, "Sissano"},
	{"ssp", NULL, NULL, NULL, "Spanish Sign Language"},
	{"ssq", NULL, NULL, NULL, "So'a"},
	{"ssr", NULL, NULL, NULL, "Swiss-French Sign Language"},
	{"sss", NULL, NULL, NULL, "Sô"},
	{"sst", NULL, NULL, NULL, "Sinasina"},
	{"ssu", NULL, NULL, NULL, "Susuami"},
	{"ssv", NULL, NULL, NULL, "Shark Bay"},
	{"ssw", "ssw", "ssw", "ss", "Swati"},
	{"ssx", NULL, NULL, NULL, "Samberigi"},
	{"ssy", NULL, NULL, NULL, "Saho"},
	{"ssz", NULL, NULL, NULL, "Sengseng"},
	{"sta", NULL, NULL, NULL, "Settla"},
	{"stb", NULL, NULL, NULL, "Northern Subanen"},
	{"std", NULL, NULL, NULL, "Sentinel"},
	{"ste", NULL, NULL, NULL, "Liana-Seti"},
	{"stf", NULL, NULL, NULL, "Seta"},
	{"stg", NULL, NULL, NULL, "Trieng"},
	{"sth", NULL, NULL, NULL, "Shelta"},
	{"sti", NULL, NULL, NULL, "Bulo Stieng"},
	{"stj", NULL, NULL, NULL, "Matya Samo"},
	{"stk", NULL, NULL, NULL, "Arammba"},
	{"stl", NULL, NULL, NULL, "Stellingwerfs"},
	{"stm", NULL, NULL, NULL, "Setaman"},
	{"stn", NULL, NULL, NULL, "Owa"},
	{"sto", NULL, NULL, NULL, "Stoney"},
	{"stp", NULL, NULL, NULL, "Southeastern Tepehuan"},
	{"stq", NULL, NULL, NULL, "Saterfriesisch"},
	{"str", NULL, NULL, NULL, "Straits Salish"},
	{"sts", NULL, NULL, NULL, "Shumashti"},
	{"stt", NULL, NULL, NULL, "Budeh Stieng"},
	{"stu", NULL, NULL, NULL, "Samtao"},
	{"stv", NULL, NULL, NULL, "Silt'e"},
	{"stw", NULL, NULL, NULL, "Satawalese"},
	{"sty", NULL, NULL, NULL, "Siberian Tatar"},
	{"sua", NULL, NULL, NULL, "Sulka"},
	{"sub", NULL, NULL, NULL, "Suku"},
	{"suc", NULL, NULL, NULL, "Western Subanon"},
	{"sue", NULL, NULL, NULL, "Suena"},
	{"sug", NULL, NULL, NULL, "Suganga"},
	{"sui", NULL, NULL, NULL, "Suki"},
	{"suj", NULL, NULL, NULL, "Shubi"},
	{"suk", "suk", "suk", NULL, "Sukuma"},
	{"sun", "sun", "sun", "su", "Sundanese"},
	{"suo", NULL, NULL, NULL, "Bouni"},
	{"suq", NULL, NULL, NULL, "Tirmaga-Chai Suri"},
	{"sur", NULL, NULL, NULL, "Mwaghavul"},
	{"sus", "sus", "sus", NULL, "Susu"},
	{"sut", NULL, NULL, NULL, "Subtiaba"},
	{"suv", NULL, NULL, NULL, "Puroik"},
	{"suw", NULL, NULL, NULL, "Sumbwa"},
	{"sux", "sux", "sux", NULL, "Sumerian"},
	{"suy", NULL, NULL, NULL, "Suyá"},
	{"suz", NULL, NULL, NULL, "Sunwar"},
	{"sva", NULL, NULL, NULL, "Svan"},
	{"svb", NULL, NULL, NULL, "Ulau-Suain"},
	{"svc", NULL, NULL, NULL, "Vincentian Creole English"},
	{"sve", NULL, NULL, NULL, "Serili"},
	{"svk", NULL, NULL, NULL, "Slovakian Sign Language"},
	{"svm", NULL, NULL, NULL, "Slavomolisano"},
	{"svs", NULL, NULL, NULL, "Savosavo"},
	{"svx", NULL, NULL, NULL, "Skalvian"},
	{"swa", "swa", "swa", "sw", "Swahili (macrolanguage)"},
	{"swb", NULL, NULL, NULL, "Maore Comorian"},
	{"swc", NULL, NULL, NULL, "Congo Swahili"},
	{"swe", "swe", "swe", "sv", "Swedish"},
	{"swf", NULL, NULL, NULL, "Sere"},
	{"swg", NULL, NULL, NULL, "Swabian"},
	{"swh", NULL, NULL, NULL, "Swahili (individual language)"},
	{"swi", NULL, NULL, NULL, "Sui"},
	{"swj", NULL, NULL, NULL, "Sira"},
	{"swk", NULL, NULL, NULL, "Malawi Sena"},
	{"swl", NULL, NULL, NULL, "Swedish Sign Language"},
	{"swm", NULL, NULL, NULL, "Samosa"},
	{"swn", NULL, NULL, NULL, "Sawknah"},
	{"swo", NULL, NULL, NULL, "Shanenawa"},
	{"swp", NULL, NULL, NULL, "Suau"},
	{"swq", NULL, NULL, NULL, "Sharwa"},
	{"swr", NULL, NULL, NULL, "Saweru"},
	{"sws", NULL, NULL, NULL, "Seluwasan"},
	{"swt", NULL, NULL, NULL, "Sawila"},
	{"swu", NULL, NULL, NULL, "Suwawa"},
	{"swv", NULL, NULL, NULL, "Shekhawati"},
	{"sww", NULL, NULL, NULL, "Sowa"},
	{"swx", NULL, NULL, NULL, "Suruahá"},
	{"swy", NULL, NULL, NULL, "Sarua"},
	{"sxb", NULL, NULL, NULL, "Suba"},
	{"sxc", NULL, NULL, NULL, "Sicanian"},
	{"sxe", NULL, NULL, NULL, "Sighu"},
	{"sxg", NULL, NULL, NULL, "Shuhi"},
	{"sxk", NULL, NULL, NULL, "Southern Kalapuya"},
	{"sxl", NULL, NULL, NULL, "Selian"},
	{"sxm", NULL, NULL, NULL, "Samre"},
	{"sxn", NULL, NULL, NULL, "Sangir"},
	{"sxo", NULL, NULL, NULL, "Sorothaptic"},
	{"sxr", NULL, NULL, NULL, "Saaroa"},
	{"sxs", NULL, NULL, NULL, "Sasaru"},
	{"sxu", NULL, NULL, NULL, "Upper Saxon"},
	{"sxw", NULL, NULL, NULL, "Saxwe Gbe"},
	{"sya", NULL, NULL, NULL, "Siang"},
	{"syb", NULL, NULL, NULL, "Central Subanen"},
	{"syc", "syc", "syc", NULL, "Classical Syriac"},
	{"syi", NULL, NULL, NULL, "Seki"},
	{"syk", NULL, NULL, NULL, "Sukur"},
	{"syl", NULL, NULL, NULL, "Sylheti"},
	{"sym", NULL, NULL, NULL, "Maya Samo"},
	{"syn", NULL, NULL, NULL, "Senaya"},
	{"syo", NULL, NULL, NULL, "Suoy"},
	{"syr", "syr", "syr", NULL, "Syriac"},
	{"sys", NULL, NULL, NULL, "Sinyar"},
	{"syw", NULL, NULL, NULL, "Kagate"},
	{"syx", NULL, NULL, NULL, "Samay"},
	{"syy", NULL, NULL, NULL, "Al-Sayyid Bedouin Sign Language"},
	{"sza", NULL, NULL, NULL, "Semelai"},
	{"szb", NULL, NULL, NULL, "Ngalum"},
	{"szc", NULL, NULL, NULL, "Semaq Beri"},
	{"szd", NULL, NULL, NULL, "Seru"},
	{"sze", NULL, NULL, NULL, "Seze"},
	{"szg", NULL, NULL, NULL, "Sengele"},
	{"szl", NULL, NULL, NULL, "Silesian"},
	{"szn", NULL, NULL, NULL, "Sula"},
	{"szp", NULL, NULL, NULL, "Suabo"},
	{"szs", NULL, NULL, NULL, "Solomon Islands Sign Language"},
	{"szv", NULL, NULL, NULL, "Isu (Fako Division)"},
	{"szw", NULL, NULL, NULL, "Sawai"},
	{"szy", NULL, NULL, NULL, "Sakizaya"},
	{"taa", NULL, NULL, NULL, "Lower Tanana"},
	{"tab", NULL, NULL, NULL, "Tabassaran"},
	{"tac", NULL, NULL, NULL, "Lowland Tarahumara"},
	{"tad", NULL, NULL, NULL, "Tause"},
	{"tae", NULL, NULL, NULL, "Tariana"},
	{"taf", NULL, NULL, NULL, "Tapirapé"},
	{"tag", NULL, NULL, NULL, "Tagoi"},
	{"tah", "tah", "tah", "ty", "Tahitian"},
	{"taj", NULL, NULL, NULL, "Eastern Tamang"},
	{"tak", NULL, NULL, NULL, "Tala"},
	{"tal", NULL, NULL, NULL, "Tal"},
	{"tam", "tam", "tam", "ta", "Tamil"},
	{"tan", NULL, NULL, NULL, "Tangale"},
	{"tao", NULL, NULL, NULL, "Yami"},
	{"tap", NULL, NULL, NULL, "Taabwa"},
	{"taq", NULL, NULL, NULL, "Tamasheq"},
	{"tar", NULL, NULL, NULL, "Central Tarahumara"},
	{"tas", NULL, NULL, NULL, "Tay Boi"},
	{"tat", "tat", "tat", "tt", "Tatar"},
	{"tau", NULL, NULL, NULL, "Upper Tanana"},
	{"tav", NULL, NULL, NULL, "Tatuyo"},
	{"taw", NULL, NULL, NULL, "Tai"},
	{"tax", NULL, NULL, NULL, "Tamki"},
	{"tay", NULL, NULL, NULL, "Atayal"},
	{"taz", NULL, NULL, NULL, "Tocho"},
	{"tba", NULL, NULL, NULL, "Aikanã"},
	{"tbc", NULL, NULL, NULL, "Takia"},
	{"tbd", NULL, NULL, NULL, "Kaki Ae"},
	{"tbe", NULL, NULL, NULL, "Tanimbili"},
	{"tbf", NULL, NULL, NULL, "Mandara"},
	{"tbg", NULL, NULL, NULL, "North Tairora"},
	{"tbh", NULL, NULL, NULL, "Dharawal"},
	{"tbi", NULL, NULL, NULL, "Gaam"},
	{"tbj", NULL, NULL, NULL, "Tiang"},
	{"tbk", NULL, NULL, NULL, "Calamian Tagbanwa"},
	{"tbl", NULL, NULL, NULL, "Tboli"},
	{"tbm", NULL, NULL, NULL, "Tagbu"},
	{"tbn", NULL, NULL, NULL, "Barro Negro Tunebo"},
	{"tbo", NULL, NULL, NULL, "Tawala"},
	{"tbp", NULL, NULL, NULL, "Taworta"},
	{"tbr", NULL, NULL, NULL, "Tumtum"},
	{"tbs", NULL, NULL, NULL, "Tanguat"},
	{"tbt", NULL, NULL, NULL, "Tembo (Kitembo)"},
	{"tbu", NULL, NULL, NULL, "Tubar"},
	{"tbv", NULL, NULL, NULL, "Tobo"},
	{"tbw", NULL, NULL, NULL, "Tagbanwa"},
	{"tbx", NULL, NULL, NULL, "Kapin"},
	{"tby", NULL, NULL, NULL, "Tabaru"},
	{"tbz", NULL, NULL, NULL, "Ditammari"},
	{"tca", NULL, NULL, NULL, "Ticuna"},
	{"tcb", NULL, NULL, NULL, "Tanacross"},
	{"tcc", NULL, NULL, NULL, "Datooga"},
	{"tcd", NULL, NULL, NULL, "Tafi"},
	{"tce", NULL, NULL, NULL, "Southern Tutchone"},
	{"tcf", NULL, NULL, NULL, "Malinaltepec Me'phaa"},
	{"tcg", NULL, NULL, NULL, "Tamagario"},
	{"tch", NULL, NULL, NULL, "Turks And Caicos Creole English"},
	{"tci", NULL, NULL, NULL, "Wára"},
	{"tck", NULL, NULL, NULL, "Tchitchege"},
	{"tcl", NULL, NULL, NULL, "Taman (Myanmar)"},
	{"tcm", NULL, NULL, NULL, "Tanahmerah"},
	{"tcn", NULL, NULL, NULL, "Tichurong"},
	{"tco", NULL, NULL, NULL, "Taungyo"},
	{"tcp", NULL, NULL, NULL, "Tawr Chin"},
	{"tcq", NULL, NULL, NULL, "Kaiy"},
	{"tcs", NULL, NULL, NULL, "Torres Strait Creole"},
	{"tct", NULL, NULL, NULL, "T'en"},
	{"tcu", NULL, NULL, NULL, "Southeastern Tarahumara"},
	{"tcw", NULL, NULL, NULL, "Tecpatlán Totonac"},
	{"tcx", NULL, NULL, NULL, "Toda"},
	{"tcy", NULL, NULL, NULL, "Tulu"},
	{"tcz", NULL, NULL, NULL, "Thado Chin"},
	{"tda", NULL, NULL, NULL, "Tagdal"},
	{"tdb", NULL, NULL, NULL, "Panchpargania"},
	{"tdc", NULL, NULL, NULL, "Emberá-Tadó"},
	{"tdd", NULL, NULL, NULL, "Tai Nüa"},
	{"tde", NULL, NULL, NULL, "Tiranige Diga Dogon"},
	{"tdf", NULL, NULL, NULL, "Talieng"},
	{"tdg", NULL, NULL, NULL, "Western Tamang"},
	{"tdh", NULL, NULL, NULL, "Thulung"},
	{"tdi", NULL, NULL, NULL, "Tomadino"},
	{"tdj", NULL, NULL, NULL, "Tajio"},
	{"tdk", NULL, NULL, NULL, "Tambas"},
	{"tdl", NULL, NULL, NULL, "Sur"},
	{"tdm", NULL, NULL, NULL, "Taruma"},
	{"tdn", NULL, NULL, NULL, "Tondano"},
	{"tdo", NULL, NULL, NULL, "Teme"},
	{"tdq", NULL, NULL, NULL, "Tita"},
	{"tdr", NULL, NULL, NULL, "Todrah"},
	{"tds", NULL, NULL, NULL, "Doutai"},
	{"tdt", NULL, NULL, NULL, "Tetun Dili"},
	{"tdv", NULL, NULL, NULL, "Toro"},
	{"tdx", NULL, NULL, NULL, "Tandroy-Mahafaly Malagasy"},
	{"tdy", NULL, NULL, NULL, "Tadyawan"},
	{"tea", NULL, NULL, NULL, "Temiar"},
	{"teb", NULL, NULL, NULL, "Tetete"},
	{"tec", NULL, NULL, NULL, "Terik"},
	{"ted", NULL, NULL, NULL, "Tepo Krumen"},
	{"tee", NULL, NULL, NULL, "Huehuetla Tepehua"},
	{"tef", NULL, NULL, NULL, "Teressa"},
	{"teg", NULL, NULL, NULL, "Teke-Tege"},
	{"teh", NULL, NULL, NULL, "Tehuelche"},
	{"tei", NULL, NULL, NULL, "Torricelli"},
	{"tek", NULL, NULL, NULL, "Ibali Teke"},
	{"tel", "tel", "tel", "te", "Telugu"},
	{"tem", "tem", "tem", NULL, "Timne"},
	{"ten", NULL, NULL, NULL, "Tama (Colombia)"},
	{"teo", NULL, NULL, NULL, "Teso"},
	{"tep", NULL, NULL, NULL, "Tepecano"},
	{"teq", NULL, NULL, NULL, "Temein"},
	{"ter", "ter", "ter", NULL, "Tereno"},
	{"tes", NULL, NULL, NULL, "Tengger"},
	{"tet", "tet", "tet", NULL, "Tetum"},
	{"teu", NULL, NULL, NULL, "Soo"},
	{"tev", NULL, NULL, NULL, "Teor"},
	{"tew", NULL, NULL, NULL, "Tewa (USA)"},
	{"tex", NULL, NULL, NULL, "Tennet"},
	{"tey", NULL, NULL, NULL, "Tulishi"},
	{"tez", NULL, NULL, NULL, "Tetserret"},
	{"tfi", NULL, NULL, NULL, "Tofin Gbe"},
	{"tfn", NULL, NULL, NULL, "Tanaina"},
	{"tfo", NULL, NULL, NULL, "Tefaro"},
	{"tfr", NULL, NULL, NULL, "Teribe"},
	{"tft", NULL, NULL, NULL, "Ternate"},
	{"tga", NULL, NULL, NULL, "Sagalla"},
	{"tgb", NULL, NULL, NULL, "Tobilung"},
	{"tgc", NULL, NULL, NULL, "Tigak"},
	{"tgd", NULL, NULL, NULL, "Ciwogai"},
	{"tge", NULL, NULL, NULL, "Eastern Gorkha Tamang"},
	{"tgf", NULL, NULL, NULL, "Chalikha"},
	{"tgh", NULL, NULL, NULL, "Tobagonian Creole English"},
	{"tgi", NULL, NULL, NULL, "Lawunuia"},
	{"tgj", NULL, NULL, NULL, "Tagin"},
	{"tgk", "tgk", "tgk", "tg", "Tajik"},
	{"tgl", "tgl", "tgl", "tl", "Tagalog"},
	{"tgn", NULL, NULL, NULL, "Tandaganon"},
	{"tgo", NULL, NULL, NULL, "Sudest"},
	{"tgp", NULL, NULL, NULL, "Tangoa"},
	{"tgq", NULL, NULL, NULL, "Tring"},
	{"tgr", NULL, NULL, NULL, "Tareng"},
	{"tgs", NULL, NULL, NULL, "Nume"},
	{"tgt", NULL, NULL, NULL, "Central Tagbanwa"},
	{"tgu", NULL, NULL, NULL, "Tanggu"},
	{"tgv", NULL, NULL, NULL, "Tingui-Boto"},
	{"tgw", NULL, NULL, NULL, "Tagwana Senoufo"},
	{"tgx", NULL, NULL, NULL, "Tagish"},
	{"tgy", NULL, NULL, NULL, "Togoyo"},
	{"tgz", NULL, NULL, NULL, "Tagalaka"},
	{"tha", "tha", "tha", "th", "Thai"},
	{"thd", NULL, NULL, NULL, "Kuuk Thaayorre"},
	{"the", NULL, NULL, NULL, "Chitwania Tharu"},
	{"thf", NULL, NULL, NULL, "Thangmi"},
	{"thh", NULL, NULL, NULL, "Northern Tarahumara"},
	{"thi", NULL, NULL, NULL, "Tai Long"},
	{"thk", NULL, NULL, NULL, "Tharaka"},
	{"thl", NULL, NULL, NULL, "Dangaura Tharu"},
	{"thm", NULL, NULL, NULL, "Aheu"},
	{"thn", NULL, NULL, NULL, "Thachanadan"},
	{"thp", NULL, NULL, NULL, "Thompson"},
	{"thq", NULL, NULL, NULL, "Kochila Tharu"},
	{"thr", NULL, NULL, NULL, "Rana Tharu"},
	{"ths", NULL, NULL, NULL, "Thakali"},
	{"tht", NULL, NULL, NULL, "Tahltan"},
	{"thu", NULL, NULL, NULL, "Thuri"},
	{"thv", NULL, NULL, NULL, "Tahaggart Tamahaq"},
	{"thy", NULL, NULL, NULL, "Tha"},
	{"thz", NULL, NULL, NULL, "Tayart Tamajeq"},
	{"tia", NULL, NULL, NULL, "Tidikelt Tamazight"},
	{"tic", NULL, NULL, NULL, "Tira"},
	{"tif", NULL, NULL, NULL, "Tifal"},
	{"tig", "tig", "tig", NULL, "Tigre"},
	{"tih", NULL, NULL, NULL, "Timugon Murut"},
	{"tii", NULL, NULL, NULL, "Tiene"},
	{"tij", NULL, NULL, NULL, "Tilung"},
	{"tik", NULL, NULL, NULL, "Tikar"},
	{"til", NULL, NULL, NULL, "Tillamook"},
	{"tim", NULL, NULL, NULL, "Timbe"},
	{"tin", NULL, NULL, NULL, "Tindi"},
	{"tio", NULL, NULL, NULL, "Teop"},
	{"tip", NULL, NULL, NULL, "Trimuris"},
	{"tiq", NULL, NULL, NULL, "Tiéfo"},
	{"tir", "tir", "tir", "ti", "Tigrinya"},
	{"tis", NULL, NULL, NULL, "Masadiit Itneg"},
	{"tit", NULL, NULL, NULL, "Tinigua"},
	{"tiu", NULL, NULL, NULL, "Adasen"},
	{"tiv", "tiv", "tiv", NULL, "Tiv"},
	{"tiw", NULL, NULL, NULL, "Tiwi"},
	{"tix", NULL, NULL, NULL, "Southern Tiwa"},
	{"tiy", NULL, NULL, NULL, "Tiruray"},
	{"tiz", NULL, NULL, NULL, "Tai Hongjin"},
	{"tja", NULL, NULL, NULL, "Tajuasohn"},
	{"tjg", NULL, NULL, NULL, "Tunjung"},
	{"tji", NULL, NULL, NULL, "Northern Tujia"},
	{"tjj", NULL, NULL, NULL, "Tjungundji"},
	{"tjl", NULL, NULL, NULL, "Tai Laing"},
	{"tjm", NULL, NULL, NULL, "Timucua"},
	{"tjn", NULL, NULL, NULL, "Tonjon"},
	{"tjo", NULL, NULL, NULL, "Temacine Tamazight"},
	{"tjp", NULL, NULL, NULL, "Tjupany"},
	{"tjs", NULL, NULL, NULL, "Southern Tujia"},
	{"tju", NULL, NULL, NULL, "Tjurruru"},
	{"tjw", NULL, NULL, NULL, "Djabwurrung"},
	{"tka", NULL, NULL, NULL, "Truká"},
	{"tkb", NULL, NULL, NULL, "Buksa"},
	{"tkd", NULL, NULL, NULL, "Tukudede"},
	{"tke", NULL, NULL, NULL, "Takwane"},
	{"tkf", NULL, NULL, NULL, "Tukumanféd"},
	{"tkg", NULL, NULL, NULL, "Tesaka Malagasy"},
	{"tkl", "tkl", "tkl", NULL, "Tokelau"},
	{"tkm", NULL, NULL, NULL, "Takelma"},
	{"tkn", NULL, NULL, NULL, "Toku-No-Shima"},
	{"tkp", NULL, NULL, NULL, "Tikopia"},
	{"tkq", NULL, NULL, NULL, "Tee"},
	{"tkr", NULL, NULL, NULL, "Tsakhur"},
	{"tks", NULL, NULL, NULL, "Takestani"},
	{"tkt", NULL, NULL, NULL, "Kathoriya Tharu"},
	{"tku", NULL, NULL, NULL, "Upper Necaxa Totonac"},
	{"tkv", NULL, NULL, NULL, "Mur Pano"},
	{"tkw", NULL, NULL, NULL, "Teanu"},
	{"tkx", NULL, NULL, NULL, "Tangko"},
	{"tkz", NULL, NULL, NULL, "Takua"},
	{"tla", NULL, NULL, NULL, "Southwestern Tepehuan"},
	{"tlb", NULL, NULL, NULL, "Tobelo"},
	{"tlc", NULL, NULL, NULL, "Yecuatla Totonac"},
	{"tld", NULL, NULL, NULL, "Talaud"},
	{"tlf", NULL, NULL, NULL, "Telefol"},
	{"tlg", NULL, NULL, NULL, "Tofanma"},
	{"tlh", "tlh", "tlh", NULL, "Klingon"},
	{"tli", "tli", "tli", NULL, "Tlingit"},
	{"tlj", NULL, NULL, NULL, "Talinga-Bwisi"},
	{"tlk", NULL, NULL, NULL, "Taloki"},
	{"tll", NULL, NULL, NULL, "Tetela"},
	{"tlm", NULL, NULL, NULL, "Tolomako"},
	{"tln", NULL, NULL, NULL, "Talondo'"},
	{"tlo", NULL, NULL, NULL, "Talodi"},
	{"tlp", NULL, NULL, NULL, "Filomena Mata-Coahuitlán Totonac"},
	{"tlq", NULL, NULL, NULL, "Tai Loi"},
	{"tlr", NULL, NULL, NULL, "Talise"},
	{"tls", NULL, NULL, NULL, "Tambotalo"},
	{"tlt", NULL, NULL, NULL, "Sou Nama"},
	{"tlu", NULL, NULL, NULL, "Tulehu"},
	{"tlv", NULL, NULL, NULL, "Taliabu"},
	{"tlx", NULL, NULL, NULL, "Khehek"},
	{"tly", NULL, NULL, NULL, "Talysh"},
	{"tma", NULL, NULL, NULL, "Tama (Chad)"},
	{"tmb", NULL, NULL, NULL, "Katbol"},
	{"tmc", NULL, NULL, NULL, "Tumak"},
	{"tmd", NULL, NULL, NULL, "Haruai"},
	{"tme", NULL, NULL, NULL, "Tremembé"},
	{"tmf", NULL, NULL, NULL, "Toba-Maskoy"},
	{"tmg", NULL, NULL, NULL, "Ternateño"},
	{"tmh", "tmh", "tmh", NULL, "Tamashek"},
	{"tmi", NULL, NULL, NULL, "Tutuba"},
	{"tmj", NULL, NULL, NULL, "Samarokena"},
	{"tmk", NULL, NULL, NULL, "Northwestern Tamang"},
	{"tml", NULL, NULL, NULL, "Tamnim Citak"},
	{"tmm", NULL, NULL, NULL, "Tai Thanh"},
	{"tmn", NULL, NULL, NULL, "Taman (Indonesia)"},
	{"tmo", NULL, NULL, NULL, "Temoq"},
	{"tmq", NULL, NULL, NULL, "Tumleo"},
	{"tmr", NULL, NULL, NULL, "Jewish Babylonian Aramaic (ca. 200-1200 CE)"},
	{"tms", NULL, NULL, NULL, "Tima"},
	{"tmt", NULL, NULL, NULL, "Tasmate"},
	{"tmu", NULL, NULL, NULL, "Iau"},
	{"tmv", NULL, NULL, NULL, "Tembo (Motembo)"},
	{"tmw", NULL, NULL, NULL, "Temuan"},
	{"tmy", NULL, NULL, NULL, "Tami"},
	{"tmz", NULL, NULL, NULL, "Tamanaku"},
	{"tna", NULL, NULL, NULL, "Tacana"},
	{"tnb", NULL, NULL, NULL, "Western Tunebo"},
	{"tnc", NULL, NULL, NULL, "Tanimuca-Retuarã"},
	{"tnd", NULL, NULL, NULL, "Angosturas Tunebo"},
	{"tng", NULL, NULL, NULL, "Tobanga"},
	{"tnh", NULL, NULL, NULL, "Maiani"},
	{"tni", NULL, NULL, NULL, "Tandia"},
	{"tnk", NULL, NULL, NULL, "Kwamera"},
	{"tnl", NULL, NULL, NULL, "Lenakel"},
	{"tnm", NULL, NULL, NULL, "Tabla"},
	{"tnn", NULL, NULL, NULL, "North Tanna"},
	{"tno", NULL, NULL, NULL, "Toromono"},
	{"tnp", NULL, NULL, NULL, "Whitesands"},
	{"tnq", NULL, NULL, NULL, "Taino"},
	{"tnr", NULL, NULL, NULL, "Ménik"},
	{"tns", NULL, NULL, NULL, "Tenis"},
	{"tnt", NULL, NULL, NULL, "Tontemboan"},
	{"tnu", NULL, NULL, NULL, "Tay Khang"},
	{"tnv", NULL, NULL, NULL, "Tangchangya"},
	{"tnw", NULL, NULL, NULL, "Tonsawang"},
	{"tnx", NULL, NULL, NULL, "Tanema"},
	{"tny", NULL, NULL, NULL, "Tongwe"},
	{"tnz", NULL, NULL, NULL, "Ten'edn"},
	{"tob", NULL, NULL, NULL, "Toba"},
	{"toc", NULL, NULL, NULL, "Coyutla Totonac"},
	{"tod", NULL, NULL, NULL, "Toma"},
	{"tof", NULL, NULL, NULL, "Gizrra"},
	{"tog", "tog", "tog", NULL, "Tonga (Nyasa)"},
	{"toh", NULL, NULL, NULL, "Gitonga"},
	{"toi", NULL, NULL, NULL, "Tonga (Zambia)"},
	{"toj", NULL, NULL, NULL, "Tojolabal"},
	{"tol", NULL, NULL, NULL, "Tolowa"},
	{"tom", NULL, NULL, NULL, "Tombulu"},
	{"ton", "ton", "ton", "to", "Tonga (Tonga Islands)"},
	{"too", NULL, NULL, NULL, "Xicotepec De Juárez Totonac"},
	{"top", NULL, NULL, NULL, "Papantla Totonac"},
	{"toq", NULL, NULL, NULL, "Toposa"},
	{"tor", NULL, NULL, NULL, "Togbo-Vara Banda"},
	{"tos", NULL, NULL, NULL, "Highland Totonac"},
	{"tou", NULL, NULL, NULL, "Tho"},
	{"tov", NULL, NULL, NULL, "Upper Taromi"},
	{"tow", NULL, NULL, NULL, "Jemez"},
	{"tox", NULL, NULL, NULL, "Tobian"},
	{"toy", NULL, NULL, NULL, "Topoiyo"},
	{"toz", NULL, NULL, NULL, "To"},
	{"tpa", NULL, NULL, NULL, "Taupota"},
	{"tpc", NULL, NULL, NULL, "Azoyú Me'phaa"},
	{"tpe", NULL, NULL, NULL, "Tippera"},
	{"tpf", NULL, NULL, NULL, "Tarpia"},
	{"tpg", NULL, NULL, NULL, "Kula"},
	{"tpi", "tpi", "tpi", NULL, "Tok Pisin"},
	{"tpj", NULL, NULL, NULL, "Tapieté"},
	{"tpk", NULL, NULL, NULL, "Tupinikin"},
	{"tpl", NULL, NULL, NULL, "Tlacoapa Me'phaa"},
	{"tpm", NULL, NULL, NULL, "Tampulma"},
	{"tpn", NULL, NULL, NULL, "Tupinambá"},
	{"tpo", NULL, NULL, NULL, "Tai Pao"},
	{"tpp", NULL, NULL, NULL, "Pisaflores Tepehua"},
	{"tpq", NULL, NULL, NULL, "Tukpa"},
	{"tpr", NULL, NULL, NULL, "Tuparí"},
	{"tpt", NULL, NULL, NULL, "Tlachichilco Tepehua"},
	{"tpu", NULL, NULL, NULL, "Tampuan"},
	{"tpv", NULL, NULL, NULL, "Tanapag"},
	{"tpw", NULL, NULL, NULL, "Tupí"},
	{"tpx", NULL, NULL, NULL, "Acatepec Me'phaa"},
	{"tpy", NULL, NULL, NULL, "Trumai"},
	{"tpz", NULL, NULL, NULL, "Tinputz"},
	{"tqb", NULL, NULL, NULL, "Tembé"},
	{"tql", NULL, NULL, NULL, "Lehali"},
	{"tqm", NULL, NULL, NULL, "Turumsa"},
	{"tqn", NULL, NULL, NULL, "Tenino"},
	{"tqo", NULL, NULL, NULL, "Toaripi"},
	{"tqp", NULL, NULL, NULL, "Tomoip"},
	{"tqq", NULL, NULL, NULL, "Tunni"},
	{"tqr", NULL, NULL, NULL, "Torona"},
	{"tqt", NULL, NULL, NULL, "Western Totonac"},
	{"tqu", NULL, NULL, NULL, "Touo"},
	{"tqw", NULL, NULL, NULL, "Tonkawa"},
	{"tra", NULL, NULL, NULL, "Tirahi"},
	{"trb", NULL, NULL, NULL, "Terebu"},
	{"trc", NULL, NULL, NULL, "Copala Triqui"},
	{"trd", NULL, NULL, NULL, "Turi"},
	{"tre", NULL, NULL, NULL, "East Tarangan"},
	{"trf", NULL, NULL, NULL, "Trinidadian Creole English"},
	{"trg", NULL, NULL, NULL, "Lishán Didán"},
	{"trh", NULL, NULL, NULL, "Turaka"},
	{"tri", NULL, NULL, NULL, "Trió"},
	{"trj", NULL, NULL, NULL, "Toram"},
	{"trl", NULL, NULL, NULL, "Traveller Scottish"},
	{"trm", NULL, NULL, NULL, "Tregami"},
	{"trn", NULL, NULL, NULL, "Trinitario"},
	{"tro", NULL, NULL, NULL, "Tarao Naga"},
	{"trp", NULL, NULL, NULL, "Kok Borok"},
	{"trq", NULL, NULL, NULL, "San Martín Itunyoso Triqui"},
	{"trr", NULL, NULL, NULL, "Taushiro"},
	{"trs", NULL, NULL, NULL, "Chicahuaxtla Triqui"},
	{"trt", NULL, NULL, NULL, "Tunggare"},
	{"tru", NULL, NULL, NULL, "Turoyo"},
	{"trv", NULL, NULL, NULL, "Taroko"},
	{"trw", NULL, NULL, NULL, "Torwali"},
	{"trx", NULL, NULL, NULL, "Tringgus-Sembaan Bidayuh"},
	{"try", NULL, NULL, NULL, "Turung"},
	{"trz", NULL, NULL, NULL, "Torá"},
	{"tsa", NULL, NULL, NULL, "Tsaangi"},
	{"tsb", NULL, NULL, NULL, "Tsamai"},
	{"tsc", NULL, NULL, NULL, "Tswa"},
	{"tsd", NULL, NULL, NULL, "Tsakonian"},
	{"tse", NULL, NULL, NULL, "Tunisian Sign Language"},
	{"tsg", NULL, NULL, NULL, "Tausug"},
	{"tsh", NULL, NULL, NULL, "Tsuvan"},
	{"tsi", "tsi", "tsi", NULL, "Tsimshian"},
	{"tsj", NULL, NULL, NULL, "Tshangla"},
	{"tsk", NULL, NULL, NULL, "Tseku"},
	{"tsl", NULL, NULL, NULL, "Ts'ün-Lao"},
	{"tsm", NULL, NULL, NULL, "Turkish Sign Language"},
	{"tsn", "tsn", "tsn", "tn", "Tswana"},
	{"tso", "tso", "tso", "ts", "Tsonga"},
	{"tsp", NULL, NULL, NULL, "Northern Toussian"},
	{"tsq", NULL, NULL, NULL, "Thai Sign Language"},
	{"tsr", NULL, NULL, NULL, "Akei"},
	{"tss", NULL, NULL, NULL, "Taiwan Sign Language"},
	{"tst", NULL, NULL, NULL, "Tondi Songway Kiini"},
	{"tsu", NULL, NULL, NULL, "Tsou"},
	{"tsv", NULL, NULL, NULL, "Tsogo"},
	{"tsw", NULL, NULL, NULL, "Tsishingini"},
	{"tsx", NULL, NULL, NULL, "Mubami"},
	{"tsy", NULL, NULL, NULL, "Tebul Sign Language"},
	{"tsz", NULL, NULL, NULL, "Purepecha"},
	{"tta", NULL, NULL, NULL, "Tutelo"},
	{"ttb", NULL, NULL, NULL, "Gaa"},
	{"ttc", NULL, NULL, NULL, "Tektiteko"},
	{"ttd", NULL, NULL, NULL, "Tauade"},
	{"tte", NULL, NULL, NULL, "Bwanabwana"},
	{"ttf", NULL, NULL, NULL, "Tuotomb"},
	{"ttg", NULL, NULL, NULL, "Tutong"},
	{"tth", NULL, NULL, NULL, "Upper Ta'oih"},
	{"tti", NULL, NULL, NULL, "Tobati"},
	{"ttj", NULL, NULL, NULL, "Tooro"},
	{"ttk", NULL, NULL, NULL, "Totoro"},
	{"ttl", NULL, NULL, NULL, "Totela"},
	{"ttm", NULL, NULL, NULL, "Northern Tutchone"},
	{"ttn", NULL, NULL, NULL, "Towei"},
	{"tto", NULL, NULL, NULL, "Lower Ta'oih"},
	{"ttp", NULL, NULL, NULL, "Tombelala"},
	{"ttq", NULL, NULL, NULL, "Tawallammat Tamajaq"},
	{"ttr", NULL, NULL, NULL, "Tera"},
	{"tts", NULL, NULL, NULL, "Northeastern Thai"},
	{"ttt", NULL, NULL, NULL, "Muslim Tat"},
	{"ttu", NULL, NULL, NULL, "Torau"},
	{"ttv", NULL, NULL, NULL, "Titan"},
	{"ttw", NULL, NULL, NULL, "Long Wat"},
	{"tty", NULL, NULL, NULL, "Sikaritai"},
	{"ttz", NULL, NULL, NULL, "Tsum"},
	{"tua", NULL, NULL, NULL, "Wiarumus"},
	{"tub", NULL, NULL, NULL, "Tübatulabal"},
	{"tuc", NULL, NULL, NULL, "Mutu"},
	{"tud", NULL, NULL, NULL, "Tuxá"},
	{"tue", NULL, NULL, NULL, "Tuyuca"},
	{"tuf", NULL, NULL, NULL, "Central Tunebo"},
	{"tug", NULL, NULL, NULL, "Tunia"},
	{"tuh", NULL, NULL, NULL, "Taulil"},
	{"tui", NULL, NULL, NULL, "Tupuri"},
	{"tuj", NULL, NULL, NULL, "Tugutil"},
	{"tuk", "tuk", "tuk", "tk", "Turkmen"},
	{"tul", NULL, NULL, NULL, "Tula"},
	{"tum", "tum", "tum", NULL, "Tumbuka"},
	{"tun", NULL, NULL, NULL, "Tunica"},
	{"tuo", NULL, NULL, NULL, "Tucano"},
	{"tuq", NULL, NULL, NULL, "Tedaga"},
	{"tur", "tur", "tur", "tr", "Turkish"},
	{"tus", NULL, NULL, NULL, "Tuscarora"},
	{"tuu", NULL, NULL, NULL, "Tututni"},
	{"tuv", NULL, NULL, NULL, "Turkana"},
	{"tux", NULL, NULL, NULL, "Tuxináwa"},
	{"tuy", NULL, NULL, NULL, "Tugen"},
	{"tuz", NULL, NULL, NULL, "Turka"},
	{"tva", NULL, NULL, NULL, "Vaghua"},
	{"tvd", NULL, NULL, NULL, "Tsuvadi"},
	{"tve", NULL, NULL, NULL, "Te'un"},
	{"tvk", NULL, NULL, NULL, "Southeast Ambrym"},
	{"tvl", "tvl", "tvl", NULL, "Tuvalu"},
	{"tvm", NULL, NULL, NULL, "Tela-Masbuar"},
	{"tvn", NULL, NULL, NULL, "Tavoyan"},
	{"tvo", NULL, NULL, NULL, "Tidore"},
	{"tvs", NULL, NULL, NULL, "Taveta"},
	{"tvt", NULL, NULL, NULL, "Tutsa Naga"},
	{"tvu", NULL, NULL, NULL, "Tunen"},
	{"tvw", NULL, NULL, NULL, "Sedoa"},
	{"tvx", NULL, NULL, NULL, "Taivoan"},
	{"tvy", NULL, NULL, NULL, "Timor Pidgin"},
	{"twa", NULL, NULL, NULL, "Twana"},
	{"twb", NULL, NULL, NULL, "Western Tawbuid"},
	{"twc", NULL, NULL, NULL, "Teshenawa"},
	{"twd", NULL, NULL, NULL, "Twents"},
	{"twe", NULL, NULL, NULL, "Tewa (Indonesia)"},
	{"twf", NULL, NULL, NULL, "Northern Tiwa"},
	{"twg", NULL, NULL, NULL, "Tereweng"},
	{"twh", NULL, NULL, NULL, "Tai Dón"},
	{"twi", "twi", "twi", "tw", "Twi"},
	{"twl", NULL, NULL, NULL, "Tawara"},
	{"twm", NULL, NULL, NULL, "Tawang Monpa"},
	{"twn", NULL, NULL, NULL, "Twendi"},
	{"two", NULL, NULL, NULL, "Tswapong"},
	{"twp", NULL, NULL, NULL, "Ere"},
	{"twq", NULL, NULL, NULL, "Tasawaq"},
	{"twr", NULL, NULL, NULL, "Southwestern Tarahumara"},
	{"twt", NULL, NULL, NULL, "Turiwára"},
	{"twu", NULL, NULL, NULL, "Termanu"},
	{"tww", NULL, NULL, NULL, "Tuwari"},
	{"twx", NULL, NULL, NULL, "Tewe"},
	{"twy", NULL, NULL, NULL, "Tawoyan"},
	{"txa", NULL, NULL, NULL, "Tombonuo"},
	{"txb", NULL, NULL, NULL, "Tokharian B"},
	{"txc", NULL, NULL, NULL, "Tsetsaut"},
	{"txe", NULL, NULL, NULL, "Totoli"},
	{"txg", NULL, NULL, NULL, "Tangut"},
	{"txh", NULL, NULL, NULL, "Thracian"},
	{"txi", NULL, NULL, NULL, "Ikpeng"},
	{"txj", NULL, NULL, NULL, "Tarjumo"},
	{"txm", NULL, NULL, NULL, "Tomini"},
	{"txn", NULL, NULL, NULL, "West Tarangan"},
	{"txo", NULL, NULL, NULL, "Toto"},
	{"txq", NULL, NULL, NULL, "Tii"},
	{"txr", NULL, NULL, NULL, "Tartessian"},
	{"txs", NULL, NULL, NULL, "Tonsea"},
	{"txt", NULL, NULL, NULL, "Citak"},
	{"txu", NULL, NULL, NULL, "Kayapó"},
	{"txx", NULL, NULL, NULL, "Tatana"},
	{"txy", NULL, NULL, NULL, "Tanosy Malagasy"},
	{"tya", NULL, NULL, NULL, "Tauya"},
	{"tye", NULL, NULL, NULL, "Kyanga"},
	{"tyh", NULL, NULL, NULL, "O'du"},
	{"tyi", NULL, NULL, NULL, "Teke-Tsaayi"},
	{"tyj", NULL, NULL, NULL, "Tai Do"},
	{"tyl", NULL, NULL, NULL, "Thu Lao"},
	{"tyn", NULL, NULL, NULL, "Kombai"},
	{"typ", NULL, NULL, NULL, "Thaypan"},
	{"tyr", NULL, NULL, NULL, "Tai Daeng"},
	{"tys", NULL, NULL, NULL, "Tày Sa Pa"},
	{"tyt", NULL, NULL, NULL, "Tày Tac"},
	{"tyu", NULL, NULL, NULL, "Kua"},
	{"tyv", "tyv", "tyv", NULL, "Tuvinian"},
	{"tyx", NULL, NULL, NULL, "Teke-Tyee"},
	{"tyy", NULL, NULL, NULL, "Tiyaa"},
	{"tyz", NULL, NULL, NULL, "Tày"},
	{"tza", NULL, NULL, NULL, "Tanzanian Sign Language"},
	{"tzh", NULL, NULL, NULL, "Tzeltal"},
	{"tzj", NULL, NULL, NULL, "Tz'utujil"},
	{"tzl", NULL, NULL, NULL, "Talossan"},
	{"tzm", NULL, NULL, NULL, "Central Atlas Tamazight"},
	{"tzn", NULL, NULL, NULL, "Tugun"},
	{"tzo", NULL, NULL, NULL, "Tzotzil"},
	{"tzx", NULL, NULL, NULL, "Tabriak"},
	{"uam", NULL, NULL, NULL, "Uamué"},
	{"uan", NULL, NULL, NULL, "Kuan"},
	{"uar", NULL, NULL, NULL, "Tairuma"},
	{"uba", NULL, NULL, NULL, "Ubang"},
	{"ubi", NULL, NULL, NULL, "Ubi"},
	{"ubl", NULL, NULL, NULL, "Buhi'non Bikol"},
	{"ubr", NULL, NULL, NULL, "Ubir"},
	{"ubu", NULL, NULL, NULL, "Umbu-Ungu"},
	{"uby", NULL, NULL, NULL, "Ubykh"},
	{"uda", NULL, NULL, NULL, "Uda"},
	{"ude", NULL, NULL, NULL, "Udihe"},
	{"udg", NULL, NULL, NULL, "Muduga"},
	{"udi", NULL, NULL, NULL, "Udi"},
	{"udj", NULL, NULL, NULL, "Ujir"},
	{"udl", NULL, NULL, NULL, "Wuzlam"},
	{"udm", "udm", "udm", NULL, "Udmurt"},
	{"udu", NULL, NULL, NULL, "Uduk"},
	{"ues", NULL, NULL, NULL, "Kioko"},
	{"ufi", NULL, NULL, NULL, "Ufim"},
	{"uga", "uga", "uga", NULL, "Ugaritic"},
	{"ugb", NULL, NULL, NULL, "Kuku-Ugbanh"},
	{"uge", NULL, NULL, NULL, "Ughele"},
	{"ugn", NULL, NULL, NULL, "Ugandan Sign Language"},
	{"ugo", NULL, NULL, NULL, "Ugong"},
	{"ugy", NULL, NULL, NULL, "Uruguayan Sign Language"},
	{"uha", NULL, NULL, NULL, "Uhami"},
	{"uhn", NULL, NULL, NULL, "Damal"},
	{"uig", "uig", "uig", "ug", "Uighur"},
	{"uis", NULL, NULL, NULL, "Uisai"},
	{"uiv", NULL, NULL, NULL, "Iyive"},
	{"uji", NULL, NULL, NULL, "Tanjijili"},
	{"uka", NULL, NULL, NULL, "Kaburi"},
	{"ukg", NULL, NULL, NULL, "Ukuriguma"},
	{"ukh", NULL, NULL, NULL, "Ukhwejo"},
	{"uki", NULL, NULL, NULL, "Kui (India)"},
	{"ukk", NULL, NULL, NULL, "Muak Sa-aak"},
	{"ukl", NULL, NULL, NULL, "Ukrainian Sign Language"},
	{"ukp", NULL, NULL, NULL, "Ukpe-Bayobiri"},
	{"ukq", NULL, NULL, NULL, "Ukwa"},
	{"ukr", "ukr", "ukr", "uk", "Ukrainian"},
	{"uks", NULL, NULL, NULL, "Urubú-Kaapor Sign Language"},
	{"uku", NULL, NULL, NULL, "Ukue"},
	{"ukv", NULL, NULL, NULL, "Kuku"},
	{"ukw", NULL, NULL, NULL, "Ukwuani-Aboh-Ndoni"},
	{"uky", NULL, NULL, NULL, "Kuuk-Yak"},
	{"ula", NULL, NULL, NULL, "Fungwa"},
	{"ulb", NULL, NULL, NULL, "Ulukwumi"},
	{"ulc", NULL, NULL, NULL, "Ulch"},
	{"ule", NULL, NULL, NULL, "Lule"},
	{"ulf", NULL, NULL, NULL, "Usku"},
	{"uli", NULL, NULL, NULL, "Ulithian"},
	{"ulk", NULL, NULL, NULL, "Meriam Mir"},
	{"ull", NULL, NULL, NULL, "Ullatan"},
	{"ulm", NULL, NULL, NULL, "Ulumanda'"},
	{"uln", NULL, NULL, NULL, "Unserdeutsch"},
	{"ulu", NULL, NULL, NULL, "Uma' Lung"},
	{"ulw", NULL, NULL, NULL, "Ulwa"},
	{"uma", NULL, NULL, NULL, "Umatilla"},
	{"umb", "umb", "umb", NULL, "Umbundu"},
	{"umc", NULL, NULL, NULL, "Marrucinian"},
	{"umd", NULL, NULL, NULL, "Umbindhamu"},
	{"umg", NULL, NULL, NULL, "Morrobalama"},
	{"umi", NULL, NULL, NULL, "Ukit"},
	{"umm", NULL, NULL, NULL, "Umon"},
	{"umn", NULL, NULL, NULL, "Makyan Naga"},
	{"umo", NULL, NULL, NULL, "Umotína"},
	{"ump", NULL, NULL, NULL, "Umpila"},
	{"umr", NULL, NULL, NULL, "Umbugarla"},
	{"ums", NULL, NULL, NULL, "Pendau"},
	{"umu", NULL, NULL, NULL, "Munsee"},
	{"una", NULL, NULL, NULL, "North Watut"},
	{"und", "und", "und", NULL, "Undetermined"},
	{"une", NULL, NULL, NULL, "Uneme"},
	{"ung", NULL, NULL, NULL, "Ngarinyin"},
	{"uni", NULL, NULL, NULL, "Uni"},
	{"unk", NULL, NULL, NULL, "Enawené-Nawé"},
	{"unm", NULL, NULL, NULL, "Unami"},
	{"unn", NULL, NULL, NULL, "Kurnai"},
	{"unr", NULL, NULL, NULL, "Mundari"},
	{"unu", NULL, NULL, NULL, "Unubahe"},
	{"unx", NULL, NULL, NULL, "Munda"},
	{"unz", NULL, NULL, NULL, "Unde Kaili"},
	{"upi", NULL, NULL, NULL, "Umeda"},
	{"upv", NULL, NULL, NULL, "Uripiv-Wala-Rano-Atchin"},
	{"ura", NULL, NULL, NULL, "Urarina"},
	{"urb", NULL, NULL, NULL, "Urubú-Kaapor"},
	{"urc", NULL, NULL, NULL, "Urningangg"},
	{"urd", "urd", "urd", "ur", "Urdu"},
	{"ure", NULL, NULL, NULL, "Uru"},
	{"urf", NULL, NULL, NULL, "Uradhi"},
	{"urg", NULL, NULL, NULL, "Urigina"},
	{"urh", NULL, NULL, NULL, "Urhobo"},
	{"uri", NULL, NULL, NULL, "Urim"},
	{"urk", NULL, NULL, NULL, "Urak Lawoi'"},
	{"url", NULL, NULL, NULL, "Urali"},
	{"urm", NULL, NULL, NULL, "Urapmin"},
	{"urn", NULL, NULL, NULL, "Uruangnirin"},
	{"uro", NULL, NULL, NULL, "Ura (Papua New Guinea)"},
	{"urp", NULL, NULL, NULL, "Uru-Pa-In"},
	{"urr", NULL, NULL, NULL, "Lehalurup"},
	{"urt", NULL, NULL, NULL, "Urat"},
	{"uru", NULL, NULL, NULL, "Urumi"},
	{"urv", NULL, NULL, NULL, "Uruava"},
	{"urw", NULL, NULL, NULL, "Sop"},
	{"urx", NULL, NULL, NULL, "Urimo"},
	{"ury", NULL, NULL, NULL, "Orya"},
	{"urz", NULL, NULL, NULL, "Uru-Eu-Wau-Wau"},
	{"usa", NULL, NULL, NULL, "Usarufa"},
	{"ush", NULL, NULL, NULL, "Ushojo"},
	{"usi", NULL, NULL, NULL, "Usui"},
	{"usk", NULL, NULL, NULL, "Usaghade"},
	{"usp", NULL, NULL, NULL, "Uspanteco"},
	{"uss", NULL, NULL, NULL, "us-Saare"},
	{"usu", NULL, NULL, NULL, "Uya"},
	{"uta", NULL, NULL, NULL, "Otank"},
	{"ute", NULL, NULL, NULL, "Ute-Southern Paiute"},
	{"uth", NULL, NULL, NULL, "ut-Hun"},
	{"utp", NULL, NULL, NULL, "Amba (Solomon Islands)"},
	{"utr", NULL, NULL, NULL, "Etulo"},
	{"utu", NULL, NULL, NULL, "Utu"},
	{"uum", NULL, NULL, NULL, "Urum"},
	{"uun", NULL, NULL, NULL, "Kulon-Pazeh"},
	{"uur", NULL, NULL, NULL, "Ura (Vanuatu)"},
	{"uuu", NULL, NULL, NULL, "U"},
	{"uve", NULL, NULL, NULL, "West Uvean"},
	{"uvh", NULL, NULL, NULL, "Uri"},
	{"uvl", NULL, NULL, NULL, "Lote"},
	{"uwa", NULL, NULL, NULL, "Kuku-Uwanh"},
	{"uya", NULL, NULL, NULL, "Doko-Uyanga"},
	{"uzb", "uzb", "uzb", "uz", "Uzbek"},
	{"uzn", NULL, NULL, NULL, "Northern Uzbek"},
	{"uzs", NULL, NULL, NULL, "Southern Uzbek"},
	{"vaa", NULL, NULL, NULL, "Vaagri Booli"},
	{"vae", NULL, NULL, NULL, "Vale"},
	{"vaf", NULL, NULL, NULL, "Vafsi"},
	{"vag", NULL, NULL, NULL, "Vagla"},
	{"vah", NULL, NULL, NULL, "Varhadi-Nagpuri"},
	{"vai", "vai", "vai", NULL, "Vai"},
	{"vaj", NULL, NULL, NULL, "Sekele"},
	{"val", NULL, NULL, NULL, "Vehes"},
	{"vam", NULL, NULL, NULL, "Vanimo"},
	{"van", NULL, NULL, NULL, "Valman"},
	{"vao", NULL, NULL, NULL, "Vao"},
	{"vap", NULL, NULL, NULL, "Vaiphei"},
	{"var", NULL, NULL, NULL, "Huarijio"},
	{"vas", NULL, NULL, NULL, "Vasavi"},
	{"vau", NULL, NULL, NULL, "Vanuma"},
	{"vav", NULL, NULL, NULL, "Varli"},
	{"vay", NULL, NULL, NULL, "Wayu"},
	{"vbb", NULL, NULL, NULL, "Southeast Babar"},
	{"vbk", NULL, NULL, NULL, "Southwestern Bontok"},
	{"vec", NULL, NULL, NULL, "Venetian"},
	{"ved", NULL, NULL, NULL, "Veddah"},
	{"vel", NULL, NULL, NULL, "Veluws"},
	{"vem", NULL, NULL, NULL, "Vemgo-Mabas"},
	{"ven", "ven", "ven", "ve", "Venda"},
	{"veo", NULL, NULL, NULL, "Ventureño"},
	{"vep", NULL, NULL, NULL, "Veps"},
	{"ver", NULL, NULL, NULL, "Mom Jango"},
	{"vgr", NULL, NULL, NULL, "Vaghri"},
	{"vgt", NULL, NULL, NULL, "Vlaamse Gebarentaal"},
	{"vic", NULL, NULL, NULL, "Virgin Islands Creole English"},
	{"vid", NULL, NULL, NULL, "Vidunda"},
	{"vie", "vie", "vie", "vi", "Vietnamese"},
	{"vif", NULL, NULL, NULL, "Vili"},
	{"vig", NULL, NULL, NULL, "Viemo"},
	{"vil", NULL, NULL, NULL, "Vilela"},
	{"vin", NULL, NULL, NULL, "Vinza"},
	{"vis", NULL, NULL, NULL, "Vishavan"},
	{"vit", NULL, NULL, NULL, "Viti"},
	{"viv", NULL, NULL, NULL, "Iduna"},
	{"vka", NULL, NULL, NULL, "Kariyarra"},
	{"vkj", NULL, NULL, NULL, "Kujarge"},
	{"vkk", NULL, NULL, NULL, "Kaur"},
	{"vkl", NULL, NULL, NULL, "Kulisusu"},
	{"vkm", NULL, NULL, NULL, "Kamakan"},
	{"vkn", NULL, NULL, NULL, "Koro Nulu"},
	{"vko", NULL, NULL, NULL, "Kodeoha"},
	{"vkp", NULL, NULL, NULL, "Korlai Creole Portuguese"},
	{"vkt", NULL, NULL, NULL, "Tenggarong Kutai Malay"},
	{"vku", NULL, NULL, NULL, "Kurrama"},
	{"vkz", NULL, NULL, NULL, "Koro Zuba"},
	{"vlp", NULL, NULL, NULL, "Valpei"},
	{"vls", NULL, NULL, NULL, "Vlaams"},
	{"vma", NULL, NULL, NULL, "Martuyhunira"},
	{"vmb", NULL, NULL, NULL, "Barbaram"},
	{"vmc", NULL, NULL, NULL, "Juxtlahuaca Mixtec"},
	{"vmd", NULL, NULL, NULL, "Mudu Koraga"},
	{"vme", NULL, NULL, NULL, "East Masela"},
	{"vmf", NULL, NULL, NULL, "Mainfränkisch"},
	{"vmg", NULL, NULL, NULL, "Lungalunga"},
	{"vmh", NULL, NULL, NULL, "Maraghei"},
	{"vmi", NULL, NULL, NULL, "Miwa"},
	{"vmj", NULL, NULL, NULL, "Ixtayutla Mixtec"},
	{"vmk", NULL, NULL, NULL, "Makhuwa-Shirima"},
	{"vml", NULL, NULL, NULL, "Malgana"},
	{"vmm", NULL, NULL, NULL, "Mitlatongo Mixtec"},
	{"vmp", NULL, NULL, NULL, "Soyaltepec Mazatec"},
	{"vmq", NULL, NULL, NULL, "Soyaltepec Mixtec"},
	{"vmr", NULL, NULL, NULL, "Marenje"},
	{"vms", NULL, NULL, NULL, "Moksela"},
	{"vmu", NULL, NULL, NULL, "Muluridyi"},
	{"vmv", NULL, NULL, NULL, "Valley Maidu"},
	{"vmw", NULL, NULL, NULL, "Makhuwa"},
	{"vmx", NULL, NULL, NULL, "Tamazola Mixtec"},
	{"vmy", NULL, NULL, NULL, "Ayautla Mazatec"},
	{"vmz", NULL, NULL, NULL, "Mazatlán Mazatec"},
	{"vnk", NULL, NULL, NULL, "Vano"},
	{"vnm", NULL, NULL, NULL, "Vinmavis"},
	{"vnp", NULL, NULL, NULL, "Vunapu"},
	{"vol", "vol", "vol", "vo", "Volapük"},
	{"vor", NULL, NULL, NULL, "Voro"},
	{"vot", "vot", "vot", NULL, "Votic"},
	{"vra", NULL, NULL, NULL, "Vera'a"},
	{"vro", NULL, NULL, NULL, "Võro"},
	{"vrs", NULL, NULL, NULL, "Varisi"},
	{"vrt", NULL, NULL, NULL, "Burmbar"},
	{"vsi", NULL, NULL, NULL, "Moldova Sign Language"},
	{"vsl", NULL, NULL, NULL, "Venezuelan Sign Language"},
	{"vsv", NULL, NULL, NULL, "Valencian Sign Language"},
	{"vto", NULL, NULL, NULL, "Vitou"},
	{"vum", NULL, NULL, NULL, "Vumbu"},
	{"vun", NULL, NULL, NULL, "Vunjo"},
	{"vut", NULL, NULL, NULL, "Vute"},
	{"vwa", NULL, NULL, NULL, "Awa (China)"},
	{"waa", NULL, NULL, NULL, "Walla Walla"},
	{"wab", NULL, NULL, NULL, "Wab"},
	{"wac", NULL, NULL, NULL, "Wasco-Wishram"},
	{"wad", NULL, NULL, NULL, "Wamesa"},
	{"wae", NULL, NULL, NULL, "Walser"},
	{"waf", NULL, NULL, NULL, "Wakoná"},
	{"wag", NULL, NULL, NULL, "Wa'ema"},
	{"wah", NULL, NULL, NULL, "Watubela"},
	{"wai", NULL, NULL, NULL, "Wares"},
	{"waj", NULL, NULL, NULL, "Waffa"},
	{"wal", "wal", "wal", NULL, "Wolaytta"},
	{"wam", NULL, NULL, NULL, "Wampanoag"},
	{"wan", NULL, NULL, NULL, "Wan"},
	{"wao", NULL, NULL, NULL, "Wappo"},
	{"wap", NULL, NULL, NULL, "Wapishana"},
	{"waq", NULL, NULL, NULL, "Wagiman"},
	{"war", "war", "war", NULL, "Waray (Philippines)"},
	{"was", "was", "was", NULL, "Washo"},
	{"wat", NULL, NULL, NULL, "Kaninuwa"},
	{"wau", NULL, NULL, NULL, "Waurá"},
	{"wav", NULL, NULL, NULL, "Waka"},
	{"waw", NULL, NULL, NULL, "Waiwai"},
	{"wax", NULL, NULL, NULL, "Watam"},
	{"way", NULL, NULL, NULL, "Wayana"},
	{"waz", NULL, NULL, NULL, "Wampur"},
	{"wba", NULL, NULL, NULL, "Warao"},
	{"wbb", NULL, NULL, NULL, "Wabo"},
	{"wbe", NULL, NULL, NULL, "Waritai"},
	{"wbf", NULL, NULL, NULL, "Wara"},
	{"wbh", NULL, NULL, NULL, "Wanda"},
	{"wbi", NULL, NULL, NULL, "Vwanji"},
	{"wbj", NULL, NULL, NULL, "Alagwa"},
	{"wbk", NULL, NULL, NULL, "Waigali"},
	{"wbl", NULL, NULL, NULL, "Wakhi"},
	{"wbm", NULL, NULL, NULL, "Wa"},
	{"wbp", NULL, NULL, NULL, "Warlpiri"},
	{"wbq", NULL, NULL, NULL, "Waddar"},
	{"wbr", NULL, NULL, NULL, "Wagdi"},
	{"wbs", NULL, NULL, NULL, "West Bengal Sign Language"},
	{"wbt", NULL, NULL, NULL, "Warnman"},
	{"wbv", NULL, NULL, NULL, "Wajarri"},
	{"wbw", NULL, NULL, NULL, "Woi"},
	{"wca", NULL, NULL, NULL, "Yanomámi"},
	{"wci", NULL, NULL, NULL, "Waci Gbe"},
	{"wdd", NULL, NULL, NULL, "Wandji"},
	{"wdg", NULL, NULL, NULL, "Wadaginam"},
	{"wdj", NULL, NULL, NULL, "Wadjiginy"},
	{"wdk", NULL, NULL, NULL, "Wadikali"},
	{"wdu", NULL, NULL, NULL, "Wadjigu"},
	{"wdy", NULL, NULL, NULL, "Wadjabangayi"},
	{"wea", NULL, NULL, NULL, "Wewaw"},
	{"wec", NULL, NULL, NULL, "Wè Western"},
	{"wed", NULL, NULL, NULL, "Wedau"},
	{"weg", NULL, NULL, NULL, "Wergaia"},
	{"weh", NULL, NULL, NULL, "Weh"},
	{"wei", NULL, NULL, NULL, "Kiunum"},
	{"wem", NULL, NULL, NULL, "Weme Gbe"},
	{"weo", NULL, NULL, NULL, "Wemale"},
	{"wep", NULL, NULL, NULL, "Westphalien"},
	{"wer", NULL, NULL, NULL, "Weri"},
	{"wes", NULL, NULL, NULL, "Cameroon Pidgin"},
	{"wet", NULL, NULL, NULL, "Perai"},
	{"weu", NULL, NULL, NULL, "Rawngtu Chin"},
	{"wew", NULL, NULL, NULL, "Wejewa"},
	{"wfg", NULL, NULL, NULL, "Yafi"},
	{"wga", NULL, NULL, NULL, "Wagaya"},
	{"wgb", NULL, NULL, NULL, "Wagawaga"},
	{"wgg", NULL, NULL, NULL, "Wangkangurru"},
	{"wgi", NULL, NULL, NULL, "Wahgi"},
	{"wgo", NULL, NULL, NULL, "Waigeo"},
	{"wgu", NULL, NULL, NULL, "Wirangu"},
	{"wgy", NULL, NULL, NULL, "Warrgamay"},
	{"wha", NULL, NULL, NULL, "Sou Upaa"},
	{"whg", NULL, NULL, NULL, "North Wahgi"},
	{"whk", NULL, NULL, NULL, "Wahau Kenyah"},
	{"whu", NULL, NULL, NULL, "Wahau Kayan"},
	{"wib", NULL, NULL, NULL, "Southern Toussian"},
	{"wic", NULL, NULL, NULL, "Wichita"},
	{"wie", NULL, NULL, NULL, "Wik-Epa"},
	{"wif", NULL, NULL, NULL, "Wik-Keyangan"},
	{"wig", NULL, NULL, NULL, "Wik Ngathan"},
	{"wih", NULL, NULL, NULL, "Wik-Me'anha"},
	{"wii", NULL, NULL, NULL, "Minidien"},
	{"wij", NULL, NULL, NULL, "Wik-Iiyanh"},
	{"wik", NULL, NULL, NULL, "Wikalkan"},
	{"wil", NULL, NULL, NULL, "Wilawila"},
	{"wim", NULL, NULL, NULL, "Wik-Mungkan"},
	{"win", NULL, NULL, NULL, "Ho-Chunk"},
	{"wir", NULL, NULL, NULL, "Wiraféd"},
	{"wiu", NULL, NULL, NULL, "Wiru"},
	{"wiv", NULL, NULL, NULL, "Vitu"},
	{"wiy", NULL, NULL, NULL, "Wiyot"},
	{"wja", NULL, NULL, NULL, "Waja"},
	{"wji", NULL, NULL, NULL, "Warji"},
	{"wka", NULL, NULL, NULL, "Kw'adza"},
	{"wkb", NULL, NULL, NULL, "Kumbaran"},
	{"wkd", NULL, NULL, NULL, "Wakde"},
	{"wkl", NULL, NULL, NULL, "Kalanadi"},
	{"wkr", NULL, NULL, NULL, "Keerray-Woorroong"},
	{"wku", NULL, NULL, NULL, "Kunduvadi"},
	{"wkw", NULL, NULL, NULL, "Wakawaka"},
	{"wky", NULL, NULL, NULL, "Wangkayutyuru"},
	{"wla", NULL, NULL, NULL, "Walio"},
	{"wlc", NULL, NULL, NULL, "Mwali Comorian"},
	{"wle", NULL, NULL, NULL, "Wolane"},
	{"wlg", NULL, NULL, NULL, "Kunbarlang"},
	{"wlh", NULL, NULL, NULL, "Welaun"},
	{"wli", NULL, NULL, NULL, "Waioli"},
	{"wlk", NULL, NULL, NULL, "Wailaki"},
	{"wll", NULL, NULL, NULL, "Wali (Sudan)"},
	{"wlm", NULL, NULL, NULL, "Middle Welsh"},
	{"wln", "wln", "wln", "wa", "Walloon"},
	{"wlo", NULL, NULL, NULL, "Wolio"},
	{"wlr", NULL, NULL, NULL, "Wailapa"},
	{"wls", NULL, NULL, NULL, "Wallisian"},
	{"wlu", NULL, NULL, NULL, "Wuliwuli"},
	{"wlv", NULL, NULL, NULL, "Wichí Lhamtés Vejoz"},
	{"wlw", NULL, NULL, NULL, "Walak"},
	{"wlx", NULL, NULL, NULL, "Wali (Ghana)"},
	{"wly", NULL, NULL, NULL, "Waling"},
	{"wma", NULL, NULL, NULL, "Mawa (Nigeria)"},
	{"wmb", NULL, NULL, NULL, "Wambaya"},
	{"wmc", NULL, NULL, NULL, "Wamas"},
	{"wmd", NULL, NULL, NULL, "Mamaindé"},
	{"wme", NULL, NULL, NULL, "Wambule"},
	{"wmg", NULL, NULL, NULL, "Western Minyag"},
	{"wmh", NULL, NULL, NULL, "Waima'a"},
	{"wmi", NULL, NULL, NULL, "Wamin"},
	{"wmm", NULL, NULL, NULL, "Maiwa (Indonesia)"},
	{"wmn", NULL, NULL, NULL, "Waamwang"},
	{"wmo", NULL, NULL, NULL, "Wom (Papua New Guinea)"},
	{"wms", NULL, NULL, NULL, "Wambon"},
	{"wmt", NULL, NULL, NULL, "Walmajarri"},
	{"wmw", NULL, NULL, NULL, "Mwani"},
	{"wmx", NULL, NULL, NULL, "Womo"},
	{"wnb", NULL, NULL, NULL, "Wanambre"},
	{"wnc", NULL, NULL, NULL, "Wantoat"},
	{"wnd", NULL, NULL, NULL, "Wandarang"},
	{"wne", NULL, NULL, NULL, "Waneci"},
	{"wng", NULL, NULL, NULL, "Wanggom"},
	{"wni", NULL, NULL, NULL, "Ndzwani Comorian"},
	{"wnk", NULL, NULL, NULL, "Wanukaka"},
	{"wnm", NULL, NULL, NULL, "Wanggamala"},
	{"wnn", NULL, NULL, NULL, "Wunumara"},
	{"wno", NULL, NULL, NULL, "Wano"},
	{"wnp", NULL, NULL, NULL, "Wanap"},
	{"wnu", NULL, NULL, NULL, "Usan"},
	{"wnw", NULL, NULL, NULL, "Wintu"},
	{"wny", NULL, NULL, NULL, "Wanyi"},
	{"woa", NULL, NULL, NULL, "Kuwema"},
	{"wob", NULL, NULL, NULL, "Wè Northern"},
	{"woc", NULL, NULL, NULL, "Wogeo"},
	{"wod", NULL, NULL, NULL, "Wolani"},
	{"woe", NULL, NULL, NULL, "Woleaian"},
	{"wof", NULL, NULL, NULL, "Gambian Wolof"},
	{"wog", NULL, NULL, NULL, "Wogamusin"},
	{"woi", NULL, NULL, NULL, "Kamang"},
	{"wok", NULL, NULL, NULL, "Longto"},
	{"wol", "wol", "wol", "wo", "Wolof"},
	{"wom", NULL, NULL, NULL, "Wom (Nigeria)"},
	{"won", NULL, NULL, NULL, "Wongo"},
	{"woo", NULL, NULL, NULL, "Manombai"},
	{"wor", NULL, NULL, NULL, "Woria"},
	{"wos", NULL, NULL, NULL, "Hanga Hundi"},
	{"wow", NULL, NULL, NULL, "Wawonii"},
	{"woy", NULL, NULL, NULL, "Weyto"},
	{"wpc", NULL, NULL, NULL, "Maco"},
	{"wrb", NULL, NULL, NULL, "Waluwarra"},
	{"wrd", NULL, NULL, NULL, "Warduji"},
	{"wrg", NULL, NULL, NULL, "Warungu"},
	{"wrh", NULL, NULL, NULL, "Wiradjuri"},
	{"wri", NULL, NULL, NULL, "Wariyangga"},
	{"wrk", NULL, NULL, NULL, "Garrwa"},
	{"wrl", NULL, NULL, NULL, "Warlmanpa"},
	{"wrm", NULL, NULL, NULL, "Warumungu"},
	{"wrn", NULL, NULL, NULL, "Warnang"},
	{"wro", NULL, NULL, NULL, "Worrorra"},
	{"wrp", NULL, NULL, NULL, "Waropen"},
	{"wrr", NULL, NULL, NULL, "Wardaman"},
	{"wrs", NULL, NULL, NULL, "Waris"},
	{"wru", NULL, NULL, NULL, "Waru"},
	{"wrv", NULL, NULL, NULL, "Waruna"},
	{"wrw", NULL, NULL, NULL, "Gugu Warra"},
	{"wrx", NULL, NULL, NULL, "Wae Rana"},
	{"wry", NULL, NULL, NULL, "Merwari"},
	{"wrz", NULL, NULL, NULL, "Waray (Australia)"},
	{"wsa", NULL, NULL, NULL, "Warembori"},
	{"wsg", NULL, NULL, NULL, "Adilabad Gondi"},
	{"wsi", NULL, NULL, NULL, "Wusi"},
	{"wsk", NULL, NULL, NULL, "Waskia"},
	{"wsr", NULL, NULL, NULL, "Owenia"},
	{"wss", NULL, NULL, NULL, "Wasa"},
	{"wsu", NULL, NULL, NULL, "Wasu"},
	{"wsv", NULL, NULL, NULL, "Wotapuri-Katarqalai"},
	{"wtf", NULL, NULL, NULL, "Watiwa"},
	{"wth", NULL, NULL, NULL, "Wathawurrung"},
	{"wti", NULL, NULL, NULL, "Berta"},
	{"wtk", NULL, NULL, NULL, "Watakataui"},
	{"wtm", NULL, NULL, NULL, "Mewati"},
	{"wtw", NULL, NULL, NULL, "Wotu"},
	{"wua", NULL, NULL, NULL, "Wikngenchera"},
	{"wub", NULL, NULL, NULL, "Wunambal"},
	{"wud", NULL, NULL, NULL, "Wudu"},
	{"wuh", NULL, NULL, NULL, "Wutunhua"},
	{"wul", NULL, NULL, NULL, "Silimo"},
	{"wum", NULL, NULL, NULL, "Wumbvu"},
	{"wun", NULL, NULL, NULL, "Bungu"},
	{"wur", NULL, NULL, NULL, "Wurrugu"},
	{"wut", NULL, NULL, NULL, "Wutung"},
	{"wuu", NULL, NULL, NULL, "Wu Chinese"},
	{"wuv", NULL, NULL, NULL, "Wuvulu-Aua"},
	{"wux", NULL, NULL, NULL, "Wulna"},
	{"wuy", NULL, NULL, NULL, "Wauyai"},
	{"wwa", NULL, NULL, NULL, "Waama"},
	{"wwb", NULL, NULL, NULL, "Wakabunga"},
	{"wwo", NULL, NULL, NULL, "Wetamut"},
	{"wwr", NULL, NULL, NULL, "Warrwa"},
	{"www", NULL, NULL, NULL, "Wawa"},
	{"wxa", NULL, NULL, NULL, "Waxianghua"},
	{"wxw", NULL, NULL, NULL, "Wardandi"},
	{"wya", NULL, NULL, NULL, "Wyandot"},
	{"wyb", NULL, NULL, NULL, "Wangaaybuwan-Ngiyambaa"},
	{"wyi", NULL, NULL, NULL, "Woiwurrung"},
	{"wym", NULL, NULL, NULL, "Wymysorys"},
	{"wyr", NULL, NULL, NULL, "Wayoró"},
	{"wyy", NULL, NULL, NULL, "Western Fijian"},
	{"xaa", NULL, NULL, NULL, "Andalusian Arabic"},
	{"xab", NULL, NULL, NULL, "Sambe"},
	{"xac", NULL, NULL, NULL, "Kachari"},
	{"xad", NULL, NULL, NULL, "Adai"},
	{"xae", NULL, NULL, NULL, "Aequian"},
	{"xag", NULL, NULL, NULL, "Aghwan"},
	{"xai", NULL, NULL, NULL, "Kaimbé"},
	{"xaj", NULL, NULL, NULL, "Ararandewára"},
	{"xak", NULL, NULL, NULL, "Máku"},
	{"xal", "xal", "xal", NULL, "Kalmyk"},
	{"xam", NULL, NULL, NULL, "ǀXam"},
	{"xan", NULL, NULL, NULL, "Xamtanga"},
	{"xao", NULL, NULL, NULL, "Khao"},
	{"xap", NULL, NULL, NULL, "Apalachee"},
	{"xaq", NULL, NULL, NULL, "Aquitanian"},
	{"xar", NULL, NULL, NULL, "Karami"},
	{"xas", NULL, NULL, NULL, "Kamas"},
	{"xat", NULL, NULL, NULL, "Katawixi"},
	{"xau", NULL, NULL, NULL, "Kauwera"},
	{"xav", NULL, NULL, NULL, "Xavánte"},
	{"xaw", NULL, NULL, NULL, "Kawaiisu"},
	{"xay", NULL, NULL, NULL, "Kayan Mahakam"},
	{"xbb", NULL, NULL, NULL, "Lower Burdekin"},
	{"xbc", NULL, NULL, NULL, "Bactrian"},
	{"xbd", NULL, NULL, NULL, "Bindal"},
	{"xbe", NULL, NULL, NULL, "Bigambal"},
	{"xbg", NULL, NULL, NULL, "Bunganditj"},
	{"xbi", NULL, NULL, NULL, "Kombio"},
	{"xbj", NULL, NULL, NULL, "Birrpayi"},
	{"xbm", NULL, NULL, NULL, "Middle Breton"},
	{"xbn", NULL, NULL, NULL, "Kenaboi"},
	{"xbo", NULL, NULL, NULL, "Bolgarian"},
	{"xbp", NULL, NULL, NULL, "Bibbulman"},
	{"xbr", NULL, NULL, NULL, "Kambera"},
	{"xbw", NULL, NULL, NULL, "Kambiwá"},
	{"xby", NULL, NULL, NULL, "Batjala"},
	{"xcb", NULL, NULL, NULL, "Cumbric"},
	{"xcc", NULL, NULL, NULL, "Camunic"},
	{"xce", NULL, NULL, NULL, "Celtiberian"},
	{"xcg", NULL, NULL, NULL, "Cisalpine Gaulish"},
	{"xch", NULL, NULL, NULL, "Chemakum"},
	{"xcl", NULL, NULL, NULL, "Classical Armenian"},
	{"xcm", NULL, NULL, NULL, "Comecrudo"},
	{"xcn", NULL, NULL, NULL, "Cotoname"},
	{"xco", NULL, NULL, NULL, "Chorasmian"},
	{"xcr", NULL, NULL, NULL, "Carian"},
	{"xct", NULL, NULL, NULL, "Classical Tibetan"},
	{"xcu", NULL, NULL, NULL, "Curonian"},
	{"xcv", NULL, NULL, NULL, "Chuvantsy"},
	{"xcw", NULL, NULL, NULL, "Coahuilteco"},
	{"xcy", NULL, NULL, NULL, "Cayuse"},
	{"xda", NULL, NULL, NULL, "Darkinyung"},
	{"xdc", NULL, NULL, NULL, "Dacian"},
	{"xdk", NULL, NULL, NULL, "Dharuk"},
	{"xdm", NULL, NULL, NULL, "Edomite"},
	{"xdo", NULL, NULL, NULL, "Kwandu"},
	{"xdy", NULL, NULL, NULL, "Malayic Dayak"},
	{"xeb", NULL, NULL, NULL, "Eblan"},
	{"xed", NULL, NULL, NULL, "Hdi"},
	{"xeg", NULL, NULL, NULL, "ǁXegwi"},
	{"xel", NULL, NULL, NULL, "Kelo"},
	{"xem", NULL, NULL, NULL, "Kembayan"},
	{"xep", NULL, NULL, NULL, "Epi-Olmec"},
	{"xer", NULL, NULL, NULL, "Xerénte"},
	{"xes", NULL, NULL, NULL, "Kesawai"},
	{"xet", NULL, NULL, NULL, "Xetá"},
	{"xeu", NULL, NULL, NULL, "Keoru-Ahia"},
	{"xfa", NULL, NULL, NULL, "Faliscan"},
	{"xga", NULL, NULL, NULL, "Galatian"},
	{"xgb", NULL, NULL, NULL, "Gbin"},
	{"xgd", NULL, NULL, NULL, "Gudang"},
	{"xgf", NULL, NULL, NULL, "Gabrielino-Fernandeño"},
	{"xgg", NULL, NULL, NULL, "Goreng"},
	{"xgi", NULL, NULL, NULL, "Garingbal"},
	{"xgl", NULL, NULL, NULL, "Galindan"},
	{"xgm", NULL, NULL, NULL, "Dharumbal"},
	{"xgr", NULL, NULL, NULL, "Garza"},
	{"xgu", NULL, NULL, NULL, "Unggumi"},
	{"xgw", NULL, NULL, NULL, "Guwa"},
	{"xha", NULL, NULL, NULL, "Harami"},
	{"xhc", NULL, NULL, NULL, "Hunnic"},
	{"xhd", NULL, NULL, NULL, "Hadrami"},
	{"xhe", NULL, NULL, NULL, "Khetrani"},
	{"xho", "xho", "xho", "xh", "Xhosa"},
	{"xhr", NULL, NULL, NULL, "Hernican"},
	{"xht", NULL, NULL, NULL, "Hattic"},
	{"xhu", NULL, NULL, NULL, "Hurrian"},
	{"xhv", NULL, NULL, NULL, "Khua"},
	{"xib", NULL, NULL, NULL, "Iberian"},
	{"xii", NULL, NULL, NULL, "Xiri"},
	{"xil", NULL, NULL, NULL, "Illyrian"},
	{"xin", NULL, NULL, NULL, "Xinca"},
	{"xir", NULL, NULL, NULL, "Xiriâna"},
	{"xis", NULL, NULL, NULL, "Kisan"},
	{"xiv", NULL, NULL, NULL, "Indus Valley Language"},
	{"xiy", NULL, NULL, NULL, "Xipaya"},
	{"xjb", NULL, NULL, NULL, "Minjungbal"},
	{"xjt", NULL, NULL, NULL, "Jaitmatang"},
	{"xka", NULL, NULL, NULL, "Kalkoti"},
	{"xkb", NULL, NULL, NULL, "Northern Nago"},
	{"xkc", NULL, NULL, NULL, "Kho'ini"},
	{"xkd", NULL, NULL, NULL, "Mendalam Kayan"},
	{"xke", NULL, NULL, NULL, "Kereho"},
	{"xkf", NULL, NULL, NULL, "Khengkha"},
	{"xkg", NULL, NULL, NULL, "Kagoro"},
	{"xki", NULL, NULL, NULL, "Kenyan Sign Language"},
	{"xkj", NULL, NULL, NULL, "Kajali"},
	{"xkk", NULL, NULL, NULL, "Kaco'"},
	{"xkl", NULL, NULL, NULL, "Mainstream Kenyah"},
	{"xkn", NULL, NULL, NULL, "Kayan River Kayan"},
	{"xko", NULL, NULL, NULL, "Kiorr"},
	{"xkp", NULL, NULL, NULL, "Kabatei"},
	{"xkq", NULL, NULL, NULL, "Koroni"},
	{"xkr", NULL, NULL, NULL, "Xakriabá"},
	{"xks", NULL, NULL, NULL, "Kumbewaha"},
	{"xkt", NULL, NULL, NULL, "Kantosi"},
	{"xku", NULL, NULL, NULL, "Kaamba"},
	{"xkv", NULL, NULL, NULL, "Kgalagadi"},
	{"xkw", NULL, NULL, NULL, "Kembra"},
	{"xkx", NULL, NULL, NULL, "Karore"},
	{"xky", NULL, NULL, NULL, "Uma' Lasan"},
	{"xkz", NULL, NULL, NULL, "Kurtokha"},
	{"xla", NULL, NULL, NULL, "Kamula"},
	{"xlb", NULL, NULL, NULL, "Loup B"},
	{"xlc", NULL, NULL, NULL, "Lycian"},
	{"xld", NULL, NULL, NULL, "Lydian"},
	{"xle", NULL, NULL, NULL, "Lemnian"},
	{"xlg", NULL, NULL, NULL, "Ligurian (Ancient)"},
	{"xli", NULL, NULL, NULL, "Liburnian"},
	{"xln", NULL, NULL, NULL, "Alanic"},
	{"xlo", NULL, NULL, NULL, "Loup A"},
	{"xlp", NULL, NULL, NULL, "Lepontic"},
	{"xls", NULL, NULL, NULL, "Lusitanian"},
	{"xlu", NULL, NULL, NULL, "Cuneiform Luwian"},
	{"xly", NULL, NULL, NULL, "Elymian"},
	{"xma", NULL, NULL, NULL, "Mushungulu"},
	{"xmb", NULL, NULL, NULL, "Mbonga"},
	{"xmc", NULL, NULL, NULL, "Makhuwa-Marrevone"},
	{"xmd", NULL, NULL, NULL, "Mbudum"},
	{"xme", NULL, NULL, NULL, "Median"},
	{"xmf", NULL, NULL, NULL, "Mingrelian"},
	{"xmg", NULL, NULL, NULL, "Mengaka"},
	{"xmh", NULL, NULL, NULL, "Kugu-Muminh"},
	{"xmj", NULL, NULL, NULL, "Majera"},
	{"xmk", NULL, NULL, NULL, "Ancient Macedonian"},
	{"xml", NULL, NULL, NULL, "Malaysian Sign Language"},
	{"xmm", NULL, NULL, NULL, "Manado Malay"},
	{"xmn", NULL, NULL, NULL, "Manichaean Middle Persian"},
	{"xmo", NULL, NULL, NULL, "Morerebi"},
	{"xmp", NULL, NULL, NULL, "Kuku-Mu'inh"},
	{"xmq", NULL, NULL, NULL, "Kuku-Mangk"},
	{"xmr", NULL, NULL, NULL, "Meroitic"},
	{"xms", NULL, NULL, NULL, "Moroccan Sign Language"},
	{"xmt", NULL, NULL, NULL, "Matbat"},
	{"xmu", NULL, NULL, NULL, "Kamu"},
	{"xmv", NULL, NULL, NULL, "Antankarana Malagasy"},
	{"xmw", NULL, NULL, NULL, "Tsimihety Malagasy"},
	{"xmx", NULL, NULL, NULL, "Maden"},
	{"xmy", NULL, NULL, NULL, "Mayaguduna"},
	{"xmz", NULL, NULL, NULL, "Mori Bawah"},
	{"xna", NULL, NULL, NULL, "Ancient North Arabian"},
	{"xnb", NULL, NULL, NULL, "Kanakanabu"},
	{"xng", NULL, NULL, NULL, "Middle Mongolian"},
	{"xnh", NULL, NULL, NULL, "Kuanhua"},
	{"xni", NULL, NULL, NULL, "Ngarigu"},
	{"xnj", NULL, NULL, NULL, "Ngoni (Tanzania)"},
	{"xnk", NULL, NULL, NULL, "Nganakarti"},
	{"xnm", NULL, NULL, NULL, "Ngumbarl"},
	{"xnn", NULL, NULL, NULL, "Northern Kankanay"},
	{"xno", NULL, NULL, NULL, "Anglo-Norman"},
	{"xnq", NULL, NULL, NULL, "Ngoni (Mozambique)"},
	{"xnr", NULL, NULL, NULL, "Kangri"},
	{"xns", NULL, NULL, NULL, "Kanashi"},
	{"xnt", NULL, NULL, NULL, "Narragansett"},
	{"xnu", NULL, NULL, NULL, "Nukunul"},
	{"xny", NULL, NULL, NULL, "Nyiyaparli"},
	{"xnz", NULL, NULL, NULL, "Kenzi"},
	{"xoc", NULL, NULL, NULL, "O'chi'chi'"},
	{"xod", NULL, NULL, NULL, "Kokoda"},
	{"xog", NULL, NULL, NULL, "Soga"},
	{"xoi", NULL, NULL, NULL, "Kominimung"},
	{"xok", NULL, NULL, NULL, "Xokleng"},
	{"xom", NULL, NULL, NULL, "Komo (Sudan)"},
	{"xon", NULL, NULL, NULL, "Konkomba"},
	{"xoo", NULL, NULL, NULL, "Xukurú"},
	{"xop", NULL, NULL, NULL, "Kopar"},
	{"xor", NULL, NULL, NULL, "Korubo"},
	{"xow", NULL, NULL, NULL, "Kowaki"},
	{"xpa", NULL, NULL, NULL, "Pirriya"},
	{"xpb", NULL, NULL, NULL, "Northeastern Tasmanian"},
	{"xpc", NULL, NULL, NULL, "Pecheneg"},
	{"xpd", NULL, NULL, NULL, "Oyster Bay Tasmanian"},
	{"xpe", NULL, NULL, NULL, "Liberia Kpelle"},
	{"xpf", NULL, NULL, NULL, "Southeast Tasmanian"},
	{"xpg", NULL, NULL, NULL, "Phrygian"},
	{"xph", NULL, NULL, NULL, "North Midlands Tasmanian"},
	{"xpi", NULL, NULL, NULL, "Pictish"},
	{"xpj", NULL, NULL, NULL, "Mpalitjanh"},
	{"xpk", NULL, NULL, NULL, "Kulina Pano"},
	{"xpl", NULL, NULL, NULL, "Port Sorell Tasmanian"},
	{"xpm", NULL, NULL, NULL, "Pumpokol"},
	{"xpn", NULL, NULL, NULL, "Kapinawá"},
	{"xpo", NULL, NULL, NULL, "Pochutec"},
	{"xpp", NULL, NULL, NULL, "Puyo-Paekche"},
	{"xpq", NULL, NULL, NULL, "Mohegan-Pequot"},
	{"xpr", NULL, NULL, NULL, "Parthian"},
	{"xps", NULL, NULL, NULL, "Pisidian"},
	{"xpt", NULL, NULL, NULL, "Punthamara"},
	{"xpu", NULL, NULL, NULL, "Punic"},
	{"xpv", NULL, NULL, NULL, "Northern Tasmanian"},
	{"xpw", NULL, NULL, NULL, "Northwestern Tasmanian"},
	{"xpx", NULL, NULL, NULL, "Southwestern Tasmanian"},
	{"xpy", NULL, NULL, NULL, "Puyo"},
	{"xpz", NULL, NULL, NULL, "Bruny Island Tasmanian"},
	{"xqa", NULL, NULL, NULL, "Karakhanid"},
	{"xqt", NULL, NULL, NULL, "Qatabanian"},
	{"xra", NULL, NULL, NULL, "Krahô"},
	{"xrb", NULL, NULL, NULL, "Eastern Karaboro"},
	{"xrd", NULL, NULL, NULL, "Gundungurra"},
	{"xre", NULL, NULL, NULL, "Kreye"},
	{"xrg", NULL, NULL, NULL, "Minang"},
	{"xri", NULL, NULL, NULL, "Krikati-Timbira"},
	{"xrm", NULL, NULL, NULL, "Armazic"},
	{"xrn", NULL, NULL, NULL, "Arin"},
	{"xrr", NULL, NULL, NULL, "Raetic"},
	{"xrt", NULL, NULL, NULL, "Aranama-Tamique"},
	{"xru", NULL, NULL, NULL, "Marriammu"},
	{"xrw", NULL, NULL, NULL, "Karawa"},
	{"xsa", NULL, NULL, NULL, "Sabaean"},
	{"xsb", NULL, NULL, NULL, "Sambal"},
	{"xsc", NULL, NULL, NULL, "Scythian"},
	{"xsd", NULL, NULL, NULL, "Sidetic"},
	{"xse", NULL, NULL, NULL, "Sempan"},
	{"xsh", NULL, NULL, NULL, "Shamang"},
	{"xsi", NULL, NULL, NULL, "Sio"},
	{"xsj", NULL, NULL, NULL, "Subi"},
	{"xsl", NULL, NULL, NULL, "South Slavey"},
	{"xsm", NULL, NULL, NULL, "Kasem"},
	{"xsn", NULL, NULL, NULL, "Sanga (Nigeria)"},
	{"xso", NULL, NULL, NULL, "Solano"},
	{"xsp", NULL, NULL, NULL, "Silopi"},
	{"xsq", NULL, NULL, NULL, "Makhuwa-Saka"},
	{"xsr", NULL, NULL, NULL, "Sherpa"},
	{"xss", NULL, NULL, NULL, "Assan"},
	{"xsu", NULL, NULL, NULL, "Sanumá"},
	{"xsv", NULL, NULL, NULL, "Sudovian"},
	{"xsy", NULL, NULL, NULL, "Saisiyat"},
	{"xta", NULL, NULL, NULL, "Alcozauca Mixtec"},
	{"xtb", NULL, NULL, NULL, "Chazumba Mixtec"},
	{"xtc", NULL, NULL, NULL, "Katcha-Kadugli-Miri"},
	{"xtd", NULL, NULL, NULL, "Diuxi-Tilantongo Mixtec"},
	{"xte", NULL, NULL, NULL, "Ketengban"},
	{"xtg", NULL, NULL, NULL, "Transalpine Gaulish"},
	{"xth", NULL, NULL, NULL, "Yitha Yitha"},
	{"xti", NULL, NULL, NULL, "Sinicahua Mixtec"},
	{"xtj", NULL, NULL, NULL, "San Juan Teita Mixtec"},
	{"xtl", NULL, NULL, NULL, "Tijaltepec Mixtec"},
	{"xtm", NULL, NULL, NULL, "Magdalena Peñasco Mixtec"},
	{"xtn", NULL, NULL, NULL, "Northern Tlaxiaco Mixtec"},
	{"xto", NULL, NULL, NULL, "Tokharian A"},
	{"xtp", NULL, NULL, NULL, "San Miguel Piedras Mixtec"},
	{"xtq", NULL, NULL, NULL, "Tumshuqese"},
	{"xtr", NULL, NULL, NULL, "Early Tripuri"},
	{"xts", NULL, NULL, NULL, "Sindihui Mixtec"},
	{"xtt", NULL, NULL, NULL, "Tacahua Mixtec"},
	{"xtu", NULL, NULL, NULL, "Cuyamecalco Mixtec"},
	{"xtv", NULL, NULL, NULL, "Thawa"},
	{"xtw", NULL, NULL, NULL, "Tawandê"},
	{"xty", NULL, NULL, NULL, "Yoloxochitl Mixtec"},
	{"xua", NULL, NULL, NULL, "Alu Kurumba"},
	{"xub", NULL, NULL, NULL, "Betta Kurumba"},
	{"xud", NULL, NULL, NULL, "Umiida"},
	{"xug", NULL, NULL, NULL, "Kunigami"},
	{"xuj", NULL, NULL, NULL, "Jennu Kurumba"},
	{"xul", NULL, NULL, NULL, "Ngunawal"},
	{"xum", NULL, NULL, NULL, "Umbrian"},
	{"xun", NULL, NULL, NULL, "Unggaranggu"},
	{"xuo", NULL, NULL, NULL, "Kuo"},
	{"xup", NULL, NULL, NULL, "Upper Umpqua"},
	{"xur", NULL, NULL, NULL, "Urartian"},
	{"xut", NULL, NULL, NULL, "Kuthant"},
	{"xuu", NULL, NULL, NULL, "Kxoe"},
	{"xve", NULL, NULL, NULL, "Venetic"},
	{"xvi", NULL, NULL, NULL, "Kamviri"},
	{"xvn", NULL, NULL, NULL, "Vandalic"},
	{"xvo", NULL, NULL, NULL, "Volscian"},
	{"xvs", NULL, NULL, NULL, "Vestinian"},
	{"xwa", NULL, NULL, NULL, "Kwaza"},
	{"xwc", NULL, NULL, NULL, "Woccon"},
	{"xwd", NULL, NULL, NULL, "Wadi Wadi"},
	{"xwe", NULL, NULL, NULL, "Xwela Gbe"},
	{"xwg", NULL, NULL, NULL, "Kwegu"},
	{"xwj", NULL, NULL, NULL, "Wajuk"},
	{"xwk", NULL, NULL, NULL, "Wangkumara"},
	{"xwl", NULL, NULL, NULL, "Western Xwla Gbe"},
	{"xwo", NULL, NULL, NULL, "Written Oirat"},
	{"xwr", NULL, NULL, NULL, "Kwerba Mamberamo"},
	{"xwt", NULL, NULL, NULL, "Wotjobaluk"},
	{"xww", NULL, NULL, NULL, "Wemba Wemba"},
	{"xxb", NULL, NULL, NULL, "Boro (Ghana)"},
	{"xxk", NULL, NULL, NULL, "Ke'o"},
	{"xxm", NULL, NULL, NULL, "Minkin"},
	{"xxr", NULL, NULL, NULL, "Koropó"},
	{"xxt", NULL, NULL, NULL, "Tambora"},
	{"xya", NULL, NULL, NULL, "Yaygir"},
	{"xyb", NULL, NULL, NULL, "Yandjibara"},
	{"xyj", NULL, NULL, NULL, "Mayi-Yapi"},
	{"xyk", NULL, NULL, NULL, "Mayi-Kulan"},
	{"xyl", NULL, NULL, NULL, "Yalakalore"},
	{"xyt", NULL, NULL, NULL, "Mayi-Thakurti"},
	{"xyy", NULL, NULL, NULL, "Yorta Yorta"},
	{"xzh", NULL, NULL, NULL, "Zhang-Zhung"},
	{"xzm", NULL, NULL, NULL, "Zemgalian"},
	{"xzp", NULL, NULL, NULL, "Ancient Zapotec"},
	{"yaa", NULL, NULL, NULL, "Yaminahua"},
	{"yab", NULL, NULL, NULL, "Yuhup"},
	{"yac", NULL, NULL, NULL, "Pass Valley Yali"},
	{"yad", NULL, NULL, NULL, "Yagua"},
	{"yae", NULL, NULL, NULL, "Pumé"},
	{"yaf", NULL, NULL, NULL, "Yaka (Democratic Republic of Congo)"},
	{"yag", NULL, NULL, NULL, "Yámana"},
	{"yah", NULL, NULL, NULL, "Yazgulyam"},
	{"yai", NULL, NULL, NULL, "Yagnobi"},
	{"yaj", NULL, NULL, NULL, "Banda-Yangere"},
	{"yak", NULL, NULL, NULL, "Yakama"},
	{"yal", NULL, NULL, NULL, "Yalunka"},
	{"yam", NULL, NULL, NULL, "Yamba"},
	{"yan", NULL, NULL, NULL, "Mayangna"},
	{"yao", "yao", "yao", NULL, "Yao"},
	{"yap", "yap", "yap", NULL, "Yapese"},
	{"yaq", NULL, NULL, NULL, "Yaqui"},
	{"yar", NULL, NULL, NULL, "Yabarana"},
	{"yas", NULL, NULL, NULL, "Nugunu (Cameroon)"},
	{"yat", NULL, NULL, NULL, "Yambeta"},
	{"yau", NULL, NULL, NULL, "Yuwana"},
	{"yav", NULL, NULL, NULL, "Yangben"},
	{"yaw", NULL, NULL, NULL, "Yawalapití"},
	{"yax", NULL, NULL, NULL, "Yauma"},
	{"yay", NULL, NULL, NULL, "Agwagwune"},
	{"yaz", NULL, NULL, NULL, "Lokaa"},
	{"yba", NULL, NULL, NULL, "Yala"},
	{"ybb", NULL, NULL, NULL, "Yemba"},
	{"ybe", NULL, NULL, NULL, "West Yugur"},
	{"ybh", NULL, NULL, NULL, "Yakha"},
	{"ybi", NULL, NULL, NULL, "Yamphu"},
	{"ybj", NULL, NULL, NULL, "Hasha"},
	{"ybk", NULL, NULL, NULL, "Bokha"},
	{"ybl", NULL, NULL, NULL, "Yukuben"},
	{"ybm", NULL, NULL, NULL, "Yaben"},
	{"ybn", NULL, NULL, NULL, "Yabaâna"},
	{"ybo", NULL, NULL, NULL, "Yabong"},
	{"ybx", NULL, NULL, NULL, "Yawiyo"},
	{"yby", NULL, NULL, NULL, "Yaweyuha"},
	{"ych", NULL, NULL, NULL, "Chesu"},
	{"ycl", NULL, NULL, NULL, "Lolopo"},
	{"ycn", NULL, NULL, NULL, "Yucuna"},
	{"ycp", NULL, NULL, NULL, "Chepya"},
	{"yda", NULL, NULL, NULL, "Yanda"},
	{"ydd", NULL, NULL, NULL, "Eastern Yiddish"},
	{"yde", NULL, NULL, NULL, "Yangum Dey"},
	{"ydg", NULL, NULL, NULL, "Yidgha"},
	{"ydk", NULL, NULL, NULL, "Yoidik"},
	{"yea", NULL, NULL, NULL, "Ravula"},
	{"yec", NULL, NULL, NULL, "Yeniche"},
	{"yee", NULL, NULL, NULL, "Yimas"},
	{"yei", NULL, NULL, NULL, "Yeni"},
	{"yej", NULL, NULL, NULL, "Yevanic"},
	{"yel", NULL, NULL, NULL, "Yela"},
	{"yer", NULL, NULL, NULL, "Tarok"},
	{"yes", NULL, NULL, NULL, "Nyankpa"},
	{"yet", NULL, NULL, NULL, "Yetfa"},
	{"yeu", NULL, NULL, NULL, "Yerukula"},
	{"yev", NULL, NULL, NULL, "Yapunda"},
	{"yey", NULL, NULL, NULL, "Yeyi"},
	{"yga", NULL, NULL, NULL, "Malyangapa"},
	{"ygi", NULL, NULL, NULL, "Yiningayi"},
	{"ygl", NULL, NULL, NULL, "Yangum Gel"},
	{"ygm", NULL, NULL, NULL, "Yagomi"},
	{"ygp", NULL, NULL, NULL, "Gepo"},
	{"ygr", NULL, NULL, NULL, "Yagaria"},
	{"ygs", NULL, NULL, NULL, "Yolŋu Sign Language"},
	{"ygu", NULL, NULL, NULL, "Yugul"},
	{"ygw", NULL, NULL, NULL, "Yagwoia"},
	{"yha", NULL, NULL, NULL, "Baha Buyang"},
	{"yhd", NULL, NULL, NULL, "Judeo-Iraqi Arabic"},
	{"yhl", NULL, NULL, NULL, "Hlepho Phowa"},
	{"yhs", NULL, NULL, NULL, "Yan-nhaŋu Sign Language"},
	{"yia", NULL, NULL, NULL, "Yinggarda"},
	{"yid", "yid", "yid", "yi", "Yiddish"},
	{"yif", NULL, NULL, NULL, "Ache"},
	{"yig", NULL, NULL, NULL, "Wusa Nasu"},
	{"yih", NULL, NULL, NULL, "Western Yiddish"},
	{"yii", NULL, NULL, NULL, "Yidiny"},
	{"yij", NULL, NULL, NULL, "Yindjibarndi"},
	{"yik", NULL, NULL, NULL, "Dongshanba Lalo"},
	{"yil", NULL, NULL, NULL, "Yindjilandji"},
	{"yim", NULL, NULL, NULL, "Yimchungru Naga"},
	{"yin", NULL, NULL, NULL, "Riang Lai"},
	{"yip", NULL, NULL, NULL, "Pholo"},
	{"yiq", NULL, NULL, NULL, "Miqie"},
	{"yir", NULL, NULL, NULL, "North Awyu"},
	{"yis", NULL, NULL, NULL, "Yis"},
	{"yit", NULL, NULL, NULL, "Eastern Lalu"},
	{"yiu", NULL, NULL, NULL, "Awu"},
	{"yiv", NULL, NULL, NULL, "Northern Nisu"},
	{"yix", NULL, NULL, NULL, "Axi Yi"},
	{"yiz", NULL, NULL, NULL, "Azhe"},
	{"yka", NULL, NULL, NULL, "Yakan"},
	{"ykg", NULL, NULL, NULL, "Northern Yukaghir"},
	{"yki", NULL, NULL, NULL, "Yoke"},
	{"ykk", NULL, NULL, NULL, "Yakaikeke"},
	{"ykl", NULL, NULL, NULL, "Khlula"},
	{"ykm", NULL, NULL, NULL, "Kap"},
	{"ykn", NULL, NULL, NULL, "Kua-nsi"},
	{"yko", NULL, NULL, NULL, "Yasa"},
	{"ykr", NULL, NULL, NULL, "Yekora"},
	{"ykt", NULL, NULL, NULL, "Kathu"},
	{"yku", NULL, NULL, NULL, "Kuamasi"},
	{"yky", NULL, NULL, NULL, "Yakoma"},
	{"yla", NULL, NULL, NULL, "Yaul"},
	{"ylb", NULL, NULL, NULL, "Yaleba"},
	{"yle", NULL, NULL, NULL, "Yele"},
	{"ylg", NULL, NULL, NULL, "Yelogu"},
	{"yli", NULL, NULL, NULL, "Angguruk Yali"},
	{"yll", NULL, NULL, NULL, "Yil"},
	{"ylm", NULL, NULL, NULL, "Limi"},
	{"yln", NULL, NULL, NULL, "Langnian Buyang"},
	{"ylo", NULL, NULL, NULL, "Naluo Yi"},
	{"ylr", NULL, NULL, NULL, "Yalarnnga"},
	{"ylu", NULL, NULL, NULL, "Aribwaung"},
	{"yly", NULL, NULL, NULL, "Nyâlayu"},
	{"ymb", NULL, NULL, NULL, "Yambes"},
	{"ymc", NULL, NULL, NULL, "Southern Muji"},
	{"ymd", NULL, NULL, NULL, "Muda"},
	{"yme", NULL, NULL, NULL, "Yameo"},
	{"ymg", NULL, NULL, NULL, "Yamongeri"},
	{"ymh", NULL, NULL, NULL, "Mili"},
	{"ymi", NULL, NULL, NULL, "Moji"},
	{"ymk", NULL, NULL, NULL, "Makwe"},
	{"yml", NULL, NULL, NULL, "Iamalele"},
	{"ymm", NULL, NULL, NULL, "Maay"},
	{"ymn", NULL, NULL, NULL, "Yamna"},
	{"ymo", NULL, NULL, NULL, "Yangum Mon"},
	{"ymp", NULL, NULL, NULL, "Yamap"},
	{"ymq", NULL, NULL, NULL, "Qila Muji"},
	{"ymr", NULL, NULL, NULL, "Malasar"},
	{"yms", NULL, NULL, NULL, "Mysian"},
	{"ymx", NULL, NULL, NULL, "Northern Muji"},
	{"ymz", NULL, NULL, NULL, "Muzi"},
	{"yna", NULL, NULL, NULL, "Aluo"},
	{"ynd", NULL, NULL, NULL, "Yandruwandha"},
	{"yne", NULL, NULL, NULL, "Lang'e"},
	{"yng", NULL, NULL, NULL, "Yango"},
	{"ynk", NULL, NULL, NULL, "Naukan Yupik"},
	{"ynl", NULL, NULL, NULL, "Yangulam"},
	{"ynn", NULL, NULL, NULL, "Yana"},
	{"yno", NULL, NULL, NULL, "Yong"},
	{"ynq", NULL, NULL, NULL, "Yendang"},
	{"yns", NULL, NULL, NULL, "Yansi"},
	{"ynu", NULL, NULL, NULL, "Yahuna"},
	{"yob", NULL, NULL, NULL, "Yoba"},
	{"yog", NULL, NULL, NULL, "Yogad"},
	{"yoi", NULL, NULL, NULL, "Yonaguni"},
	{"yok", NULL, NULL, NULL, "Yokuts"},
	{"yol", NULL, NULL, NULL, "Yola"},
	{"yom", NULL, NULL, NULL, "Yombe"},
	{"yon", NULL, NULL, NULL, "Yongkom"},
	{"yor", "yor", "yor", "yo", "Yoruba"},
	{"yot", NULL, NULL, NULL, "Yotti"},
	{"yox", NULL, NULL, NULL, "Yoron"},
	{"yoy", NULL, NULL, NULL, "Yoy"},
	{"ypa", NULL, NULL, NULL, "Phala"},
	{"ypb", NULL, NULL, NULL, "Labo Phowa"},
	{"ypg", NULL, NULL, NULL, "Phola"},
	{"yph", NULL, NULL, NULL, "Phupha"},
	{"ypm", NULL, NULL, NULL, "Phuma"},
	{"ypn", NULL, NULL, NULL, "Ani Phowa"},
	{"ypo", NULL, NULL, NULL, "Alo Phola"},
	{"ypp", NULL, NULL, NULL, "Phupa"},
	{"ypz", NULL, NULL, NULL, "Phuza"},
	{"yra", NULL, NULL, NULL, "Yerakai"},
	{"yrb", NULL, NULL, NULL, "Yareba"},
	{"yre", NULL, NULL, NULL, "Yaouré"},
	{"yrk", NULL, NULL, NULL, "Nenets"},
	{"yrl", NULL, NULL, NULL, "Nhengatu"},
	{"yrm", NULL, NULL, NULL, "Yirrk-Mel"},
	{"yrn", NULL, NULL, NULL, "Yerong"},
	{"yro", NULL, NULL, NULL, "Yaroamë"},
	{"yrs", NULL, NULL, NULL, "Yarsun"},
	{"yrw", NULL, NULL, NULL, "Yarawata"},
	{"yry", NULL, NULL, NULL, "Yarluyandi"},
	{"ysc", NULL, NULL, NULL, "Yassic"},
	{"ysd", NULL, NULL, NULL, "Samatao"},
	{"ysg", NULL, NULL, NULL, "Sonaga"},
	{"ysl", NULL, NULL, NULL, "Yugoslavian Sign Language"},
	{"ysm", NULL, NULL, NULL, "Myanmar Sign Language"},
	{"ysn", NULL, NULL, NULL, "Sani"},
	{"yso", NULL, NULL, NULL, "Nisi (China)"},
	{"ysp", NULL, NULL, NULL, "Southern Lolopo"},
	{"ysr", NULL, NULL, NULL, "Sirenik Yupik"},
	{"yss", NULL, NULL, NULL, "Yessan-Mayo"},
	{"ysy", NULL, NULL, NULL, "Sanie"},
	{"yta", NULL, NULL, NULL, "Talu"},
	{"ytl", NULL, NULL, NULL, "Tanglang"},
	{"ytp", NULL, NULL, NULL, "Thopho"},
	{"ytw", NULL, NULL, NULL, "Yout Wam"},
	{"yty", NULL, NULL, NULL, "Yatay"},
	{"yua", NULL, NULL, NULL, "Yucateco"},
	{"yub", NULL, NULL, NULL, "Yugambal"},
	{"yuc", NULL, NULL, NULL, "Yuchi"},
	{"yud", NULL, NULL, NULL, "Judeo-Tripolitanian Arabic"},
	{"yue", NULL, NULL, NULL, "Yue Chinese"},
	{"yuf", NULL, NULL, NULL, "Havasupai-Walapai-Yavapai"},
	{"yug", NULL, NULL, NULL, "Yug"},
	{"yui", NULL, NULL, NULL, "Yurutí"},
	{"yuj", NULL, NULL, NULL, "Karkar-Yuri"},
	{"yuk", NULL, NULL, NULL, "Yuki"},
	{"yul", NULL, NULL, NULL, "Yulu"},
	{"yum", NULL, NULL, NULL, "Quechan"},
	{"yun", NULL, NULL, NULL, "Bena (Nigeria)"},
	{"yup", NULL, NULL, NULL, "Yukpa"},
	{"yuq", NULL, NULL, NULL, "Yuqui"},
	{"yur", NULL, NULL, NULL, "Yurok"},
	{"yut", NULL, NULL, NULL, "Yopno"},
	{"yuw", NULL, NULL, NULL, "Yau (Morobe Province)"},
	{"yux", NULL, NULL, NULL, "Southern Yukaghir"},
	{"yuy", NULL, NULL, NULL, "East Yugur"},
	{"yuz", NULL, NULL, NULL, "Yuracare"},
	{"yva", NULL, NULL, NULL, "Yawa"},
	{"yvt", NULL, NULL, NULL, "Yavitero"},
	{"ywa", NULL, NULL, NULL, "Kalou"},
	{"ywg", NULL, NULL, NULL, "Yinhawangka"},
	{"ywl", NULL, NULL, NULL, "Western Lalu"},
	{"ywn", NULL, NULL, NULL, "Yawanawa"},
	{"ywq", NULL, NULL, NULL, "Wuding-Luquan Yi"},
	{"ywr", NULL, NULL, NULL, "Yawuru"},
	{"ywt", NULL, NULL, NULL, "Xishanba Lalo"},
	{"ywu", NULL, NULL, NULL, "Wumeng Nasu"},
	{"yww", NULL, NULL, NULL, "Yawarawarga"},
	{"yxa", NULL, NULL, NULL, "Mayawali"},
	{"yxg", NULL, NULL, NULL, "Yagara"},
	{"yxl", NULL, NULL, NULL, "Yardliyawarra"},
	{"yxm", NULL, NULL, NULL, "Yinwum"},
	{"yxu", NULL, NULL, NULL, "Yuyu"},
	{"yxy", NULL, NULL, NULL, "Yabula Yabula"},
	{"yyr", NULL, NULL, NULL, "Yir Yoront"},
	{"yyu", NULL, NULL, NULL, "Yau (Sandaun Province)"},
	{"yyz", NULL, NULL, NULL, "Ayizi"},
	{"yzg", NULL, NULL, NULL, "E'ma Buyang"},
	{"yzk", NULL, NULL, NULL, "Zokhuo"},
	{"zaa", NULL, NULL, NULL, "Sierra de Juárez Zapotec"},
	{"zab", NULL, NULL, NULL, "Western Tlacolula Valley Zapotec"},
	{"zac", NULL, NULL, NULL, "Ocotlán Zapotec"},
	{"zad", NULL, NULL, NULL, "Cajonos Zapotec"},
	{"zae", NULL, NULL, NULL, "Yareni Zapotec"},
	{"zaf", NULL, NULL, NULL, "Ayoquesco Zapotec"},
	{"zag", NULL, NULL, NULL, "Zaghawa"},
	{"zah", NULL, NULL, NULL, "Zangwal"},
	{"zai", NULL, NULL, NULL, "Isthmus Zapotec"},
	{"zaj", NULL, NULL, NULL, "Zaramo"},
	{"zak", NULL, NULL, NULL, "Zanaki"},
	{"zal", NULL, NULL, NULL, "Zauzou"},
	{"zam", NULL, NULL, NULL, "Miahuatlán Zapotec"},
	{"zao", NULL, NULL, NULL, "Ozolotepec Zapotec"},
	{"zap", "zap", "zap", NULL, "Zapotec"},
	{"zaq", NULL, NULL, NULL, "Aloápam Zapotec"},
	{"zar", NULL, NULL, NULL, "Rincón Zapotec"},
	{"zas", NULL, NULL, NULL, "Santo Domingo Albarradas Zapotec"},
	{"zat", NULL, NULL, NULL, "Tabaa Zapotec"},
	{"zau", NULL, NULL, NULL, "Zangskari"},
	{"zav", NULL, NULL, NULL, "Yatzachi Zapotec"},
	{"zaw", NULL, NULL, NULL, "Mitla Zapotec"},
	{"zax", NULL, NULL, NULL, "Xadani Zapotec"},
	{"zay", NULL, NULL, NULL, "Zayse-Zergulla"},
	{"zaz", NULL, NULL, NULL, "Zari"},
	{"zba", NULL, NULL, NULL, "Balaibalan"},
	{"zbc", NULL, NULL, NULL, "Central Berawan"},
	{"zbe", NULL, NULL, NULL, "East Berawan"},
	{"zbl", "zbl", "zbl", NULL, "Blissymbols"},
	{"zbt", NULL, NULL, NULL, "Batui"},
	{"zbu", NULL, NULL, NULL, "Bu (Bauchi State)"},
	{"zbw", NULL, NULL, NULL, "West Berawan"},
	{"zca", NULL, NULL, NULL, "Coatecas Altas Zapotec"},
	{"zch", NULL, NULL, NULL, "Central Hongshuihe Zhuang"},
	{"zdj", NULL, NULL, NULL, "Ngazidja Comorian"},
	{"zea", NULL, NULL, NULL, "Zeeuws"},
	{"zeg", NULL, NULL, NULL, "Zenag"},
	{"zeh", NULL, NULL, NULL, "Eastern Hongshuihe Zhuang"},
	{"zen", "zen", "zen", NULL, "Zenaga"},
	{"zga", NULL, NULL, NULL, "Kinga"},
	{"zgb", NULL, NULL, NULL, "Guibei Zhuang"},
	{"zgh", "zgh", "zgh", NULL, "Standard Moroccan Tamazight"},
	{"zgm", NULL, NULL, NULL, "Minz Zhuang"},
	{"zgn", NULL, NULL, NULL, "Guibian Zhuang"},
	{"zgr", NULL, NULL, NULL, "Magori"},
	{"zha", "zha", "zha", "za", "Zhuang"},
	{"zhb", NULL, NULL, NULL, "Zhaba"},
	{"zhd", NULL, NULL, NULL, "Dai Zhuang"},
	{"zhi", NULL, NULL, NULL, "Zhire"},
	{"zhn", NULL, NULL, NULL, "Nong Zhuang"},
	{"zho", "chi", "zho", "zh", "Chinese"},
	{"zhw", NULL, NULL, NULL, "Zhoa"},
	{"zia", NULL, NULL, NULL, "Zia"},
	{"zib", NULL, NULL, NULL, "Zimbabwe Sign Language"},
	{"zik", NULL, NULL, NULL, "Zimakani"},
	{"zil", NULL, NULL, NULL, "Zialo"},
	{"zim", NULL, NULL, NULL, "Mesme"},
	{"zin", NULL, NULL, NULL, "Zinza"},
	{"ziw", NULL, NULL, NULL, "Zigula"},
	{"ziz", NULL, NULL, NULL, "Zizilivakan"},
	{"zka", NULL, NULL, NULL, "Kaimbulawa"},
	{"zkb", NULL, NULL, NULL, "Koibal"},
	{"zkd", NULL, NULL, NULL, "Kadu"},
	{"zkg", NULL, NULL, NULL, "Koguryo"},
	{"zkh", NULL, NULL, NULL, "Khorezmian"},
	{"zkk", NULL, NULL, NULL, "Karankawa"},
	{"zkn", NULL, NULL, NULL, "Kanan"},
	{"zko", NULL, NULL, NULL, "Kott"},
	{"zkp", NULL, NULL, NULL, "São Paulo Kaingáng"},
	{"zkr", NULL, NULL, NULL, "Zakhring"},
	{"zkt", NULL, NULL, NULL, "Kitan"},
	{"zku", NULL, NULL, NULL, "Kaurna"},
	{"zkv", NULL, NULL, NULL, "Krevinian"},
	{"zkz", NULL, NULL, NULL, "Khazar"},
	{"zla", NULL, NULL, NULL, "Zula"},
	{"zlj", NULL, NULL, NULL, "Liujiang Zhuang"},
	{"zlm", NULL, NULL, NULL, "Malay (individual language)"},
	{"zln", NULL, NULL, NULL, "Lianshan Zhuang"},
	{"zlq", NULL, NULL, NULL, "Liuqian Zhuang"},
	{"zma", NULL, NULL, NULL, "Manda (Australia)"},
	{"zmb", NULL, NULL, NULL, "Zimba"},
	{"zmc", NULL, NULL, NULL, "Margany"},
	{"zmd", NULL, NULL, NULL, "Maridan"},
	{"zme", NULL, NULL, NULL, "Mangerr"},
	{"zmf", NULL, NULL, NULL, "Mfinu"},
	{"zmg", NULL, NULL, NULL, "Marti Ke"},
	{"zmh", NULL, NULL, NULL, "Makolkol"},
	{"zmi", NULL, NULL, NULL, "Negeri Sembilan Malay"},
	{"zmj", NULL, NULL, NULL, "Maridjabin"},
	{"zmk", NULL, NULL, NULL, "Mandandanyi"},
	{"zml", NULL, NULL, NULL, "Matngala"},
	{"zmm", NULL, NULL, NULL, "Marimanindji"},
	{"zmn", NULL, NULL, NULL, "Mbangwe"},
	{"zmo", NULL, NULL, NULL, "Molo"},
	{"zmp", NULL, NULL, NULL, "Mpuono"},
	{"zmq", NULL, NULL, NULL, "Mituku"},
	{"zmr", NULL, NULL, NULL, "Maranunggu"},
	{"zms", NULL, NULL, NULL, "Mbesa"},
	{"zmt", NULL, NULL, NULL, "Maringarr"},
	{"zmu", NULL, NULL, NULL, "Muruwari"},
	{"zmv", NULL, NULL, NULL, "Mbariman-Gudhinma"},
	{"zmw", NULL, NULL, NULL, "Mbo (Democratic Republic of Congo)"},
	{"zmx", NULL, NULL, NULL, "Bomitaba"},
	{"zmy", NULL, NULL, NULL, "Mariyedi"},
	{"zmz", NULL, NULL, NULL, "Mbandja"},
	{"zna", NULL, NULL, NULL, "Zan Gula"},
	{"zne", NULL, NULL, NULL, "Zande (individual language)"},
	{"zng", NULL, NULL, NULL, "Mang"},
	{"znk", NULL, NULL, NULL, "Manangkari"},
	{"zns", NULL, NULL, NULL, "Mangas"},
	{"zoc", NULL, NULL, NULL, "Copainalá Zoque"},
	{"zoh", NULL, NULL, NULL, "Chimalapa Zoque"},
	{"zom", NULL, NULL, NULL, "Zou"},
	{"zoo", NULL, NULL, NULL, "Asunción Mixtepec Zapotec"},
	{"zoq", NULL, NULL, NULL, "Tabasco Zoque"},
	{"zor", NULL, NULL, NULL, "Rayón Zoque"},
	{"zos", NULL, NULL, NULL, "Francisco León Zoque"},
	{"zpa", NULL, NULL, NULL, "Lachiguiri Zapotec"},
	{"zpb", NULL, NULL, NULL, "Yautepec Zapotec"},
	{"zpc", NULL, NULL, NULL, "Choapan Zapotec"},
	{"zpd", NULL, NULL, NULL, "Southeastern Ixtlán Zapotec"},
	{"zpe", NULL, NULL, NULL, "Petapa Zapotec"},
	{"zpf", NULL, NULL, NULL, "San Pedro Quiatoni Zapotec"},
	{"zpg", NULL, NULL, NULL, "Guevea De Humboldt Zapotec"},
	{"zph", NULL, NULL, NULL, "Totomachapan Zapotec"},
	{"zpi", NULL, NULL, NULL, "Santa María Quiegolani Zapotec"},
	{"zpj", NULL, NULL, NULL, "Quiavicuzas Zapotec"},
	{"zpk", NULL, NULL, NULL, "Tlacolulita Zapotec"},
	{"zpl", NULL, NULL, NULL, "Lachixío Zapotec"},
	{"zpm", NULL, NULL, NULL, "Mixtepec Zapotec"},
	{"zpn", NULL, NULL, NULL, "Santa Inés Yatzechi Zapotec"},
	{"zpo", NULL, NULL, NULL, "Amatlán Zapotec"},
	{"zpp", NULL, NULL, NULL, "El Alto Zapotec"},
	{"zpq", NULL, NULL, NULL, "Zoogocho Zapotec"},
	{"zpr", NULL, NULL, NULL, "Santiago Xanica Zapotec"},
	{"zps", NULL, NULL, NULL, "Coatlán Zapotec"},
	{"zpt", NULL, NULL, NULL, "San Vicente Coatlán Zapotec"},
	{"zpu", NULL, NULL, NULL, "Yalálag Zapotec"},
	{"zpv", NULL, NULL, NULL, "Chichicapan Zapotec"},
	{"zpw", NULL, NULL, NULL, "Zaniza Zapotec"},
	{"zpx", NULL, NULL, NULL, "San Baltazar Loxicha Zapotec"},
	{"zpy", NULL, NULL, NULL, "Mazaltepec Zapotec"},
	{"zpz", NULL, NULL, NULL, "Texmelucan Zapotec"},
	{"zqe", NULL, NULL, NULL, "Qiubei Zhuang"},
	{"zra", NULL, NULL, NULL, "Kara (Korea)"},
	{"zrg", NULL, NULL, NULL, "Mirgan"},
	{"zrn", NULL, NULL, NULL, "Zerenkel"},
	{"zro", NULL, NULL, NULL, "Záparo"},
	{"zrp", NULL, NULL, NULL, "Zarphatic"},
	{"zrs", NULL, NULL, NULL, "Mairasi"},
	{"zsa", NULL, NULL, NULL, "Sarasira"},
	{"zsk", NULL, NULL, NULL, "Kaskean"},
	{"zsl", NULL, NULL, NULL, "Zambian Sign Language"},
	{"zsm", NULL, NULL, NULL, "Standard Malay"},
	{"zsr", NULL, NULL, NULL, "Southern Rincon Zapotec"},
	{"zsu", NULL, NULL, NULL, "Sukurum"},
	{"zte", NULL, NULL, NULL, "Elotepec Zapotec"},
	{"ztg", NULL, NULL, NULL, "Xanaguía Zapotec"},
	{"ztl", NULL, NULL, NULL, "Lapaguía-Guivini Zapotec"},
	{"ztm", NULL, NULL, NULL, "San Agustín Mixtepec Zapotec"},
	{"ztn", NULL, NULL, NULL, "Santa Catarina Albarradas Zapotec"},
	{"ztp", NULL, NULL, NULL, "Loxicha Zapotec"},
	{"ztq", NULL, NULL, NULL, "Quioquitani-Quierí Zapotec"},
	{"zts", NULL, NULL, NULL, "Tilquiapan Zapotec"},
	{"ztt", NULL, NULL, NULL, "Tejalapan Zapotec"},
	{"ztu", NULL, NULL, NULL, "Güilá Zapotec"},
	{"ztx", NULL, NULL, NULL, "Zaachila Zapotec"},
	{"zty", NULL, NULL, NULL, "Yatee Zapotec"},
	{"zua", NULL, NULL, NULL, "Zeem"},
	{"zuh", NULL, NULL, NULL, "Tokano"},
	{"zul", "zul", "zul", "zu", "Zulu"},
	{"zum", NULL, NULL, NULL, "Kumzari"},
	{"zun", "zun", "zun", NULL, "Zuni"},
	{"zuy", NULL, NULL, NULL, "Zumaya"},
	{"zwa", NULL, NULL, NULL, "Zay"},
	{"zxx", "zxx", "zxx", NULL, "No linguistic content"},
	{"zyb", NULL, NULL, NULL, "Yongbei Zhuang"},
	{"zyg", NULL, NULL, NULL, "Yang Zhuang"},
	{"zyj", NULL, NULL, NULL, "Youjiang Zhuang"},
	{"zyn", NULL, NULL, NULL, "Yongnan Zhuang"},
	{"zyp", NULL, NULL, NULL, "Zyphe Chin"},
	{"zza", "zza", "zza", NULL, "Zaza"},
	{"zzj", NULL, NULL, NULL, "Zuojiang Zhuang"},
	{"mol", NULL, NULL, "mo", "Moldavian"},
};

