#include "youtube_dl.h"

YoutubeDl::YoutubeDl()
{

}

QString YoutubeDl::path = QString();

QString YoutubeDl::find() {
    if (!path.isEmpty()) return path;

    // Prefer downloaded youtube-dl
    QString localPath = QStandardPaths::locate(QStandardPaths::AppDataLocation, "youtube-dl");
    QProcess* process = instance(localPath, QStringList() << "--version");
    process->start();
    process->waitForFinished();
    process->deleteLater();
    if (process->state() != QProcess::NotRunning) process->kill();
    if (process->exitCode() == QProcess::ExitStatus::NormalExit) {
        path = localPath;
        return path;
    }

    // Try system-wide youtube-dl installation
    QString globalPath = QStandardPaths::findExecutable("youtube-dl");
    process = instance(globalPath, QStringList() << "--version");
    process->start();
    process->waitForFinished();
    process->deleteLater();
    if (process->state() != QProcess::NotRunning) process->kill();
    if (process->exitCode() == QProcess::ExitStatus::NormalExit) {
        path = globalPath;
        return path;
    }

    return "";
}

QProcess* YoutubeDl::instance(QStringList arguments) {
    return instance(find(), arguments);
}

QProcess* YoutubeDl::instance(QString path, QStringList arguments) {
    QProcess *process = new QProcess();

    process->setProgram("python");
    #if defined Q_OS_WIN
        process->setProgram("python/python.exe");
    #endif

    QString execPath = QCoreApplication::applicationDirPath();
    QProcessEnvironment env = QProcessEnvironment::systemEnvironment();
    env.insert("PATH", env.value("PATH") + ":" + execPath);
    process->setEnvironment(env.toStringList());

    process->setArguments(QStringList() << path << arguments);
    return process;
}

QString YoutubeDl::getVersion() {
    QProcess* youtubeDl = instance(QStringList("--version"));
    youtubeDl->start();
    youtubeDl->waitForFinished(10000);
    QString version = youtubeDl->readAllStandardOutput();
    return version;
}
