#!/bin/bash

name=clementine
version="1.3.1"
deb_dist="xenial"
root=$(cd "${0%/*}/.." && echo $PWD/${0##*/})
root=`dirname "$root"`
rootnoslash=`echo $root | sed "s/^\///"`

echo "Creating $name-$version.tar.xz..."

tar -cJf $name-$version.tar.xz "$root" \
    --transform "s,^$rootnoslash,$name-$version," \
    --exclude-vcs \
    --exclude "$root/bin/*" \
    --exclude "$root/debian" \
    --exclude "$root/dist/*.tar.gz" \
    --exclude "$root/dist/*.tar.xz" \
    --exclude "$root/CMakeLists.txt.user"

echo "Also creating ${name}_${version}~${deb_dist}.orig.tar.xz..."
cp "$name-$version.tar.xz" "${name}_${version}~${deb_dist}.orig.tar.xz"

