macro(MOC_WRAP_CPP outfiles)
    if(NOT CMAKE_AUTOMOC)
        # get include dirs
        qt4_get_moc_flags(moc_flags)
        qt4_extract_options(moc_files moc_options ${ARGN})

        foreach(it ${moc_files})
            get_filename_component(_abs_file ${it} ABSOLUTE)
            get_filename_component(_abs_PATH ${_abs_file} PATH)
            get_filename_component(_basename ${it} NAME_WE)

            set(_HAS_MOC false)

	    if(EXISTS ${_abs_PATH}/${_basename}.cpp)
                    set(_header ${_abs_PATH}/${_basename}.cpp)
                    file(READ ${_header} _contents)
                    string(REGEX MATCHALL "# *include +[\">]moc_[^ ]+\\.cpp[\">]" _match "${_contents}")
                    string(REGEX MATCHALL "# *include +[^ ]+\\.moc[\">]" _match2 "${_contents}")
                    string(REGEX MATCHALL "Q_OBJECT" _match3 "${_contents}")
                    if(_match)
                            set(_HAS_MOC true)
                            foreach(_current_MOC_INC ${_match})
                                    string(REGEX MATCH "moc_[^ <\"]+\\.cpp" _current_MOC "${_current_MOC_INC}")
                                    set(_moc    ${CMAKE_CURRENT_BINARY_DIR}/${_current_MOC})
                                    qt4_create_moc_command(${_abs_file} ${_moc} "${_moc_INCS}" "")
                                    macro_add_file_dependencies(${_abs_file} ${_moc})
                            endforeach(_current_MOC_INC)
                    endif()
                    if(_match2)
			    set(_HAS_MOC true)
                            foreach(_current_MOC_INC ${_match2})
                                    string(REGEX MATCH "[^ <\"]+\\.moc" _current_MOC "${_current_MOC_INC}")
                                    set(_moc    ${CMAKE_CURRENT_BINARY_DIR}/${_current_MOC})
                                    qt4_create_moc_command(${_header} ${_moc} "${_moc_INCS}" "")
                                    macro_add_file_dependencies(${_header} ${_moc})
                            endforeach (_current_MOC_INC)
                    endif()
            endif()
            if(NOT _HAS_MOC)
                    file(READ ${_abs_file} _contents)
                    string(REGEX MATCHALL "Q_OBJECT|Q_GADGET" _match2 "${_contents}")
                    if(_match2)
                            qt4_make_output_file(${_abs_file} moc_ cpp outfile)
                            qt4_create_moc_command(${_abs_file} ${outfile} "${moc_flags}" "${moc_options}")
                            set(${outfiles} ${${outfiles}} ${outfile})
                    endif()
            endif()
        endforeach(it)
    endif()
endmacro(MOC_WRAP_CPP)
