/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
 * All rights reserved.
 */
#ifndef __BKE_WORLD_H__
#define __BKE_WORLD_H__

/** \file
 * \ingroup bke
 */

struct Depsgraph;
struct Main;
struct World;

void BKE_world_free(struct World *sc);
void BKE_world_init(struct World *wrld);
struct World *BKE_world_add(struct Main *bmain, const char *name);
void BKE_world_copy_data(struct Main *bmain,
                         struct World *wrld_dst,
                         const struct World *wrld_src,
                         const int flag);
struct World *BKE_world_copy(struct Main *bmain, const struct World *wrld);
struct World *BKE_world_localize(struct World *wrld);
void BKE_world_make_local(struct Main *bmain, struct World *wrld, const bool lib_local);
void BKE_world_eval(struct Depsgraph *depsgraph, struct World *world);

#endif
