(function() {
  var Dialog, MoveDialog, fs, path, repoForPath,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  path = require('path');

  fs = require('fs-plus');

  Dialog = require('./dialog');

  repoForPath = require("./helpers").repoForPath;

  module.exports = MoveDialog = (function(superClass) {
    extend(MoveDialog, superClass);

    function MoveDialog(initialPath, arg) {
      var prompt;
      this.initialPath = initialPath;
      this.onMove = arg.onMove;
      if (fs.isDirectorySync(this.initialPath)) {
        prompt = 'Enter the new path for the directory.';
      } else {
        prompt = 'Enter the new path for the file.';
      }
      MoveDialog.__super__.constructor.call(this, {
        prompt: prompt,
        initialPath: atom.project.relativize(this.initialPath),
        select: true,
        iconClass: 'icon-arrow-right'
      });
    }

    MoveDialog.prototype.onConfirm = function(newPath) {
      var directoryPath, error, repo, rootPath;
      newPath = newPath.replace(/\s+$/, '');
      if (!path.isAbsolute(newPath)) {
        rootPath = atom.project.relativizePath(this.initialPath)[0];
        newPath = path.join(rootPath, newPath);
        if (!newPath) {
          return;
        }
      }
      if (this.initialPath === newPath) {
        this.close();
        return;
      }
      if (!this.isNewPathValid(newPath)) {
        this.showError("'" + newPath + "' already exists.");
        return;
      }
      directoryPath = path.dirname(newPath);
      try {
        if (!fs.existsSync(directoryPath)) {
          fs.makeTreeSync(directoryPath);
        }
        fs.moveSync(this.initialPath, newPath);
        if (typeof this.onMove === "function") {
          this.onMove({
            initialPath: this.initialPath,
            newPath: newPath
          });
        }
        if (repo = repoForPath(newPath)) {
          repo.getPathStatus(this.initialPath);
          repo.getPathStatus(newPath);
        }
        return this.close();
      } catch (error1) {
        error = error1;
        return this.showError(error.message + ".");
      }
    };

    MoveDialog.prototype.isNewPathValid = function(newPath) {
      var newStat, oldStat;
      try {
        oldStat = fs.statSync(this.initialPath);
        newStat = fs.statSync(newPath);
        return this.initialPath.toLowerCase() === newPath.toLowerCase() && oldStat.dev === newStat.dev && oldStat.ino === newStat.ino;
      } catch (error1) {
        return true;
      }
    };

    return MoveDialog;

  })(Dialog);

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
