'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _refsStack = require('./refs-stack');

var _refsStack2 = _interopRequireDefault(_refsStack);

// Instances of this class interface with an [extension mechanism](https://github.com/Matt-Esch/virtual-dom/blob/master/docs/hooks.md)
// in the `virtual-dom` library called "hooks". When virtual nodes have
// properties that reference hook instances, `virtual-dom` will call `hook`
// and `unhook` on this object with the underlying DOM node when it is created
// and destroyed.
//
// We maintain a global stack of simple `Object` instances in which to store
// references. When creating or updating a component, we push its associated
// `refs` object to the top of the stack. This allows the hooks to assign
// references into the component whose element we are currently creating or
// updating.

var RefHook = (function () {
  function RefHook(refName) {
    _classCallCheck(this, RefHook);

    this.refName = refName;
  }

  _createClass(RefHook, [{
    key: 'hook',
    value: function hook(node) {
      _refsStack2['default'][_refsStack2['default'].length - 1][this.refName] = node;
    }
  }, {
    key: 'unhook',
    value: function unhook(node) {
      var currentRefs = _refsStack2['default'][_refsStack2['default'].length - 1];
      if (_refsStack2['default'].length > 0 && currentRefs[this.refName] === node) {
        delete currentRefs[this.refName];
      }
    }
  }]);

  return RefHook;
})();

exports['default'] = RefHook;
module.exports = exports['default'];