(function() {
  var EmptyDecorationIterator, EmptyDecorationLayer, Point;

  Point = require('./point');

  module.exports = EmptyDecorationLayer = (function() {
    function EmptyDecorationLayer() {}

    EmptyDecorationLayer.prototype.buildIterator = function() {
      return new EmptyDecorationIterator;
    };

    EmptyDecorationLayer.prototype.getInvalidatedRanges = function() {
      return [];
    };

    return EmptyDecorationLayer;

  })();

  EmptyDecorationIterator = (function() {
    function EmptyDecorationIterator() {}

    EmptyDecorationIterator.prototype.seek = function(position) {
      return [];
    };

    EmptyDecorationIterator.prototype.moveToSuccessor = function() {
      return false;
    };

    EmptyDecorationIterator.prototype.getPosition = function() {
      return Point.INFINITY;
    };

    EmptyDecorationIterator.prototype.getCloseTags = function() {
      return [];
    };

    EmptyDecorationIterator.prototype.getOpenTags = function() {
      return [];
    };

    return EmptyDecorationIterator;

  })();

}).call(this);
