Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _electron = require('electron');

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _packageGrammarsView = require('./package-grammars-view');

var _packageGrammarsView2 = _interopRequireDefault(_packageGrammarsView);

var _packageKeymapView = require('./package-keymap-view');

var _packageKeymapView2 = _interopRequireDefault(_packageKeymapView);

var _packageReadmeView = require('./package-readme-view');

var _packageReadmeView2 = _interopRequireDefault(_packageReadmeView);

var _packageSnippetsView = require('./package-snippets-view');

var _packageSnippetsView2 = _interopRequireDefault(_packageSnippetsView);

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

var NORMALIZE_PACKAGE_DATA_README_ERROR = 'ERROR: No README data found!';

var PackageDetailView = (function () {
  function PackageDetailView(pack, settingsView, packageManager, snippetsProvider) {
    var _this = this;

    _classCallCheck(this, PackageDetailView);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);
    this.loadPackage();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    var packageRepoClickHandler = function packageRepoClickHandler(event) {
      event.preventDefault();
      var repoUrl = _this.packageManager.getRepositoryUrl(_this.pack);
      if (repoUrl) {
        _electron.shell.openExternal(repoUrl);
      }
    };
    this.refs.packageRepo.addEventListener('click', packageRepoClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.packageRepo.removeEventListener('click', packageRepoClickHandler);
    }));

    var issueButtonClickHandler = function issueButtonClickHandler(event) {
      event.preventDefault();
      var repoUrl = _this.packageManager.getRepositoryUrl(_this.pack);
      if (repoUrl) {
        _electron.shell.openExternal(repoUrl + '/issues/new');
      }
    };
    this.refs.issueButton.addEventListener('click', issueButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.changelogButton.removeEventListener('click', issueButtonClickHandler);
    }));

    var changelogButtonClickHandler = function changelogButtonClickHandler(event) {
      event.preventDefault();
      if (_this.changelogPath) {
        _this.openMarkdownFile(_this.changelogPath);
      }
    };
    this.refs.changelogButton.addEventListener('click', changelogButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.changelogButton.removeEventListener('click', changelogButtonClickHandler);
    }));

    var licenseButtonClickHandler = function licenseButtonClickHandler(event) {
      event.preventDefault();
      if (_this.licensePath) {
        _this.openMarkdownFile(_this.licensePath);
      }
    };
    this.refs.licenseButton.addEventListener('click', licenseButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.licenseButton.removeEventListener('click', licenseButtonClickHandler);
    }));

    var openButtonClickHandler = function openButtonClickHandler(event) {
      event.preventDefault();
      if (_fsPlus2['default'].existsSync(_this.pack.path)) {
        atom.open({ pathsToOpen: [_this.pack.path] });
      }
    };
    this.refs.openButton.addEventListener('click', openButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.openButton.removeEventListener('click', openButtonClickHandler);
    }));

    var learnMoreButtonClickHandler = function learnMoreButtonClickHandler(event) {
      event.preventDefault();
      _electron.shell.openExternal('https://atom.io/packages/' + _this.pack.name);
    };
    this.refs.learnMoreButton.addEventListener('click', learnMoreButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.learnMoreButton.removeEventListener('click', learnMoreButtonClickHandler);
    }));

    var breadcrumbClickHandler = function breadcrumbClickHandler(event) {
      event.preventDefault();
      _this.settingsView.showPanel(_this.breadcrumbBackPanel);
    };
    this.refs.breadcrumb.addEventListener('click', breadcrumbClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.breadcrumb.removeEventListener('click', breadcrumbClickHandler);
    }));
  }

  _createClass(PackageDetailView, [{
    key: 'completeInitialization',
    value: function completeInitialization() {
      if (this.refs.packageCard) {
        this.packageCard = this.refs.packageCard.packageCard;
      } else if (!this.packageCard) {
        // Had to load this from the network
        this.packageCard = new _packageCard2['default'](this.pack.metadata, this.settingsView, this.packageManager, { onSettingsView: true });
        this.refs.packageCardParent.replaceChild(this.packageCard.element, this.refs.loadingMessage);
      }

      this.refs.packageRepo.classList.remove('hidden');
      this.refs.startupTime.classList.remove('hidden');
      this.refs.buttons.classList.remove('hidden');
      this.activateConfig();
      this.populate();
      this.updateFileButtons();
      this.subscribeToPackageManager();
      this.renderReadme();
    }
  }, {
    key: 'loadPackage',
    value: function loadPackage() {
      var loadedPackage = atom.packages.getLoadedPackage(this.pack.name);
      if (loadedPackage) {
        this.pack = loadedPackage;
        this.completeInitialization();
      } else {
        // If the package metadata in `@pack` isn't complete, hit the network.
        if (!this.pack.metadata || !this.pack.metadata.owner) {
          this.fetchPackage();
        } else {
          this.completeInitialization();
        }
      }
    }
  }, {
    key: 'fetchPackage',
    value: function fetchPackage() {
      var _this2 = this;

      this.showLoadingMessage();
      this.packageManager.getClient()['package'](this.pack.name, function (err, packageData) {
        if (err || !packageData || !packageData.name) {
          _this2.hideLoadingMessage();
          _this2.showErrorMessage();
        } else {
          _this2.pack = packageData;
          // TODO: this should match Package.loadMetadata from core, but this is
          // an acceptable hacky workaround
          _this2.pack.metadata = _underscorePlus2['default'].extend(_this2.pack.metadata != null ? _this2.pack.metadata : {}, _this2.pack);
          _this2.completeInitialization();
        }
      });
    }
  }, {
    key: 'showLoadingMessage',
    value: function showLoadingMessage() {
      this.refs.loadingMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideLoadingMessage',
    value: function hideLoadingMessage() {
      this.refs.loadingMessage.classList.add('hidden');
    }
  }, {
    key: 'showErrorMessage',
    value: function showErrorMessage() {
      this.refs.errorMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideErrorMessage',
    value: function hideErrorMessage() {
      this.refs.errorMessage.classList.add('hidden');
    }
  }, {
    key: 'activateConfig',
    value: function activateConfig() {
      // Package.activateConfig() is part of the Private package API and should not be used outside of core.
      if (atom.packages.isPackageLoaded(this.pack.name) && !atom.packages.isPackageActive(this.pack.name)) {
        this.pack.activateConfig();
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      if (this.packageCard) {
        this.packageCard.destroy();
        this.packageCard = null;
      }

      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      if (opts.back == null) {
        opts.back = 'Install';
      }

      this.breadcrumbBackPanel = opts.back;
      this.refs.breadcrumb.textContent = this.breadcrumbBackPanel;
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'render',
    value: function render() {
      var packageCardView = undefined;
      if (this.pack && this.pack.metadata && this.pack.metadata.owner) {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(PackageCardComponent, {
            ref: 'packageCard',
            settingsView: this.settingsView,
            packageManager: this.packageManager,
            metadata: this.pack.metadata,
            options: { onSettingsView: true } })
        );
      } else {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(
            'div',
            { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' },
            'Loading ' + this.pack.name + '…'
          ),
          _etch2['default'].dom(
            'div',
            { ref: 'errorMessage', className: 'alert alert-danger icon icon-hourglass hidden' },
            'Failed to load ',
            this.pack.name,
            ' - try again later.'
          )
        );
      }
      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'package-detail panels-item' },
        _etch2['default'].dom(
          'ol',
          { ref: 'breadcrumbContainer', className: 'native-key-bindings breadcrumb', tabIndex: '-1' },
          _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom('a', { ref: 'breadcrumb' })
          ),
          _etch2['default'].dom(
            'li',
            { className: 'active' },
            _etch2['default'].dom('a', { ref: 'title' })
          )
        ),
        _etch2['default'].dom(
          'section',
          { className: 'section' },
          _etch2['default'].dom(
            'form',
            { className: 'section-container package-detail-view' },
            _etch2['default'].dom(
              'div',
              { className: 'container package-container' },
              packageCardView
            ),
            _etch2['default'].dom('p', { ref: 'packageRepo', className: 'link icon icon-repo repo-link hidden' }),
            _etch2['default'].dom('p', { ref: 'startupTime', className: 'text icon icon-dashboard hidden', tabIndex: '-1' }),
            _etch2['default'].dom(
              'div',
              { ref: 'buttons', className: 'btn-wrap-group hidden' },
              _etch2['default'].dom(
                'button',
                { ref: 'learnMoreButton', className: 'btn btn-default icon icon-link' },
                'View on Atom.io'
              ),
              _etch2['default'].dom(
                'button',
                { ref: 'issueButton', className: 'btn btn-default icon icon-bug' },
                'Report Issue'
              ),
              _etch2['default'].dom(
                'button',
                { ref: 'changelogButton', className: 'btn btn-default icon icon-squirrel' },
                'CHANGELOG'
              ),
              _etch2['default'].dom(
                'button',
                { ref: 'licenseButton', className: 'btn btn-default icon icon-law' },
                'LICENSE'
              ),
              _etch2['default'].dom(
                'button',
                { ref: 'openButton', className: 'btn btn-default icon icon-link-external' },
                'View Code'
              )
            ),
            _etch2['default'].dom('div', { ref: 'errors' })
          )
        ),
        _etch2['default'].dom('div', { ref: 'sections' })
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      this.refs.title.textContent = '' + _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(this.pack.name));
      this.type = this.pack.metadata.theme ? 'theme' : 'package';

      var repoUrl = this.packageManager.getRepositoryUrl(this.pack);
      if (repoUrl) {
        var repoName = _url2['default'].parse(repoUrl).pathname;
        this.refs.packageRepo.textContent = repoName.substring(1);
        this.refs.packageRepo.style.display = '';
      } else {
        this.refs.packageRepo.style.display = 'none';
      }

      this.updateInstalledState();
    }
  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      this.updateFileButtons();
      this.activateConfig();
      this.refs.startupTime.style.display = 'none';

      if (atom.packages.isPackageLoaded(this.pack.name)) {
        if (!atom.packages.isPackageDisabled(this.pack.name)) {
          this.settingsPanel = new _settingsPanel2['default']({ namespace: this.pack.name, includeTitle: false });
          this.keymapView = new _packageKeymapView2['default'](this.pack);
          this.refs.sections.appendChild(this.settingsPanel.element);
          this.refs.sections.appendChild(this.keymapView.element);

          if (this.pack.path) {
            this.grammarsView = new _packageGrammarsView2['default'](this.pack.path);
            this.snippetsView = new _packageSnippetsView2['default'](this.pack.path, this.snippetsProvider);
            this.refs.sections.appendChild(this.grammarsView.element);
            this.refs.sections.appendChild(this.snippetsView.element);
          }

          this.refs.startupTime.innerHTML = 'This ' + this.type + ' added <span class=\'highlight\'>' + this.getStartupTime() + 'ms</span> to startup time.';
          this.refs.startupTime.style.display = '';
        }
      }

      var sourceIsAvailable = this.packageManager.isPackageInstalled(this.pack.name) && !atom.packages.isBundledPackage(this.pack.name);
      if (sourceIsAvailable) {
        this.refs.openButton.style.display = '';
      } else {
        this.refs.openButton.style.display = 'none';
      }

      this.renderReadme();
    }
  }, {
    key: 'renderReadme',
    value: function renderReadme() {
      var readme = undefined;
      if (this.pack.metadata.readme && this.pack.metadata.readme.trim() !== NORMALIZE_PACKAGE_DATA_README_ERROR) {
        readme = this.pack.metadata.readme;
      } else {
        readme = null;
      }

      if (this.readmePath && !readme) {
        readme = _fsPlus2['default'].readFileSync(this.readmePath, { encoding: 'utf8' });
      }

      var readmeView = new _packageReadmeView2['default'](readme);
      if (this.readmeView) {
        this.readmeView.element.parentElement.replaceChild(readmeView.element, this.readmeView.element);
        this.readmeView.destroy();
      } else {
        this.refs.sections.appendChild(readmeView.element);
      }
      this.readmeView = readmeView;
    }
  }, {
    key: 'subscribeToPackageManager',
    value: function subscribeToPackageManager() {
      var _this3 = this;

      this.disposables.add(this.packageManager.on('theme-installed package-installed', function (_ref) {
        var pack = _ref.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-uninstalled package-uninstalled', function (_ref2) {
        var pack = _ref2.pack;

        if (_this3.pack.name === pack.name) {
          return _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-updated package-updated', function (_ref3) {
        var pack = _ref3.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateFileButtons();
          _this3.populate();
        }
      }));
    }
  }, {
    key: 'openMarkdownFile',
    value: function openMarkdownFile(path) {
      if (atom.packages.isPackageActive('markdown-preview')) {
        atom.workspace.open(encodeURI('markdown-preview://' + path));
      } else {
        atom.workspace.open(path);
      }
    }
  }, {
    key: 'updateFileButtons',
    value: function updateFileButtons() {
      this.changelogPath = null;
      this.licensePath = null;
      this.readmePath = null;

      var packagePath = this.pack.path != null ? this.pack.path : atom.packages.resolvePackagePath(this.pack.name);
      for (var child of _fsPlus2['default'].listSync(packagePath)) {
        switch (_path2['default'].basename(child, _path2['default'].extname(child)).toLowerCase()) {
          case 'changelog':
          case 'history':
            this.changelogPath = child;
            break;
          case 'license':
          case 'licence':
            this.licensePath = child;
            break;
          case 'readme':
            this.readmePath = child;
            break;
        }

        if (this.readmePath && this.changelogPath && this.licensePath) {
          break;
        }
      }

      if (this.changelogPath) {
        this.refs.changelogButton.style.display = '';
      } else {
        this.refs.changelogButton.style.display = 'none';
      }

      if (this.licensePath) {
        this.refs.licenseButton.style.display = '';
      } else {
        this.refs.licenseButton.style.display = 'none';
      }
    }
  }, {
    key: 'getStartupTime',
    value: function getStartupTime() {
      var loadTime = this.pack.loadTime != null ? this.pack.loadTime : 0;
      var activateTime = this.pack.activateTime != null ? this.pack.activateTime : 0;
      return loadTime + activateTime;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return PackageDetailView;
})();

exports['default'] = PackageDetailView;

var PackageCardComponent = (function () {
  function PackageCardComponent(props) {
    _classCallCheck(this, PackageCardComponent);

    this.packageCard = new _packageCard2['default'](props.metadata, props.settingsView, props.packageManager, props.options);
    this.element = this.packageCard.element;
  }

  _createClass(PackageCardComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {}
  }]);

  return PackageCardComponent;
})();

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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