Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _list = require('./list');

var _list2 = _interopRequireDefault(_list);

var _listView = require('./list-view');

var _listView2 = _interopRequireDefault(_listView);

var _utils = require('./utils');

var InstalledPackagesPanel = (function (_CollapsibleSectionPanel) {
  _inherits(InstalledPackagesPanel, _CollapsibleSectionPanel);

  _createClass(InstalledPackagesPanel, null, [{
    key: 'loadPackagesDelay',
    value: function loadPackagesDelay() {
      return 300;
    }
  }]);

  function InstalledPackagesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, InstalledPackagesPanel);

    _get(Object.getPrototypeOf(InstalledPackagesPanel.prototype), 'constructor', this).call(this);
    _etch2['default'].initialize(this);
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.items = {
      dev: new _list2['default']('name'),
      core: new _list2['default']('name'),
      user: new _list2['default']('name'),
      git: new _list2['default']('name'),
      deprecated: new _list2['default']('name')
    };
    this.itemViews = {
      dev: new _listView2['default'](this.items.dev, this.refs.devPackages, this.createPackageCard.bind(this)),
      core: new _listView2['default'](this.items.core, this.refs.corePackages, this.createPackageCard.bind(this)),
      user: new _listView2['default'](this.items.user, this.refs.communityPackages, this.createPackageCard.bind(this)),
      git: new _listView2['default'](this.items.git, this.refs.gitPackages, this.createPackageCard.bind(this)),
      deprecated: new _listView2['default'](this.items.deprecated, this.refs.deprecatedPackages, this.createPackageCard.bind(this))
    };

    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(this.refs.filterEditor.onDidStopChanging(function () {
      _this.matchPackages();
    }));
    this.subscriptions.add(this.packageManager.on('package-install-failed theme-install-failed package-uninstall-failed theme-uninstall-failed package-update-failed theme-update-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.updateErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));

    var loadPackagesTimeout = undefined;
    this.subscriptions.add(this.packageManager.on('package-updated package-installed package-uninstalled package-installed-alternative', function () {
      clearTimeout(loadPackagesTimeout);
      loadPackagesTimeout = setTimeout(_this.loadPackages.bind(_this), InstalledPackagesPanel.loadPackagesDelay());
    }));

    this.subscriptions.add(this.handleEvents());
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.loadPackages();
  }

  _createClass(InstalledPackagesPanel, [{
    key: 'focus',
    value: function focus() {
      this.refs.filterEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'section',
          { className: 'section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'div',
              { className: 'section-heading icon icon-package' },
              'Installed Packages',
              _etch2['default'].dom(
                'span',
                { ref: 'totalPackages', className: 'section-heading-count badge badge-flexible' },
                '…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'editor-container' },
              _etch2['default'].dom(_atom.TextEditor, { ref: 'filterEditor', mini: true, placeholderText: 'Filter packages by name' })
            ),
            _etch2['default'].dom('div', { ref: 'updateErrors' }),
            _etch2['default'].dom(
              'section',
              { ref: 'deprecatedSection', className: 'sub-section deprecated-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'deprecatedPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Deprecated Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'deprecatedCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'p',
                null,
                'Atom does not load deprecated packages. These packages may have updates available.'
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'deprecatedPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'deprecatedLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section installed-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'communityPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Community Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'communityCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'communityPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'communityLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section core-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'corePackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Core Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'coreCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'corePackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'coreLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section dev-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'devPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Development Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'devCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'devPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'devLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section git-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'gitPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Git Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'gitCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'gitPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'gitLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'filterPackages',
    value: function filterPackages(packages) {
      packages.dev = packages.dev.filter(function (_ref2) {
        var theme = _ref2.theme;
        return !theme;
      });
      packages.user = packages.user.filter(function (_ref3) {
        var theme = _ref3.theme;
        return !theme;
      });
      packages.deprecated = packages.user.filter(function (_ref4) {
        var name = _ref4.name;
        var version = _ref4.version;
        return atom.packages.isDeprecatedPackage(name, version);
      });
      packages.core = packages.core.filter(function (_ref5) {
        var theme = _ref5.theme;
        return !theme;
      });
      packages.git = (packages.git || []).filter(function (_ref6) {
        var theme = _ref6.theme;
        return !theme;
      });

      for (var pack of packages.core) {
        if (pack.repository == null) {
          pack.repository = 'https://github.com/atom/' + pack.name;
        }
      }

      for (var packageType of ['dev', 'core', 'user', 'git', 'deprecated']) {
        for (var pack of packages[packageType]) {
          pack.owner = (0, _utils.ownerFromRepository)(pack.repository);
        }
      }

      return packages;
    }
  }, {
    key: 'sortPackages',
    value: function sortPackages(packages) {
      packages.dev.sort(_utils.packageComparatorAscending);
      packages.core.sort(_utils.packageComparatorAscending);
      packages.user.sort(_utils.packageComparatorAscending);
      packages.git.sort(_utils.packageComparatorAscending);
      packages.deprecated.sort(_utils.packageComparatorAscending);
      return packages;
    }
  }, {
    key: 'loadPackages',
    value: function loadPackages() {
      var _this2 = this;

      var packagesWithUpdates = {};
      this.packageManager.getOutdated().then(function (packages) {
        for (var _ref72 of packages) {
          var _name = _ref72.name;
          var latestVersion = _ref72.latestVersion;

          packagesWithUpdates[_name] = latestVersion;
        }
        _this2.displayPackageUpdates(packagesWithUpdates);
      });

      this.packageManager.getInstalled().then(function (packages) {
        _this2.packages = _this2.sortPackages(_this2.filterPackages(packages));
        _this2.refs.devLoadingArea.remove();
        _this2.items.dev.setItems(_this2.packages.dev);

        _this2.refs.coreLoadingArea.remove();
        _this2.items.core.setItems(_this2.packages.core);

        _this2.refs.communityLoadingArea.remove();
        _this2.items.user.setItems(_this2.packages.user);

        _this2.refs.gitLoadingArea.remove();
        _this2.items.git.setItems(_this2.packages.git);

        if (_this2.packages.deprecated.length) {
          _this2.refs.deprecatedSection.style.display = '';
        } else {
          _this2.refs.deprecatedSection.style.display = 'none';
        }
        _this2.refs.deprecatedLoadingArea.remove();
        _this2.items.deprecated.setItems(_this2.packages.deprecated);

        // TODO show empty mesage per section

        _this2.updateSectionCounts();
        _this2.displayPackageUpdates(packagesWithUpdates);

        _this2.matchPackages();
      })['catch'](function (error) {
        console.error(error.message, error.stack);
      });
    }
  }, {
    key: 'displayPackageUpdates',
    value: function displayPackageUpdates(packagesWithUpdates) {
      for (var packageType of ['dev', 'core', 'user', 'git', 'deprecated']) {
        for (var packageCard of this.itemViews[packageType].getViews()) {
          var newVersion = packagesWithUpdates[packageCard.pack.name];
          if (newVersion) {
            packageCard.displayAvailableUpdate(newVersion);
          }
        }
      }
    }
  }, {
    key: 'createPackageCard',
    value: function createPackageCard(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Packages' });
    }
  }, {
    key: 'filterPackageListByText',
    value: function filterPackageListByText(text) {
      if (!this.packages) {
        return;
      }

      for (var packageType of ['dev', 'core', 'user', 'git', 'deprecated']) {
        var allViews = this.itemViews[packageType].getViews();
        var activeViews = this.itemViews[packageType].filterViews(function (pack) {
          if (text === '') {
            return true;
          } else {
            var owner = pack.owner != null ? pack.owner : (0, _utils.ownerFromRepository)(pack.repository);
            var filterText = pack.name + ' ' + owner;
            return _fuzzaldrin2['default'].score(filterText, text) > 0;
          }
        });

        for (var view of allViews) {
          if (view) {
            view.element.style.display = 'none';
            view.element.classList.add('hidden');
          }
        }

        for (var view of activeViews) {
          if (view) {
            view.element.style.display = '';
            view.element.classList.remove('hidden');
          }
        }
      }

      this.updateSectionCounts();
    }
  }, {
    key: 'updateUnfilteredSectionCounts',
    value: function updateUnfilteredSectionCounts() {
      this.updateSectionCount(this.refs.deprecatedPackagesHeader, this.refs.deprecatedCount, this.packages.deprecated.length);
      this.updateSectionCount(this.refs.communityPackagesHeader, this.refs.communityCount, this.packages.user.length);
      this.updateSectionCount(this.refs.corePackagesHeader, this.refs.coreCount, this.packages.core.length);
      this.updateSectionCount(this.refs.devPackagesHeader, this.refs.devCount, this.packages.dev.length);
      this.updateSectionCount(this.refs.gitPackagesHeader, this.refs.gitCount, this.packages.git.length);

      var totalPackages = this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length;
      this.refs.totalPackages.textContent = totalPackages.toString();
    }
  }, {
    key: 'updateFilteredSectionCounts',
    value: function updateFilteredSectionCounts() {
      var deprecated = this.notHiddenCardsLength(this.refs.deprecatedPackages);
      this.updateSectionCount(this.refs.deprecatedPackagesHeader, this.refs.deprecatedCount, deprecated, this.packages.deprecated.length);

      var community = this.notHiddenCardsLength(this.refs.communityPackages);
      this.updateSectionCount(this.refs.communityPackagesHeader, this.refs.communityCount, community, this.packages.user.length);

      var core = this.notHiddenCardsLength(this.refs.corePackages);
      this.updateSectionCount(this.refs.corePackagesHeader, this.refs.coreCount, core, this.packages.core.length);

      var dev = this.notHiddenCardsLength(this.refs.devPackages);
      this.updateSectionCount(this.refs.devPackagesHeader, this.refs.devCount, dev, this.packages.dev.length);

      var git = this.notHiddenCardsLength(this.refs.gitPackages);
      this.updateSectionCount(this.refs.gitPackagesHeader, this.refs.gitCount, git, this.packages.git.length);

      var shownPackages = dev + core + community + git;
      var totalPackages = this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length;
      this.refs.totalPackages.textContent = shownPackages + '/' + totalPackages;
    }
  }, {
    key: 'resetSectionHasItems',
    value: function resetSectionHasItems() {
      this.resetCollapsibleSections([this.refs.deprecatedPackagesHeader, this.refs.communityPackagesHeader, this.refs.corePackagesHeader, this.refs.devPackagesHeader, this.refs.gitPackagesHeader]);
    }
  }, {
    key: 'matchPackages',
    value: function matchPackages() {
      this.filterPackageListByText(this.refs.filterEditor.getText());
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return InstalledPackagesPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = InstalledPackagesPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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