(function() {
  var CompositeDisposable, Notification, NotificationElement, Notifications, StackTraceParser, fs, isCoreOrPackageStackTrace, ref;

  ref = require('atom'), Notification = ref.Notification, CompositeDisposable = ref.CompositeDisposable;

  fs = require('fs-plus');

  StackTraceParser = null;

  NotificationElement = require('./notification-element');

  Notifications = {
    isInitialized: false,
    subscriptions: null,
    duplicateTimeDelay: 500,
    lastNotification: null,
    activate: function(state) {
      var CommandLogger, i, len, notification, ref1;
      CommandLogger = require('./command-logger');
      CommandLogger.start();
      this.subscriptions = new CompositeDisposable;
      ref1 = atom.notifications.getNotifications();
      for (i = 0, len = ref1.length; i < len; i++) {
        notification = ref1[i];
        this.addNotificationView(notification);
      }
      this.subscriptions.add(atom.notifications.onDidAddNotification((function(_this) {
        return function(notification) {
          return _this.addNotificationView(notification);
        };
      })(this)));
      this.subscriptions.add(atom.onWillThrowError(function(arg) {
        var line, match, message, options, originalError, preventDefault, url;
        message = arg.message, url = arg.url, line = arg.line, originalError = arg.originalError, preventDefault = arg.preventDefault;
        if (originalError.name === 'BufferedProcessError') {
          message = message.replace('Uncaught BufferedProcessError: ', '');
          return atom.notifications.addError(message, {
            dismissable: true
          });
        } else if (originalError.code === 'ENOENT' && !/\/atom/i.test(message) && (match = /spawn (.+) ENOENT/.exec(message))) {
          message = "'" + match[1] + "' could not be spawned.\nIs it installed and on your path?\nIf so please open an issue on the package spawning the process.";
          return atom.notifications.addError(message, {
            dismissable: true
          });
        } else if (!atom.inDevMode() || atom.config.get('notifications.showErrorsInDevMode')) {
          preventDefault();
          if (originalError.stack && !isCoreOrPackageStackTrace(originalError.stack)) {
            return;
          }
          options = {
            detail: url + ":" + line,
            stack: originalError.stack,
            dismissable: true
          };
          return atom.notifications.addFatalError(message, options);
        }
      }));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'core:cancel', function() {
        var j, len1, ref2, results;
        ref2 = atom.notifications.getNotifications();
        results = [];
        for (j = 0, len1 = ref2.length; j < len1; j++) {
          notification = ref2[j];
          results.push(notification.dismiss());
        }
        return results;
      }));
      if (atom.inDevMode()) {
        this.subscriptions.add(atom.commands.add('atom-workspace', 'notifications:toggle-dev-panel', function() {
          return Notifications.togglePanel();
        }));
        return this.subscriptions.add(atom.commands.add('atom-workspace', 'notifications:trigger-error', function() {
          var error, options;
          try {
            return abc + 2;
          } catch (error1) {
            error = error1;
            options = {
              detail: error.stack.split('\n')[1],
              stack: error.stack,
              dismissable: true
            };
            return atom.notifications.addFatalError("Uncaught " + (error.stack.split('\n')[0]), options);
          }
        }));
      }
    },
    deactivate: function() {
      var ref1, ref2;
      this.subscriptions.dispose();
      if ((ref1 = this.notificationsElement) != null) {
        ref1.remove();
      }
      if ((ref2 = this.notificationsPanel) != null) {
        ref2.destroy();
      }
      this.subscriptions = null;
      this.notificationsElement = null;
      this.notificationsPanel = null;
      return this.isInitialized = false;
    },
    initializeIfNotInitialized: function() {
      if (this.isInitialized) {
        return;
      }
      this.subscriptions.add(atom.views.addViewProvider(Notification, function(model) {
        return new NotificationElement(model);
      }));
      this.notificationsElement = document.createElement('atom-notifications');
      atom.views.getView(atom.workspace).appendChild(this.notificationsElement);
      return this.isInitialized = true;
    },
    togglePanel: function() {
      var NotificationsPanelView;
      if (this.notificationsPanel != null) {
        if (Notifications.notificationsPanel.isVisible()) {
          return Notifications.notificationsPanel.hide();
        } else {
          return Notifications.notificationsPanel.show();
        }
      } else {
        NotificationsPanelView = require('./notifications-panel-view');
        Notifications.notificationsPanelView = new NotificationsPanelView;
        return Notifications.notificationsPanel = atom.workspace.addBottomPanel({
          item: Notifications.notificationsPanelView.getElement()
        });
      }
    },
    addNotificationView: function(notification) {
      var timeSpan;
      if (notification == null) {
        return;
      }
      this.initializeIfNotInitialized();
      if (notification.wasDisplayed()) {
        return;
      }
      if (this.lastNotification != null) {
        timeSpan = notification.getTimestamp() - this.lastNotification.getTimestamp();
        if (!(timeSpan < this.duplicateTimeDelay && notification.isEqual(this.lastNotification))) {
          this.notificationsElement.appendChild(atom.views.getView(notification).element);
        }
      } else {
        this.notificationsElement.appendChild(atom.views.getView(notification).element);
      }
      notification.setDisplayed(true);
      return this.lastNotification = notification;
    }
  };

  isCoreOrPackageStackTrace = function(stack) {
    var file, i, len, ref1;
    if (StackTraceParser == null) {
      StackTraceParser = require('stacktrace-parser');
    }
    ref1 = StackTraceParser.parse(stack);
    for (i = 0, len = ref1.length; i < len; i++) {
      file = ref1[i].file;
      if (file === '<embedded>' || fs.isAbsolute(file)) {
        return true;
      }
    }
    return false;
  };

  module.exports = Notifications;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
