(function() {
  var MarkdownPreviewView, fs, isMarkdownPreviewView, renderer, url,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  url = require('url');

  fs = require('fs-plus');

  MarkdownPreviewView = null;

  renderer = null;

  isMarkdownPreviewView = function(object) {
    if (MarkdownPreviewView == null) {
      MarkdownPreviewView = require('./markdown-preview-view');
    }
    return object instanceof MarkdownPreviewView;
  };

  module.exports = {
    activate: function() {
      var previewFile;
      atom.commands.add('atom-workspace', {
        'markdown-preview:toggle': (function(_this) {
          return function() {
            return _this.toggle();
          };
        })(this),
        'markdown-preview:copy-html': (function(_this) {
          return function() {
            return _this.copyHtml();
          };
        })(this),
        'markdown-preview:save-as-html': (function(_this) {
          return function() {
            return _this.saveAsHtml();
          };
        })(this),
        'markdown-preview:toggle-break-on-single-newline': function() {
          var keyPath;
          keyPath = 'markdown-preview.breakOnSingleNewline';
          return atom.config.set(keyPath, !atom.config.get(keyPath));
        },
        'markdown-preview:toggle-github-style': function() {
          var keyPath;
          keyPath = 'markdown-preview.useGitHubStyle';
          return atom.config.set(keyPath, !atom.config.get(keyPath));
        }
      });
      previewFile = this.previewFile.bind(this);
      atom.commands.add('.tree-view .file .name[data-name$=\\.markdown]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.md]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.mdown]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.mkd]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.mkdown]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.ron]', 'markdown-preview:preview-file', previewFile);
      atom.commands.add('.tree-view .file .name[data-name$=\\.txt]', 'markdown-preview:preview-file', previewFile);
      return atom.workspace.addOpener((function(_this) {
        return function(uriToOpen) {
          var path, protocol, ref;
          ref = uriToOpen.split('://'), protocol = ref[0], path = ref[1];
          if (protocol !== 'markdown-preview') {
            return;
          }
          try {
            path = decodeURI(path);
          } catch (error1) {
            return;
          }
          if (path.startsWith('editor/')) {
            return _this.createMarkdownPreviewView({
              editorId: path.substring(7)
            });
          } else {
            return _this.createMarkdownPreviewView({
              filePath: path
            });
          }
        };
      })(this));
    },
    createMarkdownPreviewView: function(state) {
      if (state.editorId || fs.isFileSync(state.filePath)) {
        if (MarkdownPreviewView == null) {
          MarkdownPreviewView = require('./markdown-preview-view');
        }
        return new MarkdownPreviewView(state);
      }
    },
    toggle: function() {
      var editor, grammars, ref, ref1;
      if (isMarkdownPreviewView(atom.workspace.getActivePaneItem())) {
        atom.workspace.destroyActivePaneItem();
        return;
      }
      editor = atom.workspace.getActiveTextEditor();
      if (editor == null) {
        return;
      }
      grammars = (ref = atom.config.get('markdown-preview.grammars')) != null ? ref : [];
      if (ref1 = editor.getGrammar().scopeName, indexOf.call(grammars, ref1) < 0) {
        return;
      }
      if (!this.removePreviewForEditor(editor)) {
        return this.addPreviewForEditor(editor);
      }
    },
    uriForEditor: function(editor) {
      return "markdown-preview://editor/" + editor.id;
    },
    removePreviewForEditor: function(editor) {
      var previewPane, uri;
      uri = this.uriForEditor(editor);
      previewPane = atom.workspace.paneForURI(uri);
      if (previewPane != null) {
        previewPane.destroyItem(previewPane.itemForURI(uri));
        return true;
      } else {
        return false;
      }
    },
    addPreviewForEditor: function(editor) {
      var options, previousActivePane, uri;
      uri = this.uriForEditor(editor);
      previousActivePane = atom.workspace.getActivePane();
      options = {
        searchAllPanes: true
      };
      if (atom.config.get('markdown-preview.openPreviewInSplitPane')) {
        options.split = 'right';
      }
      return atom.workspace.open(uri, options).then(function(markdownPreviewView) {
        if (isMarkdownPreviewView(markdownPreviewView)) {
          return previousActivePane.activate();
        }
      });
    },
    previewFile: function(arg) {
      var editor, filePath, i, len, ref, target;
      target = arg.target;
      filePath = target.dataset.path;
      if (!filePath) {
        return;
      }
      ref = atom.workspace.getTextEditors();
      for (i = 0, len = ref.length; i < len; i++) {
        editor = ref[i];
        if (!(editor.getPath() === filePath)) {
          continue;
        }
        this.addPreviewForEditor(editor);
        return;
      }
      return atom.workspace.open("markdown-preview://" + (encodeURI(filePath)), {
        searchAllPanes: true
      });
    },
    copyHtml: function() {
      var editor, text;
      editor = atom.workspace.getActiveTextEditor();
      if (editor == null) {
        return;
      }
      if (renderer == null) {
        renderer = require('./renderer');
      }
      text = editor.getSelectedText() || editor.getText();
      return renderer.toHTML(text, editor.getPath(), editor.getGrammar(), function(error, html) {
        if (error) {
          return console.warn('Copying Markdown as HTML failed', error);
        } else {
          return atom.clipboard.write(html);
        }
      });
    },
    saveAsHtml: function() {
      var activePane, editor, grammars, markdownPreviewPane, previousActivePane, ref, ref1, uri;
      activePane = atom.workspace.getActivePaneItem();
      if (isMarkdownPreviewView(activePane)) {
        activePane.saveAs();
        return;
      }
      editor = atom.workspace.getActiveTextEditor();
      if (editor == null) {
        return;
      }
      grammars = (ref = atom.config.get('markdown-preview.grammars')) != null ? ref : [];
      if (ref1 = editor.getGrammar().scopeName, indexOf.call(grammars, ref1) < 0) {
        return;
      }
      uri = this.uriForEditor(editor);
      markdownPreviewPane = atom.workspace.paneForURI(uri);
      if (markdownPreviewPane == null) {
        return;
      }
      previousActivePane = atom.workspace.getActivePane();
      markdownPreviewPane.activate();
      activePane = atom.workspace.getActivePaneItem();
      if (isMarkdownPreviewView(activePane)) {
        return activePane.saveAs().then(function() {
          return previousActivePane.activate();
        });
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
