'use strict';

const net = require('net');
const debug = require('debug')('log4js:logserver');

const tcpServer = (config) => {
  const port = config.port || 5000;
  const host = config.host || 'localhost';

  /* eslint prefer-arrow-callback:0 */
  const server = net.createServer(function serverCreated(clientSocket) {
    clientSocket.setEncoding('utf8');
    let logMessage = '';

    function logTheMessage(msg) {
      if (logMessage.length > 0) {
        debug('deserialising log event and sending to actual appender');
        actualAppender(deserializeLoggingEvent(clientSocket, msg));
      }
    }

    function chunkReceived(chunk) {
      debug('chunk of data received');
      let event;
      logMessage += chunk || '';
      if (logMessage.indexOf(END_MSG) > -1) {
        event = logMessage.substring(0, logMessage.indexOf(END_MSG));
        logTheMessage(event);
        logMessage = logMessage.substring(event.length + END_MSG.length) || '';
        // check for more, maybe it was a big chunk
        chunkReceived();
      }
    }

    clientSocket.on('data', chunkReceived);
    clientSocket.on('end', chunkReceived);
  });

  server.listen(config.loggerPort || 5000, config.loggerHost || 'localhost', function () {
    debug('master server listening');
    // allow the process to exit, if this is the only socket active
    server.unref();
  });
};

class LogServer {

  constructor(config) {
    if (config.tcp) {
      this.tcpServer = tcpServer(config.tcp);
    }
  }

  shutdown(cb) {
    this.tcpServer.shutdown(cb);
  }
}

exports.LogServer = LogServer;
// exports.serialise = (logEvent) => {
//
// };
