Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _statusBarItem = require('./status-bar-item');

var _statusBarItem2 = _interopRequireDefault(_statusBarItem);

var _helpers = require('./helpers');

var _helpers2 = _interopRequireDefault(_helpers);

'use babel';

var LineEndingRegExp = /\r\n|\n/g;
var LFRegExp = /(^|[^\r])\n/g;
var CRLFRegExp = /\r\n/g;

var disposables = null;
var modalPanel = null;
var lineEndingListView = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.commands.add('atom-text-editor', {
    'line-ending-selector:show': function lineEndingSelectorShow(event) {
      if (!modalPanel) {
        lineEndingListView = new _atomSelectList2['default']({
          items: [{ name: 'LF', value: '\n' }, { name: 'CRLF', value: '\r\n' }],
          filterKeyForItem: function filterKeyForItem(lineEnding) {
            return lineEnding.name;
          },
          didConfirmSelection: function didConfirmSelection(lineEnding) {
            // TODO[v1.19]: Remove conditional once atom.workspace.getActiveTextEditor ships in Atom v1.19
            if (atom.workspace.getActiveTextEditor) {
              setLineEnding(atom.workspace.getActiveTextEditor(), lineEnding.value);
            } else {
              setLineEnding(atom.workspace.getActivePaneItem(), lineEnding.value);
            }
            modalPanel.hide();
          },
          didCancelSelection: function didCancelSelection() {
            modalPanel.hide();
          },
          elementForItem: function elementForItem(lineEnding) {
            var element = document.createElement('li');
            element.textContent = lineEnding.name;
            return element;
          }
        });
        modalPanel = atom.workspace.addModalPanel({ item: lineEndingListView });
        disposables.add(new _atom.Disposable(function () {
          lineEndingListView.destroy();
          modalPanel.destroy();
          modalPanel = null;
        }));
      }

      lineEndingListView.reset();
      modalPanel.show();
      lineEndingListView.focus();
    },

    'line-ending-selector:convert-to-LF': function lineEndingSelectorConvertToLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\n');
    },

    'line-ending-selector:convert-to-CRLF': function lineEndingSelectorConvertToCRLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\r\n');
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var statusBarItem = new _statusBarItem2['default']();
  var currentBufferDisposable = null;
  var tooltipDisposable = null;

  var updateTile = _underscorePlus2['default'].debounce(function (buffer) {
    getLineEndings(buffer).then(function (lineEndings) {
      if (lineEndings.size === 0) {
        var defaultLineEnding = getDefaultLineEnding();
        buffer.setPreferredLineEnding(defaultLineEnding);
        lineEndings = new Set().add(defaultLineEnding);
      }
      statusBarItem.setLineEndings(lineEndings);
    });
  }, 0);

  var observeActiveItem = function observeActiveItem(item) {
    if (currentBufferDisposable) currentBufferDisposable.dispose();

    if (item && item.getBuffer) {
      (function () {
        var buffer = item.getBuffer();
        updateTile(buffer);
        currentBufferDisposable = buffer.onDidChange(function (_ref) {
          var oldText = _ref.oldText;
          var newText = _ref.newText;

          if (!statusBarItem.hasLineEnding('\n')) {
            if (newText.indexOf('\n') >= 0) {
              updateTile(buffer);
            }
          } else if (!statusBarItem.hasLineEnding('\r\n')) {
            if (newText.indexOf('\r\n') >= 0) {
              updateTile(buffer);
            }
          } else if (oldText.indexOf('\n')) {
            updateTile(buffer);
          }
        });
      })();
    } else {
      statusBarItem.setLineEndings(new Set());
      currentBufferDisposable = null;
    }

    if (tooltipDisposable) {
      disposables.remove(tooltipDisposable);
      tooltipDisposable.dispose();
    }
    tooltipDisposable = atom.tooltips.add(statusBarItem.element, {
      title: function title() {
        return 'File uses ' + statusBarItem.description() + ' line endings';
      }
    });
    disposables.add(tooltipDisposable);
  };

  // TODO[v1.19]: Remove conditional once atom.workspace.observeActiveTextEditor ships in Atom v1.19
  if (atom.workspace.observeActiveTextEditor) {
    disposables.add(atom.workspace.observeActiveTextEditor(observeActiveItem));
  } else {
    disposables.add(atom.workspace.observeActivePaneItem(observeActiveItem));
  }

  disposables.add(new _atom.Disposable(function () {
    if (currentBufferDisposable) currentBufferDisposable.dispose();
  }));

  statusBarItem.onClick(function () {
    var editor = undefined;

    // TODO[v1.19]: Remove conditional once atom.workspace.getActiveTextEditor ships in Atom v1.19
    if (atom.workspace.getActiveTextEditor) {
      editor = atom.workspace.getActiveTextEditor();
    } else {
      editor = atom.workspace.getActivePaneItem();
    }

    atom.commands.dispatch(atom.views.getView(editor), 'line-ending-selector:show');
  });

  var tile = statusBar.addRightTile({ item: statusBarItem, priority: 200 });
  disposables.add(new _atom.Disposable(function () {
    return tile.destroy();
  }));
}

function getDefaultLineEnding() {
  switch (atom.config.get('line-ending-selector.defaultLineEnding')) {
    case 'LF':
      return '\n';
    case 'CRLF':
      return '\r\n';
    case 'OS Default':
    default:
      return _helpers2['default'].getProcessPlatform() === 'win32' ? '\r\n' : '\n';
  }
}

function getLineEndings(buffer) {
  if (typeof buffer.find === 'function') {
    return Promise.all([buffer.find(LFRegExp), buffer.find(CRLFRegExp)]).then(function (_ref2) {
      var _ref22 = _slicedToArray(_ref2, 2);

      var hasLF = _ref22[0];
      var hasCRLF = _ref22[1];

      var result = new Set();
      if (hasLF) result.add('\n');
      if (hasCRLF) result.add('\r\n');
      return result;
    });
  } else {
    return new Promise(function (resolve) {
      var result = new Set();
      for (var i = 0; i < buffer.getLineCount() - 1; i++) {
        result.add(buffer.lineEndingForRow(i));
      }
      resolve(result);
    });
  }
}

function setLineEnding(item, lineEnding) {
  if (item && item.getBuffer) {
    var buffer = item.getBuffer();
    buffer.setPreferredLineEnding(lineEnding);
    buffer.setText(buffer.getText().replace(LineEndingRegExp, lineEnding));
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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