Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _atom = require('atom');

var _imageEditorView = require('./image-editor-view');

var _imageEditorView2 = _interopRequireDefault(_imageEditorView);

// Editor model for an image file

var ImageEditor = (function () {
  _createClass(ImageEditor, null, [{
    key: 'deserialize',
    value: function deserialize(_ref) {
      var filePath = _ref.filePath;

      if (_fsPlus2['default'].isFileSync(filePath)) {
        return new ImageEditor(filePath);
      } else {
        console.warn('Could not deserialize image editor for path \'' + filePath + '\' because that file no longer exists');
      }
    }
  }]);

  function ImageEditor(filePath) {
    _classCallCheck(this, ImageEditor);

    this.file = new _atom.File(filePath);
    this.subscriptions = new _atom.CompositeDisposable();
    this.emitter = new _atom.Emitter();
  }

  _createClass(ImageEditor, [{
    key: 'serialize',
    value: function serialize() {
      return { filePath: this.getPath(), deserializer: this.constructor.name };
    }
  }, {
    key: 'terminatePendingState',
    value: function terminatePendingState() {
      if (this.isEqual(atom.workspace.getActivePane().getPendingItem())) {
        this.emitter.emit('did-terminate-pending-state');
      }
    }
  }, {
    key: 'onDidTerminatePendingState',
    value: function onDidTerminatePendingState(callback) {
      return this.emitter.on('did-terminate-pending-state', callback);
    }

    // Register a callback for when the image file changes
  }, {
    key: 'onDidChange',
    value: function onDidChange(callback) {
      var changeSubscription = this.file.onDidChange(callback);
      this.subscriptions.add(changeSubscription);
      return changeSubscription;
    }

    // Register a callback for whne the image's title changes
  }, {
    key: 'onDidChangeTitle',
    value: function onDidChangeTitle(callback) {
      var renameSubscription = this.file.onDidRename(callback);
      this.subscriptions.add(renameSubscription);
      return renameSubscription;
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      if (this.view) {
        this.view.destroy();
      }
    }

    // Retrieves the filename of the open file.
    //
    // This is `'untitled'` if the file is new and not saved to the disk.
    //
    // Returns a {String}.
  }, {
    key: 'getTitle',
    value: function getTitle() {
      var filePath = this.getPath();
      if (filePath) {
        return _path2['default'].basename(filePath);
      } else {
        return 'untitled';
      }
    }

    // Retrieves the absolute path to the image.
    //
    // Returns a {String} path.
  }, {
    key: 'getPath',
    value: function getPath() {
      return this.file.getPath();
    }

    // Retrieves the URI of the image.
    //
    // Returns a {String}.
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.getPath();
    }

    // Retrieves the encoded URI of the image.
    //
    // Returns a {String}.
  }, {
    key: 'getEncodedURI',
    value: function getEncodedURI() {
      return 'file://' + encodeURI(this.getPath().replace(/\\/g, '/')).replace(/#/g, '%23').replace(/\?/g, '%3F');
    }

    // Compares two {ImageEditor}s to determine equality.
    //
    // Equality is based on the condition that the two URIs are the same.
    //
    // Returns a {Boolean}.
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      return other instanceof ImageEditor && this.getURI() === other.getURI();
    }

    // Essential: Invoke the given callback when the editor is destroyed.
    //
    // * `callback` {Function} to be called when the editor is destroyed.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidDestroy',
    value: function onDidDestroy(callback) {
      return this.emitter.on('did-destroy', callback);
    }
  }, {
    key: 'element',
    get: function get() {
      return this.view.element;
    }
  }, {
    key: 'view',
    get: function get() {
      if (!this.editorView) {
        this.editorView = new _imageEditorView2['default'](this);
      }
      return this.editorView;
    }
  }]);

  return ImageEditor;
})();

exports['default'] = ImageEditor;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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