'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

let Timeago = (_temp = _class = class Timeago extends _react2.default.Component {

  static getTimeDisplay(time) {
    let now = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (0, _moment2.default)();

    const m = (0, _moment2.default)(time);
    const diff = m.diff(now, 'months', true);
    if (Math.abs(diff) <= 1) {
      return m.from(now);
    } else {
      const format = m.format('MMM Do, YYYY');
      return `on ${format}`;
    }
  }

  render() {
    var _props = this.props;

    const type = _props.type,
          time = _props.time,
          others = _objectWithoutProperties(_props, ['type', 'time']);

    const display = Timeago.getTimeDisplay(time);
    const Type = type;
    const className = (0, _classnames2.default)('timeago', others.className);
    return _react2.default.createElement(
      Type,
      _extends({}, others, { className: className }),
      display
    );
  }
}, _class.propTypes = {
  time: _propTypes2.default.any.isRequired,
  type: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func])
}, _class.defaultProps = {
  type: 'span'
}, _temp);
exports.default = Timeago;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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