'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _coreDecorators = require('core-decorators');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let Resizer = (_class = (_temp = _class2 = class Resizer extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = {
      dragging: false,
      start: null,
      lastSize: props.size
    };
  }

  render() {
    var _props = this.props;

    const onChange = _props.onChange,
          children = _props.children,
          className = _props.className,
          others = _objectWithoutProperties(_props, ['onChange', 'children', 'className']); // eslint-disable-line no-unused-vars


    return _react2.default.createElement(
      'div',
      _extends({}, others, { className: (0, _classnames2.default)('resizer-container', className) }),
      _react2.default.createElement(
        'div',
        { className: 'sizing-handle', onMouseDown: this.handleMouseDown },
        '\xA0'
      ),
      _react2.default.createElement(
        'div',
        { className: 'content', style: { width: this.props.size } },
        children
      )
    );
  }

  handleMouseDown(e) {
    // save off copy since synthetic event will be recycled
    // by the time the `setState` function runs
    const clientX = e.clientX;
    this.setState(s => ({
      dragging: true,
      start: clientX,
      lastSize: this.props.size
    }));

    document.addEventListener('mousemove', this.handleMouseMove);
    document.addEventListener('mouseup', this.handleMouseUp);
  }

  handleMouseUp(e) {
    document.removeEventListener('mousemove', this.handleMouseMove);
    document.removeEventListener('mouseup', this.handleMouseUp);

    this.setState({
      dragging: false
    });
  }

  handleMouseMove(e) {
    if (!this.state.dragging) {
      return;
    }
    const oldPos = this.state.start;
    const delta = oldPos - e.clientX;
    const newSize = Math.max(0, this.state.lastSize + delta);
    this.props.onChange(newSize);
  }
}, _class2.propTypes = {
  size: _propTypes2.default.number.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  className: _propTypes2.default.string,
  children: _propTypes2.default.element
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleMouseDown', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleMouseDown'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleMouseUp', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleMouseUp'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleMouseMove', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleMouseMove'), _class.prototype)), _class);
exports.default = Resizer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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