'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let PushPullView = (_temp = _class = class PushPullView extends _react2.default.Component {

  render() {
    const pushing = this.props.pushInProgress;
    const pulling = this.props.fetchInProgress;
    const pushClasses = (0, _classnames2.default)('github-PushPull-icon', 'icon', { 'icon-arrow-up': !pushing, 'icon-sync': pushing });
    const pullClasses = (0, _classnames2.default)('github-PushPull-icon', 'icon', { 'icon-arrow-down': !pulling, 'icon-sync': pulling });
    return _react2.default.createElement(
      'div',
      { className: 'github-PushPull inline-block', ref: e => {
          this.element = e;
        } },
      _react2.default.createElement('span', { className: pullClasses }),
      _react2.default.createElement(
        'span',
        { className: 'github-PushPull-label is-pull' },
        this.props.behindCount ? `${this.props.behindCount}` : ''
      ),
      _react2.default.createElement('span', { className: pushClasses }),
      _react2.default.createElement(
        'span',
        { className: 'github-PushPull-label is-push' },
        this.props.aheadCount ? `${this.props.aheadCount}` : ''
      )
    );
  }
}, _class.propTypes = {
  pushInProgress: _propTypes2.default.bool,
  fetchInProgress: _propTypes2.default.bool,
  behindCount: _propTypes2.default.number,
  aheadCount: _propTypes2.default.number
}, _class.defaultProps = {
  pushInProgress: false,
  fetchInProgress: false,
  behindCount: 0,
  aheadCount: 0
}, _temp);
exports.default = PushPullView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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