'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * `Portal` is a mechanism for rendering a React subtree at a different place
 * in the DOM.
 *
 *    <Portal type="span" className="portal-class" appendNode={true}>
 *      <Stuff />
 *    </Portal>
 *
 * Given the above example, there will be a span with the class "portal-class"
 * created and appended to the document body, and then `<Stuff />` will be
 * rendered into it. Note that this uses `unstable_renderSubtreeIntoContainer`
 * to preserve context in the subtree.
 *
 * `getElement()` allows access to the React subtree container element.
 * `getRenderedSubtree()` allows access to the rendered subtree instance
 * (`Stuff` in the example above).
 *
 * Pass `false` (the default) to `appendNode` to skip adding the node to the
 * DOM. `type` defaults to "div" and `className` defaults to
 * "react-atom-portal".
 */
let Portal = (_temp = _class = class Portal extends _react2.default.Component {

  componentDidMount() {
    let node;
    if (this.props.getDOMNode) {
      node = this.props.getDOMNode();
    }

    if (!node) {
      node = document.createElement(this.props.type);
      node.className = this.props.className;
    }

    this.node = node;

    if (this.props.appendNode) {
      document.body.appendChild(this.node);
    }
    this.renderPortal(this.props);
  }

  componentWillReceiveProps(newProps) {
    this.renderPortal(newProps);
  }

  componentWillUnmount() {
    _reactDom2.default.unmountComponentAtNode(this.node);
    if (this.props.appendNode) {
      document.body.removeChild(this.node);
    }
  }

  renderPortal(props) {
    this.subtree = _reactDom2.default.unstable_renderSubtreeIntoContainer(this, props.children, this.node);
  }

  shouldComponentUpdate() {
    return false;
  }

  render() {
    return null;
  }

  getRenderedSubtree() {
    return this.subtree;
  }

  getElement() {
    return this.node;
  }

  getView() {
    if (this.view) {
      return this.view;
    }

    const override = {
      getPortal: () => this,
      getInstance: () => this.subtree,
      getElement: this.getElement.bind(this)
    };

    this.view = new Proxy(override, {
      get(target, name) {
        if (Reflect.has(target, name)) {
          return target[name];
        }

        return target.getInstance()[name];
      },

      set(target, name, value) {
        target.getInstance()[name] = value;
      },

      has(target, name) {
        return Reflect.has(target.getInstance(), name) || Reflect.has(target, name);
      }
    });
    return this.view;
  }
}, _class.propTypes = {
  type: _propTypes2.default.string,
  className: _propTypes2.default.string,
  appendNode: _propTypes2.default.bool,
  getDOMNode: _propTypes2.default.func
}, _class.defaultProps = {
  type: 'div',
  className: 'react-atom-portal',
  appendNode: false,
  getDOMNode: null
}, _temp);
exports.default = Portal;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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