'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

let FilePatchListItemView = class FilePatchListItemView {
  constructor(props) {
    this.props = props;
    _etch2.default.initialize(this);
    this.props.registerItemElement(this.props.mergeConflict, this.element);
  }

  update(props) {
    this.props = props;
    this.props.registerItemElement(this.props.mergeConflict, this.element);
    return _etch2.default.update(this);
  }

  render() {
    var _props = this.props;

    const mergeConflict = _props.mergeConflict,
          selected = _props.selected,
          others = _objectWithoutProperties(_props, ['mergeConflict', 'selected']);

    const fileStatus = _helpers.classNameForStatus[mergeConflict.status.file];
    const oursStatus = _helpers.classNameForStatus[mergeConflict.status.ours];
    const theirsStatus = _helpers.classNameForStatus[mergeConflict.status.theirs];
    const className = selected ? 'is-selected' : '';

    return _etch2.default.dom(
      'div',
      _extends({}, others, { className: `github-MergeConflictListView-item is-${fileStatus} ${className}` }),
      _etch2.default.dom(
        'div',
        { className: 'github-FilePatchListView-item github-FilePatchListView-pathItem' },
        _etch2.default.dom('span', { className: `github-FilePatchListView-icon icon icon-diff-${fileStatus} status-${fileStatus}` }),
        _etch2.default.dom(
          'span',
          { className: 'github-FilePatchListView-path' },
          mergeConflict.filePath
        ),
        _etch2.default.dom(
          'span',
          { className: 'github-FilePatchListView ours-theirs-info' },
          _etch2.default.dom('span', { className: `github-FilePatchListView-icon icon icon-diff-${oursStatus}` }),
          _etch2.default.dom('span', { className: `github-FilePatchListView-icon icon icon-diff-${theirsStatus}` })
        )
      ),
      _etch2.default.dom(
        'div',
        { className: 'github-FilePatchListView-item github-FilePatchListView-resolutionItem' },
        this.renderRemainingConflicts()
      )
    );
  }

  renderRemainingConflicts() {
    if (this.props.remainingConflicts === 0) {
      return _etch2.default.dom(
        'span',
        { className: 'icon icon-check github-RemainingConflicts text-success' },
        'ready'
      );
    } else if (this.props.remainingConflicts !== undefined) {
      const pluralConflicts = this.props.remainingConflicts === 1 ? '' : 's';

      return _etch2.default.dom(
        'span',
        { className: 'github-RemainingConflicts text-warning' },
        this.props.remainingConflicts,
        ' conflict',
        pluralConflicts,
        ' remaining'
      );
    } else {
      return _etch2.default.dom(
        'span',
        { className: 'github-RemainingConflicts text-subtle' },
        'calculating'
      );
    }
  }
};
exports.default = FilePatchListItemView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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