'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _coreDecorators = require('core-decorators');

var _hunkView = require('./hunk-view');

var _hunkView2 = _interopRequireDefault(_hunkView);

var _simpleTooltip = require('./simple-tooltip');

var _simpleTooltip2 = _interopRequireDefault(_simpleTooltip);

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

var _filePatchSelection = require('./file-patch-selection');

var _filePatchSelection2 = _interopRequireDefault(_filePatchSelection);

var _switchboard = require('../switchboard');

var _switchboard2 = _interopRequireDefault(_switchboard);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let FilePatchView = (_class = (_temp = _class2 = class FilePatchView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.mouseSelectionInProgress = false;
    this.disposables = new _eventKit.CompositeDisposable();

    this.state = {
      selection: new _filePatchSelection2.default(this.props.hunks)
    };
  }

  componentDidMount() {
    window.addEventListener('mouseup', this.mouseup);
    this.disposables.add(new _eventKit.Disposable(() => window.removeEventListener('mouseup', this.mouseup)));
  }

  componentWillReceiveProps(nextProps) {
    const hunksChanged = this.props.hunks.length !== nextProps.hunks.length || this.props.hunks.some((hunk, index) => hunk !== nextProps.hunks[index]);

    if (hunksChanged) {
      this.setState(prevState => {
        return {
          selection: prevState.selection.updateHunks(nextProps.hunks)
        };
      }, () => {
        nextProps.switchboard.didChangePatch();
      });
    }
  }

  render() {
    const selectedHunks = this.state.selection.getSelectedHunks();
    const selectedLines = this.state.selection.getSelectedLines();
    const headHunk = this.state.selection.getHeadHunk();
    const headLine = this.state.selection.getHeadLine();
    const hunkSelectionMode = this.state.selection.getMode() === 'hunk';

    const unstaged = this.props.stagingStatus === 'unstaged';
    const stageButtonLabelPrefix = unstaged ? 'Stage' : 'Unstage';

    return _react2.default.createElement(
      'div',
      {
        className: (0, _classnames2.default)('github-FilePatchView', { 'is-staged': !unstaged, 'is-unstaged': unstaged }),
        tabIndex: '-1',
        onMouseUp: this.mouseup,
        ref: e => {
          this.element = e;
        } },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-FilePatchView' },
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-patch-selection-mode', callback: this.togglePatchSelectionMode }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.didConfirm }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-up', callback: this.selectPrevious }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-down', callback: this.selectNext }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-right', callback: this.didMoveRight }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-to-top', callback: this.selectFirst }),
        _react2.default.createElement(_commands.Command, { command: 'core:move-to-bottom', callback: this.selectLast }),
        _react2.default.createElement(_commands.Command, { command: 'core:select-up', callback: this.selectToPrevious }),
        _react2.default.createElement(_commands.Command, { command: 'core:select-down', callback: this.selectToNext }),
        _react2.default.createElement(_commands.Command, { command: 'core:select-to-top', callback: this.selectToFirst }),
        _react2.default.createElement(_commands.Command, { command: 'core:select-to-bottom', callback: this.selectToLast }),
        _react2.default.createElement(_commands.Command, { command: 'core:select-all', callback: this.selectAll }),
        _react2.default.createElement(_commands.Command, { command: 'github:select-next-hunk', callback: this.selectNextHunk }),
        _react2.default.createElement(_commands.Command, { command: 'github:select-previous-hunk', callback: this.selectPreviousHunk }),
        _react2.default.createElement(_commands.Command, { command: 'github:open-file', callback: this.openFile }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:view-corresponding-diff',
          callback: () => this.props.isPartiallyStaged && this.props.didDiveIntoCorrespondingFilePatch()
        }),
        _react2.default.createElement(_commands.Command, { command: 'github:discard-selected-lines', callback: this.discardSelection }),
        _react2.default.createElement(_commands.Command, {
          command: 'core:undo',
          callback: () => this.props.hasUndoHistory && this.props.undoLastDiscard()
        })
      ),
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, {
          command: 'github:undo-last-discard-in-diff-view',
          callback: () => this.props.hasUndoHistory && this.props.undoLastDiscard()
        })
      ),
      _react2.default.createElement(
        'header',
        { className: 'github-FilePatchView-header' },
        _react2.default.createElement(
          'span',
          { className: 'github-FilePatchView-title' },
          unstaged ? 'Unstaged Changes for ' : 'Staged Changes for ',
          this.props.filePath
        ),
        this.renderButtonGroup()
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-FilePatchView-container' },
        this.props.hunks.map(hunk => {
          const isSelected = selectedHunks.has(hunk);
          let stageButtonSuffix = hunkSelectionMode || !isSelected ? ' Hunk' : ' Selection';
          if (selectedHunks.size > 1 && selectedHunks.has(hunk)) {
            stageButtonSuffix += 's';
          }
          const stageButtonLabel = stageButtonLabelPrefix + stageButtonSuffix;
          const discardButtonLabel = 'Discard' + stageButtonSuffix;

          return _react2.default.createElement(_hunkView2.default, {
            key: hunk.getHeader(),
            tooltips: this.props.tooltips,
            hunk: hunk,
            isSelected: selectedHunks.has(hunk),
            hunkSelectionMode: hunkSelectionMode,
            unstaged: unstaged,
            stageButtonLabel: stageButtonLabel,
            discardButtonLabel: discardButtonLabel,
            selectedLines: selectedLines,
            headLine: headLine,
            headHunk: headHunk,
            mousedownOnHeader: e => this.mousedownOnHeader(e, hunk),
            mousedownOnLine: this.mousedownOnLine,
            mousemoveOnLine: this.mousemoveOnLine,
            contextMenuOnItem: this.contextMenuOnItem,
            didClickStageButton: () => this.didClickStageButtonForHunk(hunk),
            didClickDiscardButton: () => this.didClickDiscardButtonForHunk(hunk)
          });
        })
      )
    );
  }

  renderButtonGroup() {
    const unstaged = this.props.stagingStatus === 'unstaged';

    return _react2.default.createElement(
      'span',
      { className: 'btn-group' },
      this.props.hasUndoHistory && unstaged ? _react2.default.createElement(
        'button',
        {
          className: 'btn icon icon-history',
          onClick: this.props.undoLastDiscard },
        'Undo Discard'
      ) : null,
      this.props.isPartiallyStaged ? _react2.default.createElement(
        _simpleTooltip2.default,
        {
          tooltips: this.props.tooltips,
          title: `View ${unstaged ? 'staged' : 'unstaged'} changes` },
        _react2.default.createElement('button', {
          className: (0, _classnames2.default)('btn', 'icon', { 'icon-tasklist': unstaged, 'icon-list-unordered': !unstaged }),
          onClick: this.props.didDiveIntoCorrespondingFilePatch
        })
      ) : null,
      _react2.default.createElement(
        _simpleTooltip2.default,
        {
          tooltips: this.props.tooltips,
          title: 'Open File' },
        _react2.default.createElement('button', {
          className: 'btn icon icon-code',
          onClick: this.openFile
        })
      ),
      _react2.default.createElement(
        'button',
        {
          className: (0, _classnames2.default)('btn', 'icon', { 'icon-move-down': unstaged, 'icon-move-up': !unstaged }),
          onClick: this.stageOrUnstageAll },
        unstaged ? 'Stage File' : 'Unstage File'
      )
    );
  }

  componentWillUnmount() {
    this.disposables.dispose();
  }

  contextMenuOnItem(event, hunk, line) {
    const resend = () => {
      const newEvent = new MouseEvent(event.type, event);
      setImmediate(() => event.target.parentNode.dispatchEvent(newEvent));
    };

    const mode = this.state.selection.getMode();
    if (mode === 'hunk' && !this.state.selection.getSelectedHunks().has(hunk)) {
      event.stopPropagation();

      this.setState(prevState => {
        return { selection: prevState.selection.selectHunk(hunk, event.shiftKey) };
      }, resend);
    } else if (mode === 'line' && !this.state.selection.getSelectedLines().has(line)) {
      event.stopPropagation();

      this.setState(prevState => {
        return { selection: prevState.selection.selectLine(line, event.shiftKey) };
      }, resend);
    }
  }

  mousedownOnHeader(event, hunk) {
    if (event.button !== 0) {
      return;
    }
    const windows = process.platform === 'win32';
    if (event.ctrlKey && !windows) {
      return;
    } // simply open context menu

    this.mouseSelectionInProgress = true;
    event.persist && event.persist();

    this.setState(prevState => {
      let selection = prevState.selection;
      if (event.metaKey || event.ctrlKey && windows) {
        if (selection.getMode() === 'hunk') {
          selection = selection.addOrSubtractHunkSelection(hunk);
        } else {
          // TODO: optimize
          selection = hunk.getLines().reduce((current, line) => current.addOrSubtractLineSelection(line).coalesce(), selection);
        }
      } else if (event.shiftKey) {
        if (selection.getMode() === 'hunk') {
          selection = selection.selectHunk(hunk, true);
        } else {
          const hunkLines = hunk.getLines();
          const tailIndex = selection.getLineSelectionTailIndex();
          const selectedHunkAfterTail = tailIndex < hunkLines[0].diffLineNumber;
          if (selectedHunkAfterTail) {
            selection = selection.selectLine(hunkLines[hunkLines.length - 1], true);
          } else {
            selection = selection.selectLine(hunkLines[0], true);
          }
        }
      } else {
        selection = selection.selectHunk(hunk, false);
      }

      return { selection };
    });
  }

  mousedownOnLine(event, hunk, line) {
    if (event.button !== 0) {
      return;
    }
    const windows = process.platform === 'win32';
    if (event.ctrlKey && !windows) {
      return;
    } // simply open context menu

    this.mouseSelectionInProgress = true;
    event.persist && event.persist();

    this.setState(prevState => {
      let selection = prevState.selection;

      if (event.metaKey || event.ctrlKey && windows) {
        if (selection.getMode() === 'hunk') {
          selection = selection.addOrSubtractHunkSelection(hunk);
        } else {
          selection = selection.addOrSubtractLineSelection(line);
        }
      } else if (event.shiftKey) {
        if (selection.getMode() === 'hunk') {
          selection = selection.selectHunk(hunk, true);
        } else {
          selection = selection.selectLine(line, true);
        }
      } else if (event.detail === 1) {
        selection = selection.selectLine(line, false);
      } else if (event.detail === 2) {
        selection = selection.selectHunk(hunk, false);
      }

      return { selection };
    });
  }

  mousemoveOnLine(event, hunk, line) {
    if (!this.mouseSelectionInProgress) {
      return;
    }

    this.setState(prevState => {
      let selection = null;
      if (prevState.selection.getMode() === 'hunk') {
        selection = prevState.selection.selectHunk(hunk, true);
      } else {
        selection = prevState.selection.selectLine(line, true);
      }
      return { selection };
    });
  }

  mouseup() {
    this.mouseSelectionInProgress = false;
    this.setState(prevState => {
      return { selection: prevState.selection.coalesce() };
    });
  }

  togglePatchSelectionMode() {
    this.setState(prevState => ({ selection: prevState.selection.toggleMode() }));
  }

  getPatchSelectionMode() {
    return this.state.selection.getMode();
  }

  getSelectedHunks() {
    return this.state.selection.getSelectedHunks();
  }

  getSelectedLines() {
    return this.state.selection.getSelectedLines();
  }

  selectNext() {
    this.setState(prevState => ({ selection: prevState.selection.selectNext() }));
  }

  selectNextHunk() {
    this.setState(prevState => ({ selection: prevState.selection.jumpToNextHunk() }));
  }

  selectToNext() {
    this.setState(prevState => {
      return { selection: prevState.selection.selectNext(true).coalesce() };
    });
  }

  selectPrevious() {
    this.setState(prevState => ({ selection: prevState.selection.selectPrevious() }));
  }

  selectPreviousHunk() {
    this.setState(prevState => ({ selection: prevState.selection.jumpToPreviousHunk() }));
  }

  selectToPrevious() {
    this.setState(prevState => {
      return { selection: prevState.selection.selectPrevious(true).coalesce() };
    });
  }

  selectFirst() {
    this.setState(prevState => ({ selection: prevState.selection.selectFirst() }));
  }

  selectToFirst() {
    this.setState(prevState => ({ selection: prevState.selection.selectFirst(true) }));
  }

  selectLast() {
    this.setState(prevState => ({ selection: prevState.selection.selectLast() }));
  }

  selectToLast() {
    this.setState(prevState => ({ selection: prevState.selection.selectLast(true) }));
  }

  selectAll() {
    return new Promise(resolve => {
      this.setState(prevState => ({ selection: prevState.selection.selectAll() }), resolve);
    });
  }

  getNextHunkUpdatePromise() {
    return this.state.selection.getNextUpdatePromise();
  }

  didClickStageButtonForHunk(hunk) {
    if (this.state.selection.getSelectedHunks().has(hunk)) {
      this.props.attemptLineStageOperation(this.state.selection.getSelectedLines());
    } else {
      this.setState(prevState => ({ selection: prevState.selection.selectHunk(hunk) }), () => {
        this.props.attemptHunkStageOperation(hunk);
      });
    }
  }

  didClickDiscardButtonForHunk(hunk) {
    if (this.state.selection.getSelectedHunks().has(hunk)) {
      this.discardSelection();
    } else {
      this.setState(prevState => ({ selection: prevState.selection.selectHunk(hunk) }), () => {
        this.discardSelection();
      });
    }
  }

  didConfirm() {
    return this.didClickStageButtonForHunk([...this.state.selection.getSelectedHunks()][0]);
  }

  didMoveRight() {
    if (this.props.didSurfaceFile) {
      this.props.didSurfaceFile();
    }
  }

  focus() {
    this.element.focus();
  }

  openFile() {
    let lineNumber = 0;
    const firstSelectedLine = Array.from(this.state.selection.getSelectedLines())[0];
    if (firstSelectedLine && firstSelectedLine.newLineNumber > -1) {
      lineNumber = firstSelectedLine.newLineNumber;
    } else {
      const firstSelectedHunk = Array.from(this.state.selection.getSelectedHunks())[0];
      lineNumber = firstSelectedHunk ? firstSelectedHunk.getNewStartRow() : 0;
    }
    return this.props.openCurrentFile({ lineNumber });
  }

  stageOrUnstageAll() {
    var _this = this;

    return _asyncToGenerator(function* () {
      yield _this.selectAll();
      _this.didConfirm();
    })();
  }

  discardSelection() {
    const selectedLines = this.state.selection.getSelectedLines();
    return selectedLines.size ? this.props.discardLines(selectedLines) : null;
  }

  goToDiffLine(lineNumber) {
    this.setState(prevState => ({ selection: prevState.selection.goToDiffLine(lineNumber) }));
  }
}, _class2.propTypes = {
  commandRegistry: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  filePath: _propTypes2.default.string.isRequired,
  hunks: _propTypes2.default.arrayOf(_propTypes2.default.object).isRequired,
  stagingStatus: _propTypes2.default.oneOf(['unstaged', 'staged']).isRequired,
  isPartiallyStaged: _propTypes2.default.bool.isRequired,
  hasUndoHistory: _propTypes2.default.bool.isRequired,
  attemptLineStageOperation: _propTypes2.default.func.isRequired,
  attemptHunkStageOperation: _propTypes2.default.func.isRequired,
  discardLines: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  openCurrentFile: _propTypes2.default.func.isRequired,
  didSurfaceFile: _propTypes2.default.func.isRequired,
  didDiveIntoCorrespondingFilePatch: _propTypes2.default.func.isRequired,
  switchboard: _propTypes2.default.instanceOf(_switchboard2.default)
}, _class2.defaultProps = {
  switchboard: new _switchboard2.default()
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'renderButtonGroup', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderButtonGroup'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'contextMenuOnItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'contextMenuOnItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mousedownOnLine', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousedownOnLine'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mousemoveOnLine', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mousemoveOnLine'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mouseup', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'mouseup'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'togglePatchSelectionMode', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'togglePatchSelectionMode'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectNext', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectNext'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectNextHunk', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectNextHunk'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectToNext', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectToNext'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectPrevious', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectPrevious'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectPreviousHunk', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectPreviousHunk'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectToPrevious', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectToPrevious'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectFirst', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectFirst'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectToFirst', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectToFirst'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectLast', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectLast'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectToLast', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectToLast'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectAll', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectAll'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didConfirm', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didConfirm'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didMoveRight', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didMoveRight'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openFile', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageOrUnstageAll', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'stageOrUnstageAll'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardSelection', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'discardSelection'), _class.prototype)), _class);
exports.default = FilePatchView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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