'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

let FilePatchListItemView = class FilePatchListItemView {
  constructor(props) {
    this.props = props;
    _etch2.default.initialize(this);
    this.props.registerItemElement(this.props.filePatch, this.element);
  }

  update(props) {
    this.props = props;
    this.props.registerItemElement(this.props.filePatch, this.element);
    return _etch2.default.update(this);
  }

  render() {
    var _props = this.props;

    const filePatch = _props.filePatch,
          selected = _props.selected,
          others = _objectWithoutProperties(_props, ['filePatch', 'selected']);

    const status = _helpers.classNameForStatus[filePatch.status];
    const className = selected ? 'is-selected' : '';

    return _etch2.default.dom(
      'div',
      _extends({}, others, { className: `github-FilePatchListView-item is-${status} ${className}` }),
      _etch2.default.dom('span', { className: `github-FilePatchListView-icon icon icon-diff-${status} status-${status}` }),
      _etch2.default.dom(
        'span',
        { className: 'github-FilePatchListView-path' },
        filePatch.filePath
      )
    );
  }
};
exports.default = FilePatchListItemView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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