'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.expectedDelegates = undefined;

var _desc, _value, _class;

var _commit = require('../commit');

var _branch = require('../branch');

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const expectedDelegates = exports.expectedDelegates = [];

/**
 * Map of registered subclasses to allow states to transition to one another without circular dependencies.
 * Subclasses of State should call `State.register` to add themselves here.
 */
const stateConstructors = new Map();

/**
 * Methods marked with this decorator on State should be delegated from a Repository to its current state. This will
 * be verified by a unit test in `repository.test.js`.
 */
function shouldDelegate(target, name, descriptor) {
  expectedDelegates.push(name);
  return descriptor;
}

/**
 * Base class for Repository states. Implements default "null" behavior.
 */
let State = (_class = class State {
  constructor(repository) {
    this.repository = repository;
  }

  static register(Subclass) {
    stateConstructors.set(Subclass.name, Subclass);
  }

  // This state has just been entered. Perform any asynchronous initialization that needs to occur.
  start() {
    return Promise.resolve();
  }

  // State probe predicates ////////////////////////////////////////////////////////////////////////////////////////////
  // Allow external callers to identify which state a Repository is in if necessary.

  isLoadingGuess() {
    return false;
  }

  isAbsentGuess() {
    return false;
  }

  isAbsent() {
    return false;
  }

  isLoading() {
    return false;
  }

  isEmpty() {
    return false;
  }

  isPresent() {
    return false;
  }

  isDestroyed() {
    return false;
  }

  // Behavior probe predicates /////////////////////////////////////////////////////////////////////////////////////////
  // Determine specific rendering behavior based on the current state.

  isUndetermined() {
    return false;
  }

  showGitTabInit() {
    return false;
  }

  showGitTabInitInProgress() {
    return false;
  }

  showGitTabLoading() {
    return false;
  }

  showStatusBarTiles() {
    return false;
  }

  hasDirectory() {
    return true;
  }

  // Lifecycle actions /////////////////////////////////////////////////////////////////////////////////////////////////
  // These generally default to rejecting a Promise with an error.

  init() {
    return unsupportedOperationPromise(this, 'init');
  }

  clone(remoteUrl) {
    return unsupportedOperationPromise(this, 'clone');
  }

  destroy() {
    return this.transitionTo('Destroyed');
  }

  refresh() {
    // No-op
  }

  observeFilesystemChange(events) {
    this.repository.refresh();
  }

  // Git operations ////////////////////////////////////////////////////////////////////////////////////////////////////
  // These default to rejecting a Promise with an error stating that the operation is not supported in the current
  // state.

  // Staging and unstaging

  stageFiles(paths) {
    return unsupportedOperationPromise(this, 'stageFiles');
  }

  unstageFiles(paths) {
    return unsupportedOperationPromise(this, 'unstageFiles');
  }

  stageFilesFromParentCommit(paths) {
    return unsupportedOperationPromise(this, 'stageFilesFromParentCommit');
  }

  applyPatchToIndex(patch) {
    return unsupportedOperationPromise(this, 'applyPatchToIndex');
  }

  applyPatchToWorkdir(patch) {
    return unsupportedOperationPromise(this, 'applyPatchToWorkdir');
  }

  // Committing

  commit(message, options) {
    return unsupportedOperationPromise(this, 'commit');
  }

  // Merging

  merge(branchName) {
    return unsupportedOperationPromise(this, 'merge');
  }

  abortMerge() {
    return unsupportedOperationPromise(this, 'abortMerge');
  }

  checkoutSide(side, paths) {
    return unsupportedOperationPromise(this, 'checkoutSide');
  }

  mergeFile(oursPath, commonBasePath, theirsPath, resultPath) {
    return unsupportedOperationPromise(this, 'mergeFile');
  }

  writeMergeConflictToIndex(filePath, commonBaseSha, oursSha, theirsSha) {
    return unsupportedOperationPromise(this, 'writeMergeConflictToIndex');
  }

  // Checkout

  checkout(revision) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return unsupportedOperationPromise(this, 'checkout');
  }

  checkoutPathsAtRevision(paths) {
    let revision = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'HEAD';

    return unsupportedOperationPromise(this, 'checkoutPathsAtRevision');
  }

  // Remote interactions

  fetch(branchName) {
    return unsupportedOperationPromise(this, 'fetch');
  }

  pull(branchName) {
    return unsupportedOperationPromise(this, 'pull');
  }

  push(branchName) {
    return unsupportedOperationPromise(this, 'push');
  }

  // Configuration

  setConfig(option, value) {
    var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    let replaceAll = _ref.replaceAll;

    return unsupportedOperationPromise(this, 'setConfig');
  }

  unsetConfig(option) {
    return unsupportedOperationPromise(this, 'unsetConfig');
  }

  // Direct blob interactions

  createBlob() {
    var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let filePath = _ref2.filePath,
        stdin = _ref2.stdin;

    return unsupportedOperationPromise(this, 'createBlob');
  }

  expandBlobToFile(absFilePath, sha) {
    return unsupportedOperationPromise(this, 'expandBlobToFile');
  }

  // Discard history

  createDiscardHistoryBlob() {
    return unsupportedOperationPromise(this, 'createDiscardHistoryBlob');
  }

  updateDiscardHistory() {
    return unsupportedOperationPromise(this, 'updateDiscardHistory');
  }

  storeBeforeAndAfterBlobs(filePaths, isSafe, destructiveAction) {
    let partialDiscardFilePath = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

    return unsupportedOperationPromise(this, 'storeBeforeAndAfterBlobs');
  }

  restoreLastDiscardInTempFiles(isSafe) {
    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    return unsupportedOperationPromise(this, 'restoreLastDiscardInTempFiles');
  }

  popDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return unsupportedOperationPromise(this, 'popDiscardHistory');
  }

  clearDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return unsupportedOperationPromise(this, 'clearDiscardHistory');
  }

  discardWorkDirChangesForPaths(paths) {
    return unsupportedOperationPromise(this, 'discardWorkDirChangesForPaths');
  }

  // Accessors /////////////////////////////////////////////////////////////////////////////////////////////////////////
  // When possible, these default to "empty" results when invoked in states that don't have information available, or
  // fail in a way that's consistent with the requested information not being found.

  // Index queries

  getStatusBundle() {
    return Promise.resolve({
      stagedFiles: {},
      unstagedFiles: {},
      mergeConflictFiles: {},
      branch: {
        oid: null,
        head: null,
        upstream: null,
        aheadBehind: { ahead: null, behind: null }
      }
    });
  }

  getStatusesForChangedFiles() {
    return Promise.resolve({
      stagedFiles: [],
      unstagedFiles: [],
      mergeConflictFiles: []
    });
  }

  getStagedChangesSinceParentCommit() {
    return Promise.resolve([]);
  }

  getFilePatchForPath(filePath) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return Promise.resolve(null);
  }

  readFileFromIndex(filePath) {
    return Promise.reject(new Error(`fatal: Path ${filePath} does not exist (neither on disk nor in the index).`));
  }

  // Commit access

  getLastCommit() {
    return Promise.resolve(_commit.nullCommit);
  }

  // Branches

  getBranches() {
    return Promise.resolve([]);
  }

  getCurrentBranch() {
    return Promise.resolve(_branch.nullBranch);
  }

  // Merging and rebasing status

  isMerging() {
    return Promise.resolve(false);
  }

  isRebasing() {
    return Promise.resolve(false);
  }

  // Remotes

  getRemotes() {
    return Promise.resolve([]);
  }

  getAheadCount(branchName) {
    return Promise.resolve(null);
  }

  getBehindCount(branchName) {
    return Promise.resolve(null);
  }

  getConfig(option) {
    var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let local = _ref3.local;

    return Promise.resolve(null);
  }

  // Direct blob access

  getBlobContents(sha) {
    return Promise.reject(new Error(`fatal: Not a valid object name ${sha}`));
  }

  // Discard history

  hasDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return false;
  }

  getDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return [];
  }

  getLastHistorySnapshots() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return null;
  }

  // Internal //////////////////////////////////////////////////////////////////////////////////////////////////////////
  // Non-delegated methods that provide subclasses with convenient access to Repository properties.

  git() {
    return this.repository.git;
  }

  workdir() {
    return this.repository.getWorkingDirectoryPath();
  }

  // Call methods on the active Repository state, even if the state has transitioned beneath you.
  // Use this to perform operations within `start()` methods to guard against interrupted state transitions.
  current() {
    return this.repository.state;
  }

  // Return a Promise that will resolve once the state transitions from Loading.
  getLoadPromise() {
    return this.repository.getLoadPromise();
  }

  getRemoteForBranch(branchName) {
    return this.repository.getRemoteForBranch(branchName);
  }

  saveDiscardHistory() {
    return this.repository.saveDiscardHistory();
  }

  // Initiate a transition to another state.
  transitionTo(stateName) {
    const StateConstructor = stateConstructors.get(stateName);
    if (StateConstructor === undefined) {
      throw new Error(`Attempt to transition to unrecognized state ${stateName}`);
    }

    for (var _len = arguments.length, payload = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      payload[_key - 1] = arguments[_key];
    }

    return this.repository.transition(this, StateConstructor, ...payload);
  }

  // Event broadcast

  didDestroy() {
    return this.repository.emitter.emit('did-destroy');
  }

  didUpdate() {
    return this.repository.emitter.emit('did-update');
  }

  // Direct git access
  // Non-delegated git operations for internal use within states.

  directResolveDotGitDir() {
    return Promise.resolve(null);
  }

  directGetConfig(key) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return Promise.resolve(null);
  }

  directGetBlobContents() {
    return Promise.reject(new Error('Not a valid object name'));
  }

  directInit() {
    return Promise.resolve();
  }

  directClone(remoteUrl, options) {
    return Promise.resolve();
  }

  // Deferred operations
  // Direct raw git operations to the current state, even if the state has been changed. Use these methods within
  // start() methods.

  resolveDotGitDir() {
    return this.current().directResolveDotGitDir();
  }

  doInit(workdir) {
    return this.current().directInit();
  }

  doClone(remoteUrl, options) {
    return this.current().directClone(remoteUrl, options);
  }

  // Parse a DiscardHistory payload from the SHA recorded in config.
  loadHistoryPayload() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const historySha = yield _this.current().directGetConfig('atomGithub.historySha');
      if (!historySha) {
        return {};
      }

      let blob;
      try {
        blob = yield _this.current().directGetBlobContents(historySha);
      } catch (e) {
        if (/Not a valid object name/.test(e.stdErr)) {
          return {};
        }

        throw e;
      }

      try {
        return JSON.parse(blob);
      } catch (e) {
        return {};
      }
    })();
  }

  // Debugging assistance.

  toString() {
    return this.constructor.name;
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'isLoadingGuess', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isLoadingGuess'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isAbsentGuess', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isAbsentGuess'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isAbsent', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isAbsent'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isLoading', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isLoading'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isEmpty', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isEmpty'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isPresent', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isPresent'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isDestroyed', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isDestroyed'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isUndetermined', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isUndetermined'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showGitTabInit', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'showGitTabInit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showGitTabInitInProgress', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'showGitTabInitInProgress'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showGitTabLoading', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'showGitTabLoading'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showStatusBarTiles', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'showStatusBarTiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'hasDirectory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'hasDirectory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'init', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'init'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'clone', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'clone'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'destroy', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'destroy'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'refresh', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'refresh'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'observeFilesystemChange', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'observeFilesystemChange'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageFiles', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'stageFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unstageFiles', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'unstageFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageFilesFromParentCommit', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'stageFilesFromParentCommit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'applyPatchToIndex', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'applyPatchToIndex'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'applyPatchToWorkdir', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'applyPatchToWorkdir'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'commit', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'commit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'merge', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'merge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'abortMerge', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'abortMerge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkoutSide', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'checkoutSide'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'mergeFile', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'mergeFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'writeMergeConflictToIndex', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'writeMergeConflictToIndex'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkout', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'checkout'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkoutPathsAtRevision', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'checkoutPathsAtRevision'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'fetch', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'fetch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'pull', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'pull'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'push', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'push'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setConfig', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'setConfig'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unsetConfig', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'unsetConfig'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createBlob', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'createBlob'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'expandBlobToFile', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'expandBlobToFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createDiscardHistoryBlob', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'createDiscardHistoryBlob'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'updateDiscardHistory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'updateDiscardHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'storeBeforeAndAfterBlobs', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'storeBeforeAndAfterBlobs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'restoreLastDiscardInTempFiles', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'restoreLastDiscardInTempFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'popDiscardHistory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'popDiscardHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'clearDiscardHistory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'clearDiscardHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardWorkDirChangesForPaths', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'discardWorkDirChangesForPaths'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getStatusBundle', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getStatusBundle'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getStatusesForChangedFiles', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getStatusesForChangedFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getStagedChangesSinceParentCommit', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getStagedChangesSinceParentCommit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getFilePatchForPath', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getFilePatchForPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'readFileFromIndex', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'readFileFromIndex'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getLastCommit', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getLastCommit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getBranches', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getBranches'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getCurrentBranch', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getCurrentBranch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isMerging', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isMerging'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isRebasing', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'isRebasing'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getRemotes', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getRemotes'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getAheadCount', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getAheadCount'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getBehindCount', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getBehindCount'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getConfig', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getConfig'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getBlobContents', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getBlobContents'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'hasDiscardHistory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'hasDiscardHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getDiscardHistory', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getDiscardHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getLastHistorySnapshots', [shouldDelegate], Object.getOwnPropertyDescriptor(_class.prototype, 'getLastHistorySnapshots'), _class.prototype)), _class);
exports.default = State;


function unsupportedOperationPromise(self, opName) {
  return Promise.reject(new Error(`${opName} is not available in ${self} state`));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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