'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * Initial state to be used when it's uncertain whether or not a git repository is present in a working directory. If
 * it is a git repository, transition to Present, otherwise transition to Empty.
 */
let Loading = class Loading extends _state2.default {
  start() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const dotGitDir = yield _this.resolveDotGitDir();
      if (dotGitDir) {
        _this.repository.setGitDirectoryPath(dotGitDir);
        const history = yield _this.loadHistoryPayload();
        return _this.transitionTo('Present', history);
      } else {
        return _this.transitionTo('Empty');
      }
    })();
  }

  isLoading() {
    return true;
  }

  init() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      yield _this2.getLoadPromise();
      yield _this2.repository.init();
    })();
  }

  clone(remoteUrl) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      yield _this3.getLoadPromise();
      yield _this3.repository.clone(remoteUrl);
    })();
  }

  showGitTabLoading() {
    return true;
  }

  directResolveDotGitDir() {
    return this.git().resolveDotGitDir();
  }

  directGetConfig(key, options) {
    return this.git().getConfig(key, options);
  }

  directGetBlobContents(sha) {
    return this.git().getBlobContents(sha);
  }
};
exports.default = Loading;


_state2.default.register(Loading);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvYWRpbmcuanMiXSwibmFtZXMiOlsiTG9hZGluZyIsInN0YXJ0IiwiZG90R2l0RGlyIiwicmVzb2x2ZURvdEdpdERpciIsInJlcG9zaXRvcnkiLCJzZXRHaXREaXJlY3RvcnlQYXRoIiwiaGlzdG9yeSIsImxvYWRIaXN0b3J5UGF5bG9hZCIsInRyYW5zaXRpb25UbyIsImlzTG9hZGluZyIsImluaXQiLCJnZXRMb2FkUHJvbWlzZSIsImNsb25lIiwicmVtb3RlVXJsIiwic2hvd0dpdFRhYkxvYWRpbmciLCJkaXJlY3RSZXNvbHZlRG90R2l0RGlyIiwiZ2l0IiwiZGlyZWN0R2V0Q29uZmlnIiwia2V5Iiwib3B0aW9ucyIsImdldENvbmZpZyIsImRpcmVjdEdldEJsb2JDb250ZW50cyIsInNoYSIsImdldEJsb2JDb250ZW50cyIsInJlZ2lzdGVyIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7Ozs7Ozs7O0FBRUE7Ozs7SUFJcUJBLE8sR0FBTixNQUFNQSxPQUFOLHlCQUE0QjtBQUNuQ0MsT0FBTixHQUFjO0FBQUE7O0FBQUE7QUFDWixZQUFNQyxZQUFZLE1BQU0sTUFBS0MsZ0JBQUwsRUFBeEI7QUFDQSxVQUFJRCxTQUFKLEVBQWU7QUFDYixjQUFLRSxVQUFMLENBQWdCQyxtQkFBaEIsQ0FBb0NILFNBQXBDO0FBQ0EsY0FBTUksVUFBVSxNQUFNLE1BQUtDLGtCQUFMLEVBQXRCO0FBQ0EsZUFBTyxNQUFLQyxZQUFMLENBQWtCLFNBQWxCLEVBQTZCRixPQUE3QixDQUFQO0FBQ0QsT0FKRCxNQUlPO0FBQ0wsZUFBTyxNQUFLRSxZQUFMLENBQWtCLE9BQWxCLENBQVA7QUFDRDtBQVJXO0FBU2I7O0FBRURDLGNBQVk7QUFDVixXQUFPLElBQVA7QUFDRDs7QUFFS0MsTUFBTixHQUFhO0FBQUE7O0FBQUE7QUFDWCxZQUFNLE9BQUtDLGNBQUwsRUFBTjtBQUNBLFlBQU0sT0FBS1AsVUFBTCxDQUFnQk0sSUFBaEIsRUFBTjtBQUZXO0FBR1o7O0FBRUtFLE9BQU4sQ0FBWUMsU0FBWixFQUF1QjtBQUFBOztBQUFBO0FBQ3JCLFlBQU0sT0FBS0YsY0FBTCxFQUFOO0FBQ0EsWUFBTSxPQUFLUCxVQUFMLENBQWdCUSxLQUFoQixDQUFzQkMsU0FBdEIsQ0FBTjtBQUZxQjtBQUd0Qjs7QUFFREMsc0JBQW9CO0FBQ2xCLFdBQU8sSUFBUDtBQUNEOztBQUVEQywyQkFBeUI7QUFDdkIsV0FBTyxLQUFLQyxHQUFMLEdBQVdiLGdCQUFYLEVBQVA7QUFDRDs7QUFFRGMsa0JBQWdCQyxHQUFoQixFQUFxQkMsT0FBckIsRUFBOEI7QUFDNUIsV0FBTyxLQUFLSCxHQUFMLEdBQVdJLFNBQVgsQ0FBcUJGLEdBQXJCLEVBQTBCQyxPQUExQixDQUFQO0FBQ0Q7O0FBRURFLHdCQUFzQkMsR0FBdEIsRUFBMkI7QUFDekIsV0FBTyxLQUFLTixHQUFMLEdBQVdPLGVBQVgsQ0FBMkJELEdBQTNCLENBQVA7QUFDRDtBQXhDd0MsQztrQkFBdEJ0QixPOzs7QUEyQ3JCLGdCQUFNd0IsUUFBTixDQUFleEIsT0FBZiIsImZpbGUiOiJsb2FkaW5nLmpzIiwic291cmNlUm9vdCI6Ii9ob21lL2FuZHJlaS9hdG9tLTEuMTkuMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgU3RhdGUgZnJvbSAnLi9zdGF0ZSc7XG5cbi8qKlxuICogSW5pdGlhbCBzdGF0ZSB0byBiZSB1c2VkIHdoZW4gaXQncyB1bmNlcnRhaW4gd2hldGhlciBvciBub3QgYSBnaXQgcmVwb3NpdG9yeSBpcyBwcmVzZW50IGluIGEgd29ya2luZyBkaXJlY3RvcnkuIElmXG4gKiBpdCBpcyBhIGdpdCByZXBvc2l0b3J5LCB0cmFuc2l0aW9uIHRvIFByZXNlbnQsIG90aGVyd2lzZSB0cmFuc2l0aW9uIHRvIEVtcHR5LlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBMb2FkaW5nIGV4dGVuZHMgU3RhdGUge1xuICBhc3luYyBzdGFydCgpIHtcbiAgICBjb25zdCBkb3RHaXREaXIgPSBhd2FpdCB0aGlzLnJlc29sdmVEb3RHaXREaXIoKTtcbiAgICBpZiAoZG90R2l0RGlyKSB7XG4gICAgICB0aGlzLnJlcG9zaXRvcnkuc2V0R2l0RGlyZWN0b3J5UGF0aChkb3RHaXREaXIpO1xuICAgICAgY29uc3QgaGlzdG9yeSA9IGF3YWl0IHRoaXMubG9hZEhpc3RvcnlQYXlsb2FkKCk7XG4gICAgICByZXR1cm4gdGhpcy50cmFuc2l0aW9uVG8oJ1ByZXNlbnQnLCBoaXN0b3J5KTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIHRoaXMudHJhbnNpdGlvblRvKCdFbXB0eScpO1xuICAgIH1cbiAgfVxuXG4gIGlzTG9hZGluZygpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGFzeW5jIGluaXQoKSB7XG4gICAgYXdhaXQgdGhpcy5nZXRMb2FkUHJvbWlzZSgpO1xuICAgIGF3YWl0IHRoaXMucmVwb3NpdG9yeS5pbml0KCk7XG4gIH1cblxuICBhc3luYyBjbG9uZShyZW1vdGVVcmwpIHtcbiAgICBhd2FpdCB0aGlzLmdldExvYWRQcm9taXNlKCk7XG4gICAgYXdhaXQgdGhpcy5yZXBvc2l0b3J5LmNsb25lKHJlbW90ZVVybCk7XG4gIH1cblxuICBzaG93R2l0VGFiTG9hZGluZygpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGRpcmVjdFJlc29sdmVEb3RHaXREaXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2l0KCkucmVzb2x2ZURvdEdpdERpcigpO1xuICB9XG5cbiAgZGlyZWN0R2V0Q29uZmlnKGtleSwgb3B0aW9ucykge1xuICAgIHJldHVybiB0aGlzLmdpdCgpLmdldENvbmZpZyhrZXksIG9wdGlvbnMpO1xuICB9XG5cbiAgZGlyZWN0R2V0QmxvYkNvbnRlbnRzKHNoYSkge1xuICAgIHJldHVybiB0aGlzLmdpdCgpLmdldEJsb2JDb250ZW50cyhzaGEpO1xuICB9XG59XG5cblN0YXRlLnJlZ2lzdGVyKExvYWRpbmcpO1xuIl19