'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _eventKit = require('event-kit');

let ResolutionProgress = class ResolutionProgress {
  constructor() {
    this.emitter = new _eventKit.Emitter();
    this.markerCountByPath = new Map();
  }

  didUpdate() {
    this.emitter.emit('did-update');
  }

  onDidUpdate(cb) {
    return this.emitter.on('did-update', cb);
  }

  reportMarkerCount(path, count) {
    const previous = this.markerCountByPath.get(path);
    this.markerCountByPath.set(path, count);
    if (count !== previous) {
      this.didUpdate();
    }
  }

  getRemaining(path) {
    return this.markerCountByPath.get(path);
  }

  isEmpty() {
    return this.markerCountByPath.size === 0;
  }
};
exports.default = ResolutionProgress;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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