'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _markerTools = require('./marker-tools');

let Banner = class Banner {
  constructor(editor, marker, description, originalText) {
    this.editor = editor;
    this.marker = marker;
    this.description = description;
    this.originalText = originalText;
  }

  getMarker() {
    return this.marker;
  }

  getRange() {
    return this.marker.getBufferRange();
  }

  isModified() {
    const chomp = line => line.replace(/\r?\n$/, '');

    const text = this.editor.getTextInBufferRange(this.marker.getBufferRange());
    return chomp(text) !== chomp(this.originalText);
  }

  revert() {
    const range = this.getMarker().getBufferRange();
    this.editor.setTextInBufferRange(range, this.originalText);
  }

  delete() {
    (0, _markerTools.deleteMarkerIn)(this.getMarker(), this.editor);
  }
};
exports.default = Banner;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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