'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _dec, _class, _desc, _value, _class2, _class3, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _propTypes3 = require('../prop-types');

var _observeModel = require('../decorators/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _githubLoginView = require('../views/github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

var _githubLoginModel = require('../models/github-login-model');

var _remote = require('../models/remote');

var _prInfoController = require('./pr-info-controller');

var _prInfoController2 = _interopRequireDefault(_prInfoController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let RemotePrController = (_dec = (0, _observeModel2.default)({
  getModel: props => props.loginModel,
  fetchData: (loginModel, _ref) => {
    let host = _ref.host;

    return (0, _yubikiri2.default)({
      token: loginModel.getToken(host)
    });
  }
}), _dec(_class = (_class2 = (_temp = _class3 = class RemotePrController extends _react2.default.Component {

  render() {
    var _props = this.props;
    const host = _props.host,
          remote = _props.remote,
          currentBranchName = _props.currentBranchName,
          token = _props.token,
          loginModel = _props.loginModel,
          selectedPrUrl = _props.selectedPrUrl,
          onSelectPr = _props.onSelectPr,
          onUnpinPr = _props.onUnpinPr;

    return _react2.default.createElement(
      'div',
      { className: 'github-RemotePrController' },
      token && token !== _githubLoginModel.UNAUTHENTICATED && _react2.default.createElement(_prInfoController2.default, _extends({ host, remote, currentBranchName, token, loginModel, selectedPrUrl, onSelectPr, onUnpinPr }, {
        onLogin: this.handleLogin
      })),
      (!token || token === _githubLoginModel.UNAUTHENTICATED) && _react2.default.createElement(_githubLoginView2.default, { onLogin: this.handleLogin })
    );
  }

  handleLogin(token) {
    this.props.loginModel.setToken(this.props.host, token);
  }
}, _class3.propTypes = {
  loginModel: _propTypes2.default.object.isRequired,
  host: _propTypes2.default.string, // fully qualified URI to the API endpoint, e.g. 'https://api.github.com'
  remote: _propTypes3.RemotePropType.isRequired,
  token: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.symbol]),
  currentBranchName: _propTypes2.default.string.isRequired,
  onSelectPr: _propTypes2.default.func.isRequired,
  selectedPrUrl: _propTypes2.default.string,
  onUnpinPr: _propTypes2.default.func.isRequired
}, _class3.defaultProps = {
  host: 'https://api.github.com',
  remote: _remote.nullRemote,
  token: null
}, _temp), (_applyDecoratedDescriptor(_class2.prototype, 'handleLogin', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleLogin'), _class2.prototype)), _class2)) || _class);
exports.default = RemotePrController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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