'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _propTypes3 = require('../prop-types');

var _relayRootContainer = require('../containers/relay-root-container');

var _relayRootContainer2 = _interopRequireDefault(_relayRootContainer);

var _prSelectionByUrlContainer = require('../containers/pr-selection-by-url-container');

var _prSelectionByUrlContainer2 = _interopRequireDefault(_prSelectionByUrlContainer);

var _prSelectionByBranchContainer = require('../containers/pr-selection-by-branch-container');

var _prSelectionByBranchContainer2 = _interopRequireDefault(_prSelectionByBranchContainer);

var _githubLoginView = require('../views/github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

var _prInfoByBranchRoute = require('../routes/pr-info-by-branch-route');

var _prInfoByBranchRoute2 = _interopRequireDefault(_prInfoByBranchRoute);

var _prInfoByUrlRoute = require('../routes/pr-info-by-url-route');

var _prInfoByUrlRoute2 = _interopRequireDefault(_prInfoByUrlRoute);

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

var _githubLoginModel = require('../models/github-login-model');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let PrInfoController = (_class = (_temp = _class2 = class PrInfoController extends _react2.default.Component {

  render() {
    if (this.props.token === _githubLoginModel.UNAUTHENTICATED) {
      return null;
    }

    if (this.props.selectedPrUrl) {
      return this.renderSpecificPr();
    } else {
      return this.renderPrByBranchName();
    }
  }

  renderSpecificPr() {
    var _props = this.props;
    const token = _props.token,
          host = _props.host;


    const route = new _prInfoByUrlRoute2.default({
      prUrl: this.props.selectedPrUrl
    });

    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(host, token);
    const Component = _prSelectionByUrlContainer2.default;

    return _react2.default.createElement(_relayRootContainer2.default, {
      Component: Component,
      route: route,
      environment: environment,
      renderFetched: props => {
        return _react2.default.createElement(Component, _extends({}, props, { onSelectPr: this.props.onSelectPr, onUnpinPr: this.props.onUnpinPr }));
      },
      renderLoading: this.renderLoading,
      renderFailure: this.renderSpecificPrFailure
    });
  }

  renderPrByBranchName() {
    var _props2 = this.props;
    const token = _props2.token,
          host = _props2.host;


    const route = new _prInfoByBranchRoute2.default({
      repoOwner: this.props.remote.getOwner(),
      repoName: this.props.remote.getRepo(),
      branchName: this.props.currentBranchName
    });

    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(host, token);
    const Component = _prSelectionByBranchContainer2.default;

    return _react2.default.createElement(_relayRootContainer2.default, {
      Component: Component,
      route: route,
      environment: environment,
      renderFetched: props => {
        return _react2.default.createElement(Component, _extends({}, props, { onSelectPr: this.props.onSelectPr, onUnpinPr: this.props.onUnpinPr }));
      },
      renderLoading: this.renderLoading,
      renderFailure: this.renderFailure
    });
  }

  renderLoading() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Loader' },
      _react2.default.createElement('span', { className: 'github-Spinner' })
    );
  }

  renderSpecificPrFailure(err, retry) {
    if (this.isNotFoundError(err)) {
      return _react2.default.createElement(_prSelectionByUrlContainer2.default, {
        prUrl: this.props.selectedPrUrl,
        query: null,
        onSelectPr: this.props.onSelectPr,
        onUnpinPr: this.props.onUnpinPr
      });
    } else {
      return this.renderFailure(err, retry);
    }
  }

  renderFailure(err, retry) {
    if (err.response && err.response.status === 401) {
      return _react2.default.createElement(
        'div',
        { className: 'github-GithubLoginView-Container' },
        _react2.default.createElement(
          _githubLoginView2.default,
          { onLogin: this.props.onLogin },
          _react2.default.createElement(
            'p',
            null,
            'The API endpoint returned a unauthorized error. Please try to re-authenticate with the endpoint.'
          )
        )
      );
    } else {
      return _react2.default.createElement(
        'div',
        { className: 'unknown-fatal-error' },
        _react2.default.createElement(
          'div',
          null,
          'An unknown error occurred.'
        ),
        _react2.default.createElement(
          'button',
          { onClick: retry },
          'Try Again'
        )
      );
    }
  }

  isNotFoundError(err) {
    return err.source && err.source.errors && err.source.errors[0] && err.source.errors[0].type === 'NOT_FOUND';
  }
}, _class2.propTypes = {
  token: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.symbol]).isRequired,
  host: _propTypes2.default.string.isRequired,
  currentBranchName: _propTypes2.default.string.isRequired,
  onLogin: _propTypes2.default.func.isRequired,
  remote: _propTypes3.RemotePropType.isRequired,
  onSelectPr: _propTypes2.default.func.isRequired,
  selectedPrUrl: _propTypes2.default.string,
  onUnpinPr: _propTypes2.default.func.isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'renderLoading', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderLoading'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'renderSpecificPrFailure', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderSpecificPrFailure'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'renderFailure', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderFailure'), _class.prototype)), _class);
exports.default = PrInfoController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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