'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp; /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _eventKit = require('event-kit');

var _gitTabView = require('../views/git-tab-view');

var _gitTabView2 = _interopRequireDefault(_gitTabView);

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

var _branch = require('../models/branch');

var _commit = require('../models/commit');

var _coreDecorators = require('core-decorators');

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let GitTabController = (_class = (_temp = _class2 = class GitTabController {

  constructor(props) {
    this.props = props;
    this.stagingOperationInProgress = false;
    this.lastFocus = _gitTabView2.default.focus.STAGING;

    this.repositoryObserver = new _modelObserver2.default({
      fetchData: this.fetchRepositoryData,
      didUpdate: () => {
        this.refreshResolutionProgress(false, false);
        return this.update();
      }
    });
    this.repositoryObserver.setActiveModel(props.repository);
    _etch2.default.initialize(this);

    this.element.addEventListener('focusin', this.rememberLastFocus);
    this.subscriptions = new _eventKit.Disposable(() => this.element.removeEventListener('focusin', this.rememberLastFocus));
  }

  serialize() {
    return {
      deserializer: 'GitTabControllerStub'
    };
  }

  render() {
    const modelData = this.repositoryObserver.getActiveModelData() || this.defaultRepositoryData();
    const hasUndoHistory = this.props.repository ? this.hasUndoHistory() : false;
    return _etch2.default.dom(_gitTabView2.default, _extends({
      ref: 'gitTab'
    }, modelData, {
      repository: this.props.repository,
      resolutionProgress: this.props.resolutionProgress,
      workspace: this.props.workspace,
      commandRegistry: this.props.commandRegistry,
      notificationManager: this.props.notificationManager,
      initializeRepo: this.props.initializeRepo,
      didSelectFilePath: this.props.didSelectFilePath,
      didDiveIntoFilePath: this.props.didDiveIntoFilePath,
      didSelectMergeConflictFile: this.props.didSelectMergeConflictFile,
      didDiveIntoMergeConflictPath: this.props.didDiveIntoMergeConflictPath,
      focusFilePatchView: this.props.focusFilePatchView,
      stageFilePatch: this.stageFilePatch,
      unstageFilePatch: this.unstageFilePatch,
      openFiles: this.props.openFiles,
      discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
      attemptFileStageOperation: this.attemptFileStageOperation,
      prepareToCommit: this.prepareToCommit,
      commit: this.commit,
      setAmending: this.setAmending,
      isAmending: this.props.isAmending,
      hasUndoHistory: hasUndoHistory,
      undoLastDiscard: this.props.undoLastDiscard,
      abortMerge: this.abortMerge,
      resolveAsOurs: this.resolveAsOurs,
      resolveAsTheirs: this.resolveAsTheirs,
      push: this.push,
      pull: this.pull,
      fetch: this.fetch,
      checkout: this.checkout
    }));
  }

  update(props) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const oldProps = _this.props;
      _this.props = _extends({}, _this.props, props);
      if (_this.props.repository !== oldProps.repository) {
        yield _this.repositoryObserver.setActiveModel(props.repository);
      } else if (_this.props.isAmending !== oldProps.isAmending) {
        yield _this.repositoryObserver.refreshModelData(_this.getActiveRepository());
      }
      return _etch2.default.update(_this);
    })();
  }

  destroy() {
    this.subscriptions.dispose();
    this.repositoryObserver.destroy();
  }

  getTitle() {
    return 'Git';
  }

  getIconName() {
    return 'git-commit';
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  getURI() {
    return 'atom-github://stub-uri/git-tab-controller';
  }

  getWorkingDirectory() {
    return this.props.repository.getWorkingDirectoryPath();
  }

  getLastModelDataRefreshPromise() {
    return this.repositoryObserver.getLastModelDataRefreshPromise();
  }

  getActiveRepository() {
    return this.repositoryObserver.getActiveModel();
  }

  refreshModelData() {
    return this.repositoryObserver.refreshModelData();
  }

  fetchRepositoryData(repository) {
    return (0, _yubikiri2.default)({
      lastCommit: repository.getLastCommit(),
      isMerging: repository.isMerging(),
      isRebasing: repository.isRebasing(),
      currentBranch: repository.getCurrentBranch(),
      unstagedChanges: repository.getUnstagedChanges(),
      stagedChanges: this.fetchStagedChanges(repository),
      mergeConflicts: repository.getMergeConflicts(),
      workingDirectoryPath: repository.getWorkingDirectoryPath(),
      mergeMessage: (() => {
        var _ref = _asyncToGenerator(function* (query) {
          const isMerging = yield query.isMerging;
          return isMerging ? repository.getMergeMessage() : null;
        });

        return function mergeMessage(_x) {
          return _ref.apply(this, arguments);
        };
      })(),
      fetchInProgress: Promise.resolve(false)
    });
  }

  defaultRepositoryData() {
    return {
      lastCommit: _commit.nullCommit,
      isMerging: false,
      isRebasing: false,
      currentBranch: _branch.nullBranch,
      unstagedChanges: [],
      stagedChanges: [],
      mergeConflicts: [],
      workingDirectoryPath: this.props.repository.getWorkingDirectoryPath(),
      mergeMessage: null,
      fetchInProgress: true
    };
  }

  fetchStagedChanges(repository) {
    if (this.props.isAmending) {
      return repository.getStagedChangesSinceParentCommit();
    } else {
      return repository.getStagedChanges();
    }
  }

  /*
   * Begin (but don't await) an async conflict-counting task for each merge conflict path that has no conflict
   * marker count yet. Omit any path that's already open in a TextEditor or that has already been counted.
   *
   * includeOpen - update marker counts for files that are currently open in TextEditors
   * includeCounts - update marker counts for files that have been counted before
   */
  refreshResolutionProgress(includeOpen, includeCounted) {
    const data = this.repositoryObserver.getActiveModelData();
    if (!data) {
      return;
    }

    const openPaths = new Set(this.props.workspace.getTextEditors().map(editor => editor.getPath()));
    for (let i = 0; i < data.mergeConflicts.length; i++) {
      const conflictPath = _path2.default.join(data.workingDirectoryPath, data.mergeConflicts[i].filePath);

      if (!includeOpen && openPaths.has(conflictPath)) {
        continue;
      }

      if (!includeCounted && this.props.resolutionProgress.getRemaining(conflictPath) !== undefined) {
        continue;
      }

      this.props.refreshResolutionProgress(conflictPath);
    }
  }

  unstageFilePatch(filePatch) {
    return this.getActiveRepository().applyPatchToIndex(filePatch.getUnstagePatch());
  }

  attemptFileStageOperation(filePaths, stageStatus) {
    if (this.stagingOperationInProgress) {
      return {
        stageOperationPromise: Promise.resolve(),
        selectionUpdatePromise: Promise.resolve()
      };
    }

    this.stagingOperationInProgress = true;

    const fileListUpdatePromise = this.refs.gitTab.refs.stagingView.getNextListUpdatePromise();
    let stageOperationPromise;
    if (stageStatus === 'staged') {
      stageOperationPromise = this.unstageFiles(filePaths);
    } else {
      stageOperationPromise = this.stageFiles(filePaths);
    }
    const selectionUpdatePromise = fileListUpdatePromise.then(() => {
      this.stagingOperationInProgress = false;
    });

    return { stageOperationPromise, selectionUpdatePromise };
  }

  stageFiles(filePaths) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      const pathsToIgnore = [];
      const repository = _this2.getActiveRepository();
      for (const filePath of filePaths) {
        if (yield repository.pathHasMergeMarkers(filePath)) {
          // eslint-disable-line no-await-in-loop
          const choice = atom.confirm({
            message: 'File contains merge markers: ',
            detailedMessage: `Do you still want to stage this file?\n${filePath}`,
            buttons: ['Stage', 'Cancel']
          });
          if (choice !== 0) {
            pathsToIgnore.push(filePath);
          }
        }
      }
      const pathsToStage = filePaths.filter(function (filePath) {
        return !pathsToIgnore.includes(filePath);
      });
      return repository.stageFiles(pathsToStage);
    })();
  }

  unstageFiles(filePaths) {
    const repository = this.getActiveRepository();
    if (this.props.isAmending) {
      return repository.stageFilesFromParentCommit(filePaths);
    } else {
      return repository.unstageFiles(filePaths);
    }
  }

  prepareToCommit() {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      return !(yield _this3.props.ensureGitTab());
    })();
  }

  commit(message) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      try {
        yield _this4.getActiveRepository().commit(message, { amend: _this4.props.isAmending });
        _this4.setAmending(false);
      } catch (e) {
        if (e.code === 'ECONFLICT') {
          _this4.props.notificationManager.addError('Cannot commit without resolving all the merge conflicts first.', { dismissable: true });
        } else {
          throw e;
        }
      }
    })();
  }

  setAmending(isAmending) {
    this.props.didChangeAmending(isAmending);
  }

  abortMerge() {
    var _this5 = this;

    return _asyncToGenerator(function* () {
      const choice = atom.confirm({
        message: 'Abort merge',
        detailedMessage: 'Are you sure?',
        buttons: ['Abort', 'Cancel']
      });
      if (choice !== 0) {
        return null;
      }

      try {
        yield _this5.getActiveRepository().abortMerge();
      } catch (e) {
        if (e.code === 'EDIRTYSTAGED') {
          _this5.props.notificationManager.addError(`Cannot abort because ${e.path} is both dirty and staged.`, { dismissable: true });
        } else {
          throw e;
        }
      }
      return _etch2.default.update(_this5);
    })();
  }

  resolveAsOurs(paths) {
    var _this6 = this;

    return _asyncToGenerator(function* () {
      const data = _this6.repositoryObserver.getActiveModelData();
      if (!data) {
        return;
      }
      const side = data.isRebasing ? 'theirs' : 'ours';
      yield _this6.getActiveRepository().checkoutSide(side, paths);
      _this6.refreshResolutionProgress(false, true);
    })();
  }

  resolveAsTheirs(paths) {
    var _this7 = this;

    return _asyncToGenerator(function* () {
      const data = _this7.repositoryObserver.getActiveModelData();
      if (!data) {
        return;
      }
      const side = data.isRebasing ? 'ours' : 'theirs';
      yield _this7.getActiveRepository().checkoutSide(side, paths);
      _this7.refreshResolutionProgress(false, true);
    })();
  }

  checkout(branchName, options) {
    return this.getActiveRepository().checkout(branchName, options);
  }

  rememberLastFocus(event) {
    this.lastFocus = this.refs.gitTab.rememberFocus(event) || _gitTabView2.default.focus.STAGING;
  }

  restoreFocus() {
    this.refs.gitTab.setFocus(this.lastFocus);
  }

  hasFocus() {
    return this.element.contains(document.activeElement);
  }

  wasActivated() {
    process.nextTick(() => this.restoreFocus());
  }

  focusAndSelectStagingItem(filePath, stagingStatus) {
    return this.refs.gitTab.focusAndSelectStagingItem(filePath, stagingStatus);
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.refs.gitTab.quietlySelectItem(filePath, stagingStatus);
  }

  hasUndoHistory() {
    return this.props.repository.hasDiscardHistory();
  }
}, _class2.focus = _extends({}, _gitTabView2.default.focus), _temp), (_applyDecoratedDescriptor(_class.prototype, 'fetchRepositoryData', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'fetchRepositoryData'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'attemptFileStageOperation', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'attemptFileStageOperation'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unstageFiles', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'unstageFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'prepareToCommit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'prepareToCommit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'commit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'commit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setAmending', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'setAmending'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'abortMerge', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'abortMerge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'resolveAsOurs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'resolveAsOurs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'resolveAsTheirs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'resolveAsTheirs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkout', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'checkout'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'rememberLastFocus', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'rememberLastFocus'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'quietlySelectItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'quietlySelectItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'hasUndoHistory', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'hasUndoHistory'), _class.prototype)), _class);
exports.default = GitTabController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdpdC10YWItY29udHJvbGxlci5qcyJdLCJuYW1lcyI6WyJHaXRUYWJDb250cm9sbGVyIiwiY29uc3RydWN0b3IiLCJwcm9wcyIsInN0YWdpbmdPcGVyYXRpb25JblByb2dyZXNzIiwibGFzdEZvY3VzIiwiZm9jdXMiLCJTVEFHSU5HIiwicmVwb3NpdG9yeU9ic2VydmVyIiwiZmV0Y2hEYXRhIiwiZmV0Y2hSZXBvc2l0b3J5RGF0YSIsImRpZFVwZGF0ZSIsInJlZnJlc2hSZXNvbHV0aW9uUHJvZ3Jlc3MiLCJ1cGRhdGUiLCJzZXRBY3RpdmVNb2RlbCIsInJlcG9zaXRvcnkiLCJpbml0aWFsaXplIiwiZWxlbWVudCIsImFkZEV2ZW50TGlzdGVuZXIiLCJyZW1lbWJlckxhc3RGb2N1cyIsInN1YnNjcmlwdGlvbnMiLCJyZW1vdmVFdmVudExpc3RlbmVyIiwic2VyaWFsaXplIiwiZGVzZXJpYWxpemVyIiwicmVuZGVyIiwibW9kZWxEYXRhIiwiZ2V0QWN0aXZlTW9kZWxEYXRhIiwiZGVmYXVsdFJlcG9zaXRvcnlEYXRhIiwiaGFzVW5kb0hpc3RvcnkiLCJyZXNvbHV0aW9uUHJvZ3Jlc3MiLCJ3b3Jrc3BhY2UiLCJjb21tYW5kUmVnaXN0cnkiLCJub3RpZmljYXRpb25NYW5hZ2VyIiwiaW5pdGlhbGl6ZVJlcG8iLCJkaWRTZWxlY3RGaWxlUGF0aCIsImRpZERpdmVJbnRvRmlsZVBhdGgiLCJkaWRTZWxlY3RNZXJnZUNvbmZsaWN0RmlsZSIsImRpZERpdmVJbnRvTWVyZ2VDb25mbGljdFBhdGgiLCJmb2N1c0ZpbGVQYXRjaFZpZXciLCJzdGFnZUZpbGVQYXRjaCIsInVuc3RhZ2VGaWxlUGF0Y2giLCJvcGVuRmlsZXMiLCJkaXNjYXJkV29ya0RpckNoYW5nZXNGb3JQYXRocyIsImF0dGVtcHRGaWxlU3RhZ2VPcGVyYXRpb24iLCJwcmVwYXJlVG9Db21taXQiLCJjb21taXQiLCJzZXRBbWVuZGluZyIsImlzQW1lbmRpbmciLCJ1bmRvTGFzdERpc2NhcmQiLCJhYm9ydE1lcmdlIiwicmVzb2x2ZUFzT3VycyIsInJlc29sdmVBc1RoZWlycyIsInB1c2giLCJwdWxsIiwiZmV0Y2giLCJjaGVja291dCIsIm9sZFByb3BzIiwicmVmcmVzaE1vZGVsRGF0YSIsImdldEFjdGl2ZVJlcG9zaXRvcnkiLCJkZXN0cm95IiwiZGlzcG9zZSIsImdldFRpdGxlIiwiZ2V0SWNvbk5hbWUiLCJnZXREZWZhdWx0TG9jYXRpb24iLCJnZXRQcmVmZXJyZWRXaWR0aCIsImdldFVSSSIsImdldFdvcmtpbmdEaXJlY3RvcnkiLCJnZXRXb3JraW5nRGlyZWN0b3J5UGF0aCIsImdldExhc3RNb2RlbERhdGFSZWZyZXNoUHJvbWlzZSIsImdldEFjdGl2ZU1vZGVsIiwibGFzdENvbW1pdCIsImdldExhc3RDb21taXQiLCJpc01lcmdpbmciLCJpc1JlYmFzaW5nIiwiY3VycmVudEJyYW5jaCIsImdldEN1cnJlbnRCcmFuY2giLCJ1bnN0YWdlZENoYW5nZXMiLCJnZXRVbnN0YWdlZENoYW5nZXMiLCJzdGFnZWRDaGFuZ2VzIiwiZmV0Y2hTdGFnZWRDaGFuZ2VzIiwibWVyZ2VDb25mbGljdHMiLCJnZXRNZXJnZUNvbmZsaWN0cyIsIndvcmtpbmdEaXJlY3RvcnlQYXRoIiwibWVyZ2VNZXNzYWdlIiwicXVlcnkiLCJnZXRNZXJnZU1lc3NhZ2UiLCJmZXRjaEluUHJvZ3Jlc3MiLCJQcm9taXNlIiwicmVzb2x2ZSIsImdldFN0YWdlZENoYW5nZXNTaW5jZVBhcmVudENvbW1pdCIsImdldFN0YWdlZENoYW5nZXMiLCJpbmNsdWRlT3BlbiIsImluY2x1ZGVDb3VudGVkIiwiZGF0YSIsIm9wZW5QYXRocyIsIlNldCIsImdldFRleHRFZGl0b3JzIiwibWFwIiwiZWRpdG9yIiwiZ2V0UGF0aCIsImkiLCJsZW5ndGgiLCJjb25mbGljdFBhdGgiLCJqb2luIiwiZmlsZVBhdGgiLCJoYXMiLCJnZXRSZW1haW5pbmciLCJ1bmRlZmluZWQiLCJmaWxlUGF0Y2giLCJhcHBseVBhdGNoVG9JbmRleCIsImdldFVuc3RhZ2VQYXRjaCIsImZpbGVQYXRocyIsInN0YWdlU3RhdHVzIiwic3RhZ2VPcGVyYXRpb25Qcm9taXNlIiwic2VsZWN0aW9uVXBkYXRlUHJvbWlzZSIsImZpbGVMaXN0VXBkYXRlUHJvbWlzZSIsInJlZnMiLCJnaXRUYWIiLCJzdGFnaW5nVmlldyIsImdldE5leHRMaXN0VXBkYXRlUHJvbWlzZSIsInVuc3RhZ2VGaWxlcyIsInN0YWdlRmlsZXMiLCJ0aGVuIiwicGF0aHNUb0lnbm9yZSIsInBhdGhIYXNNZXJnZU1hcmtlcnMiLCJjaG9pY2UiLCJhdG9tIiwiY29uZmlybSIsIm1lc3NhZ2UiLCJkZXRhaWxlZE1lc3NhZ2UiLCJidXR0b25zIiwicGF0aHNUb1N0YWdlIiwiZmlsdGVyIiwiaW5jbHVkZXMiLCJzdGFnZUZpbGVzRnJvbVBhcmVudENvbW1pdCIsImVuc3VyZUdpdFRhYiIsImFtZW5kIiwiZSIsImNvZGUiLCJhZGRFcnJvciIsImRpc21pc3NhYmxlIiwiZGlkQ2hhbmdlQW1lbmRpbmciLCJwYXRoIiwicGF0aHMiLCJzaWRlIiwiY2hlY2tvdXRTaWRlIiwiYnJhbmNoTmFtZSIsIm9wdGlvbnMiLCJldmVudCIsInJlbWVtYmVyRm9jdXMiLCJyZXN0b3JlRm9jdXMiLCJzZXRGb2N1cyIsImhhc0ZvY3VzIiwiY29udGFpbnMiLCJkb2N1bWVudCIsImFjdGl2ZUVsZW1lbnQiLCJ3YXNBY3RpdmF0ZWQiLCJwcm9jZXNzIiwibmV4dFRpY2siLCJmb2N1c0FuZFNlbGVjdFN0YWdpbmdJdGVtIiwic3RhZ2luZ1N0YXR1cyIsInF1aWV0bHlTZWxlY3RJdGVtIiwiaGFzRGlzY2FyZEhpc3RvcnkiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OzsyQ0FBQTtBQUNBOztBQUVBOzs7O0FBQ0E7Ozs7QUFDQTs7QUFFQTs7OztBQUNBOzs7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7SUFFcUJBLGdCLGdDQUFOLE1BQU1BLGdCQUFOLENBQXVCOztBQUtwQ0MsY0FBWUMsS0FBWixFQUFtQjtBQUNqQixTQUFLQSxLQUFMLEdBQWFBLEtBQWI7QUFDQSxTQUFLQywwQkFBTCxHQUFrQyxLQUFsQztBQUNBLFNBQUtDLFNBQUwsR0FBaUIscUJBQVdDLEtBQVgsQ0FBaUJDLE9BQWxDOztBQUVBLFNBQUtDLGtCQUFMLEdBQTBCLDRCQUFrQjtBQUMxQ0MsaUJBQVcsS0FBS0MsbUJBRDBCO0FBRTFDQyxpQkFBVyxNQUFNO0FBQ2YsYUFBS0MseUJBQUwsQ0FBK0IsS0FBL0IsRUFBc0MsS0FBdEM7QUFDQSxlQUFPLEtBQUtDLE1BQUwsRUFBUDtBQUNEO0FBTHlDLEtBQWxCLENBQTFCO0FBT0EsU0FBS0wsa0JBQUwsQ0FBd0JNLGNBQXhCLENBQXVDWCxNQUFNWSxVQUE3QztBQUNBLG1CQUFLQyxVQUFMLENBQWdCLElBQWhCOztBQUVBLFNBQUtDLE9BQUwsQ0FBYUMsZ0JBQWIsQ0FBOEIsU0FBOUIsRUFBeUMsS0FBS0MsaUJBQTlDO0FBQ0EsU0FBS0MsYUFBTCxHQUFxQix5QkFBZSxNQUFNLEtBQUtILE9BQUwsQ0FBYUksbUJBQWIsQ0FBaUMsU0FBakMsRUFBNEMsS0FBS0YsaUJBQWpELENBQXJCLENBQXJCO0FBQ0Q7O0FBRURHLGNBQVk7QUFDVixXQUFPO0FBQ0xDLG9CQUFjO0FBRFQsS0FBUDtBQUdEOztBQUVEQyxXQUFTO0FBQ1AsVUFBTUMsWUFBWSxLQUFLakIsa0JBQUwsQ0FBd0JrQixrQkFBeEIsTUFBZ0QsS0FBS0MscUJBQUwsRUFBbEU7QUFDQSxVQUFNQyxpQkFBaUIsS0FBS3pCLEtBQUwsQ0FBV1ksVUFBWCxHQUF3QixLQUFLYSxjQUFMLEVBQXhCLEdBQWdELEtBQXZFO0FBQ0EsV0FDRTtBQUNFLFdBQUk7QUFETixPQUVNSCxTQUZOO0FBR0Usa0JBQVksS0FBS3RCLEtBQUwsQ0FBV1ksVUFIekI7QUFJRSwwQkFBb0IsS0FBS1osS0FBTCxDQUFXMEIsa0JBSmpDO0FBS0UsaUJBQVcsS0FBSzFCLEtBQUwsQ0FBVzJCLFNBTHhCO0FBTUUsdUJBQWlCLEtBQUszQixLQUFMLENBQVc0QixlQU45QjtBQU9FLDJCQUFxQixLQUFLNUIsS0FBTCxDQUFXNkIsbUJBUGxDO0FBUUUsc0JBQWdCLEtBQUs3QixLQUFMLENBQVc4QixjQVI3QjtBQVNFLHlCQUFtQixLQUFLOUIsS0FBTCxDQUFXK0IsaUJBVGhDO0FBVUUsMkJBQXFCLEtBQUsvQixLQUFMLENBQVdnQyxtQkFWbEM7QUFXRSxrQ0FBNEIsS0FBS2hDLEtBQUwsQ0FBV2lDLDBCQVh6QztBQVlFLG9DQUE4QixLQUFLakMsS0FBTCxDQUFXa0MsNEJBWjNDO0FBYUUsMEJBQW9CLEtBQUtsQyxLQUFMLENBQVdtQyxrQkFiakM7QUFjRSxzQkFBZ0IsS0FBS0MsY0FkdkI7QUFlRSx3QkFBa0IsS0FBS0MsZ0JBZnpCO0FBZ0JFLGlCQUFXLEtBQUtyQyxLQUFMLENBQVdzQyxTQWhCeEI7QUFpQkUscUNBQStCLEtBQUt0QyxLQUFMLENBQVd1Qyw2QkFqQjVDO0FBa0JFLGlDQUEyQixLQUFLQyx5QkFsQmxDO0FBbUJFLHVCQUFpQixLQUFLQyxlQW5CeEI7QUFvQkUsY0FBUSxLQUFLQyxNQXBCZjtBQXFCRSxtQkFBYSxLQUFLQyxXQXJCcEI7QUFzQkUsa0JBQVksS0FBSzNDLEtBQUwsQ0FBVzRDLFVBdEJ6QjtBQXVCRSxzQkFBZ0JuQixjQXZCbEI7QUF3QkUsdUJBQWlCLEtBQUt6QixLQUFMLENBQVc2QyxlQXhCOUI7QUF5QkUsa0JBQVksS0FBS0MsVUF6Qm5CO0FBMEJFLHFCQUFlLEtBQUtDLGFBMUJ0QjtBQTJCRSx1QkFBaUIsS0FBS0MsZUEzQnhCO0FBNEJFLFlBQU0sS0FBS0MsSUE1QmI7QUE2QkUsWUFBTSxLQUFLQyxJQTdCYjtBQThCRSxhQUFPLEtBQUtDLEtBOUJkO0FBK0JFLGdCQUFVLEtBQUtDO0FBL0JqQixPQURGO0FBbUNEOztBQUVLMUMsUUFBTixDQUFhVixLQUFiLEVBQW9CO0FBQUE7O0FBQUE7QUFDbEIsWUFBTXFELFdBQVcsTUFBS3JELEtBQXRCO0FBQ0EsWUFBS0EsS0FBTCxnQkFBaUIsTUFBS0EsS0FBdEIsRUFBZ0NBLEtBQWhDO0FBQ0EsVUFBSSxNQUFLQSxLQUFMLENBQVdZLFVBQVgsS0FBMEJ5QyxTQUFTekMsVUFBdkMsRUFBbUQ7QUFDakQsY0FBTSxNQUFLUCxrQkFBTCxDQUF3Qk0sY0FBeEIsQ0FBdUNYLE1BQU1ZLFVBQTdDLENBQU47QUFDRCxPQUZELE1BRU8sSUFBSSxNQUFLWixLQUFMLENBQVc0QyxVQUFYLEtBQTBCUyxTQUFTVCxVQUF2QyxFQUFtRDtBQUN4RCxjQUFNLE1BQUt2QyxrQkFBTCxDQUF3QmlELGdCQUF4QixDQUF5QyxNQUFLQyxtQkFBTCxFQUF6QyxDQUFOO0FBQ0Q7QUFDRCxhQUFPLGVBQUs3QyxNQUFMLE9BQVA7QUFSa0I7QUFTbkI7O0FBRUQ4QyxZQUFVO0FBQ1IsU0FBS3ZDLGFBQUwsQ0FBbUJ3QyxPQUFuQjtBQUNBLFNBQUtwRCxrQkFBTCxDQUF3Qm1ELE9BQXhCO0FBQ0Q7O0FBRURFLGFBQVc7QUFDVCxXQUFPLEtBQVA7QUFDRDs7QUFFREMsZ0JBQWM7QUFDWixXQUFPLFlBQVA7QUFDRDs7QUFFREMsdUJBQXFCO0FBQ25CLFdBQU8sT0FBUDtBQUNEOztBQUVEQyxzQkFBb0I7QUFDbEIsV0FBTyxHQUFQO0FBQ0Q7O0FBRURDLFdBQVM7QUFDUCxXQUFPLDJDQUFQO0FBQ0Q7O0FBRURDLHdCQUFzQjtBQUNwQixXQUFPLEtBQUsvRCxLQUFMLENBQVdZLFVBQVgsQ0FBc0JvRCx1QkFBdEIsRUFBUDtBQUNEOztBQUVEQyxtQ0FBaUM7QUFDL0IsV0FBTyxLQUFLNUQsa0JBQUwsQ0FBd0I0RCw4QkFBeEIsRUFBUDtBQUNEOztBQUVEVix3QkFBc0I7QUFDcEIsV0FBTyxLQUFLbEQsa0JBQUwsQ0FBd0I2RCxjQUF4QixFQUFQO0FBQ0Q7O0FBRURaLHFCQUFtQjtBQUNqQixXQUFPLEtBQUtqRCxrQkFBTCxDQUF3QmlELGdCQUF4QixFQUFQO0FBQ0Q7O0FBR0QvQyxzQkFBb0JLLFVBQXBCLEVBQWdDO0FBQzlCLFdBQU8sd0JBQVM7QUFDZHVELGtCQUFZdkQsV0FBV3dELGFBQVgsRUFERTtBQUVkQyxpQkFBV3pELFdBQVd5RCxTQUFYLEVBRkc7QUFHZEMsa0JBQVkxRCxXQUFXMEQsVUFBWCxFQUhFO0FBSWRDLHFCQUFlM0QsV0FBVzRELGdCQUFYLEVBSkQ7QUFLZEMsdUJBQWlCN0QsV0FBVzhELGtCQUFYLEVBTEg7QUFNZEMscUJBQWUsS0FBS0Msa0JBQUwsQ0FBd0JoRSxVQUF4QixDQU5EO0FBT2RpRSxzQkFBZ0JqRSxXQUFXa0UsaUJBQVgsRUFQRjtBQVFkQyw0QkFBc0JuRSxXQUFXb0QsdUJBQVgsRUFSUjtBQVNkZ0I7QUFBQSxxQ0FBYyxXQUFNQyxLQUFOLEVBQWU7QUFDM0IsZ0JBQU1aLFlBQVksTUFBTVksTUFBTVosU0FBOUI7QUFDQSxpQkFBT0EsWUFBWXpELFdBQVdzRSxlQUFYLEVBQVosR0FBMkMsSUFBbEQ7QUFDRCxTQUhEOztBQUFBO0FBQUE7QUFBQTtBQUFBLFVBVGM7QUFhZEMsdUJBQWlCQyxRQUFRQyxPQUFSLENBQWdCLEtBQWhCO0FBYkgsS0FBVCxDQUFQO0FBZUQ7O0FBRUQ3RCwwQkFBd0I7QUFDdEIsV0FBTztBQUNMMkMsb0NBREs7QUFFTEUsaUJBQVcsS0FGTjtBQUdMQyxrQkFBWSxLQUhQO0FBSUxDLHVDQUpLO0FBS0xFLHVCQUFpQixFQUxaO0FBTUxFLHFCQUFlLEVBTlY7QUFPTEUsc0JBQWdCLEVBUFg7QUFRTEUsNEJBQXNCLEtBQUsvRSxLQUFMLENBQVdZLFVBQVgsQ0FBc0JvRCx1QkFBdEIsRUFSakI7QUFTTGdCLG9CQUFjLElBVFQ7QUFVTEcsdUJBQWlCO0FBVlosS0FBUDtBQVlEOztBQUVEUCxxQkFBbUJoRSxVQUFuQixFQUErQjtBQUM3QixRQUFJLEtBQUtaLEtBQUwsQ0FBVzRDLFVBQWYsRUFBMkI7QUFDekIsYUFBT2hDLFdBQVcwRSxpQ0FBWCxFQUFQO0FBQ0QsS0FGRCxNQUVPO0FBQ0wsYUFBTzFFLFdBQVcyRSxnQkFBWCxFQUFQO0FBQ0Q7QUFDRjs7QUFFRDs7Ozs7OztBQU9BOUUsNEJBQTBCK0UsV0FBMUIsRUFBdUNDLGNBQXZDLEVBQXVEO0FBQ3JELFVBQU1DLE9BQU8sS0FBS3JGLGtCQUFMLENBQXdCa0Isa0JBQXhCLEVBQWI7QUFDQSxRQUFJLENBQUNtRSxJQUFMLEVBQVc7QUFDVDtBQUNEOztBQUVELFVBQU1DLFlBQVksSUFBSUMsR0FBSixDQUNoQixLQUFLNUYsS0FBTCxDQUFXMkIsU0FBWCxDQUFxQmtFLGNBQXJCLEdBQXNDQyxHQUF0QyxDQUEwQ0MsVUFBVUEsT0FBT0MsT0FBUCxFQUFwRCxDQURnQixDQUFsQjtBQUdBLFNBQUssSUFBSUMsSUFBSSxDQUFiLEVBQWdCQSxJQUFJUCxLQUFLYixjQUFMLENBQW9CcUIsTUFBeEMsRUFBZ0RELEdBQWhELEVBQXFEO0FBQ25ELFlBQU1FLGVBQWUsZUFBS0MsSUFBTCxDQUFVVixLQUFLWCxvQkFBZixFQUFxQ1csS0FBS2IsY0FBTCxDQUFvQm9CLENBQXBCLEVBQXVCSSxRQUE1RCxDQUFyQjs7QUFFQSxVQUFJLENBQUNiLFdBQUQsSUFBZ0JHLFVBQVVXLEdBQVYsQ0FBY0gsWUFBZCxDQUFwQixFQUFpRDtBQUMvQztBQUNEOztBQUVELFVBQUksQ0FBQ1YsY0FBRCxJQUFtQixLQUFLekYsS0FBTCxDQUFXMEIsa0JBQVgsQ0FBOEI2RSxZQUE5QixDQUEyQ0osWUFBM0MsTUFBNkRLLFNBQXBGLEVBQStGO0FBQzdGO0FBQ0Q7O0FBRUQsV0FBS3hHLEtBQUwsQ0FBV1MseUJBQVgsQ0FBcUMwRixZQUFyQztBQUNEO0FBQ0Y7O0FBRUQ5RCxtQkFBaUJvRSxTQUFqQixFQUE0QjtBQUMxQixXQUFPLEtBQUtsRCxtQkFBTCxHQUEyQm1ELGlCQUEzQixDQUE2Q0QsVUFBVUUsZUFBVixFQUE3QyxDQUFQO0FBQ0Q7O0FBR0RuRSw0QkFBMEJvRSxTQUExQixFQUFxQ0MsV0FBckMsRUFBa0Q7QUFDaEQsUUFBSSxLQUFLNUcsMEJBQVQsRUFBcUM7QUFDbkMsYUFBTztBQUNMNkcsK0JBQXVCMUIsUUFBUUMsT0FBUixFQURsQjtBQUVMMEIsZ0NBQXdCM0IsUUFBUUMsT0FBUjtBQUZuQixPQUFQO0FBSUQ7O0FBRUQsU0FBS3BGLDBCQUFMLEdBQWtDLElBQWxDOztBQUVBLFVBQU0rRyx3QkFBd0IsS0FBS0MsSUFBTCxDQUFVQyxNQUFWLENBQWlCRCxJQUFqQixDQUFzQkUsV0FBdEIsQ0FBa0NDLHdCQUFsQyxFQUE5QjtBQUNBLFFBQUlOLHFCQUFKO0FBQ0EsUUFBSUQsZ0JBQWdCLFFBQXBCLEVBQThCO0FBQzVCQyw4QkFBd0IsS0FBS08sWUFBTCxDQUFrQlQsU0FBbEIsQ0FBeEI7QUFDRCxLQUZELE1BRU87QUFDTEUsOEJBQXdCLEtBQUtRLFVBQUwsQ0FBZ0JWLFNBQWhCLENBQXhCO0FBQ0Q7QUFDRCxVQUFNRyx5QkFBeUJDLHNCQUFzQk8sSUFBdEIsQ0FBMkIsTUFBTTtBQUM5RCxXQUFLdEgsMEJBQUwsR0FBa0MsS0FBbEM7QUFDRCxLQUY4QixDQUEvQjs7QUFJQSxXQUFPLEVBQUM2RyxxQkFBRCxFQUF3QkMsc0JBQXhCLEVBQVA7QUFDRDs7QUFFS08sWUFBTixDQUFpQlYsU0FBakIsRUFBNEI7QUFBQTs7QUFBQTtBQUMxQixZQUFNWSxnQkFBZ0IsRUFBdEI7QUFDQSxZQUFNNUcsYUFBYSxPQUFLMkMsbUJBQUwsRUFBbkI7QUFDQSxXQUFLLE1BQU04QyxRQUFYLElBQXVCTyxTQUF2QixFQUFrQztBQUNoQyxZQUFJLE1BQU1oRyxXQUFXNkcsbUJBQVgsQ0FBK0JwQixRQUEvQixDQUFWLEVBQW9EO0FBQUU7QUFDcEQsZ0JBQU1xQixTQUFTQyxLQUFLQyxPQUFMLENBQWE7QUFDMUJDLHFCQUFTLCtCQURpQjtBQUUxQkMsNkJBQWtCLDBDQUF5Q3pCLFFBQVMsRUFGMUM7QUFHMUIwQixxQkFBUyxDQUFDLE9BQUQsRUFBVSxRQUFWO0FBSGlCLFdBQWIsQ0FBZjtBQUtBLGNBQUlMLFdBQVcsQ0FBZixFQUFrQjtBQUFFRiwwQkFBY3ZFLElBQWQsQ0FBbUJvRCxRQUFuQjtBQUErQjtBQUNwRDtBQUNGO0FBQ0QsWUFBTTJCLGVBQWVwQixVQUFVcUIsTUFBVixDQUFpQjtBQUFBLGVBQVksQ0FBQ1QsY0FBY1UsUUFBZCxDQUF1QjdCLFFBQXZCLENBQWI7QUFBQSxPQUFqQixDQUFyQjtBQUNBLGFBQU96RixXQUFXMEcsVUFBWCxDQUFzQlUsWUFBdEIsQ0FBUDtBQWQwQjtBQWUzQjs7QUFHRFgsZUFBYVQsU0FBYixFQUF3QjtBQUN0QixVQUFNaEcsYUFBYSxLQUFLMkMsbUJBQUwsRUFBbkI7QUFDQSxRQUFJLEtBQUt2RCxLQUFMLENBQVc0QyxVQUFmLEVBQTJCO0FBQ3pCLGFBQU9oQyxXQUFXdUgsMEJBQVgsQ0FBc0N2QixTQUF0QyxDQUFQO0FBQ0QsS0FGRCxNQUVPO0FBQ0wsYUFBT2hHLFdBQVd5RyxZQUFYLENBQXdCVCxTQUF4QixDQUFQO0FBQ0Q7QUFDRjs7QUFHS25FLGlCQUFOLEdBQXdCO0FBQUE7O0FBQUE7QUFDdEIsYUFBTyxFQUFDLE1BQU0sT0FBS3pDLEtBQUwsQ0FBV29JLFlBQVgsRUFBUCxDQUFQO0FBRHNCO0FBRXZCOztBQUdLMUYsUUFBTixDQUFhbUYsT0FBYixFQUFzQjtBQUFBOztBQUFBO0FBQ3BCLFVBQUk7QUFDRixjQUFNLE9BQUt0RSxtQkFBTCxHQUEyQmIsTUFBM0IsQ0FBa0NtRixPQUFsQyxFQUEyQyxFQUFDUSxPQUFPLE9BQUtySSxLQUFMLENBQVc0QyxVQUFuQixFQUEzQyxDQUFOO0FBQ0EsZUFBS0QsV0FBTCxDQUFpQixLQUFqQjtBQUNELE9BSEQsQ0FHRSxPQUFPMkYsQ0FBUCxFQUFVO0FBQ1YsWUFBSUEsRUFBRUMsSUFBRixLQUFXLFdBQWYsRUFBNEI7QUFDMUIsaUJBQUt2SSxLQUFMLENBQVc2QixtQkFBWCxDQUErQjJHLFFBQS9CLENBQ0UsZ0VBREYsRUFFRSxFQUFDQyxhQUFhLElBQWQsRUFGRjtBQUlELFNBTEQsTUFLTztBQUNMLGdCQUFNSCxDQUFOO0FBQ0Q7QUFDRjtBQWJtQjtBQWNyQjs7QUFHRDNGLGNBQVlDLFVBQVosRUFBd0I7QUFDdEIsU0FBSzVDLEtBQUwsQ0FBVzBJLGlCQUFYLENBQTZCOUYsVUFBN0I7QUFDRDs7QUFHS0UsWUFBTixHQUFtQjtBQUFBOztBQUFBO0FBQ2pCLFlBQU00RSxTQUFTQyxLQUFLQyxPQUFMLENBQWE7QUFDMUJDLGlCQUFTLGFBRGlCO0FBRTFCQyx5QkFBaUIsZUFGUztBQUcxQkMsaUJBQVMsQ0FBQyxPQUFELEVBQVUsUUFBVjtBQUhpQixPQUFiLENBQWY7QUFLQSxVQUFJTCxXQUFXLENBQWYsRUFBa0I7QUFBRSxlQUFPLElBQVA7QUFBYzs7QUFFbEMsVUFBSTtBQUNGLGNBQU0sT0FBS25FLG1CQUFMLEdBQTJCVCxVQUEzQixFQUFOO0FBQ0QsT0FGRCxDQUVFLE9BQU93RixDQUFQLEVBQVU7QUFDVixZQUFJQSxFQUFFQyxJQUFGLEtBQVcsY0FBZixFQUErQjtBQUM3QixpQkFBS3ZJLEtBQUwsQ0FBVzZCLG1CQUFYLENBQStCMkcsUUFBL0IsQ0FDRyx3QkFBdUJGLEVBQUVLLElBQUssNEJBRGpDLEVBRUUsRUFBQ0YsYUFBYSxJQUFkLEVBRkY7QUFJRCxTQUxELE1BS087QUFDTCxnQkFBTUgsQ0FBTjtBQUNEO0FBQ0Y7QUFDRCxhQUFPLGVBQUs1SCxNQUFMLFFBQVA7QUFwQmlCO0FBcUJsQjs7QUFHS3FDLGVBQU4sQ0FBb0I2RixLQUFwQixFQUEyQjtBQUFBOztBQUFBO0FBQ3pCLFlBQU1sRCxPQUFPLE9BQUtyRixrQkFBTCxDQUF3QmtCLGtCQUF4QixFQUFiO0FBQ0EsVUFBSSxDQUFDbUUsSUFBTCxFQUFXO0FBQ1Q7QUFDRDtBQUNELFlBQU1tRCxPQUFPbkQsS0FBS3BCLFVBQUwsR0FBa0IsUUFBbEIsR0FBNkIsTUFBMUM7QUFDQSxZQUFNLE9BQUtmLG1CQUFMLEdBQTJCdUYsWUFBM0IsQ0FBd0NELElBQXhDLEVBQThDRCxLQUE5QyxDQUFOO0FBQ0EsYUFBS25JLHlCQUFMLENBQStCLEtBQS9CLEVBQXNDLElBQXRDO0FBUHlCO0FBUTFCOztBQUdLdUMsaUJBQU4sQ0FBc0I0RixLQUF0QixFQUE2QjtBQUFBOztBQUFBO0FBQzNCLFlBQU1sRCxPQUFPLE9BQUtyRixrQkFBTCxDQUF3QmtCLGtCQUF4QixFQUFiO0FBQ0EsVUFBSSxDQUFDbUUsSUFBTCxFQUFXO0FBQ1Q7QUFDRDtBQUNELFlBQU1tRCxPQUFPbkQsS0FBS3BCLFVBQUwsR0FBa0IsTUFBbEIsR0FBMkIsUUFBeEM7QUFDQSxZQUFNLE9BQUtmLG1CQUFMLEdBQTJCdUYsWUFBM0IsQ0FBd0NELElBQXhDLEVBQThDRCxLQUE5QyxDQUFOO0FBQ0EsYUFBS25JLHlCQUFMLENBQStCLEtBQS9CLEVBQXNDLElBQXRDO0FBUDJCO0FBUTVCOztBQUdEMkMsV0FBUzJGLFVBQVQsRUFBcUJDLE9BQXJCLEVBQThCO0FBQzVCLFdBQU8sS0FBS3pGLG1CQUFMLEdBQTJCSCxRQUEzQixDQUFvQzJGLFVBQXBDLEVBQWdEQyxPQUFoRCxDQUFQO0FBQ0Q7O0FBR0RoSSxvQkFBa0JpSSxLQUFsQixFQUF5QjtBQUN2QixTQUFLL0ksU0FBTCxHQUFpQixLQUFLK0csSUFBTCxDQUFVQyxNQUFWLENBQWlCZ0MsYUFBakIsQ0FBK0JELEtBQS9CLEtBQXlDLHFCQUFXOUksS0FBWCxDQUFpQkMsT0FBM0U7QUFDRDs7QUFFRCtJLGlCQUFlO0FBQ2IsU0FBS2xDLElBQUwsQ0FBVUMsTUFBVixDQUFpQmtDLFFBQWpCLENBQTBCLEtBQUtsSixTQUEvQjtBQUNEOztBQUVEbUosYUFBVztBQUNULFdBQU8sS0FBS3ZJLE9BQUwsQ0FBYXdJLFFBQWIsQ0FBc0JDLFNBQVNDLGFBQS9CLENBQVA7QUFDRDs7QUFFREMsaUJBQWU7QUFDYkMsWUFBUUMsUUFBUixDQUFpQixNQUFNLEtBQUtSLFlBQUwsRUFBdkI7QUFDRDs7QUFFRFMsNEJBQTBCdkQsUUFBMUIsRUFBb0N3RCxhQUFwQyxFQUFtRDtBQUNqRCxXQUFPLEtBQUs1QyxJQUFMLENBQVVDLE1BQVYsQ0FBaUIwQyx5QkFBakIsQ0FBMkN2RCxRQUEzQyxFQUFxRHdELGFBQXJELENBQVA7QUFDRDs7QUFHREMsb0JBQWtCekQsUUFBbEIsRUFBNEJ3RCxhQUE1QixFQUEyQztBQUN6QyxXQUFPLEtBQUs1QyxJQUFMLENBQVVDLE1BQVYsQ0FBaUI0QyxpQkFBakIsQ0FBbUN6RCxRQUFuQyxFQUE2Q3dELGFBQTdDLENBQVA7QUFDRDs7QUFHRHBJLG1CQUFpQjtBQUNmLFdBQU8sS0FBS3pCLEtBQUwsQ0FBV1ksVUFBWCxDQUFzQm1KLGlCQUF0QixFQUFQO0FBQ0Q7QUF0V21DLEMsVUFDN0I1SixLLGdCQUNGLHFCQUFXQSxLO2tCQUZHTCxnQiIsImZpbGUiOiJnaXQtdGFiLWNvbnRyb2xsZXIuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAanN4IGV0Y2guZG9tICovXG4vKiBlc2xpbnQgcmVhY3Qvbm8tdW5rbm93bi1wcm9wZXJ0eTogXCJvZmZcIiAqL1xuXG5pbXBvcnQgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCBldGNoIGZyb20gJ2V0Y2gnO1xuaW1wb3J0IHtEaXNwb3NhYmxlfSBmcm9tICdldmVudC1raXQnO1xuXG5pbXBvcnQgR2l0VGFiVmlldyBmcm9tICcuLi92aWV3cy9naXQtdGFiLXZpZXcnO1xuaW1wb3J0IE1vZGVsT2JzZXJ2ZXIgZnJvbSAnLi4vbW9kZWxzL21vZGVsLW9ic2VydmVyJztcbmltcG9ydCB7bnVsbEJyYW5jaH0gZnJvbSAnLi4vbW9kZWxzL2JyYW5jaCc7XG5pbXBvcnQge251bGxDb21taXR9IGZyb20gJy4uL21vZGVscy9jb21taXQnO1xuaW1wb3J0IHthdXRvYmluZH0gZnJvbSAnY29yZS1kZWNvcmF0b3JzJztcbmltcG9ydCB5dWJpa2lyaSBmcm9tICd5dWJpa2lyaSc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEdpdFRhYkNvbnRyb2xsZXIge1xuICBzdGF0aWMgZm9jdXMgPSB7XG4gICAgLi4uR2l0VGFiVmlldy5mb2N1cyxcbiAgfTtcblxuICBjb25zdHJ1Y3Rvcihwcm9wcykge1xuICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgICB0aGlzLnN0YWdpbmdPcGVyYXRpb25JblByb2dyZXNzID0gZmFsc2U7XG4gICAgdGhpcy5sYXN0Rm9jdXMgPSBHaXRUYWJWaWV3LmZvY3VzLlNUQUdJTkc7XG5cbiAgICB0aGlzLnJlcG9zaXRvcnlPYnNlcnZlciA9IG5ldyBNb2RlbE9ic2VydmVyKHtcbiAgICAgIGZldGNoRGF0YTogdGhpcy5mZXRjaFJlcG9zaXRvcnlEYXRhLFxuICAgICAgZGlkVXBkYXRlOiAoKSA9PiB7XG4gICAgICAgIHRoaXMucmVmcmVzaFJlc29sdXRpb25Qcm9ncmVzcyhmYWxzZSwgZmFsc2UpO1xuICAgICAgICByZXR1cm4gdGhpcy51cGRhdGUoKTtcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgdGhpcy5yZXBvc2l0b3J5T2JzZXJ2ZXIuc2V0QWN0aXZlTW9kZWwocHJvcHMucmVwb3NpdG9yeSk7XG4gICAgZXRjaC5pbml0aWFsaXplKHRoaXMpO1xuXG4gICAgdGhpcy5lbGVtZW50LmFkZEV2ZW50TGlzdGVuZXIoJ2ZvY3VzaW4nLCB0aGlzLnJlbWVtYmVyTGFzdEZvY3VzKTtcbiAgICB0aGlzLnN1YnNjcmlwdGlvbnMgPSBuZXcgRGlzcG9zYWJsZSgoKSA9PiB0aGlzLmVsZW1lbnQucmVtb3ZlRXZlbnRMaXN0ZW5lcignZm9jdXNpbicsIHRoaXMucmVtZW1iZXJMYXN0Rm9jdXMpKTtcbiAgfVxuXG4gIHNlcmlhbGl6ZSgpIHtcbiAgICByZXR1cm4ge1xuICAgICAgZGVzZXJpYWxpemVyOiAnR2l0VGFiQ29udHJvbGxlclN0dWInLFxuICAgIH07XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgY29uc3QgbW9kZWxEYXRhID0gdGhpcy5yZXBvc2l0b3J5T2JzZXJ2ZXIuZ2V0QWN0aXZlTW9kZWxEYXRhKCkgfHwgdGhpcy5kZWZhdWx0UmVwb3NpdG9yeURhdGEoKTtcbiAgICBjb25zdCBoYXNVbmRvSGlzdG9yeSA9IHRoaXMucHJvcHMucmVwb3NpdG9yeSA/IHRoaXMuaGFzVW5kb0hpc3RvcnkoKSA6IGZhbHNlO1xuICAgIHJldHVybiAoXG4gICAgICA8R2l0VGFiVmlld1xuICAgICAgICByZWY9XCJnaXRUYWJcIlxuICAgICAgICB7Li4ubW9kZWxEYXRhfVxuICAgICAgICByZXBvc2l0b3J5PXt0aGlzLnByb3BzLnJlcG9zaXRvcnl9XG4gICAgICAgIHJlc29sdXRpb25Qcm9ncmVzcz17dGhpcy5wcm9wcy5yZXNvbHV0aW9uUHJvZ3Jlc3N9XG4gICAgICAgIHdvcmtzcGFjZT17dGhpcy5wcm9wcy53b3Jrc3BhY2V9XG4gICAgICAgIGNvbW1hbmRSZWdpc3RyeT17dGhpcy5wcm9wcy5jb21tYW5kUmVnaXN0cnl9XG4gICAgICAgIG5vdGlmaWNhdGlvbk1hbmFnZXI9e3RoaXMucHJvcHMubm90aWZpY2F0aW9uTWFuYWdlcn1cbiAgICAgICAgaW5pdGlhbGl6ZVJlcG89e3RoaXMucHJvcHMuaW5pdGlhbGl6ZVJlcG99XG4gICAgICAgIGRpZFNlbGVjdEZpbGVQYXRoPXt0aGlzLnByb3BzLmRpZFNlbGVjdEZpbGVQYXRofVxuICAgICAgICBkaWREaXZlSW50b0ZpbGVQYXRoPXt0aGlzLnByb3BzLmRpZERpdmVJbnRvRmlsZVBhdGh9XG4gICAgICAgIGRpZFNlbGVjdE1lcmdlQ29uZmxpY3RGaWxlPXt0aGlzLnByb3BzLmRpZFNlbGVjdE1lcmdlQ29uZmxpY3RGaWxlfVxuICAgICAgICBkaWREaXZlSW50b01lcmdlQ29uZmxpY3RQYXRoPXt0aGlzLnByb3BzLmRpZERpdmVJbnRvTWVyZ2VDb25mbGljdFBhdGh9XG4gICAgICAgIGZvY3VzRmlsZVBhdGNoVmlldz17dGhpcy5wcm9wcy5mb2N1c0ZpbGVQYXRjaFZpZXd9XG4gICAgICAgIHN0YWdlRmlsZVBhdGNoPXt0aGlzLnN0YWdlRmlsZVBhdGNofVxuICAgICAgICB1bnN0YWdlRmlsZVBhdGNoPXt0aGlzLnVuc3RhZ2VGaWxlUGF0Y2h9XG4gICAgICAgIG9wZW5GaWxlcz17dGhpcy5wcm9wcy5vcGVuRmlsZXN9XG4gICAgICAgIGRpc2NhcmRXb3JrRGlyQ2hhbmdlc0ZvclBhdGhzPXt0aGlzLnByb3BzLmRpc2NhcmRXb3JrRGlyQ2hhbmdlc0ZvclBhdGhzfVxuICAgICAgICBhdHRlbXB0RmlsZVN0YWdlT3BlcmF0aW9uPXt0aGlzLmF0dGVtcHRGaWxlU3RhZ2VPcGVyYXRpb259XG4gICAgICAgIHByZXBhcmVUb0NvbW1pdD17dGhpcy5wcmVwYXJlVG9Db21taXR9XG4gICAgICAgIGNvbW1pdD17dGhpcy5jb21taXR9XG4gICAgICAgIHNldEFtZW5kaW5nPXt0aGlzLnNldEFtZW5kaW5nfVxuICAgICAgICBpc0FtZW5kaW5nPXt0aGlzLnByb3BzLmlzQW1lbmRpbmd9XG4gICAgICAgIGhhc1VuZG9IaXN0b3J5PXtoYXNVbmRvSGlzdG9yeX1cbiAgICAgICAgdW5kb0xhc3REaXNjYXJkPXt0aGlzLnByb3BzLnVuZG9MYXN0RGlzY2FyZH1cbiAgICAgICAgYWJvcnRNZXJnZT17dGhpcy5hYm9ydE1lcmdlfVxuICAgICAgICByZXNvbHZlQXNPdXJzPXt0aGlzLnJlc29sdmVBc091cnN9XG4gICAgICAgIHJlc29sdmVBc1RoZWlycz17dGhpcy5yZXNvbHZlQXNUaGVpcnN9XG4gICAgICAgIHB1c2g9e3RoaXMucHVzaH1cbiAgICAgICAgcHVsbD17dGhpcy5wdWxsfVxuICAgICAgICBmZXRjaD17dGhpcy5mZXRjaH1cbiAgICAgICAgY2hlY2tvdXQ9e3RoaXMuY2hlY2tvdXR9XG4gICAgICAvPlxuICAgICk7XG4gIH1cblxuICBhc3luYyB1cGRhdGUocHJvcHMpIHtcbiAgICBjb25zdCBvbGRQcm9wcyA9IHRoaXMucHJvcHM7XG4gICAgdGhpcy5wcm9wcyA9IHsuLi50aGlzLnByb3BzLCAuLi5wcm9wc307XG4gICAgaWYgKHRoaXMucHJvcHMucmVwb3NpdG9yeSAhPT0gb2xkUHJvcHMucmVwb3NpdG9yeSkge1xuICAgICAgYXdhaXQgdGhpcy5yZXBvc2l0b3J5T2JzZXJ2ZXIuc2V0QWN0aXZlTW9kZWwocHJvcHMucmVwb3NpdG9yeSk7XG4gICAgfSBlbHNlIGlmICh0aGlzLnByb3BzLmlzQW1lbmRpbmcgIT09IG9sZFByb3BzLmlzQW1lbmRpbmcpIHtcbiAgICAgIGF3YWl0IHRoaXMucmVwb3NpdG9yeU9ic2VydmVyLnJlZnJlc2hNb2RlbERhdGEodGhpcy5nZXRBY3RpdmVSZXBvc2l0b3J5KCkpO1xuICAgIH1cbiAgICByZXR1cm4gZXRjaC51cGRhdGUodGhpcyk7XG4gIH1cblxuICBkZXN0cm95KCkge1xuICAgIHRoaXMuc3Vic2NyaXB0aW9ucy5kaXNwb3NlKCk7XG4gICAgdGhpcy5yZXBvc2l0b3J5T2JzZXJ2ZXIuZGVzdHJveSgpO1xuICB9XG5cbiAgZ2V0VGl0bGUoKSB7XG4gICAgcmV0dXJuICdHaXQnO1xuICB9XG5cbiAgZ2V0SWNvbk5hbWUoKSB7XG4gICAgcmV0dXJuICdnaXQtY29tbWl0JztcbiAgfVxuXG4gIGdldERlZmF1bHRMb2NhdGlvbigpIHtcbiAgICByZXR1cm4gJ3JpZ2h0JztcbiAgfVxuXG4gIGdldFByZWZlcnJlZFdpZHRoKCkge1xuICAgIHJldHVybiA0MDA7XG4gIH1cblxuICBnZXRVUkkoKSB7XG4gICAgcmV0dXJuICdhdG9tLWdpdGh1YjovL3N0dWItdXJpL2dpdC10YWItY29udHJvbGxlcic7XG4gIH1cblxuICBnZXRXb3JraW5nRGlyZWN0b3J5KCkge1xuICAgIHJldHVybiB0aGlzLnByb3BzLnJlcG9zaXRvcnkuZ2V0V29ya2luZ0RpcmVjdG9yeVBhdGgoKTtcbiAgfVxuXG4gIGdldExhc3RNb2RlbERhdGFSZWZyZXNoUHJvbWlzZSgpIHtcbiAgICByZXR1cm4gdGhpcy5yZXBvc2l0b3J5T2JzZXJ2ZXIuZ2V0TGFzdE1vZGVsRGF0YVJlZnJlc2hQcm9taXNlKCk7XG4gIH1cblxuICBnZXRBY3RpdmVSZXBvc2l0b3J5KCkge1xuICAgIHJldHVybiB0aGlzLnJlcG9zaXRvcnlPYnNlcnZlci5nZXRBY3RpdmVNb2RlbCgpO1xuICB9XG5cbiAgcmVmcmVzaE1vZGVsRGF0YSgpIHtcbiAgICByZXR1cm4gdGhpcy5yZXBvc2l0b3J5T2JzZXJ2ZXIucmVmcmVzaE1vZGVsRGF0YSgpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGZldGNoUmVwb3NpdG9yeURhdGEocmVwb3NpdG9yeSkge1xuICAgIHJldHVybiB5dWJpa2lyaSh7XG4gICAgICBsYXN0Q29tbWl0OiByZXBvc2l0b3J5LmdldExhc3RDb21taXQoKSxcbiAgICAgIGlzTWVyZ2luZzogcmVwb3NpdG9yeS5pc01lcmdpbmcoKSxcbiAgICAgIGlzUmViYXNpbmc6IHJlcG9zaXRvcnkuaXNSZWJhc2luZygpLFxuICAgICAgY3VycmVudEJyYW5jaDogcmVwb3NpdG9yeS5nZXRDdXJyZW50QnJhbmNoKCksXG4gICAgICB1bnN0YWdlZENoYW5nZXM6IHJlcG9zaXRvcnkuZ2V0VW5zdGFnZWRDaGFuZ2VzKCksXG4gICAgICBzdGFnZWRDaGFuZ2VzOiB0aGlzLmZldGNoU3RhZ2VkQ2hhbmdlcyhyZXBvc2l0b3J5KSxcbiAgICAgIG1lcmdlQ29uZmxpY3RzOiByZXBvc2l0b3J5LmdldE1lcmdlQ29uZmxpY3RzKCksXG4gICAgICB3b3JraW5nRGlyZWN0b3J5UGF0aDogcmVwb3NpdG9yeS5nZXRXb3JraW5nRGlyZWN0b3J5UGF0aCgpLFxuICAgICAgbWVyZ2VNZXNzYWdlOiBhc3luYyBxdWVyeSA9PiB7XG4gICAgICAgIGNvbnN0IGlzTWVyZ2luZyA9IGF3YWl0IHF1ZXJ5LmlzTWVyZ2luZztcbiAgICAgICAgcmV0dXJuIGlzTWVyZ2luZyA/IHJlcG9zaXRvcnkuZ2V0TWVyZ2VNZXNzYWdlKCkgOiBudWxsO1xuICAgICAgfSxcbiAgICAgIGZldGNoSW5Qcm9ncmVzczogUHJvbWlzZS5yZXNvbHZlKGZhbHNlKSxcbiAgICB9KTtcbiAgfVxuXG4gIGRlZmF1bHRSZXBvc2l0b3J5RGF0YSgpIHtcbiAgICByZXR1cm4ge1xuICAgICAgbGFzdENvbW1pdDogbnVsbENvbW1pdCxcbiAgICAgIGlzTWVyZ2luZzogZmFsc2UsXG4gICAgICBpc1JlYmFzaW5nOiBmYWxzZSxcbiAgICAgIGN1cnJlbnRCcmFuY2g6IG51bGxCcmFuY2gsXG4gICAgICB1bnN0YWdlZENoYW5nZXM6IFtdLFxuICAgICAgc3RhZ2VkQ2hhbmdlczogW10sXG4gICAgICBtZXJnZUNvbmZsaWN0czogW10sXG4gICAgICB3b3JraW5nRGlyZWN0b3J5UGF0aDogdGhpcy5wcm9wcy5yZXBvc2l0b3J5LmdldFdvcmtpbmdEaXJlY3RvcnlQYXRoKCksXG4gICAgICBtZXJnZU1lc3NhZ2U6IG51bGwsXG4gICAgICBmZXRjaEluUHJvZ3Jlc3M6IHRydWUsXG4gICAgfTtcbiAgfVxuXG4gIGZldGNoU3RhZ2VkQ2hhbmdlcyhyZXBvc2l0b3J5KSB7XG4gICAgaWYgKHRoaXMucHJvcHMuaXNBbWVuZGluZykge1xuICAgICAgcmV0dXJuIHJlcG9zaXRvcnkuZ2V0U3RhZ2VkQ2hhbmdlc1NpbmNlUGFyZW50Q29tbWl0KCk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiByZXBvc2l0b3J5LmdldFN0YWdlZENoYW5nZXMoKTtcbiAgICB9XG4gIH1cblxuICAvKlxuICAgKiBCZWdpbiAoYnV0IGRvbid0IGF3YWl0KSBhbiBhc3luYyBjb25mbGljdC1jb3VudGluZyB0YXNrIGZvciBlYWNoIG1lcmdlIGNvbmZsaWN0IHBhdGggdGhhdCBoYXMgbm8gY29uZmxpY3RcbiAgICogbWFya2VyIGNvdW50IHlldC4gT21pdCBhbnkgcGF0aCB0aGF0J3MgYWxyZWFkeSBvcGVuIGluIGEgVGV4dEVkaXRvciBvciB0aGF0IGhhcyBhbHJlYWR5IGJlZW4gY291bnRlZC5cbiAgICpcbiAgICogaW5jbHVkZU9wZW4gLSB1cGRhdGUgbWFya2VyIGNvdW50cyBmb3IgZmlsZXMgdGhhdCBhcmUgY3VycmVudGx5IG9wZW4gaW4gVGV4dEVkaXRvcnNcbiAgICogaW5jbHVkZUNvdW50cyAtIHVwZGF0ZSBtYXJrZXIgY291bnRzIGZvciBmaWxlcyB0aGF0IGhhdmUgYmVlbiBjb3VudGVkIGJlZm9yZVxuICAgKi9cbiAgcmVmcmVzaFJlc29sdXRpb25Qcm9ncmVzcyhpbmNsdWRlT3BlbiwgaW5jbHVkZUNvdW50ZWQpIHtcbiAgICBjb25zdCBkYXRhID0gdGhpcy5yZXBvc2l0b3J5T2JzZXJ2ZXIuZ2V0QWN0aXZlTW9kZWxEYXRhKCk7XG4gICAgaWYgKCFkYXRhKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3Qgb3BlblBhdGhzID0gbmV3IFNldChcbiAgICAgIHRoaXMucHJvcHMud29ya3NwYWNlLmdldFRleHRFZGl0b3JzKCkubWFwKGVkaXRvciA9PiBlZGl0b3IuZ2V0UGF0aCgpKSxcbiAgICApO1xuICAgIGZvciAobGV0IGkgPSAwOyBpIDwgZGF0YS5tZXJnZUNvbmZsaWN0cy5sZW5ndGg7IGkrKykge1xuICAgICAgY29uc3QgY29uZmxpY3RQYXRoID0gcGF0aC5qb2luKGRhdGEud29ya2luZ0RpcmVjdG9yeVBhdGgsIGRhdGEubWVyZ2VDb25mbGljdHNbaV0uZmlsZVBhdGgpO1xuXG4gICAgICBpZiAoIWluY2x1ZGVPcGVuICYmIG9wZW5QYXRocy5oYXMoY29uZmxpY3RQYXRoKSkge1xuICAgICAgICBjb250aW51ZTtcbiAgICAgIH1cblxuICAgICAgaWYgKCFpbmNsdWRlQ291bnRlZCAmJiB0aGlzLnByb3BzLnJlc29sdXRpb25Qcm9ncmVzcy5nZXRSZW1haW5pbmcoY29uZmxpY3RQYXRoKSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgIGNvbnRpbnVlO1xuICAgICAgfVxuXG4gICAgICB0aGlzLnByb3BzLnJlZnJlc2hSZXNvbHV0aW9uUHJvZ3Jlc3MoY29uZmxpY3RQYXRoKTtcbiAgICB9XG4gIH1cblxuICB1bnN0YWdlRmlsZVBhdGNoKGZpbGVQYXRjaCkge1xuICAgIHJldHVybiB0aGlzLmdldEFjdGl2ZVJlcG9zaXRvcnkoKS5hcHBseVBhdGNoVG9JbmRleChmaWxlUGF0Y2guZ2V0VW5zdGFnZVBhdGNoKCkpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGF0dGVtcHRGaWxlU3RhZ2VPcGVyYXRpb24oZmlsZVBhdGhzLCBzdGFnZVN0YXR1cykge1xuICAgIGlmICh0aGlzLnN0YWdpbmdPcGVyYXRpb25JblByb2dyZXNzKSB7XG4gICAgICByZXR1cm4ge1xuICAgICAgICBzdGFnZU9wZXJhdGlvblByb21pc2U6IFByb21pc2UucmVzb2x2ZSgpLFxuICAgICAgICBzZWxlY3Rpb25VcGRhdGVQcm9taXNlOiBQcm9taXNlLnJlc29sdmUoKSxcbiAgICAgIH07XG4gICAgfVxuXG4gICAgdGhpcy5zdGFnaW5nT3BlcmF0aW9uSW5Qcm9ncmVzcyA9IHRydWU7XG5cbiAgICBjb25zdCBmaWxlTGlzdFVwZGF0ZVByb21pc2UgPSB0aGlzLnJlZnMuZ2l0VGFiLnJlZnMuc3RhZ2luZ1ZpZXcuZ2V0TmV4dExpc3RVcGRhdGVQcm9taXNlKCk7XG4gICAgbGV0IHN0YWdlT3BlcmF0aW9uUHJvbWlzZTtcbiAgICBpZiAoc3RhZ2VTdGF0dXMgPT09ICdzdGFnZWQnKSB7XG4gICAgICBzdGFnZU9wZXJhdGlvblByb21pc2UgPSB0aGlzLnVuc3RhZ2VGaWxlcyhmaWxlUGF0aHMpO1xuICAgIH0gZWxzZSB7XG4gICAgICBzdGFnZU9wZXJhdGlvblByb21pc2UgPSB0aGlzLnN0YWdlRmlsZXMoZmlsZVBhdGhzKTtcbiAgICB9XG4gICAgY29uc3Qgc2VsZWN0aW9uVXBkYXRlUHJvbWlzZSA9IGZpbGVMaXN0VXBkYXRlUHJvbWlzZS50aGVuKCgpID0+IHtcbiAgICAgIHRoaXMuc3RhZ2luZ09wZXJhdGlvbkluUHJvZ3Jlc3MgPSBmYWxzZTtcbiAgICB9KTtcblxuICAgIHJldHVybiB7c3RhZ2VPcGVyYXRpb25Qcm9taXNlLCBzZWxlY3Rpb25VcGRhdGVQcm9taXNlfTtcbiAgfVxuXG4gIGFzeW5jIHN0YWdlRmlsZXMoZmlsZVBhdGhzKSB7XG4gICAgY29uc3QgcGF0aHNUb0lnbm9yZSA9IFtdO1xuICAgIGNvbnN0IHJlcG9zaXRvcnkgPSB0aGlzLmdldEFjdGl2ZVJlcG9zaXRvcnkoKTtcbiAgICBmb3IgKGNvbnN0IGZpbGVQYXRoIG9mIGZpbGVQYXRocykge1xuICAgICAgaWYgKGF3YWl0IHJlcG9zaXRvcnkucGF0aEhhc01lcmdlTWFya2VycyhmaWxlUGF0aCkpIHsgLy8gZXNsaW50LWRpc2FibGUtbGluZSBuby1hd2FpdC1pbi1sb29wXG4gICAgICAgIGNvbnN0IGNob2ljZSA9IGF0b20uY29uZmlybSh7XG4gICAgICAgICAgbWVzc2FnZTogJ0ZpbGUgY29udGFpbnMgbWVyZ2UgbWFya2VyczogJyxcbiAgICAgICAgICBkZXRhaWxlZE1lc3NhZ2U6IGBEbyB5b3Ugc3RpbGwgd2FudCB0byBzdGFnZSB0aGlzIGZpbGU/XFxuJHtmaWxlUGF0aH1gLFxuICAgICAgICAgIGJ1dHRvbnM6IFsnU3RhZ2UnLCAnQ2FuY2VsJ10sXG4gICAgICAgIH0pO1xuICAgICAgICBpZiAoY2hvaWNlICE9PSAwKSB7IHBhdGhzVG9JZ25vcmUucHVzaChmaWxlUGF0aCk7IH1cbiAgICAgIH1cbiAgICB9XG4gICAgY29uc3QgcGF0aHNUb1N0YWdlID0gZmlsZVBhdGhzLmZpbHRlcihmaWxlUGF0aCA9PiAhcGF0aHNUb0lnbm9yZS5pbmNsdWRlcyhmaWxlUGF0aCkpO1xuICAgIHJldHVybiByZXBvc2l0b3J5LnN0YWdlRmlsZXMocGF0aHNUb1N0YWdlKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICB1bnN0YWdlRmlsZXMoZmlsZVBhdGhzKSB7XG4gICAgY29uc3QgcmVwb3NpdG9yeSA9IHRoaXMuZ2V0QWN0aXZlUmVwb3NpdG9yeSgpO1xuICAgIGlmICh0aGlzLnByb3BzLmlzQW1lbmRpbmcpIHtcbiAgICAgIHJldHVybiByZXBvc2l0b3J5LnN0YWdlRmlsZXNGcm9tUGFyZW50Q29tbWl0KGZpbGVQYXRocyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiByZXBvc2l0b3J5LnVuc3RhZ2VGaWxlcyhmaWxlUGF0aHMpO1xuICAgIH1cbiAgfVxuXG4gIEBhdXRvYmluZFxuICBhc3luYyBwcmVwYXJlVG9Db21taXQoKSB7XG4gICAgcmV0dXJuICFhd2FpdCB0aGlzLnByb3BzLmVuc3VyZUdpdFRhYigpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGFzeW5jIGNvbW1pdChtZXNzYWdlKSB7XG4gICAgdHJ5IHtcbiAgICAgIGF3YWl0IHRoaXMuZ2V0QWN0aXZlUmVwb3NpdG9yeSgpLmNvbW1pdChtZXNzYWdlLCB7YW1lbmQ6IHRoaXMucHJvcHMuaXNBbWVuZGluZ30pO1xuICAgICAgdGhpcy5zZXRBbWVuZGluZyhmYWxzZSk7XG4gICAgfSBjYXRjaCAoZSkge1xuICAgICAgaWYgKGUuY29kZSA9PT0gJ0VDT05GTElDVCcpIHtcbiAgICAgICAgdGhpcy5wcm9wcy5ub3RpZmljYXRpb25NYW5hZ2VyLmFkZEVycm9yKFxuICAgICAgICAgICdDYW5ub3QgY29tbWl0IHdpdGhvdXQgcmVzb2x2aW5nIGFsbCB0aGUgbWVyZ2UgY29uZmxpY3RzIGZpcnN0LicsXG4gICAgICAgICAge2Rpc21pc3NhYmxlOiB0cnVlfSxcbiAgICAgICAgKTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHRocm93IGU7XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgQGF1dG9iaW5kXG4gIHNldEFtZW5kaW5nKGlzQW1lbmRpbmcpIHtcbiAgICB0aGlzLnByb3BzLmRpZENoYW5nZUFtZW5kaW5nKGlzQW1lbmRpbmcpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGFzeW5jIGFib3J0TWVyZ2UoKSB7XG4gICAgY29uc3QgY2hvaWNlID0gYXRvbS5jb25maXJtKHtcbiAgICAgIG1lc3NhZ2U6ICdBYm9ydCBtZXJnZScsXG4gICAgICBkZXRhaWxlZE1lc3NhZ2U6ICdBcmUgeW91IHN1cmU/JyxcbiAgICAgIGJ1dHRvbnM6IFsnQWJvcnQnLCAnQ2FuY2VsJ10sXG4gICAgfSk7XG4gICAgaWYgKGNob2ljZSAhPT0gMCkgeyByZXR1cm4gbnVsbDsgfVxuXG4gICAgdHJ5IHtcbiAgICAgIGF3YWl0IHRoaXMuZ2V0QWN0aXZlUmVwb3NpdG9yeSgpLmFib3J0TWVyZ2UoKTtcbiAgICB9IGNhdGNoIChlKSB7XG4gICAgICBpZiAoZS5jb2RlID09PSAnRURJUlRZU1RBR0VEJykge1xuICAgICAgICB0aGlzLnByb3BzLm5vdGlmaWNhdGlvbk1hbmFnZXIuYWRkRXJyb3IoXG4gICAgICAgICAgYENhbm5vdCBhYm9ydCBiZWNhdXNlICR7ZS5wYXRofSBpcyBib3RoIGRpcnR5IGFuZCBzdGFnZWQuYCxcbiAgICAgICAgICB7ZGlzbWlzc2FibGU6IHRydWV9LFxuICAgICAgICApO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhyb3cgZTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIGV0Y2gudXBkYXRlKHRoaXMpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGFzeW5jIHJlc29sdmVBc091cnMocGF0aHMpIHtcbiAgICBjb25zdCBkYXRhID0gdGhpcy5yZXBvc2l0b3J5T2JzZXJ2ZXIuZ2V0QWN0aXZlTW9kZWxEYXRhKCk7XG4gICAgaWYgKCFkYXRhKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuICAgIGNvbnN0IHNpZGUgPSBkYXRhLmlzUmViYXNpbmcgPyAndGhlaXJzJyA6ICdvdXJzJztcbiAgICBhd2FpdCB0aGlzLmdldEFjdGl2ZVJlcG9zaXRvcnkoKS5jaGVja291dFNpZGUoc2lkZSwgcGF0aHMpO1xuICAgIHRoaXMucmVmcmVzaFJlc29sdXRpb25Qcm9ncmVzcyhmYWxzZSwgdHJ1ZSk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgYXN5bmMgcmVzb2x2ZUFzVGhlaXJzKHBhdGhzKSB7XG4gICAgY29uc3QgZGF0YSA9IHRoaXMucmVwb3NpdG9yeU9ic2VydmVyLmdldEFjdGl2ZU1vZGVsRGF0YSgpO1xuICAgIGlmICghZGF0YSkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cbiAgICBjb25zdCBzaWRlID0gZGF0YS5pc1JlYmFzaW5nID8gJ291cnMnIDogJ3RoZWlycyc7XG4gICAgYXdhaXQgdGhpcy5nZXRBY3RpdmVSZXBvc2l0b3J5KCkuY2hlY2tvdXRTaWRlKHNpZGUsIHBhdGhzKTtcbiAgICB0aGlzLnJlZnJlc2hSZXNvbHV0aW9uUHJvZ3Jlc3MoZmFsc2UsIHRydWUpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGNoZWNrb3V0KGJyYW5jaE5hbWUsIG9wdGlvbnMpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRBY3RpdmVSZXBvc2l0b3J5KCkuY2hlY2tvdXQoYnJhbmNoTmFtZSwgb3B0aW9ucyk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgcmVtZW1iZXJMYXN0Rm9jdXMoZXZlbnQpIHtcbiAgICB0aGlzLmxhc3RGb2N1cyA9IHRoaXMucmVmcy5naXRUYWIucmVtZW1iZXJGb2N1cyhldmVudCkgfHwgR2l0VGFiVmlldy5mb2N1cy5TVEFHSU5HO1xuICB9XG5cbiAgcmVzdG9yZUZvY3VzKCkge1xuICAgIHRoaXMucmVmcy5naXRUYWIuc2V0Rm9jdXModGhpcy5sYXN0Rm9jdXMpO1xuICB9XG5cbiAgaGFzRm9jdXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZWxlbWVudC5jb250YWlucyhkb2N1bWVudC5hY3RpdmVFbGVtZW50KTtcbiAgfVxuXG4gIHdhc0FjdGl2YXRlZCgpIHtcbiAgICBwcm9jZXNzLm5leHRUaWNrKCgpID0+IHRoaXMucmVzdG9yZUZvY3VzKCkpO1xuICB9XG5cbiAgZm9jdXNBbmRTZWxlY3RTdGFnaW5nSXRlbShmaWxlUGF0aCwgc3RhZ2luZ1N0YXR1cykge1xuICAgIHJldHVybiB0aGlzLnJlZnMuZ2l0VGFiLmZvY3VzQW5kU2VsZWN0U3RhZ2luZ0l0ZW0oZmlsZVBhdGgsIHN0YWdpbmdTdGF0dXMpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIHF1aWV0bHlTZWxlY3RJdGVtKGZpbGVQYXRoLCBzdGFnaW5nU3RhdHVzKSB7XG4gICAgcmV0dXJuIHRoaXMucmVmcy5naXRUYWIucXVpZXRseVNlbGVjdEl0ZW0oZmlsZVBhdGgsIHN0YWdpbmdTdGF0dXMpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGhhc1VuZG9IaXN0b3J5KCkge1xuICAgIHJldHVybiB0aGlzLnByb3BzLnJlcG9zaXRvcnkuaGFzRGlzY2FyZEhpc3RvcnkoKTtcbiAgfVxufVxuIl19