'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrSelectionByUrl = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _prInfoContainer = require('./pr-info-container');

var _prInfoContainer2 = _interopRequireDefault(_prInfoContainer);

var _prUrlInputBox = require('../views/pr-url-input-box');

var _prUrlInputBox2 = _interopRequireDefault(_prUrlInputBox);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let PrSelectionByUrl = exports.PrSelectionByUrl = (_temp = _class = class PrSelectionByUrl extends _react2.default.Component {

  render() {
    // TODO: render a selector if multiple PRs
    const resource = this.props.query && this.props.query.resource;
    if (!resource || resource.__typename !== 'PullRequest') {
      // return <div>PR not found</div>;
      return _react2.default.createElement(
        'div',
        { className: 'github-PrUrlInputBox-Container' },
        _react2.default.createElement(
          _prUrlInputBox2.default,
          { onSubmit: this.props.onSelectPr },
          _react2.default.createElement(
            'p',
            null,
            _react2.default.createElement(
              'span',
              { style: { display: 'block' } },
              'This branch is pinned to the pull request at this URL:'
            ),
            _react2.default.createElement('input', { value: this.props.prUrl, style: { width: '100%' }, readOnly: true }),
            _react2.default.createElement(
              'span',
              { style: { display: 'block' } },
              'but we couldn\'t find a pull request at that URL.'
            )
          ),
          _react2.default.createElement(
            'p',
            null,
            'You can manually pin another GitHub pull request to the current branch by entering its URL:'
          )
        )
      );
    }
    return _react2.default.createElement(_prInfoContainer2.default, {
      pullRequest: resource,
      pinnedByUrl: true,
      onUnpinPr: this.props.onUnpinPr
    });
  }

  setPr(prLink) {
    this.props.onSelectPr(prLink);
  }
}, _class.propTypes = {
  query: _propTypes2.default.shape({
    resource: _propTypes2.default.object
  }),
  prUrl: _propTypes2.default.string,
  onSelectPr: _propTypes2.default.func.isRequired,
  onUnpinPr: _propTypes2.default.func.isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(PrSelectionByUrl, {
  initialVariables: {
    prUrl: null
  },

  fragments: {
    query: () => function (RQL_0) {
      return {
        children: [{
          calls: [{
            kind: 'Call',
            metadata: {
              type: 'URI!'
            },
            name: 'url',
            value: {
              kind: 'CallVariable',
              callVariableName: 'prUrl'
            }
          }],
          children: [{
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isRequisite: true
            },
            type: 'String'
          }, {
            children: [].concat.apply([], [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, _reactRelay2.default.QL.__frag(RQL_0)]),
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {},
            name: 'PullRequest',
            type: 'PullRequest'
          }, {
            children: [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {
              isAbstract: true
            },
            name: 'IdFragment',
            type: 'Node'
          }],
          fieldName: 'resource',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id',
            isAbstract: true
          },
          type: 'UniformResourceLocatable'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Pr_QueryRelayQL',
        type: 'Query'
      };
    }(_prInfoContainer2.default.getFragment('pullRequest'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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