'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IssueishPaneItemView = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _issueishTimelineContainer = require('./issueish-timeline-container');

var _issueishTimelineContainer2 = _interopRequireDefault(_issueishTimelineContainer);

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _githubDotcomMarkdown = require('../views/github-dotcom-markdown');

var _githubDotcomMarkdown2 = _interopRequireDefault(_githubDotcomMarkdown);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const reactionTypeToEmoji = {
  THUMBS_UP: '👍',
  THUMBS_DOWN: '👎',
  LAUGH: '😆',
  HOORAY: '🎉',
  CONFUSED: '😕',
  HEART: '❤️'
};

const typeAndStateToIcon = {
  Issue: {
    OPEN: 'issue-opened',
    CLOSED: 'issue-closed'
  },
  PullRequest: {
    OPEN: 'git-pull-request',
    CLOSED: 'git-pull-request',
    MERGED: 'git-merge'
  }
};

let IssueishPaneItemView = exports.IssueishPaneItemView = (_temp = _class = class IssueishPaneItemView extends _react2.default.Component {

  render() {
    const repo = this.props.repository;
    const issueish = this.props.issueish;
    const icons = typeAndStateToIcon[issueish.__typename] || {};
    const icon = icons[issueish.state] || '';
    const childProps = {
      issue: issueish.__typename === 'Issue' ? issueish : null,
      pullRequest: issueish.__typename === 'PullRequest' ? issueish : null
    };
    return _react2.default.createElement(
      'div',
      { className: 'github-PrPaneItem' },
      _react2.default.createElement(
        'div',
        { className: 'github-PrPaneItem-container' },
        _react2.default.createElement(
          'div',
          { className: 'issueish-badge-and-link' },
          _react2.default.createElement(
            'span',
            { className: (0, _classnames2.default)('issueish-badge', 'badge', issueish.state.toLowerCase()) },
            _react2.default.createElement(_octicon2.default, { icon: icon }),
            issueish.state.toLowerCase()
          ),
          _react2.default.createElement(
            'span',
            { className: 'issueish-link' },
            _react2.default.createElement(
              'a',
              { href: issueish.url },
              repo.owner.login,
              '/',
              repo.name,
              '#',
              issueish.number
            )
          )
        ),
        _react2.default.createElement(
          'div',
          { className: 'issueish-avatar-and-title' },
          _react2.default.createElement(
            'a',
            { className: 'author-avatar-link', href: issueish.author.url },
            _react2.default.createElement('img', { className: 'author-avatar', src: issueish.author.avatarUrl, title: issueish.author.login })
          ),
          _react2.default.createElement(
            'h3',
            { className: 'issueish-title' },
            issueish.title
          )
        ),
        _react2.default.createElement(_githubDotcomMarkdown2.default, {
          html: issueish.bodyHTML || '<em>No description provided.</em>',
          switchToIssueish: this.props.switchToIssueish
        }),
        _react2.default.createElement(
          'div',
          { className: 'reactions' },
          issueish.reactionGroups.map(group => group.users.totalCount > 0 ? _react2.default.createElement(
            'span',
            { className: (0, _classnames2.default)('reaction-group', group.content.toLowerCase()), key: group.content },
            reactionTypeToEmoji[group.content],
            ' \xA0 ',
            group.users.totalCount
          ) : null)
        ),
        _react2.default.createElement(_issueishTimelineContainer2.default, _extends({}, childProps, { switchToIssueish: this.props.switchToIssueish }))
      )
    );
  }
}, _class.propTypes = {
  switchToIssueish: _propTypes2.default.func.isRequired,
  repository: _propTypes2.default.shape({
    name: _propTypes2.default.string.isRequired,
    owner: _propTypes2.default.shape({
      login: _propTypes2.default.string
    })
  }),
  issueish: _propTypes2.default.shape({
    title: _propTypes2.default.string,
    bodyHTML: _propTypes2.default.string,
    number: _propTypes2.default.number,
    state: _propTypes2.default.oneOf(['OPEN', 'CLOSED', 'MERGED']).isRequired,
    author: _propTypes2.default.shape({
      login: _propTypes2.default.string.isRequired,
      avatarUrl: _propTypes2.default.string.isRequired,
      url: _propTypes2.default.string.isRequired
    }).isRequired,
    reactionGroups: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      content: _propTypes2.default.string.isRequired,
      users: _propTypes2.default.shape({
        totalCount: _propTypes2.default.number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(IssueishPaneItemView, {
  fragments: {
    repository: () => function () {
      return {
        children: [{
          fieldName: 'name',
          kind: 'Field',
          metadata: {},
          type: 'String'
        }, {
          children: [{
            fieldName: 'login',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }],
          fieldName: 'owner',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id',
            isAbstract: true
          },
          type: 'RepositoryOwner'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Issueish_RepositoryRelayQL',
        type: 'Repository'
      };
    }(),

    issueish: () => function (RQL_0, RQL_1) {
      return {
        children: [{
          fieldName: '__typename',
          kind: 'Field',
          metadata: {
            isRequisite: true
          },
          type: 'String'
        }, {
          children: [].concat.apply([], [{
            fieldName: 'state',
            kind: 'Field',
            metadata: {},
            type: 'IssueState'
          }, {
            fieldName: 'number',
            kind: 'Field',
            metadata: {},
            type: 'Int'
          }, {
            fieldName: 'title',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'bodyHTML',
            kind: 'Field',
            metadata: {},
            type: 'HTML'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'avatarUrl',
              kind: 'Field',
              metadata: {},
              type: 'URI'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [{
                fieldName: 'url',
                kind: 'Field',
                metadata: {},
                type: 'URI'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'User',
              type: 'User'
            }, {
              children: [{
                fieldName: 'url',
                kind: 'Field',
                metadata: {},
                type: 'URI'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'Bot',
              type: 'Bot'
            }, {
              children: [{
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, {
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {
                isAbstract: true
              },
              name: 'IdFragment',
              type: 'Node'
            }],
            fieldName: 'author',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id',
              isAbstract: true
            },
            type: 'Actor'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, _reactRelay2.default.QL.__frag(RQL_0)]),
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {},
          name: 'Issue',
          type: 'Issue'
        }, {
          children: [].concat.apply([], [{
            fieldName: 'state',
            kind: 'Field',
            metadata: {},
            type: 'PullRequestState'
          }, {
            fieldName: 'number',
            kind: 'Field',
            metadata: {},
            type: 'Int'
          }, {
            fieldName: 'title',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'bodyHTML',
            kind: 'Field',
            metadata: {},
            type: 'HTML'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'avatarUrl',
              kind: 'Field',
              metadata: {},
              type: 'URI'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [{
                fieldName: 'url',
                kind: 'Field',
                metadata: {},
                type: 'URI'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'User',
              type: 'User'
            }, {
              children: [{
                fieldName: 'url',
                kind: 'Field',
                metadata: {},
                type: 'URI'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'Bot',
              type: 'Bot'
            }, {
              children: [{
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, {
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {
                isAbstract: true
              },
              name: 'IdFragment',
              type: 'Node'
            }],
            fieldName: 'author',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id',
              isAbstract: true
            },
            type: 'Actor'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, _reactRelay2.default.QL.__frag(RQL_1)]),
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {},
          name: 'PullRequest',
          type: 'PullRequest'
        }, {
          children: [{
            fieldName: 'url',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }, {
            children: [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {
              isAbstract: true
            },
            name: 'IdFragment',
            type: 'Node'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {
            isAbstract: true
          },
          name: 'UniformResourceLocatable',
          type: 'UniformResourceLocatable'
        }, {
          children: [{
            children: [{
              fieldName: 'content',
              kind: 'Field',
              metadata: {},
              type: 'ReactionContent'
            }, {
              children: [{
                fieldName: 'totalCount',
                kind: 'Field',
                metadata: {},
                type: 'Int'
              }],
              fieldName: 'users',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                isConnection: true
              },
              type: 'ReactingUserConnection'
            }],
            fieldName: 'reactionGroups',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isPlural: true
            },
            type: 'ReactionGroup'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {
            isAbstract: true
          },
          name: 'Reactable',
          type: 'Reactable'
        }, {
          children: [{
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {
            isAbstract: true
          },
          name: 'IdFragment',
          type: 'Node'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {
          isAbstract: true
        },
        name: 'Issueish_IssueishRelayQL',
        type: 'IssueOrPullRequest'
      };
    }(_issueishTimelineContainer2.default.getFragment('issue'), _issueishTimelineContainer2.default.getFragment('pullRequest'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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