'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _userMentionTooltipRoute = require('../routes/user-mention-tooltip-route');

var _userMentionTooltipRoute2 = _interopRequireDefault(_userMentionTooltipRoute);

var _userMentionTooltipContainer = require('../containers/user-mention-tooltip-container');

var _userMentionTooltipContainer2 = _interopRequireDefault(_userMentionTooltipContainer);

var _relayRootContainer = require('../containers/relay-root-container');

var _relayRootContainer2 = _interopRequireDefault(_relayRootContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let UserMentionTooltipItem = class UserMentionTooltipItem {
  constructor(username, relayEnvironment) {
    this.username = username.substr(1);
    this.relayEnvironment = relayEnvironment;
  }

  getElement() {
    return this.element;
  }

  get element() {
    if (!this._element) {
      const route = new _userMentionTooltipRoute2.default({ username: this.username });
      this._element = document.createElement('div');
      const rootContainer = _react2.default.createElement(_relayRootContainer2.default, {
        Component: _userMentionTooltipContainer2.default,
        route: route,
        environment: this.relayEnvironment,
        renderLoading: () => {
          return _react2.default.createElement(
            'div',
            { className: 'github-Loader' },
            _react2.default.createElement('span', { className: 'github-Spinner' })
          );
        },
        renderFailure: () => _react2.default.createElement(
          'div',
          null,
          'Could not load information'
        )
      });
      this._component = _reactDom2.default.render(rootContainer, this._element);
    }

    return this._element;
  }

  destroy() {
    if (this._element) {
      _reactDom2.default.unmountComponentAtNode(this._element);
      delete this._element;
    }
  }
};
exports.default = UserMentionTooltipItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInVzZXItbWVudGlvbi10b29sdGlwLWl0ZW0uanMiXSwibmFtZXMiOlsiVXNlck1lbnRpb25Ub29sdGlwSXRlbSIsImNvbnN0cnVjdG9yIiwidXNlcm5hbWUiLCJyZWxheUVudmlyb25tZW50Iiwic3Vic3RyIiwiZ2V0RWxlbWVudCIsImVsZW1lbnQiLCJfZWxlbWVudCIsInJvdXRlIiwiZG9jdW1lbnQiLCJjcmVhdGVFbGVtZW50Iiwicm9vdENvbnRhaW5lciIsIl9jb21wb25lbnQiLCJyZW5kZXIiLCJkZXN0cm95IiwidW5tb3VudENvbXBvbmVudEF0Tm9kZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7QUFFQTs7OztBQUNBOzs7O0FBQ0E7Ozs7OztJQUVxQkEsc0IsR0FBTixNQUFNQSxzQkFBTixDQUE2QjtBQUMxQ0MsY0FBWUMsUUFBWixFQUFzQkMsZ0JBQXRCLEVBQXdDO0FBQ3RDLFNBQUtELFFBQUwsR0FBZ0JBLFNBQVNFLE1BQVQsQ0FBZ0IsQ0FBaEIsQ0FBaEI7QUFDQSxTQUFLRCxnQkFBTCxHQUF3QkEsZ0JBQXhCO0FBQ0Q7O0FBRURFLGVBQWE7QUFDWCxXQUFPLEtBQUtDLE9BQVo7QUFDRDs7QUFFRCxNQUFJQSxPQUFKLEdBQWM7QUFDWixRQUFJLENBQUMsS0FBS0MsUUFBVixFQUFvQjtBQUNsQixZQUFNQyxRQUFRLHNDQUE0QixFQUFDTixVQUFVLEtBQUtBLFFBQWhCLEVBQTVCLENBQWQ7QUFDQSxXQUFLSyxRQUFMLEdBQWdCRSxTQUFTQyxhQUFULENBQXVCLEtBQXZCLENBQWhCO0FBQ0EsWUFBTUMsZ0JBQ0o7QUFDRSx3REFERjtBQUVFLGVBQU9ILEtBRlQ7QUFHRSxxQkFBYSxLQUFLTCxnQkFIcEI7QUFJRSx1QkFBZSxNQUFNO0FBQ25CLGlCQUNFO0FBQUE7QUFBQSxjQUFLLFdBQVUsZUFBZjtBQUNFLG9EQUFNLFdBQVUsZ0JBQWhCO0FBREYsV0FERjtBQUtELFNBVkg7QUFXRSx1QkFBZSxNQUFNO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFYdkIsUUFERjtBQWVBLFdBQUtTLFVBQUwsR0FBa0IsbUJBQVNDLE1BQVQsQ0FBZ0JGLGFBQWhCLEVBQStCLEtBQUtKLFFBQXBDLENBQWxCO0FBQ0Q7O0FBRUQsV0FBTyxLQUFLQSxRQUFaO0FBQ0Q7O0FBRURPLFlBQVU7QUFDUixRQUFJLEtBQUtQLFFBQVQsRUFBbUI7QUFDakIseUJBQVNRLHNCQUFULENBQWdDLEtBQUtSLFFBQXJDO0FBQ0EsYUFBTyxLQUFLQSxRQUFaO0FBQ0Q7QUFDRjtBQXhDeUMsQztrQkFBdkJQLHNCIiwiZmlsZSI6InVzZXItbWVudGlvbi10b29sdGlwLWl0ZW0uanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUmVhY3REb20gZnJvbSAncmVhY3QtZG9tJztcblxuaW1wb3J0IFVzZXJNZW50aW9uVG9vbHRpcFJvdXRlIGZyb20gJy4uL3JvdXRlcy91c2VyLW1lbnRpb24tdG9vbHRpcC1yb3V0ZSc7XG5pbXBvcnQgVXNlck1lbnRpb25Ub29sdGlwQ29udGFpbmVyIGZyb20gJy4uL2NvbnRhaW5lcnMvdXNlci1tZW50aW9uLXRvb2x0aXAtY29udGFpbmVyJztcbmltcG9ydCBSZWxheVJvb3RDb250YWluZXIgZnJvbSAnLi4vY29udGFpbmVycy9yZWxheS1yb290LWNvbnRhaW5lcic7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFVzZXJNZW50aW9uVG9vbHRpcEl0ZW0ge1xuICBjb25zdHJ1Y3Rvcih1c2VybmFtZSwgcmVsYXlFbnZpcm9ubWVudCkge1xuICAgIHRoaXMudXNlcm5hbWUgPSB1c2VybmFtZS5zdWJzdHIoMSk7XG4gICAgdGhpcy5yZWxheUVudmlyb25tZW50ID0gcmVsYXlFbnZpcm9ubWVudDtcbiAgfVxuXG4gIGdldEVsZW1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZWxlbWVudDtcbiAgfVxuXG4gIGdldCBlbGVtZW50KCkge1xuICAgIGlmICghdGhpcy5fZWxlbWVudCkge1xuICAgICAgY29uc3Qgcm91dGUgPSBuZXcgVXNlck1lbnRpb25Ub29sdGlwUm91dGUoe3VzZXJuYW1lOiB0aGlzLnVzZXJuYW1lfSk7XG4gICAgICB0aGlzLl9lbGVtZW50ID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2Jyk7XG4gICAgICBjb25zdCByb290Q29udGFpbmVyID0gKFxuICAgICAgICA8UmVsYXlSb290Q29udGFpbmVyXG4gICAgICAgICAgQ29tcG9uZW50PXtVc2VyTWVudGlvblRvb2x0aXBDb250YWluZXJ9XG4gICAgICAgICAgcm91dGU9e3JvdXRlfVxuICAgICAgICAgIGVudmlyb25tZW50PXt0aGlzLnJlbGF5RW52aXJvbm1lbnR9XG4gICAgICAgICAgcmVuZGVyTG9hZGluZz17KCkgPT4ge1xuICAgICAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItTG9hZGVyXCI+XG4gICAgICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLVNwaW5uZXJcIiAvPlxuICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICk7XG4gICAgICAgICAgfX1cbiAgICAgICAgICByZW5kZXJGYWlsdXJlPXsoKSA9PiA8ZGl2PkNvdWxkIG5vdCBsb2FkIGluZm9ybWF0aW9uPC9kaXY+fVxuICAgICAgICAvPlxuICAgICAgKTtcbiAgICAgIHRoaXMuX2NvbXBvbmVudCA9IFJlYWN0RG9tLnJlbmRlcihyb290Q29udGFpbmVyLCB0aGlzLl9lbGVtZW50KTtcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy5fZWxlbWVudDtcbiAgfVxuXG4gIGRlc3Ryb3koKSB7XG4gICAgaWYgKHRoaXMuX2VsZW1lbnQpIHtcbiAgICAgIFJlYWN0RG9tLnVubW91bnRDb21wb25lbnRBdE5vZGUodGhpcy5fZWxlbWVudCk7XG4gICAgICBkZWxldGUgdGhpcy5fZWxlbWVudDtcbiAgICB9XG4gIH1cbn1cbiJdfQ==