(function() {
  var DiffListView, GitDiffView, diffListView;

  GitDiffView = require('./git-diff-view');

  DiffListView = require('./diff-list-view');

  diffListView = null;

  module.exports = {
    activate: function() {
      return atom.workspace.observeTextEditors(function(editor) {
        new GitDiffView(editor);
        return atom.commands.add(atom.views.getView(editor), 'git-diff:toggle-diff-list', function() {
          if (diffListView == null) {
            diffListView = new DiffListView();
          }
          return diffListView.toggle();
        });
      });
    },
    deactivate: function() {
      if (diffListView != null) {
        diffListView.destroy();
      }
      return diffListView = null;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdC1kaWZmL2xpYi9tYWluLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUE7O0VBQUEsV0FBQSxHQUFjLE9BQUEsQ0FBUSxpQkFBUjs7RUFDZCxZQUFBLEdBQWUsT0FBQSxDQUFRLGtCQUFSOztFQUVmLFlBQUEsR0FBZTs7RUFFZixNQUFNLENBQUMsT0FBUCxHQUNFO0lBQUEsUUFBQSxFQUFVLFNBQUE7YUFDUixJQUFJLENBQUMsU0FBUyxDQUFDLGtCQUFmLENBQWtDLFNBQUMsTUFBRDtRQUM1QixJQUFBLFdBQUEsQ0FBWSxNQUFaO2VBQ0osSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFkLENBQWtCLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBWCxDQUFtQixNQUFuQixDQUFsQixFQUE4QywyQkFBOUMsRUFBMkUsU0FBQTs7WUFDekUsZUFBb0IsSUFBQSxZQUFBLENBQUE7O2lCQUNwQixZQUFZLENBQUMsTUFBYixDQUFBO1FBRnlFLENBQTNFO01BRmdDLENBQWxDO0lBRFEsQ0FBVjtJQU9BLFVBQUEsRUFBWSxTQUFBOztRQUNWLFlBQVksQ0FBRSxPQUFkLENBQUE7O2FBQ0EsWUFBQSxHQUFlO0lBRkwsQ0FQWjs7QUFORiIsInNvdXJjZXNDb250ZW50IjpbIkdpdERpZmZWaWV3ID0gcmVxdWlyZSAnLi9naXQtZGlmZi12aWV3J1xuRGlmZkxpc3RWaWV3ID0gcmVxdWlyZSAnLi9kaWZmLWxpc3QtdmlldydcblxuZGlmZkxpc3RWaWV3ID0gbnVsbFxuXG5tb2R1bGUuZXhwb3J0cyA9XG4gIGFjdGl2YXRlOiAtPlxuICAgIGF0b20ud29ya3NwYWNlLm9ic2VydmVUZXh0RWRpdG9ycyAoZWRpdG9yKSAtPlxuICAgICAgbmV3IEdpdERpZmZWaWV3KGVkaXRvcilcbiAgICAgIGF0b20uY29tbWFuZHMuYWRkIGF0b20udmlld3MuZ2V0VmlldyhlZGl0b3IpLCAnZ2l0LWRpZmY6dG9nZ2xlLWRpZmYtbGlzdCcsIC0+XG4gICAgICAgIGRpZmZMaXN0VmlldyA/PSBuZXcgRGlmZkxpc3RWaWV3KClcbiAgICAgICAgZGlmZkxpc3RWaWV3LnRvZ2dsZSgpXG5cbiAgZGVhY3RpdmF0ZTogLT5cbiAgICBkaWZmTGlzdFZpZXc/LmRlc3Ryb3koKVxuICAgIGRpZmZMaXN0VmlldyA9IG51bGxcbiJdfQ==
